import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RecipientConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#authentication_type Recipient#authentication_type}
    */
    readonly authenticationType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#comment Recipient#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#data_recipient_global_metastore_id Recipient#data_recipient_global_metastore_id}
    */
    readonly dataRecipientGlobalMetastoreId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#id Recipient#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#name Recipient#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#sharing_code Recipient#sharing_code}
    */
    readonly sharingCode?: string;
    /**
    * ip_access_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#ip_access_list Recipient#ip_access_list}
    */
    readonly ipAccessList?: RecipientIpAccessList;
    /**
    * tokens block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#tokens Recipient#tokens}
    */
    readonly tokens?: RecipientTokens[] | cdktf.IResolvable;
}
export interface RecipientIpAccessList {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#allowed_ip_addresses Recipient#allowed_ip_addresses}
    */
    readonly allowedIpAddresses: string[];
}
export declare function recipientIpAccessListToTerraform(struct?: RecipientIpAccessListOutputReference | RecipientIpAccessList): any;
export declare class RecipientIpAccessListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RecipientIpAccessList | undefined;
    set internalValue(value: RecipientIpAccessList | undefined);
    private _allowedIpAddresses?;
    get allowedIpAddresses(): string[];
    set allowedIpAddresses(value: string[]);
    get allowedIpAddressesInput(): string[] | undefined;
}
export interface RecipientTokens {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#activation_url Recipient#activation_url}
    */
    readonly activationUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#created_at Recipient#created_at}
    */
    readonly createdAt?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#created_by Recipient#created_by}
    */
    readonly createdBy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#expiration_time Recipient#expiration_time}
    */
    readonly expirationTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#id Recipient#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#updated_at Recipient#updated_at}
    */
    readonly updatedAt?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/recipient#updated_by Recipient#updated_by}
    */
    readonly updatedBy?: string;
}
export declare function recipientTokensToTerraform(struct?: RecipientTokens | cdktf.IResolvable): any;
export declare class RecipientTokensOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RecipientTokens | cdktf.IResolvable | undefined;
    set internalValue(value: RecipientTokens | cdktf.IResolvable | undefined);
    private _activationUrl?;
    get activationUrl(): string;
    set activationUrl(value: string);
    resetActivationUrl(): void;
    get activationUrlInput(): string | undefined;
    private _createdAt?;
    get createdAt(): number;
    set createdAt(value: number);
    resetCreatedAt(): void;
    get createdAtInput(): number | undefined;
    private _createdBy?;
    get createdBy(): string;
    set createdBy(value: string);
    resetCreatedBy(): void;
    get createdByInput(): string | undefined;
    private _expirationTime?;
    get expirationTime(): number;
    set expirationTime(value: number);
    resetExpirationTime(): void;
    get expirationTimeInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _updatedAt?;
    get updatedAt(): number;
    set updatedAt(value: number);
    resetUpdatedAt(): void;
    get updatedAtInput(): number | undefined;
    private _updatedBy?;
    get updatedBy(): string;
    set updatedBy(value: string);
    resetUpdatedBy(): void;
    get updatedByInput(): string | undefined;
}
export declare class RecipientTokensList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RecipientTokens[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RecipientTokensOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/recipient databricks_recipient}
*/
export declare class Recipient extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_recipient";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/recipient databricks_recipient} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RecipientConfig
    */
    constructor(scope: Construct, id: string, config: RecipientConfig);
    private _authenticationType?;
    get authenticationType(): string;
    set authenticationType(value: string);
    get authenticationTypeInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dataRecipientGlobalMetastoreId?;
    get dataRecipientGlobalMetastoreId(): string;
    set dataRecipientGlobalMetastoreId(value: string);
    resetDataRecipientGlobalMetastoreId(): void;
    get dataRecipientGlobalMetastoreIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sharingCode?;
    get sharingCode(): string;
    set sharingCode(value: string);
    resetSharingCode(): void;
    get sharingCodeInput(): string | undefined;
    private _ipAccessList;
    get ipAccessList(): RecipientIpAccessListOutputReference;
    putIpAccessList(value: RecipientIpAccessList): void;
    resetIpAccessList(): void;
    get ipAccessListInput(): RecipientIpAccessList | undefined;
    private _tokens;
    get tokens(): RecipientTokensList;
    putTokens(value: RecipientTokens[] | cdktf.IResolvable): void;
    resetTokens(): void;
    get tokensInput(): cdktf.IResolvable | RecipientTokens[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
