import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecretScopeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/secret_scope#backend_type SecretScope#backend_type}
    */
    readonly backendType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/secret_scope#id SecretScope#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/secret_scope#initial_manage_principal SecretScope#initial_manage_principal}
    */
    readonly initialManagePrincipal?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/secret_scope#name SecretScope#name}
    */
    readonly name: string;
    /**
    * keyvault_metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/secret_scope#keyvault_metadata SecretScope#keyvault_metadata}
    */
    readonly keyvaultMetadata?: SecretScopeKeyvaultMetadata;
}
export interface SecretScopeKeyvaultMetadata {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/secret_scope#dns_name SecretScope#dns_name}
    */
    readonly dnsName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/secret_scope#resource_id SecretScope#resource_id}
    */
    readonly resourceId: string;
}
export declare function secretScopeKeyvaultMetadataToTerraform(struct?: SecretScopeKeyvaultMetadataOutputReference | SecretScopeKeyvaultMetadata): any;
export declare class SecretScopeKeyvaultMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecretScopeKeyvaultMetadata | undefined;
    set internalValue(value: SecretScopeKeyvaultMetadata | undefined);
    private _dnsName?;
    get dnsName(): string;
    set dnsName(value: string);
    get dnsNameInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/secret_scope databricks_secret_scope}
*/
export declare class SecretScope extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_secret_scope";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/secret_scope databricks_secret_scope} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecretScopeConfig
    */
    constructor(scope: Construct, id: string, config: SecretScopeConfig);
    private _backendType?;
    get backendType(): string;
    set backendType(value: string);
    resetBackendType(): void;
    get backendTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialManagePrincipal?;
    get initialManagePrincipal(): string;
    set initialManagePrincipal(value: string);
    resetInitialManagePrincipal(): void;
    get initialManagePrincipalInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _keyvaultMetadata;
    get keyvaultMetadata(): SecretScopeKeyvaultMetadataOutputReference;
    putKeyvaultMetadata(value: SecretScopeKeyvaultMetadata): void;
    resetKeyvaultMetadata(): void;
    get keyvaultMetadataInput(): SecretScopeKeyvaultMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
