import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicePrincipalSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal_secret#id ServicePrincipalSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal_secret#secret ServicePrincipalSecret#secret}
    */
    readonly secret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal_secret#service_principal_id ServicePrincipalSecret#service_principal_id}
    */
    readonly servicePrincipalId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal_secret#status ServicePrincipalSecret#status}
    */
    readonly status?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/service_principal_secret databricks_service_principal_secret}
*/
export declare class ServicePrincipalSecret extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_service_principal_secret";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/service_principal_secret databricks_service_principal_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicePrincipalSecretConfig
    */
    constructor(scope: Construct, id: string, config: ServicePrincipalSecretConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    resetSecret(): void;
    get secretInput(): string | undefined;
    private _servicePrincipalId?;
    get servicePrincipalId(): string;
    set servicePrincipalId(value: string);
    get servicePrincipalIdInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
