import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#created_at Share#created_at}
    */
    readonly createdAt?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#created_by Share#created_by}
    */
    readonly createdBy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#id Share#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#name Share#name}
    */
    readonly name: string;
    /**
    * object block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#object Share#object}
    */
    readonly object?: ShareObject[] | cdktf.IResolvable;
}
export interface ShareObjectPartitionValue {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#name Share#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#op Share#op}
    */
    readonly op: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#recipient_property_key Share#recipient_property_key}
    */
    readonly recipientPropertyKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#value Share#value}
    */
    readonly value?: string;
}
export declare function shareObjectPartitionValueToTerraform(struct?: ShareObjectPartitionValue | cdktf.IResolvable): any;
export declare class ShareObjectPartitionValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ShareObjectPartitionValue | cdktf.IResolvable | undefined;
    set internalValue(value: ShareObjectPartitionValue | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _op?;
    get op(): string;
    set op(value: string);
    get opInput(): string | undefined;
    private _recipientPropertyKey?;
    get recipientPropertyKey(): string;
    set recipientPropertyKey(value: string);
    resetRecipientPropertyKey(): void;
    get recipientPropertyKeyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ShareObjectPartitionValueList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ShareObjectPartitionValue[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ShareObjectPartitionValueOutputReference;
}
export interface ShareObjectPartition {
    /**
    * value block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#value Share#value}
    */
    readonly value: ShareObjectPartitionValue[] | cdktf.IResolvable;
}
export declare function shareObjectPartitionToTerraform(struct?: ShareObjectPartition | cdktf.IResolvable): any;
export declare class ShareObjectPartitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ShareObjectPartition | cdktf.IResolvable | undefined;
    set internalValue(value: ShareObjectPartition | cdktf.IResolvable | undefined);
    private _value;
    get value(): ShareObjectPartitionValueList;
    putValue(value: ShareObjectPartitionValue[] | cdktf.IResolvable): void;
    get valueInput(): cdktf.IResolvable | ShareObjectPartitionValue[] | undefined;
}
export declare class ShareObjectPartitionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ShareObjectPartition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ShareObjectPartitionOutputReference;
}
export interface ShareObject {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#added_at Share#added_at}
    */
    readonly addedAt?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#added_by Share#added_by}
    */
    readonly addedBy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#cdf_enabled Share#cdf_enabled}
    */
    readonly cdfEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#comment Share#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#data_object_type Share#data_object_type}
    */
    readonly dataObjectType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#history_data_sharing_status Share#history_data_sharing_status}
    */
    readonly historyDataSharingStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#name Share#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#shared_as Share#shared_as}
    */
    readonly sharedAs?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#start_version Share#start_version}
    */
    readonly startVersion?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#status Share#status}
    */
    readonly status?: string;
    /**
    * partition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/share#partition Share#partition}
    */
    readonly partition?: ShareObjectPartition[] | cdktf.IResolvable;
}
export declare function shareObjectToTerraform(struct?: ShareObject | cdktf.IResolvable): any;
export declare class ShareObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ShareObject | cdktf.IResolvable | undefined;
    set internalValue(value: ShareObject | cdktf.IResolvable | undefined);
    private _addedAt?;
    get addedAt(): number;
    set addedAt(value: number);
    resetAddedAt(): void;
    get addedAtInput(): number | undefined;
    private _addedBy?;
    get addedBy(): string;
    set addedBy(value: string);
    resetAddedBy(): void;
    get addedByInput(): string | undefined;
    private _cdfEnabled?;
    get cdfEnabled(): boolean | cdktf.IResolvable;
    set cdfEnabled(value: boolean | cdktf.IResolvable);
    resetCdfEnabled(): void;
    get cdfEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dataObjectType?;
    get dataObjectType(): string;
    set dataObjectType(value: string);
    get dataObjectTypeInput(): string | undefined;
    private _historyDataSharingStatus?;
    get historyDataSharingStatus(): string;
    set historyDataSharingStatus(value: string);
    resetHistoryDataSharingStatus(): void;
    get historyDataSharingStatusInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sharedAs?;
    get sharedAs(): string;
    set sharedAs(value: string);
    resetSharedAs(): void;
    get sharedAsInput(): string | undefined;
    private _startVersion?;
    get startVersion(): number;
    set startVersion(value: number);
    resetStartVersion(): void;
    get startVersionInput(): number | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _partition;
    get partition(): ShareObjectPartitionList;
    putPartition(value: ShareObjectPartition[] | cdktf.IResolvable): void;
    resetPartition(): void;
    get partitionInput(): cdktf.IResolvable | ShareObjectPartition[] | undefined;
}
export declare class ShareObjectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ShareObject[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ShareObjectOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/share databricks_share}
*/
export declare class Share extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_share";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/share databricks_share} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ShareConfig
    */
    constructor(scope: Construct, id: string, config: ShareConfig);
    private _createdAt?;
    get createdAt(): number;
    set createdAt(value: number);
    resetCreatedAt(): void;
    get createdAtInput(): number | undefined;
    private _createdBy?;
    get createdBy(): string;
    set createdBy(value: string);
    resetCreatedBy(): void;
    get createdByInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _object;
    get object(): ShareObjectList;
    putObject(value: ShareObject[] | cdktf.IResolvable): void;
    resetObject(): void;
    get objectInput(): cdktf.IResolvable | ShareObject[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
