import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlAlertConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert#id SqlAlert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert#name SqlAlert#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert#parent SqlAlert#parent}
    */
    readonly parent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert#query_id SqlAlert#query_id}
    */
    readonly queryId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert#rearm SqlAlert#rearm}
    */
    readonly rearm?: number;
    /**
    * options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert#options SqlAlert#options}
    */
    readonly options: SqlAlertOptions;
}
export interface SqlAlertOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert#column SqlAlert#column}
    */
    readonly column: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert#custom_body SqlAlert#custom_body}
    */
    readonly customBody?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert#custom_subject SqlAlert#custom_subject}
    */
    readonly customSubject?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert#muted SqlAlert#muted}
    */
    readonly muted?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert#op SqlAlert#op}
    */
    readonly op: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert#value SqlAlert#value}
    */
    readonly value: string;
}
export declare function sqlAlertOptionsToTerraform(struct?: SqlAlertOptionsOutputReference | SqlAlertOptions): any;
export declare class SqlAlertOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlAlertOptions | undefined;
    set internalValue(value: SqlAlertOptions | undefined);
    private _column?;
    get column(): string;
    set column(value: string);
    get columnInput(): string | undefined;
    private _customBody?;
    get customBody(): string;
    set customBody(value: string);
    resetCustomBody(): void;
    get customBodyInput(): string | undefined;
    private _customSubject?;
    get customSubject(): string;
    set customSubject(value: string);
    resetCustomSubject(): void;
    get customSubjectInput(): string | undefined;
    private _muted?;
    get muted(): boolean | cdktf.IResolvable;
    set muted(value: boolean | cdktf.IResolvable);
    resetMuted(): void;
    get mutedInput(): boolean | cdktf.IResolvable | undefined;
    private _op?;
    get op(): string;
    set op(value: string);
    get opInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert databricks_sql_alert}
*/
export declare class SqlAlert extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_sql_alert";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/sql_alert databricks_sql_alert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlAlertConfig
    */
    constructor(scope: Construct, id: string, config: SqlAlertConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _queryId?;
    get queryId(): string;
    set queryId(value: string);
    get queryIdInput(): string | undefined;
    private _rearm?;
    get rearm(): number;
    set rearm(value: number);
    resetRearm(): void;
    get rearmInput(): number | undefined;
    private _options;
    get options(): SqlAlertOptionsOutputReference;
    putOptions(value: SqlAlertOptions): void;
    get optionsInput(): SqlAlertOptions | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
