import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#auto_stop_mins SqlEndpoint#auto_stop_mins}
    */
    readonly autoStopMins?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#cluster_size SqlEndpoint#cluster_size}
    */
    readonly clusterSize: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#data_source_id SqlEndpoint#data_source_id}
    */
    readonly dataSourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#enable_photon SqlEndpoint#enable_photon}
    */
    readonly enablePhoton?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#enable_serverless_compute SqlEndpoint#enable_serverless_compute}
    */
    readonly enableServerlessCompute?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#id SqlEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#instance_profile_arn SqlEndpoint#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#jdbc_url SqlEndpoint#jdbc_url}
    */
    readonly jdbcUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#max_num_clusters SqlEndpoint#max_num_clusters}
    */
    readonly maxNumClusters?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#min_num_clusters SqlEndpoint#min_num_clusters}
    */
    readonly minNumClusters?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#name SqlEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#num_clusters SqlEndpoint#num_clusters}
    */
    readonly numClusters?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#spot_instance_policy SqlEndpoint#spot_instance_policy}
    */
    readonly spotInstancePolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#state SqlEndpoint#state}
    */
    readonly state?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#warehouse_type SqlEndpoint#warehouse_type}
    */
    readonly warehouseType?: string;
    /**
    * channel block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#channel SqlEndpoint#channel}
    */
    readonly channel?: SqlEndpointChannel;
    /**
    * odbc_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#odbc_params SqlEndpoint#odbc_params}
    */
    readonly odbcParams?: SqlEndpointOdbcParams;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#tags SqlEndpoint#tags}
    */
    readonly tags?: SqlEndpointTags;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#timeouts SqlEndpoint#timeouts}
    */
    readonly timeouts?: SqlEndpointTimeouts;
}
export interface SqlEndpointChannel {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#name SqlEndpoint#name}
    */
    readonly name?: string;
}
export declare function sqlEndpointChannelToTerraform(struct?: SqlEndpointChannelOutputReference | SqlEndpointChannel): any;
export declare class SqlEndpointChannelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlEndpointChannel | undefined;
    set internalValue(value: SqlEndpointChannel | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface SqlEndpointOdbcParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#host SqlEndpoint#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#hostname SqlEndpoint#hostname}
    */
    readonly hostname?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#path SqlEndpoint#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#port SqlEndpoint#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#protocol SqlEndpoint#protocol}
    */
    readonly protocol: string;
}
export declare function sqlEndpointOdbcParamsToTerraform(struct?: SqlEndpointOdbcParamsOutputReference | SqlEndpointOdbcParams): any;
export declare class SqlEndpointOdbcParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlEndpointOdbcParams | undefined;
    set internalValue(value: SqlEndpointOdbcParams | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
}
export interface SqlEndpointTagsCustomTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#key SqlEndpoint#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#value SqlEndpoint#value}
    */
    readonly value: string;
}
export declare function sqlEndpointTagsCustomTagsToTerraform(struct?: SqlEndpointTagsCustomTags | cdktf.IResolvable): any;
export declare class SqlEndpointTagsCustomTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SqlEndpointTagsCustomTags | cdktf.IResolvable | undefined;
    set internalValue(value: SqlEndpointTagsCustomTags | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class SqlEndpointTagsCustomTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SqlEndpointTagsCustomTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SqlEndpointTagsCustomTagsOutputReference;
}
export interface SqlEndpointTags {
    /**
    * custom_tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#custom_tags SqlEndpoint#custom_tags}
    */
    readonly customTags: SqlEndpointTagsCustomTags[] | cdktf.IResolvable;
}
export declare function sqlEndpointTagsToTerraform(struct?: SqlEndpointTagsOutputReference | SqlEndpointTags): any;
export declare class SqlEndpointTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlEndpointTags | undefined;
    set internalValue(value: SqlEndpointTags | undefined);
    private _customTags;
    get customTags(): SqlEndpointTagsCustomTagsList;
    putCustomTags(value: SqlEndpointTagsCustomTags[] | cdktf.IResolvable): void;
    get customTagsInput(): cdktf.IResolvable | SqlEndpointTagsCustomTags[] | undefined;
}
export interface SqlEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint#create SqlEndpoint#create}
    */
    readonly create?: string;
}
export declare function sqlEndpointTimeoutsToTerraform(struct?: SqlEndpointTimeoutsOutputReference | SqlEndpointTimeouts | cdktf.IResolvable): any;
export declare class SqlEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SqlEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint databricks_sql_endpoint}
*/
export declare class SqlEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_sql_endpoint";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/sql_endpoint databricks_sql_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlEndpointConfig
    */
    constructor(scope: Construct, id: string, config: SqlEndpointConfig);
    private _autoStopMins?;
    get autoStopMins(): number;
    set autoStopMins(value: number);
    resetAutoStopMins(): void;
    get autoStopMinsInput(): number | undefined;
    private _clusterSize?;
    get clusterSize(): string;
    set clusterSize(value: string);
    get clusterSizeInput(): string | undefined;
    private _dataSourceId?;
    get dataSourceId(): string;
    set dataSourceId(value: string);
    resetDataSourceId(): void;
    get dataSourceIdInput(): string | undefined;
    private _enablePhoton?;
    get enablePhoton(): boolean | cdktf.IResolvable;
    set enablePhoton(value: boolean | cdktf.IResolvable);
    resetEnablePhoton(): void;
    get enablePhotonInput(): boolean | cdktf.IResolvable | undefined;
    private _enableServerlessCompute?;
    get enableServerlessCompute(): boolean | cdktf.IResolvable;
    set enableServerlessCompute(value: boolean | cdktf.IResolvable);
    resetEnableServerlessCompute(): void;
    get enableServerlessComputeInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _jdbcUrl?;
    get jdbcUrl(): string;
    set jdbcUrl(value: string);
    resetJdbcUrl(): void;
    get jdbcUrlInput(): string | undefined;
    private _maxNumClusters?;
    get maxNumClusters(): number;
    set maxNumClusters(value: number);
    resetMaxNumClusters(): void;
    get maxNumClustersInput(): number | undefined;
    private _minNumClusters?;
    get minNumClusters(): number;
    set minNumClusters(value: number);
    resetMinNumClusters(): void;
    get minNumClustersInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _numClusters?;
    get numClusters(): number;
    set numClusters(value: number);
    resetNumClusters(): void;
    get numClustersInput(): number | undefined;
    private _spotInstancePolicy?;
    get spotInstancePolicy(): string;
    set spotInstancePolicy(value: string);
    resetSpotInstancePolicy(): void;
    get spotInstancePolicyInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _warehouseType?;
    get warehouseType(): string;
    set warehouseType(value: string);
    resetWarehouseType(): void;
    get warehouseTypeInput(): string | undefined;
    private _channel;
    get channel(): SqlEndpointChannelOutputReference;
    putChannel(value: SqlEndpointChannel): void;
    resetChannel(): void;
    get channelInput(): SqlEndpointChannel | undefined;
    private _odbcParams;
    get odbcParams(): SqlEndpointOdbcParamsOutputReference;
    putOdbcParams(value: SqlEndpointOdbcParams): void;
    resetOdbcParams(): void;
    get odbcParamsInput(): SqlEndpointOdbcParams | undefined;
    private _tags;
    get tags(): SqlEndpointTagsOutputReference;
    putTags(value: SqlEndpointTags): void;
    resetTags(): void;
    get tagsInput(): SqlEndpointTags | undefined;
    private _timeouts;
    get timeouts(): SqlEndpointTimeoutsOutputReference;
    putTimeouts(value: SqlEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SqlEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
