import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlGlobalConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_global_config#data_access_config SqlGlobalConfig#data_access_config}
    */
    readonly dataAccessConfig?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_global_config#enable_serverless_compute SqlGlobalConfig#enable_serverless_compute}
    */
    readonly enableServerlessCompute?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_global_config#id SqlGlobalConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_global_config#instance_profile_arn SqlGlobalConfig#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_global_config#security_policy SqlGlobalConfig#security_policy}
    */
    readonly securityPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_global_config#sql_config_params SqlGlobalConfig#sql_config_params}
    */
    readonly sqlConfigParams?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/sql_global_config databricks_sql_global_config}
*/
export declare class SqlGlobalConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_sql_global_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/sql_global_config databricks_sql_global_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlGlobalConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: SqlGlobalConfigConfig);
    private _dataAccessConfig?;
    get dataAccessConfig(): {
        [key: string]: string;
    };
    set dataAccessConfig(value: {
        [key: string]: string;
    });
    resetDataAccessConfig(): void;
    get dataAccessConfigInput(): {
        [key: string]: string;
    } | undefined;
    private _enableServerlessCompute?;
    get enableServerlessCompute(): boolean | cdktf.IResolvable;
    set enableServerlessCompute(value: boolean | cdktf.IResolvable);
    resetEnableServerlessCompute(): void;
    get enableServerlessComputeInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _securityPolicy?;
    get securityPolicy(): string;
    set securityPolicy(value: string);
    resetSecurityPolicy(): void;
    get securityPolicyInput(): string | undefined;
    private _sqlConfigParams?;
    get sqlConfigParams(): {
        [key: string]: string;
    };
    set sqlConfigParams(value: {
        [key: string]: string;
    });
    resetSqlConfigParams(): void;
    get sqlConfigParamsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
