import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#active User#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#allow_cluster_create User#allow_cluster_create}
    */
    readonly allowClusterCreate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#allow_instance_pool_create User#allow_instance_pool_create}
    */
    readonly allowInstancePoolCreate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#databricks_sql_access User#databricks_sql_access}
    */
    readonly databricksSqlAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#display_name User#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#external_id User#external_id}
    */
    readonly externalId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#force User#force}
    */
    readonly force?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#force_delete_home_dir User#force_delete_home_dir}
    */
    readonly forceDeleteHomeDir?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#force_delete_repos User#force_delete_repos}
    */
    readonly forceDeleteRepos?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#home User#home}
    */
    readonly home?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#id User#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#repos User#repos}
    */
    readonly repos?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#user_name User#user_name}
    */
    readonly userName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/user#workspace_access User#workspace_access}
    */
    readonly workspaceAccess?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/user databricks_user}
*/
export declare class User extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/user databricks_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope: Construct, id: string, config: UserConfig);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    private _allowClusterCreate?;
    get allowClusterCreate(): boolean | cdktf.IResolvable;
    set allowClusterCreate(value: boolean | cdktf.IResolvable);
    resetAllowClusterCreate(): void;
    get allowClusterCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _allowInstancePoolCreate?;
    get allowInstancePoolCreate(): boolean | cdktf.IResolvable;
    set allowInstancePoolCreate(value: boolean | cdktf.IResolvable);
    resetAllowInstancePoolCreate(): void;
    get allowInstancePoolCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _databricksSqlAccess?;
    get databricksSqlAccess(): boolean | cdktf.IResolvable;
    set databricksSqlAccess(value: boolean | cdktf.IResolvable);
    resetDatabricksSqlAccess(): void;
    get databricksSqlAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _externalId?;
    get externalId(): string;
    set externalId(value: string);
    resetExternalId(): void;
    get externalIdInput(): string | undefined;
    private _force?;
    get force(): boolean | cdktf.IResolvable;
    set force(value: boolean | cdktf.IResolvable);
    resetForce(): void;
    get forceInput(): boolean | cdktf.IResolvable | undefined;
    private _forceDeleteHomeDir?;
    get forceDeleteHomeDir(): boolean | cdktf.IResolvable;
    set forceDeleteHomeDir(value: boolean | cdktf.IResolvable);
    resetForceDeleteHomeDir(): void;
    get forceDeleteHomeDirInput(): boolean | cdktf.IResolvable | undefined;
    private _forceDeleteRepos?;
    get forceDeleteRepos(): boolean | cdktf.IResolvable;
    set forceDeleteRepos(value: boolean | cdktf.IResolvable);
    resetForceDeleteRepos(): void;
    get forceDeleteReposInput(): boolean | cdktf.IResolvable | undefined;
    private _home?;
    get home(): string;
    set home(value: string);
    resetHome(): void;
    get homeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _repos?;
    get repos(): string;
    set repos(value: string);
    resetRepos(): void;
    get reposInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    get userNameInput(): string | undefined;
    private _workspaceAccess?;
    get workspaceAccess(): boolean | cdktf.IResolvable;
    set workspaceAccess(value: boolean | cdktf.IResolvable);
    resetWorkspaceAccess(): void;
    get workspaceAccessInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
