import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WorkspaceConfConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/workspace_conf#custom_config WorkspaceConf#custom_config}
    */
    readonly customConfig?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/workspace_conf#id WorkspaceConf#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/workspace_conf databricks_workspace_conf}
*/
export declare class WorkspaceConf extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_workspace_conf";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/workspace_conf databricks_workspace_conf} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WorkspaceConfConfig = {}
    */
    constructor(scope: Construct, id: string, config?: WorkspaceConfConfig);
    private _customConfig?;
    get customConfig(): {
        [key: string]: string;
    };
    set customConfig(value: {
        [key: string]: string;
    });
    resetCustomConfig(): void;
    get customConfigInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
