from pydantic import BaseModel, ConfigDict, Field
from maleo_soma.types.controller import OptionalMessageController


class SubscriptionConfigurationDTO(BaseModel):
    id: str = Field(..., description="Subscription's ID")
    max_messages: int = Field(10, description="Subscription's Max messages")
    ack_deadline: int = Field(10, description="Subscription's ACK deadline")


class ExtendedSubscriptionConfigurationDTO(SubscriptionConfigurationDTO):
    model_config = ConfigDict(arbitrary_types_allowed=True)

    controller: OptionalMessageController = Field(
        None, description="Optional message controller"
    )
