"""Initial migration: baseline schema with all models

Revision ID: 8c9b2ea10904
Revises:
Create Date: 2025-10-16 07:13:04.486058

"""
from alembic import op
import sqlalchemy as sa
import noiz
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '8c9b2ea10904'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('beamforming_file',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('filepath', noiz.models.custom_db_types.PathInDB(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('beamforming_peak_all_abspower',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('slowness', sa.Float(), nullable=False),
    sa.Column('slowness_x', sa.Float(), nullable=False),
    sa.Column('slowness_y', sa.Float(), nullable=False),
    sa.Column('amplitude', sa.Float(), nullable=False),
    sa.Column('azimuth', sa.Float(), nullable=False),
    sa.Column('backazimuth', sa.Float(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('beamforming_peak_all_relpower',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('slowness', sa.Float(), nullable=False),
    sa.Column('slowness_x', sa.Float(), nullable=False),
    sa.Column('slowness_y', sa.Float(), nullable=False),
    sa.Column('amplitude', sa.Float(), nullable=False),
    sa.Column('azimuth', sa.Float(), nullable=False),
    sa.Column('backazimuth', sa.Float(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('beamforming_peak_average_abspower',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('slowness', sa.Float(), nullable=False),
    sa.Column('slowness_x', sa.Float(), nullable=False),
    sa.Column('slowness_y', sa.Float(), nullable=False),
    sa.Column('amplitude', sa.Float(), nullable=False),
    sa.Column('azimuth', sa.Float(), nullable=False),
    sa.Column('backazimuth', sa.Float(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('beamforming_peak_average_relpower',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('slowness', sa.Float(), nullable=False),
    sa.Column('slowness_x', sa.Float(), nullable=False),
    sa.Column('slowness_y', sa.Float(), nullable=False),
    sa.Column('amplitude', sa.Float(), nullable=False),
    sa.Column('azimuth', sa.Float(), nullable=False),
    sa.Column('backazimuth', sa.Float(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('component_file',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('filepath', sa.UnicodeText(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('crosscorrelation_cartesian_file',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('filepath', sa.UnicodeText(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('crosscorrelation_cylindrical_file',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('filepath', sa.UnicodeText(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('datachunk_file',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('filepath', sa.UnicodeText(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('datachunk_params',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('sampling_rate', sa.Float(), nullable=False),
    sa.Column('prefiltering_low', sa.Float(), nullable=False),
    sa.Column('prefiltering_high', sa.Float(), nullable=False),
    sa.Column('prefiltering_order', sa.Integer(), nullable=False),
    sa.Column('preprocessing_taper_type', sa.UnicodeText(), nullable=False),
    sa.Column('preprocessing_taper_side', sa.UnicodeText(), nullable=False),
    sa.Column('preprocessing_taper_max_length', sa.Float(), nullable=False),
    sa.Column('preprocessing_taper_max_percentage', sa.Float(), nullable=False),
    sa.Column('remove_response', sa.Boolean(), nullable=False),
    sa.Column('datachunk_sample_threshold', sa.Float(), nullable=False),
    sa.Column('max_gap_for_merging', sa.Integer(), nullable=False),
    sa.Column('padding_method', sa.UnicodeText(), nullable=False),
    sa.Column('padding_taper_type', sa.UnicodeText(), nullable=True),
    sa.Column('padding_taper_max_length', sa.Float(), nullable=True),
    sa.Column('padding_taper_max_percentage', sa.Float(), nullable=True),
    sa.Column('response_constant_coefficient', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('device',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('network', sa.UnicodeText(), nullable=True),
    sa.Column('station', sa.UnicodeText(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('network', 'station', name='unique_device_per_station')
    )
    op.create_table('event_confirmation_file',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('filepath', noiz.models.custom_db_types.PathInDB(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('event_detection_file',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('filepath', noiz.models.custom_db_types.PathInDB(), nullable=False),
    sa.Column('pngpath', noiz.models.custom_db_types.PathInDB(), nullable=True),
    sa.Column('trgpath', noiz.models.custom_db_types.PathInDB(), nullable=True),
    sa.Column('npzpath', noiz.models.custom_db_types.PathInDB(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('ppsd_file',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('filepath', noiz.models.custom_db_types.PathInDB(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('processed_datachunk_file',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('filepath', sa.UnicodeText(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('timespan',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('starttime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('midtime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('endtime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('endtime', name='unique_endtime'),
    sa.UniqueConstraint('midtime', name='unique_midtime'),
    sa.UniqueConstraint('starttime', 'midtime', 'endtime', name='unique_times'),
    sa.UniqueConstraint('starttime', name='unique_starttime')
    )
    op.create_table('tsindex',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('network', sa.UnicodeText(), nullable=False),
    sa.Column('station', sa.UnicodeText(), nullable=False),
    sa.Column('location', sa.UnicodeText(), nullable=False),
    sa.Column('channel', sa.UnicodeText(), nullable=False),
    sa.Column('quality', sa.UnicodeText(), nullable=True),
    sa.Column('version', sa.Integer(), nullable=True),
    sa.Column('starttime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('endtime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('samplerate', sa.NUMERIC(), nullable=False),
    sa.Column('filename', sa.UnicodeText(), nullable=False),
    sa.Column('byteoffset', sa.BigInteger(), nullable=False),
    sa.Column('bytes', sa.BigInteger(), nullable=True),
    sa.Column('hash', sa.UnicodeText(), nullable=True),
    sa.Column('timeindex', postgresql.HSTORE(text_type=sa.Text()), nullable=True),
    sa.Column('timespans', postgresql.ARRAY(postgresql.NUMRANGE()), nullable=True),
    sa.Column('timerates', postgresql.ARRAY(sa.NUMERIC()), nullable=True),
    sa.Column('format', sa.UnicodeText(), nullable=True),
    sa.Column('filemodtime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('updated', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('scanned', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('component',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('network', sa.UnicodeText(), nullable=True),
    sa.Column('station', sa.UnicodeText(), nullable=True),
    sa.Column('component', sa.UnicodeText(), nullable=True),
    sa.Column('inventory_filepath', sa.UnicodeText(), nullable=True),
    sa.Column('lat', sa.Float(), nullable=True),
    sa.Column('lon', sa.Float(), nullable=True),
    sa.Column('x', sa.Float(), nullable=True),
    sa.Column('y', sa.Float(), nullable=True),
    sa.Column('zone', sa.Integer(), nullable=True),
    sa.Column('northern', sa.Boolean(), nullable=True),
    sa.Column('elevation', sa.Float(), nullable=True),
    sa.Column('device_id', sa.Integer(), nullable=True),
    sa.Column('component_file_id', sa.BigInteger(), nullable=True),
    sa.Column('start_date', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('end_date', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.ForeignKeyConstraint(['component_file_id'], ['component_file.id'], ),
    sa.ForeignKeyConstraint(['device_id'], ['device.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('network', 'station', 'component', name='unique_component_per_station')
    )
    op.create_table('event_detection_params',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('datachunk_params_id', sa.Integer(), nullable=False),
    sa.Column('detection_type', sa.UnicodeText(), nullable=False),
    sa.Column('trace_trimming_sec', sa.Float(), nullable=True),
    sa.Column('n_short_time_average', sa.Integer(), nullable=True),
    sa.Column('n_long_time_average', sa.Integer(), nullable=True),
    sa.Column('trigger_value', sa.Float(), nullable=True),
    sa.Column('detrigger_value', sa.Float(), nullable=True),
    sa.Column('peak_ground_velocity_threshold', sa.Float(), nullable=True),
    sa.Column('minimum_frequency', sa.Float(), nullable=False),
    sa.Column('maximum_frequency', sa.Float(), nullable=False),
    sa.Column('output_margin_length_sec', sa.Float(), nullable=False),
    sa.ForeignKeyConstraint(['datachunk_params_id'], ['datachunk_params.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('ppsd_params',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('datachunk_params_id', sa.Integer(), nullable=False),
    sa.Column('segment_length', sa.Float(), nullable=False),
    sa.Column('segment_overlap', sa.Float(), nullable=False),
    sa.Column('freq_min', sa.Float(), nullable=False),
    sa.Column('freq_max', sa.Float(), nullable=False),
    sa.Column('taper_type', sa.UnicodeText(), nullable=True),
    sa.Column('taper_max_percentage', sa.Float(), nullable=True),
    sa.Column('resample', sa.Boolean(), nullable=False),
    sa.Column('resampled_frequency_start', sa.Float(), nullable=True),
    sa.Column('resampled_frequency_stop', sa.Float(), nullable=True),
    sa.Column('resampled_frequency_step', sa.Float(), nullable=True),
    sa.Column('rejected_windows_quantile', sa.Float(), nullable=False),
    sa.Column('save_all_windows', sa.Boolean(), nullable=False),
    sa.Column('save_compressed', sa.Boolean(), nullable=False),
    sa.Column('sampling_rate', sa.Float(), nullable=False),
    sa.ForeignKeyConstraint(['datachunk_params_id'], ['datachunk_params.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('qcone_config',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('datachunk_params_id', sa.Integer(), nullable=True),
    sa.Column('null_policy', sa.UnicodeText(), nullable=False),
    sa.Column('strict_gps', sa.Boolean(), nullable=False),
    sa.Column('starttime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('endtime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('avg_gps_time_error_min', sa.Float(), nullable=True),
    sa.Column('avg_gps_time_error_max', sa.Float(), nullable=True),
    sa.Column('avg_gps_time_uncertainty_min', sa.Float(), nullable=True),
    sa.Column('avg_gps_time_uncertainty_max', sa.Float(), nullable=True),
    sa.Column('signal_energy_min', sa.Float(), nullable=True),
    sa.Column('signal_energy_max', sa.Float(), nullable=True),
    sa.Column('signal_min_value_min', sa.Float(), nullable=True),
    sa.Column('signal_min_value_max', sa.Float(), nullable=True),
    sa.Column('signal_max_value_min', sa.Float(), nullable=True),
    sa.Column('signal_max_value_max', sa.Float(), nullable=True),
    sa.Column('signal_mean_value_min', sa.Float(), nullable=True),
    sa.Column('signal_mean_value_max', sa.Float(), nullable=True),
    sa.Column('signal_variance_min', sa.Float(), nullable=True),
    sa.Column('signal_variance_max', sa.Float(), nullable=True),
    sa.Column('signal_skewness_min', sa.Float(), nullable=True),
    sa.Column('signal_skewness_max', sa.Float(), nullable=True),
    sa.Column('signal_kurtosis_min', sa.Float(), nullable=True),
    sa.Column('signal_kurtosis_max', sa.Float(), nullable=True),
    sa.ForeignKeyConstraint(['datachunk_params_id'], ['datachunk_params.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('averaged_soh_gps',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('timespan_id', sa.BigInteger(), nullable=False),
    sa.Column('z_component_id', sa.Integer(), nullable=True),
    sa.Column('time_error', sa.Float(), nullable=True),
    sa.Column('time_uncertainty', sa.Float(), nullable=True),
    sa.Column('device_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['device_id'], ['device.id'], ),
    sa.ForeignKeyConstraint(['timespan_id'], ['timespan.id'], ),
    sa.ForeignKeyConstraint(['z_component_id'], ['component.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('timespan_id', 'z_component_id', name='unique_tispan_per_station_in_avgsohgps')
    )
    op.create_table('beamforming_params',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('qcone_config_id', sa.Integer(), nullable=False),
    sa.Column('min_freq', sa.Float(), nullable=False),
    sa.Column('max_freq', sa.Float(), nullable=False),
    sa.Column('slowness_x_min', sa.Float(), nullable=False),
    sa.Column('slowness_x_max', sa.Float(), nullable=False),
    sa.Column('slowness_y_min', sa.Float(), nullable=False),
    sa.Column('slowness_y_max', sa.Float(), nullable=False),
    sa.Column('slowness_step', sa.Float(), nullable=False),
    sa.Column('window_length', sa.Float(), nullable=False),
    sa.Column('window_step', sa.Float(), nullable=False),
    sa.Column('perform_statistical_reject', sa.Boolean(), nullable=False),
    sa.Column('n_sigma_stat_reject', sa.Float(), nullable=False),
    sa.Column('prop_bad_freqs_stat_reject', sa.Float(), nullable=False),
    sa.Column('save_average_beamformer_abspower', sa.Boolean(), nullable=False),
    sa.Column('save_all_beamformers_abspower', sa.Boolean(), nullable=False),
    sa.Column('save_average_beamformer_relpower', sa.Boolean(), nullable=False),
    sa.Column('save_all_beamformers_relpower', sa.Boolean(), nullable=False),
    sa.Column('perform_deconvolution_all', sa.Boolean(), nullable=False),
    sa.Column('perform_deconvolution_average', sa.Boolean(), nullable=False),
    sa.Column('save_all_arf', sa.Boolean(), nullable=False),
    sa.Column('save_average_arf', sa.Boolean(), nullable=False),
    sa.Column('arf_enlarge_ratio', sa.Float(), nullable=False),
    sa.Column('smin1', sa.Float(), nullable=True),
    sa.Column('smax1', sa.Float(), nullable=True),
    sa.Column('smin2', sa.Float(), nullable=True),
    sa.Column('smax2', sa.Float(), nullable=True),
    sa.Column('thetamin1', sa.Float(), nullable=True),
    sa.Column('thetamax1', sa.Float(), nullable=True),
    sa.Column('thetamin2', sa.Float(), nullable=True),
    sa.Column('thetamax2', sa.Float(), nullable=True),
    sa.Column('sparsity_max', sa.Integer(), nullable=False),
    sa.Column('sigma_angle', sa.Float(), nullable=False),
    sa.Column('sigma_slowness_kernels_ratio_to_ds', sa.Integer(), nullable=False),
    sa.Column('rms_target_deconv', sa.Float(), nullable=False),
    sa.Column('reg_coef_deconv', sa.Float(), nullable=False),
    sa.Column('rel_rms_thresh_admissible_slowness', sa.Float(), nullable=False),
    sa.Column('rel_rms_stop_crit_increase_sparsity', sa.Float(), nullable=False),
    sa.Column('extract_peaks_average_beamformer_abspower', sa.Boolean(), nullable=False),
    sa.Column('extract_peaks_all_beamformers_abspower', sa.Boolean(), nullable=False),
    sa.Column('extract_peaks_average_beamformer_relpower', sa.Boolean(), nullable=False),
    sa.Column('extract_peaks_all_beamformers_relpower', sa.Boolean(), nullable=False),
    sa.Column('neighborhood_size', sa.Float(), nullable=False),
    sa.Column('maxima_threshold', sa.Float(), nullable=False),
    sa.Column('best_point_count', sa.Integer(), nullable=False),
    sa.Column('beam_portion_threshold', sa.Float(), nullable=False),
    sa.Column('semblance_threshold', sa.Float(), nullable=False),
    sa.Column('velocity_threshold', sa.Float(), nullable=False),
    sa.Column('prewhiten', sa.Boolean(), nullable=False),
    sa.Column('method', sa.String(), nullable=False),
    sa.Column('used_component_codes', sa.String(), nullable=False),
    sa.Column('minimum_trace_count', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['qcone_config_id'], ['qcone_config.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('componentpair_cartesian',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('component_a_id', sa.Integer(), nullable=False),
    sa.Column('component_b_id', sa.Integer(), nullable=False),
    sa.Column('component_code_pair', sa.UnicodeText(), nullable=False),
    sa.Column('autocorrelation', sa.Boolean(), nullable=False),
    sa.Column('intracorrelation', sa.Boolean(), nullable=False),
    sa.Column('azimuth', sa.Float(), nullable=False),
    sa.Column('backazimuth', sa.Float(), nullable=False),
    sa.Column('distance', sa.Float(), nullable=False),
    sa.Column('arcdistance', sa.Float(), nullable=False),
    sa.ForeignKeyConstraint(['component_a_id'], ['component.id'], ),
    sa.ForeignKeyConstraint(['component_b_id'], ['component.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('component_a_id', 'component_b_id', name='single_component_pair')
    )
    op.create_table('componentpair_cylindrical',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('component_aE_id', sa.Integer(), nullable=True),
    sa.Column('component_bE_id', sa.Integer(), nullable=True),
    sa.Column('component_aN_id', sa.Integer(), nullable=True),
    sa.Column('component_bN_id', sa.Integer(), nullable=True),
    sa.Column('component_aZ_id', sa.Integer(), nullable=True),
    sa.Column('component_bZ_id', sa.Integer(), nullable=True),
    sa.Column('component_cylindrical_code_pair', sa.UnicodeText(), nullable=False),
    sa.Column('autocorrelation', sa.Boolean(), nullable=False),
    sa.Column('intracorrelation', sa.Boolean(), nullable=False),
    sa.Column('azimuth', sa.Float(), nullable=False),
    sa.Column('backazimuth', sa.Float(), nullable=False),
    sa.Column('distance', sa.Float(), nullable=False),
    sa.Column('arcdistance', sa.Float(), nullable=False),
    sa.ForeignKeyConstraint(['component_aE_id'], ['component.id'], ),
    sa.ForeignKeyConstraint(['component_aN_id'], ['component.id'], ),
    sa.ForeignKeyConstraint(['component_aZ_id'], ['component.id'], ),
    sa.ForeignKeyConstraint(['component_bE_id'], ['component.id'], ),
    sa.ForeignKeyConstraint(['component_bN_id'], ['component.id'], ),
    sa.ForeignKeyConstraint(['component_bZ_id'], ['component.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('datachunk',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('component_id', sa.Integer(), nullable=False),
    sa.Column('datachunk_params_id', sa.Integer(), nullable=False),
    sa.Column('timespan_id', sa.BigInteger(), nullable=False),
    sa.Column('sampling_rate', sa.Float(), nullable=False),
    sa.Column('npts', sa.Integer(), nullable=False),
    sa.Column('padded_npts', sa.Integer(), nullable=True),
    sa.Column('datachunk_file_id', sa.BigInteger(), nullable=True),
    sa.Column('device_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['component_id'], ['component.id'], ),
    sa.ForeignKeyConstraint(['datachunk_file_id'], ['datachunk_file.id'], ),
    sa.ForeignKeyConstraint(['datachunk_params_id'], ['datachunk_params.id'], ),
    sa.ForeignKeyConstraint(['device_id'], ['device.id'], ),
    sa.ForeignKeyConstraint(['timespan_id'], ['timespan.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('timespan_id', 'component_id', 'datachunk_params_id', name='unique_datachunk_per_timespan_per_station_per_processing')
    )
    op.create_table('event_confirmation_params',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('datachunk_params_id', sa.Integer(), nullable=False),
    sa.Column('event_detection_params_id', sa.Integer(), nullable=False),
    sa.Column('time_lag', sa.Float(), nullable=False),
    sa.Column('vote_threshold', sa.Integer(), nullable=False),
    sa.Column('sampling_step', sa.Float(), nullable=False),
    sa.Column('vote_weight', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['datachunk_params_id'], ['datachunk_params.id'], ),
    sa.ForeignKeyConstraint(['event_detection_params_id'], ['event_detection_params.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('processed_datachunk_params',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('datachunk_params_id', sa.Integer(), nullable=False),
    sa.Column('qcone_config_id', sa.Integer(), nullable=False),
    sa.Column('filtering_low', sa.Float(), nullable=False),
    sa.Column('filtering_high', sa.Float(), nullable=False),
    sa.Column('filtering_order', sa.Integer(), nullable=False),
    sa.Column('waterlevel_ratio_to_max', sa.Float(), nullable=False),
    sa.Column('convolution_sliding_window_min_samples', sa.Integer(), nullable=False),
    sa.Column('convolution_sliding_window_max_ratio_to_fmin', sa.Float(), nullable=False),
    sa.Column('convolution_sliding_window_ratio_to_bandwidth', sa.Float(), nullable=False),
    sa.Column('quefrency_filter_lowpass_pct', sa.Float(), nullable=False),
    sa.Column('quefrency_filter_taper_min_samples', sa.Integer(), nullable=False),
    sa.Column('quefrency_filter_taper_length_ratio_to_length_cepstrum', sa.Float(), nullable=False),
    sa.Column('spectral_whitening', sa.Boolean(), nullable=False),
    sa.Column('one_bit', sa.Boolean(), nullable=False),
    sa.Column('quefrency', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['datachunk_params_id'], ['datachunk_params.id'], ),
    sa.ForeignKeyConstraint(['qcone_config_id'], ['qcone_config.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('qcone_rejected_time_periods',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('qcone_config_id', sa.Integer(), nullable=True),
    sa.Column('component_id', sa.Integer(), nullable=True),
    sa.Column('starttime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('endtime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.ForeignKeyConstraint(['component_id'], ['component.id'], ),
    sa.ForeignKeyConstraint(['qcone_config_id'], ['qcone_config.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('soh_gps',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('z_component_id', sa.Integer(), nullable=True),
    sa.Column('datetime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('time_error', sa.Float(), nullable=True),
    sa.Column('time_uncertainty', sa.Float(), nullable=True),
    sa.Column('device_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['device_id'], ['device.id'], ),
    sa.ForeignKeyConstraint(['z_component_id'], ['component.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('datetime', 'z_component_id', name='unique_timestamp_per_station_in_sohgps')
    )
    op.create_table('soh_instrument',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('z_component_id', sa.Integer(), nullable=True),
    sa.Column('datetime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('voltage', sa.Float(), nullable=True),
    sa.Column('current', sa.Float(), nullable=True),
    sa.Column('temperature', sa.Float(), nullable=True),
    sa.Column('device_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['device_id'], ['device.id'], ),
    sa.ForeignKeyConstraint(['z_component_id'], ['component.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('datetime', 'z_component_id', name='unique_timestamp_per_station_in_sohinstrument')
    )
    op.create_table('averaged_soh_gps_association_components',
    sa.Column('component_id', sa.BigInteger(), nullable=True),
    sa.Column('averaged_soh_gps_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['averaged_soh_gps_id'], ['averaged_soh_gps.id'], ),
    sa.ForeignKeyConstraint(['component_id'], ['component.id'], ),
    sa.UniqueConstraint('component_id', 'averaged_soh_gps_id'),
    info={'bind_key': None}
    )
    op.create_table('beamforming_result',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('beamforming_params_id', sa.Integer(), nullable=False),
    sa.Column('timespan_id', sa.Integer(), nullable=False),
    sa.Column('used_component_count', sa.Integer(), nullable=False),
    sa.Column('beamforming_file_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['beamforming_file_id'], ['beamforming_file.id'], ),
    sa.ForeignKeyConstraint(['beamforming_params_id'], ['beamforming_params.id'], ),
    sa.ForeignKeyConstraint(['timespan_id'], ['timespan.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('timespan_id', 'beamforming_params_id', name='unique_beam_per_config_per_timespan')
    )
    op.create_table('crosscorrelation_cartesian_params',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('processed_datachunk_params_id', sa.Integer(), nullable=False),
    sa.Column('correlation_max_lag', sa.Float(), nullable=False),
    sa.Column('sampling_rate', sa.Float(), nullable=False),
    sa.ForeignKeyConstraint(['processed_datachunk_params_id'], ['processed_datachunk_params.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('datachunk_stats',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('datachunk_id', sa.BigInteger(), nullable=False),
    sa.Column('energy', sa.Float(), nullable=True),
    sa.Column('min', sa.Float(), nullable=True),
    sa.Column('max', sa.Float(), nullable=True),
    sa.Column('mean', sa.Float(), nullable=True),
    sa.Column('variance', sa.Float(), nullable=True),
    sa.Column('skewness', sa.Float(), nullable=True),
    sa.Column('kurtosis', sa.Float(), nullable=True),
    sa.ForeignKeyConstraint(['datachunk_id'], ['datachunk.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('datachunk_id', name='unique_stats_per_datachunk')
    )
    op.create_table('event_confirmation_run',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('specific_stations_params', sa.UnicodeText(), nullable=True),
    sa.Column('event_confirmation_params_id', sa.Integer(), nullable=False),
    sa.Column('event_detection_type', sa.UnicodeText(), nullable=False),
    sa.ForeignKeyConstraint(['event_confirmation_params_id'], ['event_confirmation_params.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('event_detection_result',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('event_detection_run_id', sa.Integer(), nullable=False),
    sa.Column('event_detection_params_id', sa.Integer(), nullable=False),
    sa.Column('datachunk_id', sa.Integer(), nullable=False),
    sa.Column('timespan_id', sa.Integer(), nullable=False),
    sa.Column('detection_type', sa.UnicodeText(), nullable=False),
    sa.Column('time_start', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('time_stop', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('peak_ground_velocity', sa.Float(), nullable=False),
    sa.Column('minimum_frequency', sa.Float(), nullable=False),
    sa.Column('maximum_frequency', sa.Float(), nullable=False),
    sa.Column('event_detection_file_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['datachunk_id'], ['datachunk.id'], ),
    sa.ForeignKeyConstraint(['event_detection_file_id'], ['event_detection_file.id'], ),
    sa.ForeignKeyConstraint(['event_detection_params_id'], ['event_detection_params.id'], ),
    sa.ForeignKeyConstraint(['timespan_id'], ['timespan.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('timespan_id', 'datachunk_id', 'event_detection_params_id', 'time_start', name='unique_detection_per_timespan_per_datachunk_per_param_per_time')
    )
    op.create_table('ppsd_result',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('ppsd_params_id', sa.Integer(), nullable=False),
    sa.Column('timespan_id', sa.Integer(), nullable=False),
    sa.Column('datachunk_id', sa.Integer(), nullable=False),
    sa.Column('ppsd_file_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['datachunk_id'], ['datachunk.id'], ),
    sa.ForeignKeyConstraint(['ppsd_file_id'], ['ppsd_file.id'], ),
    sa.ForeignKeyConstraint(['ppsd_params_id'], ['ppsd_params.id'], ),
    sa.ForeignKeyConstraint(['timespan_id'], ['timespan.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('datachunk_id', 'ppsd_params_id', name='unique_ppsd_per_config_per_datachunk')
    )
    op.create_table('processeddatachunk',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('processed_datachunk_params_id', sa.Integer(), nullable=False),
    sa.Column('datachunk_id', sa.Integer(), nullable=False),
    sa.Column('processed_datachunk_file_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['datachunk_id'], ['datachunk.id'], ),
    sa.ForeignKeyConstraint(['processed_datachunk_file_id'], ['processed_datachunk_file.id'], ),
    sa.ForeignKeyConstraint(['processed_datachunk_params_id'], ['processed_datachunk_params.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('datachunk_id', 'processed_datachunk_params_id', name='unique_processing_per_datachunk_per_config')
    )
    op.create_table('qcone_results',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('qcone_config_id', sa.Integer(), nullable=True),
    sa.Column('datachunk_id', sa.Integer(), nullable=True),
    sa.Column('starttime', sa.Boolean(), nullable=False),
    sa.Column('endtime', sa.Boolean(), nullable=False),
    sa.Column('accepted_time', sa.Boolean(), nullable=False),
    sa.Column('avg_gps_time_error_min', sa.Boolean(), nullable=False),
    sa.Column('avg_gps_time_error_max', sa.Boolean(), nullable=False),
    sa.Column('avg_gps_time_uncertainty_min', sa.Boolean(), nullable=False),
    sa.Column('avg_gps_time_uncertainty_max', sa.Boolean(), nullable=False),
    sa.Column('signal_energy_min', sa.Boolean(), nullable=False),
    sa.Column('signal_energy_max', sa.Boolean(), nullable=False),
    sa.Column('signal_min_value_min', sa.Boolean(), nullable=False),
    sa.Column('signal_min_value_max', sa.Boolean(), nullable=False),
    sa.Column('signal_max_value_min', sa.Boolean(), nullable=False),
    sa.Column('signal_max_value_max', sa.Boolean(), nullable=False),
    sa.Column('signal_mean_value_min', sa.Boolean(), nullable=False),
    sa.Column('signal_mean_value_max', sa.Boolean(), nullable=False),
    sa.Column('signal_variance_min', sa.Boolean(), nullable=False),
    sa.Column('signal_variance_max', sa.Boolean(), nullable=False),
    sa.Column('signal_skewness_min', sa.Boolean(), nullable=False),
    sa.Column('signal_skewness_max', sa.Boolean(), nullable=False),
    sa.Column('signal_kurtosis_min', sa.Boolean(), nullable=False),
    sa.Column('signal_kurtosis_max', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['datachunk_id'], ['datachunk.id'], ),
    sa.ForeignKeyConstraint(['qcone_config_id'], ['qcone_config.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('datachunk_id', 'qcone_config_id', name='unique_qcone_results_per_config_per_datachunk')
    )
    op.create_table('soh_gps_association',
    sa.Column('component_id', sa.BigInteger(), nullable=True),
    sa.Column('soh_gps_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['component_id'], ['component.id'], ),
    sa.ForeignKeyConstraint(['soh_gps_id'], ['soh_gps.id'], ),
    sa.UniqueConstraint('component_id', 'soh_gps_id'),
    info={'bind_key': None}
    )
    op.create_table('soh_instrument_association',
    sa.Column('component_id', sa.BigInteger(), nullable=True),
    sa.Column('soh_instrument_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['component_id'], ['component.id'], ),
    sa.ForeignKeyConstraint(['soh_instrument_id'], ['soh_instrument.id'], ),
    sa.UniqueConstraint('component_id', 'soh_instrument_id'),
    info={'bind_key': None}
    )
    op.create_table('beamforming_association_datachunks',
    sa.Column('datachunk_id', sa.BigInteger(), nullable=True),
    sa.Column('beamforming_result_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['beamforming_result_id'], ['beamforming_result.id'], ),
    sa.ForeignKeyConstraint(['datachunk_id'], ['datachunk.id'], ),
    sa.UniqueConstraint('beamforming_result_id', 'datachunk_id'),
    info={'bind_key': None}
    )
    op.create_table('beamforming_result_association_all_abspower',
    sa.Column('beamforming_peak_all_abspower_id', sa.BigInteger(), nullable=True),
    sa.Column('beamforming_result_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['beamforming_peak_all_abspower_id'], ['beamforming_peak_all_abspower.id'], ),
    sa.ForeignKeyConstraint(['beamforming_result_id'], ['beamforming_result.id'], ),
    sa.UniqueConstraint('beamforming_result_id', 'beamforming_peak_all_abspower_id'),
    info={'bind_key': None}
    )
    op.create_table('beamforming_result_association_all_relpower',
    sa.Column('beamforming_peak_all_relpower_id', sa.BigInteger(), nullable=True),
    sa.Column('beamforming_result_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['beamforming_peak_all_relpower_id'], ['beamforming_peak_all_relpower.id'], ),
    sa.ForeignKeyConstraint(['beamforming_result_id'], ['beamforming_result.id'], ),
    sa.UniqueConstraint('beamforming_result_id', 'beamforming_peak_all_relpower_id'),
    info={'bind_key': None}
    )
    op.create_table('beamforming_result_association_avg_abspower',
    sa.Column('beamforming_peak_average_abspower_id', sa.BigInteger(), nullable=True),
    sa.Column('beamforming_result_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['beamforming_peak_average_abspower_id'], ['beamforming_peak_average_abspower.id'], ),
    sa.ForeignKeyConstraint(['beamforming_result_id'], ['beamforming_result.id'], ),
    sa.UniqueConstraint('beamforming_result_id', 'beamforming_peak_average_abspower_id'),
    info={'bind_key': None}
    )
    op.create_table('beamforming_result_association_avg_relpower',
    sa.Column('beamforming_peak_average_relpower_id', sa.BigInteger(), nullable=True),
    sa.Column('beamforming_result_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['beamforming_peak_average_relpower_id'], ['beamforming_peak_average_relpower.id'], ),
    sa.ForeignKeyConstraint(['beamforming_result_id'], ['beamforming_result.id'], ),
    sa.UniqueConstraint('beamforming_result_id', 'beamforming_peak_average_relpower_id'),
    info={'bind_key': None}
    )
    op.create_table('crosscorrelation_cartesian',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('componentpair_id', sa.Integer(), nullable=False),
    sa.Column('timespan_id', sa.BigInteger(), nullable=False),
    sa.Column('crosscorrelation_cartesian_params_id', sa.Integer(), nullable=False),
    sa.Column('crosscorrelation_cartesian_file_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['componentpair_id'], ['componentpair_cartesian.id'], ),
    sa.ForeignKeyConstraint(['crosscorrelation_cartesian_file_id'], ['crosscorrelation_cartesian_file.id'], ),
    sa.ForeignKeyConstraint(['crosscorrelation_cartesian_params_id'], ['crosscorrelation_cartesian_params.id'], ),
    sa.ForeignKeyConstraint(['timespan_id'], ['timespan.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('timespan_id', 'componentpair_id', 'crosscorrelation_cartesian_params_id', name='unique_ccfn_per_timespan_per_componentpair_per_config')
    )
    op.create_table('crosscorrelation_cylindrical_params',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('crosscorrelation_cartesian_params_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['crosscorrelation_cartesian_params_id'], ['crosscorrelation_cartesian_params.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('event_confirmation_result',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('event_confirmation_params_id', sa.Integer(), nullable=False),
    sa.Column('event_confirmation_run_id', sa.Integer(), nullable=False),
    sa.Column('timespan_id', sa.Integer(), nullable=False),
    sa.Column('time_start', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('time_stop', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('peak_ground_velocity', sa.Float(), nullable=False),
    sa.Column('number_station_triggered', sa.Integer(), nullable=False),
    sa.Column('event_confirmation_file_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['event_confirmation_file_id'], ['event_confirmation_file.id'], ),
    sa.ForeignKeyConstraint(['event_confirmation_params_id'], ['event_confirmation_params.id'], ),
    sa.ForeignKeyConstraint(['event_confirmation_run_id'], ['event_confirmation_run.id'], ),
    sa.ForeignKeyConstraint(['timespan_id'], ['timespan.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('timespan_id', 'event_confirmation_params_id', 'time_start', 'time_stop', 'peak_ground_velocity', 'number_station_triggered', name='unique_confirmation_per_timespan_per_param_per_time')
    )
    op.create_table('event_confirmation_run_association_datachunk',
    sa.Column('event_confirmation_run_id', sa.BigInteger(), nullable=True),
    sa.Column('datachunk_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['datachunk_id'], ['datachunk.id'], ),
    sa.ForeignKeyConstraint(['event_confirmation_run_id'], ['event_confirmation_run.id'], ),
    sa.UniqueConstraint('event_confirmation_run_id', 'datachunk_id'),
    info={'bind_key': None}
    )
    op.create_table('qctwo_config',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('crosscorrelation_cartesian_params_id', sa.Integer(), nullable=True),
    sa.Column('null_policy', sa.UnicodeText(), nullable=False),
    sa.Column('starttime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('endtime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.ForeignKeyConstraint(['crosscorrelation_cartesian_params_id'], ['crosscorrelation_cartesian_params.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('crosscorrelation_cylindrical',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('componentpair_cylindrical_id', sa.Integer(), nullable=False),
    sa.Column('timespan_id', sa.BigInteger(), nullable=False),
    sa.Column('crosscorrelation_cartesian_1_id', sa.Integer(), nullable=True),
    sa.Column('crosscorrelation_cartesian_1_code_pair', sa.UnicodeText(), nullable=True),
    sa.Column('crosscorrelation_cartesian_2_id', sa.Integer(), nullable=True),
    sa.Column('crosscorrelation_cartesian_2_code_pair', sa.UnicodeText(), nullable=True),
    sa.Column('crosscorrelation_cartesian_3_id', sa.Integer(), nullable=True),
    sa.Column('crosscorrelation_cartesian_3_code_pair', sa.UnicodeText(), nullable=True),
    sa.Column('crosscorrelation_cartesian_4_id', sa.Integer(), nullable=True),
    sa.Column('crosscorrelation_cartesian_4_code_pair', sa.UnicodeText(), nullable=True),
    sa.Column('crosscorrelation_cylindrical_params_id', sa.Integer(), nullable=False),
    sa.Column('crosscorrelation_cylindrical_file_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['componentpair_cylindrical_id'], ['componentpair_cylindrical.id'], ),
    sa.ForeignKeyConstraint(['crosscorrelation_cartesian_1_id'], ['crosscorrelation_cartesian.id'], ),
    sa.ForeignKeyConstraint(['crosscorrelation_cartesian_2_id'], ['crosscorrelation_cartesian.id'], ),
    sa.ForeignKeyConstraint(['crosscorrelation_cartesian_3_id'], ['crosscorrelation_cartesian.id'], ),
    sa.ForeignKeyConstraint(['crosscorrelation_cartesian_4_id'], ['crosscorrelation_cartesian.id'], ),
    sa.ForeignKeyConstraint(['crosscorrelation_cylindrical_file_id'], ['crosscorrelation_cylindrical_file.id'], ),
    sa.ForeignKeyConstraint(['crosscorrelation_cylindrical_params_id'], ['crosscorrelation_cylindrical_params.id'], ),
    sa.ForeignKeyConstraint(['timespan_id'], ['timespan.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('timespan_id', 'componentpair_cylindrical_id', 'crosscorrelation_cylindrical_params_id', name='unique_ccfcylindrical_per_timespan_cylindrical_per_config')
    )
    op.create_table('event_confirmation_result_association_event_detection_result',
    sa.Column('event_confirmation_result_id', sa.BigInteger(), nullable=True),
    sa.Column('event_detection_result_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['event_confirmation_result_id'], ['event_confirmation_result.id'], ),
    sa.ForeignKeyConstraint(['event_detection_result_id'], ['event_detection_result.id'], ),
    info={'bind_key': None}
    )
    op.create_table('qctwo_rejected_time_periods',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('qctwo_config_id', sa.Integer(), nullable=True),
    sa.Column('componentpair_id', sa.Integer(), nullable=True),
    sa.Column('starttime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('endtime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.ForeignKeyConstraint(['componentpair_id'], ['componentpair_cartesian.id'], ),
    sa.ForeignKeyConstraint(['qctwo_config_id'], ['qctwo_config.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('qctwo_results',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('qctwo_config_id', sa.Integer(), nullable=True),
    sa.Column('crosscorrelation_cartesian_id', sa.Integer(), nullable=True),
    sa.Column('starttime', sa.Boolean(), nullable=False),
    sa.Column('endtime', sa.Boolean(), nullable=False),
    sa.Column('accepted_time', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['crosscorrelation_cartesian_id'], ['crosscorrelation_cartesian.id'], ),
    sa.ForeignKeyConstraint(['qctwo_config_id'], ['qctwo_config.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('crosscorrelation_cartesian_id', 'qctwo_config_id', name='unique_qctwo_results_per_config_per_ccf')
    )
    op.create_table('stacking_schema',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('crosscorrelation_cartesian_params_id', sa.Integer(), nullable=False),
    sa.Column('qctwo_config_id', sa.Integer(), nullable=False),
    sa.Column('minimum_ccf_count', sa.Integer(), nullable=False),
    sa.Column('starttime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('endtime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('stacking_length', sa.Interval(), nullable=False),
    sa.Column('stacking_overlap', sa.Interval(), nullable=False),
    sa.ForeignKeyConstraint(['crosscorrelation_cartesian_params_id'], ['crosscorrelation_cartesian_params.id'], ),
    sa.ForeignKeyConstraint(['qctwo_config_id'], ['qctwo_config.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('stacking_timespan',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('starttime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('midtime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('endtime', sa.TIMESTAMP(timezone=True), nullable=False),
    sa.Column('stacking_schema_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['stacking_schema_id'], ['stacking_schema.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('stacking_schema_id', 'endtime', name='unique_stack_endtime_per_config'),
    sa.UniqueConstraint('stacking_schema_id', 'midtime', name='unique_stack_midtime_per_config'),
    sa.UniqueConstraint('stacking_schema_id', 'starttime', 'midtime', 'endtime', name='unique_stack_times_per_config'),
    sa.UniqueConstraint('stacking_schema_id', 'starttime', name='unique_stack_starttime_per_config')
    )
    op.create_table('ccfstack',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('stacking_timespan_id', sa.BigInteger(), nullable=False),
    sa.Column('stacking_schema_id', sa.Integer(), nullable=False),
    sa.Column('componentpair_id', sa.Integer(), nullable=False),
    sa.Column('stack', postgresql.ARRAY(sa.Float()), nullable=False),
    sa.Column('no_ccfs', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['componentpair_id'], ['componentpair_cartesian.id'], ),
    sa.ForeignKeyConstraint(['stacking_schema_id'], ['stacking_schema.id'], ),
    sa.ForeignKeyConstraint(['stacking_timespan_id'], ['stacking_timespan.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('stacking_timespan_id', 'stacking_schema_id', 'componentpair_id', name='unique_stack_per_pair_per_config')
    )
    op.create_table('stacking_association',
    sa.Column('crosscorrelation_cartesian_id', sa.BigInteger(), nullable=True),
    sa.Column('ccfstack_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['ccfstack_id'], ['ccfstack.id'], ),
    sa.ForeignKeyConstraint(['crosscorrelation_cartesian_id'], ['crosscorrelation_cartesian.id'], ),
    info={'bind_key': None}
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('stacking_association')
    op.drop_table('ccfstack')
    op.drop_table('stacking_timespan')
    op.drop_table('stacking_schema')
    op.drop_table('qctwo_results')
    op.drop_table('qctwo_rejected_time_periods')
    op.drop_table('event_confirmation_result_association_event_detection_result')
    op.drop_table('crosscorrelation_cylindrical')
    op.drop_table('qctwo_config')
    op.drop_table('event_confirmation_run_association_datachunk')
    op.drop_table('event_confirmation_result')
    op.drop_table('crosscorrelation_cylindrical_params')
    op.drop_table('crosscorrelation_cartesian')
    op.drop_table('beamforming_result_association_avg_relpower')
    op.drop_table('beamforming_result_association_avg_abspower')
    op.drop_table('beamforming_result_association_all_relpower')
    op.drop_table('beamforming_result_association_all_abspower')
    op.drop_table('beamforming_association_datachunks')
    op.drop_table('soh_instrument_association')
    op.drop_table('soh_gps_association')
    op.drop_table('qcone_results')
    op.drop_table('processeddatachunk')
    op.drop_table('ppsd_result')
    op.drop_table('event_detection_result')
    op.drop_table('event_confirmation_run')
    op.drop_table('datachunk_stats')
    op.drop_table('crosscorrelation_cartesian_params')
    op.drop_table('beamforming_result')
    op.drop_table('averaged_soh_gps_association_components')
    op.drop_table('soh_instrument')
    op.drop_table('soh_gps')
    op.drop_table('qcone_rejected_time_periods')
    op.drop_table('processed_datachunk_params')
    op.drop_table('event_confirmation_params')
    op.drop_table('datachunk')
    op.drop_table('componentpair_cylindrical')
    op.drop_table('componentpair_cartesian')
    op.drop_table('beamforming_params')
    op.drop_table('averaged_soh_gps')
    op.drop_table('qcone_config')
    op.drop_table('ppsd_params')
    op.drop_table('event_detection_params')
    op.drop_table('component')
    op.drop_table('tsindex')
    op.drop_table('timespan')
    op.drop_table('processed_datachunk_file')
    op.drop_table('ppsd_file')
    op.drop_table('event_detection_file')
    op.drop_table('event_confirmation_file')
    op.drop_table('device')
    op.drop_table('datachunk_params')
    op.drop_table('datachunk_file')
    op.drop_table('crosscorrelation_cylindrical_file')
    op.drop_table('crosscorrelation_cartesian_file')
    op.drop_table('component_file')
    op.drop_table('beamforming_peak_average_relpower')
    op.drop_table('beamforming_peak_average_abspower')
    op.drop_table('beamforming_peak_all_relpower')
    op.drop_table('beamforming_peak_all_abspower')
    op.drop_table('beamforming_file')
    # ### end Alembic commands ###
