# Arthur Client

This repo houses Arthur's Python Client for direct Pythonic interaction with our REST API. The client is 
auto-generated from our OpenAPI docs, so if you want to change something here you should probably be making the edit 
either in [our API spec](https://gitlab.com/ArthurAI/arthur-api-service/-/tree/develop/documentation/subcomponents?ref_type=heads)
(if you're changing the API contents, e.g. updating a return type or adding an endpoint) or in [our client generator](https://gitlab.com/ArthurAI/python-client-generator)
(if you're changing how the code gets generated, e.g. adding support for a new encoding).

### Quickstart: Generating Locally

While the code in this repository is autogenerated, you can test how your changes elsewhere affect the generated code 
by running the generation locally. This will demonstrate what would happen in this repo _if you did make those external 
changes_, but you won't want to actually commit the changes or create an MR—let the CI/CD autogeneration take care of 
that.

1. Set API Service path (consider putting in your user profile): `export API_SERVICE_DIR=</your/absolute/path>`
2. Add [client generator](https://gitlab.com/ArthurAI/python-client-generator) to your Python path: 
  `export PYTHONPATH=</your/absolute/path/to>/python-client-generator:$PYTHONPATH`
3. Follow prerequisites (redocly install, Python requirements, etc.) in client generator README
4. Generate: `python -m clientgen $API_SERVICE_DIR/documentation/subcomponents arthur/client/rest`

### API Spec & Source of Truth

This client library is generated from the subcomponents of our OpenAPI spec, which live at 
[arthur-api-server/documention/subcomponents](https://gitlab.com/ArthurAI/arthur-api-service/-/tree/develop/documentation/subcomponents?ref_type=heads). 
Each of those files corresponds to a subpackage as described above, and gets composed onto the main ArthurClient class 
at `arthur.client.rest.client`.

#### A note about the files in arthur/client/rest

In the directory `arthur/client/rest`, you will find 2 important files: `__init__.py` and `client.py`.  While all other 
files and folders present contain _only_ generated code, these files contain both manually-created _and_ auto-generated 
code. There are 3 segments that sit between pairs of comments where the code is auto-generated. These are the comment 
pairs:

- in `__init__.py`
  - between the comments `# import subpackages` and `# end import subpackages`
- in `client.py`
  - between the comments `# import sub-clients` and `# end import sub-clients`
  - between the comments `# create client object for each client subcomponent` and `# end client object creation`

You should never edit the code in these sections directly: if you want to make changes 

need to edit any code in these sections when merging to `main`. The only time you would need to modify
these sections is if you are experimenting with the API spec and the generated client and need to quickly generate code 
locally. These sections should be changed back when merging to master

### Enhancements

- Add logging
- Add generation and publication of Sphinx docs from docstrings
