# generated by datamodel-codegen:
#   filename:  admin.yaml
#   timestamp: 2023-11-17T16:56:29+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional
from uuid import UUID

from arthur.client.rest.common.models import Page, PageSize, TotalCount, TotalPages
from pydantic import BaseModel, Field


class PermissionRequest(BaseModel):
    resource: str
    """
    The resource the request is trying to act upon
    """
    action: str
    """
    The action the request is trying to take on the resource
    """


class UsageRollups(str, Enum):
    Organization = 'organization'
    Model = 'model'


class UpdateCurrentUserRequest(BaseModel):
    old_password: Optional[str] = None
    """
    The user's old password.
    """
    new_password: Optional[str] = None
    """
    The user's new password
    """
    first_name: Optional[str] = None
    """
    The user's first name
    """
    last_name: Optional[str] = None
    """
    The user's last name
    """
    email: Optional[str] = None
    """
    The user's email
    """
    username: Optional[str] = None
    """
    The username the user will use to login
    """
    show_intro_sequence: Optional[bool] = None
    """
    Used by the Arthur dashboard to determine whether the user should be shown the intro sequence upon login
    """
    help_mode_enabled: Optional[bool] = None
    """
    Used by the Arthur dashboard to determine whether or not to show dashboard tooltips
    """


class RolesRequest(BaseModel):
    roles: Optional[List[str]] = None
    """
    A list of roles
    """
    organization_id: Optional[str] = None
    """
    The UUID of the organization
    """


class UpdateUserRequest(BaseModel):
    old_password: Optional[str] = None
    """
    The user's old password. Not required to update the password if the caller is a super admin.
    """
    new_password: Optional[str] = None
    """
    The user's new password
    """
    first_name: Optional[str] = None
    """
    The user's first name
    """
    last_name: Optional[str] = None
    """
    The user's last name
    """
    email: Optional[str] = None
    """
    The user's email
    """
    username: Optional[str] = None
    """
    The username the user will use to login
    """
    roles: Optional[List[str]] = None
    show_intro_sequence: Optional[bool] = None
    """
    Used by the Arthur dashboard to determine whether the user should be shown the intro sequence upon login
    """
    help_mode_enabled: Optional[bool] = None
    """
    Used by the Arthur dashboard to determine whether or not to show dashboard tooltips
    """


class UserContext(BaseModel):
    name: Optional[str] = None
    """
    Name of the context.
    """
    id: Optional[str] = None
    """
    UUID of the context.
    """


class UsageCategory(Enum):
    Inferences = 'inferences'
    Explanations = 'explanations'
    Organization = 'organization'
    GroundTruth = 'ground_truth'
    ReferenceData = 'reference_data'


class User(BaseModel):
    id: str
    """
    the unique id of the user
    """
    first_name: Optional[str] = None
    """
    The user's first name
    """
    last_name: Optional[str] = None
    """
    The user's last name
    """
    email: str
    """
    The user's email
    """
    username: Optional[str] = None
    """
    The username the user can use to login
    """
    roles: Optional[List[str]] = None
    """
    The user's roles in the current organization.
    """
    alert_notifications_enabled: Optional[bool] = None
    """
    Whether or not the user will receive email notifications when alerts are triggered, defaults to 'false'
    """
    show_intro_sequence: Optional[bool] = None
    """
    Used by the Arthur dashboard to determine whether or not to show the user an intro sequence upon login
    """
    help_mode_enabled: Optional[bool] = None
    """
    Used by the Arthur dashboard to determine whether or not to show dashboard tooltips
    """
    created_at: Optional[datetime] = None
    """
    UTC timestamp of when the user was created
    """


class UsageMetric(BaseModel):
    name: str = Field(..., example='record_counts')
    """
    Name of the metric. For inferences, explanations, and ground_truth this will be either bytes or record_count. For organizational metrics this will be user_count and/or model_count.
    """
    value: float


class TagResponse(BaseModel):
    id: Optional[str] = None
    """
    UUID of the tag
    """
    organization_id: Optional[str] = None
    """
    UUI of the organization
    """
    name: str
    """
    Name of the tag
    """


class LoginRequest(BaseModel):
    login: str
    """
    either an email or a username
    """
    password: str


class LoginFailureResponse(BaseModel):
    error: Optional[str] = Field(None, example='unauthorized')
    """
    Error message
    """


class LoginLockoutResponse(BaseModel):
    error: Optional[str] = Field(
        None, example='User locked out, please try again after 10 minutes'
    )
    """
    Error message
    """


class OrganizationUsage(BaseModel):
    organization_id: Optional[UUID] = Field(
        None, example='12345678-90ab-cdef-1234-567890abcdef'
    )
    """
    Unique UUID for the organization
    """
    users: Optional[int] = Field(None, example=5)
    """
    number of active users in the organization
    """
    user_invites: Optional[int] = Field(None, example=7)
    """
    number of user invitations to the organization sent out
    """
    service_accounts: Optional[int] = Field(None, example=3)
    """
    number of service accounts in the organization
    """
    shareable_states: Optional[int] = Field(None, example=5)
    """
    number of shareable states created in the organization
    """
    active_models: Optional[int] = Field(None, example=2)
    """
    number of active models in the organization
    """
    total_models: Optional[int] = Field(None, example=3)
    """
    number of total models in the organization including archived models
    """
    inference_count_monthly_total_limit: Optional[int] = Field(None, example=5259)
    """
    number of inferences sent across all models over the last 30 days in the organization
    """
    inference_bytes_monthly_total_limit: Optional[int] = Field(None, example=5554096)
    """
    amount of inference data in bytes sent across all models over the last 30 days in the organization
    """
    ground_truth_count_monthly_total_limit: Optional[int] = Field(None, example=4725)
    """
    number of ground truth data points that sent across all models over the last 30 days in the organization
    """
    ground_truth_bytes_monthly_total_limit: Optional[int] = Field(None, example=345056)
    """
    amount of ground truth data in bytes sent across all models over the last 30 days in the organization
    """
    reference_data_count_monthly_total_limit: Optional[int] = Field(None, example=11057)
    """
    number of reference data points that sent across all models over the last 30 days in the organization
    """
    reference_data_bytes_monthly_total_limit: Optional[int] = Field(
        None, example=12756989
    )
    """
    amount of reference data in bytes sent across all models over the last 30 days in the organization
    """


class InviteResponse(BaseModel):
    """
    returned if and only if return_direct_links is set to true; returns a map of emails to invite links
    """

    user_invite_links: Optional[Dict[str, Any]] = None
    """
    a mapping where each email signup is a key and its corresponding signup invite link is the value
    """


class RoleDefinitionRequest(BaseModel):
    role_name: str
    """
    The name of the role you are creating
    """
    permissions: Optional[List[PermissionRequest]] = None
    """
    A list of permissions to associate with the role.  See Arthur Docs for available permissions
    """
    inherited_role_names: Optional[List[str]] = None
    """
    A list of roles to inherit permissions from.  These can be user defined roles or Arthur default roles.  See Arthur docs for default roles
    """


class UsageData(BaseModel):
    inferences: Optional[List[UsageMetric]] = None
    explanations: Optional[List[UsageMetric]] = None
    organization: Optional[List[UsageMetric]] = None
    ground_truth: Optional[List[UsageMetric]] = None
    id: UUID = Field(..., example='19e2716a-02a0-4b52-9ff2-540c1e685be6')
    """
    When rollup = "model", this will be the model id. When rollup = "organization", this will be the organization id.
    """
    name: str = Field(..., example='Model A')
    organization_id: UUID = Field(..., example='dc355b20-9163-4619-a0b8-4bf2cd8d62d7')
    """
    In the case where rollup = "model", this will be the organization id for the model referenced by "id". In the case where rollup = "organization", this will be the same value as the "id" field.
    """


class OrganizationLimits(BaseModel):
    organization_id: Optional[UUID] = Field(
        None, example='12345678-90ab-cdef-1234-567890abcdef'
    )
    """
    Unique UUID for the organization
    """
    plan: Optional[str] = Field(None, example='enterprise')
    """
    The organization's license plan for platform usage
    """
    max_users: Optional[int] = Field(None, example=10)
    """
    maximum number of active users permitted in the organization
    """
    max_user_invites: Optional[int] = Field(None, example=20)
    """
    maximum number of user invitations permitted to be sent for the organization
    """
    max_service_accounts: Optional[int] = Field(None, example=10)
    """
    maximum number of service accounts permitted in the organization
    """
    max_shareable_states: Optional[int] = Field(None, example=500)
    """
    maximum number of shareable states that can be created in the organization
    """
    max_active_models: Optional[int] = Field(None, example=3)
    """
    maximum number of active models permitted in the organization
    """
    max_total_models: Optional[int] = Field(None, example=10)
    """
    maximum number of total models permitted in the organization (deleted models count toward this total)
    """
    max_model_attributes: Optional[int] = Field(None, example=100)
    """
    maximum number of attributes permitted on any given model in the organization
    """
    max_predicted_model_attributes: Optional[int] = Field(None, example=20)
    """
    maximum number of predicted attributes permitted on any given model in the organization
    """
    max_categories_per_attribute: Optional[int] = Field(None, example=20)
    """
    maximum number of categories any given model attribute can have in the organization
    """
    max_bias_groups: Optional[int] = Field(None, example=100)
    """
    maximum number of bias groups permitted on any given model in the organization
    """
    max_tags: Optional[int] = Field(None, example=10)
    """
    maximum number of tags any given model can have in the organization
    """
    max_alert_rules_per_model: Optional[int] = Field(None, example=500)
    """
    maximum number of alert rules that can be set across all models in the organization
    """
    max_custom_metrics: Optional[int] = Field(None, example=100)
    """
    maximum number of custom metrics permitted on any given model in the organization
    """
    inference_count_per_request_limit: Optional[int] = Field(None, example=100000)
    """
    maximum number of inferences that can be sent in a single request in the organization
    """
    inference_count_monthly_model_limit: Optional[int] = Field(None, example=500000)
    """
    maximum number of inferences that can be sent to a single model over a rolling 30 day period in the organization
    """
    inference_count_monthly_total_limit: Optional[int] = Field(None, example=500000)
    """
    maximum number of inferences that can be sent across all models over a rolling 30 day period in the organization
    """
    inference_bytes_per_request_limit: Optional[int] = Field(None, example=4294967296)
    """
    maximum byte size of inferences that can be sent in a single request in the organization
    """
    inference_bytes_monthly_model_limit: Optional[int] = Field(
        None, example=68719476736
    )
    """
    maximum byte size of inferences that can be sent to a single model over a rolling 30 day period in the organization
    """
    inference_bytes_monthly_total_limit: Optional[int] = Field(
        None, example=1099511627776
    )
    """
    maximum byte size of inferences that can be sent across all models over a rolling 30 day period in the organization
    """
    ground_truth_count_per_request_limit: Optional[int] = Field(None, example=100000)
    """
    maximum number of ground truth data points that can be sent in a single request in the organization
    """
    ground_truth_count_monthly_model_limit: Optional[int] = Field(None, example=500000)
    """
    maximum number of ground truth data points that can be sent to a single model over a rolling 30 day period in the organization
    """
    ground_truth_count_monthly_total_limit: Optional[int] = Field(None, example=500000)
    """
    maximum number of ground truth data points that can be sent across all models over a rolling 30 day period in the organization
    """
    ground_truth_bytes_per_request_limit: Optional[int] = Field(
        None, example=4294967296
    )
    """
    maximum byte size of ground truth data that can be sent in a single request in the organization
    """
    ground_truth_bytes_monthly_model_limit: Optional[int] = Field(
        None, example=68719476736
    )
    """
    maximum byte size of ground truth data that can be sent to a single model over a rolling 30 day period in the organization
    """
    ground_truth_bytes_monthly_total_limit: Optional[int] = Field(
        None, example=1099511627776
    )
    """
    maximum byte size of ground truth data that can be sent across all models over a rolling 30 day period in the organization
    """
    reference_data_count_per_request_limit: Optional[int] = Field(None, example=100000)
    """
    maximum number of reference data points that can be sent in a single request in the organization
    """
    reference_data_count_monthly_model_limit: Optional[int] = Field(
        None, example=500000
    )
    """
    maximum number of reference data points that can be sent to a single model over a rolling 30 day period in the organization
    """
    reference_data_count_monthly_total_limit: Optional[int] = Field(
        None, example=500000
    )
    """
    maximum number of reference data points that can be sent across all models over a rolling 30 day period in the organization
    """
    reference_data_bytes_per_request_limit: Optional[int] = Field(
        None, example=4294967296
    )
    """
    maximum byte size of reference data that can be sent in a single request in the organization
    """
    reference_data_bytes_monthly_model_limit: Optional[int] = Field(
        None, example=68719476736
    )
    """
    maximum byte size of reference data that can be sent to a single model over a rolling 30 day period in the organization
    """
    reference_data_bytes_monthly_total_limit: Optional[int] = Field(
        None, example=1099511627776
    )
    """
    maximum byte size of reference data that can be sent across all models over a rolling 30 day period in the organization
    """
    model_versioning_enabled: Optional[bool] = Field(None, example=False)
    """
    flag indicating whether model versioning is enabled in the organization
    """
    enrichments_enabled: Optional[bool] = Field(None, example=False)
    """
    flag indicating whether enrichments (explainability, hot-spots, etc.) are enabled in the organization
    """
    tabular_models_only: Optional[bool] = Field(None, example=True)
    """
    flag indicating whether only tabular models are permitted in the organization
    """


class AuthenticationInfo(BaseModel):
    organization_ids: List[str]
    """
    A list of organization IDs.
    """
    issuer: str
    """
    The identifier of the IDP managing this user.
    """
    external_user_id: Optional[str] = None
    """
    An identifier for an external-IdP token bearer. Populated if this user's token came from an IDP and the IDP configuration specified an oidc.CustomClaimNames that mapped UserID to a claim.
    """
    internal_user_id: Optional[str] = None
    """
    An identifier for an Arthur-internal user. Populated for Arthur-authenticated users with user tokens.
    """
    service_account_id: Optional[str] = None
    """
    An identifier for an Arthur service account. Populated for Arthur-authenticated service account tokens.
    """
    username: str
    """
    Either the Arthur username or the username specified by an external IDP. This will be set to arthur.ServiceAccountName for service account tokens.
    """
    first_name: str
    """
    The first name of the Arthur authenticated user, or the first name claim if the external IDP is configured with one.
    """
    last_name: str
    """
    The last name of the Arthur authenticated user, or the last name claim if the external IDP is configured with one.
    """
    email: str
    """
    The email of the Arthur authenticated user or the email of the external IDP user if the IDP is configured with that claim. For Arthur service accounts, this will be empty.
    """
    roles: List[str]
    """
    The list of roles that this user has. For Arthur tokens, there will always be one role in this array; however, there can be more than one for external providers.
    """


class TagUpdateRequest(BaseModel):
    name: str
    """
    New name to update tag with
    """


class NewUserRequest(BaseModel):
    first_name: Optional[str] = None
    """
    The user's first name
    """
    last_name: Optional[str] = None
    """
    The user's last name
    """
    email: str
    """
    The user's email
    """
    username: str
    """
    The username the user will use to login
    """
    password: str
    """
    The user's password
    """
    roles: List[str]
    """
    Available Standard Roles are [Administrator, Model Owner, User].
    """
    alert_notifications_enabled: Optional[bool] = None
    """
    Whether or not the user will receive email notifications when alerts are triggered, defaults to 'false'
    """


class SetCurrentOrganizationRequest(BaseModel):
    organization_id: str


class UserResponse(BaseModel):
    """
    Represents an application user, if the client is using a service token then only organization_id and roles will be populated in the object
    """

    id: Optional[str] = None
    """
    the unique id of the user
    """
    organization_id: str
    """
    The ID of the users current context
    """
    organization_name: Optional[str] = None
    """
    The name of the users current context
    """
    first_name: Optional[str] = None
    """
    The user's first name
    """
    last_name: Optional[str] = None
    """
    The user's last name
    """
    email: Optional[str] = None
    """
    The user's email
    """
    username: Optional[str] = None
    """
    The username the user can use to login
    """
    roles: List[str]
    """
    The user's roles
    """
    alert_notifications_enabled: Optional[bool] = None
    """
    Whether or not the user will receive email notifications when alerts are triggered, defaults to 'false'
    """
    show_intro_sequence: Optional[bool] = None
    """
    used by the Arthur dashboard to determine whether the user should be shown the intro sequence upon login
    """
    help_mode_enabled: Optional[bool] = None
    """
    Used by the Arthur dashboard to determine whether or not to show dashboard tooltips
    """
    plan: Optional[str] = None
    """
    string representation of what plan the org of the returned user is associated with (ie. self-service or paidSaas)
    """
    created_at: Optional[datetime] = None
    """
    UTC timestamp of when the user was created
    """
    contexts: Optional[List[UserContext]] = None
    """
    Contexts that the user has permissions in.
    """


class PaginatedUsers(BaseModel):
    data: List[User]
    """
    List of users.
    """
    page: Page
    page_size: PageSize
    total_pages: Optional[TotalPages] = None
    total_count: Optional[TotalCount] = None


class NewOrganizationRequest(BaseModel):
    name: str
    roles: Optional[List[RoleDefinitionRequest]] = None
    """
    A list of RoleDefinitionRequest objects that define the custom RBAC for this organization
    """


class PaginatedTagResponse(BaseModel):
    """
    Paginated list of tags.
    """

    data: Optional[List[TagResponse]] = None
    page: Optional[Page] = None
    page_size: Optional[PageSize] = None
    total_pages: Optional[TotalPages] = None
    total_count: Optional[TotalCount] = None


class UpdateOrganizationRequest(BaseModel):
    name: Optional[str] = None
    plan: Optional[str] = None


class InviteRequest(BaseModel):
    invite_emails: List[str]
    """
    A list of emails to invite to the organization of the inviting user
    """
    return_direct_links: Optional[bool] = Field(False, example=True)
    """
    If set to true, invite emails will not be sent; instead, the signup links will be returned directly in the api response. If set to false email invites will be sent and the response body will be null.
    """
    custom_dashboard_url: Optional[str] = Field(None, example='beta.kots.dev.arthur.ai')
    """
    Set this if you want the invite links to be prefixed with a URL different from the default
    """
    organization_id: Optional[UUID] = Field(
        None, example='b4e2c14d-85f6-405a-b184-ca9fbca2604f'
    )
    """
    Set this if and only if calling as superadmin, otherwise it will return an error; this specifies the org to invite the users to
    """


class OrgExpand(str, Enum):
    LicensePlan = 'license_plan'
    Roles = 'roles'


class Organization(BaseModel):
    id: UUID = Field(..., example='12345678-90ab-cdef-1234-567890abcdef')
    """
    Unique UUID for the organization
    """
    name: str
    bucket_name: Optional[str] = None
    bucket_url: Optional[str] = None
    plan: Optional[str] = Field(None, example='enterprise')
    """
    The organization's license plan for platform usage
    """
    created_at: Optional[Any] = None
    """
    The time in UTC that the org was created
    """
    updated_at: Optional[Any] = None
    """
    The time in UTC that the org was last updated
    """
    roles: Optional[List[RoleDefinitionRequest]] = None
    """
    A list of RoleDefinitionRequest objects that define the custom RBAC for this organization
    """


class CustomRBACRequest(BaseModel):
    roles: Optional[List[RoleDefinitionRequest]] = None
    """
    A list of RoleDefinitionRequests
    """


class PaginatedUsageResponse(BaseModel):
    data: List[UsageData]
    total_count: int
    rollup: str = Field(..., example='model')
    interval_start: datetime
    interval_end: datetime


class PaginatedOrganizations(BaseModel):
    data: List[Organization]
    """
    List of organizations.
    """
    page: Page
    page_size: PageSize
    total_pages: Optional[TotalPages] = None
    total_count: Optional[TotalCount] = None
