# generated by datamodel-codegen:
#   filename:  alerts.yaml
#   timestamp: 2023-11-17T16:56:29+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

from arthur.client.rest.common.models import (
    DataDriftRequest,
    Page,
    PageSize,
    QueryFilter,
    QueryRequest,
    TotalCount,
    TotalPages,
)
from pydantic import BaseModel, Field


class Type(str, Enum):
    Email = 'email'


class NewAlertSummaryNotificationConfiguration(BaseModel):
    """
    Tells us where and how to deliver an alert summary
    """

    type: Type
    destination: Optional[str] = None
    """
    For a notification type of "email", this will be auto-populated with the email address associated with the specified user_id. If provided, it must match the email address associated with the specified user_id.
    """
    user_id: Optional[str] = None
    """
    UUID of the user this alert summary notification configuration is associated with, if any. This field is required for notifications of type "email".
    """


class AlertPriority(str, Enum):
    Warning = 'warning'
    Critical = 'critical'


class EmailNotificationBody(BaseModel):
    model_id: UUID
    alert_timestamp: datetime
    alert_description: str
    alert_priority: AlertPriority


class AlertNotificationConfiguration(BaseModel):
    """
    Tells us where and how to deliver an alert notification
    """

    id: str = Field(..., example='418c6939-8765-40fa-b04e-11ba57b7f21c')
    """
    The unique UUID of this notification configuration
    """
    model_id: str
    """
    The UUID of the model that this alert notification config belongs to
    """
    type: Type
    destination: Optional[str] = None
    """
    For a notification type of "email", this is the email address the notification will be delivered to.
    """
    user_id: Optional[str] = None
    """
    UUID of the user this notification config is associated with, if any. This field is required for email notifications.
    """
    enabled: bool
    """
    Whether or not this notification config is enabled
    """


class MetricType(str, Enum):
    """
    The metric type/category
    """

    ModelOutputMetric = 'model_output_metric'
    ModelPerformanceMetric = 'model_performance_metric'
    ModelDataDriftMetric = 'model_data_drift_metric'
    ModelDataBoundMetric = 'model_data_bound_metric'


class LastUpdatedByType(str, Enum):
    """
    Type of user that created or last updated this alert rule. Null if the rule was auto-generated by Arthur.
    """

    ServiceAccount = 'service-account'
    ArthurManaged = 'arthur-managed'
    IDPManaged = 'idp-managed'


class AlertRulesSort(str, Enum):
    Name = 'name'
    Severity = 'severity'
    MetricID = 'metric_id'
    MetricName = 'metric_name'
    MetricType = 'metric_type'
    SubsequentAlertWaitTime = 'subsequent_alert_wait_time'
    LastUpdatedAt = 'last_updated_at'
    LastUpdatedBy = 'last_updated_by'
    Enabled = 'enabled'


class AlertCounts(BaseModel):
    """
    Alert counts for an alert rule by status. Only included if include_alert_metadata query param is set to true.
    """

    new: Optional[float] = None
    acknowledged: Optional[float] = None
    resolved: Optional[float] = None


class Bound(str, Enum):
    Upper = 'upper'
    Lower = 'lower'


class Severity(str, Enum):
    """
    Priority of the alert rule which triggered this alert.
    """

    warning = 'warning'
    critical = 'critical'


class AlertRuleRequest(BaseModel):
    name: Optional[str] = None
    """
    A name for the alert rule, a default will be generated if this is not supplied.
    """
    bound: Bound
    threshold: float
    """
    threshold of alert rule
    """
    metric_id: str
    """
    The UUID of the metric to use for this alert rule.
    """
    metric_parameters: Optional[Dict[str, Any]] = None
    """
    Parameter values to use when evaluating the metric. May only supply one value for each parameter.
    """
    filters: Optional[List[QueryFilter]] = None
    """
    Additional filter(s) to apply when evaluating the alert rule.
    """
    severity: Severity
    """
    Priority of the alert rule which triggered this alert.
    """
    lookback_period: Optional[int] = None
    """
    The lookback time or "window length" in minutes to use when calculating the alert rule metric. For example, a lookback period of 5 minutes for an alert rule on average prediction will calculate average prediction for the past 5 minutes in a rolling window format. This will default to 5 minutes
    """
    subsequent_alert_wait_time: Optional[int] = None
    """
    If metric continues to pass threshold this is the time in minutes to wait before triggering another alert. This defaults to 1440 minutes (1 day). This does not need to be set for batch alerts.
    """
    enabled: Optional[bool] = None
    """
    Whether or not an alert rule is active. Defaults to true.
    """


class PaginatedAlertNotificationConfigurationsResponse(BaseModel):
    """
    Paginated list of alert notification configurations
    """

    data: List[AlertNotificationConfiguration]
    page: Page
    page_size: PageSize
    total_pages: TotalPages
    total_count: TotalCount


class Frequency(str, Enum):
    """
    The cadence on which to send out the alert summary to subscribers
    """

    Daily = 'daily'
    Weekly = 'weekly'


class SendDayOfWeek(str, Enum):
    """
    The day of the week to send the alert summary to subscribers. Only required if frequency is Weekly.
    """

    Monday = 'Monday'
    Tuesday = 'Tuesday'
    Wednesday = 'Wednesday'
    Thursday = 'Thursday'
    Friday = 'Friday'
    Saturday = 'Saturday'
    Sunday = 'Sunday'


class NewAlertSummaryConfiguration(BaseModel):
    """
    a new alert summary configuration to create
    """

    name: str
    """
    The user defined name of this alert summary configuration. Must be unique within the org
    """
    frequency: Frequency
    """
    The cadence on which to send out the alert summary to subscribers
    """
    send_day_of_week: Optional[SendDayOfWeek] = None
    """
    The day of the week to send the alert summary to subscribers. Only required if frequency is Weekly.
    """
    send_time_of_day: str = Field(..., example='09:00')
    """
    The time on a given day to send the alert summary to subscribers in the format "00:00".
    """
    models: Optional[List[str]] = None
    """
    The models that should be included in the alert summary
    """
    subscribers: Optional[List[NewAlertSummaryNotificationConfiguration]] = None
    """
    collection of notification configurations that define where to send this alert summary
    """


class Type2(str, Enum):
    Email = 'email'
    PagerDuty = 'pagerduty'
    ServiceNow = 'servicenow'


class NewAlertNotificationConfiguration(BaseModel):
    """
    a new alert notification configuration to create
    """

    model_id: str
    """
    The UUID of the model that this alert notification config belongs to
    """
    type: Type2
    destination: Optional[str] = None
    """
    For a notification type of "email", this field does not need to be provided and will be automatically inferred from the user id.
    """
    user_id: Optional[str] = None
    """
    UUID of the user this notification config is associated with, if any. This field is required for email notifications.
    """
    enabled: Optional[bool] = True
    """
    Whether or not this notification config is enabled. Defaults to "true"
    """


class BulkAlertUpdateResponse(BaseModel):
    """
    Information on the outcome of a bulk alert update
    """

    updated_alerts: int
    """
    The number of alerts updates for the alert rule
    """


class Status(str, Enum):
    """
    Whether the alert has been resolved or not.
    """

    New = 'new'
    Resolved = 'resolved'


class AlertNotificationConfigurationUpdate(BaseModel):
    """
    The fields to update in the AlertNotificationConfiguration object
    """

    enabled: bool
    """
    Whether or not this notification config is enabled
    """


class AlertSummaryConfigurationUpdate(BaseModel):
    """
    the updated AlertSummaryConfiguration object
    """

    name: Optional[str] = None
    """
    The user defined name of this alert summary configuration. Must be unique within the org
    """
    frequency: Optional[Frequency] = None
    """
    The cadence on which to send out the alert summary to subscribers
    """
    send_day_of_week: Optional[SendDayOfWeek] = None
    """
    The day of the week to send the alert summary to subscribers. Only required if frequency is Weekly.
    """
    send_time_of_day: Optional[str] = Field(None, example='09:00')
    """
    The time on a given day to send the alert summary to subscribers in the format "00:00".
    """
    models: Optional[List[str]] = None
    """
    The models that should be included in the alert summary
    """
    enabled: Optional[bool] = True
    """
    Whether or not this Alert Summary configuration is enabled.
    """


class Severity1(str, Enum):
    """
    Priority of the alert rule which triggered this alert.
    """

    Warning = 'warning'
    Critical = 'critical'


class AlertRulePatch(BaseModel):
    name: Optional[str] = None
    """
    Optional new display name of the alert rule. Will replace the existing name if supplied.
    """
    bound: Optional[Bound] = None
    threshold: Optional[float] = None
    """
    threshold of alert rule
    """
    severity: Optional[Severity1] = None
    """
    Priority of the alert rule which triggered this alert.
    """
    lookback_period: Optional[int] = None
    """
    The lookback time in minutes to use when calculating the alert rule metric. For example, a Lookback Period of 3 minutes for an alert rule on average prediction will calculate average prediction for the past 3 minutes in a rolling window format. This will default to 1 minute
    """
    subsequent_alert_wait_time: Optional[int] = None
    """
    If metric continues to pass threshold this is the time in minutes to wait before triggering another alert. This defaults to 1440 minutes (1 day).
    """
    enabled: Optional[bool] = None
    """
    Whether or not an alert rule is active. Defaults to true.
    """


class Status1(str, Enum):
    """
    Status to update alert with
    """

    Resolved = 'resolved'
    Acknowledged = 'acknowledged'


class AlertRequest(BaseModel):
    status: Status1
    """
    Status to update alert with
    """


class AlertSummaryNotificationConfiguration(BaseModel):
    """
    Tells us where and how to deliver an alert summary
    """

    id: str
    """
    the unique UUID of this AlertSummaryNotificationConfiguration
    """
    type: Type
    summary_id: str
    destination: Optional[str] = None
    """
    For a notification type of "email", this is the email address the alert summary will be delivered to
    """
    user_id: Optional[str] = None
    """
    UUID of the user this alert summary notification configuration is associated with, if any. This field is required for notifications of type "email".
    """
    enabled: bool
    """
    Whether or not this Alert Summary Notification configuration is enabled.
    """


class AlertSummaryReportLineItem(BaseModel):
    """
    data for a specific alert line item to be included in an alert summary report
    """

    model_id: str
    """
    UUID of the model that this alert data belongs to
    """
    alert_check_name: str
    """
    the name of the alert rule to display in the report
    """
    alert_check_threshold: str
    """
    the threshold configured for the alert rule this alert data belongs to
    """
    alert_count: float
    """
    the count of alerts that were triggered for the alert rule this alert data belongs to
    """
    hyperlink: Optional[str] = None
    """
    a click-able url link that should be embedded into this line item for the alert summary report
    """


class AlertSummaryNotificationConfigurationUpdate(BaseModel):
    """
    the updated AlertSummaryNotificationConfiguration object
    """

    enabled: Optional[bool] = None
    """
    Whether or not this Alert Summary Notification configuration is enabled.
    """


class AlertSummaryConfiguration(BaseModel):
    """
    Specify the contents of an alert summary as well as when and where to send it
    """

    id: str = Field(..., example='418c6939-8765-40fa-b04e-11ba57b7f21c')
    """
    The unique UUID of this alert summary configuration
    """
    name: str
    """
    The user defined name of this alert summary configuration. Must be unique within the org
    """
    owner_user_id: Optional[str] = None
    """
    The unique id of the user that created this alert summary configuration
    """
    organization_id: UUID
    """
    The UUID of the organization corresponding to this alert.
    """
    frequency: Frequency
    """
    The cadence on which to send out the alert summary to subscribers
    """
    send_day_of_week: Optional[SendDayOfWeek] = None
    """
    The day of the week to send the alert summary to subscribers. Only required if frequency is Weekly.
    """
    send_time_of_day: str = Field(..., example='09:00')
    """
    The time on a given day to send the alert summary to subscribers in the format "00:00".
    """
    models: List[str]
    """
    UUIDs of the models that should be included in the alert summary
    """
    subscribers: List[AlertSummaryNotificationConfiguration]
    """
    collection of notification configurations that define where to send this alert summary
    """
    enabled: bool
    """
    Whether or not this Alert Summary configuration is enabled.
    """


class AlertRuleResponse(AlertRuleRequest):
    id: str
    """
    UUID of an alert rule
    """
    metric_query: Union[QueryRequest, DataDriftRequest]
    """
    This should be in the format described in our [Query Guide](/api-documentation/query_guide.html). Note that you should not include timestamp or batch_id filters as these should be dynamically added when fetching the metric. The query should use an aggregate function in the first select that maps to the result returned from the query. The query should return a single result.
    """
    metric_type: MetricType
    """
    The metric type/category
    """
    last_updated_by: Optional[str] = None
    """
    User ID of the user that created or last updated this alert rule. Null if the rule was auto-generated by Arthur.
    """
    last_updated_by_type: Optional[LastUpdatedByType] = None
    """
    Type of user that created or last updated this alert rule. Null if the rule was auto-generated by Arthur.
    """
    last_updated_at: Optional[str] = None
    """
    The time that this alert rule was created or last updated.
    """
    alert_counts: Optional[AlertCounts] = None
    last_metric_value: Optional[float] = None
    """
    Metric value of the most recent triggered alert for this alert rule. Only included if include_alert_metadata query param is set to true.
    """
    last_triggered: Optional[str] = None
    """
    Timestamp of the most recent triggered alert for this alert rule. Only included if include_alert_metadata query param is set to true.
    """
    name: str
    """
    A name for the alert rule, a default will be generated if this is not supplied.
    """
    threshold: float
    """
    threshold of alert rule
    """
    bound: Bound
    severity: Severity
    """
    Priority of the alert rule which triggered this alert.
    """
    lookback_period: int
    """
    The lookback time or "window length" in minutes to use when calculating the alert rule metric. For example, a lookback period of 5 minutes for an alert rule on average prediction will calculate average prediction for the past 5 minutes in a rolling window format. This will default to 5 minutes
    """
    subsequent_alert_wait_time: int
    """
    If metric continues to pass threshold this is the time in minutes to wait before triggering another alert. This defaults to 1440 minutes (1 day). This does not need to be set for batch alerts.
    """
    enabled: bool
    """
    Whether or not an alert rule is active. Defaults to true.
    """
    metric_id: str
    """
    The UUID of the metric to use for this alert rule.
    """


class PaginatedAlertSummaryNotificationConfigurationsResponse(BaseModel):
    """
    Paginated list of alert summary configurations
    """

    data: List[AlertSummaryNotificationConfiguration]
    page: Page
    page_size: PageSize
    total_pages: TotalPages
    total_count: TotalCount


class AlertSummaryReport(BaseModel):
    """
    Contents of an alert summary report to be sent
    """

    report_id: str
    """
    unique UUID of this alert summary report
    """
    configuration_id: str
    """
    UUID of the alert summary report configuration associated with this report
    """
    time_frame: str
    """
    the start to end time frame in UTC for this report
    """
    data: List[AlertSummaryReportLineItem]
    """
    alert summary data line items to include in the report
    """


class AlertResponse(BaseModel):
    id: str
    """
    UUID of the alert
    """
    timestamp: datetime
    """
    UTC timestamp in ISO8601 format when the alert was triggered
    """
    window_start: Optional[str] = None
    """
    UTC timestamp in ISO8601 of the metric's rolling window start time
    """
    window_end: Optional[str] = None
    """
    UTC timestamp in ISO8601 of the metric's rolling window end time
    """
    metric_value: float
    """
    The metric value calculated between the window_start and window_end times
    """
    message: str
    """
    Message associated with the alert.
    """
    severity: str
    """
    Priority of the alert rule which triggered this alert.
    """
    model_id: str
    """
    UUID of the model the alert is on
    """
    batch_id: Optional[str] = None
    """
    Id of the batch which the alert was triggered for. Only valid for batch alert rules.
    """
    status: Status
    """
    Whether the alert has been resolved or not.
    """
    organization_id: Optional[UUID] = None
    """
    The UUID of the organization corresponding to this alert.
    """
    alert_rule: AlertRuleResponse


class PaginatedAlertSummaryReportsResponse(BaseModel):
    """
    Paginated list of alert summary reports
    """

    data: Optional[List[AlertSummaryReport]] = None
    page: Optional[Page] = None
    page_size: Optional[PageSize] = None
    total_pages: Optional[TotalPages] = None
    total_count: Optional[TotalCount] = None


class PaginatedAlertRuleResponse(BaseModel):
    """
    Paginated list of alert rules.
    """

    data: Optional[List[AlertRuleResponse]] = None
    page: Optional[Page] = None
    page_size: Optional[PageSize] = None
    total_pages: Optional[TotalPages] = None
    total_count: Optional[TotalCount] = None


class PaginatedAlertSummaryConfigurationsResponse(BaseModel):
    """
    Paginated list of alert summary configurations
    """

    data: List[AlertSummaryConfiguration]
    page: Page
    page_size: PageSize
    total_pages: TotalPages
    total_count: TotalCount


class PaginatedAlertResponse(BaseModel):
    """
    Paginated list of alert responses.
    """

    data: List[AlertResponse]
    page: Page
    page_size: PageSize
    total_pages: TotalPages
    total_count: TotalCount
