# generated by datamodel-codegen:
#   filename:  insights.yaml
#   timestamp: 2023-11-17T16:56:28+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional

from arthur.client.rest.common.models import Page, PageSize, TotalCount, TotalPages
from pydantic import BaseModel


class InsightUpdateResponse(BaseModel):
    """
    Information on the outcome of an insight(s) update
    """

    updated_count: int
    """
    The number of insights updated
    """


class ModelInsightCount(BaseModel):
    """
    Insight counts by model
    """

    model_id: str
    """
    UUID of the model these insights belong to
    """
    count: float
    """
    number of insights that fit the request criteria
    """


class MetricType(str, Enum):
    """
    the metric this insight is calculate for. Only accuracy hotspots insights are supported for now.
    """

    AccuracyHotspot = 'accuracyhotspot'


class Status(str, Enum):
    """
    Whether the alert has been resolved or not.
    """

    New = 'new'
    Resolved = 'resolved'
    Acknowledged = 'acknowledged'


class Insight(BaseModel):
    id: str
    """
    UUID of the insight
    """
    model_id: str
    """
    UUID of the model the insight is on
    """
    batch_id: Optional[str] = None
    """
    Id of the batch which the insights was generated for. Only valid for batch models.
    """
    run_id: str
    """
    UUID of the corresponding workflow run in dataset-service that triggered the generation of this insight.
    """
    metric_type: MetricType
    """
    the metric this insight is calculate for. Only accuracy hotspots insights are supported for now.
    """
    threshold_value: float
    """
    the threshold value the metric is checked against
    """
    region: Dict[str, Any]
    """
    bounds on model inputs associated with this insight
    """
    metric_value: float
    """
    the value of this input region for the specified metric type
    """
    timestamp: datetime
    """
    UTC timestamp in ISO8601 format when the insight was created
    """
    window_start: Optional[datetime] = None
    """
    Only for streaming models. UTC timestamp in ISO8601, of the start time boundary of hotspot checking
    """
    window_end: Optional[datetime] = None
    """
    Only for streaming models. UTC timestamp in ISO8601, of the end time boundary of hotspot checking
    """
    status: Status
    """
    Whether the alert has been resolved or not.
    """


class InsightGroupCounts(BaseModel):
    """
    Insights are grouped by batch_id for batch models and by window_start for streaming models. Each group contains either a batch_id or window_start field that identifies the group.
    """

    batch_id: Optional[str] = None
    """
    Id of the batch which identify this group of generated insights. Only valid for batch models.
    """
    window_start: Optional[datetime] = None
    """
    Only for streaming models. UTC timestamp in ISO8601, of the start time boundary of hotspot checking which identify this group of generated insights.
    """
    timestamp: Optional[datetime] = None
    """
    UTC timestamp in ISO8601 format of the latest insight that belongs to this group.
    """
    count: Optional[float] = None
    """
    Total number of insights that belong to this group.
    """


class Status1(str, Enum):
    """
    Status to update alert with
    """

    New = 'new'
    Resolved = 'resolved'
    Acknowledge = 'acknowledged'


class InsightPatch(BaseModel):
    status: Status1
    """
    Status to update alert with
    """


class PaginatedInsights(BaseModel):
    """
    Paginated list of insights.
    """

    data: List[Insight]
    page: Page
    page_size: PageSize
    total_pages: TotalPages
    total_count: TotalCount


class PaginatedInsightGroupCounts(BaseModel):
    """
    Paginated list of Insight Groups.
    """

    data: List[InsightGroupCounts]
    page: Page
    page_size: PageSize
    total_pages: TotalPages
    total_count: TotalCount
