# generated by datamodel-codegen:
#   filename:  model_groups.yaml
#   timestamp: 2023-11-17T16:56:28+00:00

from __future__ import annotations

from datetime import datetime
from typing import List, Optional

from arthur.client.rest.common.models import Page, PageSize, TotalCount, TotalPages
from arthur.client.rest.models.models import ModelResponse
from pydantic import BaseModel, constr


class ModelGroupResponse(BaseModel):
    id: Optional[str] = None
    """
    The auto-generated unique UUID for the model group.
    """
    name: Optional[constr(max_length=255)] = None
    """
    Optional name of the model group.
    """
    description: Optional[constr(max_length=255)] = None
    """
    Optional description of the model group.
    """
    versions: Optional[List[ModelResponse]] = None
    """
    Model versions
    """
    archived: Optional[bool] = None
    """
    Indicates whether or not a model group has been archived, defaults to false.
    """
    archived_at: Optional[datetime] = None
    """
    UTC timestamp in ISO8601 format of when the model group was archived.
    """
    created_at: Optional[datetime] = None
    """
    UTC timestamp in ISO8601 format of when the model group was created.
    """
    updated_at: Optional[datetime] = None
    """
    UTC timestamp in ISO8601 format of when the model group was last updated.
    """


class ModelGroupUpdateRequest(BaseModel):
    name: Optional[constr(max_length=255)] = None
    """
    Optional name of the model group.
    """
    description: Optional[constr(max_length=255)] = None
    """
    Optional description of the model group.
    """


class PaginatedModelGroupVersionsResponse(BaseModel):
    data: List[ModelResponse]
    """
    Model versions.
    """
    page: Page
    page_size: PageSize
    total_pages: Optional[TotalPages] = None
    total_count: Optional[TotalCount] = None


class PaginatedModelGroupResponse(BaseModel):
    data: List[ModelGroupResponse]
    """
    List of model group objects.
    """
    page: Page
    page_size: PageSize
    total_pages: Optional[TotalPages] = None
    total_count: Optional[TotalCount] = None
