from codemie_tools.base.models import ToolMetadata

SEARCH_ES_INDEX_TOOL = ToolMetadata(
    name="elastic",
    description="""
    Use this tool when user wants to search a specific data in the specific index in Elastic.
    There several required fields:
    - index: name of the Elastic index which should be used to apply generated query to fulfill user request.
    - query: string text. It's a query to Elastic API in a form of a Query DSL generated by LLM which
    will be used to find necessary information in a specified index to fulfill user request.
    Important: string formatting and escaping SHOULD NOT be used when passing query to the tool.
    """.strip(),
    label="Search Elastic index",
    user_description="""
    Provides access to Elasticsearch, enabling search operations on specific indices within an Elastic cluster. This tool allows the AI assistant to perform targeted searches and retrieve data from Elasticsearch.
    Before using it, it is necessary to add a new integration for the tool by providing:
    1. Alias (A friendly name for the Elasticsearch integration)
    2. Elasticsearch URL
    3. API Key ID
    4. API Key
    """.strip()
)
