from typing import overload
from enum import IntEnum
import abc
import datetime
import typing

import QuantConnect
import QuantConnect.Data
import QuantConnect.Data.Fundamental
import QuantConnect.Data.Market
import QuantConnect.Data.UniverseSelection
import System
import System.Collections.Generic

ReusuableCLRObject = typing.Any

QuantConnect_Data_Fundamental_MultiPeriodField_T = typing.TypeVar("QuantConnect_Data_Fundamental_MultiPeriodField_T")


class FundamentalTimeDependentProperty(ReusuableCLRObject, metaclass=abc.ABCMeta):
    """Simple base class shared by top layer fundamental properties which depend on a time provider"""

    @property
    def _time_provider(self) -> QuantConnect.ITimeProvider:
        """
        The time provider instance to use
        
        This property is protected.
        """
        ...

    @property
    def _security_identifier(self) -> QuantConnect.SecurityIdentifier:
        """
        The SID instance to use
        
        This property is protected.
        """
        ...

    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def clone(self, time_provider: QuantConnect.ITimeProvider) -> QuantConnect.Data.Fundamental.FundamentalTimeDependentProperty:
        """Clones this instance"""
        ...


class CompanyReference(QuantConnect.Data.Fundamental.FundamentalTimeDependentProperty):
    """Definition of the CompanyReference class"""

    @property
    def company_id(self) -> str:
        """10-digit unique and unchanging Morningstar identifier assigned to every company."""
        ...

    @property
    def short_name(self) -> str:
        """25-character max abbreviated name of the firm. In most cases, the short name will simply be the Legal Name less the "Corporation", "Corp.", "Inc.", "Incorporated", etc..."""
        ...

    @property
    def standard_name(self) -> str:
        """The English translation of the foreign legal name if/when applicable."""
        ...

    @property
    def legal_name(self) -> str:
        """The full name of the registrant as specified in its charter, and most often found on the front cover of the 10K/10Q/20F filing."""
        ...

    @property
    def country_id(self) -> str:
        """3 Character ISO code of the country where the firm is domiciled. See separate reference document for Country Mappings."""
        ...

    @property
    def cik(self) -> str:
        """The Central Index Key; a corporate identifier assigned by the Securities and Exchange Commission (SEC)."""
        ...

    @property
    def company_status(self) -> str:
        """At the Company level; each company is assigned to 1 of 3 possible status classifications; (U) Public, (V) Private, or (O) Obsolete: - Public-Firm is operating and currently has at least one common share class that is currently trading on a public exchange. - Private-Firm is operating but does not have any common share classes currently trading on a public exchange. - Obsolete-Firm is no longer operating because it closed its business, or was acquired."""
        ...

    @property
    def fiscal_year_end(self) -> int:
        """The Month of the company's latest fiscal year."""
        ...

    @property
    def industry_template_code(self) -> str:
        """This indicator will denote which one of the six industry data collection templates applies to the company. Each industry data collection template includes data elements that are commonly reported by companies in that industry. N=Normal (Manufacturing), M=Mining, U=Utility, T=Transportation, B=Bank, I=Insurance"""
        ...

    @property
    def primary_share_class_id(self) -> str:
        """The 10-digit unique and unchanging Morningstar identifier assigned to the Primary Share class of a company. The primary share of a company is defined as the first share that was traded publicly and is still actively trading. If this share is no longer trading, the primary share will be the share with the highest volume."""
        ...

    @property
    def primary_symbol(self) -> str:
        """The symbol of the Primary Share of the company, composed of an arrangement of characters (often letters) representing a particular security listed on an exchange or otherwise traded publicly. The primary share of a company is defined as the first share that was traded publicly and is still actively trading. If this share is no longer trading, the primary share will be the share with the highest volume. Note: Morningstar's multi-share class symbols will often contain a "period" within the symbol; e.g. BRK.B for Berkshire Hathaway Class B."""
        ...

    @property
    def primary_exchange_id(self) -> str:
        """The Id representing the stock exchange of the Primary Share of the company. See separate reference document for Exchange Mappings. The primary share of a company is defined as the first share that was traded publicly with and is still actively trading. If this share is no longer trading, the primary share will be the share with the highest volume."""
        ...

    @property
    def business_country_id(self) -> str:
        """In some cases, different from the country of domicile (CountryId; DataID 5). This element is a three (3) Character ISO code of the business country of the security. It is determined by a few factors, including:"""
        ...

    @property
    def legal_name_language_code(self) -> str:
        """The language code for the foreign legal name if/when applicable. Related to DataID 4 (LegalName)."""
        ...

    @property
    def auditor(self) -> str:
        """The legal (registered) name of the company's current auditor. Distinct from DataID 28000 Period Auditor that identifies the Auditor related to that period's financial statements."""
        ...

    @property
    def auditor_language_code(self) -> str:
        """The ISO code denoting the language text for Auditor's name and contact information."""
        ...

    @property
    def advisor(self) -> str:
        """The legal (registered) name of the current legal Advisor of the company."""
        ...

    @property
    def advisor_language_code(self) -> str:
        """The ISO code denoting the language text for Advisor's name and contact information."""
        ...

    @property
    def is_limited_partnership(self) -> bool:
        """Indicator to denote if the company is a limited partnership, which is a form of business structure comprised of a general partner and limited partners. 1 denotes it is a LP; otherwise 0."""
        ...

    @property
    def is_reit(self) -> bool:
        """Indicator to denote if the company is a real estate investment trust (REIT). 1 denotes it is a REIT; otherwise 0."""
        ...

    @property
    def primary_mic(self) -> str:
        """The MIC (market identifier code) of the PrimarySymbol of the company. See Data Appendix A for the relevant MIC to exchange name mapping."""
        ...

    @property
    def report_style(self) -> int:
        """This refers to the financial template used to collect the company's financial statements. There are two report styles representing two different financial template structures. Report style "1" is most commonly used by US and Canadian companies, and Report style "3" is most commonly used by the rest of the universe. Contact your client manager for access to the respective templates."""
        ...

    @property
    def yearof_establishment(self) -> str:
        """The year a company was founded."""
        ...

    @property
    def is_limited_liability_company(self) -> bool:
        """Indicator to denote if the company is a limited liability company. 1 denotes it is a LLC; otherwise 0."""
        ...

    @property
    def expected_fiscal_year_end(self) -> datetime.datetime:
        """The upcoming expected year end for the company. It is calculated based on current year end (from latest available annual report) + 1 year."""
        ...

    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def clone(self, time_provider: QuantConnect.ITimeProvider) -> QuantConnect.Data.Fundamental.FundamentalTimeDependentProperty:
        """Clones this instance"""
        ...


class SecurityReference(QuantConnect.Data.Fundamental.FundamentalTimeDependentProperty):
    """Definition of the SecurityReference class"""

    @property
    def security_symbol(self) -> str:
        """An arrangement of characters (often letters) representing a particular security listed on an exchange or otherwise traded publicly. Note: Morningstar's multi-share class symbols will often contain a "period" within the symbol; e.g. BRK.B for Berkshire Hathaway Class B."""
        ...

    @property
    def exchange_id(self) -> str:
        """The Id representing the stock exchange that the particular share class is trading. See separate reference document for Exchange Mappings."""
        ...

    @property
    def currency_id(self) -> str:
        """3 Character ISO code of the currency that the exchange price is denominated in; i.e. the trading currency of the security. See separate reference document for Currency Mappings."""
        ...

    @property
    def ipo_date(self) -> datetime.datetime:
        """The initial day that the share begins trading on a public exchange."""
        ...

    @property
    def is_depositary_receipt(self) -> bool:
        """Indicator to denote if the share class is a depository receipt. 1 denotes it is an ADR or GDR; otherwise 0."""
        ...

    @property
    def depositary_receipt_ratio(self) -> float:
        """The number of underlying common shares backing each American Depository Receipt traded."""
        ...

    @property
    def security_type(self) -> str:
        """Each security will be assigned to one of the below security type classifications; - Common Stock (ST00000001) - Preferred Stock (ST00000002) - Units (ST000000A1)"""
        ...

    @property
    def share_class_description(self) -> str:
        """Provides information when applicable such as whether the share class is Class A or Class B, an ADR, GDR, or a business development company (BDC). For preferred stocks, this field provides more detail about the preferred share class."""
        ...

    @property
    def share_class_status(self) -> str:
        """At the ShareClass level; each share is assigned to 1 of 4 possible status classifications; (A) Active, (D) Deactive, (I) Inactive, or (O) Obsolete: - Active-Share class is currently trading in a public market, and we have fundamental data available. - Deactive-Share class was once Active, but is no longer trading due to share being delisted from the exchange. - Inactive-Share class is currently trading in a public market, but no fundamental data is available. - Obsolete-Share class was once Inactive, but is no longer trading due to share being delisted from the exchange."""
        ...

    @property
    def is_primary_share(self) -> bool:
        """This indicator will denote if the indicated share is the primary share for the company. A "1" denotes the primary share, a "0" denotes a share that is not the primary share. The primary share is defined as the first share that a company IPO'd with and is still actively trading. If this share is no longer trading, we will denote the primary share as the share with the highest volume."""
        ...

    @property
    def is_dividend_reinvest(self) -> bool:
        """Shareholder election plan to re-invest cash dividend into additional shares."""
        ...

    @property
    def is_direct_invest(self) -> bool:
        """A plan to make it possible for individual investors to invest in public companies without going through a stock broker."""
        ...

    @property
    def investment_id(self) -> str:
        """Identifier assigned to each security Morningstar covers."""
        ...

    @property
    def ipo_offer_price(self) -> float:
        """IPO offer price indicates the price at which an issuer sells its shares under an initial public offering (IPO). The offer price is set by issuer and its underwriters."""
        ...

    @property
    def delisting_date(self) -> datetime.datetime:
        """The date on which an inactive security was delisted from an exchange."""
        ...

    @property
    def delisting_reason(self) -> str:
        """The reason for an inactive security's delisting from an exchange. The full list of Delisting Reason codes can be found within the Data Definitions- Appendix A DelistingReason Codes tab."""
        ...

    @property
    def mic(self) -> str:
        """The MIC (market identifier code) of the related shareclass of the company. See Data Appendix A for the relevant MIC to exchange name mapping."""
        ...

    @property
    def common_share_sub_type(self) -> str:
        """Refers to the type of securities that can be found within the equity database. For the vast majority, this value will populate as null for regular common shares. For a minority of shareclasses, this will populate as either "Participating Preferred", "Closed-End Fund", "Foreign Share", or "Foreign Participated Preferred" which reflects our limited coverage of these types of securities within our equity database."""
        ...

    @property
    def ipo_offer_price_range(self) -> str:
        """The estimated offer price range (low-high) for a new IPO. The field should be used until the final IPO price becomes available, as populated in the data field "IPOPrice"."""
        ...

    @property
    def exchange_sub_market_global_id(self) -> str:
        """Classification to denote different Marketplace or Market tiers within a stock exchange."""
        ...

    @property
    def conversion_ratio(self) -> float:
        """The relationship between the chosen share class and the primary share class."""
        ...

    @property
    def par_value(self) -> float:
        """Nominal value of a security determined by the issuing company."""
        ...

    @property
    def trading_status(self) -> bool:
        """Morningstar DataId: 1028"""
        ...

    @property
    def market_data_id(self) -> str:
        """Morningstar DataId: 1029"""
        ...

    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def clone(self, time_provider: QuantConnect.ITimeProvider) -> QuantConnect.Data.Fundamental.FundamentalTimeDependentProperty:
        """Clones this instance"""
        ...


class FinancialStatementsPeriodEndingDate(QuantConnect.Data.Fundamental.MultiPeriodField[datetime.datetime]):
    """The exact date that is given in the financial statements for each quarter's end."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> datetime.datetime:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> datetime.datetime:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> datetime.datetime:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> datetime.datetime:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> datetime.datetime:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> datetime.datetime:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> datetime.datetime:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> datetime.datetime:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, datetime.datetime]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FinancialStatementsFileDate(QuantConnect.Data.Fundamental.MultiPeriodField[datetime.datetime]):
    """Specific date on which a company released its filing to the public."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> datetime.datetime:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> datetime.datetime:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> datetime.datetime:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> datetime.datetime:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> datetime.datetime:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> datetime.datetime:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> datetime.datetime:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> datetime.datetime:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, datetime.datetime]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FinancialStatementsAccessionNumber(QuantConnect.Data.Fundamental.MultiPeriodField[str]):
    """The accession number is a unique number that EDGAR assigns to each submission as the submission is received."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> str:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> str:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> str:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> str:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> str:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> str:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> str:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, str]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FinancialStatementsFormType(QuantConnect.Data.Fundamental.MultiPeriodField[str]):
    """The type of filing of the report: for instance, 10-K (annual report) or 10-Q (quarterly report)."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> str:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> str:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> str:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> str:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> str:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> str:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> str:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> str:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, str]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PeriodAuditor(QuantConnect.Data.Fundamental.MultiPeriodField[str]):
    """The name of the auditor that performed the financial statement audit for the given period."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> str:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> str:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> str:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> str:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> str:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> str:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> str:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> str:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, str]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AuditorReportStatus(QuantConnect.Data.Fundamental.MultiPeriodField[str]):
    """Auditor opinion code will be one of the following for each annual period: Code Meaning UQ Unqualified Opinion UE Unqualified Opinion with Explanation QM Qualified - Due to change in accounting method QL Qualified - Due to litigation OT Qualified Opinion - Other AO Adverse Opinion DS Disclaim an opinion UA Unaudited"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> str:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> str:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> str:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> str:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> str:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> str:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> str:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> str:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, str]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InventoryValuationMethod(QuantConnect.Data.Fundamental.MultiPeriodField[str]):
    """Which method of inventory valuation was used - LIFO, FIFO, Average, Standard costs, Net realizable value, Others, LIFO and FIFO, FIFO and Average, FIFO and other, LIFO and Average, LIFO and other, Average and other, 3 or more methods, None"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> str:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> str:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> str:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> str:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> str:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> str:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> str:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> str:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, str]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NumberOfShareHolders(QuantConnect.Data.Fundamental.MultiPeriodField[int]):
    """The number of shareholders on record"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> int:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> int:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> int:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> int:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> int:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> int:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> int:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> int:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, int]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FinancialStatementsPeriodType(QuantConnect.Data.Fundamental.MultiPeriodField[str]):
    """The nature of the period covered by an individual set of financial results. The output can be: Quarter, Semi-annual or Annual. Assuming a 12-month fiscal year, quarter typically covers a three-month period, semi-annual a six-month period, and annual a twelve-month period. Annual could cover results collected either from preliminary results or an annual report"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> str:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> str:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> str:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> str:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> str:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> str:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> str:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> str:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, str]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalRiskBasedCapital(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The sum of Tier 1 and Tier 2 Capital. Tier 1 capital consists of common shareholders equity, perpetual preferred shareholders equity with non-cumulative dividends, retained earnings, and minority interests in the equity accounts of consolidated subsidiaries. Tier 2 capital consists of subordinated debt, intermediate-term preferred stock, cumulative and long-term preferred stock, and a portion of a bank's allowance for loan and lease losses."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class IncomeStatementFileDate(QuantConnect.Data.Fundamental.MultiPeriodField[datetime.datetime]):
    """Filing date of the Income Statement."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> datetime.datetime:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> datetime.datetime:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> datetime.datetime:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def six_months(self) -> datetime.datetime:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> datetime.datetime:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> datetime.datetime:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> datetime.datetime:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> datetime.datetime:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, datetime.datetime]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AmortizationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The non-cash expense recognized on intangible assets over the benefit period of the asset."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SecuritiesAmortizationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The gradual elimination of a liability, such as a mortgage, in regular payments over a specified period of time. Such payments must be sufficient to cover both principal and interest."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CostOfRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate cost of goods produced and sold and services rendered during the reporting PeriodAsByte. It excludes all operating expenses such as depreciation, depletion, amortization, and SG&A. For the must have cost industry, if the number is not reported by the company, it will be calculated based on accounting equation. Cost of Revenue = Revenue - Operating Expenses - Operating Profit."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DepletionIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The non-cash expense recognized on natural resources (eg. Oil and mineral deposits) over the benefit period of the asset."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DepreciationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The current period non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of assets over their useful lives, in the Income Statement. Examples of tangible asset include buildings, production and equipment."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DepreciationAndAmortizationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The sum of depreciation and amortization expense in the Income Statement. Depreciation is the non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of assets over their useful lives Amortization is the non-cash expense recognized on intangible assets over the benefit period of the asset."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DepreciationAmortizationDepletionIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The sum of depreciation, amortization and depletion expense in the Income Statement. Depreciation is the non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of assets over their useful lives Amortization is the non-cash expense recognized on intangible assets over the benefit period of the asset. Depletion is the non-cash expense recognized on natural resources (eg. Oil and mineral deposits) over the benefit period of the asset."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetIncomeDiscontinuousOperationsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """To be classified as discontinued operations, if both of the following conditions are met: 1: The operations and cash flow of the component have been or will be removed from the ongoing operations of the entity as a result of the disposal transaction, and 2: The entity will have no significant continuing involvement in the operations of the component after the disposal transaction. The discontinued operation is reported net of tax. Gains/Loss on Disposal of Discontinued Operations: Any gains or loss recognized on disposal of discontinued operations, which is the difference between the carrying value of the division and its fair value less costs to sell. Provision for Gain/Loss on Disposal: The amount of current expense charged in order to prepare for the disposal of discontinued operations."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ExciseTaxesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Excise taxes are taxes paid when purchases are made on a specific good, such as gasoline. Excise taxes are often included in the price of the product. There are also excise taxes on activities, such as on wagering or on highway usage by trucks."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetIncomeExtraordinaryIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gains (losses), whether arising from extinguishment of debt, prior period adjustments, or from other events or transactions, that are both unusual in nature and infrequent in occurrence thereby meeting the criteria for an event or transaction to be classified as an extraordinary item."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FeeRevenueAndOtherIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of fees, commissions, and other income."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GeneralAndAdministrativeExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate total of general managing and administering expenses for the company."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GrossProfitIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total revenue less cost of revenue. The number is as reported by the company on the income statement; however, the number will be calculated if it is not reported. This field is null if the cost of revenue is not given. Gross Profit = Total Revenue - Cost of Revenue."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Relates to the general cost of borrowing money. It is the price that a lender charges a borrower for the use of the lender's money."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestExpenseNonOperatingIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Interest expense caused by long term financing activities; such as interest expense incurred on trading liabilities, commercial paper, long-term debt, capital leases, deposits, and all other borrowings."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestIncomeAfterProvisionForLoanLossIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net interest and dividend income or expense, including any amortization and accretion (as applicable) of discounts and premiums, including consideration of the provisions for loan, lease, credit, and other related losses, if any."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestIncomeNonOperatingIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Interest income earned from long term financing activities."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetNonOperatingInterestIncomeExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net-Non Operating interest income or expenses caused by financing activities."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LossAdjustmentExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Losses generally refer to (1) the amount of reduction in the value of an insured's property caused by an insured peril, (2) the amount sought through an insured's claim, or (3) the amount paid on behalf of an insured under an insurance contract. Loss Adjustment Expenses is expenses incurred in the course of investigating and settling claims that includes any legal and adjusters' fees and the costs of paying claims and all related expenses."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class MinorityInterestsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents par or stated value of the subsidiary stock not owned by the parent company plus the minority interest's equity in the surplus of the subsidiary. This item includes preferred dividend averages on the minority preferred stock (preferred shares not owned by the reporting parent company). Minority interest also refers to stockholders who own less than 50% of a subsidiary's outstanding voting common stock. The minority stockholders hold an interest in the subsidiary's net assets and share earnings with the parent company."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Includes all the operations (continuing and discontinued) and all the other income or charges (extraordinary, accounting changes, tax loss carry forward, and other gains and losses)."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetIncomeCommonStockholdersIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net income minus the preferred dividends paid as presented in the Income Statement."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetIncomeContinuousOperationsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Revenue less expenses and taxes from the entity's ongoing operations and before income (loss) from: Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing Operation; Income from Tax Loss Carry forward; Other Gains/Losses."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetInterestIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total interest income minus total interest expense. It represents the difference between interest and dividends earned on interest- bearing assets and interest paid to depositors and other creditors."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetInvestmentIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total of interest, dividends, and other earnings derived from the insurance company's invested assets minus the expenses associated with these investments. Excluded from this income are capital gains or losses as the result of the sale of assets, as well as any unrealized capital gains or losses."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All sales, business revenues and income that the company makes from its business operations, net of excise taxes. This applies for all companies and can be used as comparison for all industries. For Normal, Mining, Transportation and Utility templates companies, this is the sum of Operating Revenues, Excise Taxes and Fees. For Bank template companies, this is the sum of Net Interest Income and Non-Interest Income. For Insurance template companies, this is the sum of Premiums, Interest Income, Fees, Investment and Other Income."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonInterestExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Any expenses that not related to interest. It includes labor and related expense, occupancy and equipment, commission, professional expense and contract services expenses, selling, general and administrative, research and development depreciation, amortization and depletion, and any other special income/charges."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonInterestIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The total amount of non-interest income which may be derived from: (1) fees and commissions; (2) premiums earned; (3) equity investment; (4) the sale or disposal of assets; and (5) other sources not otherwise specified."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OperatingExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Operating expenses are primary recurring costs associated with central operations (other than cost of goods sold) that are incurred in order to generate sales."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OperatingIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income from normal business operations after deducting cost of revenue and operating expenses. It does not include income from any investing activities."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OperatingRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sales and income that the company makes from its business operations. This applies only to non-bank and insurance companies. For Utility template companies, this is the sum of revenue from electric, gas, transportation and other operating revenue. For Transportation template companies, this is the sum of revenue-passenger, revenue-cargo, and other operating revenue."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherIncomeExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income or expense that comes from miscellaneous sources."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PolicyAcquisitionExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Costs that vary with and are primarily related to the acquisition of new and renewal insurance contracts. Also referred to as underwriting expenses."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetPolicyholderBenefitsAndClaimsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The net provision in current period for future policy benefits, claims, and claims settlement expenses incurred in the claims settlement process before the effects of reinsurance arrangements. The value is net of the effects of contracts assumed and ceded."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PreferredStockDividendsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount of dividends declared or paid in the period to preferred shareholders, or the amount for which the obligation to pay them dividends arose in the PeriodAsByte. Preferred dividends are the amount required for the current year only, and not for any amount required in past years."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalPremiumsEarnedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Premiums earned is the portion of an insurance written premium which is considered "earned" by the insurer, based on the part of the policy period that the insurance has been in effect, and during which the insurer has been exposed to loss."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PretaxIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Reported income before the deduction or benefit of income taxes."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TaxProvisionIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Include any taxes on income, net of any investment tax credits for the current accounting PeriodAsByte."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CreditLossesProvisionIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A charge to income which represents an expense deemed adequate by management given the composition of a bank's credit portfolios, their probability of default, the economic environment and the allowance for credit losses already established. Specific provisions are established to reduce the book value of specific assets (primarily loans) to establish the amount expected to be recovered on the loans."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ResearchAndDevelopmentIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of research and development expenses during the year."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SellingAndMarketingExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate total amount of expenses directly related to the marketing or selling of products or services."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SellingGeneralAndAdministrationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate total costs related to selling a firm's product and services, as well as all other general and administrative expenses. Selling expenses are those directly related to the company's efforts to generate sales (e.g., sales salaries, commissions, advertising, delivery expenses). General and administrative expenses are expenses related to general administration of the company's operation (e.g., officers and office salaries, office supplies, telephone, accounting and legal services, and business licenses and fees)."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SpecialIncomeChargesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Earnings or losses attributable to occurrences or actions by the firm that is either infrequent or unusual."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The sum of operating expense and cost of revenue. If the company does not give the reported number, it will be calculated by adding operating expense and cost of revenue."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income generated from interest-bearing deposits or accounts."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class EBITIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Earnings minus expenses (excluding interest and tax expenses)."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class EBITDAIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Earnings minus expenses (excluding interest, tax, depreciation, and amortization expenses)."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from: Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing Operation; Income from Tax Loss Carry forward; Other Gains/Losses."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CededPremiumsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount of premiums paid and payable to another insurer as a result of reinsurance arrangements in order to exchange for that company accepting all or part of insurance on a risk or exposure. This item is usually only available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CommissionExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CreditCardIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income earned from credit card services including late, over limit, and annual fees. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DividendIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Dividends earned from equity investment securities. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class EarningsFromEquityInterestIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The earnings from equity interest can be a result of any of the following: Income from earnings distribution of the business, either as dividends paid to corporate shareholders or as drawings in a partnership; Capital gain realized upon sale of the business; Capital gain realized from selling his or her interest to other partners. This item is usually not available for bank and insurance industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class EquipmentIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Equipment expenses include depreciation, repairs, rentals, and service contract costs. This also includes equipment purchases which do not qualify for capitalization in accordance with the entity's accounting policy. This item may also include furniture expenses. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Costs incurred in identifying areas that may warrant examination and in examining specific areas that are considered to have prospects of containing energy or metal reserves, including costs of drilling exploratory wells. Development expense is the capitalized costs incurred to obtain access to proved reserves and to provide facilities for extracting, treating, gathering and storing the energy and metal. Mineral property includes oil and gas wells, mines, and other natural deposits (including geothermal deposits). The payment for leasing those properties is called mineral property lease expense. Exploration expense is included in operation expenses for mining industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FeesAndCommissionsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total fees and commissions earned from providing services such as leasing of space or maintaining: (1) depositor accounts; (2) transfer agent; (3) fiduciary and trust; (4) brokerage and underwriting; (5) mortgage; (6) credit cards; (7) correspondent clearing; and (8) other such services and activities performed for others. This item is usually available for bank and insurance industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ForeignExchangeTradingGainsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Trading revenues that result from foreign exchange exposures such as cash instruments and off-balance sheet derivative instruments. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FuelIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of fuel cost for current period associated with the revenue generation. This item is usually only available for transportation industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FuelAndPurchasePowerIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Cost of fuel, purchase power and gas associated with revenue generation. This item is usually only available for utility industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GainOnSaleOfBusinessIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount of excess earned in comparison to fair value when selling a business. This item is usually not available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GainOnSaleOfPPEIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount of excess earned in comparison to the net book value for sale of property, plant, equipment. This item is usually not available for bank and insurance industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GainOnSaleOfSecurityIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount of excess earned in comparison to the original purchase value of the security."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GrossPremiumsWrittenIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total premiums generated from all policies written by an insurance company within a given period of time. This item is usually only available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ImpairmentOfCapitalAssetsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Impairments are considered to be permanent, which is a downward revaluation of fixed assets. If the sum of all estimated future cash flows is less than the carrying value of the asset, then the asset would be considered impaired and would have to be written down to its fair value. Once an asset is written down, it may only be written back up under very few circumstances. Usually the company uses the sum of undiscounted future cash flows to determine if the impairment should occur, and uses the sum of discounted future cash flows to make the impairment judgment. The impairment decision emphasizes on capital assets' future profit collection ability."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Premium might contain a portion of the amount that has been paid in advance for insurance that has not yet been provided, which is called unearned premium. If either party cancels the contract, the insurer must have the unearned premium ready to refund. Hence, the amount of premium reserve maintained by insurers is called unearned premium reserves, which is prepared for liquidation. This item is usually only available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InsuranceAndClaimsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Insurance and claims are the expenses in the period incurred with respect to protection provided by insurance entities against risks other than risks associated with production (which is allocated to cost of sales). This item is usually not available for insurance industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestExpenseForDepositIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Includes interest expense on the following deposit accounts: Interest-bearing Demand deposit; Checking account; Savings account; Deposit in foreign offices; Money Market Certificates & Deposit Accounts. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gross expenses on the purchase of Federal funds at a specified price with a simultaneous agreement to sell the same to the same counterparty at a fixed or determinable price at a future date. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate interest expenses incurred on long-term borrowings and any interest expenses on fixed assets (property, plant, equipment) that are leased due longer than one year. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestExpenseForShortTermDebtIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate interest expenses incurred on short-term borrowings and any interest expenses on fixed assets (property, plant, equipment) that are leased within one year. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestIncomeFromDepositsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Interest income generated from all deposit accounts. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to resell the identical security purchased or a security that meets the definition of ""substantially the same"" in the case of a dollar roll. Also includes purchases of participations in pools of securities that are subject to a resale agreement; This category includes all interest income generated from federal funds sold and securities purchases under agreements to resell; This category includes all interest income generated from federal funds sold and securities purchases under agreements to resell."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestIncomeFromLeasesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Includes interest and fee income generated by direct lease financing. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestIncomeFromLoansIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Loan is a common field to banks. Interest Income from Loans is interest and fee income generated from all loans, which includes Commercial loans; Credit loans; Other consumer loans; Real Estate - Construction; Real Estate - Mortgage; Foreign loans. Banks earn interest from loans. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestIncomeFromLoansAndLeaseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total interest and fee income generated by loans and lease. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestIncomeFromSecuritiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents total interest and dividend income from U.S. Treasury securities, U.S. government agency and corporation obligations, securities issued by states and political subdivisions, other domestic debt securities, foreign debt securities, and equity securities (including investments in mutual funds). Excludes interest income from securities held in trading accounts. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InvestmentBankingProfitIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Includes (1) underwriting revenue (the spread between the resale price received and the cost of the securities and related expenses) generated through the purchasing, distributing and reselling of new issues of securities (alternatively, could be a secondary offering of a large block of previously issued securities); and (2) fees earned for mergers, acquisitions, divestitures, restructurings, and other types of financial advisory services. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class MaintenanceAndRepairsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of maintenance and repair expenses in the current period associated with the revenue generation. Mainly for fixed assets. This item is usually only available for transportation industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetForeignExchangeGainLossIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate foreign currency translation gain or loss (both realized and unrealized) included as part of revenue. This item is usually only available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetOccupancyExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Occupancy expense may include items, such as depreciation of facilities and equipment, lease expenses, property taxes and property and casualty insurance expense. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetPremiumsWrittenIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net premiums written are gross premiums written less ceded premiums. This item is usually only available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetRealizedGainLossOnInvestmentsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain or loss realized during the period of time for all kinds of investment securities. In might include trading, available-for-sale, or held-to-maturity securities. This item is usually only available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OccupancyAndEquipmentIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Includes total expenses of occupancy and equipment. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OperationAndMaintenanceIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of operation and maintenance expenses, which is the one important operating expense for the utility industry. It includes any costs related to production and maintenance cost of the property during the revenue generation process. This item is usually only available for mining and utility industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherCustomerServicesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents fees and commissions earned from provide other services. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherInterestExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All other interest expense that is not otherwise classified"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherInterestIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All other interest income that is not otherwise classified"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherNonInterestExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All other non interest expense that is not otherwise classified"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherSpecialChargesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All other special charges that are not otherwise classified"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherTaxesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Any taxes that are not part of income taxes. This item is usually not available for bank and insurance industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PolicyholderBenefitsCededIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The provision in current period for future policy benefits, claims, and claims settlement, which is under reinsurance arrangements. This item is usually only available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PolicyholderBenefitsGrossIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The gross amount of provision in current period for future policyholder benefits, claims, and claims settlement, incurred in the claims settlement process before the effects of reinsurance arrangements. This item is usually only available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PolicyholderDividendsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Payments made or credits extended to the insured by the company, usually at the end of a policy year results in reducing the net insurance cost to the policyholder. Such dividends may be paid in cash to the insured or applied by the insured as reductions of the premiums due for the next policy year. This item is usually only available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PolicyholderInterestIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The periodic income payment provided to the annuitant by the insurance company, which is determined by the assumed interest rate (AIR) and other factors. This item is usually only available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ProfessionalExpenseAndContractServicesExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Professional and contract service expense includes cost reimbursements for support services related to contracted projects, outsourced management, technical and staff support. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ProvisionForDoubtfulAccountsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amount of the current period expense charged against operations, the offset which is generally to the allowance for doubtful accounts for the purpose of reducing receivables, including notes receivable, to an amount that approximates their net realizable value (the amount expected to be collected). The category includes provision for loan losses, provision for any doubtful account receivable, and bad debt expenses. This item is usually not available for bank and insurance industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RentAndLandingFeesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Rent fees are the cost of occupying space during the accounting PeriodAsByte. Landing fees are a change paid to an airport company for landing at a particular airport. This item is not available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RestructuringAndMergernAcquisitionIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Expenses are related to restructuring, merger, or acquisitions. Restructuring expenses are charges associated with the consolidation and relocation of operations, disposition or abandonment of operations or productive assets. Merger and acquisition expenses are the amount of costs of a business combination including legal, accounting, and other costs that were charged to expense during the PeriodAsByte."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SalariesAndWagesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All salary, wages, compensation, management fees, and employee benefit expenses."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SecuritiesActivitiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Loss from Securities and Activities"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ServiceChargeOnDepositorAccountsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Includes any service charges on following accounts: Demand Deposit; Checking account; Savings account; Deposit in foreign offices; ESCROW accounts; Money Market Certificates & Deposit accounts, CDs (Negotiable Certificates of Deposits); NOW Accounts (Negotiable Order of Withdrawal); IRAs (Individual Retirement Accounts). This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TradingGainLossIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A broker-dealer or other financial entity may buy and sell securities exclusively for its own account, sometimes referred to as proprietary trading. The profit or loss is measured by the difference between the acquisition cost and the selling price or current market or fair value. The net gain or loss, includes both realized and unrealized, from trading cash instruments, equities and derivative contracts (including commodity contracts) that has been recognized during the accounting period for the broker dealer or other financial entity's own account. This item is typically available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TrustFeesbyCommissionsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Bank manages funds on behalf of its customers through the operation of various trust accounts. Any fees earned through managing those funds are called trust fees, which are recognized when earned. This item is typically available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class UnderwritingExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Also known as Policy Acquisition Costs; and reported by insurance companies. The cost incurred by an insurer when deciding whether to accept or decline a risk; may include meetings with the insureds or brokers, actuarial review of loss history, or physical inspections of exposures. Also, expenses deducted from insurance company revenues (including incurred losses and acquisition costs) to determine underwriting profit."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class WriteOffIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A reduction in the value of an asset or earnings by the amount of an expense or loss."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherNonInterestIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Usually available for the banking industry. This is Non-Interest Income that is not otherwise classified."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AmortizationOfIntangiblesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate expense charged against earnings to allocate the cost of intangible assets (nonphysical assets not used in production) in a systematic and rational manner to the periods expected to benefit from such assets."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net Income from Continuing Operations and Discontinued Operations, added together."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetIncomeFromTaxLossCarryforwardIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Occurs if a company has had a net loss from operations on a previous year that can be carried forward to reduce net income for tax purposes."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherOperatingExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of operating expenses associated with normal operations. Will not include any gain, loss, benefit, or income; and its value reported by the company should be <0."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalMoneyMarketInvestmentsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The sum of the money market investments held by a bank's depositors, which are FDIC insured."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ReconciledCostOfRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The Cost Of Revenue plus Depreciation, Depletion & Amortization from the IncomeStatement; minus Depreciation, Depletion & Amortization from the Cash Flow Statement"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ReconciledDepreciationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Is Depreciation, Depletion & Amortization from the Cash Flow Statement"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NormalizedIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This calculation represents earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly measure a company's profitability. This is calculated using Net Income from Continuing Operations plus/minus any tax affected unusual Items and Goodwill Impairments/Write Offs."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from: Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing Operation; Income from Tax Loss Carry forward; Other Gains/Losses."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GainLossonSaleofAssetsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Any gain (loss) recognized on the sale of assets or a sale which generates profit or loss, which is a difference between sales price and net book value at the disposal time."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GainonSaleofLoansIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain on sale of any loans investment."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GainonSaleofInvestmentPropertyIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain on the disposal of investment property."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LossonExtinguishmentofDebtIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Loss on extinguishment of debt is the accounting loss that results from a debt extinguishment. A debt shall be accounted for as having been extinguished in a number of circumstances, including when it has been settled through repayment or replacement by another liability. It generally results in an accounting gain or loss. Amount represents the difference between the fair value of the payments made and the carrying amount of the debt at the time of its extinguishment."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class EarningsfromEquityInterestNetOfTaxIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income from other equity interest reported after Provision of Tax. This applies to all industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetIncomeIncludingNoncontrollingInterestsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net income of the group after the adjustment of all expenses and benefit."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherunderPreferredStockDividendIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Dividend paid to the preferred shareholders before the common stock shareholders."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class StaffCostsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total staff cost which is paid to the employees that is not part of Selling, General, and Administration expense."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SocialSecurityCostsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Benefits paid to the employees in respect of their work."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PensionCostsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The expense that a company incurs each year by providing a pension plan for its employees. Major expenses in the pension cost include employer matching contributions and management fees."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherOperatingIncomeTotalIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total Other Operating Income- including interest income, dividend income and other types of operating income."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total income from the associates and joint venture via investment, accounted for in the Non-Operating section."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalOtherFinanceCostIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Any other finance cost which is not clearly defined in the Non-Operating section."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GrossDividendPaymentIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total amount paid in dividends to investors- this includes dividends paid on equity and non-equity shares."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FeesandCommissionIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Fees and commission income earned by bank and insurance companies on the rendering services."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FeesandCommissionExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Cost incurred by bank and insurance companies for fees and commission income."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetTradingIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Any trading income on the securities."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherStaffCostsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other costs in incurred in lieu of the employees that cannot be identified by other specific items in the Staff Costs section."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GainonInvestmentPropertiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain on disposal and change in fair value of investment properties."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AverageDilutionEarningsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Adjustments to reported net income to calculate Diluted EPS, by assuming that all convertible instruments are converted to Common Equity. The adjustments usually include the interest expense of debentures when assumed converted and preferred dividends of convertible preferred stock when assumed converted."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain/Loss through hedging activities."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain/loss on the write-off of financial assets available-for-sale."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NegativeGoodwillImmediatelyRecognizedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Negative Goodwill recognized in the Income Statement. Negative Goodwill arises where the net assets at the date of acquisition, fairly valued, falls below the cost of acquisition."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain or loss on derivatives investment due to the fair value adjustment."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Impairment or reversal of impairment on financial instrument such as derivative. This is a contra account under Total Revenue in banks."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ClaimsandPaidIncurredIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All reported claims arising out of incidents in that year are considered incurred grouped with claims paid out."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Claim on the reinsurance company and take the benefits."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Expense due to changes between periods in insurance liabilities."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ChangeinInvestmentContractIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Expense due to changes between periods in Investment Contracts."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CreditRiskProvisionsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Provision for the risk of loss of principal or loss of a financial reward stemming from a borrower's failure to repay a loan or otherwise meet a contractual obligation. Credit risk arises whenever a borrower is expecting to use future cash flows to pay a current debt. Investors are compensated for assuming credit risk by way of interest payments from the borrower or issuer of a debt obligation. This is a contra account under Total Revenue in banks."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class WagesandSalariesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This is the portion under Staff Costs that represents salary paid to the employees in respect of their work."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherNonOperatingIncomeExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total other income and expense of the company that cannot be identified by other specific items in the Non-Operating section."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherNonOperatingIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other income of the company that cannot be identified by other specific items in the Non-Operating section."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherNonOperatingExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other expenses of the company that cannot be identified by other specific items in the Non-Operating section."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalUnusualItemsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total unusual items including Negative Goodwill."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalUnusualItemsExcludingGoodwillIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The sum of all the identifiable operating and non-operating unusual items."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TaxRateForCalcsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Tax rate used for Morningstar calculations."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TaxEffectOfUnusualItemsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Tax effect of the usual items"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NormalizedEBITDAIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """EBITDA less Total Unusual Items"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class StockBasedCompensationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The cost to the company for granting stock options to reward employees."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DilutedNIAvailtoComStockholdersIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net income to calculate Diluted EPS, accounting for adjustments assuming that all the convertible instruments are being converted to Common Equity."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InvestmentContractLiabilitiesIncurredIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Expenses due to the insurer's liabilities incurred in Investment Contracts."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ReinsuranceRecoveriesofInvestmentContractIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Expense due to recoveries from reinsurers for Investment Contracts."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalDividendPaymentofEquitySharesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total amount paid in dividends to equity securities investors."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalDividendPaymentofNonEquitySharesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total amount paid in dividends to Non-Equity securities investors."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The change in the amount of the unearned premium reserves maintained by insurers."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The change in the amount of unearned premium reserve to be covered by reinsurers."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ClaimsandChangeinInsuranceLiabilitiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Expense due to the insurer's changes in insurance liabilities."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Expense due to recoveries from reinsurers for insurance liabilities."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalOperatingIncomeAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Operating profit/loss as reported by the company, may be the same or not the same as Morningstar's standardized definition."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherGAIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other General and Administrative Expenses not categorized that the company incurs that are not directly tied to a specific function such as manufacturing, production, or sales."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherCostofRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other costs associated with the revenue-generating activities of the company not categorized above."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RentandLandingFeesCostofRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Costs paid to use the facilities necessary to generate revenue during the accounting PeriodAsByte."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DDACostofRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Costs of depreciation and amortization on assets used for the revenue-generating activities during the accounting period"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RentExpenseSupplementalIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The sum of all rent expenses incurred by the company for operating leases during the year, it is a supplemental value which would be reported outside consolidated statements or consolidated statement's footnotes."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NormalizedPreTaxIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This calculation represents pre-tax earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly measure a company's profitability. This is calculated using Pre-Tax Income plus/minus any unusual Items and Goodwill Impairments/Write Offs."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ResearchAndDevelopmentExpensesSupplementalIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of research and development expenses during the year. It is a supplemental value which would be reported outside consolidated statements."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DepreciationSupplementalIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The current period expense charged against earnings on tangible asset over its useful life. It is a supplemental value which would be reported outside consolidated statements."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AmortizationSupplementalIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The current period expense charged against earnings on intangible asset over its useful life. It is a supplemental value which would be reported outside consolidated statements."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalRevenueAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total revenue as reported by the company, may be the same or not the same as Morningstar's standardized definition."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OperatingExpenseAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Operating expense as reported by the company, may be the same or not the same as Morningstar's standardized definition."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NormalizedIncomeAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly measure a company's profitability. This is as reported by the company, may be the same or not the same as Morningstar's standardized definition."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NormalizedEBITDAAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """EBITDA less Total Unusual Items. This is as reported by the company, may be the same or not the same as Morningstar's standardized definition."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NormalizedEBITAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """EBIT less Total Unusual Items. This is as reported by the company, may be the same or not the same as Morningstar's standardized definition."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NormalizedOperatingProfitAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Operating profit adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly measure a company's profitability. This is as reported by the company, may be the same or not the same as Morningstar's standardized definition."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class EffectiveTaxRateAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The average tax rate for the period as reported by the company, may be the same or not the same as Morningstar's standardized definition."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class IncomeStatement(ReusuableCLRObject):
    """Definition of the IncomeStatement class"""

    @property
    def is_file_date(self) -> QuantConnect.Data.Fundamental.IncomeStatementFileDate:
        """Filing date of the Income Statement."""
        ...

    @property
    def amortization(self) -> QuantConnect.Data.Fundamental.AmortizationIncomeStatement:
        """The non-cash expense recognized on intangible assets over the benefit period of the asset."""
        ...

    @property
    def securities_amortization(self) -> QuantConnect.Data.Fundamental.SecuritiesAmortizationIncomeStatement:
        """The gradual elimination of a liability, such as a mortgage, in regular payments over a specified period of time. Such payments must be sufficient to cover both principal and interest."""
        ...

    @property
    def cost_of_revenue(self) -> QuantConnect.Data.Fundamental.CostOfRevenueIncomeStatement:
        """The aggregate cost of goods produced and sold and services rendered during the reporting period. It excludes all operating expenses such as depreciation, depletion, amortization, and SG&A. For the must have cost industry, if the number is not reported by the company, it will be calculated based on accounting equation. Cost of Revenue = Revenue - Operating Expenses - Operating Profit."""
        ...

    @property
    def depletion(self) -> QuantConnect.Data.Fundamental.DepletionIncomeStatement:
        """The non-cash expense recognized on natural resources (eg. Oil and mineral deposits) over the benefit period of the asset."""
        ...

    @property
    def depreciation(self) -> QuantConnect.Data.Fundamental.DepreciationIncomeStatement:
        """The current period non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of assets over their useful lives, in the Income Statement. Examples of tangible asset include buildings, production and equipment."""
        ...

    @property
    def depreciation_and_amortization(self) -> QuantConnect.Data.Fundamental.DepreciationAndAmortizationIncomeStatement:
        """The sum of depreciation and amortization expense in the Income Statement. Depreciation is the non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of assets over their useful lives Amortization is the non-cash expense recognized on intangible assets over the benefit period of the asset."""
        ...

    @property
    def depreciation_amortization_depletion(self) -> QuantConnect.Data.Fundamental.DepreciationAmortizationDepletionIncomeStatement:
        """The sum of depreciation, amortization and depletion expense in the Income Statement. Depreciation is the non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of assets over their useful lives Amortization is the non-cash expense recognized on intangible assets over the benefit period of the asset. Depletion is the non-cash expense recognized on natural resources (eg. Oil and mineral deposits) over the benefit period of the asset."""
        ...

    @property
    def net_income_discontinuous_operations(self) -> QuantConnect.Data.Fundamental.NetIncomeDiscontinuousOperationsIncomeStatement:
        """To be classified as discontinued operations, if both of the following conditions are met: 1: The operations and cash flow of the component have been or will be removed from the ongoing operations of the entity as a result of the disposal transaction, and 2: The entity will have no significant continuing involvement in the operations of the component after the disposal transaction. The discontinued operation is reported net of tax. Gains/Loss on Disposal of Discontinued Operations: Any gains or loss recognized on disposal of discontinued operations, which is the difference between the carrying value of the division and its fair value less costs to sell. Provision for Gain/Loss on Disposal: The amount of current expense charged in order to prepare for the disposal of discontinued operations."""
        ...

    @property
    def excise_taxes(self) -> QuantConnect.Data.Fundamental.ExciseTaxesIncomeStatement:
        """Excise taxes are taxes paid when purchases are made on a specific good, such as gasoline. Excise taxes are often included in the price of the product. There are also excise taxes on activities, such as on wagering or on highway usage by trucks."""
        ...

    @property
    def net_income_extraordinary(self) -> QuantConnect.Data.Fundamental.NetIncomeExtraordinaryIncomeStatement:
        """Gains (losses), whether arising from extinguishment of debt, prior period adjustments, or from other events or transactions, that are both unusual in nature and infrequent in occurrence thereby meeting the criteria for an event or transaction to be classified as an extraordinary item."""
        ...

    @property
    def fee_revenue_and_other_income(self) -> QuantConnect.Data.Fundamental.FeeRevenueAndOtherIncomeIncomeStatement:
        """The aggregate amount of fees, commissions, and other income."""
        ...

    @property
    def general_and_administrative_expense(self) -> QuantConnect.Data.Fundamental.GeneralAndAdministrativeExpenseIncomeStatement:
        """The aggregate total of general managing and administering expenses for the company."""
        ...

    @property
    def gross_profit(self) -> QuantConnect.Data.Fundamental.GrossProfitIncomeStatement:
        """Total revenue less cost of revenue. The number is as reported by the company on the income statement; however, the number will be calculated if it is not reported. This field is null if the cost of revenue is not given. Gross Profit = Total Revenue - Cost of Revenue."""
        ...

    @property
    def interest_expense(self) -> QuantConnect.Data.Fundamental.InterestExpenseIncomeStatement:
        """Relates to the general cost of borrowing money. It is the price that a lender charges a borrower for the use of the lender's money."""
        ...

    @property
    def interest_expense_non_operating(self) -> QuantConnect.Data.Fundamental.InterestExpenseNonOperatingIncomeStatement:
        """Interest expense caused by long term financing activities; such as interest expense incurred on trading liabilities, commercial paper, long-term debt, capital leases, deposits, and all other borrowings."""
        ...

    @property
    def interest_income_after_provision_for_loan_loss(self) -> QuantConnect.Data.Fundamental.InterestIncomeAfterProvisionForLoanLossIncomeStatement:
        """Net interest and dividend income or expense, including any amortization and accretion (as applicable) of discounts and premiums, including consideration of the provisions for loan, lease, credit, and other related losses, if any."""
        ...

    @property
    def interest_income_non_operating(self) -> QuantConnect.Data.Fundamental.InterestIncomeNonOperatingIncomeStatement:
        """Interest income earned from long term financing activities."""
        ...

    @property
    def net_non_operating_interest_income_expense(self) -> QuantConnect.Data.Fundamental.NetNonOperatingInterestIncomeExpenseIncomeStatement:
        """Net-Non Operating interest income or expenses caused by financing activities."""
        ...

    @property
    def loss_adjustment_expense(self) -> QuantConnect.Data.Fundamental.LossAdjustmentExpenseIncomeStatement:
        """Losses generally refer to (1) the amount of reduction in the value of an insured's property caused by an insured peril, (2) the amount sought through an insured's claim, or (3) the amount paid on behalf of an insured under an insurance contract. Loss Adjustment Expenses is expenses incurred in the course of investigating and settling claims that includes any legal and adjusters' fees and the costs of paying claims and all related expenses."""
        ...

    @property
    def minority_interests(self) -> QuantConnect.Data.Fundamental.MinorityInterestsIncomeStatement:
        """Represents par or stated value of the subsidiary stock not owned by the parent company plus the minority interest's equity in the surplus of the subsidiary. This item includes preferred dividend averages on the minority preferred stock (preferred shares not owned by the reporting parent company). Minority interest also refers to stockholders who own less than 50% of a subsidiary's outstanding voting common stock. The minority stockholders hold an interest in the subsidiary's net assets and share earnings with the parent company."""
        ...

    @property
    def net_income(self) -> QuantConnect.Data.Fundamental.NetIncomeIncomeStatement:
        """Includes all the operations (continuing and discontinued) and all the other income or charges (extraordinary, accounting changes, tax loss carry forward, and other gains and losses)."""
        ...

    @property
    def net_income_common_stockholders(self) -> QuantConnect.Data.Fundamental.NetIncomeCommonStockholdersIncomeStatement:
        """Net income minus the preferred dividends paid as presented in the Income Statement."""
        ...

    @property
    def net_income_continuous_operations(self) -> QuantConnect.Data.Fundamental.NetIncomeContinuousOperationsIncomeStatement:
        """Revenue less expenses and taxes from the entity's ongoing operations and before income (loss) from: Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing Operation; Income from Tax Loss Carry forward; Other Gains/Losses."""
        ...

    @property
    def net_interest_income(self) -> QuantConnect.Data.Fundamental.NetInterestIncomeIncomeStatement:
        """Total interest income minus total interest expense. It represents the difference between interest and dividends earned on interest- bearing assets and interest paid to depositors and other creditors."""
        ...

    @property
    def net_investment_income(self) -> QuantConnect.Data.Fundamental.NetInvestmentIncomeIncomeStatement:
        """Total of interest, dividends, and other earnings derived from the insurance company's invested assets minus the expenses associated with these investments. Excluded from this income are capital gains or losses as the result of the sale of assets, as well as any unrealized capital gains or losses."""
        ...

    @property
    def total_revenue(self) -> QuantConnect.Data.Fundamental.TotalRevenueIncomeStatement:
        """All sales, business revenues and income that the company makes from its business operations, net of excise taxes. This applies for all companies and can be used as comparison for all industries. For Normal, Mining, Transportation and Utility templates companies, this is the sum of Operating Revenues, Excise Taxes and Fees. For Bank template companies, this is the sum of Net Interest Income and Non-Interest Income. For Insurance template companies, this is the sum of Premiums, Interest Income, Fees, Investment and Other Income."""
        ...

    @property
    def non_interest_expense(self) -> QuantConnect.Data.Fundamental.NonInterestExpenseIncomeStatement:
        """Any expenses that not related to interest. It includes labor and related expense, occupancy and equipment, commission, professional expense and contract services expenses, selling, general and administrative, research and development depreciation, amortization and depletion, and any other special income/charges."""
        ...

    @property
    def non_interest_income(self) -> QuantConnect.Data.Fundamental.NonInterestIncomeIncomeStatement:
        """The total amount of non-interest income which may be derived from: (1) fees and commissions; (2) premiums earned; (3) equity investment; (4) the sale or disposal of assets; and (5) other sources not otherwise specified."""
        ...

    @property
    def operating_expense(self) -> QuantConnect.Data.Fundamental.OperatingExpenseIncomeStatement:
        """Operating expenses are primary recurring costs associated with central operations (other than cost of goods sold) that are incurred in order to generate sales."""
        ...

    @property
    def operating_income(self) -> QuantConnect.Data.Fundamental.OperatingIncomeIncomeStatement:
        """Income from normal business operations after deducting cost of revenue and operating expenses. It does not include income from any investing activities."""
        ...

    @property
    def operating_revenue(self) -> QuantConnect.Data.Fundamental.OperatingRevenueIncomeStatement:
        """Sales and income that the company makes from its business operations. This applies only to non-bank and insurance companies. For Utility template companies, this is the sum of revenue from electric, gas, transportation and other operating revenue. For Transportation template companies, this is the sum of revenue-passenger, revenue-cargo, and other operating revenue."""
        ...

    @property
    def other_income_expense(self) -> QuantConnect.Data.Fundamental.OtherIncomeExpenseIncomeStatement:
        """Income or expense that comes from miscellaneous sources."""
        ...

    @property
    def policy_acquisition_expense(self) -> QuantConnect.Data.Fundamental.PolicyAcquisitionExpenseIncomeStatement:
        """Costs that vary with and are primarily related to the acquisition of new and renewal insurance contracts. Also referred to as underwriting expenses."""
        ...

    @property
    def net_policyholder_benefits_and_claims(self) -> QuantConnect.Data.Fundamental.NetPolicyholderBenefitsAndClaimsIncomeStatement:
        """The net provision in current period for future policy benefits, claims, and claims settlement expenses incurred in the claims settlement process before the effects of reinsurance arrangements. The value is net of the effects of contracts assumed and ceded."""
        ...

    @property
    def preferred_stock_dividends(self) -> QuantConnect.Data.Fundamental.PreferredStockDividendsIncomeStatement:
        """The amount of dividends declared or paid in the period to preferred shareholders, or the amount for which the obligation to pay them dividends arose in the period. Preferred dividends are the amount required for the current year only, and not for any amount required in past years."""
        ...

    @property
    def total_premiums_earned(self) -> QuantConnect.Data.Fundamental.TotalPremiumsEarnedIncomeStatement:
        """Premiums earned is the portion of an insurance written premium which is considered "earned" by the insurer, based on the part of the policy period that the insurance has been in effect, and during which the insurer has been exposed to loss."""
        ...

    @property
    def pretax_income(self) -> QuantConnect.Data.Fundamental.PretaxIncomeIncomeStatement:
        """Reported income before the deduction or benefit of income taxes."""
        ...

    @property
    def tax_provision(self) -> QuantConnect.Data.Fundamental.TaxProvisionIncomeStatement:
        """Include any taxes on income, net of any investment tax credits for the current accounting period."""
        ...

    @property
    def credit_losses_provision(self) -> QuantConnect.Data.Fundamental.CreditLossesProvisionIncomeStatement:
        """A charge to income which represents an expense deemed adequate by management given the composition of a bank's credit portfolios, their probability of default, the economic environment and the allowance for credit losses already established. Specific provisions are established to reduce the book value of specific assets (primarily loans) to establish the amount expected to be recovered on the loans."""
        ...

    @property
    def research_and_development(self) -> QuantConnect.Data.Fundamental.ResearchAndDevelopmentIncomeStatement:
        """The aggregate amount of research and development expenses during the year."""
        ...

    @property
    def selling_and_marketing_expense(self) -> QuantConnect.Data.Fundamental.SellingAndMarketingExpenseIncomeStatement:
        """The aggregate total amount of expenses directly related to the marketing or selling of products or services."""
        ...

    @property
    def selling_general_and_administration(self) -> QuantConnect.Data.Fundamental.SellingGeneralAndAdministrationIncomeStatement:
        """The aggregate total costs related to selling a firm's product and services, as well as all other general and administrative expenses. Selling expenses are those directly related to the company's efforts to generate sales (e.g., sales salaries, commissions, advertising, delivery expenses). General and administrative expenses are expenses related to general administration of the company's operation (e.g., officers and office salaries, office supplies, telephone, accounting and legal services, and business licenses and fees)."""
        ...

    @property
    def special_income_charges(self) -> QuantConnect.Data.Fundamental.SpecialIncomeChargesIncomeStatement:
        """Earnings or losses attributable to occurrences or actions by the firm that is either infrequent or unusual."""
        ...

    @property
    def total_expenses(self) -> QuantConnect.Data.Fundamental.TotalExpensesIncomeStatement:
        """The sum of operating expense and cost of revenue. If the company does not give the reported number, it will be calculated by adding operating expense and cost of revenue."""
        ...

    @property
    def interest_income(self) -> QuantConnect.Data.Fundamental.InterestIncomeIncomeStatement:
        """Income generated from interest-bearing deposits or accounts."""
        ...

    @property
    def ebit(self) -> QuantConnect.Data.Fundamental.EBITIncomeStatement:
        """Earnings minus expenses (excluding interest and tax expenses)."""
        ...

    @property
    def ebitda(self) -> QuantConnect.Data.Fundamental.EBITDAIncomeStatement:
        """Earnings minus expenses (excluding interest, tax, depreciation, and amortization expenses)."""
        ...

    @property
    def net_income_continuous_operations_net_minority_interest(self) -> QuantConnect.Data.Fundamental.NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement:
        """Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from: Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing Operation; Income from Tax Loss Carry forward; Other Gains/Losses."""
        ...

    @property
    def ceded_premiums(self) -> QuantConnect.Data.Fundamental.CededPremiumsIncomeStatement:
        """The amount of premiums paid and payable to another insurer as a result of reinsurance arrangements in order to exchange for that company accepting all or part of insurance on a risk or exposure. This item is usually only available for insurance industry."""
        ...

    @property
    def commission_expenses(self) -> QuantConnect.Data.Fundamental.CommissionExpensesIncomeStatement:
        """Morningstar DataId: 20202"""
        ...

    @property
    def credit_card(self) -> QuantConnect.Data.Fundamental.CreditCardIncomeStatement:
        """Income earned from credit card services including late, over limit, and annual fees. This item is usually only available for bank industry."""
        ...

    @property
    def dividend_income(self) -> QuantConnect.Data.Fundamental.DividendIncomeIncomeStatement:
        """Dividends earned from equity investment securities. This item is usually only available for bank industry."""
        ...

    @property
    def earnings_from_equity_interest(self) -> QuantConnect.Data.Fundamental.EarningsFromEquityInterestIncomeStatement:
        """The earnings from equity interest can be a result of any of the following: Income from earnings distribution of the business, either as dividends paid to corporate shareholders or as drawings in a partnership; Capital gain realized upon sale of the business; Capital gain realized from selling his or her interest to other partners. This item is usually not available for bank and insurance industries."""
        ...

    @property
    def equipment(self) -> QuantConnect.Data.Fundamental.EquipmentIncomeStatement:
        """Equipment expenses include depreciation, repairs, rentals, and service contract costs. This also includes equipment purchases which do not qualify for capitalization in accordance with the entity's accounting policy. This item may also include furniture expenses. This item is usually only available for bank industry."""
        ...

    @property
    def exploration_development_and_mineral_property_lease_expenses(self) -> QuantConnect.Data.Fundamental.ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement:
        """Costs incurred in identifying areas that may warrant examination and in examining specific areas that are considered to have prospects of containing energy or metal reserves, including costs of drilling exploratory wells. Development expense is the capitalized costs incurred to obtain access to proved reserves and to provide facilities for extracting, treating, gathering and storing the energy and metal. Mineral property includes oil and gas wells, mines, and other natural deposits (including geothermal deposits). The payment for leasing those properties is called mineral property lease expense. Exploration expense is included in operation expenses for mining industry."""
        ...

    @property
    def fees_and_commissions(self) -> QuantConnect.Data.Fundamental.FeesAndCommissionsIncomeStatement:
        """Total fees and commissions earned from providing services such as leasing of space or maintaining: (1) depositor accounts; (2) transfer agent; (3) fiduciary and trust; (4) brokerage and underwriting; (5) mortgage; (6) credit cards; (7) correspondent clearing; and (8) other such services and activities performed for others. This item is usually available for bank and insurance industries."""
        ...

    @property
    def foreign_exchange_trading_gains(self) -> QuantConnect.Data.Fundamental.ForeignExchangeTradingGainsIncomeStatement:
        """Trading revenues that result from foreign exchange exposures such as cash instruments and off-balance sheet derivative instruments. This item is usually only available for bank industry."""
        ...

    @property
    def fuel(self) -> QuantConnect.Data.Fundamental.FuelIncomeStatement:
        """The aggregate amount of fuel cost for current period associated with the revenue generation. This item is usually only available for transportation industry."""
        ...

    @property
    def fuel_and_purchase_power(self) -> QuantConnect.Data.Fundamental.FuelAndPurchasePowerIncomeStatement:
        """Cost of fuel, purchase power and gas associated with revenue generation. This item is usually only available for utility industry."""
        ...

    @property
    def gain_on_sale_of_business(self) -> QuantConnect.Data.Fundamental.GainOnSaleOfBusinessIncomeStatement:
        """The amount of excess earned in comparison to fair value when selling a business. This item is usually not available for insurance industry."""
        ...

    @property
    def gain_on_sale_of_ppe(self) -> QuantConnect.Data.Fundamental.GainOnSaleOfPPEIncomeStatement:
        """The amount of excess earned in comparison to the net book value for sale of property, plant, equipment. This item is usually not available for bank and insurance industries."""
        ...

    @property
    def gain_on_sale_of_security(self) -> QuantConnect.Data.Fundamental.GainOnSaleOfSecurityIncomeStatement:
        """The amount of excess earned in comparison to the original purchase value of the security."""
        ...

    @property
    def gross_premiums_written(self) -> QuantConnect.Data.Fundamental.GrossPremiumsWrittenIncomeStatement:
        """Total premiums generated from all policies written by an insurance company within a given period of time. This item is usually only available for insurance industry."""
        ...

    @property
    def impairment_of_capital_assets(self) -> QuantConnect.Data.Fundamental.ImpairmentOfCapitalAssetsIncomeStatement:
        """Impairments are considered to be permanent, which is a downward revaluation of fixed assets. If the sum of all estimated future cash flows is less than the carrying value of the asset, then the asset would be considered impaired and would have to be written down to its fair value. Once an asset is written down, it may only be written back up under very few circumstances. Usually the company uses the sum of undiscounted future cash flows to determine if the impairment should occur, and uses the sum of discounted future cash flows to make the impairment judgment. The impairment decision emphasizes on capital assets' future profit collection ability."""
        ...

    @property
    def increase_decrease_in_net_unearned_premium_reserves(self) -> QuantConnect.Data.Fundamental.IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement:
        """Premium might contain a portion of the amount that has been paid in advance for insurance that has not yet been provided, which is called unearned premium. If either party cancels the contract, the insurer must have the unearned premium ready to refund. Hence, the amount of premium reserve maintained by insurers is called unearned premium reserves, which is prepared for liquidation. This item is usually only available for insurance industry."""
        ...

    @property
    def insurance_and_claims(self) -> QuantConnect.Data.Fundamental.InsuranceAndClaimsIncomeStatement:
        """Insurance and claims are the expenses in the period incurred with respect to protection provided by insurance entities against risks other than risks associated with production (which is allocated to cost of sales). This item is usually not available for insurance industries."""
        ...

    @property
    def interest_expense_for_deposit(self) -> QuantConnect.Data.Fundamental.InterestExpenseForDepositIncomeStatement:
        """Includes interest expense on the following deposit accounts: Interest-bearing Demand deposit; Checking account; Savings account; Deposit in foreign offices; Money Market Certificates & Deposit Accounts. This item is usually only available for bank industry."""
        ...

    @property
    def interest_expense_for_federal_funds_sold_and_securities_purchase_under_agreements_to_resell(self) -> QuantConnect.Data.Fundamental.InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement:
        """Gross expenses on the purchase of Federal funds at a specified price with a simultaneous agreement to sell the same to the same counterparty at a fixed or determinable price at a future date. This item is usually only available for bank industry."""
        ...

    @property
    def interest_expense_for_long_term_debt_and_capital_securities(self) -> QuantConnect.Data.Fundamental.InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement:
        """The aggregate interest expenses incurred on long-term borrowings and any interest expenses on fixed assets (property, plant, equipment) that are leased due longer than one year. This item is usually only available for bank industry."""
        ...

    @property
    def interest_expense_for_short_term_debt(self) -> QuantConnect.Data.Fundamental.InterestExpenseForShortTermDebtIncomeStatement:
        """The aggregate interest expenses incurred on short-term borrowings and any interest expenses on fixed assets (property, plant, equipment) that are leased within one year. This item is usually only available for bank industry."""
        ...

    @property
    def interest_income_from_deposits(self) -> QuantConnect.Data.Fundamental.InterestIncomeFromDepositsIncomeStatement:
        """Interest income generated from all deposit accounts. This item is usually only available for bank industry."""
        ...

    @property
    def interest_income_from_federal_funds_sold_and_securities_purchase_under_agreements_to_resell(self) -> QuantConnect.Data.Fundamental.InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement:
        """The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to resell the identical security purchased or a security that meets the definition of ""substantially the same"" in the case of a dollar roll. Also includes purchases of participations in pools of securities that are subject to a resale agreement; This category includes all interest income generated from federal funds sold and securities purchases under agreements to resell; This category includes all interest income generated from federal funds sold and securities purchases under agreements to resell."""
        ...

    @property
    def interest_income_from_leases(self) -> QuantConnect.Data.Fundamental.InterestIncomeFromLeasesIncomeStatement:
        """Includes interest and fee income generated by direct lease financing. This item is usually only available for bank industry."""
        ...

    @property
    def interest_income_from_loans(self) -> QuantConnect.Data.Fundamental.InterestIncomeFromLoansIncomeStatement:
        """Loan is a common field to banks. Interest Income from Loans is interest and fee income generated from all loans, which includes Commercial loans; Credit loans; Other consumer loans; Real Estate - Construction; Real Estate - Mortgage; Foreign loans. Banks earn interest from loans. This item is usually only available for bank industry."""
        ...

    @property
    def interest_income_from_loans_and_lease(self) -> QuantConnect.Data.Fundamental.InterestIncomeFromLoansAndLeaseIncomeStatement:
        """Total interest and fee income generated by loans and lease. This item is usually only available for bank industry."""
        ...

    @property
    def interest_income_from_securities(self) -> QuantConnect.Data.Fundamental.InterestIncomeFromSecuritiesIncomeStatement:
        """Represents total interest and dividend income from U.S. Treasury securities, U.S. government agency and corporation obligations, securities issued by states and political subdivisions, other domestic debt securities, foreign debt securities, and equity securities (including investments in mutual funds). Excludes interest income from securities held in trading accounts. This item is usually only available for bank industry."""
        ...

    @property
    def investment_banking_profit(self) -> QuantConnect.Data.Fundamental.InvestmentBankingProfitIncomeStatement:
        """Includes (1) underwriting revenue (the spread between the resale price received and the cost of the securities and related expenses) generated through the purchasing, distributing and reselling of new issues of securities (alternatively, could be a secondary offering of a large block of previously issued securities); and (2) fees earned for mergers, acquisitions, divestitures, restructurings, and other types of financial advisory services. This item is usually only available for bank industry."""
        ...

    @property
    def maintenance_and_repairs(self) -> QuantConnect.Data.Fundamental.MaintenanceAndRepairsIncomeStatement:
        """The aggregate amount of maintenance and repair expenses in the current period associated with the revenue generation. Mainly for fixed assets. This item is usually only available for transportation industry."""
        ...

    @property
    def net_foreign_exchange_gain_loss(self) -> QuantConnect.Data.Fundamental.NetForeignExchangeGainLossIncomeStatement:
        """The aggregate foreign currency translation gain or loss (both realized and unrealized) included as part of revenue. This item is usually only available for insurance industry."""
        ...

    @property
    def net_occupancy_expense(self) -> QuantConnect.Data.Fundamental.NetOccupancyExpenseIncomeStatement:
        """Occupancy expense may include items, such as depreciation of facilities and equipment, lease expenses, property taxes and property and casualty insurance expense. This item is usually only available for bank industry."""
        ...

    @property
    def net_premiums_written(self) -> QuantConnect.Data.Fundamental.NetPremiumsWrittenIncomeStatement:
        """Net premiums written are gross premiums written less ceded premiums. This item is usually only available for insurance industry."""
        ...

    @property
    def net_realized_gain_loss_on_investments(self) -> QuantConnect.Data.Fundamental.NetRealizedGainLossOnInvestmentsIncomeStatement:
        """Gain or loss realized during the period of time for all kinds of investment securities. In might include trading, available-for-sale, or held-to-maturity securities. This item is usually only available for insurance industry."""
        ...

    @property
    def occupancy_and_equipment(self) -> QuantConnect.Data.Fundamental.OccupancyAndEquipmentIncomeStatement:
        """Includes total expenses of occupancy and equipment. This item is usually only available for bank industry."""
        ...

    @property
    def operation_and_maintenance(self) -> QuantConnect.Data.Fundamental.OperationAndMaintenanceIncomeStatement:
        """The aggregate amount of operation and maintenance expenses, which is the one important operating expense for the utility industry. It includes any costs related to production and maintenance cost of the property during the revenue generation process. This item is usually only available for mining and utility industries."""
        ...

    @property
    def other_customer_services(self) -> QuantConnect.Data.Fundamental.OtherCustomerServicesIncomeStatement:
        """Represents fees and commissions earned from provide other services. This item is usually only available for bank industry."""
        ...

    @property
    def other_interest_expense(self) -> QuantConnect.Data.Fundamental.OtherInterestExpenseIncomeStatement:
        """All other interest expense that is not otherwise classified"""
        ...

    @property
    def other_interest_income(self) -> QuantConnect.Data.Fundamental.OtherInterestIncomeIncomeStatement:
        """All other interest income that is not otherwise classified"""
        ...

    @property
    def other_non_interest_expense(self) -> QuantConnect.Data.Fundamental.OtherNonInterestExpenseIncomeStatement:
        """All other non interest expense that is not otherwise classified"""
        ...

    @property
    def other_special_charges(self) -> QuantConnect.Data.Fundamental.OtherSpecialChargesIncomeStatement:
        """All other special charges that are not otherwise classified"""
        ...

    @property
    def other_taxes(self) -> QuantConnect.Data.Fundamental.OtherTaxesIncomeStatement:
        """Any taxes that are not part of income taxes. This item is usually not available for bank and insurance industries."""
        ...

    @property
    def policyholder_benefits_ceded(self) -> QuantConnect.Data.Fundamental.PolicyholderBenefitsCededIncomeStatement:
        """The provision in current period for future policy benefits, claims, and claims settlement, which is under reinsurance arrangements. This item is usually only available for insurance industry."""
        ...

    @property
    def policyholder_benefits_gross(self) -> QuantConnect.Data.Fundamental.PolicyholderBenefitsGrossIncomeStatement:
        """The gross amount of provision in current period for future policyholder benefits, claims, and claims settlement, incurred in the claims settlement process before the effects of reinsurance arrangements. This item is usually only available for insurance industry."""
        ...

    @property
    def policyholder_dividends(self) -> QuantConnect.Data.Fundamental.PolicyholderDividendsIncomeStatement:
        """Payments made or credits extended to the insured by the company, usually at the end of a policy year results in reducing the net insurance cost to the policyholder. Such dividends may be paid in cash to the insured or applied by the insured as reductions of the premiums due for the next policy year. This item is usually only available for insurance industry."""
        ...

    @property
    def policyholder_interest(self) -> QuantConnect.Data.Fundamental.PolicyholderInterestIncomeStatement:
        """The periodic income payment provided to the annuitant by the insurance company, which is determined by the assumed interest rate (AIR) and other factors. This item is usually only available for insurance industry."""
        ...

    @property
    def professional_expense_and_contract_services_expense(self) -> QuantConnect.Data.Fundamental.ProfessionalExpenseAndContractServicesExpenseIncomeStatement:
        """Professional and contract service expense includes cost reimbursements for support services related to contracted projects, outsourced management, technical and staff support. This item is usually only available for bank industry."""
        ...

    @property
    def provision_for_doubtful_accounts(self) -> QuantConnect.Data.Fundamental.ProvisionForDoubtfulAccountsIncomeStatement:
        """Amount of the current period expense charged against operations, the offset which is generally to the allowance for doubtful accounts for the purpose of reducing receivables, including notes receivable, to an amount that approximates their net realizable value (the amount expected to be collected). The category includes provision for loan losses, provision for any doubtful account receivable, and bad debt expenses. This item is usually not available for bank and insurance industries."""
        ...

    @property
    def rent_and_landing_fees(self) -> QuantConnect.Data.Fundamental.RentAndLandingFeesIncomeStatement:
        """Rent fees are the cost of occupying space during the accounting period. Landing fees are a change paid to an airport company for landing at a particular airport. This item is not available for insurance industry."""
        ...

    @property
    def restructuring_and_mergern_acquisition(self) -> QuantConnect.Data.Fundamental.RestructuringAndMergernAcquisitionIncomeStatement:
        """Expenses are related to restructuring, merger, or acquisitions. Restructuring expenses are charges associated with the consolidation and relocation of operations, disposition or abandonment of operations or productive assets. Merger and acquisition expenses are the amount of costs of a business combination including legal, accounting, and other costs that were charged to expense during the period."""
        ...

    @property
    def salaries_and_wages(self) -> QuantConnect.Data.Fundamental.SalariesAndWagesIncomeStatement:
        """All salary, wages, compensation, management fees, and employee benefit expenses."""
        ...

    @property
    def securities_activities(self) -> QuantConnect.Data.Fundamental.SecuritiesActivitiesIncomeStatement:
        """Income/Loss from Securities and Activities"""
        ...

    @property
    def service_charge_on_depositor_accounts(self) -> QuantConnect.Data.Fundamental.ServiceChargeOnDepositorAccountsIncomeStatement:
        """Includes any service charges on following accounts: Demand Deposit; Checking account; Savings account; Deposit in foreign offices; ESCROW accounts; Money Market Certificates & Deposit accounts, CDs (Negotiable Certificates of Deposits); NOW Accounts (Negotiable Order of Withdrawal); IRAs (Individual Retirement Accounts). This item is usually only available for bank industry."""
        ...

    @property
    def trading_gain_loss(self) -> QuantConnect.Data.Fundamental.TradingGainLossIncomeStatement:
        """A broker-dealer or other financial entity may buy and sell securities exclusively for its own account, sometimes referred to as proprietary trading. The profit or loss is measured by the difference between the acquisition cost and the selling price or current market or fair value. The net gain or loss, includes both realized and unrealized, from trading cash instruments, equities and derivative contracts (including commodity contracts) that has been recognized during the accounting period for the broker dealer or other financial entity's own account. This item is typically available for bank industry."""
        ...

    @property
    def trust_feesby_commissions(self) -> QuantConnect.Data.Fundamental.TrustFeesbyCommissionsIncomeStatement:
        """Bank manages funds on behalf of its customers through the operation of various trust accounts. Any fees earned through managing those funds are called trust fees, which are recognized when earned. This item is typically available for bank industry."""
        ...

    @property
    def underwriting_expenses(self) -> QuantConnect.Data.Fundamental.UnderwritingExpensesIncomeStatement:
        """Also known as Policy Acquisition Costs; and reported by insurance companies. The cost incurred by an insurer when deciding whether to accept or decline a risk; may include meetings with the insureds or brokers, actuarial review of loss history, or physical inspections of exposures. Also, expenses deducted from insurance company revenues (including incurred losses and acquisition costs) to determine underwriting profit."""
        ...

    @property
    def write_off(self) -> QuantConnect.Data.Fundamental.WriteOffIncomeStatement:
        """A reduction in the value of an asset or earnings by the amount of an expense or loss."""
        ...

    @property
    def other_non_interest_income(self) -> QuantConnect.Data.Fundamental.OtherNonInterestIncomeIncomeStatement:
        """Usually available for the banking industry. This is Non-Interest Income that is not otherwise classified."""
        ...

    @property
    def amortization_of_intangibles(self) -> QuantConnect.Data.Fundamental.AmortizationOfIntangiblesIncomeStatement:
        """The aggregate expense charged against earnings to allocate the cost of intangible assets (nonphysical assets not used in production) in a systematic and rational manner to the periods expected to benefit from such assets."""
        ...

    @property
    def net_income_from_continuing_and_discontinued_operation(self) -> QuantConnect.Data.Fundamental.NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement:
        """Net Income from Continuing Operations and Discontinued Operations, added together."""
        ...

    @property
    def net_income_from_tax_loss_carryforward(self) -> QuantConnect.Data.Fundamental.NetIncomeFromTaxLossCarryforwardIncomeStatement:
        """Occurs if a company has had a net loss from operations on a previous year that can be carried forward to reduce net income for tax purposes."""
        ...

    @property
    def other_operating_expenses(self) -> QuantConnect.Data.Fundamental.OtherOperatingExpensesIncomeStatement:
        """The aggregate amount of operating expenses associated with normal operations. Will not include any gain, loss, benefit, or income; and its value reported by the company should be <0."""
        ...

    @property
    def total_money_market_investments(self) -> QuantConnect.Data.Fundamental.TotalMoneyMarketInvestmentsIncomeStatement:
        """The sum of the money market investments held by a bank's depositors, which are FDIC insured."""
        ...

    @property
    def reconciled_cost_of_revenue(self) -> QuantConnect.Data.Fundamental.ReconciledCostOfRevenueIncomeStatement:
        """The Cost Of Revenue plus Depreciation, Depletion & Amortization from the IncomeStatement; minus Depreciation, Depletion & Amortization from the Cash Flow Statement"""
        ...

    @property
    def reconciled_depreciation(self) -> QuantConnect.Data.Fundamental.ReconciledDepreciationIncomeStatement:
        """Is Depreciation, Depletion & Amortization from the Cash Flow Statement"""
        ...

    @property
    def normalized_income(self) -> QuantConnect.Data.Fundamental.NormalizedIncomeIncomeStatement:
        """This calculation represents earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly measure a company's profitability. This is calculated using Net Income from Continuing Operations plus/minus any tax affected unusual Items and Goodwill Impairments/Write Offs."""
        ...

    @property
    def net_income_from_continuing_operation_net_minority_interest(self) -> QuantConnect.Data.Fundamental.NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement:
        """Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from: Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing Operation; Income from Tax Loss Carry forward; Other Gains/Losses."""
        ...

    @property
    def gain_losson_saleof_assets(self) -> QuantConnect.Data.Fundamental.GainLossonSaleofAssetsIncomeStatement:
        """Any gain (loss) recognized on the sale of assets or a sale which generates profit or loss, which is a difference between sales price and net book value at the disposal time."""
        ...

    @property
    def gainon_saleof_loans(self) -> QuantConnect.Data.Fundamental.GainonSaleofLoansIncomeStatement:
        """Gain on sale of any loans investment."""
        ...

    @property
    def gainon_saleof_investment_property(self) -> QuantConnect.Data.Fundamental.GainonSaleofInvestmentPropertyIncomeStatement:
        """Gain on the disposal of investment property."""
        ...

    @property
    def losson_extinguishmentof_debt(self) -> QuantConnect.Data.Fundamental.LossonExtinguishmentofDebtIncomeStatement:
        """Loss on extinguishment of debt is the accounting loss that results from a debt extinguishment. A debt shall be accounted for as having been extinguished in a number of circumstances, including when it has been settled through repayment or replacement by another liability. It generally results in an accounting gain or loss. Amount represents the difference between the fair value of the payments made and the carrying amount of the debt at the time of its extinguishment."""
        ...

    @property
    def earningsfrom_equity_interest_net_of_tax(self) -> QuantConnect.Data.Fundamental.EarningsfromEquityInterestNetOfTaxIncomeStatement:
        """Income from other equity interest reported after Provision of Tax. This applies to all industries."""
        ...

    @property
    def net_income_including_noncontrolling_interests(self) -> QuantConnect.Data.Fundamental.NetIncomeIncludingNoncontrollingInterestsIncomeStatement:
        """Net income of the group after the adjustment of all expenses and benefit."""
        ...

    @property
    def otherunder_preferred_stock_dividend(self) -> QuantConnect.Data.Fundamental.OtherunderPreferredStockDividendIncomeStatement:
        """Dividend paid to the preferred shareholders before the common stock shareholders."""
        ...

    @property
    def staff_costs(self) -> QuantConnect.Data.Fundamental.StaffCostsIncomeStatement:
        """Total staff cost which is paid to the employees that is not part of Selling, General, and Administration expense."""
        ...

    @property
    def social_security_costs(self) -> QuantConnect.Data.Fundamental.SocialSecurityCostsIncomeStatement:
        """Benefits paid to the employees in respect of their work."""
        ...

    @property
    def pension_costs(self) -> QuantConnect.Data.Fundamental.PensionCostsIncomeStatement:
        """The expense that a company incurs each year by providing a pension plan for its employees. Major expenses in the pension cost include employer matching contributions and management fees."""
        ...

    @property
    def other_operating_income_total(self) -> QuantConnect.Data.Fundamental.OtherOperatingIncomeTotalIncomeStatement:
        """Total Other Operating Income- including interest income, dividend income and other types of operating income."""
        ...

    @property
    def incomefrom_associatesand_other_participating_interests(self) -> QuantConnect.Data.Fundamental.IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement:
        """Total income from the associates and joint venture via investment, accounted for in the Non-Operating section."""
        ...

    @property
    def total_other_finance_cost(self) -> QuantConnect.Data.Fundamental.TotalOtherFinanceCostIncomeStatement:
        """Any other finance cost which is not clearly defined in the Non-Operating section."""
        ...

    @property
    def gross_dividend_payment(self) -> QuantConnect.Data.Fundamental.GrossDividendPaymentIncomeStatement:
        """Total amount paid in dividends to investors- this includes dividends paid on equity and non-equity shares."""
        ...

    @property
    def feesand_commission_income(self) -> QuantConnect.Data.Fundamental.FeesandCommissionIncomeIncomeStatement:
        """Fees and commission income earned by bank and insurance companies on the rendering services."""
        ...

    @property
    def feesand_commission_expense(self) -> QuantConnect.Data.Fundamental.FeesandCommissionExpenseIncomeStatement:
        """Cost incurred by bank and insurance companies for fees and commission income."""
        ...

    @property
    def net_trading_income(self) -> QuantConnect.Data.Fundamental.NetTradingIncomeIncomeStatement:
        """Any trading income on the securities."""
        ...

    @property
    def other_staff_costs(self) -> QuantConnect.Data.Fundamental.OtherStaffCostsIncomeStatement:
        """Other costs in incurred in lieu of the employees that cannot be identified by other specific items in the Staff Costs section."""
        ...

    @property
    def gainon_investment_properties(self) -> QuantConnect.Data.Fundamental.GainonInvestmentPropertiesIncomeStatement:
        """Gain on disposal and change in fair value of investment properties."""
        ...

    @property
    def average_dilution_earnings(self) -> QuantConnect.Data.Fundamental.AverageDilutionEarningsIncomeStatement:
        """Adjustments to reported net income to calculate Diluted EPS, by assuming that all convertible instruments are converted to Common Equity. The adjustments usually include the interest expense of debentures when assumed converted and preferred dividends of convertible preferred stock when assumed converted."""
        ...

    @property
    def gain_losson_financial_instruments_designatedas_cash_flow_hedges(self) -> QuantConnect.Data.Fundamental.GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement:
        """Gain/Loss through hedging activities."""
        ...

    @property
    def gain_losson_derecognitionof_available_for_sale_financial_assets(self) -> QuantConnect.Data.Fundamental.GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement:
        """Gain/loss on the write-off of financial assets available-for-sale."""
        ...

    @property
    def negative_goodwill_immediately_recognized(self) -> QuantConnect.Data.Fundamental.NegativeGoodwillImmediatelyRecognizedIncomeStatement:
        """Negative Goodwill recognized in the Income Statement. Negative Goodwill arises where the net assets at the date of acquisition, fairly valued, falls below the cost of acquisition."""
        ...

    @property
    def gains_losseson_financial_instruments_dueto_fair_value_adjustmentsin_hedge_accounting_total(self) -> QuantConnect.Data.Fundamental.GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement:
        """Gain or loss on derivatives investment due to the fair value adjustment."""
        ...

    @property
    def impairment_losses_reversals_financial_instruments_net(self) -> QuantConnect.Data.Fundamental.ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement:
        """Impairment or reversal of impairment on financial instrument such as derivative. This is a contra account under Total Revenue in banks."""
        ...

    @property
    def claimsand_paid_incurred(self) -> QuantConnect.Data.Fundamental.ClaimsandPaidIncurredIncomeStatement:
        """All reported claims arising out of incidents in that year are considered incurred grouped with claims paid out."""
        ...

    @property
    def reinsurance_recoveries_claimsand_benefits(self) -> QuantConnect.Data.Fundamental.ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement:
        """Claim on the reinsurance company and take the benefits."""
        ...

    @property
    def changein_insurance_liabilities_netof_reinsurance(self) -> QuantConnect.Data.Fundamental.ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement:
        """Income/Expense due to changes between periods in insurance liabilities."""
        ...

    @property
    def changein_investment_contract(self) -> QuantConnect.Data.Fundamental.ChangeinInvestmentContractIncomeStatement:
        """Income/Expense due to changes between periods in Investment Contracts."""
        ...

    @property
    def credit_risk_provisions(self) -> QuantConnect.Data.Fundamental.CreditRiskProvisionsIncomeStatement:
        """Provision for the risk of loss of principal or loss of a financial reward stemming from a borrower's failure to repay a loan or otherwise meet a contractual obligation. Credit risk arises whenever a borrower is expecting to use future cash flows to pay a current debt. Investors are compensated for assuming credit risk by way of interest payments from the borrower or issuer of a debt obligation. This is a contra account under Total Revenue in banks."""
        ...

    @property
    def wagesand_salaries(self) -> QuantConnect.Data.Fundamental.WagesandSalariesIncomeStatement:
        """This is the portion under Staff Costs that represents salary paid to the employees in respect of their work."""
        ...

    @property
    def other_non_operating_income_expenses(self) -> QuantConnect.Data.Fundamental.OtherNonOperatingIncomeExpensesIncomeStatement:
        """Total other income and expense of the company that cannot be identified by other specific items in the Non-Operating section."""
        ...

    @property
    def other_non_operating_income(self) -> QuantConnect.Data.Fundamental.OtherNonOperatingIncomeIncomeStatement:
        """Other income of the company that cannot be identified by other specific items in the Non-Operating section."""
        ...

    @property
    def other_non_operating_expenses(self) -> QuantConnect.Data.Fundamental.OtherNonOperatingExpensesIncomeStatement:
        """Other expenses of the company that cannot be identified by other specific items in the Non-Operating section."""
        ...

    @property
    def total_unusual_items(self) -> QuantConnect.Data.Fundamental.TotalUnusualItemsIncomeStatement:
        """Total unusual items including Negative Goodwill."""
        ...

    @property
    def total_unusual_items_excluding_goodwill(self) -> QuantConnect.Data.Fundamental.TotalUnusualItemsExcludingGoodwillIncomeStatement:
        """The sum of all the identifiable operating and non-operating unusual items."""
        ...

    @property
    def tax_rate_for_calcs(self) -> QuantConnect.Data.Fundamental.TaxRateForCalcsIncomeStatement:
        """Tax rate used for Morningstar calculations."""
        ...

    @property
    def tax_effect_of_unusual_items(self) -> QuantConnect.Data.Fundamental.TaxEffectOfUnusualItemsIncomeStatement:
        """Tax effect of the usual items"""
        ...

    @property
    def normalized_ebitda(self) -> QuantConnect.Data.Fundamental.NormalizedEBITDAIncomeStatement:
        """EBITDA less Total Unusual Items"""
        ...

    @property
    def stock_based_compensation(self) -> QuantConnect.Data.Fundamental.StockBasedCompensationIncomeStatement:
        """The cost to the company for granting stock options to reward employees."""
        ...

    @property
    def diluted_ni_availto_com_stockholders(self) -> QuantConnect.Data.Fundamental.DilutedNIAvailtoComStockholdersIncomeStatement:
        """Net income to calculate Diluted EPS, accounting for adjustments assuming that all the convertible instruments are being converted to Common Equity."""
        ...

    @property
    def investment_contract_liabilities_incurred(self) -> QuantConnect.Data.Fundamental.InvestmentContractLiabilitiesIncurredIncomeStatement:
        """Income/Expenses due to the insurer's liabilities incurred in Investment Contracts."""
        ...

    @property
    def reinsurance_recoveriesof_investment_contract(self) -> QuantConnect.Data.Fundamental.ReinsuranceRecoveriesofInvestmentContractIncomeStatement:
        """Income/Expense due to recoveries from reinsurers for Investment Contracts."""
        ...

    @property
    def total_dividend_paymentof_equity_shares(self) -> QuantConnect.Data.Fundamental.TotalDividendPaymentofEquitySharesIncomeStatement:
        """Total amount paid in dividends to equity securities investors."""
        ...

    @property
    def total_dividend_paymentof_non_equity_shares(self) -> QuantConnect.Data.Fundamental.TotalDividendPaymentofNonEquitySharesIncomeStatement:
        """Total amount paid in dividends to Non-Equity securities investors."""
        ...

    @property
    def changein_the_gross_provisionfor_unearned_premiums(self) -> QuantConnect.Data.Fundamental.ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement:
        """The change in the amount of the unearned premium reserves maintained by insurers."""
        ...

    @property
    def changein_the_gross_provisionfor_unearned_premiums_reinsurers_share(self) -> QuantConnect.Data.Fundamental.ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement:
        """The change in the amount of unearned premium reserve to be covered by reinsurers."""
        ...

    @property
    def claimsand_changein_insurance_liabilities(self) -> QuantConnect.Data.Fundamental.ClaimsandChangeinInsuranceLiabilitiesIncomeStatement:
        """Income/Expense due to the insurer's changes in insurance liabilities."""
        ...

    @property
    def reinsurance_recoveriesof_insurance_liabilities(self) -> QuantConnect.Data.Fundamental.ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement:
        """Income/Expense due to recoveries from reinsurers for insurance liabilities."""
        ...

    @property
    def total_operating_income_as_reported(self) -> QuantConnect.Data.Fundamental.TotalOperatingIncomeAsReportedIncomeStatement:
        """Operating profit/loss as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @property
    def other_ga(self) -> QuantConnect.Data.Fundamental.OtherGAIncomeStatement:
        """Other General and Administrative Expenses not categorized that the company incurs that are not directly tied to a specific function such as manufacturing, production, or sales."""
        ...

    @property
    def other_costof_revenue(self) -> QuantConnect.Data.Fundamental.OtherCostofRevenueIncomeStatement:
        """Other costs associated with the revenue-generating activities of the company not categorized above."""
        ...

    @property
    def rentand_landing_fees_costof_revenue(self) -> QuantConnect.Data.Fundamental.RentandLandingFeesCostofRevenueIncomeStatement:
        """Costs paid to use the facilities necessary to generate revenue during the accounting period."""
        ...

    @property
    def dda_costof_revenue(self) -> QuantConnect.Data.Fundamental.DDACostofRevenueIncomeStatement:
        """Costs of depreciation and amortization on assets used for the revenue-generating activities during the accounting period"""
        ...

    @property
    def rent_expense_supplemental(self) -> QuantConnect.Data.Fundamental.RentExpenseSupplementalIncomeStatement:
        """The sum of all rent expenses incurred by the company for operating leases during the year, it is a supplemental value which would be reported outside consolidated statements or consolidated statement's footnotes."""
        ...

    @property
    def normalized_pre_tax_income(self) -> QuantConnect.Data.Fundamental.NormalizedPreTaxIncomeIncomeStatement:
        """This calculation represents pre-tax earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly measure a company's profitability. This is calculated using Pre-Tax Income plus/minus any unusual Items and Goodwill Impairments/Write Offs."""
        ...

    @property
    def research_and_development_expenses_supplemental(self) -> QuantConnect.Data.Fundamental.ResearchAndDevelopmentExpensesSupplementalIncomeStatement:
        """The aggregate amount of research and development expenses during the year. It is a supplemental value which would be reported outside consolidated statements."""
        ...

    @property
    def depreciation_supplemental(self) -> QuantConnect.Data.Fundamental.DepreciationSupplementalIncomeStatement:
        """The current period expense charged against earnings on tangible asset over its useful life. It is a supplemental value which would be reported outside consolidated statements."""
        ...

    @property
    def amortization_supplemental(self) -> QuantConnect.Data.Fundamental.AmortizationSupplementalIncomeStatement:
        """The current period expense charged against earnings on intangible asset over its useful life. It is a supplemental value which would be reported outside consolidated statements."""
        ...

    @property
    def total_revenue_as_reported(self) -> QuantConnect.Data.Fundamental.TotalRevenueAsReportedIncomeStatement:
        """Total revenue as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @property
    def operating_expense_as_reported(self) -> QuantConnect.Data.Fundamental.OperatingExpenseAsReportedIncomeStatement:
        """Operating expense as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @property
    def normalized_income_as_reported(self) -> QuantConnect.Data.Fundamental.NormalizedIncomeAsReportedIncomeStatement:
        """Earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly measure a company's profitability. This is as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @property
    def normalized_ebitda_as_reported(self) -> QuantConnect.Data.Fundamental.NormalizedEBITDAAsReportedIncomeStatement:
        """EBITDA less Total Unusual Items. This is as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @property
    def normalized_ebit_as_reported(self) -> QuantConnect.Data.Fundamental.NormalizedEBITAsReportedIncomeStatement:
        """EBIT less Total Unusual Items. This is as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @property
    def normalized_operating_profit_as_reported(self) -> QuantConnect.Data.Fundamental.NormalizedOperatingProfitAsReportedIncomeStatement:
        """Operating profit adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly measure a company's profitability. This is as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @property
    def effective_tax_rate_as_reported(self) -> QuantConnect.Data.Fundamental.EffectiveTaxRateAsReportedIncomeStatement:
        """The average tax rate for the period as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...


class BalanceSheetFileDate(QuantConnect.Data.Fundamental.MultiPeriodField[datetime.datetime]):
    """Filing date of the Balance Sheet"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> datetime.datetime:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> datetime.datetime:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> datetime.datetime:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> datetime.datetime:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> datetime.datetime:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, datetime.datetime]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AccountsPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Any money that a company owes its suppliers for goods and services purchased on credit and is expected to pay within the next year or operating cycle."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AccountsReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Accounts owed to a company by customers within a year as a result of exchanging goods or services on credit."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentAccruedExpensesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """An expense recognized before it is paid for. Includes compensation, interest, pensions and all other miscellaneous accruals reported by the company. Expenses incurred during the accounting period, but not required to be paid until a later date."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonCurrentAccruedExpensesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """An expense that has occurred but the transaction has not been entered in the accounting records. Accordingly, an adjusting entry is made to debit the appropriate expense account and to credit a liability account such as accrued expenses payable or accounts payable."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AccruedInvestmentIncomeBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Interest, dividends, rents, ancillary and other revenues earned but not yet received by the entity on its investments."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AccumulatedDepreciationBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The cumulative amount of wear and tear or obsolescence charged against the fixed assets of a company."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GainsLossesNotAffectingRetainedEarningsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of gains or losses that are not part of retained earnings. It is also called other comprehensive income."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AdditionalPaidInCapitalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Excess of issue price over par or stated value of the entity's capital stock and amounts received from other transactions involving the entity's stock or stockholders. Includes adjustments to additional paid in capital. There are two major categories of additional paid in capital: 1) Paid in capital in excess of par/stated value, which is the difference between the actual issue price of the shares and the shares' par/stated value. 2) Paid in capital from other transactions which includes treasury stock, retirement of stock, stock dividends recorded at market, lapse of stock purchase warrants, conversion of convertible bonds in excess of the par value of the stock, and any other additional capital from the company's own stock transactions."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AllowanceForLoansAndLeaseLossesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A contra account sets aside as an allowance for bad loans (e.g. customer defaults)."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AvailableForSaleSecuritiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """For an unclassified balance sheet, this item represents equity securities categorized neither as held-to-maturity nor trading. Equity securities represent ownership interests or the right to acquire ownership interests in corporations and other legal entities which ownership interest is represented by shares of common or preferred stock (which is not mandatory redeemable or redeemable at the option of the holder), convertible securities, stock rights, or stock warrants. This category includes preferred stocks, available- for-sale and common stock, available-for-sale."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CapitalStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The total amount of stock authorized for issue by a corporation, including common and preferred stock."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CashBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Cash includes currency on hand as well as demand deposits with banks or financial institutions. It also includes other kinds of accounts that have the general characteristics of demand deposits in that the customer may deposit additional funds at any time and also effectively may withdraw funds at any time without prior notice or penalty."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CashEquivalentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Cash equivalents, excluding items classified as marketable securities, include short-term, highly liquid investments that are both readily convertible to known amounts of cash, and so near their maturity that they present insignificant risk of changes in value because of changes in interest rates. Generally, only investments with original maturities of three months or less qualify under this definition. Original maturity means original maturity to the entity holding the investment. For example, both a three-month US Treasury bill and a three-year Treasury note purchased three months from maturity qualify as cash equivalents. However, a Treasury note purchased three years ago does not become a cash equivalent when its remaining maturity is three months."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CashAndCashEquivalentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Includes unrestricted cash on hand, money market instruments and other debt securities which can be converted to cash immediately."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CashAndDueFromBanksBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Includes cash on hand (currency and coin), cash items in process of collection, non-interest bearing deposits due from other financial institutions (including corporate credit unions), and balances with the Federal Reserve Banks, Federal Home Loan Banks and central banks."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CashCashEquivalentsAndFederalFundsSoldBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of cash, cash equivalents, and federal funds sold."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CashCashEquivalentsAndMarketableSecuritiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of cash, cash equivalents, and marketable securities."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CommonStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Common stock (all issues) at par value, as reported within the Stockholder's Equity section of the balance sheet; i.e. it is one component of Common Stockholder's Equity"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The total amount of assets considered to be convertible into cash within a relatively short period of time, usually a year."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentDebtBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the total amount of long-term debt such as bank loans and commercial paper, which is due within one year."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentDebtAndCapitalLeaseObligationBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All borrowings due within one year including current portions of long-term debt and capital leases as well as short-term debt such as bank loans and commercial paper."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The debts or obligations of the firm that are due within one year."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentCapitalLeaseObligationBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the total amount of long-term capital leases that must be paid within the next accounting PeriodAsByte. Capital lease obligations are contractual obligations that arise from obtaining the use of property or equipment via a capital lease contract."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DeferredAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """An amount owed to a firm that is not expected to be received by the firm within one year from the date of the balance sheet."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DeferredCostsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """An expenditure not recognized as a cost of operation of the period in which incurred, but carried forward to be written off in future periods."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonCurrentDeferredLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the non-current portion of obligations, which is a liability that usually would have been paid but is now past due."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentDeferredLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the current portion of obligations, which is a liability that usually would have been paid but is now past due."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DeferredPolicyAcquisitionCostsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net amount of deferred policy acquisition costs capitalized on contracts remaining in force as of the balance sheet date."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentDeferredRevenueBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents collections of cash or other assets related to revenue producing activity for which revenue has not yet been recognized. Generally, an entity records deferred revenue when it receives consideration from a customer before achieving certain criteria that must be met for revenue to be recognized in conformity with GAAP. It can be either current or non-current item. Also called unearned revenue."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonCurrentDeferredRevenueBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The non-current portion of deferred revenue amount as of the balance sheet date. Deferred revenue is a liability related to revenue producing activity for which revenue has not yet been recognized, and is not expected be recognized in the next twelve months."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DeferredTaxAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """An asset on a company's balance sheet that may be used to reduce any subsequent period's income tax expense. Deferred tax assets can arise due to net loss carryovers, which are only recorded as assets if it is deemed more likely than not that the asset will be used in future fiscal periods."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentDeferredTaxesAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Meaning a future tax asset, resulting from temporary differences between book (accounting) value of assets and liabilities and their tax value, or timing differences between the recognition of gains and losses in financial statements and their recognition in a tax computation. It is also called future tax."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentDeferredTaxesLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Meaning a future tax liability, resulting from temporary differences between book (accounting) value of assets and liabilities and their tax value, or timing differences between the recognition of gains and losses in financial statements and their recognition in a tax computation. Deferred tax liabilities generally arise where tax relief is provided in advance of an accounting expense, or income is accrued but not taxed until received."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonCurrentDeferredTaxesAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A result of timing differences between taxable incomes reported on the income statement and taxable income from the company's tax return. Depending on the positioning of deferred income taxes, the field may be either current (within current assets) or non- current (below total current assets). Typically a company will have two deferred income taxes fields."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonCurrentDeferredTaxesLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The estimated future tax obligations, which usually arise when different accounting methods are used for financial statements and tax statement It is also an add-back to the cash flow statement. Deferred income taxes include accumulated tax deferrals due to accelerated depreciation and investment credit."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class EquityInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This asset represents equity securities categorized neither as held-to-maturity nor trading."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchaseBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This liability refers to the amount shown on the books that a bank with insufficient reserves borrows, at the federal funds rate, from another bank to meet its reserve requirements; and the amount of securities that an institution sells and agrees to repurchase at a specified date for a specified price, net of any reductions or offsets."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This asset refers to very-short-term loans of funds to other banks and securities dealers."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FixedMaturityInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This asset refers to types of investments that may be contained within the fixed maturity category which securities are having a stated final repayment date. Examples of items within this category may include bonds, including convertibles and bonds with warrants, and redeemable preferred stocks."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FuturePolicyBenefitsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Accounting policy pertaining to an insurance entity's net liability for future benefits (for example, death, cash surrender value) to be paid to or on behalf of policyholders, describing the bases, methodologies and components of the reserve, and assumptions regarding estimates of expected investment yields, mortality, morbidity, terminations and expenses."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GeneralPartnershipCapitalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """In a limited partnership or master limited partnership form of business, this represents the balance of capital held by the general partners."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GoodwillBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The excess of the cost of an acquired company over the sum of the fair market value of its identifiable individual assets less the liabilities."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GoodwillAndOtherIntangibleAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Rights or economic benefits, such as patents and goodwill, that is not physical in nature. They are those that are neither physical nor financial in nature, nevertheless, have value to the company. Intangibles are listed net of accumulated amortization."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GrossLoanBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the sum of all loans (commercial, consumer, mortgage, etc.) as well as leases before any provisions for loan losses or unearned discounts."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GrossPPEBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Carrying amount at the balance sheet date for long-lived physical assets used in the normal conduct of business and not intended for resale. This can include land, physical structures, machinery, vehicles, furniture, computer equipment, construction in progress, and similar items. Amount does not include depreciation."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class HeldToMaturitySecuritiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Debt securities that a firm has the ability and intent to hold until maturity."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class IncomeTaxPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A current liability account which reflects the amount of income taxes currently due to the federal, state, and local governments."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestBearingDepositsLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate of all domestic and foreign deposits in the bank that earns interests."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of the carrying values as of the balance sheet date of interest payable on all forms of debt, including trade payable that has been incurred."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InterestBearingDepositsAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Deposit of money with a financial institution, in consideration of which the financial institution pays or credits interest, or amounts in the nature of interest."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InventoryBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A company's merchandise, raw materials, and finished and unfinished products which have not yet been sold."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InvestmentsAndAdvancesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All investments in affiliates, real estate, securities, etc. Non-current investment, not including marketable securities."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LimitedPartnershipCapitalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """In a limited partnership or master limited partnership form of business, this represents the balance of capital held by the limited partners."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LongTermDebtBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of the carrying values as of the balance sheet date of all long-term debt, which is debt initially having maturities due after one year or beyond the operating cycle, if longer, but excluding the portions thereof scheduled to be repaid within one year or the normal operating cycle, if longer. Long-term debt includes notes payable, bonds payable, mortgage loans, convertible debt, subordinated debt and other types of long term debt."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LongTermDebtAndCapitalLeaseObligationBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All borrowings lasting over one year including long-term debt and long-term portion of capital lease obligations."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LongTermInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Often referred to simply as "investments". Long-term investments are to be held for many years and are not intended to be disposed in the near future. This group usually consists of four types of investments."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LongTermCapitalLeaseObligationBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the total liability for long-term leases lasting over one year. Amount equal to the present value (the principal) at the beginning of the lease term less lease payments during the lease term."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class MinorityInterestBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Carrying amount of the equity interests owned by non-controlling shareholders, partners, or other equity holders in one or more of the entities included in the reporting entity's consolidated financial statements."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class MoneyMarketInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Short-term (typical maturity is less than one year), highly liquid government or corporate debt instrument such as bankers' acceptance, promissory notes, and treasury bills."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetLoanBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the value of all loans after deduction of the appropriate allowances for loan and lease losses."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetPPEBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Tangible assets that are held by an entity for use in the production or supply of goods and services, for rental to others, or for administrative purposes and that are expected to provide economic benefit for more than one year; net of accumulated depreciation."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonInterestBearingDepositsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of all domestic and foreign deposits in the banks that do not draw interest."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentNotesPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Written promises to pay a stated sum at one or more specified dates in the future, within the accounting PeriodAsByte."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NotesReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """An amount representing an agreement for an unconditional promise by the maker to pay the entity (holder) a definite sum of money at a future date(s) within one year of the balance sheet date or the normal operating cycle, whichever is longer. Such amount may include accrued interest receivable in accordance with the terms of the note. The note also may contain provisions including a discount or premium, payable on demand, secured, or unsecured, interest bearing or non-interest bearing, among a myriad of other features and characteristics."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonCurrentNoteReceivablesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """An amount representing an agreement for an unconditional promise by the maker to pay the entity (holder) a definite sum of money at a future date(s), excluding the portion that is expected to be received within one year of the balance sheet date or the normal operating cycle, whichever is longer."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherCurrentLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other current liabilities = Total current liabilities - Payables and accrued Expenses - Current debt and capital lease obligation - provisions, current - deferred liabilities, current."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherIntangibleAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of the carrying amounts of all intangible assets, excluding goodwill."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherShortTermInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of short term investments, which will be expired within one year that are not specifically classified as Available-for-Sale, Held-to-Maturity, nor Trading investments."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PayablesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The sum of all payables owed and expected to be paid within one year or one operating cycle, including accounts payables, taxes payable, dividends payable and all other current payables."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PayablesAndAccruedExpensesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This balance sheet account includes all current payables and accrued expenses."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PolicyReservesBenefitsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Accounting policy pertaining to an insurance entity's net liability for future benefits (for example, death, cash surrender value) to be paid to or on behalf of policyholders, describing the bases, methodologies and components of the reserve, and assumptions regarding estimates of expected investment yields, mortality, morbidity, terminations and expenses."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PolicyholderFundsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The total liability as of the balance sheet date of amounts due to policy holders, excluding future policy benefits and claims, including unpaid policy dividends, retrospective refunds, and undistributed earnings on participating business."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PreferredSecuritiesOutsideStockEquityBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Preferred securities that that firm treats as a liability. It includes convertible preferred stock or redeemable preferred stock."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PreferredStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Preferred stock (all issues) at par value, as reported within the Stockholder's Equity section of the balance sheet."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PrepaidAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of the carrying amounts that are paid in advance for expenses, which will be charged against earnings in subsequent periods."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonCurrentPrepaidAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of the carrying amounts that are paid in advance for expenses, which will be charged against earnings in periods after one year or beyond the operating cycle, if longer."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ReceivablesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The sum of all receivables owed by customers and affiliates within one year, including accounts receivable, notes receivable, premiums receivable, and other current receivables."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ReinsuranceRecoverableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount of benefits the ceding insurer expects to recover on insurance policies ceded to other insurance entities as of the balance sheet date for all guaranteed benefit types. It includes estimated amounts for claims incurred but not reported, and policy benefits, net of any related valuation allowance."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RetainedEarningsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The cumulative net income of the company from the date of its inception (or reorganization) to the date of the financial statement less the cumulative distributions to shareholders either directly (dividends) or indirectly (treasury stock)."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SecuritiesLendingCollateralBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying value as of the balance sheet date of the liabilities collateral securities loaned to other broker-dealers. Borrowers of securities generally are required to provide collateral to the lenders of securities, commonly cash but sometimes other securities or standby letters of credit, with a value slightly higher than that of the securities borrowed."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SecurityAgreeToBeResellBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to resell the identical security purchased or a security that meets the definition of "substantially the same" in the case of a dollar roll. Also includes purchases of participations in pools of securities that are subject to a resale agreement."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SecuritySoldNotYetRepurchasedBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represent obligations of the company to deliver the specified security at the contracted price and, thereby, create a liability to purchase the security in the market at prevailing prices."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SeparateAccountAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The fair value of the assets held by the company for the benefit of separate account policyholders."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SeparateAccountBusinessBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Refers to revenue that is generated that is not part of typical operations."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ShortTermInvestmentsAvailableForSaleBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The current assets section of a company's balance sheet that contains the investments that a company holds with the purpose for trading."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ShortTermInvestmentsHeldToMaturityBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The current assets section of a company's balance sheet that contains the investments that a company has made that will expire at a fixed date within one year."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ShortTermInvestmentsTradingBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The current assets section of a company's balance sheet that contains the investments that a company can trade at any moment."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class StockholdersEquityBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The residual interest in the assets of the enterprise that remains after deducting its liabilities. Equity is increased by owners' investments and by comprehensive income, and it is reduced by distributions to the owners."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalTaxPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A liability that reflects the taxes owed to federal, state, and local tax authorities. It is the carrying value as of the balance sheet date of obligations incurred and payable for statutory income, sales, use, payroll, excise, real, property and other taxes."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of probable future economic benefits obtained or controlled by a particular enterprise as a result of past transactions or events."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalDepositsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A liability account which represents the total amount of funds deposited."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Asset that refers to the sum of all available for sale securities and other investments often reported on the balance sheet of insurance firms."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalNonCurrentAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of the carrying amounts as of the balance sheet date of all assets that are expected to be realized in cash, sold or consumed after one year or beyond the normal operating cycle, if longer."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalPartnershipCapitalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Ownership interest of different classes of partners in the publicly listed limited partnership or master limited partnership. Partners include general, limited and preferred partners."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TradingAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Trading account assets are bought and held principally for the purpose of selling them in the near term (thus held for only a short period of time). Unrealized holding gains and losses for trading securities are included in earnings."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TradingLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying amount of liabilities as of the balance sheet date that pertain to principal and customer trading transactions, or which may be incurred with the objective of generating a profit from short-term fluctuations in price as part of an entity's market-making, hedging and proprietary trading. Examples include short positions in securities, derivatives and commodities, obligations under repurchase agreements, and securities borrowed arrangements."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TradingSecuritiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The total of financial instruments that are bought and held principally for the purpose of selling them in the near term (thus held for only a short period of time) or for debt and equity securities formerly categorized as available-for-sale or held-to-maturity which the company held as of the date it opted to account for such securities at fair value."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TreasuryStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The portion of shares that a company keeps in their own treasury. Treasury stock may have come from a repurchase or buyback from shareholders; or it may have never been issued to the public in the first place. These shares don't pay dividends, have no voting rights, and are not included in shares outstanding calculations."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class UnearnedIncomeBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income received but not yet earned, it represents the unearned amount that is netted against the total loan."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class UnearnedPremiumsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Carrying amount of premiums written on insurance contracts that have not been earned as of the balance sheet date."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class UnpaidLossAndLossReserveBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Liability amount that reflects claims that are expected based upon statistical projections, but which have not been reported to the insurer."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InvestedCapitalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Invested capital = common shareholders' equity + long term debt + current debt"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentDeferredAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Payments that will be assigned as expenses with one accounting period, but that are paid in advance and temporarily set up as current assets on the balance sheet."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonCurrentDeferredAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Payments that will be assigned as expenses longer than one accounting period, but that are paid in advance and temporarily set up as non-current assets on the balance sheet."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SecuritiesAndInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Asset, often applicable to Banks, which refers to the aggregate amount of all securities and investments."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalLiabilitiesNetMinorityInterestBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Probable future sacrifices of economic benefits arising from present obligations of an enterprise to transfer assets or provide services to others in the future as a result of past transactions or events, excluding minority interest."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalNonCurrentLiabilitiesNetMinorityInterestBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total obligations, net minority interest, incurred as part of normal operations that is expected to be repaid beyond the following twelve months or one business cycle; excludes minority interest."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalEquityGrossMinorityInterestBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Residual interest, including minority interest, that remains in the assets of the enterprise after deducting its liabilities. Equity is increased by owners' investments and by comprehensive income, and it is reduced by distributions to the owners."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GrossAccountsReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Accounts owed to a company by customers within a year as a result of exchanging goods or services on credit."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonCurrentAccountsReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Accounts receivable represents sums owed to the business that the business records as revenue. Gross accounts receivable is accounts receivable before the business deducts uncollectable accounts to calculate the true value of accounts receivable."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AccruedInterestReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This account shows the amount of unpaid interest accrued to the date of purchase and included in the purchase price of securities purchased between interest dates."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AdvanceFromFederalHomeLoanBanksBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This item is typically available for bank industry. It's the amount of borrowings as of the balance sheet date from the Federal Home Loan Bank, which are primarily used to cover shortages in the required reserve balance and liquidity shortages."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AllowanceForDoubtfulAccountsReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """An Allowance for Doubtful Accounts measures receivables recorded but not expected to be collected."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AllowanceForNotesReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This item is typically available for bank industry. It represents a provision relating to a written agreement to receive money with the terms of the note (at a specified future date(s) within one year from the reporting date (or the normal operating cycle, whichever is longer), consisting of principal as well as any accrued interest) for the portion that is expected to be uncollectible."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AssetsHeldForSaleBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This item is typically available for bank industry. It's a part of long-lived assets, which has been decided for sale in the future."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AssetsOfDiscontinuedOperationsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A portion of a company's business that has been disposed of or sold."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class BankIndebtednessBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All indebtedness for borrowed money or the deferred purchase price of property or services, including without limitation reimbursement and other obligations with respect to surety bonds and letters of credit, all obligations evidenced by notes, bonds debentures or similar instruments, all capital lease obligations and all contingent obligations."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class BankOwnedLifeInsuranceBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying amount of a life insurance policy on an officer, executive or employee for which the reporting entity (a bank) is entitled to proceeds from the policy upon death of the insured or surrender of the insurance policy."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SecurityBorrowedBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The securities borrowed or on loan, which is the temporary loan of securities by a lender to a borrower in exchange for cash. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class BuildingsAndImprovementsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Fixed assets that specifically deal with the facilities a company owns. Include the improvements associated with buildings."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CommercialLoanBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Short-term loan, typically 90 days, used by a company to finance seasonal working capital needs."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CommercialPaperBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Commercial paper is a money-market security issued by large banks and corporations. It represents the current obligation for the company. There are four basic kinds of commercial paper: promissory notes, drafts, checks, and certificates of deposit. The maturities of these money market securities generally do not exceed 270 days."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CommonStockEquityBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The portion of the Stockholders' Equity that reflects the amount of common stock, which are units of ownership."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ConstructionInProgressBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """It represents carrying amount of long-lived asset under construction that includes construction costs to date on capital projects. Assets constructed, but not completed."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ConsumerLoanBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A loan that establishes consumer credit that is granted for personal use; usually unsecured and based on the borrower's integrity and ability to pay."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class MinimumPensionLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The company's minimum pension obligations to its former employees, paid into a defined pension plan to satisfy all pension entitlements that have been earned by employees to date."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CustomerAcceptancesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts receivable from customers on short-term negotiable time drafts drawn on and accepted by the institution (also known as banker's acceptance transactions) that are outstanding on the reporting date."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DefinedPensionBenefitBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The recognition of an asset where pension fund assets exceed promised benefits."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DerivativeProductLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Fair values of all liabilities resulting from contracts that meet the criteria of being accounted for as derivative instruments; and which are expected to be extinguished or otherwise disposed of after one year or beyond the normal operating cycle."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DerivativeAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Fair values of assets resulting from contracts that meet the criteria of being accounted for as derivative instruments, net of the effects of master netting arrangements."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DividendsPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of the carrying values of dividends declared but unpaid on equity securities issued and outstanding (also includes dividends collected on behalf of another owner of securities that are being held by entity) by the entity."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class EmployeeBenefitsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Carrying amount as of the balance sheet date of the portion of the obligations recognized for the various benefits provided to former or inactive employees, their beneficiaries, and covered dependents after employment but before retirement."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FederalFundsPurchasedBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount borrowed by a bank, at the federal funds rate, from another bank to meet its reserve requirements. This item is typically available for the bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FederalFundsSoldBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Federal funds transactions involve lending (federal funds sold) or borrowing (federal funds purchased) of immediately available reserve balances. This item is typically available for the bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FederalHomeLoanBankStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Federal Home Loan Bank stock represents an equity interest in a FHLB. It does not have a readily determinable fair value because its ownership is restricted and it lacks a market (liquidity). This item is typically available for the bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FinancialAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Fair values as of the balance sheet date of all assets resulting from contracts that meet the criteria of being accounted for as derivative instruments, net of the effects of master netting arrangements."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FinancialInstrumentsSoldUnderAgreementsToRepurchaseBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying value as of the balance sheet date of securities that an institution sells and agrees to repurchase (the identical or substantially the same securities) as a seller-borrower at a specified date for a specified price, also known as a repurchase agreement. This item is typically available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FinishedGoodsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying amount as of the balance sheet date of merchandise or goods held by the company that are readily available for sale. This item is typically available for mining and manufacturing industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FlightFleetVehicleAndRelatedEquipmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """It is one of the important fixed assets for transportation industry, which includes bicycles, cars, motorcycles, trains, ships, boats, and aircraft. This item is typically available for transportation industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ForeclosedAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying amount as of the balance sheet date of all assets obtained in full or partial satisfaction of a debt arrangement through foreclosure proceedings or defeasance; includes real and personal property; equity interests in corporations, partnerships, and joint ventures; and beneficial interest in trusts. This item is typically typically available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ForeignCurrencyTranslationAdjustmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Changes to accumulated comprehensive income that results from the process of translating subsidiary financial statements and foreign equity investments into functional currency of the reporting company."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InventoriesAdjustmentsAllowancesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This item represents certain charges made in the current period in inventory resulting from such factors as breakage, spoilage, employee theft and shoplifting. This item is typically available for manufacturing, mining and utility industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InvestmentsInOtherVenturesUnderEquityMethodBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This item represents the carrying amount on the company's balance sheet of its investments in common stock of an equity method. This item is typically available for the insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LandAndImprovementsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Fixed Assets that specifically deal with land a company owns. Includes the improvements associated with land. This excludes land held for sale."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LeasesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Carrying amount at the balance sheet date of a long-lived, depreciable asset that is an addition or improvement to assets held under lease arrangement. This item is usually not available for the insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LiabilitiesOfDiscontinuedOperationsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The obligations arising from the sale, disposal, or planned sale in the near future (generally within one year) of a disposal group, including a component of the entity (discontinued operation). This item is typically available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LineOfCreditBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying value as of the balance sheet date of obligations drawn from a line of credit, which is a bank's commitment to make loans up to a specific amount."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LoansHeldForSaleBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """It means the aggregate amount of loans receivable that will be sold to other entities. This item is typically available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LoansReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Reflects the carrying amount of unpaid loans issued to other institutions for cash needs or an asset purchase."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class MachineryFurnitureEquipmentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Fixed assets specifically dealing with tools, equipment and office furniture. This item is usually not available for the insurance and utility industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class MaterialsAndSuppliesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Aggregated amount of unprocessed materials to be used in manufacturing or production process and supplies that will be consumed. This item is typically available for the utility industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class MineralPropertiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A fixed asset that represents strictly mineral type properties. This item is typically available for mining industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class MortgageLoanBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This is a lien on real estate to protect a lender. This item is typically available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class MortgageAndConsumerloansBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """It means the aggregate amount of mortgage and consumer loans. This item is typically available for the insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class GrossNotesReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """An amount representing an agreement for an unconditional promise by the maker to pay the entity (holder) a definite sum of money at a future date(s) within one year of the balance sheet date or the normal operating cycle. Such amount may include accrued interest receivable in accordance with the terms of the note. The note also may contain provisions including a discount or premium, payable on demand, secured, or unsecured, interest bearing or non-interest bearing, among myriad other features and characteristics. This item is typically available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other non-current assets that are not otherwise classified."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherCapitalStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other Capital Stock that is not otherwise classified."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherCurrentAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other current assets that are not otherwise classified."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherCurrentBorrowingsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Short Term Borrowings that are not otherwise classified."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherEquityAdjustmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other adjustments to stockholders' equity that is not otherwise classified, including other reserves."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherInventoriesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other non-current inventories not otherwise classified."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherInvestedAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """An item represents all the other investments or/and securities that cannot be defined into any category above. This item is typically available for the insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherNonCurrentAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other non-current assets that are not otherwise classified."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherPropertiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other fixed assets not otherwise classified."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherRealEstateOwnedBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The Carrying amount as of the balance sheet date of other real estate, which may include real estate investments, real estate loans that qualify as investments in real estate, and premises that are no longer used in operations may also be included in real estate owned. This does not include real estate assets taken in settlement of troubled loans through surrender or foreclosure. This item is typically available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherReceivablesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other non-current receivables not otherwise classified."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NonCurrentPensionAndOtherPostretirementBenefitPlansBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A loan issued by an insurance company that uses the cash value of a person's life insurance policy as collateral. This item is usually only available in the insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PolicyLoansBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A loan issued by an insurance company that uses the cash value of a person's life insurance policy as collateral. This item is usually only available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PreferredStockEquityBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A class of ownership in a company that has a higher claim on the assets and earnings than common stock. Preferred stock generally has a dividend that must be paid out before dividends to common stockholders and the shares usually do not have voting rights."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PropertiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Tangible assets that are held by an entity for use in the production or supply of goods and services, for rental to others, or for administrative purposes and that are expected to provide economic benefit for more than one year. This item is available for manufacturing, bank and transportation industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CurrentProvisionsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Provisions are created to protect the interests of one or both parties named in a contract or legal document which is a preparatory action or measure. Current provision is expired within one accounting PeriodAsByte."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LongTermProvisionsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Provisions are created to protect the interests of one or both parties named in a contract or legal document which is a preparatory action or measure. Long-term provision is expired beyond one accounting PeriodAsByte."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RawMaterialsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Carrying amount as of the balance sheet data of unprocessed items to be consumed in the manufacturing or production process. This item is available for manufacturing and mining industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ReceivablesAdjustmentsAllowancesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A provision relating to a written agreement to receive money at a specified future date(s) (within one year from the reporting date or the normal operating cycle, whichever is longer), consisting of principal as well as any accrued interest)."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RegulatoryAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Carrying amount as of the balance sheet date of capitalized costs of regulated entities that are expected to be recovered through revenue sources over one year or beyond the normal operating cycle."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RegulatoryLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount for the individual regulatory noncurrent liability as itemized in a table of regulatory noncurrent liabilities as of the end of the PeriodAsByte. Such things as the costs of energy efficiency programs and low-income energy assistances programs and deferred fuel. This item is usually only available for utility industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ReinsuranceBalancesPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying amount as of the balance sheet date of the known and estimated amounts owed to insurers under reinsurance treaties or other arrangements. This item is usually only available for insurance industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RestrictedCashBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying amounts of cash and cash equivalent items, which are restricted as to withdrawal or usage. Restrictions may include legally restricted deposits held as compensating balances against short-term borrowing arrangements, contracts entered into with others, or entity statements of intention with regard to particular deposits; however, time deposits and short-term certificates of deposit are not generally included in legally restricted deposits. Excludes compensating balance arrangements that are not agreements, which legally restrict the use of cash amounts shown on the balance sheet. For a classified balance sheet, represents the current portion only (the non-current portion has a separate concept); for an unclassified balance sheet represents the entire amount. This item is usually not available for bank and insurance industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RestrictedCashAndCashEquivalentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying amounts of cash and cash equivalent items which are restricted as to withdrawal or usage. This item is available for bank and insurance industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RestrictedCashAndInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The cash and investments whose use in whole or in part is restricted for the long-term, generally by contractual agreements or regulatory requirements. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RestrictedCommonStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Shares of stock for which sale is contractually or governmentally restricted for a given period of time. Stock that is acquired through an employee stock option plan or other private means may not be transferred. Restricted stock must be traded in compliance with special SEC regulations."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class RestrictedInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Investments whose use is restricted in whole or in part, generally by contractual agreements or regulatory requirements. This item is usually only available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TaxesReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Carrying amount due within one year of the balance sheet date (or one operating cycle, if longer) from tax authorities as of the balance sheet date representing refunds of overpayments or recoveries based on agreed-upon resolutions of disputes. This item is usually not available for bank industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalCapitalizationBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Stockholder's Equity plus Long Term Debt."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalDeferredCreditsAndOtherNonCurrentLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Revenue received by a firm but not yet reported as income. This item is usually only available for utility industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class UnbilledReceivablesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Revenues that are not currently billed from the customer under the terms of the contract. This item is usually only available for utility industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class UnrealizedGainLossBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A profit or loss that results from holding onto an asset rather than cashing it in and officially taking the profit or loss."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class WorkInProcessBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Work, or goods, in the process of being fabricated or manufactured but not yet completed as finished goods. This item is usually available for manufacturing and mining industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherNonCurrentLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This item is usually not available for bank and insurance industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CapitalLeaseObligationsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Current Portion of Capital Lease Obligation plus Long Term Portion of Capital Lease Obligation."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This item is available for bank and insurance industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Payables and Accrued Expenses that are not defined as Trade, Tax or Dividends related."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TangibleBookValueBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The company's total book value less the value of any intangible assets. Methodology: Common Stock Equity minus Goodwill and Other Intangible Assets"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalEquityBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total Equity equals Preferred Stock Equity + Common Stock Equity."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class WorkingCapitalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Current Assets minus Current Liabilities. This item is usually not available for bank and insurance industries."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalDebtBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All borrowings incurred by the company including debt and capital lease obligations."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CommonUtilityPlantBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount for the other plant related to the utility industry fix assets."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ElectricUtilityPlantBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount for the electric plant related to the utility industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NaturalGasFuelAndOtherBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount for the natural gas, fuel and other items related to the utility industry, which might include oil and gas wells, the properties to exploit oil and gas or liquefied natural gas sites."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetUtilityPlantBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net utility plant might include water production, electric utility plan, natural gas, fuel and other, common utility plant and accumulated depreciation. This item is usually only available for utility industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class WaterProductionBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount for a facility and plant that provides water which might include wells, reservoirs, pumping stations, and control facilities; and waste water systems which includes the waste treatment and disposal facility and equipment. This item is usually only available for utility industry."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OrdinarySharesNumberBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Number of Common or Ordinary Shares."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class PreferredSharesNumberBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Number of Preferred Shares."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TreasurySharesNumberBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Number of Treasury Shares."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TradingAndOtherReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This will serve as the "parent" value to AccountsReceivable (DataId 23001) and OtherReceivables (DataId 23342) for all company financials reported in the IFRS GAAP."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class EquityAttributableToOwnersOfParentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SecuritiesLoanedBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The carrying value as of the balance sheet date of securities loaned to other broker dealers, typically used by such parties to cover short sales, secured by cash or other securities furnished by such parties until the borrowing is closed."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class NetTangibleAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net assets in physical form. This is calculated using Stockholders' Equity less Intangible Assets (including Goodwill)."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def one_month(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def six_months(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def nine_months(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DuefromRelatedPartiesCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts owed to the company from a non-arm's length entity, due within the company's current operating cycle."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DuefromRelatedPartiesNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts owed to the company from a non-arm's length entity, due after the company's current operating cycle."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DuetoRelatedPartiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts owed by the company to a non-arm's length entity."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DuetoRelatedPartiesCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts owed by the company to a non-arm's length entity that has to be repaid within the company's current operating cycle."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DuetoRelatedPartiesNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts owed by the company to a non-arm's length entity that has to be repaid after the company's current operating cycle."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InvestmentPropertiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Company's investments in properties net of accumulated depreciation, which generate a return."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InvestmentsinSubsidiariesatCostBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A stake in any company which is more than 51%."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InvestmentsinAssociatesatCostBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A stake in any company which is more than 20% but less than 50%."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InvestmentsinJointVenturesatCostBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A 50% stake in any company in which remaining 50% belongs to other company."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class InvestmentinFinancialAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the sum of all financial investments (trading securities, available-for-sale securities, held-to-maturity securities, etc.)"""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def two_months(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class FinanceLeaseReceivablesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Accounts owed to the bank in relation to capital leases. Capital/ finance lease obligation are contractual obligations that arise from obtaining the use of property or equipment via a capital lease contract."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ConvertibleLoansCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This represents loans that entitle the lender (or the holder of loan debenture) to convert the loan to common or preferred stock (ordinary or preference shares) within the next 12 months or operating cycle."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class BankLoansCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A debt financing obligation issued by a bank or similar financial institution to a company, that entitles the lender or holder of the instrument to interest payments and the repayment of principal at a specified time within the next 12 months or operating cycle."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherLoansCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other loans between the customer and bank which cannot be identified by other specific items in the Debt section, due within the next 12 months or operating cycle."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AccruedandDeferredIncomeBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of accrued liabilities and deferred income (amount received in advance but the services are not provided in respect of amount)."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class BankLoansNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A debt financing obligation issued by a bank or similar financial institution to a company, that entitles the lender or holder of the instrument to interest payments and the repayment of principal at a specified time beyond the current accounting PeriodAsByte."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherLoansNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other loans between the customer and bank which cannot be identified by other specific items in the Debt section, due beyond the current operating cycle."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OtherReservesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other reserves owned by the company that cannot be identified by other specific items in the Reserves section."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LoansandAdvancestoBankBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of loans and advances made to a bank or financial institution."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LoansandAdvancestoCustomerBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of loans and advances made to customers."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TreasuryBillsandOtherEligibleBillsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Investments backed by the central government, it usually carries less risk than other investments."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class EquitySharesInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Investments in shares of a company representing ownership in that company."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DepositsbyBankBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Banks investment in the ongoing entity."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class CustomerAccountsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Carrying value of amounts transferred by customers to third parties for security purposes that are expected to be returned or applied towards payment after one year or beyond the operating cycle, if longer."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ItemsinTheCourseofTransmissiontoOtherBanksBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Carrying amount as of the balance sheet date of drafts and bills of exchange that have been accepted by the reporting bank or by others for its own account, as its liability to holders of the drafts."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TradingandFinancialLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total carrying amount of total trading, financial liabilities and debt in a non-differentiated balance sheet."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DebtSecuritiesinIssueBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Any debt financial instrument issued instead of cash loan."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class SubordinatedLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The total carrying value of securities loaned to other broker dealers, typically used by such parties to cover short sales, secured by cash or other securities furnished by such parties until the borrowing is closed; in a Non-Differentiated Balance Sheet."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ProvisionsTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Provisions are created to protect the interests of one or both parties named in a contract or legal document, which is a preparatory action or measure. Current provision is expired within one accounting PeriodAsByte."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class OperatingLeaseAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A contract that allows for the use of an asset, but does not convey rights of ownership of the asset. An operating lease is not capitalized; it is accounted for as a rental expense in what is known as "off balance sheet financing." For the lessor, the asset being leased is accounted for as an asset and is depreciated as such."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class ClaimsOutstandingBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts owing to policy holders who have filed claims but have not yet been settled or paid."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LiabilitiesHeldforSaleCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Liabilities due within the next 12 months related from an asset classified as Held for Sale."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class LiabilitiesHeldforSaleNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Liabilities related to an asset classified as held for sale excluding the portion due the next 12 months or operating cycle."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class DebtSecuritiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Debt securities held as investments."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class TotalFinancialLeaseObligationsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the total amount of long-term capital leases that must be paid within the next accounting period for a Non- Differentiated Balance Sheet. Capital lease obligations are contractual obligations that arise from obtaining the use of property or equipment via a capital lease contract."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def twelve_months(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @property
    def has_value(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def value(self) -> float:
        """Returns the default value for the field"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new empty instance"""
        ...

    @overload
    def __init__(self, time_provider: QuantConnect.ITimeProvider, security_identifier: QuantConnect.SecurityIdentifier) -> None:
        """Creates a new instance for the given time and security"""
        ...

    def get_period_value(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    def get_period_values(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...


class AccruedandDeferredIncomeCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of Accrued Liabilities and Deferred Income (amount received in advance but the services are not provided in respect of amount) due within 1 year."""

    @property
    def default_period(self) -> str:
        """
        The default period
        
        This property is protected.
        """
        ...

    @property
    def three_months(self) -> float:
        """Gets/sets