# Generated by Django 4.0.6 on 2022-07-15 09:26

import datetime
import uuid
from decimal import Decimal

import colorfield.fields
import django.contrib.postgres.fields
import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import django_fsm
import mptt.fields
import wbcore.contrib.color.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("django_celery_beat", "0014_remove_clockedschedule_enabled"),
    ]

    operations = [
        migrations.CreateModel(
            name="Product",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=255)),
                ("description", models.TextField(blank=True, null=True)),
                ("isin", models.CharField(max_length=12)),
                ("share_price", models.PositiveIntegerField(default=100)),
                ("ticker", models.CharField(max_length=255)),
                ("bank_fees", models.DecimalField(decimal_places=6, max_digits=6)),
                ("management_fees", models.DecimalField(decimal_places=6, max_digits=6)),
                ("performance_fees", models.DecimalField(decimal_places=6, max_digits=6)),
                ("performance_fees_vat", models.DecimalField(decimal_places=6, max_digits=6)),
            ],
            options={
                "verbose_name": "Product",
                "verbose_name_plural": "Products",
                "ordering": ("title", "ticker", "isin"),
                "db_table": "portfolio_product",
            },
        ),
        migrations.CreateModel(
            name="Valuation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("status", django_fsm.FSMField(default="unlocked", max_length=50)),
                ("date", models.DateField(default=django.utils.timezone.now)),
                ("gross_value", models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True)),
                ("net_value", models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True)),
                ("shares", models.PositiveIntegerField(blank=True, null=True)),
                ("bank_fees", models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True)),
                ("management_fees", models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True)),
                ("performance_fees_net", models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True)),
                (
                    "performance_fees_gross",
                    models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True),
                ),
                ("position_value", models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True)),
                ("trade_value", models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True)),
                ("dividend_value", models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True)),
                ("cash_value", models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True)),
                ("customer_trades", models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True)),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="valuations",
                        to="wbportfolio.product",
                    ),
                ),
            ],
            options={
                "verbose_name": "Valuation",
                "verbose_name_plural": "Valuations",
                "db_table": "portfolio_valuation",
            },
        ),
        migrations.CreateModel(
            name="Strategy",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(blank=True, max_length=255, null=True)),
                ("ticker", models.CharField(max_length=255, unique=True)),
                ("isin", models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                "verbose_name": "Strategy",
                "verbose_name_plural": "Strategies",
                "db_table": "portfolio_strategy",
            },
        ),
        migrations.CreateModel(
            name="Equity",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("ticker", models.CharField(max_length=64)),
                ("title", models.CharField(blank=True, max_length=255, null=True)),
                ("isin", models.CharField(blank=True, max_length=12, null=True)),
                ("industry", models.CharField(blank=True, max_length=255, null=True)),
                ("sector", models.CharField(blank=True, max_length=255, null=True)),
                ("subsector", models.CharField(blank=True, max_length=255, null=True)),
                ("exchange", models.CharField(default=1, max_length=64)),
            ],
            options={
                "verbose_name": "Equity",
                "verbose_name_plural": "Equities",
                "db_table": "portfolio_equity",
            },
        ),
        migrations.CreateModel(
            name="StrategyPosition",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date", models.DateField(default=django.utils.timezone.now)),
                ("price", models.DecimalField(decimal_places=4, max_digits=16)),
                ("currency_fx_rate", models.DecimalField(decimal_places=8, default=1.0, max_digits=14)),
                ("weighting", models.DecimalField(blank=True, decimal_places=6, max_digits=7, null=True)),
                (
                    "parent_strategy",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="child_strategy_positions",
                        to="wbportfolio.strategy",
                    ),
                ),
                (
                    "strategy",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="strategy_positions",
                        to="wbportfolio.strategy",
                    ),
                ),
            ],
            options={
                "db_table": "portfolio_strategyposition",
            },
        ),
        migrations.CreateModel(
            name="EquityPosition",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date", models.DateField(default=django.utils.timezone.now)),
                ("price", models.DecimalField(decimal_places=4, max_digits=16)),
                ("currency_fx_rate", models.DecimalField(decimal_places=8, default=1.0, max_digits=14)),
                ("shares", models.IntegerField(blank=True, null=True)),
                ("weighting", models.DecimalField(blank=True, decimal_places=6, max_digits=7, null=True)),
                (
                    "equity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, related_name="positions", to="wbportfolio.equity"
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="equity_positions",
                        to="wbportfolio.product",
                    ),
                ),
                (
                    "strategy",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="equity_positions",
                        to="wbportfolio.strategy",
                    ),
                ),
                ("equity_valuation_date", models.DateField(default=django.utils.timezone.now)),
            ],
            options={
                "verbose_name": "Equity Position",
                "verbose_name_plural": "Equity Positions",
                "db_table": "portfolio_equityposition",
            },
        ),
        migrations.AlterField(
            model_name="valuation",
            name="gross_value",
            field=models.DecimalField(blank=True, decimal_places=6, max_digits=16, null=True),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="net_value",
            field=models.DecimalField(blank=True, decimal_places=6, max_digits=16, null=True),
        ),
        migrations.AddField(
            model_name="equity",
            name="is_cash",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="strategy",
            name="is_cash",
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name="equity",
            name="exchange",
            field=models.CharField(blank=True, max_length=64, null=True),
        ),
        migrations.RemoveField(
            model_name="valuation",
            name="bank_fees",
        ),
        migrations.RemoveField(
            model_name="valuation",
            name="cash_value",
        ),
        migrations.RemoveField(
            model_name="valuation",
            name="customer_trades",
        ),
        migrations.RemoveField(
            model_name="valuation",
            name="dividend_value",
        ),
        migrations.RemoveField(
            model_name="valuation",
            name="management_fees",
        ),
        migrations.RemoveField(
            model_name="valuation",
            name="performance_fees_gross",
        ),
        migrations.RemoveField(
            model_name="valuation",
            name="performance_fees_net",
        ),
        migrations.RemoveField(
            model_name="valuation",
            name="position_value",
        ),
        migrations.RemoveField(
            model_name="valuation",
            name="shares",
        ),
        migrations.RemoveField(
            model_name="valuation",
            name="trade_value",
        ),
        migrations.AlterField(
            model_name="valuation",
            name="net_value",
            field=models.DecimalField(decimal_places=6, default=1, max_digits=16),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="valuation",
            name="calculated",
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name="strategyposition",
            name="currency_fx_rate",
            field=models.DecimalField(blank=True, decimal_places=8, default=1.0, max_digits=14, null=True),
        ),
        migrations.AlterField(
            model_name="strategyposition",
            name="price",
            field=models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True),
        ),
        migrations.CreateModel(
            name="HistoricalValuation",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[("unlocked", "Unlocked"), ("locked", "Locked")], default="unlocked", max_length=50
                    ),
                ),
                ("date", models.DateField(default=django.utils.timezone.now)),
                ("net_value", models.DecimalField(decimal_places=6, max_digits=16)),
                ("gross_value", models.DecimalField(blank=True, decimal_places=6, max_digits=16, null=True)),
                ("calculated", models.BooleanField(default=False)),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.product",
                    ),
                ),
                ("beta", models.FloatField(blank=True, null=True)),
                ("correlation", models.FloatField(blank=True, null=True)),
                ("sharpe_ratio", models.FloatField(blank=True, null=True)),
            ],
            options={
                "verbose_name": "historical Valuation",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
                "db_table": "portfolio_historicalvaluation",
            },
        ),
        migrations.CreateModel(
            name="HistoricalTrade",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                (
                    "trade_type",
                    models.CharField(
                        choices=[("rebalance", "Rebalance"), ("decrease", "Decrease"), ("increase", "Increase")],
                        default="rebalance",
                        max_length=15,
                    ),
                ),
                ("trade_date", models.DateField(default=django.utils.timezone.now)),
                ("shares", models.IntegerField()),
                ("price", models.DecimalField(decimal_places=4, default=0.0, max_digits=16)),
                ("currency_fx_rate", models.DecimalField(decimal_places=8, default=1.0, max_digits=14)),
                ("execution_fees", models.DecimalField(decimal_places=4, default=0.0, max_digits=16)),
                ("market_fees", models.DecimalField(decimal_places=4, default=0.0, max_digits=16)),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "equity",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.equity",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.product",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Trade",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
                "db_table": "portfolio_historicaltrade",
            },
        ),
        migrations.CreateModel(
            name="HistoricalStrategy",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("title", models.CharField(blank=True, max_length=255, null=True)),
                ("ticker", models.CharField(db_index=True, max_length=255)),
                ("isin", models.CharField(blank=True, max_length=255, null=True)),
                ("is_cash", models.BooleanField(default=False)),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                ("risk_scale", models.PositiveIntegerField(blank=True, null=True)),
                ("base_color", models.CharField(default="#FF0000", max_length=64)),
            ],
            options={
                "verbose_name": "historical Strategy",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
                "db_table": "portfolio_historicalstrategy",
            },
        ),
        migrations.CreateModel(
            name="HistoricalFees",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("date", models.DateField(default=django.utils.timezone.now)),
                (
                    "bank_fees",
                    models.DecimalField(
                        decimal_places=4,
                        default=0.0,
                        help_text="Bank Fees that were generated for a product on a specific date",
                        max_digits=16,
                    ),
                ),
                (
                    "management_fees",
                    models.DecimalField(
                        decimal_places=4,
                        default=0.0,
                        help_text="Management Fees that were generated for a product on a specific date",
                        max_digits=16,
                    ),
                ),
                (
                    "performance_fees_net",
                    models.DecimalField(
                        decimal_places=4,
                        default=0.0,
                        help_text="Performance Fees Net that were generated for a product on a specific date",
                        max_digits=16,
                    ),
                ),
                (
                    "performance_fees_gross",
                    models.DecimalField(
                        decimal_places=4,
                        default=0.0,
                        help_text="Performance Fees Gross that were generated for a product on a specific date",
                        max_digits=16,
                    ),
                ),
                (
                    "calculated",
                    models.BooleanField(
                        default=True, help_text="A marker whether the fees were calculated or supplied."
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.product",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Fees",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
                "db_table": "portfolio_historicalfees",
            },
        ),
        migrations.CreateModel(
            name="HistoricalDividend",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("date", models.DateField(default=django.utils.timezone.now)),
                ("shares", models.IntegerField()),
                ("dividend_value", models.DecimalField(decimal_places=4, default=0.0, max_digits=16)),
                ("currency_fx_rate", models.DecimalField(decimal_places=8, default=1.0, max_digits=14)),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "equity",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.equity",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.product",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Dividend",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
                "db_table": "portfolio_historicaldividend",
            },
        ),
        migrations.CreateModel(
            name="HistoricalCustomerTrade",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                (
                    "trade_date",
                    models.DateField(
                        default=django.utils.timezone.now,
                        help_text="The date that the trade was traded.",
                        verbose_name="Trade Date",
                    ),
                ),
                (
                    "value_date",
                    models.DateField(
                        blank=True,
                        help_text="The date that the trade was valuated.",
                        null=True,
                        verbose_name="Value Date",
                    ),
                ),
                (
                    "bank",
                    models.CharField(
                        help_text="The bank/counterparty/custodian the trade went through.", max_length=255
                    ),
                ),
                ("shares", models.IntegerField(help_text="The number of shares that were traded.")),
                (
                    "price",
                    models.DecimalField(
                        blank=True, decimal_places=4, help_text="The price per share.", max_digits=10, null=True
                    ),
                ),
                (
                    "external_identifier",
                    models.CharField(
                        blank=True, help_text="An external identifier that was supplied.", max_length=255, null=True
                    ),
                ),
                (
                    "marked_for_deletion",
                    models.BooleanField(
                        default=False, help_text="If this is checked, then the trade is supposed to be deleted."
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.product",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Customer Trade",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
                "db_table": "portfolio_historicalcustomertrade",
            },
        ),
        migrations.AddField(
            model_name="product",
            name="strategy",
            field=models.ForeignKey(
                blank=True,
                help_text="The strategy that this product implements.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products",
                to="wbportfolio.strategy",
                verbose_name="Underlying Strategy",
            ),
        ),
        migrations.CreateModel(
            name="PortfolioRole",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "role_type",
                    models.CharField(
                        choices=[
                            ("manager", "Manager"),
                            ("risk_manager", "Risk Manager"),
                            ("analyst", "Analyst"),
                            ("portfolio_manager", "Portfolio Manager"),
                        ],
                        max_length=24,
                    ),
                ),
                ("start", models.DateField(blank=True, null=True)),
                ("end", models.DateField(blank=True, null=True)),
                ("weighting", models.FloatField(default=1)),
            ],
            options={
                "verbose_name": "Portfolio Role",
                "verbose_name_plural": "Portfolio Roles",
                "db_table": "portfolio_portfoliorole",
            },
        ),
        migrations.CreateModel(
            name="HistoricalPortfolioRole",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                (
                    "role_type",
                    models.CharField(
                        choices=[
                            ("manager", "Manager"),
                            ("risk_manager", "Risk Manager"),
                            ("analyst", "Analyst"),
                            ("portfolio_manager", "Portfolio Manager"),
                        ],
                        max_length=24,
                    ),
                ),
                ("start", models.DateField(blank=True, null=True)),
                ("end", models.DateField(blank=True, null=True)),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.product",
                    ),
                ),
                ("weighting", models.FloatField(default=1)),
                (
                    "strategy",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.strategy",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Portfolio Role",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
                "db_table": "portfolio_historicalportfoliorole",
            },
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="shares",
            field=models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True),
        ),
        migrations.AlterField(
            model_name="product",
            name="bank_fees",
            field=models.DecimalField(
                decimal_places=6,
                help_text="The fees that the bank receives each day for hosting this product in percent. Can only be between 0 and 99.99%.",
                max_digits=6,
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="isin",
            field=models.CharField(help_text="The ISIN provided by the bank.", max_length=12, verbose_name="ISIN"),
        ),
        migrations.AlterField(
            model_name="product",
            name="management_fees",
            field=models.DecimalField(
                decimal_places=6,
                help_text="The fees that you receive each day for managing this product in percent. Can only be between 0 and 99.99%.",
                max_digits=6,
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="performance_fees",
            field=models.DecimalField(
                decimal_places=6,
                help_text="The fees that you receive each day when a performance criteria is met in percent. Can only be between 0 and 99.99%.",
                max_digits=6,
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="performance_fees_vat",
            field=models.DecimalField(
                decimal_places=6,
                help_text="The VAT that gets deducted, when you receive performance fees. Can only be between 0 and 99.99%.",
                max_digits=6,
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="share_price",
            field=models.PositiveIntegerField(
                default=100,
                help_text="The initial share price that is used to calculate the nominal value of a product.",
                verbose_name="Share Price",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="ticker",
            field=models.CharField(
                help_text="The ticker provided by the bank.", max_length=255, verbose_name="Ticker"
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="title",
            field=models.CharField(max_length=255, verbose_name="Title"),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="status",
            field=django_fsm.FSMField(
                choices=[("unlocked", "Unlocked"), ("locked", "Locked")], default="unlocked", max_length=50
            ),
        ),
        migrations.CreateModel(
            name="HistoricalEquityPosition",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("date", models.DateField(default=django.utils.timezone.now)),
                ("equity_valuation_date", models.DateField(default=django.utils.timezone.now)),
                ("price", models.DecimalField(decimal_places=4, max_digits=16)),
                ("currency_fx_rate", models.DecimalField(decimal_places=8, default=1.0, max_digits=14)),
                ("shares", models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True)),
                ("weighting", models.DecimalField(blank=True, decimal_places=6, max_digits=7, null=True)),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "equity",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.equity",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.product",
                    ),
                ),
                (
                    "strategy",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.strategy",
                    ),
                ),
                ("avg_volume_50d", models.FloatField(blank=True, null=True)),
                ("volume", models.FloatField(blank=True, null=True)),
                ("market_capitalization", models.FloatField(blank=True, null=True)),
                ("theoretical_position", models.BooleanField(default=False)),
            ],
            options={
                "verbose_name": "historical Equity Position",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
                "db_table": "portfolio_historicalequityposition",
            },
        ),
        migrations.AddField(
            model_name="product",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True),
        ),
        migrations.AddField(
            model_name="product",
            name="no_aggregation",
            field=models.BooleanField(default=False),
        ),
        migrations.CreateModel(
            name="EquityCountry",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("code", models.CharField(max_length=8)),
                ("title", models.CharField(max_length=255)),
            ],
            options={
                "verbose_name": "Equity Country",
                "verbose_name_plural": "Equity Countries",
                "db_table": "portfolio_equitycountry",
            },
        ),
        migrations.RemoveField(
            model_name="equity",
            name="industry",
        ),
        migrations.RemoveField(
            model_name="equity",
            name="sector",
        ),
        migrations.RemoveField(
            model_name="equity",
            name="subsector",
        ),
        migrations.CreateModel(
            name="IndustryClassification",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("code", models.CharField(max_length=64)),
                (
                    "classification_type",
                    models.CharField(
                        choices=[
                            ("GICS_SECTOR", "GICS Sector"),
                            ("GICS_INDUSTRY_GROUP", "GICS Industry Group"),
                            ("GICS_INDUSTRY", "GICS Industry"),
                            ("GICS_SUB_INDUSTRY", "GICS Sub Industry"),
                        ],
                        max_length=64,
                    ),
                ),
                (
                    "parent_classification",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="children_classification",
                        to="wbportfolio.industryclassification",
                    ),
                ),
                ("title", models.CharField(default="", max_length=128)),
            ],
            options={
                "verbose_name": "Industry Classification",
                "verbose_name_plural": "Industry Classifications",
                "db_table": "portfolio_industryclassification",
            },
        ),
        migrations.AddField(
            model_name="equity",
            name="gics_classification",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to=models.Q(("classification_type", "GICS_SUB_INDUSTRY")),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="gics_equities",
                to="wbportfolio.industryclassification",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="asset_class",
            field=models.CharField(
                choices=[
                    ("EQUITY", "Equity"),
                    ("FIXED_INCOME", "Fixed income"),
                    ("PRIVATE_EQUITY", "Private equity"),
                    ("DERIVATIVE", "Derivative"),
                    ("CASH", "Cash"),
                    ("CRYPTOCURRENCY", "Cryptocurrency"),
                    ("COMMODITY", "Commodity"),
                    ("HEDGE_FUND", "Hedge Fund"),
                    ("MULTI_ASSET", "Multi Asset"),
                ],
                default="EQUITY",
                max_length=16,
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="investment_strategy",
            field=models.CharField(
                choices=[("LONG", "Long"), ("SHORT", "Short"), ("LONG_SHORT", "Long/Short")],
                default="LONG",
                max_length=16,
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="legal_structure",
            field=models.CharField(
                choices=[
                    ("AMC", "Actively Managed Certificate"),
                    ("SICAV_UCITS", "SICAV (UCITS)"),
                    ("PLC_UCITS", "PLC (UCITS)"),
                    ("SICAV_AIF", "SICAV (AIFs)"),
                    ("SCF_UCITS", "Swiss Contractual Fund (UCITS)"),
                    ("FCP_AIF", "FCP (AIFs)"),
                    ("PLC_AIF", "PLC (AIFs)"),
                    ("SCF_AIF", "Swiss Contractual Fund (AIF) "),
                ],
                default="AMC",
                max_length=16,
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="liquidity",
            field=models.CharField(
                choices=[
                    ("DAILY", "Daily"),
                    ("WEEKLY", "Weekly"),
                    ("MONTHLY", "Monthly"),
                    ("QUATERLY", "Quaterly"),
                    ("YEARLY", "Yearly"),
                ],
                default="DAILY",
                max_length=16,
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="risk_scale",
            field=models.IntegerField(
                default=4,
                validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(7)],
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="type_of_return",
            field=models.CharField(
                choices=[
                    ("TOTAL_RETURN", "Total return"),
                    ("YIELD", "Yield"),
                    ("PRICE_RETURN", "Price return"),
                    ("ABSOLUT_RETURN", "Absolut return"),
                ],
                default="TOTAL_RETURN",
                max_length=16,
            ),
        ),
        migrations.AddField(
            model_name="valuation",
            name="beta",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="valuation",
            name="correlation",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.CreateModel(
            name="StainlyBondInstrument",
            fields=[
                ("name", models.CharField(default="", max_length=256)),
                ("id", models.CharField(max_length=100, primary_key=True, serialize=False)),
            ],
            options={
                "db_table": "portfolio_stainlybondinstrument",
            },
        ),
        migrations.CreateModel(
            name="StainlyEquityInstrument",
            fields=[
                ("name", models.CharField(default="", max_length=256)),
                ("id", models.CharField(max_length=100, primary_key=True, serialize=False)),
            ],
            options={
                "db_table": "portfolio_stainlyequityinstrument",
            },
        ),
        migrations.AddField(
            model_name="product",
            name="stainly_benchmark_instrument",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products",
                to="wbportfolio.stainlyequityinstrument",
                verbose_name="The Stainly Instrument Benchmark Reference",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="stainly_risk_instrument",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products",
                to="wbportfolio.stainlybondinstrument",
                verbose_name="The Stainly Instrument Risk Free Rate Reference",
            ),
        ),
        migrations.AddField(
            model_name="equity",
            name="stainly_equity",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="equities",
                to="wbportfolio.stainlyequityinstrument",
                verbose_name="The Stainly Instrument Reference",
            ),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="avg_volume_50d",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="market_capitalization",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="product",
            name="template",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="product",
            name="url_lookup",
            field=models.CharField(blank=True, default="", max_length=255, null=True),
        ),
        migrations.AddField(
            model_name="product",
            name="base_color",
            field=models.CharField(
                choices=[
                    ("BLACK_1", "#3C4859"),
                    ("BLACK_2", "#6D7683"),
                    ("BLACK_3", "#9EA3AC"),
                    ("BLACK_4", "#CED1D5"),
                    ("DARK_BLUE_1", "#0585FF"),
                    ("DARK_BLUE_2", "#69B6FF"),
                    ("DARK_BLUE_3", "#B4DAFF"),
                    ("LIGHT_BLUE_1", "#70D6FF"),
                    ("LIGHT_BLUE_2", "#A9E7FF"),
                    ("LIGHT_BLUE_3", "#D4F3FF"),
                    ("TURQUOISE_DARK_1", "#01ABAA"),
                    ("TURQUOISE_DARK_2", "#67CDCC"),
                    ("TURQUOISE_DARK_3", "#B3E6E5"),
                    ("TURQUOISE_LIGHT_1", "#06D6A0"),
                    ("TURQUOISE_LIGHT_2", "#6AE7C6"),
                    ("TURQUOISE_LIGHT_3", "#B4F3E2"),
                    ("GREEN_1", "#8CD867"),
                    ("GREEN_2", "#BAE8A4"),
                    ("GREEN_3", "#DDF3D1"),
                    ("PURPLE_DARK_1", "#5624DA"),
                    ("PURPLE_DARK_2", "#9A7CE9"),
                    ("PURPLE_DARK_3", "#CCBDF4"),
                    ("PURPLE_LIGHT_1", "#A258E5"),
                    ("PURPLE_LIGHT_2", "#C79BEF"),
                    ("PURPLE_LIGHT_3", "#E3CDF7"),
                    ("PINK_1", "#EF476F"),
                    ("PINK_2", "#F591A9"),
                    ("PINK_3", "#FAC8D4"),
                    ("YELLOW_1", "#FFD166"),
                    ("YELLOW_2", "#FFE8B2"),
                ],
                default="DARK_BLUE_1",
                max_length=64,
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="logo_file",
            field=models.FileField(blank=True, null=True, upload_to="system/product_logo"),
        ),
        migrations.AddField(
            model_name="product",
            name="active_factsheet",
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name="valuation",
            name="sharpe_ratio",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AlterModelOptions(
            name="product",
            options={"ordering": ("title", "isin"), "verbose_name": "Product", "verbose_name_plural": "Products"},
        ),
        migrations.AlterField(
            model_name="product",
            name="ticker",
            field=models.CharField(
                blank=True,
                help_text="The ticker provided by the bank.",
                max_length=255,
                null=True,
                verbose_name="Ticker",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="factsheet_pdf_template",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="product",
            name="type",
            field=models.CharField(
                choices=[
                    ("TECHNOLOGY", "Technology"),
                    ("HEALTH_INNOVATIONS", "Health Innovations"),
                    ("ATONRA_TOPS", "Atonrâ Tops"),
                ],
                default="TECHNOLOGY",
                max_length=64,
            ),
        ),
        migrations.RenameField(
            model_name="product",
            old_name="stainly_benchmark_instrument",
            new_name="stainly_reference_instrument",
        ),
        migrations.AddField(
            model_name="product",
            name="stainly_benchmark_instruments",
            field=models.ManyToManyField(
                blank=True,
                related_name="stainly_instruments_products",
                to="wbportfolio.stainlyequityinstrument",
                verbose_name="The Stainly Instrument Benchmarks list",
            ),
        ),
        migrations.RenameField(
            model_name="product",
            old_name="template",
            new_name="factsheet_html_template",
        ),
        migrations.AddField(
            model_name="product",
            name="external_webpage",
            field=models.URLField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="volume",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="strategy",
            name="risk_scale",
            field=models.PositiveIntegerField(blank=True, null=True),
        ),
        migrations.CreateModel(
            name="FactsheetAsset",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("key", models.CharField(max_length=255, unique=True)),
                ("description", models.TextField(blank=True, null=True)),
                ("text", models.TextField(blank=True, null=True)),
                ("asset", models.FileField(blank=True, null=True, upload_to="portfolio/factsheet/assets")),
            ],
            options={
                "verbose_name": "Factsheet Asset",
                "verbose_name_plural": "Factsheet Assets",
                "db_table": "portfolio_factsheetasset",
            },
        ),
        migrations.AddField(
            model_name="strategy",
            name="base_color",
            field=models.CharField(default="#FF0000", max_length=64),
        ),
        migrations.AddField(
            model_name="product",
            name="strategy_theme",
            field=models.ForeignKey(
                blank=True,
                help_text="The base strategy which serves as an entrypoint to a theme.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products_theme",
                to="wbportfolio.strategy",
                verbose_name="Theme Strategy",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="description",
            field=models.TextField(default=""),
        ),
        migrations.AlterField(
            model_name="product",
            name="description",
            field=models.TextField(default=""),
        ),
        migrations.AlterField(
            model_name="product",
            name="active_factsheet",
            field=models.BooleanField(
                default=True, help_text="True if a factsheet needs to be available for this product"
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="is_factsheet_private",
            field=models.BooleanField(
                default=False,
                help_text="True if the factsheet cannot be present on the public menu (e.g. for white label customer)",
            ),
        ),
        migrations.CreateModel(
            name="HistoricalProduct",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
                ("description", models.TextField(default="")),
                (
                    "isin",
                    models.CharField(help_text="The ISIN provided by the bank.", max_length=12, verbose_name="ISIN"),
                ),
                (
                    "share_price",
                    models.PositiveIntegerField(
                        default=100,
                        help_text="The initial share price that is used to calculate the nominal value of a product.",
                        verbose_name="Share Price",
                    ),
                ),
                (
                    "ticker",
                    models.CharField(
                        blank=True,
                        help_text="The ticker provided by the bank.",
                        max_length=255,
                        null=True,
                        verbose_name="Ticker",
                    ),
                ),
                (
                    "bank_fees",
                    models.DecimalField(
                        decimal_places=6,
                        help_text="The fees that the bank receives each day for hosting this product in percent. Can only be between 0 and 99.99%.",
                        max_digits=6,
                    ),
                ),
                (
                    "management_fees",
                    models.DecimalField(
                        decimal_places=6,
                        help_text="The fees that you receive each day for managing this product in percent. Can only be between 0 and 99.99%.",
                        max_digits=6,
                    ),
                ),
                (
                    "performance_fees",
                    models.DecimalField(
                        decimal_places=6,
                        help_text="The fees that you receive each day when a performance criteria is met in percent. Can only be between 0 and 99.99%.",
                        max_digits=6,
                    ),
                ),
                (
                    "performance_fees_vat",
                    models.DecimalField(
                        decimal_places=6,
                        help_text="The VAT that gets deducted, when you receive performance fees. Can only be between 0 and 99.99%.",
                        max_digits=6,
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "strategy",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="The strategy that this product implements.",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.strategy",
                        verbose_name="Underlying Strategy",
                    ),
                ),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True)),
                ("no_aggregation", models.BooleanField(default=False)),
                (
                    "asset_class",
                    models.CharField(
                        choices=[
                            ("EQUITY", "Equity"),
                            ("FIXED_INCOME", "Fixed income"),
                            ("PRIVATE_EQUITY", "Private equity"),
                            ("DERIVATIVE", "Derivative"),
                            ("CASH", "Cash"),
                            ("CRYPTOCURRENCY", "Cryptocurrency"),
                            ("COMMODITY", "Commodity"),
                            ("HEDGE_FUND", "Hedge Fund"),
                            ("MULTI_ASSET", "Multi Asset"),
                        ],
                        default="EQUITY",
                        max_length=16,
                    ),
                ),
                (
                    "investment_strategy",
                    models.CharField(
                        choices=[("LONG", "Long"), ("SHORT", "Short"), ("LONG_SHORT", "Long/Short")],
                        default="LONG",
                        max_length=16,
                    ),
                ),
                (
                    "legal_structure",
                    models.CharField(
                        choices=[
                            ("AMC", "Actively Managed Certificate"),
                            ("SICAV_UCITS", "SICAV (UCITS)"),
                            ("PLC_UCITS", "PLC (UCITS)"),
                            ("SICAV_AIF", "SICAV (AIFs)"),
                            ("SCF_UCITS", "Swiss Contractual Fund (UCITS)"),
                            ("FCP_AIF", "FCP (AIFs)"),
                            ("PLC_AIF", "PLC (AIFs)"),
                            ("SCF_AIF", "Swiss Contractual Fund (AIF) "),
                        ],
                        default="AMC",
                        max_length=16,
                    ),
                ),
                (
                    "liquidity",
                    models.CharField(
                        choices=[
                            ("DAILY", "Daily"),
                            ("WEEKLY", "Weekly"),
                            ("MONTHLY", "Monthly"),
                            ("QUATERLY", "Quaterly"),
                            ("YEARLY", "Yearly"),
                        ],
                        default="DAILY",
                        max_length=16,
                    ),
                ),
                (
                    "risk_scale",
                    models.IntegerField(
                        default=4,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(7),
                        ],
                    ),
                ),
                (
                    "type_of_return",
                    models.CharField(
                        choices=[
                            ("TOTAL_RETURN", "Total return"),
                            ("YIELD", "Yield"),
                            ("PRICE_RETURN", "Price return"),
                            ("ABSOLUT_RETURN", "Absolut return"),
                        ],
                        default="TOTAL_RETURN",
                        max_length=16,
                    ),
                ),
                (
                    "stainly_reference_instrument",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.stainlyequityinstrument",
                        verbose_name="The Stainly Instrument Benchmark Reference",
                    ),
                ),
                (
                    "stainly_risk_instrument",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.stainlybondinstrument",
                        verbose_name="The Stainly Instrument Risk Free Rate Reference",
                    ),
                ),
                ("factsheet_html_template", models.TextField(blank=True, null=True)),
                (
                    "base_color",
                    models.CharField(
                        choices=[
                            ("BLACK_1", "#3C4859"),
                            ("BLACK_2", "#6D7683"),
                            ("BLACK_3", "#9EA3AC"),
                            ("BLACK_4", "#CED1D5"),
                            ("DARK_BLUE_1", "#0585FF"),
                            ("DARK_BLUE_2", "#69B6FF"),
                            ("DARK_BLUE_3", "#B4DAFF"),
                            ("LIGHT_BLUE_1", "#70D6FF"),
                            ("LIGHT_BLUE_2", "#A9E7FF"),
                            ("LIGHT_BLUE_3", "#D4F3FF"),
                            ("TURQUOISE_DARK_1", "#01ABAA"),
                            ("TURQUOISE_DARK_2", "#67CDCC"),
                            ("TURQUOISE_DARK_3", "#B3E6E5"),
                            ("TURQUOISE_LIGHT_1", "#06D6A0"),
                            ("TURQUOISE_LIGHT_2", "#6AE7C6"),
                            ("TURQUOISE_LIGHT_3", "#B4F3E2"),
                            ("GREEN_1", "#8CD867"),
                            ("GREEN_2", "#BAE8A4"),
                            ("GREEN_3", "#DDF3D1"),
                            ("PURPLE_DARK_1", "#5624DA"),
                            ("PURPLE_DARK_2", "#9A7CE9"),
                            ("PURPLE_DARK_3", "#CCBDF4"),
                            ("PURPLE_LIGHT_1", "#A258E5"),
                            ("PURPLE_LIGHT_2", "#C79BEF"),
                            ("PURPLE_LIGHT_3", "#E3CDF7"),
                            ("PINK_1", "#EF476F"),
                            ("PINK_2", "#F591A9"),
                            ("PINK_3", "#FAC8D4"),
                            ("YELLOW_1", "#FFD166"),
                            ("YELLOW_2", "#FFE8B2"),
                        ],
                        default="DARK_BLUE_1",
                        max_length=64,
                    ),
                ),
                ("url_lookup", models.CharField(blank=True, default="", max_length=255, null=True)),
                ("logo_file", models.TextField(blank=True, max_length=100, null=True)),
                (
                    "active_factsheet",
                    models.BooleanField(
                        default=True, help_text="True if a factsheet needs to be available for this product"
                    ),
                ),
                ("factsheet_pdf_template", models.TextField(blank=True, null=True)),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("TECHNOLOGY", "Technology"),
                            ("HEALTH_INNOVATIONS", "Health Innovations"),
                            ("ATONRA_TOPS", "Atonrâ Tops"),
                        ],
                        default="TECHNOLOGY",
                        max_length=64,
                    ),
                ),
                ("external_webpage", models.URLField(blank=True, null=True)),
                (
                    "is_factsheet_private",
                    models.BooleanField(
                        default=False,
                        help_text="True if the factsheet cannot be present on the public menu (e.g. for white label customer)",
                    ),
                ),
                (
                    "strategy_theme",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="The base strategy which serves as an entrypoint to a theme.",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.strategy",
                        verbose_name="Theme Strategy",
                    ),
                ),
                (
                    "issue_price",
                    models.PositiveIntegerField(
                        default=100,
                        help_text="The initial issue price that is displayed on the facthsheet",
                        verbose_name="Issue Price",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Product",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
                "db_table": "portfolio_historicalproduct",
            },
        ),
        migrations.AddField(
            model_name="equity",
            name="internal_product",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="internal_equity_positions",
                to="wbportfolio.product",
            ),
        ),
        migrations.CreateModel(
            name="HistoricalEquity",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("ticker", models.CharField(max_length=64)),
                ("exchange", models.CharField(blank=True, max_length=64, null=True)),
                ("title", models.CharField(blank=True, max_length=255, null=True)),
                ("isin", models.CharField(blank=True, max_length=12, null=True)),
                ("is_cash", models.BooleanField(default=False)),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "gics_classification",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        limit_choices_to=models.Q(("classification_type", "GICS_SUB_INDUSTRY")),
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.industryclassification",
                    ),
                ),
                (
                    "stainly_equity",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.stainlyequityinstrument",
                        verbose_name="The Stainly Instrument Reference",
                    ),
                ),
                (
                    "internal_product",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.product",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Equity",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
                "db_table": "portfolio_historicalequity",
            },
        ),
        migrations.AddField(
            model_name="equityposition",
            name="theoretical_position",
            field=models.BooleanField(default=False),
        ),
        migrations.CreateModel(
            name="HistoricalStrategyPosition",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("date", models.DateField(default=django.utils.timezone.now)),
                ("price", models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True)),
                (
                    "currency_fx_rate",
                    models.DecimalField(blank=True, decimal_places=8, default=1.0, max_digits=14, null=True),
                ),
                ("weighting", models.DecimalField(blank=True, decimal_places=6, max_digits=7, null=True)),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_strategy",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.strategy",
                    ),
                ),
                (
                    "strategy",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.strategy",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Strategy Position",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
                "db_table": "portfolio_historicalstrategyposition",
            },
        ),
        migrations.AlterModelOptions(
            name="strategyposition",
            options={"verbose_name": "Strategy Position", "verbose_name_plural": "Strategy Positions"},
        ),
        migrations.AlterField(
            model_name="historicalstrategy",
            name="ticker",
            field=models.CharField(max_length=255),
        ),
        migrations.AlterField(
            model_name="strategy",
            name="ticker",
            field=models.CharField(max_length=255),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="parent_equity",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="equity_children",
                to="wbportfolio.equity",
            ),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="parent_strategy",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="equity_children",
                to="wbportfolio.strategy",
            ),
        ),
        migrations.AddField(
            model_name="historicalequityposition",
            name="parent_equity",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.equity",
            ),
        ),
        migrations.AddField(
            model_name="historicalequityposition",
            name="parent_strategy",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.strategy",
            ),
        ),
        migrations.AddField(
            model_name="historicalstrategy",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.AddField(
            model_name="strategy",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="base_color",
            field=models.CharField(
                choices=[
                    ("BLACK_1", "#3C4859"),
                    ("BLACK_2", "#6D7683"),
                    ("BLACK_3", "#9EA3AC"),
                    ("BLACK_4", "#CED1D5"),
                    ("DARK_BLUE_1", "#0585FF"),
                    ("DARK_BLUE_2", "#69B6FF"),
                    ("DARK_BLUE_3", "#B4DAFF"),
                    ("LIGHT_BLUE_1", "#70D6FF"),
                    ("LIGHT_BLUE_2", "#A9E7FF"),
                    ("LIGHT_BLUE_3", "#D4F3FF"),
                    ("TURQUOISE_DARK_1", "#01ABAA"),
                    ("TURQUOISE_DARK_2", "#67CDCC"),
                    ("TURQUOISE_DARK_3", "#B3E6E5"),
                    ("TURQUOISE_LIGHT_1", "#05D6A1"),
                    ("TURQUOISE_LIGHT_2", "#69E7C6"),
                    ("TURQUOISE_LIGHT_3", "#ADF1E0"),
                    ("GREEN_1", "#8CD867"),
                    ("GREEN_2", "#BAE8A4"),
                    ("GREEN_3", "#DDF3D1"),
                    ("PURPLE_DARK_1", "#5624DA"),
                    ("PURPLE_DARK_2", "#9A7CE9"),
                    ("PURPLE_DARK_3", "#CCBDF4"),
                    ("PURPLE_LIGHT_1", "#A258E5"),
                    ("PURPLE_LIGHT_2", "#C79BEF"),
                    ("PURPLE_LIGHT_3", "#E3CDF7"),
                    ("PINK_1", "#EF476F"),
                    ("PINK_2", "#F591A9"),
                    ("PINK_3", "#FAC8D4"),
                    ("YELLOW_1", "#FFD166"),
                    ("YELLOW_2", "#FFE8B2"),
                ],
                default="DARK_BLUE_1",
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="base_color",
            field=models.CharField(
                choices=[
                    ("BLACK_1", "#3C4859"),
                    ("BLACK_2", "#6D7683"),
                    ("BLACK_3", "#9EA3AC"),
                    ("BLACK_4", "#CED1D5"),
                    ("DARK_BLUE_1", "#0585FF"),
                    ("DARK_BLUE_2", "#69B6FF"),
                    ("DARK_BLUE_3", "#B4DAFF"),
                    ("LIGHT_BLUE_1", "#70D6FF"),
                    ("LIGHT_BLUE_2", "#A9E7FF"),
                    ("LIGHT_BLUE_3", "#D4F3FF"),
                    ("TURQUOISE_DARK_1", "#01ABAA"),
                    ("TURQUOISE_DARK_2", "#67CDCC"),
                    ("TURQUOISE_DARK_3", "#B3E6E5"),
                    ("TURQUOISE_LIGHT_1", "#05D6A1"),
                    ("TURQUOISE_LIGHT_2", "#69E7C6"),
                    ("TURQUOISE_LIGHT_3", "#ADF1E0"),
                    ("GREEN_1", "#8CD867"),
                    ("GREEN_2", "#BAE8A4"),
                    ("GREEN_3", "#DDF3D1"),
                    ("PURPLE_DARK_1", "#5624DA"),
                    ("PURPLE_DARK_2", "#9A7CE9"),
                    ("PURPLE_DARK_3", "#CCBDF4"),
                    ("PURPLE_LIGHT_1", "#A258E5"),
                    ("PURPLE_LIGHT_2", "#C79BEF"),
                    ("PURPLE_LIGHT_3", "#E3CDF7"),
                    ("PINK_1", "#EF476F"),
                    ("PINK_2", "#F591A9"),
                    ("PINK_3", "#FAC8D4"),
                    ("YELLOW_1", "#FFD166"),
                    ("YELLOW_2", "#FFE8B2"),
                ],
                default="DARK_BLUE_1",
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="base_color",
            field=models.CharField(
                choices=[
                    ("BLACK_1", "#3C4859"),
                    ("BLACK_2", "#6D7683"),
                    ("BLACK_3", "#9EA3AC"),
                    ("BLACK_4", "#CED1D5"),
                    ("DARK_BLUE_1", "#0585FF"),
                    ("DARK_BLUE_2", "#69B6FF"),
                    ("DARK_BLUE_3", "#B4DAFF"),
                    ("LIGHT_BLUE_1", "#70D6FF"),
                    ("LIGHT_BLUE_2", "#A9E7FF"),
                    ("LIGHT_BLUE_3", "#D4F3FF"),
                    ("TURQUOISE_DARK_1", "#01ABAA"),
                    ("TURQUOISE_DARK_2", "#67CDCC"),
                    ("TURQUOISE_DARK_3", "#B3E6E5"),
                    ("TURQUOISE_LIGHT_1", "#05D6A1"),
                    ("TURQUOISE_LIGHT_2", "#69E7C6"),
                    ("TURQUOISE_LIGHT_3", "#ADF1E0"),
                    ("GREEN_1", "#8CD867"),
                    ("GREEN_2", "#BAE8A4"),
                    ("GREEN_3", "#DDF3D1"),
                    ("PURPLE_DARK_1", "#5624DA"),
                    ("PURPLE_DARK_2", "#9A7CE9"),
                    ("PURPLE_DARK_3", "#CCBDF4"),
                    ("PURPLE_LIGHT_1", "#A258E5"),
                    ("PURPLE_LIGHT_2", "#C79BEF"),
                    ("PURPLE_LIGHT_3", "#E3CDF7"),
                    ("PINK_1", "#EF476F"),
                    ("PINK_2", "#F591A9"),
                    ("PINK_3", "#FAC8D4"),
                    ("YELLOW_1", "#FFD166"),
                    ("YELLOW_2", "#FFE8B2"),
                ],
                default="DARK_BLUE_1",
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="base_color",
            field=models.CharField(
                choices=[
                    ("BLACK_1", "#3C4859"),
                    ("BLACK_2", "#6D7683"),
                    ("BLACK_3", "#9EA3AC"),
                    ("BLACK_4", "#CED1D5"),
                    ("DARK_BLUE_1", "#0585FF"),
                    ("DARK_BLUE_2", "#69B6FF"),
                    ("DARK_BLUE_3", "#B4DAFF"),
                    ("LIGHT_BLUE_1", "#70D6FF"),
                    ("LIGHT_BLUE_2", "#A9E7FF"),
                    ("LIGHT_BLUE_3", "#D4F3FF"),
                    ("TURQUOISE_DARK_1", "#01ABAA"),
                    ("TURQUOISE_DARK_2", "#67CDCC"),
                    ("TURQUOISE_DARK_3", "#B3E6E5"),
                    ("TURQUOISE_LIGHT_1", "#05D6A1"),
                    ("TURQUOISE_LIGHT_2", "#69E7C6"),
                    ("TURQUOISE_LIGHT_3", "#ADF1E0"),
                    ("GREEN_1", "#8CD867"),
                    ("GREEN_2", "#BAE8A4"),
                    ("GREEN_3", "#DDF3D1"),
                    ("PURPLE_DARK_1", "#5624DA"),
                    ("PURPLE_DARK_2", "#9A7CE9"),
                    ("PURPLE_DARK_3", "#CCBDF4"),
                    ("PURPLE_LIGHT_1", "#A258E5"),
                    ("PURPLE_LIGHT_2", "#C79BEF"),
                    ("PURPLE_LIGHT_3", "#E3CDF7"),
                    ("PINK_1", "#EF476F"),
                    ("PINK_2", "#F591A9"),
                    ("PINK_3", "#FAC8D4"),
                    ("YELLOW_1", "#FFD166"),
                    ("YELLOW_2", "#FFE8B2"),
                ],
                default="DARK_BLUE_1",
                max_length=64,
            ),
        ),
        migrations.DeleteModel(
            name="EquityCountry",
        ),
        migrations.AlterField(
            model_name="historicalvaluation",
            name="status",
            field=models.CharField(
                choices=[("unlocked", "Unlocked"), ("locked", "Locked")], default="unlocked", max_length=32
            ),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="status",
            field=models.CharField(
                choices=[("unlocked", "Unlocked"), ("locked", "Locked")], default="unlocked", max_length=32
            ),
        ),
        migrations.AddField(
            model_name="historicalcustomertrade",
            name="comment",
            field=models.TextField(default="", verbose_name="Comment"),
        ),
        migrations.CreateModel(
            name="FactsheetCategory",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=128)),
            ],
            options={
                "verbose_name": "Factsheet Category",
                "verbose_name_plural": "Factsheet Categories",
                "db_table": "portfolio_factsheetcategory",
            },
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="type",
        ),
        migrations.RemoveField(
            model_name="product",
            name="type",
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="factsheet_category",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The Visual Factsheet category",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.factsheetcategory",
                verbose_name="Factsheet Category",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="factsheet_category",
            field=models.ForeignKey(
                blank=True,
                help_text="The Visual Factsheet category",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products",
                to="wbportfolio.factsheetcategory",
                verbose_name="Factsheet Category",
            ),
        ),
        migrations.DeleteModel(
            name="HistoricalEquityPosition",
        ),
        migrations.AlterField(
            model_name="equity",
            name="exchange",
            field=models.CharField(blank=True, max_length=64, null=True, verbose_name="Exchange"),
        ),
        migrations.AlterField(
            model_name="equity",
            name="gics_classification",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to=models.Q(("classification_type", "GICS_SUB_INDUSTRY")),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="gics_equities",
                to="wbportfolio.industryclassification",
                verbose_name="GICS Classification",
            ),
        ),
        migrations.AlterField(
            model_name="equity",
            name="is_cash",
            field=models.BooleanField(default=False, verbose_name="Is Cash"),
        ),
        migrations.AlterField(
            model_name="equity",
            name="isin",
            field=models.CharField(blank=True, max_length=12, null=True, verbose_name="ISIN"),
        ),
        migrations.AlterField(
            model_name="equity",
            name="ticker",
            field=models.CharField(max_length=64, verbose_name="Ticker"),
        ),
        migrations.AlterField(
            model_name="equity",
            name="title",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Title"),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="avg_volume_50d",
            field=models.FloatField(blank=True, null=True, verbose_name="Average volume over 50 days"),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="currency_fx_rate",
            field=models.DecimalField(
                decimal_places=8, default=1.0, max_digits=14, verbose_name="Currency FOREX rate"
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="equity",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="positions",
                to="wbportfolio.equity",
                verbose_name="Equity",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="equity_valuation_date",
            field=models.DateField(default=django.utils.timezone.now, verbose_name="Valuation Date"),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="parent_equity",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="equity_children",
                to="wbportfolio.equity",
                verbose_name="Parent Equity",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="parent_strategy",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="equity_children",
                to="wbportfolio.strategy",
                verbose_name="Parent Strategy",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="product",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="equity_positions",
                to="wbportfolio.product",
                verbose_name="Product",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="shares",
            field=models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True, verbose_name="Shares"),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="strategy",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="equity_positions",
                to="wbportfolio.strategy",
                verbose_name="Strategy",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="weighting",
            field=models.DecimalField(blank=True, decimal_places=6, max_digits=7, null=True, verbose_name="Weight"),
        ),
        migrations.AlterField(
            model_name="historicalcustomertrade",
            name="external_identifier",
            field=models.CharField(
                blank=True,
                help_text="An external identifier that was supplied.",
                max_length=255,
                null=True,
                verbose_name="External Identifier",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomertrade",
            name="marked_for_deletion",
            field=models.BooleanField(
                default=False,
                help_text="If this is checked, then the trade is supposed to be deleted.",
                verbose_name="To be deleted",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomertrade",
            name="price",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The price per share.",
                max_digits=10,
                null=True,
                verbose_name="Price",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomertrade",
            name="shares",
            field=models.IntegerField(help_text="The number of shares that were traded.", verbose_name="Shares"),
        ),
        migrations.AlterField(
            model_name="historicalequity",
            name="exchange",
            field=models.CharField(blank=True, max_length=64, null=True, verbose_name="Exchange"),
        ),
        migrations.AlterField(
            model_name="historicalequity",
            name="gics_classification",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                limit_choices_to=models.Q(("classification_type", "GICS_SUB_INDUSTRY")),
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.industryclassification",
                verbose_name="GICS Classification",
            ),
        ),
        migrations.AlterField(
            model_name="historicalequity",
            name="is_cash",
            field=models.BooleanField(default=False, verbose_name="Is Cash"),
        ),
        migrations.AlterField(
            model_name="historicalequity",
            name="isin",
            field=models.CharField(blank=True, max_length=12, null=True, verbose_name="ISIN"),
        ),
        migrations.AlterField(
            model_name="historicalequity",
            name="ticker",
            field=models.CharField(max_length=64, verbose_name="Ticker"),
        ),
        migrations.AlterField(
            model_name="historicalequity",
            name="title",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Title"),
        ),
        migrations.AlterField(
            model_name="historicalfees",
            name="bank_fees",
            field=models.DecimalField(
                decimal_places=4,
                default=0.0,
                help_text="Bank Fees that were generated for a product on a specific date",
                max_digits=16,
                verbose_name="Bank Fees",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfees",
            name="calculated",
            field=models.BooleanField(
                default=True,
                help_text="A marker whether the fees were calculated or supplied.",
                verbose_name="Is calculated",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfees",
            name="management_fees",
            field=models.DecimalField(
                decimal_places=4,
                default=0.0,
                help_text="Management Fees that were generated for a product on a specific date",
                max_digits=16,
                verbose_name="Management Fees",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfees",
            name="performance_fees_gross",
            field=models.DecimalField(
                decimal_places=4,
                default=0.0,
                help_text="Performance Fees Gross that were generated for a product on a specific date",
                max_digits=16,
                verbose_name="Performance Fees (Gross)",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfees",
            name="performance_fees_net",
            field=models.DecimalField(
                decimal_places=4,
                default=0.0,
                help_text="Performance Fees Net that were generated for a product on a specific date",
                max_digits=16,
                verbose_name="Performance Fees (Net)",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfees",
            name="product",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.product",
                verbose_name="Product",
            ),
        ),
        migrations.AlterField(
            model_name="historicalportfoliorole",
            name="product",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.product",
                verbose_name="Product",
            ),
        ),
        migrations.AlterField(
            model_name="historicalportfoliorole",
            name="role_type",
            field=models.CharField(
                choices=[
                    ("manager", "Manager"),
                    ("risk_manager", "Risk Manager"),
                    ("analyst", "Analyst"),
                    ("portfolio_manager", "Portfolio Manager"),
                ],
                max_length=24,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="historicalportfoliorole",
            name="strategy",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.strategy",
                verbose_name="Strategy",
            ),
        ),
        migrations.AlterField(
            model_name="historicalportfoliorole",
            name="weighting",
            field=models.FloatField(default=1, verbose_name="Weight"),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="asset_class",
            field=models.CharField(
                choices=[
                    ("EQUITY", "Equity"),
                    ("FIXED_INCOME", "Fixed income"),
                    ("PRIVATE_EQUITY", "Private equity"),
                    ("DERIVATIVE", "Derivative"),
                    ("CASH", "Cash"),
                    ("CRYPTOCURRENCY", "Cryptocurrency"),
                    ("COMMODITY", "Commodity"),
                    ("HEDGE_FUND", "Hedge Fund"),
                    ("MULTI_ASSET", "Multi Asset"),
                ],
                default="EQUITY",
                max_length=16,
                verbose_name="Asset Class",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="bank_fees",
            field=models.DecimalField(
                decimal_places=6,
                help_text="The fees that the bank receives each day for hosting this product in percent. Can only be between 0 and 99.99%.",
                max_digits=6,
                verbose_name="Bank Fees",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="description",
            field=models.TextField(default="", verbose_name="Description"),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="investment_strategy",
            field=models.CharField(
                choices=[("LONG", "Long"), ("SHORT", "Short"), ("LONG_SHORT", "Long/Short")],
                default="LONG",
                max_length=16,
                verbose_name="Long/Short Strategy",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="legal_structure",
            field=models.CharField(
                choices=[
                    ("AMC", "Actively Managed Certificate"),
                    ("SICAV_UCITS", "SICAV (UCITS)"),
                    ("PLC_UCITS", "PLC (UCITS)"),
                    ("SICAV_AIF", "SICAV (AIFs)"),
                    ("SCF_UCITS", "Swiss Contractual Fund (UCITS)"),
                    ("FCP_AIF", "FCP (AIFs)"),
                    ("PLC_AIF", "PLC (AIFs)"),
                    ("SCF_AIF", "Swiss Contractual Fund (AIF) "),
                ],
                default="AMC",
                max_length=16,
                verbose_name="Legal Structure",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="liquidity",
            field=models.CharField(
                choices=[
                    ("DAILY", "Daily"),
                    ("WEEKLY", "Weekly"),
                    ("MONTHLY", "Monthly"),
                    ("QUATERLY", "Quaterly"),
                    ("YEARLY", "Yearly"),
                ],
                default="DAILY",
                max_length=16,
                verbose_name="Liquidity",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="management_fees",
            field=models.DecimalField(
                decimal_places=6,
                help_text="The fees that you receive each day for managing this product in percent. Can only be between 0 and 99.99%.",
                max_digits=6,
                verbose_name="Management Fees",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="performance_fees",
            field=models.DecimalField(
                decimal_places=6,
                help_text="The fees that you receive each day when a performance criteria is met in percent. Can only be between 0 and 99.99%.",
                max_digits=6,
                verbose_name="Performance Fees",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="performance_fees_vat",
            field=models.DecimalField(
                decimal_places=6,
                help_text="The VAT that gets deducted, when you receive performance fees. Can only be between 0 and 99.99%.",
                max_digits=6,
                verbose_name="Performance fees (VAT)",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="risk_scale",
            field=models.IntegerField(
                default=4,
                validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(7)],
                verbose_name="Risk Scale",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="type_of_return",
            field=models.CharField(
                choices=[
                    ("TOTAL_RETURN", "Total return"),
                    ("YIELD", "Yield"),
                    ("PRICE_RETURN", "Price return"),
                    ("ABSOLUT_RETURN", "Absolut return"),
                ],
                default="TOTAL_RETURN",
                max_length=16,
                verbose_name="Type of Return",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="url_lookup",
            field=models.CharField(blank=True, default="", max_length=255, null=True, verbose_name="URL Identifier"),
        ),
        migrations.AlterField(
            model_name="historicalstrategy",
            name="isin",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="ISIN"),
        ),
        migrations.AlterField(
            model_name="historicalstrategy",
            name="risk_scale",
            field=models.PositiveIntegerField(blank=True, null=True, verbose_name="Risk Scale"),
        ),
        migrations.AlterField(
            model_name="historicalstrategy",
            name="ticker",
            field=models.CharField(max_length=255, verbose_name="Ticker"),
        ),
        migrations.AlterField(
            model_name="historicalstrategy",
            name="title",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Bank Title"),
        ),
        migrations.AlterField(
            model_name="historicalstrategy",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Factsheet Title"),
        ),
        migrations.AlterField(
            model_name="historicalstrategyposition",
            name="currency_fx_rate",
            field=models.DecimalField(
                blank=True, decimal_places=8, default=1.0, max_digits=14, null=True, verbose_name="FOREX rate"
            ),
        ),
        migrations.AlterField(
            model_name="historicalstrategyposition",
            name="date",
            field=models.DateField(default=django.utils.timezone.now, verbose_name="Date"),
        ),
        migrations.AlterField(
            model_name="historicalstrategyposition",
            name="parent_strategy",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.strategy",
                verbose_name="Parent Strategy",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstrategyposition",
            name="price",
            field=models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True, verbose_name="Price"),
        ),
        migrations.AlterField(
            model_name="historicalstrategyposition",
            name="strategy",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.strategy",
                verbose_name="Strategy",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstrategyposition",
            name="weighting",
            field=models.DecimalField(blank=True, decimal_places=6, max_digits=7, null=True, verbose_name="Weight"),
        ),
        migrations.AlterField(
            model_name="historicalvaluation",
            name="beta",
            field=models.FloatField(blank=True, null=True, verbose_name="Beta"),
        ),
        migrations.AlterField(
            model_name="historicalvaluation",
            name="calculated",
            field=models.BooleanField(default=False, verbose_name="Is Calculated"),
        ),
        migrations.AlterField(
            model_name="historicalvaluation",
            name="correlation",
            field=models.FloatField(blank=True, null=True, verbose_name="Correlation"),
        ),
        migrations.AlterField(
            model_name="historicalvaluation",
            name="date",
            field=models.DateField(default=django.utils.timezone.now, verbose_name="Date"),
        ),
        migrations.AlterField(
            model_name="historicalvaluation",
            name="gross_value",
            field=models.DecimalField(
                blank=True, decimal_places=6, max_digits=16, null=True, verbose_name="Value (Gross)"
            ),
        ),
        migrations.AlterField(
            model_name="historicalvaluation",
            name="net_value",
            field=models.DecimalField(decimal_places=6, max_digits=16, verbose_name="Value (Net)"),
        ),
        migrations.AlterField(
            model_name="historicalvaluation",
            name="product",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.product",
                verbose_name="Product",
            ),
        ),
        migrations.AlterField(
            model_name="historicalvaluation",
            name="sharpe_ratio",
            field=models.FloatField(blank=True, null=True, verbose_name="Sharpe Ratio"),
        ),
        migrations.AlterField(
            model_name="historicalvaluation",
            name="status",
            field=models.CharField(
                choices=[("unlocked", "Unlocked"), ("locked", "Locked")],
                default="unlocked",
                max_length=32,
                verbose_name="Status",
            ),
        ),
        migrations.AlterField(
            model_name="portfoliorole",
            name="role_type",
            field=models.CharField(
                choices=[
                    ("manager", "Manager"),
                    ("risk_manager", "Risk Manager"),
                    ("analyst", "Analyst"),
                    ("portfolio_manager", "Portfolio Manager"),
                ],
                max_length=24,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="portfoliorole",
            name="weighting",
            field=models.FloatField(default=1, verbose_name="Weight"),
        ),
        migrations.AlterField(
            model_name="product",
            name="asset_class",
            field=models.CharField(
                choices=[
                    ("EQUITY", "Equity"),
                    ("FIXED_INCOME", "Fixed income"),
                    ("PRIVATE_EQUITY", "Private equity"),
                    ("DERIVATIVE", "Derivative"),
                    ("CASH", "Cash"),
                    ("CRYPTOCURRENCY", "Cryptocurrency"),
                    ("COMMODITY", "Commodity"),
                    ("HEDGE_FUND", "Hedge Fund"),
                    ("MULTI_ASSET", "Multi Asset"),
                ],
                default="EQUITY",
                max_length=16,
                verbose_name="Asset Class",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="bank_fees",
            field=models.DecimalField(
                decimal_places=6,
                help_text="The fees that the bank receives each day for hosting this product in percent. Can only be between 0 and 99.99%.",
                max_digits=6,
                verbose_name="Bank Fees",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="description",
            field=models.TextField(default="", verbose_name="Description"),
        ),
        migrations.AlterField(
            model_name="product",
            name="investment_strategy",
            field=models.CharField(
                choices=[("LONG", "Long"), ("SHORT", "Short"), ("LONG_SHORT", "Long/Short")],
                default="LONG",
                max_length=16,
                verbose_name="Long/Short Strategy",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="legal_structure",
            field=models.CharField(
                choices=[
                    ("AMC", "Actively Managed Certificate"),
                    ("SICAV_UCITS", "SICAV (UCITS)"),
                    ("PLC_UCITS", "PLC (UCITS)"),
                    ("SICAV_AIF", "SICAV (AIFs)"),
                    ("SCF_UCITS", "Swiss Contractual Fund (UCITS)"),
                    ("FCP_AIF", "FCP (AIFs)"),
                    ("PLC_AIF", "PLC (AIFs)"),
                    ("SCF_AIF", "Swiss Contractual Fund (AIF) "),
                ],
                default="AMC",
                max_length=16,
                verbose_name="Legal Structure",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="liquidity",
            field=models.CharField(
                choices=[
                    ("DAILY", "Daily"),
                    ("WEEKLY", "Weekly"),
                    ("MONTHLY", "Monthly"),
                    ("QUATERLY", "Quaterly"),
                    ("YEARLY", "Yearly"),
                ],
                default="DAILY",
                max_length=16,
                verbose_name="Liquidity",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="management_fees",
            field=models.DecimalField(
                decimal_places=6,
                help_text="The fees that you receive each day for managing this product in percent. Can only be between 0 and 99.99%.",
                max_digits=6,
                verbose_name="Management Fees",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="performance_fees",
            field=models.DecimalField(
                decimal_places=6,
                help_text="The fees that you receive each day when a performance criteria is met in percent. Can only be between 0 and 99.99%.",
                max_digits=6,
                verbose_name="Performance Fees",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="performance_fees_vat",
            field=models.DecimalField(
                decimal_places=6,
                help_text="The VAT that gets deducted, when you receive performance fees. Can only be between 0 and 99.99%.",
                max_digits=6,
                verbose_name="Performance fees (VAT)",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="risk_scale",
            field=models.IntegerField(
                default=4,
                validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(7)],
                verbose_name="Risk Scale",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="type_of_return",
            field=models.CharField(
                choices=[
                    ("TOTAL_RETURN", "Total return"),
                    ("YIELD", "Yield"),
                    ("PRICE_RETURN", "Price return"),
                    ("ABSOLUT_RETURN", "Absolut return"),
                ],
                default="TOTAL_RETURN",
                max_length=16,
                verbose_name="Type of Return",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="url_lookup",
            field=models.CharField(blank=True, default="", max_length=255, null=True, verbose_name="URL Identifier"),
        ),
        migrations.AlterField(
            model_name="strategy",
            name="isin",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="ISIN"),
        ),
        migrations.AlterField(
            model_name="strategy",
            name="risk_scale",
            field=models.PositiveIntegerField(blank=True, null=True, verbose_name="Risk Scale"),
        ),
        migrations.AlterField(
            model_name="strategy",
            name="ticker",
            field=models.CharField(max_length=255, verbose_name="Ticker"),
        ),
        migrations.AlterField(
            model_name="strategy",
            name="title",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Bank Title"),
        ),
        migrations.AlterField(
            model_name="strategy",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Factsheet Title"),
        ),
        migrations.AlterField(
            model_name="strategyposition",
            name="currency_fx_rate",
            field=models.DecimalField(
                blank=True, decimal_places=8, default=1.0, max_digits=14, null=True, verbose_name="FOREX rate"
            ),
        ),
        migrations.AlterField(
            model_name="strategyposition",
            name="date",
            field=models.DateField(default=django.utils.timezone.now, verbose_name="Date"),
        ),
        migrations.AlterField(
            model_name="strategyposition",
            name="parent_strategy",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="child_strategy_positions",
                to="wbportfolio.strategy",
                verbose_name="Parent Strategy",
            ),
        ),
        migrations.AlterField(
            model_name="strategyposition",
            name="price",
            field=models.DecimalField(blank=True, decimal_places=4, max_digits=16, null=True, verbose_name="Price"),
        ),
        migrations.AlterField(
            model_name="strategyposition",
            name="strategy",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="strategy_positions",
                to="wbportfolio.strategy",
                verbose_name="Strategy",
            ),
        ),
        migrations.AlterField(
            model_name="strategyposition",
            name="weighting",
            field=models.DecimalField(blank=True, decimal_places=6, max_digits=7, null=True, verbose_name="Weight"),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="beta",
            field=models.FloatField(blank=True, null=True, verbose_name="Beta"),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="calculated",
            field=models.BooleanField(default=False, verbose_name="Is Calculated"),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="correlation",
            field=models.FloatField(blank=True, null=True, verbose_name="Correlation"),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="date",
            field=models.DateField(default=django.utils.timezone.now, verbose_name="Date"),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="gross_value",
            field=models.DecimalField(
                blank=True, decimal_places=6, max_digits=16, null=True, verbose_name="Value (Gross)"
            ),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="net_value",
            field=models.DecimalField(decimal_places=6, max_digits=16, verbose_name="Value (Net)"),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="valuations",
                to="wbportfolio.product",
                verbose_name="Product",
            ),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="sharpe_ratio",
            field=models.FloatField(blank=True, null=True, verbose_name="Sharpe Ratio"),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="status",
            field=models.CharField(
                choices=[("unlocked", "Unlocked"), ("locked", "Locked")],
                default="unlocked",
                max_length=32,
                verbose_name="Status",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="market_capitalization",
            field=models.FloatField(blank=True, null=True, verbose_name="Market Capitalization"),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="price",
            field=models.DecimalField(decimal_places=4, max_digits=16, verbose_name="Price"),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="volume",
            field=models.FloatField(blank=True, null=True, verbose_name="Daily Volume"),
        ),
        migrations.AlterField(
            model_name="historicalcustomertrade",
            name="product",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.product",
                verbose_name="Product",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfees",
            name="date",
            field=models.DateField(default=django.utils.timezone.now, verbose_name="Date"),
        ),
        migrations.AlterField(
            model_name="historicalportfoliorole",
            name="end",
            field=models.DateField(blank=True, null=True, verbose_name="End"),
        ),
        migrations.AlterField(
            model_name="historicalportfoliorole",
            name="start",
            field=models.DateField(blank=True, null=True, verbose_name="Start"),
        ),
        migrations.AlterField(
            model_name="historicaltrade",
            name="currency_fx_rate",
            field=models.DecimalField(decimal_places=8, default=1.0, max_digits=14, verbose_name="FOREX rate"),
        ),
        migrations.AlterField(
            model_name="historicaltrade",
            name="equity",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.equity",
                verbose_name="Equity",
            ),
        ),
        migrations.AlterField(
            model_name="historicaltrade",
            name="execution_fees",
            field=models.DecimalField(decimal_places=4, default=0.0, max_digits=16, verbose_name="Execution Fees"),
        ),
        migrations.AlterField(
            model_name="historicaltrade",
            name="market_fees",
            field=models.DecimalField(decimal_places=4, default=0.0, max_digits=16, verbose_name="Market Fees"),
        ),
        migrations.AlterField(
            model_name="historicaltrade",
            name="price",
            field=models.DecimalField(decimal_places=4, default=0.0, max_digits=16, verbose_name="Price"),
        ),
        migrations.AlterField(
            model_name="historicaltrade",
            name="product",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.product",
                verbose_name="Product",
            ),
        ),
        migrations.AlterField(
            model_name="historicaltrade",
            name="shares",
            field=models.IntegerField(verbose_name="Shares"),
        ),
        migrations.AlterField(
            model_name="historicaltrade",
            name="trade_date",
            field=models.DateField(default=django.utils.timezone.now, verbose_name="Date"),
        ),
        migrations.AlterField(
            model_name="historicaltrade",
            name="trade_type",
            field=models.CharField(
                choices=[("rebalance", "Rebalance"), ("decrease", "Decrease"), ("increase", "Increase")],
                default="rebalance",
                max_length=15,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="industryclassification",
            name="classification_type",
            field=models.CharField(
                choices=[
                    ("GICS_SECTOR", "GICS Sector"),
                    ("GICS_INDUSTRY_GROUP", "GICS Industry Group"),
                    ("GICS_INDUSTRY", "GICS Industry"),
                    ("GICS_SUB_INDUSTRY", "GICS Sub Industry"),
                ],
                max_length=64,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="industryclassification",
            name="code",
            field=models.CharField(max_length=64, verbose_name="Code"),
        ),
        migrations.AlterField(
            model_name="industryclassification",
            name="parent_classification",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="children_classification",
                to="wbportfolio.industryclassification",
                verbose_name="Parent Classification",
            ),
        ),
        migrations.AlterField(
            model_name="industryclassification",
            name="title",
            field=models.CharField(max_length=128, verbose_name="Title"),
        ),
        migrations.AlterField(
            model_name="portfoliorole",
            name="end",
            field=models.DateField(blank=True, null=True, verbose_name="End"),
        ),
        migrations.AlterField(
            model_name="portfoliorole",
            name="start",
            field=models.DateField(blank=True, null=True, verbose_name="Start"),
        ),
        migrations.AlterField(
            model_name="historicalvaluation",
            name="status",
            field=django_fsm.FSMField(
                choices=[("unlocked", "Unlocked"), ("locked", "Locked")],
                default="unlocked",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AlterField(
            model_name="valuation",
            name="status",
            field=django_fsm.FSMField(
                choices=[("unlocked", "Unlocked"), ("locked", "Locked")],
                default="unlocked",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AddField(
            model_name="equity",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Title Factsheet"),
        ),
        migrations.AddField(
            model_name="historicalequity",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Title Factsheet"),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="is_factsheet_private",
            field=models.BooleanField(
                default=True,
                help_text="True if the factsheet cannot be present on the public menu (e.g. for white label customer)",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="is_factsheet_private",
            field=models.BooleanField(
                default=True,
                help_text="True if the factsheet cannot be present on the public menu (e.g. for white label customer)",
            ),
        ),
        migrations.CreateModel(
            name="ProductGroup",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("identifier", models.CharField(max_length=255, verbose_name="Identifier")),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
                (
                    "type",
                    models.CharField(choices=[("Fund", "Fund")], default="Fund", max_length=64, verbose_name="Type"),
                ),
            ],
            options={
                "verbose_name": "Product Group",
                "verbose_name_plural": "Product Groups",
                "db_table": "portfolio_productgroup",
            },
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="group",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.productgroup",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="group",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products",
                to="wbportfolio.productgroup",
            ),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="product_group",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="equity_positions",
                to="wbportfolio.productgroup",
                verbose_name="Product Group",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomertrade",
            name="shares",
            field=models.FloatField(help_text="The number of shares that were traded.", verbose_name="Shares"),
        ),
        migrations.AlterField(
            model_name="historicalcustomertrade",
            name="shares",
            field=models.DecimalField(
                decimal_places=2,
                help_text="The number of shares that were traded.",
                max_digits=15,
                verbose_name="Shares",
            ),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="category",
            field=models.CharField(choices=[("Ucits", "Ucits")], default="Ucits", max_length=64),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="umbrella",
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.CreateModel(
            name="ProductGroupRepresentant",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "product_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="representants",
                        to="wbportfolio.productgroup",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Group Representant",
                "verbose_name_plural": "Product Group Representants",
                "db_table": "portfolio_productgrouprepresentant",
            },
        ),
        migrations.AlterField(
            model_name="productgroup",
            name="category",
            field=models.CharField(choices=[("UCITS", "Ucits")], default="UCITS", max_length=64),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="dividend",
            field=models.CharField(
                choices=[("CAPITALISATION", "Capitalisation"), ("DISTRIBUTION", "Distribution")],
                default="CAPITALISATION",
                max_length=16,
                verbose_name="Type of Dividends",
            ),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="minimum_subscription",
            field=models.IntegerField(
                default=100, help_text="Minimum subscription amount allowed to invest in the fund"
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="dividend",
            field=models.CharField(
                choices=[("CAPITALISATION", "Capitalisation"), ("DISTRIBUTION", "Distribution")],
                default="CAPITALISATION",
                max_length=16,
                verbose_name="Type of Dividends",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="minimum_subscription",
            field=models.IntegerField(
                default=100, help_text="Minimum subscription amount allowed to invest in the fund"
            ),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="cut_off_time",
            field=models.TimeField(default=datetime.time(13, 0)),
        ),
        migrations.AddField(
            model_name="product",
            name="cut_off_time",
            field=models.TimeField(default=datetime.time(13, 0)),
        ),
        migrations.AddField(
            model_name="historicalvaluation",
            name="is_fake",
            field=models.BooleanField(
                default=False, help_text="Set to True if the data is generated using back propagation"
            ),
        ),
        migrations.AddField(
            model_name="valuation",
            name="is_fake",
            field=models.BooleanField(
                default=False, help_text="Set to True if the data is generated using back propagation"
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="base_color",
            field=models.CharField(
                choices=[
                    ("BLACK_1", "#3C4859"),
                    ("BLACK_2", "#6D7683"),
                    ("BLACK_3", "#9EA3AC"),
                    ("BLACK_4", "#CED1D5"),
                    ("DARK_BLUE_1", "#0585FF"),
                    ("DARK_BLUE_2", "#69B6FF"),
                    ("DARK_BLUE_3", "#B4DAFF"),
                    ("LIGHT_BLUE_1", "#70D6FF"),
                    ("LIGHT_BLUE_2", "#A9E7FF"),
                    ("LIGHT_BLUE_3", "#D4F3FF"),
                    ("TURQUOISE_DARK_1", "#01ABAA"),
                    ("TURQUOISE_DARK_2", "#67CDCC"),
                    ("TURQUOISE_DARK_3", "#B3E6E5"),
                    ("TURQUOISE_LIGHT_1", "#05D6A1"),
                    ("TURQUOISE_LIGHT_2", "#69E7C6"),
                    ("TURQUOISE_LIGHT_3", "#ADF1E0"),
                    ("GREEN_1", "#8CD867"),
                    ("GREEN_2", "#BAE8A4"),
                    ("GREEN_3", "#DDF3D1"),
                    ("ORANGE_1", "#FF783A"),
                    ("ORANGE_2", "#FFAE89"),
                    ("ORANGE_3", "#FFC9B0"),
                    ("PURPLE_DARK_1", "#5624DA"),
                    ("PURPLE_DARK_2", "#9A7CE9"),
                    ("PURPLE_DARK_3", "#CCBDF4"),
                    ("PURPLE_LIGHT_1", "#A258E5"),
                    ("PURPLE_LIGHT_2", "#C79BEF"),
                    ("PURPLE_LIGHT_3", "#E3CDF7"),
                    ("PINK_1", "#EF476F"),
                    ("PINK_2", "#F591A9"),
                    ("PINK_3", "#FAC8D4"),
                    ("YELLOW_1", "#FFD166"),
                    ("YELLOW_2", "#FFE8B2"),
                ],
                default="DARK_BLUE_1",
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="base_color",
            field=models.CharField(
                choices=[
                    ("BLACK_1", "#3C4859"),
                    ("BLACK_2", "#6D7683"),
                    ("BLACK_3", "#9EA3AC"),
                    ("BLACK_4", "#CED1D5"),
                    ("DARK_BLUE_1", "#0585FF"),
                    ("DARK_BLUE_2", "#69B6FF"),
                    ("DARK_BLUE_3", "#B4DAFF"),
                    ("LIGHT_BLUE_1", "#70D6FF"),
                    ("LIGHT_BLUE_2", "#A9E7FF"),
                    ("LIGHT_BLUE_3", "#D4F3FF"),
                    ("TURQUOISE_DARK_1", "#01ABAA"),
                    ("TURQUOISE_DARK_2", "#67CDCC"),
                    ("TURQUOISE_DARK_3", "#B3E6E5"),
                    ("TURQUOISE_LIGHT_1", "#05D6A1"),
                    ("TURQUOISE_LIGHT_2", "#69E7C6"),
                    ("TURQUOISE_LIGHT_3", "#ADF1E0"),
                    ("GREEN_1", "#8CD867"),
                    ("GREEN_2", "#BAE8A4"),
                    ("GREEN_3", "#DDF3D1"),
                    ("ORANGE_1", "#FF783A"),
                    ("ORANGE_2", "#FFAE89"),
                    ("ORANGE_3", "#FFC9B0"),
                    ("PURPLE_DARK_1", "#5624DA"),
                    ("PURPLE_DARK_2", "#9A7CE9"),
                    ("PURPLE_DARK_3", "#CCBDF4"),
                    ("PURPLE_LIGHT_1", "#A258E5"),
                    ("PURPLE_LIGHT_2", "#C79BEF"),
                    ("PURPLE_LIGHT_3", "#E3CDF7"),
                    ("PINK_1", "#EF476F"),
                    ("PINK_2", "#F591A9"),
                    ("PINK_3", "#FAC8D4"),
                    ("YELLOW_1", "#FFD166"),
                    ("YELLOW_2", "#FFE8B2"),
                ],
                default="DARK_BLUE_1",
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomertrade",
            name="shares",
            field=models.DecimalField(
                decimal_places=4,
                help_text="The number of shares that were traded.",
                max_digits=15,
                verbose_name="Shares",
            ),
        ),
        migrations.AddField(
            model_name="equity",
            name="internal_product_group",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="internal_equity_positions",
                to="wbportfolio.productgroup",
            ),
        ),
        migrations.AddField(
            model_name="historicalequity",
            name="internal_product_group",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.productgroup",
            ),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="ticker_reuters",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Reuters Ticker"),
        ),
        migrations.AddField(
            model_name="product",
            name="ticker_reuters",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Reuters Ticker"),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="ticker",
            field=models.CharField(
                blank=True,
                help_text="The ticker provided by the bank.",
                max_length=255,
                null=True,
                verbose_name="Ticker Bloomberg",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="ticker",
            field=models.CharField(
                blank=True,
                help_text="The ticker provided by the bank.",
                max_length=255,
                null=True,
                verbose_name="Ticker Bloomberg",
            ),
        ),
        migrations.AddField(
            model_name="historicalvaluation",
            name="lock_statistics",
            field=models.BooleanField(
                default=False, help_text="If True, a save will not override the beta, correlation and sharpe ratio"
            ),
        ),
        migrations.AddField(
            model_name="valuation",
            name="lock_statistics",
            field=models.BooleanField(
                default=False, help_text="If True, a save will not override the beta, correlation and sharpe ratio"
            ),
        ),
        migrations.AddField(
            model_name="stainlyequityinstrument",
            name="stainly_id",
            field=models.CharField(default="", max_length=100),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="_custom_management_rebates",
            field=models.DecimalField(blank=True, decimal_places=5, max_digits=5, null=True),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="_custom_performance_rebates",
            field=models.DecimalField(blank=True, decimal_places=5, max_digits=5, null=True),
        ),
        migrations.AddField(
            model_name="product",
            name="_custom_management_rebates",
            field=models.DecimalField(blank=True, decimal_places=5, max_digits=5, null=True),
        ),
        migrations.AddField(
            model_name="product",
            name="_custom_performance_rebates",
            field=models.DecimalField(blank=True, decimal_places=5, max_digits=5, null=True),
        ),
        migrations.RenameModel(
            old_name="StainlyEquityInstrument",
            new_name="StainlyAsset",
        ),
        migrations.AlterField(
            model_name="equity",
            name="stainly_equity",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="equities",
                to="wbportfolio.stainlyasset",
                verbose_name="The Stainly Instrument Reference",
            ),
        ),
        migrations.AlterField(
            model_name="historicalequity",
            name="stainly_equity",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.stainlyasset",
                verbose_name="The Stainly Instrument Reference",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="stainly_reference_instrument",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.stainlyasset",
                verbose_name="The Stainly Instrument Benchmark Reference",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="stainly_benchmark_instruments",
            field=models.ManyToManyField(
                blank=True,
                related_name="stainly_instruments_products",
                to="wbportfolio.stainlyasset",
                verbose_name="The Stainly Instrument Benchmarks list",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="stainly_reference_instrument",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products",
                to="wbportfolio.stainlyasset",
                verbose_name="The Stainly Instrument Benchmark Reference",
            ),
        ),
        migrations.AddField(
            model_name="stainlyasset",
            name="type",
            field=models.CharField(
                choices=[
                    ("bond", "Bond"),
                    ("equity", "Equity"),
                    ("index", "Index"),
                    ("interestratesource", "Interest Rate"),
                ],
                default="equity",
                max_length=32,
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="stainly_risk_instrument",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.stainlyasset",
                verbose_name="The Stainly Instrument Risk Free Rate Reference",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="stainly_risk_instrument",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="product_risks",
                to="wbportfolio.stainlyasset",
                verbose_name="The Stainly Instrument Risk Free Rate Reference",
            ),
        ),
        migrations.DeleteModel(
            name="StainlyBondInstrument",
        ),
        migrations.AddField(
            model_name="stainlyasset",
            name="price_field",
            field=models.CharField(default="price_close", max_length=126),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="active_factsheet",
            field=models.BooleanField(
                default=False, help_text="True if a factsheet needs to be available for this product"
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="active_factsheet",
            field=models.BooleanField(
                default=False, help_text="True if a factsheet needs to be available for this product"
            ),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="market_shares",
            field=models.FloatField(blank=True, null=True, verbose_name="Market Shares"),
        ),
        migrations.AddField(
            model_name="historicalstrategy",
            name="description",
            field=models.TextField(default="", verbose_name="Description"),
        ),
        migrations.AddField(
            model_name="strategy",
            name="description",
            field=models.TextField(default="", verbose_name="Description"),
        ),
        migrations.AddField(
            model_name="historicalfees",
            name="crystalized_performance_fees",
            field=models.DecimalField(
                decimal_places=4,
                default=0.0,
                help_text="Performance Fees that are crystalized.",
                max_digits=16,
                verbose_name="Crystalized Performance Fees",
            ),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="_custom_management_rebates_indirect",
            field=models.DecimalField(blank=True, decimal_places=5, max_digits=5, null=True),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="_custom_minimum_investment",
            field=models.IntegerField(blank=True, null=True, verbose_name="Minimum AUM"),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="_custom_performance_rebates_indirect",
            field=models.DecimalField(blank=True, decimal_places=5, max_digits=5, null=True),
        ),
        migrations.AddField(
            model_name="product",
            name="_custom_management_rebates_indirect",
            field=models.DecimalField(blank=True, decimal_places=5, max_digits=5, null=True),
        ),
        migrations.AddField(
            model_name="product",
            name="_custom_minimum_investment",
            field=models.IntegerField(blank=True, null=True, verbose_name="Minimum AUM"),
        ),
        migrations.AddField(
            model_name="product",
            name="_custom_performance_rebates_indirect",
            field=models.DecimalField(blank=True, decimal_places=5, max_digits=5, null=True),
        ),
        migrations.CreateModel(
            name="Register",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("register_reference", models.CharField(max_length=255, unique=True)),
                ("register_name_1", models.CharField(max_length=255)),
                ("register_name_2", models.CharField(default="", max_length=255)),
                ("global_register_reference", models.CharField(default="", max_length=255)),
                ("external_register_reference", models.CharField(default="", max_length=255)),
                ("custodian_reference", models.CharField(max_length=255)),
                ("custodian_name_1", models.CharField(max_length=255)),
                ("custodian_name_2", models.CharField(default="", max_length=255)),
                ("custodian_address", models.TextField(default="")),
                ("custodian_postcode", models.CharField(default="", max_length=255)),
                ("custodian_city", models.CharField(default="", max_length=255)),
                ("sales_reference", models.CharField(default="", max_length=255)),
                ("dealer_reference", models.CharField(default="", max_length=255)),
                ("outlet_reference", models.CharField(max_length=255)),
                ("outlet_name", models.CharField(max_length=255)),
                ("outlet_address", models.TextField(default="")),
                ("outlet_postcode", models.CharField(default="", max_length=255)),
                ("outlet_city", models.CharField(default="", max_length=255)),
                (
                    "status",
                    models.CharField(
                        choices=[("ACTIVE", "Active"), ("INACTIVE", "Inactive"), ("WARNING", "Warning")],
                        default="ACTIVE",
                        max_length=8,
                    ),
                ),
                ("status_message", models.TextField(default="")),
                ("opened", models.DateField()),
                ("opened_reference_1", models.CharField(default="", max_length=255)),
                ("opened_reference_2", models.CharField(default="", max_length=255)),
                ("updated_reference_1", models.CharField(default="", max_length=255)),
                ("updated_reference_2", models.CharField(default="", max_length=255)),
                (
                    "investor_type",
                    models.CharField(
                        choices=[
                            ("BANK", "Bank and Financial Institution"),
                            ("NOMINEE", "Nominee"),
                            ("GLOBAL", "Global"),
                        ],
                        default="BANK",
                        max_length=24,
                    ),
                ),
                ("computed_str", models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                "verbose_name": "Register",
                "verbose_name_plural": "Registers",
                "db_table": "portfolio_register",
            },
        ),
        migrations.AddField(
            model_name="historicalcustomertrade",
            name="pending",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="historicalcustomertrade",
            name="register",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.register",
            ),
        ),
        migrations.AddField(
            model_name="historicalcustomertrade",
            name="external_identifier2",
            field=models.CharField(
                blank=True,
                help_text="A second external identifier that was supplied.",
                max_length=255,
                null=True,
                verbose_name="External Identifier 2",
            ),
        ),
        migrations.CreateModel(
            name="Portfolio",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "name",
                    models.CharField(
                        default="", help_text="The Name of the Portfolio", max_length=255, verbose_name="Name"
                    ),
                ),
            ],
            options={
                "verbose_name": "Portfolio",
                "verbose_name_plural": "Portfolios",
                "db_table": "portfolio_portfolio",
            },
        ),
        migrations.CreateModel(
            name="Exchange",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "exchange_name",
                    models.CharField(
                        blank=True,
                        help_text="Name of the Exchange.",
                        max_length=265,
                        null=True,
                        verbose_name="Exchange Name",
                    ),
                ),
                (
                    "exchange_mic",
                    models.CharField(
                        blank=True, help_text="Market Identifier Code.", max_length=4, null=True, verbose_name="MIC"
                    ),
                ),
                (
                    "operating_mic",
                    models.CharField(
                        blank=True,
                        help_text="Operating Market Identifier Code.",
                        max_length=4,
                        null=True,
                        verbose_name="Operating MIC",
                    ),
                ),
                (
                    "bbg_exchange",
                    models.CharField(
                        blank=True,
                        help_text="Bloomberg Exchange Code.",
                        max_length=4,
                        null=True,
                        verbose_name="BBG Exchange Code",
                    ),
                ),
                (
                    "bbg_composite_primary",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates the primary exchange for this BBG Composite Code.",
                        verbose_name="BBG Primary composite",
                    ),
                ),
                (
                    "bbg_composite",
                    models.CharField(
                        blank=True,
                        help_text="Bloomberg Composite Code.",
                        max_length=4,
                        null=True,
                        verbose_name="BBG Composite Code",
                    ),
                ),
                (
                    "exchange_ric",
                    models.CharField(
                        blank=True,
                        help_text="Reuters Exchange Code.",
                        max_length=4,
                        null=True,
                        verbose_name="RIC Exchange Code",
                    ),
                ),
                (
                    "city",
                    models.CharField(
                        blank=True,
                        help_text="The city where this Exchange is located at.",
                        max_length=255,
                        null=True,
                        verbose_name="City",
                    ),
                ),
                (
                    "website",
                    models.URLField(
                        blank=True, help_text="The Website of the Exchange", null=True, verbose_name="Website"
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True, default="", help_text="Any comments for this exchange", verbose_name="Comments"
                    ),
                ),
            ],
            options={
                "verbose_name": "Exchange",
                "verbose_name_plural": "Exchanges",
                "db_table": "portfolio_exchange",
            },
        ),
        migrations.CreateModel(
            name="Asset",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "asset_type",
                    models.CharField(
                        choices=[
                            ("Product", "Product"),
                            ("Index", "Index"),
                            ("ProductGroup", "Product Group"),
                            ("Equity", "Equity"),
                            ("Cash", "Cash"),
                            ("Option", "Option"),
                            ("Right", "Right"),
                            ("Bond", "Bond"),
                            ("Future", "Future"),
                            ("Forward", "Forward"),
                            ("Swap", "Swap"),
                            ("Coupon", "Coupon"),
                            ("Crypto", "Crypto"),
                            ("Commodity", "Commodity"),
                        ],
                        default="Equity",
                        help_text="Type of the Instrument.",
                        max_length=64,
                        verbose_name="Instrument Type",
                    ),
                ),
                (
                    "valuation_date",
                    models.DateField(help_text="The valuation date of the Asset.", verbose_name="Valuation Date"),
                ),
                (
                    "asset_valuation_date",
                    models.DateField(
                        blank=True,
                        help_text="An alternate Valuation Date, if the valuation date of the Asset is different from the overlying Portfolio.",
                        null=True,
                        verbose_name="Alternate Valuation Date",
                    ),
                ),
                (
                    "price_denotation",
                    models.CharField(
                        choices=[("PERCENT", "%"), ("CURRENCY", "Currency")],
                        default="CURRENCY",
                        help_text="The denotation of the price.",
                        max_length=16,
                        verbose_name="Price Denotation",
                    ),
                ),
                (
                    "price",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The Price of the Asset on the valuation date of the Asset.",
                        max_digits=16,
                        null=True,
                        verbose_name="Price",
                    ),
                ),
                (
                    "price_multiplier",
                    models.DecimalField(
                        decimal_places=4,
                        default=1,
                        help_text="The Price Multiplier of an Asset.",
                        max_digits=16,
                        verbose_name="Price Multiplier",
                    ),
                ),
                (
                    "price_fx_portfolio",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The Price of the Asset on the valuation date of the Asset in the Portfolio's currency.",
                        max_digits=16,
                        null=True,
                        verbose_name="Price FX Portfolio",
                    ),
                ),
                (
                    "quantity",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The amount of Units of the Asset on the valuation date of the Asset.",
                        max_digits=14,
                        null=True,
                        verbose_name="Quantity",
                    ),
                ),
                (
                    "total_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The Total Value of the Asset on the valuation date of the Asset.",
                        max_digits=20,
                        null=True,
                        verbose_name="Total Value",
                    ),
                ),
                (
                    "total_value_fx_portfolio",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The Total Value of the Asset on the valuation date of the Asset in the Portfolio's currency.",
                        max_digits=20,
                        null=True,
                        verbose_name="Total Value FX Portfolio",
                    ),
                ),
                (
                    "weight",
                    models.DecimalField(
                        blank=True,
                        decimal_places=6,
                        help_text="The Weight of the Asset on the valuation date of the Asset.",
                        max_digits=7,
                        null=True,
                        verbose_name="Weight",
                    ),
                ),
                (
                    "currency_fx_rate_portfolio",
                    models.DecimalField(
                        decimal_places=14,
                        help_text="The Currency Exchange Rate that is applied to the Asset to convert it into the Portfolio's currency.",
                        max_digits=28,
                        verbose_name="Currency FX Rate",
                    ),
                ),
                (
                    "volume",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The Volume of the Asset on the valuation date of the Asset.",
                        max_digits=14,
                        null=True,
                        verbose_name="Volume",
                    ),
                ),
                (
                    "volume_50d",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The Average Volume of the Asset over the last 50 days from the valuation date of the Asset.",
                        max_digits=14,
                        null=True,
                        verbose_name="Average Volume (50 Days)",
                    ),
                ),
                (
                    "volume_200d",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The Average Volume of the Asset over the last 200 days from the valuation date of the Asset.",
                        max_digits=14,
                        null=True,
                        verbose_name="Average Volume (200 Days)",
                    ),
                ),
                (
                    "market_capitalization",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The Market Capitalization of the Asset the valuation date of the Asset. (Only Equities)",
                        max_digits=20,
                        null=True,
                        verbose_name="Market Capitalization",
                    ),
                ),
                (
                    "exchange",
                    models.ForeignKey(
                        blank=True,
                        help_text="The exchange where this asset is.",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="assets",
                        to="wbportfolio.exchange",
                        verbose_name="Exchange",
                    ),
                ),
                (
                    "portfolio",
                    models.ForeignKey(
                        help_text="The Portfolio the Asset belongs to.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="assets",
                        to="wbportfolio.portfolio",
                        verbose_name="Portfolio",
                    ),
                ),
                (
                    "portfolio_created",
                    models.ForeignKey(
                        blank=True,
                        help_text="The Portfolio that created the Asset.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="assets_created",
                        to="wbportfolio.portfolio",
                        verbose_name="Portfolio Created",
                    ),
                ),
            ],
            options={
                "verbose_name": "Asset",
                "verbose_name_plural": "Assets",
            },
        ),
        migrations.RenameModel(
            old_name="HistoricalStrategyPosition",
            new_name="HistoricalIndexPosition",
        ),
        migrations.RenameModel(
            old_name="Strategy",
            new_name="Index",
        ),
        migrations.AlterModelTable(
            name="index",
            table="portfolio_index",
        ),
        migrations.RenameModel(
            old_name="StrategyPosition",
            new_name="IndexPosition",
        ),
        migrations.RenameModel(
            old_name="HistoricalStrategy",
            new_name="HistoricalIndex",
        ),
        migrations.AlterModelOptions(
            name="historicalindex",
            options={
                "get_latest_by": "history_date",
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Index",
            },
        ),
        migrations.RenameField(
            model_name="indexposition",
            old_name="strategy",
            new_name="index",
        ),
        migrations.RenameField(
            model_name="equityposition",
            old_name="parent_strategy",
            new_name="parent_index",
        ),
        migrations.RenameField(
            model_name="equityposition",
            old_name="strategy",
            new_name="index",
        ),
        migrations.RenameField(
            model_name="historicalportfoliorole",
            old_name="strategy",
            new_name="index",
        ),
        migrations.RenameField(
            model_name="historicalproduct",
            old_name="strategy",
            new_name="index",
        ),
        migrations.RenameField(
            model_name="product",
            old_name="strategy",
            new_name="index",
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="portfolio",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The Portfolio of the Product.",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.portfolio",
                verbose_name="Portfolio",
            ),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="portfolio_computed",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The computed Portfolio of the Product.",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.portfolio",
                verbose_name="Computed Portfolio",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="portfolio",
            field=models.OneToOneField(
                blank=True,
                help_text="The Portfolio of the Product.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="product",
                to="wbportfolio.portfolio",
                verbose_name="Portfolio",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="portfolio_computed",
            field=models.OneToOneField(
                blank=True,
                help_text="The computed Portfolio of the Product.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="product_computed",
                to="wbportfolio.portfolio",
                verbose_name="Computed Portfolio",
            ),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="portfolio",
            field=models.OneToOneField(
                blank=True,
                help_text="The Portfolio of the Product Group.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="product_group",
                to="wbportfolio.portfolio",
                verbose_name="Portfolio",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="investment_strategy",
            field=models.CharField(
                choices=[("LONG", "Long"), ("SHORT", "Short"), ("LONG_SHORT", "Long/Short")],
                default="LONG",
                max_length=16,
                verbose_name="Long/Short Index",
            ),
        ),
        migrations.RenameField(
            model_name="historicalproduct",
            old_name="strategy_theme",
            new_name="index_theme",
        ),
        migrations.RenameField(
            model_name="product",
            old_name="strategy_theme",
            new_name="index_theme",
        ),
        migrations.AlterModelOptions(
            name="historicalindexposition",
            options={
                "get_latest_by": "history_date",
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Index Position",
            },
        ),
        migrations.AlterModelOptions(
            name="index",
            options={"verbose_name": "Index", "verbose_name_plural": "Indexes"},
        ),
        migrations.AlterModelOptions(
            name="indexposition",
            options={"verbose_name": "Index Position", "verbose_name_plural": "Index Positions"},
        ),
        migrations.RenameField(
            model_name="historicalindexposition",
            old_name="parent_strategy",
            new_name="parent_index",
        ),
        migrations.RenameField(
            model_name="historicalindexposition",
            old_name="strategy",
            new_name="index",
        ),
        migrations.RenameField(
            model_name="indexposition",
            old_name="parent_strategy",
            new_name="parent_index",
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="index",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="equity_positions",
                to="wbportfolio.index",
                verbose_name="Index",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="parent_index",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="equity_children",
                to="wbportfolio.index",
                verbose_name="Parent Index",
            ),
        ),
        migrations.AlterField(
            model_name="historicalportfoliorole",
            name="index",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.index",
                verbose_name="Index",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="index",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The index that this product implements.",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.index",
                verbose_name="Underlying Index",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="index_theme",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The base index which serves as an entrypoint to a theme.",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.index",
                verbose_name="Theme Index",
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="investment_strategy",
            field=models.CharField(
                choices=[("LONG", "Long"), ("SHORT", "Short"), ("LONG_SHORT", "Long/Short")],
                default="LONG",
                max_length=16,
                verbose_name="Long/Short Strategy",
            ),
        ),
        migrations.AlterField(
            model_name="indexposition",
            name="index",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="index_positions",
                to="wbportfolio.index",
                verbose_name="Index",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="index",
            field=models.ForeignKey(
                blank=True,
                help_text="The index that this product implements.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products",
                to="wbportfolio.index",
                verbose_name="Underlying Index",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="index_theme",
            field=models.ForeignKey(
                blank=True,
                help_text="The base index which serves as an entrypoint to a theme.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products_theme",
                to="wbportfolio.index",
                verbose_name="Theme Index",
            ),
        ),
        migrations.AlterField(
            model_name="historicalindexposition",
            name="index",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.index",
                verbose_name="Index",
            ),
        ),
        migrations.AlterField(
            model_name="historicalindexposition",
            name="parent_index",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.index",
                verbose_name="Parent Index",
            ),
        ),
        migrations.AlterField(
            model_name="indexposition",
            name="parent_index",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="child_index_positions",
                to="wbportfolio.index",
                verbose_name="Parent Index",
            ),
        ),
        migrations.RenameField(
            model_name="historicalproduct",
            old_name="investment_strategy",
            new_name="investment_index",
        ),
        migrations.RenameField(
            model_name="product",
            old_name="investment_strategy",
            new_name="investment_index",
        ),
        migrations.RenameField(
            model_name="equityposition",
            old_name="avg_volume_50d",
            new_name="volume_50d",
        ),
        migrations.RenameField(
            model_name="equityposition",
            old_name="equity_valuation_date",
            new_name="asset_valuation_date",
        ),
        migrations.AddField(
            model_name="equityposition",
            name="asset_type",
            field=models.CharField(
                choices=[
                    ("Product", "Product"),
                    ("Index", "Index"),
                    ("ProductGroup", "Product Group"),
                    ("Equity", "Equity"),
                    ("Cash", "Cash"),
                    ("Option", "Option"),
                    ("Right", "Right"),
                    ("Bond", "Bond"),
                    ("Future", "Future"),
                    ("Forward", "Forward"),
                    ("Swap", "Swap"),
                    ("Coupon", "Coupon"),
                    ("Crypto", "Crypto"),
                    ("Commodity", "Commodity"),
                ],
                default="Equity",
                help_text="Type of the Instrument.",
                max_length=64,
                verbose_name="Instrument Type",
            ),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="portfolio",
            field=models.ForeignKey(
                blank=True,
                help_text="The Portfolio the Asset belongs to.",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="assets",
                to="wbportfolio.portfolio",
                verbose_name="Portfolio",
            ),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="portfolio_created",
            field=models.ForeignKey(
                blank=True,
                help_text="The Portfolio that created the Asset.",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="assets_created",
                to="wbportfolio.portfolio",
                verbose_name="Portfolio Created",
            ),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="price_denotation",
            field=models.CharField(
                choices=[("PERCENT", "%"), ("CURRENCY", "Currency")],
                default="CURRENCY",
                help_text="The denotation of the price.",
                max_length=16,
                verbose_name="Price Denotation",
            ),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="price_fx_portfolio",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Price of the Asset on the valuation date of the Asset in the Portfolio's currency.",
                max_digits=16,
                null=True,
                verbose_name="Price FX Portfolio",
            ),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="price_multiplier",
            field=models.DecimalField(
                decimal_places=4,
                default=1,
                help_text="The Price Multiplier of an Asset.",
                max_digits=16,
                verbose_name="Price Multiplier",
            ),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="total_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Total Value of the Asset on the valuation date of the Asset.",
                max_digits=20,
                null=True,
                verbose_name="Total Value",
            ),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="total_value_fx_portfolio",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Total Value of the Asset on the valuation date of the Asset in the Portfolio's currency.",
                max_digits=20,
                null=True,
                verbose_name="Total Value FX Portfolio",
            ),
        ),
        migrations.AddField(
            model_name="equityposition",
            name="volume_200d",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Average Volume of the Asset over the last 200 days from the valuation date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Average Volume (200 Days)",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="currency_fx_rate",
            field=models.DecimalField(
                decimal_places=14,
                default=1.0,
                help_text="The Currency Exchange Rate that is applied to the Asset to convert it into the Portfolio's currency.",
                max_digits=28,
                verbose_name="Currency FX Rate",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="equity",
            field=models.ForeignKey(
                blank=True,
                help_text="The equity that is this asset.",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="assets",
                to="wbportfolio.equity",
                verbose_name="Underlying Equity",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="market_capitalization",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Market Capitalization of the Asset the valuation date of the Asset. (Only Equities)",
                max_digits=20,
                null=True,
                verbose_name="Market Capitalization",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="price",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Price of the Asset on the valuation date of the Asset.",
                max_digits=16,
                null=True,
                verbose_name="Price",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="shares",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The amount of Units of the Asset on the valuation date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Quantity",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="volume",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Volume of the Asset on the valuation date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Volume",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="weighting",
            field=models.DecimalField(
                blank=True,
                decimal_places=6,
                help_text="The Weight of the Asset on the valuation date of the Asset.",
                max_digits=7,
                null=True,
                verbose_name="Weight",
            ),
        ),
        migrations.DeleteModel(
            name="Asset",
        ),
        migrations.RemoveField(
            model_name="equityposition",
            name="theoretical_position",
        ),
        migrations.AddField(
            model_name="equity",
            name="exchange_obj",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="equities",
                to="wbportfolio.exchange",
                verbose_name="Exchange",
            ),
        ),
        migrations.AddField(
            model_name="historicalequity",
            name="exchange_obj",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.exchange",
                verbose_name="Exchange",
            ),
        ),
        migrations.AddField(
            model_name="historicalindex",
            name="initial_date",
            field=models.DateField(
                blank=True, help_text="The Initial Date of the Index.", null=True, verbose_name="Initial Date"
            ),
        ),
        migrations.AddField(
            model_name="historicalindex",
            name="portfolio",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The Portfolio of the Index.",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.portfolio",
                verbose_name="Portfolio",
            ),
        ),
        migrations.AddField(
            model_name="historicalindex",
            name="portfolio_computed",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The computed Portfolio of the Index.",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.portfolio",
                verbose_name="Computed Portfolio",
            ),
        ),
        migrations.AddField(
            model_name="index",
            name="initial_date",
            field=models.DateField(
                blank=True, help_text="The Initial Date of the Index.", null=True, verbose_name="Initial Date"
            ),
        ),
        migrations.AddField(
            model_name="index",
            name="portfolio",
            field=models.OneToOneField(
                blank=True,
                help_text="The Portfolio of the Index.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="index",
                to="wbportfolio.portfolio",
                verbose_name="Portfolio",
            ),
        ),
        migrations.AddField(
            model_name="index",
            name="portfolio_computed",
            field=models.OneToOneField(
                blank=True,
                help_text="The computed Portfolio of the Index.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="index_computed",
                to="wbportfolio.portfolio",
                verbose_name="Computed Portfolio",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="asset_valuation_date",
            field=models.DateField(
                blank=True,
                help_text="An alternate Valuation Date, if the valuation date of the Asset is different from the overlying Portfolio.",
                null=True,
                verbose_name="Alternate Valuation Date",
            ),
        ),
        migrations.AlterField(
            model_name="equityposition",
            name="volume_50d",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Average Volume of the Asset over the last 50 days from the valuation date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Average Volume (50 Days)",
            ),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="portfolio_computed",
            field=models.OneToOneField(
                blank=True,
                help_text="The computed Portfolio of the Product Group.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="product_group_computed",
                to="wbportfolio.portfolio",
                verbose_name="Computed Portfolio",
            ),
        ),
        migrations.RemoveField(
            model_name="historicalvaluation",
            name="status",
        ),
        migrations.RemoveField(
            model_name="valuation",
            name="status",
        ),
        migrations.AddField(
            model_name="productgroup",
            name="old_id",
            field=models.IntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="index",
            name="old_id",
            field=models.IntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="product",
            name="old_id",
            field=models.IntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="equity",
            name="old_id",
            field=models.IntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="description",
            field=models.TextField(blank=True, default="", null=True, verbose_name="Description"),
        ),
        migrations.CreateModel(
            name="Instrument",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("base_color", models.CharField(blank=True, default="#FF0000", max_length=64, null=True)),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True)),
                (
                    "instrument_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Product", "Product"),
                            ("Index", "Index"),
                            ("ProductGroup", "Product Group"),
                            ("Equity", "Equity"),
                            ("Cash", "Cash"),
                            ("Option", "Option"),
                            ("Right", "Right"),
                            ("Bond", "Bond"),
                            ("Future", "Future"),
                            ("Forward", "Forward"),
                            ("Swap", "Swap"),
                            ("Coupon", "Coupon"),
                            ("Crypto", "Crypto"),
                            ("Commodity", "Commodity"),
                        ],
                        max_length=255,
                        null=True,
                        verbose_name="Type",
                    ),
                ),
                ("identifier", models.CharField(blank=True, max_length=255, null=True, verbose_name="Identifier")),
                ("title", models.CharField(blank=True, max_length=255, null=True, verbose_name="Title")),
                ("exchange", models.CharField(blank=True, max_length=64, null=True, verbose_name="Exchange")),
                (
                    "exchange_obj",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="equities",
                        to="wbportfolio.exchange",
                        verbose_name="Exchange",
                    ),
                ),
                (
                    "title_repr",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Factsheet Title"),
                ),
                ("description", models.TextField(blank=True, default="", null=True, verbose_name="Description")),
                (
                    "isin",
                    models.CharField(
                        blank=True,
                        help_text="The ISIN provided by the bank.",
                        max_length=12,
                        null=True,
                        verbose_name="ISIN",
                    ),
                ),
                (
                    "ticker",
                    models.CharField(
                        blank=True,
                        help_text="The ticker provided by the bank.",
                        max_length=255,
                        null=True,
                        verbose_name="Ticker Bloomberg",
                    ),
                ),
                (
                    "stainly_reference_instrument",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="portfolios",
                        to="wbportfolio.stainlyasset",
                        verbose_name="The Stainly Instrument Benchmark Reference",
                    ),
                ),
                (
                    "stainly_risk_instrument",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="risk_portfolios",
                        to="wbportfolio.stainlyasset",
                        verbose_name="The Stainly Instrument Risk Free Rate Reference",
                    ),
                ),
                (
                    "stainly_equity",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="equities",
                        to="wbportfolio.stainlyasset",
                        verbose_name="The Stainly Instrument Reference",
                    ),
                ),
            ],
            options={
                "db_table": "portfolio_instrument",
            },
        ),
        migrations.AddField(
            model_name="historicalvaluation",
            name="instrument",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.instrument",
                verbose_name="Instrument",
            ),
        ),
        migrations.RemoveField(
            model_name="equity",
            name="id",
        ),
        migrations.RemoveField(
            model_name="index",
            name="id",
        ),
        migrations.RemoveField(
            model_name="product",
            name="id",
        ),
        migrations.RemoveField(
            model_name="productgroup",
            name="id",
        ),
        migrations.AddField(
            model_name="equity",
            name="instrument_ptr",
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                primary_key=True,
                serialize=False,
                to="wbportfolio.instrument",
            ),
        ),
        migrations.AddField(
            model_name="index",
            name="instrument_ptr",
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                primary_key=True,
                serialize=False,
                to="wbportfolio.instrument",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="instrument_ptr",
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                primary_key=True,
                serialize=False,
                to="wbportfolio.instrument",
            ),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="instrument_ptr",
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                primary_key=True,
                serialize=False,
                to="wbportfolio.instrument",
            ),
        ),
        migrations.RenameField(
            model_name="valuation",
            old_name="product",
            new_name="instrument",
        ),
        migrations.AlterField(
            model_name="valuation",
            name="instrument",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="valuations",
                to="wbportfolio.instrument",
                verbose_name="Instrument",
            ),
        ),
        migrations.RenameModel(
            old_name="EquityPosition",
            new_name="AssetPosition",
        ),
        migrations.AlterModelTable(
            name="assetposition",
            table="portfolio_assetposition",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="index",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="parent_equity",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="product",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="product_group",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="equity",
        ),
        migrations.RemoveField(
            model_name="indexposition",
            name="index",
        ),
        migrations.RemoveField(
            model_name="indexposition",
            name="parent_index",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="parent_index",
        ),
        migrations.DeleteModel(
            name="HistoricalIndexPosition",
        ),
        migrations.DeleteModel(
            name="IndexPosition",
        ),
        migrations.RemoveField(
            model_name="equity",
            name="internal_product",
        ),
        migrations.RemoveField(
            model_name="equity",
            name="internal_product_group",
        ),
        migrations.RemoveField(
            model_name="historicalindex",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicalindex",
            name="portfolio",
        ),
        migrations.RemoveField(
            model_name="historicalindex",
            name="portfolio_computed",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="group",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="index",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="index_theme",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="portfolio",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="portfolio_computed",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="stainly_reference_instrument",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="stainly_risk_instrument",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="factsheet_category",
        ),
        migrations.AlterModelOptions(
            name="assetposition",
            options={"verbose_name": "Asset Position", "verbose_name_plural": "Asset Positions"},
        ),
        migrations.RenameField(
            model_name="product",
            old_name="index",
            new_name="base_index",
        ),
        migrations.DeleteModel(
            name="HistoricalEquity",
        ),
        migrations.DeleteModel(
            name="HistoricalIndex",
        ),
        migrations.DeleteModel(
            name="HistoricalProduct",
        ),
        migrations.RemoveField(
            model_name="product",
            name="logo_file",
        ),
        migrations.RemoveField(
            model_name="product",
            name="url_lookup",
        ),
        migrations.RemoveField(
            model_name="product",
            name="active_factsheet",
        ),
        migrations.RemoveField(
            model_name="product",
            name="base_color",
        ),
        migrations.DeleteModel(
            name="FactsheetAsset",
        ),
        migrations.RemoveField(
            model_name="product",
            name="factsheet_category",
        ),
        migrations.RemoveField(
            model_name="product",
            name="factsheet_html_template",
        ),
        migrations.RemoveField(
            model_name="product",
            name="factsheet_pdf_template",
        ),
        migrations.RemoveField(
            model_name="product",
            name="is_factsheet_private",
        ),
        migrations.DeleteModel(
            name="FactsheetCategory",
        ),
        migrations.RemoveField(
            model_name="equity",
            name="title",
        ),
        migrations.RemoveField(
            model_name="equity",
            name="title_repr",
        ),
        migrations.RemoveField(
            model_name="index",
            name="title",
        ),
        migrations.RemoveField(
            model_name="index",
            name="title_repr",
        ),
        migrations.RemoveField(
            model_name="product",
            name="title",
        ),
        migrations.RemoveField(
            model_name="productgroup",
            name="title",
        ),
        migrations.RemoveField(
            model_name="equity",
            name="exchange",
        ),
        migrations.RemoveField(
            model_name="equity",
            name="exchange_obj",
        ),
        migrations.RemoveField(
            model_name="equity",
            name="isin",
        ),
        migrations.RemoveField(
            model_name="equity",
            name="stainly_equity",
        ),
        migrations.RemoveField(
            model_name="equity",
            name="ticker",
        ),
        migrations.RemoveField(
            model_name="historicalvaluation",
            name="product",
        ),
        migrations.RemoveField(
            model_name="index",
            name="base_color",
        ),
        migrations.RemoveField(
            model_name="index",
            name="isin",
        ),
        migrations.RemoveField(
            model_name="index",
            name="ticker",
        ),
        migrations.RemoveField(
            model_name="product",
            name="computed_str",
        ),
        migrations.RemoveField(
            model_name="product",
            name="description",
        ),
        migrations.RemoveField(
            model_name="index",
            name="description",
        ),
        migrations.RemoveField(
            model_name="product",
            name="isin",
        ),
        migrations.RemoveField(
            model_name="product",
            name="stainly_reference_instrument",
        ),
        migrations.RemoveField(
            model_name="product",
            name="stainly_risk_instrument",
        ),
        migrations.RemoveField(
            model_name="product",
            name="ticker",
        ),
        migrations.RemoveField(
            model_name="productgroup",
            name="description",
        ),
        migrations.RemoveField(
            model_name="productgroup",
            name="identifier",
        ),
        migrations.CreateModel(
            name="Cash",
            fields=[
                (
                    "instrument_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.instrument",
                    ),
                ),
            ],
            options={
                "db_table": "portfolio_cash",
            },
            bases=("wbportfolio.instrument",),
        ),
        migrations.RemoveField(
            model_name="equity",
            name="is_cash",
        ),
        migrations.RemoveField(
            model_name="index",
            name="is_cash",
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="asset_type",
            field=models.CharField(
                choices=[
                    ("Product", "Product"),
                    ("Index", "Index"),
                    ("ProductGroup", "Product Group"),
                    ("Equity", "Equity"),
                    ("Cash", "Cash"),
                    ("Option", "Option"),
                    ("Right", "Right"),
                    ("Bond", "Bond"),
                    ("InterestRateDerivative", "Interest Rate Derivate"),
                    ("Future", "Future"),
                    ("Forward", "Forward"),
                    ("Swap", "Swap"),
                    ("Coupon", "Coupon"),
                    ("Crypto", "Crypto"),
                    ("Commodity", "Commodity"),
                ],
                default="Equity",
                help_text="Type of the Instrument.",
                max_length=64,
                verbose_name="Instrument Type",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="instrument_type",
            field=models.CharField(
                blank=True,
                choices=[
                    ("Product", "Product"),
                    ("Index", "Index"),
                    ("ProductGroup", "Product Group"),
                    ("Equity", "Equity"),
                    ("Cash", "Cash"),
                    ("Option", "Option"),
                    ("Right", "Right"),
                    ("Bond", "Bond"),
                    ("InterestRateDerivative", "Interest Rate Derivate"),
                    ("Future", "Future"),
                    ("Forward", "Forward"),
                    ("Swap", "Swap"),
                    ("Coupon", "Coupon"),
                    ("Crypto", "Crypto"),
                    ("Commodity", "Commodity"),
                ],
                max_length=255,
                null=True,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="stainly_equity",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="instruments",
                to="wbportfolio.stainlyasset",
                verbose_name="The Stainly Instrument Reference",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="asset_type",
            field=models.CharField(
                choices=[
                    ("Product", "Product"),
                    ("Index", "Index"),
                    ("ProductGroup", "Product Group"),
                    ("Equity", "Equity"),
                    ("Cash", "Cash"),
                    ("Option", "Option"),
                    ("Right", "Right"),
                    ("Bond", "Bond"),
                    ("InterestRateDerivative", "Interest Rate Derivate"),
                    ("Future", "Future"),
                    ("Forward", "Forward"),
                    ("Swap", "Swap"),
                    ("Coupon", "Coupon"),
                    ("Crypto", "Crypto"),
                    ("Commodity", "Commodity"),
                ],
                default="Equity",
                help_text="Type of the Instrument.",
                max_length=64,
                verbose_name="Instrument Type",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="market_shares",
            field=models.FloatField(
                blank=True,
                help_text="The total market shares (total_value / market_capitalization",
                null=True,
                verbose_name="Market Shares",
            ),
        ),
        migrations.AlterField(
            model_name="equity",
            name="gics_classification",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to=models.Q(("classification_type", 0)),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="gics_equities",
                to="wbportfolio.industryclassification",
                verbose_name="GICS Classification",
            ),
        ),
        migrations.AlterField(
            model_name="industryclassification",
            name="classification_type",
            field=models.CharField(
                choices=[
                    (3, "GICS Sector"),
                    (2, "GICS Industry Group"),
                    (1, "GICS Industry"),
                    (0, "GICS Sub Industry"),
                ],
                max_length=64,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="base_color",
            field=colorfield.fields.ColorField(blank=True, default="#FF0000", max_length=64, null=True),
        ),
        migrations.CreateModel(
            name="Bond",
            fields=[
                (
                    "instrument_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.instrument",
                    ),
                ),
            ],
            options={
                "db_table": "portfolio_bond",
            },
            bases=("wbportfolio.instrument",),
        ),
        migrations.CreateModel(
            name="InterestRateDerivative",
            fields=[
                (
                    "instrument_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.instrument",
                    ),
                ),
            ],
            options={
                "db_table": "portfolio_interestratederivative",
            },
            bases=("wbportfolio.instrument",),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="instrument_type",
            field=models.CharField(
                blank=True,
                choices=[
                    ("Product", "Product"),
                    ("Index", "Index"),
                    ("ProductGroup", "Product Group"),
                    ("Equity", "Equity"),
                    ("Cash", "Cash"),
                    ("Option", "Option"),
                    ("Right", "Right"),
                    ("Bond", "Bond"),
                    ("InterestRateDerivative", "Interest Rate Derivate"),
                    ("Future", "Future"),
                    ("Forward", "Forward"),
                    ("Swap", "Swap"),
                    ("Coupon", "Coupon"),
                    ("Crypto", "Crypto"),
                    ("Commodity", "Commodity"),
                ],
                max_length=255,
                null=True,
                verbose_name="Type",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="external_id",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="External Identifier"),
        ),
        migrations.CreateModel(
            name="BenchmarkThroughModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("is_primary", models.BooleanField(default=False)),
                (
                    "from_instrument",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="to_benchmarks",
                        to="wbportfolio.instrument",
                    ),
                ),
                (
                    "to_instrument",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="from_benchmarks",
                        to="wbportfolio.instrument",
                    ),
                ),
            ],
            options={
                "db_table": "portfolio_benchmarkthroughmodel",
            },
        ),
        migrations.AddField(
            model_name="instrument",
            name="benchmarks",
            field=models.ManyToManyField(
                blank=True,
                related_name="benchmarks_of",
                through="wbportfolio.BenchmarkThroughModel",
                to="wbportfolio.instrument",
                verbose_name="The Instrument Benchmark Reference",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="risk_instrument",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="risks_of",
                to="wbportfolio.instrument",
                verbose_name="The Instrument Risk Free Rate Reference",
            ),
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="stainly_equity",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="stainly_reference_instrument",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="stainly_risk_instrument",
        ),
        migrations.DeleteModel(
            name="StainlyAsset",
        ),
        migrations.RemoveField(
            model_name="product",
            name="stainly_benchmark_instruments",
        ),
        migrations.CreateModel(
            name="Custodian",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "name",
                    models.CharField(
                        help_text="The Name of the Custodian.", max_length=255, unique=True, verbose_name="Name"
                    ),
                ),
                (
                    "mapping",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=255),
                        default=list,
                        help_text="Each custodian of this mapping will be assigned to this custodian.",
                        size=None,
                        verbose_name="Custodian Mapping",
                    ),
                ),
            ],
            options={
                "verbose_name": "Custodian",
                "verbose_name_plural": "Custodians",
                "db_table": "portfolio_custodian",
            },
        ),
        migrations.CreateModel(
            name="ExchangeInstrumentThroughModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("is_primary", models.BooleanField(default=False)),
                (
                    "exchange",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="exchange_instrument",
                        to="wbportfolio.exchange",
                    ),
                ),
                (
                    "instrument",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="instrument_exchange",
                        to="wbportfolio.instrument",
                    ),
                ),
            ],
            options={
                "db_table": "portfolio_exchangeinstrumentthroughmodel",
            },
        ),
        migrations.AddField(
            model_name="instrument",
            name="exchanges",
            field=models.ManyToManyField(
                blank=True,
                help_text="Tradeable exchanges",
                related_name="instruments",
                through="wbportfolio.ExchangeInstrumentThroughModel",
                to="wbportfolio.exchange",
                verbose_name="Exchanges",
            ),
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="exchange_obj",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="asset_type",
        ),
        migrations.RenameModel(
            old_name="HistoricalCustomerTrade",
            new_name="HistoricalCustomerTradeOld",
        ),
        migrations.RenameModel(
            old_name="HistoricalDividend",
            new_name="HistoricalDividendOld",
        ),
        migrations.RenameModel(
            old_name="HistoricalFees",
            new_name="HistoricalFeesOld",
        ),
        migrations.RenameModel(
            old_name="HistoricalTrade",
            new_name="HistoricalTradeOld",
        ),
        migrations.CreateModel(
            name="Transaction",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "transaction_type",
                    models.CharField(
                        choices=[
                            ("CustomerTrade", "Customer Trade"),
                            ("Trade", "Trade"),
                            ("Dividend", "Dividend"),
                            ("Expiry", "Expiry"),
                            ("Fees", "Fees"),
                        ],
                        max_length=255,
                        verbose_name="Type",
                    ),
                ),
                (
                    "transaction_date",
                    models.DateField(
                        help_text="The date that this transaction was traded.", verbose_name="Trade Date"
                    ),
                ),
                (
                    "book_date",
                    models.DateField(
                        blank=True,
                        help_text="The date that this transaction was booked.",
                        null=True,
                        verbose_name="Trade Date",
                    ),
                ),
                (
                    "value_date",
                    models.DateField(
                        blank=True,
                        help_text="The date that this transaction was valuated.",
                        null=True,
                        verbose_name="Value Date",
                    ),
                ),
                (
                    "currency_fx_rate",
                    models.DecimalField(
                        decimal_places=8, default=Decimal("1"), max_digits=14, verbose_name="FOREX rate"
                    ),
                ),
                (
                    "total_value",
                    models.DecimalField(
                        blank=True, decimal_places=4, default=0, max_digits=20, verbose_name="Total Value"
                    ),
                ),
                (
                    "total_value_fx_portfolio",
                    models.DecimalField(
                        blank=True, decimal_places=4, default=0, max_digits=20, verbose_name="Total Value Fx Portfolio"
                    ),
                ),
                (
                    "total_value_gross",
                    models.DecimalField(
                        blank=True, decimal_places=4, default=0, max_digits=20, verbose_name="Total Value Gross"
                    ),
                ),
                (
                    "total_value_gross_fx_portfolio",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        default=0,
                        max_digits=20,
                        verbose_name="Total Value Gross Fx Portfolio",
                    ),
                ),
                (
                    "external_id",
                    models.CharField(
                        blank=True,
                        help_text="An external identifier that was supplied.",
                        max_length=255,
                        null=True,
                        verbose_name="External Identifier",
                    ),
                ),
                ("comment", models.TextField(default="", verbose_name="Comment")),
                (
                    "portfolio",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="transactions",
                        to="wbportfolio.portfolio",
                        verbose_name="Portfolio",
                    ),
                ),
            ],
            options={
                "verbose_name": "Transaction",
                "verbose_name_plural": "Transactions",
                "db_table": "portfolio_transaction",
                "ordering": ["-transaction_date"],
            },
        ),
        migrations.CreateModel(
            name="Dividend",
            fields=[
                (
                    "transaction_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.transaction",
                    ),
                ),
                (
                    "shares",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="The number of shares that were traded.",
                        max_digits=15,
                        verbose_name="Shares",
                    ),
                ),
                (
                    "price",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The price per share.",
                        max_digits=16,
                        null=True,
                        verbose_name="Price",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "db_table": "portfolio_dividend",
            },
            bases=("wbportfolio.transaction", models.Model),
        ),
        migrations.CreateModel(
            name="Expiry",
            fields=[
                (
                    "transaction_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.transaction",
                    ),
                ),
                (
                    "shares",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="The number of shares that were traded.",
                        max_digits=15,
                        verbose_name="Shares",
                    ),
                ),
                (
                    "price",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The price per share.",
                        max_digits=16,
                        null=True,
                        verbose_name="Price",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "db_table": "portfolio_expiry",
            },
            bases=("wbportfolio.transaction", models.Model),
        ),
        migrations.CreateModel(
            name="Trade",
            fields=[
                (
                    "transaction_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.transaction",
                    ),
                ),
                (
                    "shares",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="The number of shares that were traded.",
                        max_digits=15,
                        verbose_name="Shares",
                    ),
                ),
                (
                    "price",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The price per share.",
                        max_digits=16,
                        null=True,
                        verbose_name="Price",
                    ),
                ),
                (
                    "trade_type",
                    models.CharField(
                        choices=[("rebalance", "Rebalance"), ("decrease", "Decrease"), ("increase", "Increase")],
                        default="rebalance",
                        max_length=15,
                        verbose_name="Type",
                    ),
                ),
                (
                    "execution_fees",
                    models.DecimalField(decimal_places=4, default=0.0, max_digits=16, verbose_name="Execution Fees"),
                ),
                (
                    "market_fees",
                    models.DecimalField(decimal_places=4, default=0.0, max_digits=16, verbose_name="Market Fees"),
                ),
            ],
            options={
                "verbose_name": "Trade",
                "verbose_name_plural": "Trades",
                "db_table": "portfolio_trade",
            },
            bases=("wbportfolio.transaction", models.Model),
        ),
        migrations.CreateModel(
            name="Fees",
            fields=[
                (
                    "transaction_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.transaction",
                    ),
                ),
                (
                    "fee_type",
                    models.CharField(
                        choices=[
                            ("TRANSACTION", "Transaction"),
                            ("PERFORMANCE_CRYSTALIZED", "Performance Crystalized"),
                            ("PERFORMANCE", "Performance"),
                            ("MANAGEMENT", "Management"),
                            ("ISSUER", "Issuer"),
                            ("OTHER", "Other"),
                        ],
                        default="MANAGEMENT",
                        max_length=255,
                        verbose_name="Fees Type",
                    ),
                ),
                (
                    "calculated",
                    models.BooleanField(
                        default=True,
                        help_text="A marker whether the fees were calculated or supplied.",
                        verbose_name="Is calculated",
                    ),
                ),
                (
                    "linked_product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="transactionfees",
                        to="wbportfolio.product",
                        verbose_name="Product",
                    ),
                ),
            ],
            options={
                "verbose_name": "Fees",
                "verbose_name_plural": "Fees",
                "db_table": "portfolio_fees",
            },
            bases=("wbportfolio.transaction", models.Model),
        ),
        migrations.CreateModel(
            name="CustomerTrade",
            fields=[
                (
                    "transaction_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.transaction",
                    ),
                ),
                (
                    "shares",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="The number of shares that were traded.",
                        max_digits=15,
                        verbose_name="Shares",
                    ),
                ),
                (
                    "price",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The price per share.",
                        max_digits=16,
                        null=True,
                        verbose_name="Price",
                    ),
                ),
                (
                    "bank",
                    models.CharField(
                        help_text="The bank/counterparty/custodian the trade went through.",
                        max_length=255,
                        verbose_name="Counterparty",
                    ),
                ),
                (
                    "marked_for_deletion",
                    models.BooleanField(
                        default=False,
                        help_text="If this is checked, then the trade is supposed to be deleted.",
                        verbose_name="To be deleted",
                    ),
                ),
            ],
            options={
                "verbose_name": "Customer Trade",
                "verbose_name_plural": "Customer Trades",
                "db_table": "portfolio_customertrade",
            },
            bases=("wbportfolio.transaction", models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalTransaction",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                (
                    "transaction_type",
                    models.CharField(
                        choices=[
                            ("CustomerTrade", "Customer Trade"),
                            ("Trade", "Trade"),
                            ("Dividend", "Dividend"),
                            ("Expiry", "Expiry"),
                            ("Fees", "Fees"),
                        ],
                        max_length=255,
                        verbose_name="Type",
                    ),
                ),
                (
                    "transaction_date",
                    models.DateField(
                        help_text="The date that this transaction was traded.", verbose_name="Trade Date"
                    ),
                ),
                (
                    "book_date",
                    models.DateField(
                        blank=True,
                        help_text="The date that this transaction was booked.",
                        null=True,
                        verbose_name="Trade Date",
                    ),
                ),
                (
                    "value_date",
                    models.DateField(
                        blank=True,
                        help_text="The date that this transaction was valuated.",
                        null=True,
                        verbose_name="Value Date",
                    ),
                ),
                (
                    "currency_fx_rate",
                    models.DecimalField(
                        decimal_places=8, default=Decimal("1"), max_digits=14, verbose_name="FOREX rate"
                    ),
                ),
                (
                    "total_value",
                    models.DecimalField(
                        blank=True, decimal_places=4, default=0, max_digits=20, verbose_name="Total Value"
                    ),
                ),
                (
                    "total_value_fx_portfolio",
                    models.DecimalField(
                        blank=True, decimal_places=4, default=0, max_digits=20, verbose_name="Total Value Fx Portfolio"
                    ),
                ),
                (
                    "total_value_gross",
                    models.DecimalField(
                        blank=True, decimal_places=4, default=0, max_digits=20, verbose_name="Total Value Gross"
                    ),
                ),
                (
                    "total_value_gross_fx_portfolio",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        default=0,
                        max_digits=20,
                        verbose_name="Total Value Gross Fx Portfolio",
                    ),
                ),
                (
                    "external_id",
                    models.CharField(
                        blank=True,
                        help_text="An external identifier that was supplied.",
                        max_length=255,
                        null=True,
                        verbose_name="External Identifier",
                    ),
                ),
                ("comment", models.TextField(default="", verbose_name="Comment")),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "portfolio",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.portfolio",
                        verbose_name="Portfolio",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Transaction",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
                "db_table": "portfolio_historicaltransaction",
            },
        ),
        migrations.AddField(
            model_name="industryclassification",
            name="classification_level",
            field=models.IntegerField(
                choices=[
                    (3, "GICS Sector"),
                    (2, "GICS Industry Group"),
                    (1, "GICS Industry"),
                    (0, "GICS Sub Industry"),
                ],
                default=0,
                verbose_name="Level",
            ),
        ),
        migrations.RenameField(
            model_name="exchange",
            old_name="exchange_mic",
            new_name="mic_code",
        ),
        migrations.RenameField(
            model_name="exchange",
            old_name="exchange_name",
            new_name="name",
        ),
        migrations.RenameField(
            model_name="exchange",
            old_name="exchange_ric",
            new_name="refinitiv_identifier_code",
        ),
        migrations.RemoveField(
            model_name="exchange",
            name="operating_mic",
        ),
        migrations.AddField(
            model_name="exchange",
            name="operating_mic_code",
            field=models.CharField(
                blank=True,
                help_text="Operating Market Identifier Code.",
                max_length=4,
                null=True,
                verbose_name="Operating MIC Code",
            ),
        ),
        migrations.AddField(
            model_name="exchange",
            name="operating_mic_name",
            field=models.CharField(
                blank=True,
                help_text="Operating Market Identifier Name.",
                max_length=126,
                null=True,
                verbose_name="Operating MIC Name",
            ),
        ),
        migrations.AddField(
            model_name="exchange",
            name="refinitiv_mnemonic",
            field=models.CharField(
                blank=True,
                help_text="Reuters Exchange Mnemonic Code.",
                max_length=4,
                null=True,
                verbose_name="Refinitiv Mnemonic",
            ),
        ),
        migrations.AlterField(
            model_name="exchange",
            name="mic_code",
            field=models.CharField(
                blank=True, help_text="Market Identifier Code.", max_length=4, null=True, verbose_name="MIC (ISO)"
            ),
        ),
        migrations.AddField(
            model_name="exchange",
            name="mic_name",
            field=models.CharField(
                blank=True,
                help_text="Market Identifier Name.",
                max_length=126,
                null=True,
                verbose_name="MIC (ISO) Name",
            ),
        ),
        migrations.RemoveField(
            model_name="historicalcustomertradeold",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicalcustomertradeold",
            name="product",
        ),
        migrations.RemoveField(
            model_name="historicaldividendold",
            name="equity",
        ),
        migrations.RemoveField(
            model_name="historicaldividendold",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicaldividendold",
            name="product",
        ),
        migrations.RemoveField(
            model_name="historicalfeesold",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicalfeesold",
            name="product",
        ),
        migrations.RemoveField(
            model_name="historicaltradeold",
            name="equity",
        ),
        migrations.RemoveField(
            model_name="historicaltradeold",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicaltradeold",
            name="product",
        ),
        migrations.AlterField(
            model_name="equity",
            name="gics_classification",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to=models.Q(("classification_level", 0)),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="gics_equities",
                to="wbportfolio.industryclassification",
                verbose_name="GICS Classification",
            ),
        ),
        migrations.DeleteModel(
            name="HistoricalCustomerTradeOld",
        ),
        migrations.DeleteModel(
            name="HistoricalDividendOld",
        ),
        migrations.DeleteModel(
            name="HistoricalFeesOld",
        ),
        migrations.DeleteModel(
            name="HistoricalTradeOld",
        ),
        migrations.AlterModelOptions(
            name="assetposition",
            options={
                "ordering": ["-date"],
                "verbose_name": "Asset Position",
                "verbose_name_plural": "Asset Positions",
            },
        ),
        migrations.AlterModelOptions(
            name="valuation",
            options={"ordering": ["-date"], "verbose_name": "Valuation", "verbose_name_plural": "Valuations"},
        ),
        migrations.CreateModel(
            name="FeeCalculation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=128, verbose_name="Name")),
                (
                    "import_path",
                    models.CharField(default="restbench.fees.default", max_length=512, verbose_name="Import Path"),
                ),
            ],
            options={
                "db_table": "portfolio_feecalculation",
            },
        ),
        migrations.AddField(
            model_name="product",
            name="fee_calculation",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products",
                to="wbportfolio.feecalculation",
                verbose_name="Fee Calculation Method",
            ),
        ),
        migrations.CreateModel(
            name="PortfolioSynchronization",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=128, verbose_name="Name")),
                (
                    "import_path",
                    models.CharField(
                        default="restbench.portfolio.default", max_length=512, verbose_name="Import Path"
                    ),
                ),
            ],
            options={
                "db_table": "portfolio_portfoliosynchronization",
            },
        ),
        migrations.AddField(
            model_name="assetposition",
            name="is_estimated",
            field=models.BooleanField(default=False, verbose_name="Estimated Asset"),
        ),
        migrations.AddField(
            model_name="portfolio",
            name="depends_on",
            field=models.ManyToManyField(
                blank=True,
                help_text="The Portfolios that need to sychronize before this portfolio",
                related_name="parent_portfolios",
                to="wbportfolio.portfolio",
                verbose_name="Dependent Portfolios",
            ),
        ),
        migrations.AddField(
            model_name="portfolio",
            name="portfolio_synchronization",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="portfolios",
                to="wbportfolio.portfoliosynchronization",
                verbose_name="Portfolio Synchronization Method",
            ),
        ),
        migrations.AddField(
            model_name="portfolio",
            name="base_index_portfolio",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="index_based_portfolios",
                to="wbportfolio.portfolio",
                verbose_name="Index Portfolio on which this portfolio is based",
            ),
        ),
        migrations.RemoveField(
            model_name="product",
            name="base_index",
        ),
        migrations.RemoveField(
            model_name="product",
            name="index_theme",
        ),
        migrations.AddField(
            model_name="portfolio",
            name="theme_index_portfolio",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="theme_based_portfolios",
                to="wbportfolio.portfolio",
                verbose_name="Theme Portfolio on which this portfolio is based",
            ),
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="exchange",
        ),
        migrations.RenameModel(
            old_name="Valuation",
            new_name="InstrumentPrice",
        ),
        migrations.AlterModelTable(
            name="instrumentprice",
            table="portfolio_instrumentprice",
        ),
        migrations.RenameModel(
            old_name="HistoricalValuation",
            new_name="HistoricalInstrumentPrice",
        ),
        migrations.AlterModelTable(
            name="historicalinstrumentprice",
            table="portfolio_historicalinstrumentprice",
        ),
        migrations.AlterModelOptions(
            name="historicalinstrumentprice",
            options={
                "get_latest_by": "history_date",
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical InstrumentPrice",
            },
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="asset_valuation_date",
            field=models.DateField(
                blank=True,
                help_text="An alternate Valuation Date, if the price date of the Asset is different from the overlying Portfolio.",
                null=True,
                verbose_name="Alternate Valuation Date",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="market_capitalization",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Market Capitalization of the Asset the price date of the Asset. (Only Equities)",
                max_digits=20,
                null=True,
                verbose_name="Market Capitalization",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="price",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Price of the Asset on the price date of the Asset.",
                max_digits=16,
                null=True,
                verbose_name="Price",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="price_fx_portfolio",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Price of the Asset on the price date of the Asset in the Portfolio's currency.",
                max_digits=16,
                null=True,
                verbose_name="Price FX Portfolio",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="shares",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The amount of Units of the Asset on the price date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Quantity",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="total_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Total Value of the Asset on the price date of the Asset.",
                max_digits=20,
                null=True,
                verbose_name="Total Value",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="total_value_fx_portfolio",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Total Value of the Asset on the price date of the Asset in the Portfolio's currency.",
                max_digits=20,
                null=True,
                verbose_name="Total Value FX Portfolio",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="volume",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Volume of the Asset on the price date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Volume",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="volume_200d",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Average Volume of the Asset over the last 200 days from the price date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Average Volume (200 Days)",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="volume_50d",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Average Volume of the Asset over the last 50 days from the price date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Average Volume (50 Days)",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="weighting",
            field=models.DecimalField(
                blank=True,
                decimal_places=6,
                help_text="The Weight of the Asset on the price date of the Asset.",
                max_digits=7,
                null=True,
                verbose_name="Weight",
            ),
        ),
        migrations.AlterModelOptions(
            name="instrumentprice",
            options={
                "ordering": ["-date"],
                "verbose_name": "InstrumentPrice",
                "verbose_name_plural": "Instrument Prices",
            },
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="instrument",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="prices",
                to="wbportfolio.instrument",
                verbose_name="Instrument",
            ),
        ),
        migrations.AlterField(
            model_name="historicaltransaction",
            name="transaction_type",
            field=models.CharField(
                choices=[
                    ("CustomerTrade", "Customer Trade"),
                    ("Dividend", "Dividend"),
                    ("Expiry", "Expiry"),
                    ("Fees", "Fees"),
                ],
                max_length=255,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="transaction_type",
            field=models.CharField(
                choices=[
                    ("CustomerTrade", "Customer Trade"),
                    ("Dividend", "Dividend"),
                    ("Expiry", "Expiry"),
                    ("Fees", "Fees"),
                ],
                max_length=255,
                verbose_name="Type",
            ),
        ),
        migrations.DeleteModel(
            name="Trade",
        ),
        migrations.RenameModel(
            old_name="CustomerTrade",
            new_name="Trade",
        ),
        migrations.AlterField(
            model_name="historicaltransaction",
            name="transaction_type",
            field=models.CharField(
                choices=[("Trade", "Customer"), ("Dividend", "Dividend"), ("Expiry", "Expiry"), ("Fees", "Fees")],
                max_length=255,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="transaction_type",
            field=models.CharField(
                choices=[("Trade", "Customer"), ("Dividend", "Dividend"), ("Expiry", "Expiry"), ("Fees", "Fees")],
                max_length=255,
                verbose_name="Type",
            ),
        ),
        migrations.AlterModelOptions(
            name="assetposition",
            options={"verbose_name": "Asset Position", "verbose_name_plural": "Asset Positions"},
        ),
        migrations.AlterModelOptions(
            name="instrumentprice",
            options={"verbose_name": "InstrumentPrice", "verbose_name_plural": "Instrument Prices"},
        ),
        migrations.AlterModelOptions(
            name="product",
            options={"verbose_name": "Product", "verbose_name_plural": "Products"},
        ),
        migrations.AlterModelOptions(
            name="transaction",
            options={"verbose_name": "Transaction", "verbose_name_plural": "Transactions"},
        ),
        migrations.AlterField(
            model_name="historicaltransaction",
            name="transaction_type",
            field=models.CharField(
                choices=[("Trade", "Trade"), ("Dividend", "Dividend"), ("Expiry", "Expiry"), ("Fees", "Fees")],
                default="Trade",
                max_length=255,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="transaction_type",
            field=models.CharField(
                choices=[("Trade", "Trade"), ("Dividend", "Dividend"), ("Expiry", "Expiry"), ("Fees", "Fees")],
                default="Trade",
                max_length=255,
                verbose_name="Type",
            ),
        ),
        migrations.RenameField(
            model_name="benchmarkthroughmodel",
            old_name="to_instrument",
            new_name="benchmark",
        ),
        migrations.RenameField(
            model_name="benchmarkthroughmodel",
            old_name="from_instrument",
            new_name="instrument",
        ),
        migrations.RenameField(
            model_name="fees",
            old_name="fee_type",
            new_name="transaction_subtype",
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="is_estimated",
            field=models.BooleanField(
                default=False,
                help_text="True if the data is forward-estimated based on last day data. If the data is overridden by the importer or by the synchronization, this field becomes False.",
                verbose_name="Estimated Asset",
            ),
        ),
        migrations.AddField(
            model_name="dividend",
            name="price_gross",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The gross price per share.",
                max_digits=16,
                null=True,
                verbose_name="Gross Price",
            ),
        ),
        migrations.AddField(
            model_name="expiry",
            name="price_gross",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The gross price per share.",
                max_digits=16,
                null=True,
                verbose_name="Gross Price",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="isin",
            field=models.CharField(
                blank=True,
                help_text="The ISIN provided by the bank.",
                max_length=12,
                null=True,
                unique=True,
                verbose_name="ISIN",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="portfolio",
            field=models.ForeignKey(
                default=None,
                help_text="The Portfolio the Asset belongs to.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="assets",
                to="wbportfolio.portfolio",
                verbose_name="Portfolio",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="transaction",
            name="portfolio",
            field=models.ForeignKey(
                default=None,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="transactions",
                to="wbportfolio.portfolio",
                verbose_name="Portfolio",
            ),
            preserve_default=False,
        ),
        migrations.RenameField(
            model_name="assetposition",
            old_name="market_shares",
            new_name="market_share",
        ),
        migrations.AddField(
            model_name="index",
            name="is_cash",
            field=models.BooleanField(default=False, help_text="True if this index should be considered cash"),
        ),
        migrations.AddField(
            model_name="instrument",
            name="inception_date",
            field=models.DateField(
                blank=True, help_text="The instrument creation", null=True, verbose_name="Inception Date"
            ),
        ),
        migrations.CreateModel(
            name="PriceComputation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=128, verbose_name="Name")),
                (
                    "import_path",
                    models.CharField(default="restbench.price.default", max_length=512, verbose_name="Import Path"),
                ),
            ],
            options={
                "db_table": "portfolio_pricecomputation",
            },
        ),
        migrations.AddField(
            model_name="instrument",
            name="price_computation",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="instruments",
                to="wbportfolio.pricecomputation",
                verbose_name="Price Computation Method",
            ),
        ),
        migrations.AlterField(
            model_name="historicalinstrumentprice",
            name="net_value",
            field=models.DecimalField(
                blank=True, decimal_places=6, max_digits=16, null=True, verbose_name="Value (Net)"
            ),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="net_value",
            field=models.DecimalField(
                blank=True, decimal_places=6, max_digits=16, null=True, verbose_name="Value (Net)"
            ),
        ),
        migrations.RemoveField(
            model_name="historicalinstrumentprice",
            name="is_fake",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="is_fake",
        ),
        migrations.RemoveField(
            model_name="index",
            name="is_cash",
        ),
        migrations.AddField(
            model_name="instrument",
            name="is_cash",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="portfolio",
            name="portfolio_type",
            field=models.CharField(
                choices=[("BASE", "Base"), ("INDEX", "Index"), ("MODEL", "Model"), ("COMPUTED", "Computed")],
                default="BASE",
                max_length=255,
                verbose_name="Type",
            ),
        ),
        migrations.CreateModel(
            name="InstrumentPortfolioThroughModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "primary_portfolio",
                    models.BooleanField(
                        default=False,
                        help_text="Set the Primary Portfolio. Only one portfolio among an instrument's portfolios can be set as primary",
                    ),
                ),
                (
                    "asset_portfolio",
                    models.BooleanField(
                        default=False,
                        help_text="Set the Asset Portfolio, the one containing the assets. Only one portfolio among an instrument's portfolios can be set as the asset portfolio",
                    ),
                ),
                (
                    "base_instrument",
                    models.BooleanField(
                        default=False,
                        help_text="Set the Base Instrument. Only one instrument among the instruments implementing that portfolio can be set as core",
                    ),
                ),
                (
                    "portfolio",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="through_instruments",
                        to="wbportfolio.portfolio",
                    ),
                ),
            ],
            options={
                "db_table": "portfolio_instrumentportfoliothroughmodel",
            },
        ),
        migrations.AddField(
            model_name="instrument",
            name="portfolios",
            field=models.ManyToManyField(
                blank=True,
                help_text="Portfolio linked to this instrument",
                related_name="instruments",
                through="wbportfolio.InstrumentPortfolioThroughModel",
                to="wbportfolio.portfolio",
                verbose_name="Portfolios",
            ),
        ),
        migrations.RemoveField(
            model_name="index",
            name="portfolio",
        ),
        migrations.RemoveField(
            model_name="index",
            name="portfolio_computed",
        ),
        migrations.RemoveField(
            model_name="product",
            name="portfolio",
        ),
        migrations.RemoveField(
            model_name="product",
            name="portfolio_computed",
        ),
        migrations.RemoveField(
            model_name="productgroup",
            name="portfolio",
        ),
        migrations.RemoveField(
            model_name="productgroup",
            name="portfolio_computed",
        ),
        migrations.AddField(
            model_name="historicalportfoliorole",
            name="instrument",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.instrument",
                verbose_name="Instrument",
            ),
        ),
        migrations.RemoveField(
            model_name="historicalportfoliorole",
            name="index",
        ),
        migrations.RemoveField(
            model_name="historicalportfoliorole",
            name="product",
        ),
        migrations.AddField(
            model_name="instrument",
            name="issue_price",
            field=models.PositiveIntegerField(
                default=100,
                help_text="The initial issue price that is displayed on the facthsheet",
                verbose_name="Issue Price",
            ),
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="market_capitalization",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="volume",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="volume_200d",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="volume_50d",
        ),
        migrations.AddField(
            model_name="historicalinstrumentprice",
            name="market_capitalization",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Market Capitalization of the Asset the price date of the Asset. (Only Equities)",
                max_digits=20,
                null=True,
                verbose_name="Market Capitalization",
            ),
        ),
        migrations.AddField(
            model_name="historicalinstrumentprice",
            name="volume",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Volume of the Asset on the price date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Volume",
            ),
        ),
        migrations.AddField(
            model_name="historicalinstrumentprice",
            name="volume_200d",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Average Volume of the Asset over the last 200 days from the price date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Average Volume (200 Days)",
            ),
        ),
        migrations.AddField(
            model_name="historicalinstrumentprice",
            name="volume_50d",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Average Volume of the Asset over the last 50 days from the price date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Average Volume (50 Days)",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="market_capitalization",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Market Capitalization of the Asset the price date of the Asset. (Only Equities)",
                max_digits=20,
                null=True,
                verbose_name="Market Capitalization",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="outstanding_shares",
            field=models.DecimalField(
                decimal_places=4,
                default=Decimal("0"),
                help_text="The amount of outstanding share for this instrument",
                max_digits=14,
                verbose_name="Outstanding Shares",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="volume",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Volume of the Asset on the price date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Volume",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="volume_200d",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Average Volume of the Asset over the last 200 days from the price date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Average Volume (200 Days)",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="volume_50d",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The Average Volume of the Asset over the last 50 days from the price date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Average Volume (50 Days)",
            ),
        ),
        migrations.AddField(
            model_name="historicalinstrumentprice",
            name="outstanding_shares",
            field=models.DecimalField(
                decimal_places=4,
                default=Decimal("0"),
                help_text="The amount of outstanding share for this instrument",
                max_digits=14,
                verbose_name="Outstanding Shares",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="external_price_field_name",
            field=models.CharField(blank=True, max_length=64, null=True, verbose_name="External Price Field Name"),
        ),
        migrations.CreateModel(
            name="InstrumentFavoriteGroup",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=256)),
                (
                    "public",
                    models.BooleanField(
                        default=False, help_text="If set to True, this group will be available to everyone."
                    ),
                ),
                (
                    "instruments",
                    models.ManyToManyField(
                        blank=True,
                        related_name="favorite_groups",
                        to="wbportfolio.instrument",
                        verbose_name="Favorite Instruments Group",
                    ),
                ),
                (
                    "primary",
                    models.BooleanField(
                        default=False,
                        help_text="If set to True, this group will be set as default filter for instrument based viewset (Only one primary group allowed).",
                    ),
                ),
            ],
            options={
                "db_table": "portfolio_instrumentfavoritegroup",
            },
        ),
        migrations.AlterField(
            model_name="register",
            name="investor_type",
            field=models.CharField(
                choices=[
                    ("BANK", "Bank and Financial Institution"),
                    ("NOMINEE", "Nominee"),
                    ("GLOBAL", "Global"),
                    ("NON_FINANCIAL_ENTITY", "Non Financial Entities/Corporate"),
                ],
                default="BANK",
                max_length=24,
            ),
        ),
        migrations.CreateModel(
            name="Classification",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "height",
                    models.PositiveIntegerField(default=0, verbose_name="The height (leaf node have height 0)"),
                ),
                ("level_representation", models.CharField(max_length=256, verbose_name="Level Representation")),
                ("title", models.CharField(max_length=128, verbose_name="Title")),
                ("code", models.CharField(max_length=64, verbose_name="Code")),
                ("lft", models.PositiveIntegerField(editable=False)),
                ("rght", models.PositiveIntegerField(editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(editable=False)),
            ],
            options={
                "verbose_name": "Classification",
                "verbose_name_plural": "Classifications",
                "db_table": "portfolio_classification",
            },
        ),
        migrations.CreateModel(
            name="ClassificationGroup",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=128, verbose_name="Title")),
                (
                    "is_primary",
                    models.BooleanField(
                        default=False,
                        help_text="Set to True if this classification must be used as default if not specified otherwise",
                        verbose_name="Primary",
                    ),
                ),
                ("max_depth", models.IntegerField(default=0, verbose_name="Maximum Depth")),
            ],
            options={
                "verbose_name": "Classification Group",
                "verbose_name_plural": "Classification Groups",
                "db_table": "portfolio_classificationgroup",
            },
        ),
        migrations.CreateModel(
            name="ProductInstrumentPreferedClassificationThroughModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "instrument",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="prefered_classification_products",
                        to="wbportfolio.instrument",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="prefered_classification_instruments",
                        to="wbportfolio.product",
                    ),
                ),
            ],
            options={
                "db_table": "portfolio_productinstrumentpreferedclassificationthroughmodel",
            },
        ),
        migrations.AddField(
            model_name="classification",
            name="group",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="classifications",
                to="wbportfolio.classificationgroup",
                verbose_name="Classification Group",
            ),
        ),
        migrations.AddField(
            model_name="classification",
            name="parent",
            field=mptt.fields.TreeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="children",
                to="wbportfolio.classification",
                verbose_name="Parent Classification",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="classifications",
            field=models.ManyToManyField(
                blank=True,
                help_text="The assigned classifications",
                limit_choices_to=models.Q(("level", django.db.models.expressions.F("group__max_depth"))),
                related_name="instruments",
                to="wbportfolio.classification",
                verbose_name="Classifications",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="prefered_instrument_classifications",
            field=models.ManyToManyField(
                blank=True,
                related_name="prefered_products_classifications",
                through="wbportfolio.ProductInstrumentPreferedClassificationThroughModel",
                to="wbportfolio.instrument",
                verbose_name="The Prefered classification per instrument",
            ),
        ),
        migrations.RemoveField(
            model_name="equity",
            name="gics_classification",
        ),
        migrations.DeleteModel(
            name="IndustryClassification",
        ),
        migrations.AddField(
            model_name="classification",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="classifications",
            field=models.ManyToManyField(
                blank=True,
                limit_choices_to=models.Q(("level", django.db.models.expressions.F("group__max_depth"))),
                related_name="instruments",
                to="wbportfolio.classification",
                verbose_name="Classifications",
            ),
        ),
        migrations.RenameField(
            model_name="classification",
            old_name="code",
            new_name="code_aggregated",
        ),
        migrations.AddField(
            model_name="classification",
            name="level_code",
            field=models.IntegerField(default=0, verbose_name="Level Code"),
        ),
        migrations.AlterField(
            model_name="classification",
            name="code_aggregated",
            field=models.CharField(max_length=64, verbose_name="Code Aggregated"),
        ),
        migrations.AddField(
            model_name="classificationgroup",
            name="code_level_digits",
            field=models.IntegerField(default=2, verbose_name="The number of digits per code level"),
        ),
        migrations.CreateModel(
            name="PortfolioInstrumentPreferedClassificationThroughModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "portfolio",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="prefered_classification_instruments",
                        to="wbportfolio.portfolio",
                    ),
                ),
            ],
            options={
                "db_table": "portfolio_portfolioinstrumentpreferedclassificationthroughmodel",
                "verbose_name": "Portfolio Prefered Classification Per Instrument",
                "verbose_name_plural": "Portfolio Prefered Classification Per Instruments",
            },
        ),
        migrations.RemoveField(
            model_name="product",
            name="prefered_instrument_classifications",
        ),
        migrations.DeleteModel(
            name="ProductInstrumentPreferedClassificationThroughModel",
        ),
        migrations.RemoveField(
            model_name="historicalinstrumentprice",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicalinstrumentprice",
            name="instrument",
        ),
        migrations.RemoveField(
            model_name="historicalportfoliorole",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicalportfoliorole",
            name="instrument",
        ),
        migrations.RemoveField(
            model_name="historicaltransaction",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicaltransaction",
            name="portfolio",
        ),
        migrations.AlterField(
            model_name="portfoliosynchronization",
            name="import_path",
            field=models.CharField(
                default="restbench.wbportfolio.default", max_length=512, verbose_name="Import Path"
            ),
        ),
        migrations.DeleteModel(
            name="HistoricalInstrumentPrice",
        ),
        migrations.DeleteModel(
            name="HistoricalPortfolioRole",
        ),
        migrations.DeleteModel(
            name="HistoricalTransaction",
        ),
        migrations.CreateModel(
            name="HistoricalTransaction",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                (
                    "transaction_type",
                    models.CharField(
                        choices=[("Trade", "Trade"), ("Dividend", "Dividend"), ("Expiry", "Expiry"), ("Fees", "Fees")],
                        default="Trade",
                        max_length=255,
                        verbose_name="Type",
                    ),
                ),
                (
                    "transaction_date",
                    models.DateField(
                        help_text="The date that this transaction was traded.", verbose_name="Trade Date"
                    ),
                ),
                (
                    "book_date",
                    models.DateField(
                        blank=True,
                        help_text="The date that this transaction was booked.",
                        null=True,
                        verbose_name="Trade Date",
                    ),
                ),
                (
                    "value_date",
                    models.DateField(
                        blank=True,
                        help_text="The date that this transaction was valuated.",
                        null=True,
                        verbose_name="Value Date",
                    ),
                ),
                (
                    "currency_fx_rate",
                    models.DecimalField(
                        decimal_places=8, default=Decimal("1"), max_digits=14, verbose_name="FOREX rate"
                    ),
                ),
                (
                    "total_value",
                    models.DecimalField(
                        blank=True, decimal_places=4, default=0, max_digits=20, verbose_name="Total Value"
                    ),
                ),
                (
                    "total_value_fx_portfolio",
                    models.DecimalField(
                        blank=True, decimal_places=4, default=0, max_digits=20, verbose_name="Total Value Fx Portfolio"
                    ),
                ),
                (
                    "total_value_gross",
                    models.DecimalField(
                        blank=True, decimal_places=4, default=0, max_digits=20, verbose_name="Total Value Gross"
                    ),
                ),
                (
                    "total_value_gross_fx_portfolio",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        default=0,
                        max_digits=20,
                        verbose_name="Total Value Gross Fx Portfolio",
                    ),
                ),
                (
                    "external_id",
                    models.CharField(
                        blank=True,
                        help_text="An external identifier that was supplied.",
                        max_length=255,
                        null=True,
                        verbose_name="External Identifier",
                    ),
                ),
                ("comment", models.TextField(default="", verbose_name="Comment")),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "portfolio",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.portfolio",
                        verbose_name="Portfolio",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Transaction",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalRegister",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("register_reference", models.CharField(db_index=True, max_length=255)),
                ("register_name_1", models.CharField(max_length=255)),
                ("register_name_2", models.CharField(default="", max_length=255)),
                ("global_register_reference", models.CharField(default="", max_length=255)),
                ("external_register_reference", models.CharField(default="", max_length=255)),
                ("custodian_reference", models.CharField(max_length=255)),
                ("custodian_name_1", models.CharField(max_length=255)),
                ("custodian_name_2", models.CharField(default="", max_length=255)),
                ("custodian_address", models.TextField(default="")),
                ("custodian_postcode", models.CharField(default="", max_length=255)),
                ("custodian_city", models.CharField(default="", max_length=255)),
                ("sales_reference", models.CharField(default="", max_length=255)),
                ("dealer_reference", models.CharField(default="", max_length=255)),
                ("outlet_reference", models.CharField(max_length=255)),
                ("outlet_name", models.CharField(max_length=255)),
                ("outlet_address", models.TextField(default="")),
                ("outlet_postcode", models.CharField(default="", max_length=255)),
                ("outlet_city", models.CharField(default="", max_length=255)),
                (
                    "investor_type",
                    models.CharField(
                        choices=[
                            ("BANK", "Bank and Financial Institution"),
                            ("NOMINEE", "Nominee"),
                            ("GLOBAL", "Global"),
                            ("NON_FINANCIAL_ENTITY", "Non Financial Entities/Corporate"),
                        ],
                        default="BANK",
                        max_length=24,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[("ACTIVE", "Active"), ("INACTIVE", "Inactive"), ("WARNING", "Warning")],
                        default="ACTIVE",
                        max_length=8,
                    ),
                ),
                ("status_message", models.TextField(default="")),
                ("opened", models.DateField()),
                ("opened_reference_1", models.CharField(default="", max_length=255)),
                ("opened_reference_2", models.CharField(default="", max_length=255)),
                ("updated_reference_1", models.CharField(default="", max_length=255)),
                ("updated_reference_2", models.CharField(default="", max_length=255)),
                ("computed_str", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Register",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalProductGroup",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("base_color", colorfield.fields.ColorField(blank=True, default="#FF0000", max_length=64, null=True)),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True)),
                (
                    "instrument_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Product", "Product"),
                            ("Index", "Index"),
                            ("ProductGroup", "Product Group"),
                            ("Equity", "Equity"),
                            ("Cash", "Cash"),
                            ("Option", "Option"),
                            ("Right", "Right"),
                            ("Bond", "Bond"),
                            ("InterestRateDerivative", "Interest Rate Derivate"),
                            ("Future", "Future"),
                            ("Forward", "Forward"),
                            ("Swap", "Swap"),
                            ("Coupon", "Coupon"),
                            ("Crypto", "Crypto"),
                            ("Commodity", "Commodity"),
                        ],
                        max_length=255,
                        null=True,
                        verbose_name="Type",
                    ),
                ),
                (
                    "inception_date",
                    models.DateField(
                        blank=True, help_text="The instrument creation", null=True, verbose_name="Inception Date"
                    ),
                ),
                ("identifier", models.CharField(blank=True, max_length=255, null=True, verbose_name="Identifier")),
                (
                    "external_id",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="External Identifier"),
                ),
                (
                    "external_price_field_name",
                    models.CharField(blank=True, max_length=64, null=True, verbose_name="External Price Field Name"),
                ),
                ("title", models.CharField(blank=True, max_length=255, null=True, verbose_name="Title")),
                (
                    "title_repr",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Factsheet Title"),
                ),
                ("description", models.TextField(blank=True, default="", null=True, verbose_name="Description")),
                (
                    "isin",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="The ISIN provided by the bank.",
                        max_length=12,
                        null=True,
                        verbose_name="ISIN",
                    ),
                ),
                (
                    "ticker",
                    models.CharField(
                        blank=True,
                        help_text="The ticker provided by the bank.",
                        max_length=255,
                        null=True,
                        verbose_name="Ticker Bloomberg",
                    ),
                ),
                ("is_cash", models.BooleanField(default=False)),
                (
                    "issue_price",
                    models.PositiveIntegerField(
                        default=100,
                        help_text="The initial issue price that is displayed on the facthsheet",
                        verbose_name="Issue Price",
                    ),
                ),
                (
                    "type",
                    models.CharField(choices=[("Fund", "Fund")], default="Fund", max_length=64, verbose_name="Type"),
                ),
                ("old_id", models.IntegerField(blank=True, null=True)),
                ("category", models.CharField(choices=[("UCITS", "Ucits")], default="UCITS", max_length=64)),
                ("umbrella", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "price_computation",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.pricecomputation",
                        verbose_name="Price Computation Method",
                    ),
                ),
                (
                    "risk_instrument",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.instrument",
                        verbose_name="The Instrument Risk Free Rate Reference",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Product Group",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalProduct",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("base_color", colorfield.fields.ColorField(blank=True, default="#FF0000", max_length=64, null=True)),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True)),
                (
                    "instrument_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Product", "Product"),
                            ("Index", "Index"),
                            ("ProductGroup", "Product Group"),
                            ("Equity", "Equity"),
                            ("Cash", "Cash"),
                            ("Option", "Option"),
                            ("Right", "Right"),
                            ("Bond", "Bond"),
                            ("InterestRateDerivative", "Interest Rate Derivate"),
                            ("Future", "Future"),
                            ("Forward", "Forward"),
                            ("Swap", "Swap"),
                            ("Coupon", "Coupon"),
                            ("Crypto", "Crypto"),
                            ("Commodity", "Commodity"),
                        ],
                        max_length=255,
                        null=True,
                        verbose_name="Type",
                    ),
                ),
                (
                    "inception_date",
                    models.DateField(
                        blank=True, help_text="The instrument creation", null=True, verbose_name="Inception Date"
                    ),
                ),
                ("identifier", models.CharField(blank=True, max_length=255, null=True, verbose_name="Identifier")),
                (
                    "external_id",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="External Identifier"),
                ),
                (
                    "external_price_field_name",
                    models.CharField(blank=True, max_length=64, null=True, verbose_name="External Price Field Name"),
                ),
                ("title", models.CharField(blank=True, max_length=255, null=True, verbose_name="Title")),
                (
                    "title_repr",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Factsheet Title"),
                ),
                ("description", models.TextField(blank=True, default="", null=True, verbose_name="Description")),
                (
                    "isin",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="The ISIN provided by the bank.",
                        max_length=12,
                        null=True,
                        verbose_name="ISIN",
                    ),
                ),
                (
                    "ticker",
                    models.CharField(
                        blank=True,
                        help_text="The ticker provided by the bank.",
                        max_length=255,
                        null=True,
                        verbose_name="Ticker Bloomberg",
                    ),
                ),
                ("is_cash", models.BooleanField(default=False)),
                (
                    "issue_price",
                    models.PositiveIntegerField(
                        default=100,
                        help_text="The initial issue price that is displayed on the facthsheet",
                        verbose_name="Issue Price",
                    ),
                ),
                ("old_id", models.IntegerField(blank=True, null=True)),
                (
                    "share_price",
                    models.PositiveIntegerField(
                        default=100,
                        help_text="The initial share price that is used to calculate the nominal value of a product.",
                        verbose_name="Share Price",
                    ),
                ),
                (
                    "bank_fees",
                    models.DecimalField(
                        decimal_places=6,
                        help_text="The fees that the bank receives each day for hosting this product in percent. Can only be between 0 and 99.99%.",
                        max_digits=6,
                        verbose_name="Bank Fees",
                    ),
                ),
                (
                    "management_fees",
                    models.DecimalField(
                        decimal_places=6,
                        help_text="The fees that you receive each day for managing this product in percent. Can only be between 0 and 99.99%.",
                        max_digits=6,
                        verbose_name="Management Fees",
                    ),
                ),
                (
                    "performance_fees",
                    models.DecimalField(
                        decimal_places=6,
                        help_text="The fees that you receive each day when a performance criteria is met in percent. Can only be between 0 and 99.99%.",
                        max_digits=6,
                        verbose_name="Performance Fees",
                    ),
                ),
                (
                    "performance_fees_vat",
                    models.DecimalField(
                        decimal_places=6,
                        help_text="The VAT that gets deducted, when you receive performance fees. Can only be between 0 and 99.99%.",
                        max_digits=6,
                        verbose_name="Performance fees (VAT)",
                    ),
                ),
                (
                    "type_of_return",
                    models.CharField(
                        choices=[
                            ("TOTAL_RETURN", "Total return"),
                            ("YIELD", "Yield"),
                            ("PRICE_RETURN", "Price return"),
                            ("ABSOLUT_RETURN", "Absolut return"),
                        ],
                        default="TOTAL_RETURN",
                        max_length=16,
                        verbose_name="Type of Return",
                    ),
                ),
                (
                    "asset_class",
                    models.CharField(
                        choices=[
                            ("EQUITY", "Equity"),
                            ("FIXED_INCOME", "Fixed income"),
                            ("PRIVATE_EQUITY", "Private equity"),
                            ("DERIVATIVE", "Derivative"),
                            ("CASH", "Cash"),
                            ("CRYPTOCURRENCY", "Cryptocurrency"),
                            ("COMMODITY", "Commodity"),
                            ("HEDGE_FUND", "Hedge Fund"),
                            ("MULTI_ASSET", "Multi Asset"),
                        ],
                        default="EQUITY",
                        max_length=16,
                        verbose_name="Asset Class",
                    ),
                ),
                (
                    "legal_structure",
                    models.CharField(
                        choices=[
                            ("AMC", "Actively Managed Certificate"),
                            ("SICAV_UCITS", "SICAV (UCITS)"),
                            ("PLC_UCITS", "PLC (UCITS)"),
                            ("SICAV_AIF", "SICAV (AIFs)"),
                            ("SCF_UCITS", "Swiss Contractual Fund (UCITS)"),
                            ("FCP_AIF", "FCP (AIFs)"),
                            ("PLC_AIF", "PLC (AIFs)"),
                            ("SCF_AIF", "Swiss Contractual Fund (AIF) "),
                        ],
                        default="AMC",
                        max_length=16,
                        verbose_name="Legal Structure",
                    ),
                ),
                (
                    "investment_index",
                    models.CharField(
                        choices=[("LONG", "Long"), ("SHORT", "Short"), ("LONG_SHORT", "Long/Short")],
                        default="LONG",
                        max_length=16,
                        verbose_name="Long/Short Strategy",
                    ),
                ),
                (
                    "liquidity",
                    models.CharField(
                        choices=[
                            ("DAILY", "Daily"),
                            ("WEEKLY", "Weekly"),
                            ("MONTHLY", "Monthly"),
                            ("QUATERLY", "Quaterly"),
                            ("YEARLY", "Yearly"),
                        ],
                        default="DAILY",
                        max_length=16,
                        verbose_name="Liquidity",
                    ),
                ),
                (
                    "risk_scale",
                    models.IntegerField(
                        default=4,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(7),
                        ],
                        verbose_name="Risk Scale",
                    ),
                ),
                ("no_aggregation", models.BooleanField(default=False)),
                (
                    "dividend",
                    models.CharField(
                        choices=[("CAPITALISATION", "Capitalisation"), ("DISTRIBUTION", "Distribution")],
                        default="CAPITALISATION",
                        max_length=16,
                        verbose_name="Type of Dividends",
                    ),
                ),
                (
                    "minimum_subscription",
                    models.IntegerField(
                        default=100, help_text="Minimum subscription amount allowed to invest in the fund"
                    ),
                ),
                ("cut_off_time", models.TimeField(default=datetime.time(13, 0))),
                ("external_webpage", models.URLField(blank=True, null=True)),
                (
                    "ticker_reuters",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Reuters Ticker"),
                ),
                (
                    "_custom_management_rebates",
                    models.DecimalField(blank=True, decimal_places=5, max_digits=5, null=True),
                ),
                (
                    "_custom_performance_rebates",
                    models.DecimalField(blank=True, decimal_places=5, max_digits=5, null=True),
                ),
                (
                    "_custom_management_rebates_indirect",
                    models.DecimalField(blank=True, decimal_places=5, max_digits=5, null=True),
                ),
                (
                    "_custom_performance_rebates_indirect",
                    models.DecimalField(blank=True, decimal_places=5, max_digits=5, null=True),
                ),
                ("_custom_minimum_investment", models.IntegerField(blank=True, null=True, verbose_name="Minimum AUM")),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "fee_calculation",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.feecalculation",
                        verbose_name="Fee Calculation Method",
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.productgroup",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "price_computation",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.pricecomputation",
                        verbose_name="Price Computation Method",
                    ),
                ),
                (
                    "risk_instrument",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.instrument",
                        verbose_name="The Instrument Risk Free Rate Reference",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Product",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalPortfolioRole",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                (
                    "role_type",
                    models.CharField(
                        choices=[
                            ("manager", "Manager"),
                            ("risk_manager", "Risk Manager"),
                            ("analyst", "Analyst"),
                            ("portfolio_manager", "Portfolio Manager"),
                        ],
                        max_length=24,
                        verbose_name="Type",
                    ),
                ),
                ("start", models.DateField(blank=True, null=True, verbose_name="Start")),
                ("end", models.DateField(blank=True, null=True, verbose_name="End")),
                ("weighting", models.FloatField(default=1, verbose_name="Weight")),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "instrument",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.instrument",
                        verbose_name="Instrument",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Portfolio Role",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalPortfolio",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                (
                    "portfolio_type",
                    models.CharField(
                        choices=[("BASE", "Base"), ("INDEX", "Index"), ("MODEL", "Model"), ("COMPUTED", "Computed")],
                        default="BASE",
                        max_length=255,
                        verbose_name="Type",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        default="", help_text="The Name of the Portfolio", max_length=255, verbose_name="Name"
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "base_index_portfolio",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.portfolio",
                        verbose_name="Index Portfolio on which this portfolio is based",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "portfolio_synchronization",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.portfoliosynchronization",
                        verbose_name="Portfolio Synchronization Method",
                    ),
                ),
                (
                    "theme_index_portfolio",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.portfolio",
                        verbose_name="Theme Portfolio on which this portfolio is based",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Portfolio",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalInterestRateDerivative",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("base_color", colorfield.fields.ColorField(blank=True, default="#FF0000", max_length=64, null=True)),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True)),
                (
                    "instrument_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Product", "Product"),
                            ("Index", "Index"),
                            ("ProductGroup", "Product Group"),
                            ("Equity", "Equity"),
                            ("Cash", "Cash"),
                            ("Option", "Option"),
                            ("Right", "Right"),
                            ("Bond", "Bond"),
                            ("InterestRateDerivative", "Interest Rate Derivate"),
                            ("Future", "Future"),
                            ("Forward", "Forward"),
                            ("Swap", "Swap"),
                            ("Coupon", "Coupon"),
                            ("Crypto", "Crypto"),
                            ("Commodity", "Commodity"),
                        ],
                        max_length=255,
                        null=True,
                        verbose_name="Type",
                    ),
                ),
                (
                    "inception_date",
                    models.DateField(
                        blank=True, help_text="The instrument creation", null=True, verbose_name="Inception Date"
                    ),
                ),
                ("identifier", models.CharField(blank=True, max_length=255, null=True, verbose_name="Identifier")),
                (
                    "external_id",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="External Identifier"),
                ),
                (
                    "external_price_field_name",
                    models.CharField(blank=True, max_length=64, null=True, verbose_name="External Price Field Name"),
                ),
                ("title", models.CharField(blank=True, max_length=255, null=True, verbose_name="Title")),
                (
                    "title_repr",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Factsheet Title"),
                ),
                ("description", models.TextField(blank=True, default="", null=True, verbose_name="Description")),
                (
                    "isin",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="The ISIN provided by the bank.",
                        max_length=12,
                        null=True,
                        verbose_name="ISIN",
                    ),
                ),
                (
                    "ticker",
                    models.CharField(
                        blank=True,
                        help_text="The ticker provided by the bank.",
                        max_length=255,
                        null=True,
                        verbose_name="Ticker Bloomberg",
                    ),
                ),
                ("is_cash", models.BooleanField(default=False)),
                (
                    "issue_price",
                    models.PositiveIntegerField(
                        default=100,
                        help_text="The initial issue price that is displayed on the facthsheet",
                        verbose_name="Issue Price",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "price_computation",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.pricecomputation",
                        verbose_name="Price Computation Method",
                    ),
                ),
                (
                    "risk_instrument",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.instrument",
                        verbose_name="The Instrument Risk Free Rate Reference",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical interest rate derivative",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalInstrument",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("base_color", colorfield.fields.ColorField(blank=True, default="#FF0000", max_length=64, null=True)),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True)),
                (
                    "instrument_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Product", "Product"),
                            ("Index", "Index"),
                            ("ProductGroup", "Product Group"),
                            ("Equity", "Equity"),
                            ("Cash", "Cash"),
                            ("Option", "Option"),
                            ("Right", "Right"),
                            ("Bond", "Bond"),
                            ("InterestRateDerivative", "Interest Rate Derivate"),
                            ("Future", "Future"),
                            ("Forward", "Forward"),
                            ("Swap", "Swap"),
                            ("Coupon", "Coupon"),
                            ("Crypto", "Crypto"),
                            ("Commodity", "Commodity"),
                        ],
                        max_length=255,
                        null=True,
                        verbose_name="Type",
                    ),
                ),
                (
                    "inception_date",
                    models.DateField(
                        blank=True, help_text="The instrument creation", null=True, verbose_name="Inception Date"
                    ),
                ),
                ("identifier", models.CharField(blank=True, max_length=255, null=True, verbose_name="Identifier")),
                (
                    "external_id",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="External Identifier"),
                ),
                (
                    "external_price_field_name",
                    models.CharField(blank=True, max_length=64, null=True, verbose_name="External Price Field Name"),
                ),
                ("title", models.CharField(blank=True, max_length=255, null=True, verbose_name="Title")),
                (
                    "title_repr",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Factsheet Title"),
                ),
                ("description", models.TextField(blank=True, default="", null=True, verbose_name="Description")),
                (
                    "isin",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="The ISIN provided by the bank.",
                        max_length=12,
                        null=True,
                        verbose_name="ISIN",
                    ),
                ),
                (
                    "ticker",
                    models.CharField(
                        blank=True,
                        help_text="The ticker provided by the bank.",
                        max_length=255,
                        null=True,
                        verbose_name="Ticker Bloomberg",
                    ),
                ),
                ("is_cash", models.BooleanField(default=False)),
                (
                    "issue_price",
                    models.PositiveIntegerField(
                        default=100,
                        help_text="The initial issue price that is displayed on the facthsheet",
                        verbose_name="Issue Price",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "price_computation",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.pricecomputation",
                        verbose_name="Price Computation Method",
                    ),
                ),
                (
                    "risk_instrument",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.instrument",
                        verbose_name="The Instrument Risk Free Rate Reference",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical instrument",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalIndex",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("base_color", colorfield.fields.ColorField(blank=True, default="#FF0000", max_length=64, null=True)),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True)),
                (
                    "instrument_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Product", "Product"),
                            ("Index", "Index"),
                            ("ProductGroup", "Product Group"),
                            ("Equity", "Equity"),
                            ("Cash", "Cash"),
                            ("Option", "Option"),
                            ("Right", "Right"),
                            ("Bond", "Bond"),
                            ("InterestRateDerivative", "Interest Rate Derivate"),
                            ("Future", "Future"),
                            ("Forward", "Forward"),
                            ("Swap", "Swap"),
                            ("Coupon", "Coupon"),
                            ("Crypto", "Crypto"),
                            ("Commodity", "Commodity"),
                        ],
                        max_length=255,
                        null=True,
                        verbose_name="Type",
                    ),
                ),
                (
                    "inception_date",
                    models.DateField(
                        blank=True, help_text="The instrument creation", null=True, verbose_name="Inception Date"
                    ),
                ),
                ("identifier", models.CharField(blank=True, max_length=255, null=True, verbose_name="Identifier")),
                (
                    "external_id",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="External Identifier"),
                ),
                (
                    "external_price_field_name",
                    models.CharField(blank=True, max_length=64, null=True, verbose_name="External Price Field Name"),
                ),
                ("title", models.CharField(blank=True, max_length=255, null=True, verbose_name="Title")),
                (
                    "title_repr",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Factsheet Title"),
                ),
                ("description", models.TextField(blank=True, default="", null=True, verbose_name="Description")),
                (
                    "isin",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="The ISIN provided by the bank.",
                        max_length=12,
                        null=True,
                        verbose_name="ISIN",
                    ),
                ),
                (
                    "ticker",
                    models.CharField(
                        blank=True,
                        help_text="The ticker provided by the bank.",
                        max_length=255,
                        null=True,
                        verbose_name="Ticker Bloomberg",
                    ),
                ),
                ("is_cash", models.BooleanField(default=False)),
                (
                    "issue_price",
                    models.PositiveIntegerField(
                        default=100,
                        help_text="The initial issue price that is displayed on the facthsheet",
                        verbose_name="Issue Price",
                    ),
                ),
                ("old_id", models.IntegerField(blank=True, null=True)),
                ("risk_scale", models.PositiveIntegerField(blank=True, null=True, verbose_name="Risk Scale")),
                (
                    "initial_date",
                    models.DateField(
                        blank=True, help_text="The Initial Date of the Index.", null=True, verbose_name="Initial Date"
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "price_computation",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.pricecomputation",
                        verbose_name="Price Computation Method",
                    ),
                ),
                (
                    "risk_instrument",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.instrument",
                        verbose_name="The Instrument Risk Free Rate Reference",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Index",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalExchange",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        help_text="Name of the Exchange.",
                        max_length=265,
                        null=True,
                        verbose_name="Exchange Name",
                    ),
                ),
                (
                    "mic_code",
                    models.CharField(
                        blank=True,
                        help_text="Market Identifier Code.",
                        max_length=4,
                        null=True,
                        verbose_name="MIC (ISO)",
                    ),
                ),
                (
                    "mic_name",
                    models.CharField(
                        blank=True,
                        help_text="Market Identifier Name.",
                        max_length=126,
                        null=True,
                        verbose_name="MIC (ISO) Name",
                    ),
                ),
                (
                    "operating_mic_code",
                    models.CharField(
                        blank=True,
                        help_text="Operating Market Identifier Code.",
                        max_length=4,
                        null=True,
                        verbose_name="Operating MIC Code",
                    ),
                ),
                (
                    "operating_mic_name",
                    models.CharField(
                        blank=True,
                        help_text="Operating Market Identifier Name.",
                        max_length=126,
                        null=True,
                        verbose_name="Operating MIC Name",
                    ),
                ),
                (
                    "bbg_exchange",
                    models.CharField(
                        blank=True,
                        help_text="Bloomberg Exchange Code.",
                        max_length=4,
                        null=True,
                        verbose_name="BBG Exchange Code",
                    ),
                ),
                (
                    "bbg_composite_primary",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates the primary exchange for this BBG Composite Code.",
                        verbose_name="BBG Primary composite",
                    ),
                ),
                (
                    "bbg_composite",
                    models.CharField(
                        blank=True,
                        help_text="Bloomberg Composite Code.",
                        max_length=4,
                        null=True,
                        verbose_name="BBG Composite Code",
                    ),
                ),
                (
                    "refinitiv_identifier_code",
                    models.CharField(
                        blank=True,
                        help_text="Reuters Exchange Code.",
                        max_length=4,
                        null=True,
                        verbose_name="RIC Exchange Code",
                    ),
                ),
                (
                    "refinitiv_mnemonic",
                    models.CharField(
                        blank=True,
                        help_text="Reuters Exchange Mnemonic Code.",
                        max_length=4,
                        null=True,
                        verbose_name="Refinitiv Mnemonic",
                    ),
                ),
                (
                    "city",
                    models.CharField(
                        blank=True,
                        help_text="The city where this Exchange is located at.",
                        max_length=255,
                        null=True,
                        verbose_name="City",
                    ),
                ),
                (
                    "website",
                    models.URLField(
                        blank=True, help_text="The Website of the Exchange", null=True, verbose_name="Website"
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True, default="", help_text="Any comments for this exchange", verbose_name="Comments"
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Exchange",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalEquity",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("base_color", colorfield.fields.ColorField(blank=True, default="#FF0000", max_length=64, null=True)),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True)),
                (
                    "instrument_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Product", "Product"),
                            ("Index", "Index"),
                            ("ProductGroup", "Product Group"),
                            ("Equity", "Equity"),
                            ("Cash", "Cash"),
                            ("Option", "Option"),
                            ("Right", "Right"),
                            ("Bond", "Bond"),
                            ("InterestRateDerivative", "Interest Rate Derivate"),
                            ("Future", "Future"),
                            ("Forward", "Forward"),
                            ("Swap", "Swap"),
                            ("Coupon", "Coupon"),
                            ("Crypto", "Crypto"),
                            ("Commodity", "Commodity"),
                        ],
                        max_length=255,
                        null=True,
                        verbose_name="Type",
                    ),
                ),
                (
                    "inception_date",
                    models.DateField(
                        blank=True, help_text="The instrument creation", null=True, verbose_name="Inception Date"
                    ),
                ),
                ("identifier", models.CharField(blank=True, max_length=255, null=True, verbose_name="Identifier")),
                (
                    "external_id",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="External Identifier"),
                ),
                (
                    "external_price_field_name",
                    models.CharField(blank=True, max_length=64, null=True, verbose_name="External Price Field Name"),
                ),
                ("title", models.CharField(blank=True, max_length=255, null=True, verbose_name="Title")),
                (
                    "title_repr",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Factsheet Title"),
                ),
                ("description", models.TextField(blank=True, default="", null=True, verbose_name="Description")),
                (
                    "isin",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="The ISIN provided by the bank.",
                        max_length=12,
                        null=True,
                        verbose_name="ISIN",
                    ),
                ),
                (
                    "ticker",
                    models.CharField(
                        blank=True,
                        help_text="The ticker provided by the bank.",
                        max_length=255,
                        null=True,
                        verbose_name="Ticker Bloomberg",
                    ),
                ),
                ("is_cash", models.BooleanField(default=False)),
                (
                    "issue_price",
                    models.PositiveIntegerField(
                        default=100,
                        help_text="The initial issue price that is displayed on the facthsheet",
                        verbose_name="Issue Price",
                    ),
                ),
                ("old_id", models.IntegerField(blank=True, null=True)),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "price_computation",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.pricecomputation",
                        verbose_name="Price Computation Method",
                    ),
                ),
                (
                    "risk_instrument",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.instrument",
                        verbose_name="The Instrument Risk Free Rate Reference",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Equity",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalCustodian",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                (
                    "name",
                    models.CharField(
                        db_index=True, help_text="The Name of the Custodian.", max_length=255, verbose_name="Name"
                    ),
                ),
                (
                    "mapping",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=255),
                        default=list,
                        help_text="Each custodian of this mapping will be assigned to this custodian.",
                        size=None,
                        verbose_name="Custodian Mapping",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Custodian",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalClassificationGroup",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("title", models.CharField(max_length=128, verbose_name="Title")),
                (
                    "is_primary",
                    models.BooleanField(
                        default=False,
                        help_text="Set to True if this classification must be used as default if not specified otherwise",
                        verbose_name="Primary",
                    ),
                ),
                ("max_depth", models.IntegerField(default=0, verbose_name="Maximum Depth")),
                (
                    "code_level_digits",
                    models.IntegerField(default=2, verbose_name="The number of digits per code level"),
                ),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Classification Group",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="HistoricalBond",
            fields=[
                ("id", models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID")),
                ("base_color", colorfield.fields.ColorField(blank=True, default="#FF0000", max_length=64, null=True)),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True)),
                (
                    "instrument_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Product", "Product"),
                            ("Index", "Index"),
                            ("ProductGroup", "Product Group"),
                            ("Equity", "Equity"),
                            ("Cash", "Cash"),
                            ("Option", "Option"),
                            ("Right", "Right"),
                            ("Bond", "Bond"),
                            ("InterestRateDerivative", "Interest Rate Derivate"),
                            ("Future", "Future"),
                            ("Forward", "Forward"),
                            ("Swap", "Swap"),
                            ("Coupon", "Coupon"),
                            ("Crypto", "Crypto"),
                            ("Commodity", "Commodity"),
                        ],
                        max_length=255,
                        null=True,
                        verbose_name="Type",
                    ),
                ),
                (
                    "inception_date",
                    models.DateField(
                        blank=True, help_text="The instrument creation", null=True, verbose_name="Inception Date"
                    ),
                ),
                ("identifier", models.CharField(blank=True, max_length=255, null=True, verbose_name="Identifier")),
                (
                    "external_id",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="External Identifier"),
                ),
                (
                    "external_price_field_name",
                    models.CharField(blank=True, max_length=64, null=True, verbose_name="External Price Field Name"),
                ),
                ("title", models.CharField(blank=True, max_length=255, null=True, verbose_name="Title")),
                (
                    "title_repr",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Factsheet Title"),
                ),
                ("description", models.TextField(blank=True, default="", null=True, verbose_name="Description")),
                (
                    "isin",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="The ISIN provided by the bank.",
                        max_length=12,
                        null=True,
                        verbose_name="ISIN",
                    ),
                ),
                (
                    "ticker",
                    models.CharField(
                        blank=True,
                        help_text="The ticker provided by the bank.",
                        max_length=255,
                        null=True,
                        verbose_name="Ticker Bloomberg",
                    ),
                ),
                ("is_cash", models.BooleanField(default=False)),
                (
                    "issue_price",
                    models.PositiveIntegerField(
                        default=100,
                        help_text="The initial issue price that is displayed on the facthsheet",
                        verbose_name="Issue Price",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")], max_length=1),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "price_computation",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.pricecomputation",
                        verbose_name="Price Computation Method",
                    ),
                ),
                (
                    "risk_instrument",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="wbportfolio.instrument",
                        verbose_name="The Instrument Risk Free Rate Reference",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical bond",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
        ),
        migrations.CreateModel(
            name="TradeProposal",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("trade_date", models.DateTimeField(verbose_name="Trading Date")),
                ("comment", models.TextField(default="", verbose_name="Trade Comment")),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[
                            ("DRAFT", "Draft"),
                            ("SUBMIT", "Submit"),
                            ("APPROVED", "Approved"),
                            ("DENIED", "Denied"),
                        ],
                        default="DRAFT",
                        max_length=50,
                        verbose_name="Status",
                    ),
                ),
                (
                    "portfolio",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="trade_proposals",
                        to="wbportfolio.portfolio",
                        verbose_name="Portfolio",
                    ),
                ),
                (
                    "model_portfolio",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="model_trade_proposals",
                        to="wbportfolio.portfolio",
                        verbose_name="Model Portfolio",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="instrumentportfoliothroughmodel",
            name="model_portfolio",
            field=models.BooleanField(
                default=False,
                help_text="Set the MOdel Portfolio. Only one instrument among the instruments implementing that portfolio can be set as model",
            ),
        ),
        migrations.RemoveField(
            model_name="portfolio",
            name="depends_on",
        ),
        migrations.CreateModel(
            name="PortfolioPortfolioThroughModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("is_primary", models.BooleanField(default=False)),
                ("is_theme", models.BooleanField(default=False)),
                (
                    "dependency_portfolio",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dependent_through",
                        to="wbportfolio.portfolio",
                    ),
                ),
                (
                    "dependent_portfolio",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dependency_through",
                        to="wbportfolio.portfolio",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="portfolio",
            name="depends_on",
            field=models.ManyToManyField(
                blank=True,
                related_name="dependent_portfolios",
                through="wbportfolio.PortfolioPortfolioThroughModel",
                to="wbportfolio.portfolio",
                verbose_name="The portfolios this portfolio depends on",
            ),
        ),
        migrations.RemoveField(
            model_name="historicalportfolio",
            name="base_index_portfolio",
        ),
        migrations.RemoveField(
            model_name="historicalportfolio",
            name="theme_index_portfolio",
        ),
        migrations.RemoveField(
            model_name="portfolio",
            name="base_index_portfolio",
        ),
        migrations.RemoveField(
            model_name="portfolio",
            name="theme_index_portfolio",
        ),
        migrations.AlterField(
            model_name="portfolio",
            name="depends_on",
            field=models.ManyToManyField(
                blank=True,
                related_name="dependency_portfolios",
                through="wbportfolio.PortfolioPortfolioThroughModel",
                to="wbportfolio.portfolio",
                verbose_name="The portfolios this portfolio depends on",
            ),
        ),
        migrations.AlterField(
            model_name="tradeproposal",
            name="status",
            field=django_fsm.FSMField(
                choices=[
                    ("DRAFT", "Draft"),
                    ("SUBMIT", "Submit"),
                    ("APPROVED", "Approved"),
                    ("REVERTED", "Reverted"),
                    ("DENIED", "Denied"),
                ],
                default="DRAFT",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AlterField(
            model_name="dividend",
            name="shares",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The number of shares that were traded.",
                max_digits=15,
                null=True,
                verbose_name="Shares",
            ),
        ),
        migrations.AlterField(
            model_name="expiry",
            name="shares",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The number of shares that were traded.",
                max_digits=15,
                null=True,
                verbose_name="Shares",
            ),
        ),
        migrations.RenameField(
            model_name="portfolioportfoliothroughmodel",
            old_name="dependent_portfolio",
            new_name="portfolio",
        ),
        migrations.AlterField(
            model_name="tradeproposal",
            name="trade_date",
            field=models.DateField(verbose_name="Trading Date"),
        ),
        migrations.AddField(
            model_name="historicalbond",
            name="refinitiv_identifier_code",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="Refinitiv Identifier Code",
                max_length=255,
                null=True,
                verbose_name="RIC",
            ),
        ),
        migrations.AddField(
            model_name="historicalequity",
            name="refinitiv_identifier_code",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="Refinitiv Identifier Code",
                max_length=255,
                null=True,
                verbose_name="RIC",
            ),
        ),
        migrations.AddField(
            model_name="historicalindex",
            name="refinitiv_identifier_code",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="Refinitiv Identifier Code",
                max_length=255,
                null=True,
                verbose_name="RIC",
            ),
        ),
        migrations.AddField(
            model_name="historicalinstrument",
            name="refinitiv_identifier_code",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="Refinitiv Identifier Code",
                max_length=255,
                null=True,
                verbose_name="RIC",
            ),
        ),
        migrations.AddField(
            model_name="historicalinterestratederivative",
            name="refinitiv_identifier_code",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="Refinitiv Identifier Code",
                max_length=255,
                null=True,
                verbose_name="RIC",
            ),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="refinitiv_identifier_code",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="Refinitiv Identifier Code",
                max_length=255,
                null=True,
                verbose_name="RIC",
            ),
        ),
        migrations.AddField(
            model_name="historicalproductgroup",
            name="refinitiv_identifier_code",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="Refinitiv Identifier Code",
                max_length=255,
                null=True,
                verbose_name="RIC",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="refinitiv_identifier_code",
            field=models.CharField(
                blank=True,
                help_text="Refinitiv Identifier Code",
                max_length=255,
                null=True,
                unique=True,
                verbose_name="RIC",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="ask",
            field=models.FloatField(blank=True, null=True, verbose_name="Ask"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="bid",
            field=models.FloatField(blank=True, null=True, verbose_name="Bid"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="open",
            field=models.FloatField(blank=True, null=True, verbose_name="Open"),
        ),
        migrations.AlterField(
            model_name="historicalbond",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Title (Representation)"),
        ),
        migrations.AlterField(
            model_name="historicalequity",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Title (Representation)"),
        ),
        migrations.AlterField(
            model_name="historicalindex",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Title (Representation)"),
        ),
        migrations.AlterField(
            model_name="historicalinstrument",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Title (Representation)"),
        ),
        migrations.AlterField(
            model_name="historicalinterestratederivative",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Title (Representation)"),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Title (Representation)"),
        ),
        migrations.AlterField(
            model_name="historicalproductgroup",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Title (Representation)"),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="title_repr",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Title (Representation)"),
        ),
        migrations.AddIndex(
            model_name="instrumentprice",
            index=models.Index(fields=["date", "instrument"], name="instrument_price_idx"),
        ),
        migrations.AddField(
            model_name="historicalbond",
            name="old_isins",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=12),
                blank=True,
                default=list,
                help_text="When an instrument changes its isin, we store to help retreive it later",
                size=None,
                verbose_name="Old ISINS",
            ),
        ),
        migrations.AddField(
            model_name="historicalequity",
            name="old_isins",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=12),
                blank=True,
                default=list,
                help_text="When an instrument changes its isin, we store to help retreive it later",
                size=None,
                verbose_name="Old ISINS",
            ),
        ),
        migrations.AddField(
            model_name="historicalindex",
            name="old_isins",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=12),
                blank=True,
                default=list,
                help_text="When an instrument changes its isin, we store to help retreive it later",
                size=None,
                verbose_name="Old ISINS",
            ),
        ),
        migrations.AddField(
            model_name="historicalinstrument",
            name="old_isins",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=12),
                blank=True,
                default=list,
                help_text="When an instrument changes its isin, we store to help retreive it later",
                size=None,
                verbose_name="Old ISINS",
            ),
        ),
        migrations.AddField(
            model_name="historicalinterestratederivative",
            name="old_isins",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=12),
                blank=True,
                default=list,
                help_text="When an instrument changes its isin, we store to help retreive it later",
                size=None,
                verbose_name="Old ISINS",
            ),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="old_isins",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=12),
                blank=True,
                default=list,
                help_text="When an instrument changes its isin, we store to help retreive it later",
                size=None,
                verbose_name="Old ISINS",
            ),
        ),
        migrations.AddField(
            model_name="historicalproductgroup",
            name="old_isins",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=12),
                blank=True,
                default=list,
                help_text="When an instrument changes its isin, we store to help retreive it later",
                size=None,
                verbose_name="Old ISINS",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="old_isins",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=12),
                blank=True,
                default=list,
                help_text="When an instrument changes its isin, we store to help retreive it later",
                size=None,
                verbose_name="Old ISINS",
            ),
        ),
        migrations.RenameModel(
            old_name="portfoliosynchronization",
            new_name="portfoliosynchronizationold",
        ),
        migrations.RenameModel(
            old_name="pricecomputation",
            new_name="pricecomputationold",
        ),
        migrations.AlterModelTable(
            name="portfoliosynchronizationold",
            table="portfolio_portfoliosynchronizationold",
        ),
        migrations.AlterModelTable(
            name="pricecomputationold",
            table="portfolio_pricecomputationold",
        ),
        migrations.CreateModel(
            name="SynchronizationTask",
            fields=[
                (
                    "periodictask_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="django_celery_beat.periodictask",
                    ),
                ),
                ("import_path", models.CharField(default="", max_length=512, verbose_name="Import Path")),
                (
                    "dependent_task",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="dependency_tasks",
                        to="wbportfolio.synchronizationtask",
                    ),
                ),
            ],
            bases=("django_celery_beat.periodictask",),
        ),
        migrations.AddField(
            model_name="historicalportfolio",
            name="last_synchronization",
            field=models.DateTimeField(blank=True, null=True, verbose_name="Last Synchronization Date"),
        ),
        migrations.AddField(
            model_name="portfolio",
            name="last_synchronization",
            field=models.DateTimeField(blank=True, null=True, verbose_name="Last Synchronization Date"),
        ),
        migrations.CreateModel(
            name="PortfolioSynchronization",
            fields=[
                (
                    "synchronizationtask_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.synchronizationtask",
                    ),
                ),
                (
                    "is_automatic_validation",
                    models.BooleanField(
                        default=True,
                        help_text="Set to True if you want to automatically implement proposed positions",
                        verbose_name="Automatic validation",
                    ),
                ),
                (
                    "propagate_history",
                    models.BooleanField(
                        default=False,
                        help_text="If true, when the depends on portfolio changes at a certain date, this method will trigger a synchronization for each date (at the scheduled frequency) from that date to the latest valid date",
                        verbose_name="Propagate History",
                    ),
                ),
            ],
            bases=("wbportfolio.synchronizationtask",),
        ),
        migrations.CreateModel(
            name="PriceComputation",
            fields=[
                (
                    "synchronizationtask_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.synchronizationtask",
                    ),
                ),
            ],
            bases=("wbportfolio.synchronizationtask",),
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="price_computation",
        ),
        migrations.RemoveField(
            model_name="portfolio",
            name="portfolio_synchronization",
        ),
        migrations.AddField(
            model_name="instrument",
            name="price_computation",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="instruments",
                to="wbportfolio.pricecomputation",
                verbose_name="Price Computation Method",
            ),
        ),
        migrations.AddField(
            model_name="portfolio",
            name="portfolio_synchronization",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="portfolios",
                to="wbportfolio.portfoliosynchronization",
                verbose_name="Portfolio Synchronization Method",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbond",
            name="price_computation",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="wbportfolio.pricecomputation",
                verbose_name="Price Computation Method",
            ),
        ),
        migrations.RemoveField(
            model_name="historicalequity",
            name="price_computation",
        ),
        migrations.RemoveField(
            model_name="historicalindex",
            name="price_computation",
        ),
        migrations.RemoveField(
            model_name="historicalinstrument",
            name="price_computation",
        ),
        migrations.RemoveField(
            model_name="historicalinterestratederivative",
            name="price_computation",
        ),
        migrations.RemoveField(
            model_name="historicalportfolio",
            name="portfolio_synchronization",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="price_computation",
        ),
        migrations.RemoveField(
            model_name="historicalproductgroup",
            name="price_computation",
        ),
        migrations.AlterField(
            model_name="synchronizationtask",
            name="import_path",
            field=models.CharField(blank=True, default="", max_length=512, verbose_name="Import Path"),
        ),
        migrations.AlterField(
            model_name="portfolio",
            name="depends_on",
            field=models.ManyToManyField(
                blank=True,
                related_name="dependent_portfolios",
                through="wbportfolio.PortfolioPortfolioThroughModel",
                to="wbportfolio.portfolio",
                verbose_name="The portfolios this portfolio depends on",
            ),
        ),
        migrations.DeleteModel(
            name="portfoliosynchronizationold",
        ),
        migrations.DeleteModel(
            name="pricecomputationold",
        ),
        migrations.RemoveField(
            model_name="classification",
            name="level_code",
        ),
        migrations.AlterField(
            model_name="historicalproductgroup",
            name="category",
            field=models.CharField(
                choices=[("UCITS", "UCITS"), ("OTHER_FUNDS", "Other funds for traditional investments")],
                default="UCITS",
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="productgroup",
            name="category",
            field=models.CharField(
                choices=[("UCITS", "UCITS"), ("OTHER_FUNDS", "Other funds for traditional investments")],
                default="UCITS",
                max_length=64,
            ),
        ),
        migrations.DeleteModel(
            name="HistoricalBond",
        ),
        migrations.DeleteModel(
            name="HistoricalClassificationGroup",
        ),
        migrations.DeleteModel(
            name="HistoricalCustodian",
        ),
        migrations.DeleteModel(
            name="HistoricalEquity",
        ),
        migrations.DeleteModel(
            name="HistoricalExchange",
        ),
        migrations.DeleteModel(
            name="HistoricalIndex",
        ),
        migrations.DeleteModel(
            name="HistoricalInstrument",
        ),
        migrations.DeleteModel(
            name="HistoricalInterestRateDerivative",
        ),
        migrations.DeleteModel(
            name="HistoricalPortfolio",
        ),
        migrations.DeleteModel(
            name="HistoricalPortfolioRole",
        ),
        migrations.DeleteModel(
            name="HistoricalProduct",
        ),
        migrations.DeleteModel(
            name="HistoricalProductGroup",
        ),
        migrations.DeleteModel(
            name="HistoricalRegister",
        ),
        migrations.DeleteModel(
            name="HistoricalTransaction",
        ),
        migrations.AlterModelOptions(
            name="instrumentprice",
            options={"verbose_name": "Instrument Price", "verbose_name_plural": "Instrument Prices"},
        ),
        migrations.AddField(
            model_name="instrument",
            name="refinitiv_mnemonic_code",
            field=models.CharField(
                blank=True,
                help_text="Refinitiv Mnemonic Code",
                max_length=255,
                null=True,
                unique=True,
                verbose_name="Refinitiv Mnemonic Code",
            ),
        ),
        migrations.CreateModel(
            name="SplitData",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("split_date", models.DateField()),
                ("factor", models.FloatField(default=1.0)),
            ],
            options={
                "verbose_name": "Datum Split",
                "verbose_name_plural": "Data Split",
            },
        ),
        migrations.RemoveIndex(
            model_name="instrumentprice",
            name="instrument_price_idx",
        ),
        migrations.AddField(
            model_name="bond",
            name="bond_type",
            field=models.CharField(
                choices=[
                    ("BWT", "Bond With Warrant"),
                    ("CVT", "Convertible"),
                    ("IXL", "Index Linked"),
                    ("ZER", "Zero Coupon"),
                    ("FLO", "Floating Rate"),
                    ("STR", "Straight"),
                ],
                default="CVT",
                max_length=64,
            ),
        ),
        migrations.AddField(
            model_name="bond",
            name="borrower",
            field=models.CharField(default="", max_length=256),
        ),
        migrations.AddField(
            model_name="bond",
            name="issuer_type",
            field=models.CharField(
                choices=[
                    ("CORP", "Corporate"),
                    ("SOV", "Sovereign"),
                    ("SSOV", "Sub-Sovereign"),
                    ("FIN", "Financial Institution"),
                    ("AGCY", "Agency"),
                    ("SUPR", "Supranational"),
                ],
                default="SOV",
                max_length=64,
            ),
        ),
        migrations.AddField(
            model_name="bond",
            name="maturity_date",
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="bond",
            name="price_unit",
            field=models.CharField(
                choices=[
                    ("ACTUAL", "Actual"),
                    ("ACTUAL_PENCE", "Actual Pence"),
                    ("ACTUAL_POUNDS", "Actual Pounds"),
                    ("PERCENTAGE", "Percentage"),
                    ("PERCENTAGE_PENCE", "Percentage Pence"),
                    ("PERCENTAGE_POUNDS", "Percentage Pounds"),
                ],
                default="PERCENTAGE",
                max_length=64,
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_update",
            field=models.DateTimeField(auto_now=True, null=True),
        ),
        migrations.AddField(
            model_name="instrument",
            name="primary_field",
            field=models.CharField(default="net_value", max_length=64, verbose_name="Primary Field"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="bid_rate",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="high",
            field=models.DecimalField(blank=True, decimal_places=6, max_digits=16, null=True, verbose_name="high"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="interest_rate",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="low",
            field=models.DecimalField(blank=True, decimal_places=6, max_digits=16, null=True, verbose_name="Low"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="net_return",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="offered_rate",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="price_index",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="total_return_index",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="yield_redemption",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="ask",
            field=models.DecimalField(blank=True, decimal_places=6, max_digits=16, null=True, verbose_name="Ask"),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="bid",
            field=models.DecimalField(blank=True, decimal_places=6, max_digits=16, null=True, verbose_name="Bid"),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="market_capitalization",
            field=models.FloatField(
                blank=True,
                help_text="The Market Capitalization of the Asset the price date of the Asset. (Only Equities)",
                null=True,
                verbose_name="Market Capitalization",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="open",
            field=models.DecimalField(blank=True, decimal_places=6, max_digits=16, null=True, verbose_name="Open"),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="volume",
            field=models.FloatField(
                blank=True,
                help_text="The Volume of the Asset on the price date of the Asset.",
                null=True,
                verbose_name="Volume",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="volume_200d",
            field=models.FloatField(
                blank=True,
                help_text="The Average Volume of the Asset over the last 200 days from the price date of the Asset.",
                null=True,
                verbose_name="Average Volume (200 Days)",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="volume_50d",
            field=models.FloatField(
                blank=True,
                help_text="The Average Volume of the Asset over the last 50 days from the price date of the Asset.",
                null=True,
                verbose_name="Average Volume (50 Days)",
            ),
        ),
        migrations.AddIndex(
            model_name="instrumentprice",
            index=models.Index(fields=["calculated", "date", "instrument"], name="instrument_price_idx"),
        ),
        migrations.RenameField(
            model_name="splitdata",
            old_name="split_date",
            new_name="date",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="offered_rate",
        ),
        migrations.AddField(
            model_name="instrument",
            name="refinitiv_ticker",
            field=models.CharField(
                blank=True,
                help_text="Refinitiv Refinitiv",
                max_length=255,
                null=True,
                unique=True,
                verbose_name="Refinitiv Ticker",
            ),
        ),
        migrations.CreateModel(
            name="IncomeStatement",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date", models.DateField()),
                ("revenue", models.FloatField(blank=True, null=True, verbose_name="Net Sales or Revenues")),
                ("cost_of_revenue", models.FloatField(blank=True, null=True, verbose_name="Cost Of Goods Sold/Sales")),
                ("gross_profit_margin", models.FloatField(blank=True, null=True, verbose_name="Gross profit Margin")),
                (
                    "operating_expenses",
                    models.FloatField(blank=True, null=True, verbose_name="Total Operating Expense"),
                ),
                (
                    "general_expenses",
                    models.FloatField(
                        blank=True, null=True, verbose_name="Selling, General & Administrative Expenses"
                    ),
                ),
                (
                    "salaries_expenses",
                    models.FloatField(blank=True, null=True, verbose_name="Salaries And Benefits Expenses"),
                ),
                ("rd_expenses", models.FloatField(blank=True, null=True, verbose_name="Research & Development")),
                (
                    "depreciation_amortization_expenses",
                    models.FloatField(blank=True, null=True, verbose_name="Depreciation, Depletion And Amortization"),
                ),
                ("interest_expenses", models.FloatField(blank=True, null=True, verbose_name="Interest Expense Total")),
                ("unusual_expense", models.FloatField(blank=True, null=True, verbose_name="Unusual Expense (Income)")),
                (
                    "other_expenses",
                    models.FloatField(blank=True, null=True, verbose_name="Other Operating Expenses, Total"),
                ),
                ("operating_income", models.FloatField(blank=True, null=True, verbose_name="Operating Income")),
                ("interest_income", models.FloatField(blank=True, null=True, verbose_name="Interest Income Total")),
                (
                    "gain_loss_sale_assets",
                    models.FloatField(blank=True, null=True, verbose_name="Gains/Loss On Sale Of Assets"),
                ),
                (
                    "gain_loss_disposable_assets",
                    models.FloatField(blank=True, null=True, verbose_name="Gains/Loss On Disposal Of Assets"),
                ),
                (
                    "gain_loss_sale_pretax",
                    models.FloatField(blank=True, null=True, verbose_name="Gains/Losses On Sale Of Securities Pretax"),
                ),
                (
                    "net_income_after_before",
                    models.FloatField(blank=True, null=True, verbose_name="Net Income Before Taxes"),
                ),
                ("income_taxes", models.FloatField(blank=True, null=True, verbose_name="Provision for Income Taxes")),
                ("minority_interest", models.FloatField(blank=True, null=True, verbose_name="Minority Interest")),
                (
                    "net_income_before_extra_items",
                    models.FloatField(blank=True, null=True, verbose_name="Net Income Before Extraordinary Items"),
                ),
                (
                    "extraordinary_items",
                    models.FloatField(blank=True, null=True, verbose_name="Total Extraordinary Items"),
                ),
                ("net_income", models.FloatField(blank=True, null=True, verbose_name="Net Income")),
                (
                    "net_income_common",
                    models.FloatField(blank=True, null=True, verbose_name="Net Income Available To Common"),
                ),
                ("net_income_diluted", models.FloatField(blank=True, null=True, verbose_name="Diluted Net Income")),
                (
                    "common_shares_diluted",
                    models.FloatField(
                        blank=True, null=True, verbose_name="Common Shares Used To Calculate Fully Diluted EPS"
                    ),
                ),
                (
                    "diluted_eps_before_extra_items",
                    models.FloatField(blank=True, null=True, verbose_name="Diluted EPS Excluding Extraordinary Items"),
                ),
                (
                    "dividends_per_share",
                    models.FloatField(blank=True, null=True, verbose_name="DPS - Common Stock Primary Issue"),
                ),
                ("diluted_eps", models.FloatField(blank=True, null=True, verbose_name="Diluted Normalized EP")),
                (
                    "equity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="income_statements",
                        to="wbportfolio.equity",
                    ),
                ),
            ],
            options={
                "verbose_name": "Income Statement",
                "verbose_name_plural": "Income Statements",
            },
        ),
        migrations.CreateModel(
            name="Estimate",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date", models.DateField()),
                (
                    "equity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="estimates", to="wbportfolio.equity"
                    ),
                ),
            ],
            options={
                "verbose_name": "Estimate",
                "verbose_name_plural": "Estimates",
            },
        ),
        migrations.CreateModel(
            name="CashFlow",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date", models.DateField()),
                (
                    "equity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="cash_flows", to="wbportfolio.equity"
                    ),
                ),
            ],
            options={
                "verbose_name": "Cash Flow",
                "verbose_name_plural": "Cash Flows",
            },
        ),
        migrations.CreateModel(
            name="BalanceSheet",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date", models.DateField()),
                (
                    "equity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="balance_sheets",
                        to="wbportfolio.equity",
                    ),
                ),
            ],
            options={
                "verbose_name": "Cash Flow",
                "verbose_name_plural": "Cash Flows",
            },
        ),
        migrations.AddIndex(
            model_name="incomestatement",
            index=models.Index(fields=["equity", "-date"], name="equity_income_statement_idx"),
        ),
        migrations.AddIndex(
            model_name="estimate",
            index=models.Index(fields=["equity", "-date"], name="index_estimate_idx"),
        ),
        migrations.AddIndex(
            model_name="cashflow",
            index=models.Index(fields=["equity", "-date"], name="equity_cash_flow_idx"),
        ),
        migrations.AddIndex(
            model_name="balancesheet",
            index=models.Index(fields=["equity", "-date"], name="index_balance_sheet_idx"),
        ),
        migrations.CreateModel(
            name="ETF",
            fields=[
                (
                    "instrument_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.instrument",
                    ),
                ),
            ],
            options={
                "verbose_name": "ETF",
                "verbose_name_plural": "ETFs",
            },
            bases=("wbportfolio.instrument",),
        ),
        migrations.CreateModel(
            name="Future",
            fields=[
                (
                    "instrument_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.instrument",
                    ),
                ),
                ("contracts", models.IntegerField(blank=True, null=True)),
            ],
            options={
                "verbose_name": "Future",
                "verbose_name_plural": "Futures",
            },
            bases=("wbportfolio.instrument",),
        ),
        migrations.AddField(
            model_name="bond",
            name="credit_rating",
            field=models.CharField(default="", max_length=256),
        ),
        migrations.AddField(
            model_name="instrument",
            name="closing_date",
            field=models.DateField(
                blank=True, help_text="The instrument closing date", null=True, verbose_name="Closing Date"
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="sedol",
            field=models.CharField(
                blank=True,
                help_text="Stock Exchange Daily Official List",
                max_length=255,
                null=True,
                unique=True,
                verbose_name="SEDOL",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="valoren",
            field=models.CharField(
                blank=True,
                help_text="Valoren Number",
                max_length=255,
                null=True,
                unique=True,
                verbose_name="Valoren Number",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="instrument_type",
            field=models.CharField(
                blank=True,
                choices=[
                    ("Product", "Product"),
                    ("Index", "Index"),
                    ("ProductGroup", "Product Group"),
                    ("Equity", "Equity"),
                    ("ETF", "ETF"),
                    ("Cash", "Cash"),
                    ("Option", "Option"),
                    ("Right", "Right"),
                    ("Bond", "Bond"),
                    ("InterestRateDerivative", "Interest Rate Derivate"),
                    ("Future", "Future"),
                    ("Forward", "Forward"),
                    ("Swap", "Swap"),
                    ("Coupon", "Coupon"),
                    ("Crypto", "Crypto"),
                    ("Commodity", "Commodity"),
                ],
                max_length=255,
                null=True,
                verbose_name="Type",
            ),
        ),
        migrations.CreateModel(
            name="Option",
            fields=[
                (
                    "instrument_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.instrument",
                    ),
                ),
                ("expiry_date", models.DateField(verbose_name="Expiry Date")),
                (
                    "option_type",
                    models.CharField(choices=[("CALL", "Call"), ("PUT", "Put")], default="CALL", max_length=126),
                ),
                (
                    "exercise_style",
                    models.CharField(
                        choices=[("AMERICAN", "American"), ("EUROPEAN", "European")],
                        default="EUROPEAN",
                        max_length=126,
                    ),
                ),
                ("size_of_contract", models.FloatField(verbose_name="Size of Contract")),
                ("strike", models.DecimalField(decimal_places=4, max_digits=16, verbose_name="Strike Price")),
                (
                    "underlying",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="options",
                        to="wbportfolio.instrument",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("wbportfolio.instrument",),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="market_capitalization_consolidated",
            field=models.FloatField(
                blank=True,
                help_text="The Market Capitalization consolidated across exchanges",
                null=True,
                verbose_name="Market Capitalization Consolidated",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="price_earning",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="offered_rate",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="bond",
            name="coupon_type",
            field=models.CharField(blank=True, max_length=64, null=True),
        ),
        migrations.AddField(
            model_name="dividend",
            name="retrocession",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.CreateModel(
            name="DividendTransaction",
            fields=[
                (
                    "transaction_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.transaction",
                    ),
                ),
                (
                    "shares",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The number of shares that were traded.",
                        max_digits=15,
                        null=True,
                        verbose_name="Shares",
                    ),
                ),
                (
                    "price",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The price per share.",
                        max_digits=16,
                        null=True,
                        verbose_name="Price",
                    ),
                ),
                (
                    "price_gross",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The gross price per share.",
                        max_digits=16,
                        null=True,
                        verbose_name="Gross Price",
                    ),
                ),
                ("retrocession", models.FloatField(default=1)),
            ],
            options={
                "abstract": False,
            },
            bases=("wbportfolio.transaction", models.Model),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="transaction_type",
            field=models.CharField(
                choices=[
                    ("Trade", "Trade"),
                    ("DividendTransaction", "Dividend Transaction"),
                    ("Expiry", "Expiry"),
                    ("Fees", "Fees"),
                ],
                default="Trade",
                max_length=255,
                verbose_name="Type",
            ),
        ),
        migrations.DeleteModel(
            name="Dividend",
        ),
        migrations.AlterField(
            model_name="exchange",
            name="mic_code",
            field=models.CharField(
                blank=True,
                help_text="Market Identifier Code.",
                max_length=4,
                null=True,
                unique=True,
                verbose_name="MIC (ISO)",
            ),
        ),
        migrations.CreateModel(
            name="Theme",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=255, unique=True)),
                ("color", models.CharField(default="#000000", max_length=7)),
                ("icon", models.ImageField(blank=True, null=True, upload_to="wbportfolio/")),
                (
                    "classification",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="wbportfolio.classification",
                    ),
                ),
                (
                    "model_portfolio",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="model_portfolio_of_themes",
                        to="wbportfolio.portfolio",
                    ),
                ),
                ("products", models.ManyToManyField(blank=True, related_name="themes", to="wbportfolio.product")),
                (
                    "peers",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="peer_of_themes",
                        to="wbportfolio.portfolio",
                    ),
                ),
            ],
            options={
                "verbose_name": "Theme",
                "verbose_name_plural": "Themes",
            },
        ),
        migrations.AlterField(
            model_name="instrument",
            name="instrument_type",
            field=models.CharField(
                blank=True,
                choices=[
                    ("Product", "Product"),
                    ("Index", "Index"),
                    ("ProductGroup", "Product Group"),
                    ("Equity", "Equity"),
                    ("ETF", "ETF"),
                    ("ETP", "ETP"),
                    ("Cash", "Cash"),
                    ("Option", "Option"),
                    ("Right", "Right"),
                    ("Bond", "Bond"),
                    ("InterestRateDerivative", "Interest Rate Derivate"),
                    ("Future", "Future"),
                    ("Forward", "Forward"),
                    ("Swap", "Swap"),
                    ("Coupon", "Coupon"),
                    ("Crypto", "Crypto"),
                    ("Commodity", "Commodity"),
                ],
                max_length=255,
                null=True,
                verbose_name="Type",
            ),
        ),
        migrations.CreateModel(
            name="ETP",
            fields=[
                (
                    "instrument_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.instrument",
                    ),
                ),
            ],
            options={
                "verbose_name": "ETP",
                "verbose_name_plural": "ETPs",
            },
            bases=("wbportfolio.instrument",),
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="external_price_field_name",
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="outstanding_shares",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The amount of outstanding share for this instrument",
                max_digits=14,
                null=True,
                verbose_name="Outstanding Shares",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="close",
            field=models.DecimalField(blank=True, decimal_places=6, max_digits=16, null=True, verbose_name="Close"),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="primary_field",
            field=models.CharField(default="close", max_length=64, verbose_name="Primary Field"),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="net_value",
            field=models.DecimalField(decimal_places=6, default=0, max_digits=16, verbose_name="Value (Net)"),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="transaction",
            name="total_value",
            field=models.DecimalField(
                blank=True, decimal_places=4, max_digits=20, null=True, verbose_name="Total Value"
            ),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="total_value_fx_portfolio",
            field=models.DecimalField(
                blank=True, decimal_places=4, max_digits=20, null=True, verbose_name="Total Value Fx Portfolio"
            ),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="total_value_gross",
            field=models.DecimalField(
                blank=True, decimal_places=4, max_digits=20, null=True, verbose_name="Total Value Gross"
            ),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="total_value_gross_fx_portfolio",
            field=models.DecimalField(
                blank=True, decimal_places=4, max_digits=20, null=True, verbose_name="Total Value Gross Fx Portfolio"
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_valuation_date",
            field=models.DateField(
                blank=True, help_text="Last Valuation Date", null=True, verbose_name="Last Valuation Date"
            ),
        ),
        migrations.CreateModel(
            name="AssetAllocationType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=255)),
                (
                    "default_max_investment",
                    models.DecimalField(
                        decimal_places=4,
                        default=0.1,
                        help_text="The default percentage this allocation is counted towards the potential.",
                        max_digits=5,
                    ),
                ),
            ],
            options={
                "verbose_name": "Asset Allocation Type",
                "verbose_name_plural": "Asset Allocation Types",
            },
        ),
        migrations.CreateModel(
            name="GeographicFocus",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("percent", models.DecimalField(decimal_places=4, max_digits=5)),
                ("comment", models.TextField(default="")),
            ],
            options={
                "verbose_name": "Geographic Focus",
                "verbose_name_plural": "Geographic Focuses",
            },
        ),
        migrations.CreateModel(
            name="AssetAllocation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("percent", models.DecimalField(decimal_places=4, max_digits=5)),
                (
                    "max_investment",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The percentage this allocation is counted towards the potential. Defaults to the default provided in the asset type.",
                        max_digits=5,
                        null=True,
                    ),
                ),
                ("comment", models.TextField(default="")),
                (
                    "asset_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="asset_allocations",
                        to="wbportfolio.assetallocationtype",
                    ),
                ),
            ],
            options={
                "verbose_name": "Asset Allocation",
                "verbose_name_plural": "Asset Allocations",
            },
        ),
        migrations.CreateModel(
            name="CompanyPortfolioData",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "assets_under_management",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="The Assets under Management (AUM) that is managed by this company.",
                        max_digits=17,
                        null=True,
                        verbose_name="AUM",
                    ),
                ),
                (
                    "invested_assets_under_management_usd",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="The invested Assets under Management (AUM).",
                        max_digits=17,
                        null=True,
                        verbose_name="Invested AUM ($)",
                    ),
                ),
                (
                    "investment_discretion",
                    models.CharField(
                        choices=[
                            ("FULLY_DISCRETIONAIRY", "Fully Discretionairy"),
                            ("MOSTLY_DISCRETIONAIRY", "Mostly Discretionairy"),
                            ("MIXED", "Mixed"),
                            ("MOSTLY_ADVISORY", "Mostly Advisory"),
                            ("FULLY_ADVISORY", "Fully Advisory"),
                        ],
                        default="MIXED",
                        help_text="What discretion this company has to invest its assets.",
                        max_length=21,
                        verbose_name="Investment Discretion",
                    ),
                ),
                (
                    "potential",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="\n        The potential reflects how much potential a company (regardless whether client/propective) has. The formula to calculate the potential is:\n\n        AUM * Asset Allocation Percent * Asset Allocation Max Investment - Invested AUM.\n    ",
                        max_digits=19,
                        null=True,
                    ),
                ),
            ],
            options={
                "verbose_name": "Company Portfolio Data",
                "verbose_name_plural": "Company Portfolio Data",
            },
        ),
        migrations.AddField(
            model_name="product",
            name="termsheet",
            field=models.FileField(blank=True, null=True, upload_to="wbportfolio/"),
        ),
        migrations.CreateModel(
            name="AddressableMarket",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("year", models.PositiveIntegerField(blank=True, null=True)),
                ("value_usd", models.DecimalField(blank=True, decimal_places=2, max_digits=19, null=True)),
                ("comment", models.TextField(blank=True, default="")),
                (
                    "classification",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="addressable_markets",
                        to="wbportfolio.classification",
                    ),
                ),
            ],
            options={
                "verbose_name": "Total Addressable Market",
                "verbose_name_plural": "Total Addressable Market",
            },
        ),
        migrations.AlterField(
            model_name="companyportfoliodata",
            name="assets_under_management",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                help_text="The Assets under Management (AUM) that is managed by this company or this person's primary employer.",
                max_digits=17,
                null=True,
                verbose_name="AUM",
            ),
        ),
        migrations.AlterField(
            model_name="companyportfoliodata",
            name="investment_discretion",
            field=models.CharField(
                choices=[
                    ("FULLY_DISCRETIONAIRY", "Fully Discretionairy"),
                    ("MOSTLY_DISCRETIONAIRY", "Mostly Discretionairy"),
                    ("MIXED", "Mixed"),
                    ("MOSTLY_ADVISORY", "Mostly Advisory"),
                    ("FULLY_ADVISORY", "Fully Advisory"),
                ],
                default="MIXED",
                help_text="What discretion this company or this person's primary employer has to invest its assets.",
                max_length=21,
                verbose_name="Investment Discretion",
            ),
        ),
        migrations.CreateModel(
            name="DailyFundamental",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date", models.DateField()),
                (
                    "eps",
                    models.FloatField(
                        blank=True, help_text="Historical Earnings per share", null=True, verbose_name="EPS"
                    ),
                ),
                (
                    "eps_ttm",
                    models.FloatField(
                        blank=True, help_text="Trailing Twelve Month EPS", null=True, verbose_name="EPS TTM"
                    ),
                ),
                (
                    "free_cash_flow",
                    models.FloatField(
                        blank=True, help_text="Historical Free Cash Flow", null=True, verbose_name="FCFs"
                    ),
                ),
                (
                    "free_cash_flow_growth",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True, help_text="Current Free Cash Flow Growth", null=True, verbose_name="FCFs Growth"
                    ),
                ),
                (
                    "free_cash_flow_5y_cagr",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="5-year Cumulative Annual Growth Rate of FCFs %",
                        null=True,
                        verbose_name="Latest 5Y FCFs CAGR",
                    ),
                ),
            ],
            options={
                "verbose_name": "Fundamental: Daily",
                "verbose_name_plural": "Fundamental: Daily",
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="FiscalQuarterPeriod",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "fiscal_quarter",
                    models.PositiveIntegerField(choices=[(0, "Yearly"), (1, "Q1"), (2, "Q2"), (3, "Q3"), (4, "Q4")]),
                ),
                ("fiscal_year", models.PositiveIntegerField()),
                ("fiscal_quarter_end_date", models.DateField(help_text="The Fiscal Quarter end date")),
                ("fiscal_year_end_date", models.DateField(help_text="The Fiscal Year end date")),
                (
                    "company_expected_report_date",
                    models.DateField(
                        blank=True, help_text="The expected report date announced by the company", null=True
                    ),
                ),
                (
                    "expected_report_date",
                    models.DateField(
                        blank=True, help_text="The expected report date announced by the company", null=True
                    ),
                ),
            ],
            options={
                "verbose_name": "Fundamental: Fiscal Period",
                "verbose_name_plural": "Fundamental: Fiscal Periods",
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Forecast",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date", models.DateField()),
                (
                    "net_debt_y0",
                    models.FloatField(
                        blank=True,
                        help_text="Expected Net Debt current fiscal year",
                        null=True,
                        verbose_name="Expected Net Debt current fiscal year",
                    ),
                ),
                (
                    "net_debt_y1",
                    models.FloatField(
                        blank=True,
                        help_text="Expected Net Debt current year 1",
                        null=True,
                        verbose_name="Expected Net Debt current year 1",
                    ),
                ),
                (
                    "net_debt_y2",
                    models.FloatField(
                        blank=True,
                        help_text="Expected Net Debt current year 2",
                        null=True,
                        verbose_name="Expected Net Debt current year 2",
                    ),
                ),
                (
                    "net_debt_y3",
                    models.FloatField(
                        blank=True,
                        help_text="Expected Net Debt current year 3",
                        null=True,
                        verbose_name="Expected Net Debt current year 3",
                    ),
                ),
                (
                    "net_debt_y4",
                    models.FloatField(
                        blank=True,
                        help_text="Expected Net Debt current year 4",
                        null=True,
                        verbose_name="Expected Net Debt current year 4",
                    ),
                ),
                (
                    "entreprise_value_y0",
                    models.FloatField(
                        blank=True,
                        help_text="Expected Entreprise Value current fiscal year",
                        null=True,
                        verbose_name="Expected Entreprise Value current fiscal year",
                    ),
                ),
                (
                    "entreprise_value_y1",
                    models.FloatField(
                        blank=True,
                        help_text="Expected Entreprise Value fiscal year +1",
                        null=True,
                        verbose_name="Expected Entreprise Value fiscal year +1",
                    ),
                ),
                (
                    "entreprise_value_y2",
                    models.FloatField(
                        blank=True,
                        help_text="Expected Entreprise Value fiscal year +2",
                        null=True,
                        verbose_name="Expected Entreprise Value fiscal year +2",
                    ),
                ),
                (
                    "entreprise_value_y3",
                    models.FloatField(
                        blank=True,
                        help_text="Expected Entreprise Value fiscal year +3",
                        null=True,
                        verbose_name="Expected Entreprise Value fiscal year +3",
                    ),
                ),
                (
                    "entreprise_value_y4",
                    models.FloatField(
                        blank=True,
                        help_text="Expected Entreprise Value fiscal year +4",
                        null=True,
                        verbose_name="Expected Entreprise Value fiscal year +4",
                    ),
                ),
                (
                    "free_cash_flow_y0",
                    models.FloatField(
                        blank=True,
                        help_text="Expected FCFs current fiscal year",
                        null=True,
                        verbose_name="Expected FCFs current fiscal year",
                    ),
                ),
                (
                    "free_cash_flow_y1",
                    models.FloatField(
                        blank=True,
                        help_text="Expected FCFs fiscal year +1",
                        null=True,
                        verbose_name="Expected FCFs fiscal year +1",
                    ),
                ),
                (
                    "free_cash_flow_y2",
                    models.FloatField(
                        blank=True,
                        help_text="Expected FCFs fiscal year +2",
                        null=True,
                        verbose_name="Expected FCFs fiscal year +2",
                    ),
                ),
                (
                    "free_cash_flow_y3",
                    models.FloatField(
                        blank=True,
                        help_text="Expected FCFs fiscal year +3",
                        null=True,
                        verbose_name="Expected FCFs fiscal year +3",
                    ),
                ),
                (
                    "free_cash_flow_y4",
                    models.FloatField(
                        blank=True,
                        help_text="Expected FCFs fiscal year +4",
                        null=True,
                        verbose_name="Expected FCFs fiscal year +4",
                    ),
                ),
            ],
            options={
                "verbose_name": "Fundamental: Forecast",
                "verbose_name_plural": "Fundamental: Forecasts",
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Fundamental",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date_range", django.contrib.postgres.fields.ranges.DateRangeField()),
                (
                    "fiscal_quarter",
                    models.PositiveIntegerField(
                        blank=True, choices=[(0, "Yearly"), (1, "Q1"), (2, "Q2"), (3, "Q3"), (4, "Q4")], null=True
                    ),
                ),
                ("fiscal_year", models.PositiveIntegerField()),
                ("revenue", models.FloatField(blank=True, null=True, verbose_name="Net Sales or Revenues")),
                (
                    "revenue_growth",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Year over year revenue growth (historical and estimated)",
                        null=True,
                        verbose_name="Revenue Growth (%)",
                    ),
                ),
                (
                    "revenue_growth_5y_cagr",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="5-year Cumulative Annual Growth Rate of revenue %",
                        null=True,
                        verbose_name="5Y Revenue Growth CAGR",
                    ),
                ),
                (
                    "cost_of_good_sold",
                    models.FloatField(
                        blank=True,
                        help_text="Cost of Goods Sold (excluding Depreciation and Amortization)",
                        null=True,
                        verbose_name="COGS (ex D&A)",
                    ),
                ),
                (
                    "gross_profit",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True, help_text="Historical Gross profit", null=True, verbose_name="Gross profit"
                    ),
                ),
                (
                    "gross_profit_margin",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Historical Gross profit Margin",
                        null=True,
                        verbose_name="Gross profit Margin (%)",
                    ),
                ),
                (
                    "ebitda",
                    models.FloatField(
                        blank=True,
                        help_text="Historical Earnings Before Interest, Taxes & Depreciation",
                        null=True,
                        verbose_name="EBITDA",
                    ),
                ),
                (
                    "ebitda_margin",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True, help_text="EBITDA Margin", null=True, verbose_name="EBITDA Margin (%)"
                    ),
                ),
                (
                    "ebit",
                    models.FloatField(
                        blank=True,
                        help_text="HHistorical Earnings Before Interest, Taxes & Depreciation",
                        null=True,
                        verbose_name="EBIT",
                    ),
                ),
                (
                    "ebit_margin",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True, help_text="EBIT Margin", null=True, verbose_name="EBIT Margin (%)"
                    ),
                ),
                (
                    "net_profit",
                    models.FloatField(
                        blank=True, help_text="Historical Earnings", null=True, verbose_name="Net Profit"
                    ),
                ),
                (
                    "net_profit_margin",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Historical Earnings margin",
                        null=True,
                        verbose_name="Net Profit Margin (%)",
                    ),
                ),
                (
                    "company_tax_rate",
                    models.FloatField(
                        blank=True, help_text="Company Tax Rate %", null=True, verbose_name="Company Tax Rate %"
                    ),
                ),
                (
                    "cost_research_development",
                    models.FloatField(
                        blank=True, help_text="Cost of Research & Development", null=True, verbose_name="R&D Cost"
                    ),
                ),
                (
                    "interest_expense",
                    models.FloatField(
                        blank=True, help_text="Total Interest Payment", null=True, verbose_name="Interest expense"
                    ),
                ),
                (
                    "sga",
                    models.FloatField(
                        blank=True,
                        help_text="Selling, General & Administrative Expenses",
                        null=True,
                        verbose_name="SG&A",
                    ),
                ),
                (
                    "cash_from_operation",
                    models.FloatField(blank=True, help_text="Working Capital", null=True, verbose_name="WC"),
                ),
                (
                    "working_capital",
                    models.FloatField(
                        blank=True, help_text="Working Capital", null=True, verbose_name="Working Capital"
                    ),
                ),
                (
                    "capital_expenditures",
                    models.FloatField(
                        blank=True, help_text="Capital Expenditures", null=True, verbose_name="Capital Expenditures"
                    ),
                ),
                (
                    "investment_cash",
                    models.FloatField(
                        blank=True, help_text="Cash From Investments", null=True, verbose_name="Cash From Investments"
                    ),
                ),
                (
                    "financing_cash",
                    models.FloatField(
                        blank=True, help_text="Cash From Financing", null=True, verbose_name="Cash From Financing"
                    ),
                ),
                (
                    "shareholder_equity",
                    models.FloatField(
                        blank=True, help_text="Historical Equity", null=True, verbose_name="Shareholder Equities"
                    ),
                ),
                (
                    "total_assets",
                    models.FloatField(
                        blank=True, help_text="Historical Assets", null=True, verbose_name="Total Assets"
                    ),
                ),
                (
                    "current_liabilities",
                    models.FloatField(
                        blank=True, help_text="Current Liabilities", null=True, verbose_name="Current Liabilities"
                    ),
                ),
                (
                    "total_debt",
                    models.FloatField(blank=True, help_text="Total Debt", null=True, verbose_name="Total Debt"),
                ),
                (
                    "cash_equivalents",
                    models.FloatField(
                        blank=True, help_text="Cash & Equivalents", null=True, verbose_name="Cash & Equivalents"
                    ),
                ),
                ("net_debt", models.FloatField(blank=True, help_text="Net Debt", null=True, verbose_name="Net Debt")),
                (
                    "cash_st_investments",
                    models.FloatField(
                        blank=True,
                        help_text="Cash & Short Term Investments",
                        null=True,
                        verbose_name="Cash & ST Investments",
                    ),
                ),
                (
                    "net_change_in_cash",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True, help_text="Net Change in Cash", null=True, verbose_name="Net Change in Cash"
                    ),
                ),
                (
                    "receivables",
                    models.FloatField(
                        blank=True, help_text="Accounts Receivables", null=True, verbose_name="Receivables"
                    ),
                ),
                (
                    "inventories",
                    models.FloatField(blank=True, help_text="Inventories", null=True, verbose_name="Inventory"),
                ),
                (
                    "payables",
                    models.FloatField(blank=True, help_text="Accounts Payable", null=True, verbose_name="Payables"),
                ),
                (
                    "book_value_per_share",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True, help_text="Book Value per share", null=True, verbose_name="Book Value per Share"
                    ),
                ),
                (
                    "current_assets",
                    models.FloatField(
                        blank=True, help_text="Current Assets", null=True, verbose_name="Current Assets"
                    ),
                ),
                (
                    "employee_count",
                    models.FloatField(
                        blank=True, help_text="Employee Count", null=True, verbose_name="Employees Count"
                    ),
                ),
                (
                    "employee_count_growth",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True, help_text="Employee Count Growth", null=True, verbose_name="Employees Count Growth"
                    ),
                ),
                (
                    "entreprise_value",
                    models.FloatField(
                        blank=True, help_text="Enterprise Value", null=True, verbose_name="Enterprise Value"
                    ),
                ),
                (
                    "free_cash",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True, help_text="Free Cash", null=True, verbose_name="Free Cash"
                    ),
                ),
                (
                    "net_debt_to_EBITDA_ratio",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="a debt ratio that shows how many years it would take for a company to pay back its debt if net debt and EBITDA are held constant",
                        null=True,
                        verbose_name="debt-to-EBITDA ratio",
                    ),
                ),
                (
                    "burn_rate",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Burn rate (Total Cash change/12 months)",
                        null=True,
                        verbose_name="Burn Rate",
                    ),
                ),
                (
                    "operating_burn_rate",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Operating burn rate (CFO /12 months)",
                        null=True,
                        verbose_name="Operating Burn rate",
                    ),
                ),
                (
                    "free_cash_burn_rate",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Free cash burn rate (FCF/12 months)",
                        null=True,
                        verbose_name="Free cash burn rate",
                    ),
                ),
                (
                    "cash_reserve_to_burn_rate_ratio",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Time before cash runs out (Cash reserves/Burn rate)",
                        null=True,
                        verbose_name="Cash Reserve to Burn Rate Ratio",
                    ),
                ),
                (
                    "cash_reserve_to_operating_burn_rate_ratio",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Time before cash runs out (Cash reserves/ Operating burn)",
                        null=True,
                        verbose_name="Cash Reserve to Operating Burn Rate Ratio",
                    ),
                ),
                (
                    "cash_reserve_to_free_cash_burn_rate_ratio",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Time before cash runs out (Cash reserves/ FCF burn)",
                        null=True,
                        verbose_name="Cash Reserve to Free Cash Burn Rate Ratio",
                    ),
                ),
                (
                    "working_capital_to_burn_rate_ratio",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Working capital sustainability (WC / Burn rate)",
                        null=True,
                        verbose_name="Working Capital to Burn Rate Ratio",
                    ),
                ),
                (
                    "working_capital_to_operating_burn_rate_ratio",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Working capital sustainability (WC / Operating Burn rate)",
                        null=True,
                        verbose_name="Working Capital to Operating Burn Rate Ratio",
                    ),
                ),
                (
                    "working_capital_to_free_cash_burn_rate_ratio",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Working capital sustainability (WC / FCF Burn rate)",
                        null=True,
                        verbose_name="Working Capital to Free Cash Burn Rate Ratio",
                    ),
                ),
                (
                    "current_ratio",
                    wbcore.models.fields.DynamicFloatField(blank=True, null=True, verbose_name="Current Ratio"),
                ),
                (
                    "cash_st_investments_to_current_assets_ratio",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Cash & Short Term Investments as a % of Current Assets",
                        null=True,
                        verbose_name="Cash & Short Investments to current assets ratio",
                    ),
                ),
                (
                    "rd_to_sales_ratio",
                    wbcore.models.fields.DynamicFloatField(blank=True, null=True, verbose_name="R&D to Sales ratio"),
                ),
                (
                    "interest_coverage_ratio",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Times Earnings Before Interest And Taxes pay interest",
                        null=True,
                        verbose_name="Interest Coverage Ratio",
                    ),
                ),
                (
                    "return_on_equity",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True, help_text="Return on Equity", null=True, verbose_name="ROE (%)"
                    ),
                ),
                (
                    "return_on_assets",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True, help_text="Return On Assets", null=True, verbose_name="ROA (%)"
                    ),
                ),
                (
                    "return_on_capital_employed",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True, help_text="Return on Capital Employed", null=True, verbose_name="ROCE (%)"
                    ),
                ),
                (
                    "return_on_invested_capital",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True, help_text="Return On Invested Capital", null=True, verbose_name="ROIC (%)"
                    ),
                ),
                (
                    "revenue_to_employee_ratio",
                    wbcore.models.fields.DynamicFloatField(
                        blank=True,
                        help_text="Company efficiency metric, revenue generated by employee",
                        null=True,
                        verbose_name="Revenue/Employee",
                    ),
                ),
            ],
            options={
                "verbose_name": "Fundamental",
                "verbose_name_plural": "Fundamental",
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="GeographicSegment",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date_range", django.contrib.postgres.fields.ranges.DateRangeField()),
                (
                    "fiscal_quarter",
                    models.PositiveIntegerField(
                        blank=True, choices=[(0, "Yearly"), (1, "Q1"), (2, "Q2"), (3, "Q3"), (4, "Q4")], null=True
                    ),
                ),
                ("fiscal_year", models.PositiveIntegerField()),
                ("level", models.PositiveIntegerField(default=1, verbose_name="Segment Level")),
                (
                    "field",
                    models.CharField(
                        choices=[("SALES", "Sales")], default="SALES", max_length=128, verbose_name="Segment Field"
                    ),
                ),
                ("description", models.TextField(default="", verbose_name="Segment Description")),
                ("value", models.FloatField(verbose_name="Segment Value")),
                (
                    "value_growth",
                    wbcore.models.fields.DynamicFloatField(blank=True, null=True, verbose_name="Segment Value Growth"),
                ),
            ],
            options={
                "verbose_name": "Fundamental: Geographic Segment",
                "verbose_name_plural": "Fundamental: Geographic Segments",
            },
            bases=(models.Model,),
        ),
        migrations.RemoveField(
            model_name="cashflow",
            name="equity",
        ),
        migrations.RemoveField(
            model_name="estimate",
            name="equity",
        ),
        migrations.RemoveField(
            model_name="incomestatement",
            name="equity",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="market_capitalization_consolidated",
        ),
        migrations.AddField(
            model_name="instrument",
            name="next_report_date",
            field=models.DateField(blank=True, null=True, verbose_name="Date of next quarterly report"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="currency_fx_usd",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="The Currency Exchange rate to convert this price to USD.",
                null=True,
                verbose_name="Currency FX Rate to USD",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="custom_beta_180d",
            field=wbcore.models.fields.DynamicFloatField(blank=True, null=True, verbose_name="Custom Beta (180 days)"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="custom_beta_1y",
            field=wbcore.models.fields.DynamicFloatField(blank=True, null=True, verbose_name="Custom Beta (1 Years)"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="custom_beta_2y",
            field=wbcore.models.fields.DynamicFloatField(blank=True, null=True, verbose_name="Custom Beta (2 Years)"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="custom_beta_3y",
            field=wbcore.models.fields.DynamicFloatField(blank=True, null=True, verbose_name="Custom Beta (3 Years)"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="custom_beta_5y",
            field=wbcore.models.fields.DynamicFloatField(blank=True, null=True, verbose_name="Custom Beta (4 Years)"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="dividend_yield",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="free_float",
            field=models.FloatField(
                blank=True, help_text="Free Float Number Of Shares", null=True, verbose_name="Free Float"
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="free_float_ratio",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Free float / Number of shares outstanding",
                null=True,
                verbose_name="Free Float Ratio",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="market_capitalization_usd",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="The Market Capitalization in dollard of the Asset the price date of the Asset.",
                null=True,
                verbose_name="Market Capitalization (USD)",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="net_value_usd",
            field=wbcore.models.fields.DynamicFloatField(blank=True, null=True, verbose_name="Value $ (Net)"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="short_interest",
            field=models.FloatField(blank=True, null=True, verbose_name="Short Interest"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="short_interest_ratio",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Short Interest / Number of shares outstanding",
                null=True,
                verbose_name="Short Interest Ratio",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="volume_50d_usd",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="The Average Volume of the Asset over the last 50 days from the USD price date of the Asset.",
                null=True,
                verbose_name="Average Volume USD (50 Days)",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="volume_usd",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="The Volume of the Asset on the usd price date of the Asset.",
                null=True,
                verbose_name="Volume USD",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="gross_value",
            field=wbcore.models.fields.DynamicDecimalField(
                blank=True, decimal_places=6, max_digits=16, null=True, verbose_name="Value (Gross)"
            ),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="market_capitalization",
            field=models.FloatField(
                blank=True,
                help_text="The Market Capitalization of the Asset the price date of the Asset.",
                null=True,
                verbose_name="Market Capitalization",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="outstanding_shares",
            field=wbcore.models.fields.DynamicDecimalField(
                blank=True,
                decimal_places=4,
                help_text="The amount of outstanding share for this instrument",
                max_digits=14,
                null=True,
                verbose_name="Outstanding Shares",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="volume_200d",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="The Average Volume of the Asset over the last 200 days from the price date of the Asset.",
                null=True,
                verbose_name="Average Volume (200 Days)",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="volume_50d",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="The Average Volume of the Asset over the last 50 days from the price date of the Asset.",
                null=True,
                verbose_name="Average Volume (50 Days)",
            ),
        ),
        migrations.DeleteModel(
            name="BalanceSheet",
        ),
        migrations.DeleteModel(
            name="CashFlow",
        ),
        migrations.DeleteModel(
            name="Estimate",
        ),
        migrations.DeleteModel(
            name="IncomeStatement",
        ),
        migrations.AddField(
            model_name="geographicsegment",
            name="instrument",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="geographic_segments",
                to="wbportfolio.instrument",
            ),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="instrument",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="fundamentals", to="wbportfolio.instrument"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="instrument",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="forecasts", to="wbportfolio.instrument"
            ),
        ),
        migrations.AddField(
            model_name="fiscalquarterperiod",
            name="instrument",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="quarterly_fiscal_periods",
                to="wbportfolio.instrument",
            ),
        ),
        migrations.AddField(
            model_name="dailyfundamental",
            name="instrument",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="daily_fundamentals",
                to="wbportfolio.instrument",
            ),
        ),
        migrations.AddIndex(
            model_name="geographicsegment",
            index=models.Index(fields=["instrument", "fiscal_year", "fiscal_quarter"], name="geographic_segment_idx"),
        ),
        migrations.AddIndex(
            model_name="fundamental",
            index=models.Index(fields=["instrument", "fiscal_year", "fiscal_quarter"], name="fundamental_idx"),
        ),
        migrations.AddIndex(
            model_name="forecast",
            index=models.Index(fields=["instrument", "date"], name="forecast_idx"),
        ),
        migrations.AddIndex(
            model_name="fiscalquarterperiod",
            index=models.Index(fields=["instrument", "fiscal_year", "fiscal_quarter"], name="fiscal_period_idx"),
        ),
        migrations.AddIndex(
            model_name="dailyfundamental",
            index=models.Index(fields=["instrument", "-date"], name="daily_fundamental_idx"),
        ),
        migrations.CreateModel(
            name="RelatedInstrumentThroughModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("is_primary", models.BooleanField(default=False)),
                (
                    "related_type",
                    models.CharField(
                        choices=[("BENCHMARK", "Benchmark"), ("PEER", "Peer"), ("RISK_INSTRUMENT", "Risk Instrument")],
                        default="BENCHMARK",
                        max_length=32,
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="instrument",
            name="related_instruments",
            field=models.ManyToManyField(
                blank=True,
                related_name="benchmarks_of",
                through="wbportfolio.RelatedInstrumentThroughModel",
                to="wbportfolio.instrument",
                verbose_name="The Related Instruments",
            ),
        ),
        migrations.AddField(
            model_name="relatedinstrumentthroughmodel",
            name="instrument",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="related_instruments_through",
                to="wbportfolio.instrument",
            ),
        ),
        migrations.AddField(
            model_name="relatedinstrumentthroughmodel",
            name="related_instrument",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="dependent_instruments_through",
                to="wbportfolio.instrument",
            ),
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="benchmarks",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="risk_instrument",
        ),
        migrations.DeleteModel(
            name="BenchmarkThroughModel",
        ),
        migrations.RenameField(
            model_name="instrument",
            old_name="classifications",
            new_name="old_classifications",
        ),
        migrations.CreateModel(
            name="InstrumentClassificationThroughModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("is_favorite", models.BooleanField(default=False)),
                (
                    "classification",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="instruments_through",
                        to="wbportfolio.classification",
                    ),
                ),
                (
                    "instrument",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="classifications_through",
                        to="wbportfolio.instrument",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="instrument",
            name="classifications",
            field=models.ManyToManyField(
                blank=True,
                limit_choices_to=models.Q(("level", django.db.models.expressions.F("group__max_depth"))),
                related_name="tmp_instruments",
                through="wbportfolio.InstrumentClassificationThroughModel",
                to="wbportfolio.classification",
                verbose_name="Classifications",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="classifications",
            field=models.ManyToManyField(
                blank=True,
                limit_choices_to=models.Q(("level", django.db.models.expressions.F("group__max_depth"))),
                related_name="instruments",
                through="wbportfolio.InstrumentClassificationThroughModel",
                to="wbportfolio.classification",
                verbose_name="Classifications",
            ),
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="old_classifications",
        ),
        migrations.AddField(
            model_name="addressablemarket",
            name="expected_value_usd",
            field=models.DecimalField(blank=True, decimal_places=2, max_digits=19, null=True),
        ),
        migrations.AddField(
            model_name="addressablemarket",
            name="source",
            field=models.TextField(blank=True, default=""),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebit_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected EBIT current fiscal year",
                null=True,
                verbose_name="EBIT Current (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebit_y2",
            field=models.FloatField(
                blank=True, help_text="Expected EBIT next fiscal year", null=True, verbose_name="EBIT (FY2e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebit_y3",
            field=models.FloatField(
                blank=True, help_text="Expected EBIT fiscal year + 2", null=True, verbose_name="EBIT (FY3e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebit_y4",
            field=models.FloatField(
                blank=True, help_text="Expected EBIT fiscal year + 3", null=True, verbose_name="EBIT (FY4e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebit_y5",
            field=models.FloatField(
                blank=True, help_text="Expected EBIT fiscal year + 4", null=True, verbose_name="EBIT (FY5e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebitda_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected EBITDA current fiscal year",
                null=True,
                verbose_name="EBITDA Current (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebitda_y2",
            field=models.FloatField(
                blank=True, help_text="Expected EBITDA next fiscal year", null=True, verbose_name="EBITDA (FY2e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebitda_y3",
            field=models.FloatField(
                blank=True, help_text="Expected EBITDA fiscal year + 2", null=True, verbose_name="EBITDA (FY3e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebitda_y4",
            field=models.FloatField(
                blank=True, help_text="Expected EBITDA fiscal year + 3", null=True, verbose_name="EBITDA (FY4e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebitda_y5",
            field=models.FloatField(
                blank=True, help_text="Expected EBITDA fiscal year + 4", null=True, verbose_name="EBITDA (FY5e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="eps_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Expected EPS current fiscal year", null=True, verbose_name="EPS Current (FYI1e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="eps_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Expected EPS next fiscal year", null=True, verbose_name="EPS (FYI2e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="eps_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Expected EPS fiscal year + 2", null=True, verbose_name="EPS (FYI3e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="eps_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Expected EPS fiscal year + 3", null=True, verbose_name="EPS (FYI4e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="eps_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Expected EPS fiscal year + 4", null=True, verbose_name="EPS (FYI5e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_margin_y1",
            field=models.FloatField(
                blank=True,
                help_text="Gross profit Current (FY1e)",
                null=True,
                verbose_name="Gross profit Margin Current (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_margin_y2",
            field=models.FloatField(
                blank=True,
                help_text="Expected Gross profit margin next fiscal year",
                null=True,
                verbose_name="Gross profit Margin (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_margin_y3",
            field=models.FloatField(
                blank=True,
                help_text="Expected Gross profit margin fiscal year + 2",
                null=True,
                verbose_name="Gross profit Margin (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_margin_y4",
            field=models.FloatField(
                blank=True,
                help_text="Expected Gross profit margin fiscal year + 3",
                null=True,
                verbose_name="Gross profit Margin (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_margin_y5",
            field=models.FloatField(
                blank=True,
                help_text="Expected Gross profit margin fiscal year + 4",
                null=True,
                verbose_name="Gross profit Margin (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_profit_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit current fiscal year",
                null=True,
                verbose_name="Net profit Current (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_profit_y2",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit next fiscal year",
                null=True,
                verbose_name="Net profit (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_profit_y3",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit fiscal year + 2",
                null=True,
                verbose_name="Net profit (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_profit_y4",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit fiscal year + 3",
                null=True,
                verbose_name="Net profit (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_profit_y5",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit fiscal year + 4",
                null=True,
                verbose_name="Net profit (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="revenue_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected Revenue current fiscal year",
                null=True,
                verbose_name="Revenue Current (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="revenue_y2",
            field=models.FloatField(blank=True, help_text="Revenue FY2e", null=True, verbose_name="Revenue FY2e"),
        ),
        migrations.AddField(
            model_name="forecast",
            name="revenue_y3",
            field=models.FloatField(blank=True, help_text="Revenue FY3e", null=True, verbose_name="Revenue FY3e"),
        ),
        migrations.AddField(
            model_name="forecast",
            name="revenue_y4",
            field=models.FloatField(blank=True, help_text="Revenue FY4e", null=True, verbose_name="Revenue FY4e"),
        ),
        migrations.AddField(
            model_name="forecast",
            name="revenue_y5",
            field=models.FloatField(blank=True, help_text="Revenue FY5e", null=True, verbose_name="Revenue FY5e"),
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_daily_fundamental",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_of_instrument",
                to="wbportfolio.dailyfundamental",
                verbose_name="Last Daily Fundamental",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_forecast",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_of_instrument",
                to="wbportfolio.forecast",
                verbose_name="Last Forecast",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_fundamental_y0",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_of_instrument",
                to="wbportfolio.fundamental",
                verbose_name="Last Fundamental",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_geographic_segment",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_of_instrument",
                to="wbportfolio.geographicsegment",
                verbose_name="Last Geographic segment",
            ),
        ),
        migrations.AlterModelOptions(
            name="theme",
            options={
                "permissions": [("admin_theme", "Can administer Theme")],
                "verbose_name": "Theme",
                "verbose_name_plural": "Themes",
            },
        ),
        migrations.CreateModel(
            name="InstrumentPerformanceAnalysis",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("value", models.FloatField(blank=True, null=True)),
                ("comment", models.TextField(blank=True, null=True, verbose_name="Comments")),
                ("period", django.contrib.postgres.fields.ranges.DateRangeField()),
                (
                    "type_analysis",
                    models.CharField(
                        choices=[("CONTRIBUTION", "Contribution"), ("MEAN_PERFORMANCE", "Mean Performance")],
                        default="CONTRIBUTION",
                        max_length=32,
                        verbose_name="Type of Analysis",
                    ),
                ),
                (
                    "conviction_type",
                    models.CharField(
                        choices=[
                            ("BUY", "Buy"),
                            ("WARMING_UP", "Warming up"),
                            ("COOLING_DOWN", "Cooling down"),
                            ("SELL", "Sell"),
                        ],
                        default="BUY",
                        max_length=32,
                        verbose_name="Conviction type",
                    ),
                ),
                (
                    "conclusion_type",
                    models.CharField(
                        choices=[
                            ("NO_CHANGES", "No Changes"),
                            ("UNDER_REVIEW_TO_ADD", "Under review to add"),
                            ("UNDER_REVIEW_TO_SELL", "Under review to sell"),
                            ("EXITED", "Exited"),
                        ],
                        default="NO_CHANGES",
                        max_length=32,
                        verbose_name="Conclusion type",
                    ),
                ),
                ("url_figure", models.CharField(blank=True, max_length=1000, null=True, verbose_name="URL Figure")),
                (
                    "classification",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="%(class)s",
                        to="wbportfolio.classification",
                    ),
                ),
                (
                    "instrument",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="performance_analysis",
                        to="wbportfolio.instrument",
                    ),
                ),
                (
                    "performance_peers",
                    models.ManyToManyField(
                        blank=True,
                        related_name="instrument_performances_analysis",
                        to="wbportfolio.instrumentperformanceanalysis",
                        verbose_name="Performance Peers",
                    ),
                ),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True)),
            ],
            options={
                "verbose_name": "Instrument Performance Analysis",
                "verbose_name_plural": "Instrument Performance Analysis",
            },
        ),
        migrations.CreateModel(
            name="ClassificationPerformanceAnalysis",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("value", models.FloatField(blank=True, null=True)),
                ("comment", models.TextField(blank=True, null=True, verbose_name="Comments")),
                ("period", django.contrib.postgres.fields.ranges.DateRangeField()),
                (
                    "type_analysis",
                    models.CharField(
                        choices=[("CONTRIBUTION", "Contribution"), ("MEAN_PERFORMANCE", "Mean Performance")],
                        default="CONTRIBUTION",
                        max_length=32,
                        verbose_name="Type of Analysis",
                    ),
                ),
                ("url_figure", models.CharField(blank=True, max_length=1000, null=True, verbose_name="URL Figure")),
                (
                    "classification",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s",
                        to="wbportfolio.classification",
                    ),
                ),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True)),
            ],
            options={
                "verbose_name": "Classification Performance Analysis",
                "verbose_name_plural": "Classification Performance Analysis",
            },
        ),
        migrations.AlterField(
            model_name="dailyfundamental",
            name="free_cash_flow",
            field=models.FloatField(blank=True, help_text="Free Cash Flow", null=True, verbose_name="FCF"),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="free_cash_flow",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Free cash flow", null=True, verbose_name="FCFs"
            ),
        ),
        migrations.RemoveField(
            model_name="dailyfundamental",
            name="free_cash_flow_5y_cagr",
        ),
        migrations.AddField(
            model_name="fundamental",
            name="free_cash_flow_5y_cagr",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="5-year Cumulative Annual Growth Rate of FCFs %",
                null=True,
                verbose_name="Latest 5Y FCFs CAGR",
            ),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="free_cash_flow_growth",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Current Free Cash Flow Growth", null=True, verbose_name="FCFs Growth"
            ),
        ),
        migrations.AlterField(
            model_name="dailyfundamental",
            name="free_cash_flow",
            field=models.FloatField(
                blank=True, help_text="Daily Free Cash Flow", null=True, verbose_name="FCF (Daily)"
            ),
        ),
        migrations.AlterField(
            model_name="dailyfundamental",
            name="free_cash_flow_growth",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Current Free Cash Flow Growth", null=True, verbose_name="Daily FCFs Growth"
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_fundamental_y1",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_y1_fundamental_of_instruments",
                to="wbportfolio.fundamental",
                verbose_name="Last Fundamental (Year - 1)",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_fundamental_y2",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_y2_fundamental_of_instruments",
                to="wbportfolio.fundamental",
                verbose_name="Last Fundamental (Year - 2)",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_fundamental_y3",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_y3_fundamental_of_instruments",
                to="wbportfolio.fundamental",
                verbose_name="Last Fundamental (Year - 3)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="entreprise_value_y4",
            new_name="entreprise_value_y5",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="entreprise_value_y5",
            field=models.FloatField(
                blank=True,
                help_text="Expected Entreprise Value fiscal year +4",
                null=True,
                verbose_name="Expected Entreprise Value (FY5e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="free_cash_flow_y4",
            new_name="free_cash_flow_y5",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="free_cash_flow_y5",
            field=models.FloatField(
                blank=True, help_text="Expected FCFs fiscal year +4", null=True, verbose_name="FCFs (FY5e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross profit fiscal year + 4",
                null=True,
                verbose_name="Gross profit (FY5e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="net_debt_y4",
            new_name="net_debt_y5",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="net_debt_y5",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Debt current year 4",
                null=True,
                verbose_name="Net Debt current (FY5e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="entreprise_value_y3",
            new_name="entreprise_value_y4",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="entreprise_value_y4",
            field=models.FloatField(
                blank=True,
                help_text="Expected Entreprise Value fiscal year +3",
                null=True,
                verbose_name="Expected Entreprise Value (FY4e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="free_cash_flow_y3",
            new_name="free_cash_flow_y4",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="free_cash_flow_y4",
            field=models.FloatField(
                blank=True, help_text="Expected FCFs fiscal year +3", null=True, verbose_name="FCFs (FY4e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross profit fiscal year + 3",
                null=True,
                verbose_name="Gross profit (FY4e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="net_debt_y3",
            new_name="net_debt_y4",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="net_debt_y4",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Debt current year 3",
                null=True,
                verbose_name="Net Debt current (FY4e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="entreprise_value_y2",
            new_name="entreprise_value_y3",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="entreprise_value_y3",
            field=models.FloatField(
                blank=True,
                help_text="Expected Entreprise Value fiscal year +2",
                null=True,
                verbose_name="Expected Entreprise Value (FY3e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="free_cash_flow_y2",
            new_name="free_cash_flow_y3",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="free_cash_flow_y3",
            field=models.FloatField(
                blank=True, help_text="Expected FCFs fiscal year +2", null=True, verbose_name="FCFs (FY3e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross profit fiscal year + 2",
                null=True,
                verbose_name="Gross profit (FY3e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="net_debt_y2",
            new_name="net_debt_y3",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="net_debt_y3",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Debt current year 2",
                null=True,
                verbose_name="Net Debt current (FY3e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="entreprise_value_y1",
            new_name="entreprise_value_y2",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="entreprise_value_y2",
            field=models.FloatField(
                blank=True,
                help_text="Expected Entreprise Value fiscal year +1",
                null=True,
                verbose_name="Expected Entreprise Value (FY2e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="free_cash_flow_y1",
            new_name="free_cash_flow_y2",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="free_cash_flow_y2",
            field=models.FloatField(
                blank=True, help_text="Expected FCFs fiscal year +1", null=True, verbose_name="FCFs (FY2e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross profit next fiscal year",
                null=True,
                verbose_name="Gross profit (FY2e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="net_debt_y1",
            new_name="net_debt_y2",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="net_debt_y2",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Debt current year 1",
                null=True,
                verbose_name="Net Debt current (FY2e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="entreprise_value_y0",
            new_name="entreprise_value_y1",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="entreprise_value_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected Entreprise Value current fiscal year",
                null=True,
                verbose_name="Expected Entreprise Value current (FY1e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="free_cash_flow_y0",
            new_name="free_cash_flow_y1",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="free_cash_flow_y1",
            field=models.FloatField(
                blank=True, help_text="Expected FCFs current fiscal year", null=True, verbose_name="FCFs (FY1e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross profit current fiscal year",
                null=True,
                verbose_name="Gross profit current (FY1e)",
            ),
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="net_debt_y0",
            new_name="net_debt_y1",
        ),
        migrations.AlterField(
            model_name="forecast",
            name="net_debt_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Debt current fiscal year",
                null=True,
                verbose_name="Net Debt current (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="last_fundamental_y0",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_fundamental_of_instruments",
                to="wbportfolio.fundamental",
                verbose_name="Last Fundamental",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="last_fundamental_y0",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_fundamental_of_instruments",
                to="wbportfolio.fundamental",
                verbose_name="Last Fundamental (Current Year)",
            ),
        ),
        migrations.AlterField(
            model_name="fundamental",
            name="revenue",
            field=models.FloatField(blank=True, help_text="Net Sales or Revenues", null=True, verbose_name="Revenue"),
        ),
        migrations.AlterField(
            model_name="tradeproposal",
            name="status",
            field=django_fsm.FSMField(
                choices=[("DRAFT", "Draft"), ("SUBMIT", "Submit"), ("APPROVED", "Approved"), ("DENIED", "Denied")],
                default="DRAFT",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="date",
            field=models.DateField(verbose_name="Date"),
        ),
        migrations.RemoveField(
            model_name="equity",
            name="old_id",
        ),
        migrations.RemoveField(
            model_name="index",
            name="initial_date",
        ),
        migrations.RemoveField(
            model_name="index",
            name="old_id",
        ),
        migrations.RemoveField(
            model_name="product",
            name="old_id",
        ),
        migrations.RemoveField(
            model_name="productgroup",
            name="old_id",
        ),
        migrations.AddField(
            model_name="instrument",
            name="imports_allowed",
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="issue_price",
            field=models.PositiveIntegerField(
                default=100,
                help_text="The initial issue price that is displayed on the factsheet",
                verbose_name="Issue Price",
            ),
        ),
        migrations.RemoveField(
            model_name="product",
            name="ticker_reuters",
        ),
        migrations.AlterField(
            model_name="geographicsegment",
            name="description",
            field=models.TextField(blank=True, default="", verbose_name="Segment Description"),
        ),
        migrations.AlterField(
            model_name="register",
            name="custodian_address",
            field=models.TextField(blank=True, default=""),
        ),
        migrations.AlterField(
            model_name="register",
            name="outlet_address",
            field=models.TextField(blank=True, default=""),
        ),
        migrations.AlterField(
            model_name="register",
            name="status_message",
            field=models.TextField(blank=True, default=""),
        ),
        migrations.AlterField(
            model_name="tradeproposal",
            name="comment",
            field=models.TextField(blank=True, default="", verbose_name="Trade Comment"),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="comment",
            field=models.TextField(blank=True, default="", verbose_name="Comment"),
        ),
        migrations.AddField(
            model_name="exchange",
            name="closing_time",
            field=models.TimeField(
                blank=True,
                help_text="The closing time of the exchange",
                null=True,
                verbose_name="Exchange Closing time",
            ),
        ),
        migrations.AddField(
            model_name="exchange",
            name="opening_time",
            field=models.TimeField(
                blank=True,
                help_text="The opening time of the exchange",
                null=True,
                verbose_name="Exchange Opening time",
            ),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="diluted_eps",
            field=models.FloatField(
                blank=True, help_text="Diluted Earning per shares", null=True, verbose_name="Diluted EPS"
            ),
        ),
        migrations.AlterField(
            model_name="splitdata",
            name="date",
            field=models.DateField(verbose_name="Executive Date"),
        ),
        migrations.AddField(
            model_name="assetposition",
            name="latest_split",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="splited_assets",
                to="wbportfolio.splitdata",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="latest_split",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="splited_prices",
                to="wbportfolio.splitdata",
            ),
        ),
        migrations.AddField(
            model_name="splitdata",
            name="status",
            field=django_fsm.FSMField(
                choices=[
                    ("APPLIED", "Applied"),
                    ("DENIED", "Denied"),
                    ("CONFIRMED", "Confirmed"),
                    ("PENDING", "Pending"),
                ],
                default="PENDING",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AlterField(
            model_name="splitdata",
            name="factor",
            field=models.DecimalField(decimal_places=3, default=Decimal("1"), max_digits=9, verbose_name="Factor"),
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="external_id",
        ),
        migrations.AddField(
            model_name="instrument",
            name="tag_detail_endpoint",
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.AddField(
            model_name="instrument",
            name="tag_representation",
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.CreateModel(
            name="InstrumentRequest",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "instrument_type",
                    models.CharField(
                        choices=[
                            ("Product", "Product"),
                            ("Index", "Index"),
                            ("ProductGroup", "Product Group"),
                            ("Equity", "Equity"),
                            ("ETF", "ETF"),
                            ("ETP", "ETP"),
                            ("Cash", "Cash"),
                            ("Option", "Option"),
                            ("Right", "Right"),
                            ("Bond", "Bond"),
                            ("InterestRateDerivative", "Interest Rate Derivate"),
                            ("Future", "Future"),
                            ("Forward", "Forward"),
                            ("Swap", "Swap"),
                            ("Coupon", "Coupon"),
                            ("Crypto", "Crypto"),
                            ("Commodity", "Commodity"),
                        ],
                        max_length=255,
                        verbose_name="Type",
                    ),
                ),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[("PENDING", "Pending"), ("APPROVED", "Approved"), ("DENIED", "Denied")],
                        default="PENDING",
                        help_text="The Request Status (default to Pending)",
                        max_length=50,
                        verbose_name="Status",
                    ),
                ),
                ("notes", models.TextField(blank=True, null=True, verbose_name="Notes")),
                (
                    "created",
                    models.DateTimeField(
                        auto_now_add=True, help_text="The request creation time", verbose_name="Created"
                    ),
                ),
                ("instrument_data", models.JSONField(default=dict, verbose_name="Instrument Data")),
                (
                    "created_instrument",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="creation_request",
                        to="wbportfolio.instrument",
                    ),
                ),
            ],
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="outstanding_shares",
            field=wbcore.models.fields.DynamicDecimalField(
                blank=True,
                decimal_places=4,
                help_text="The amount of outstanding share for this instrument",
                max_digits=16,
                null=True,
                verbose_name="Outstanding Shares",
            ),
        ),
        migrations.AddField(
            model_name="theme",
            name="benchmarks",
            field=models.ManyToManyField(blank=True, related_name="benchmark_of_themes", to="wbportfolio.instrument"),
        ),
        migrations.AddField(
            model_name="theme",
            name="composite",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="composite_of_themes",
                to="wbportfolio.portfolio",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="old_isins",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=12),
                blank=True,
                default=list,
                help_text="These old ISINs are stored for this instrument to retrieve it more easily later.",
                size=None,
                verbose_name="Old ISINS",
            ),
        ),
        migrations.AddField(
            model_name="theme",
            name="color_new",
            field=wbcore.contrib.color.fields.ColorField(default="#000000"),
        ),
        migrations.RemoveField(
            model_name="theme",
            name="color",
        ),
        migrations.RenameField(
            model_name="theme",
            old_name="color_new",
            new_name="color",
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="date",
            field=models.DateField(default=datetime.date.today),
        ),
        migrations.RemoveField(
            model_name="fundamental",
            name="net_debt_to_EBITDA_ratio",
        ),
        migrations.AddField(
            model_name="forecast",
            name="capex_to_sales_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Capex-to-Sales current fiscal year",
                null=True,
                verbose_name="Capex-to-Sales Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="capex_to_sales_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Capex-to-Sales fiscal year +1", null=True, verbose_name="Capex-to-Sales (FY2e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="capex_to_sales_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Capex-to-Sales fiscal year +2", null=True, verbose_name="Capex-to-Sales (FY3e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="capex_to_sales_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Capex-to-Sales fiscal year +3", null=True, verbose_name="Capex-to-Sales (FY4e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="capex_to_sales_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Capex-to-Sales fiscal year +4", null=True, verbose_name="Capex-to-Sales (FY5e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="capital_expenditures_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Capital Expenditures current fiscal year",
                null=True,
                verbose_name="Capital Expenditures Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="capital_expenditures_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Capital Expenditures fiscal year +1",
                null=True,
                verbose_name="Capital Expenditures (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="capital_expenditures_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Capital Expenditures fiscal year +2",
                null=True,
                verbose_name="Capital Expenditures (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="capital_expenditures_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Capital Expenditures fiscal year +3",
                null=True,
                verbose_name="Capital Expenditures (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="capital_expenditures_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Capital Expenditures fiscal year +4",
                null=True,
                verbose_name="Capital Expenditures (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebit_margin_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected EBIT Margin current fiscal year",
                null=True,
                verbose_name="EBIT Margin Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebit_margin_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected EBIT Margin next fiscal year",
                null=True,
                verbose_name="EBIT Margin (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebit_margin_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected EBIT Margin fiscal year + 2",
                null=True,
                verbose_name="EBIT Margin (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebit_margin_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected EBIT Margin fiscal year + 3",
                null=True,
                verbose_name="EBIT Margin (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebit_margin_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected EBIT Margin fiscal year + 4",
                null=True,
                verbose_name="EBIT Margin (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebitda_margin_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected EBITDA Margin current fiscal year",
                null=True,
                verbose_name="EBITDA Margin Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebitda_margin_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected EBITDA Margin next fiscal year",
                null=True,
                verbose_name="EBITDA Margin (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebitda_margin_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected EBITDA Margin fiscal year + 2",
                null=True,
                verbose_name="EBITDA Margin (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebitda_margin_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected EBITDA Margin fiscal year + 3",
                null=True,
                verbose_name="EBITDA Margin (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="ebitda_margin_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected EBITDA Margin fiscal year + 4",
                null=True,
                verbose_name="EBITDA Margin (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="expected_book_value_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Book value current fiscal year",
                null=True,
                verbose_name="Expected Book value Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="expected_book_value_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Book value fiscal year +1",
                null=True,
                verbose_name="Expected Book value (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="expected_book_value_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Book value fiscal year +2",
                null=True,
                verbose_name="Expected Book value (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="expected_book_value_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Book value fiscal year +3",
                null=True,
                verbose_name="Expected Book value (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="expected_book_value_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Book value fiscal year +4",
                null=True,
                verbose_name="Expected Book value (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="free_cash_flow_growth_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected FCFs Growth current fiscal year",
                null=True,
                verbose_name="FCFs Growth Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="free_cash_flow_growth_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected FCFs Growth fiscal year +1",
                null=True,
                verbose_name="FCFs Growth (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="free_cash_flow_growth_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected FCFs Growth fiscal year +2",
                null=True,
                verbose_name="FCFs Growth (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="free_cash_flow_growth_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected FCFs Growth fiscal year +3",
                null=True,
                verbose_name="FCFs Growth (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="free_cash_flow_growth_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected FCFs Growth fiscal year +4",
                null=True,
                verbose_name="FCFs Growth (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="free_cash_flow_to_sales_ratio_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected FCFs-to-Sales Ratio current fiscal year",
                null=True,
                verbose_name="FCFs-to-Sales Ratio Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="free_cash_flow_to_sales_ratio_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected FCFs-to-Sales Ratio fiscal year +1",
                null=True,
                verbose_name="FCFs-to-Sales Ratio (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="free_cash_flow_to_sales_ratio_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected FCFs-to-Sales Ratio fiscal year +2",
                null=True,
                verbose_name="FCFs-to-Sales Ratio (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="free_cash_flow_to_sales_ratio_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected FCFs-to-Sales Ratio fiscal year +3",
                null=True,
                verbose_name="FCFs-to-Sales Ratio (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="free_cash_flow_to_sales_ratio_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected FCFs-to-Sales Ratio fiscal year +4",
                null=True,
                verbose_name="FCFs-to-Sales Ratio (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_debt_to_ebitda_ratio_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Net Debt to EBITDA Ratio current fiscal year",
                null=True,
                verbose_name="Net Debt to EBITDA Ratio Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_debt_to_ebitda_ratio_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Net Debt to EBITDA Ratio year 1",
                null=True,
                verbose_name="Net Debt to EBITDA Ratio (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_debt_to_ebitda_ratio_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Net Debt to EBITDA Ratio year 2",
                null=True,
                verbose_name="Net Debt to EBITDA Ratio (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_debt_to_ebitda_ratio_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Net Debt to EBITDA Ratio year 3",
                null=True,
                verbose_name="Net Debt to EBITDA Ratio (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_debt_to_ebitda_ratio_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Net Debt to EBITDA Ratio year 4",
                null=True,
                verbose_name="Net Debt to EBITDA Ratio (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_profit_margin_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Net Profit Margin current fiscal year",
                null=True,
                verbose_name="Net Profit Margin Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_profit_margin_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Net Profit Margin next fiscal year",
                null=True,
                verbose_name="Net Profit Margin (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_profit_margin_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Net Profit Margin fiscal year + 2",
                null=True,
                verbose_name="Net Profit Margin (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_profit_margin_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Net Profit Margin fiscal year + 3",
                null=True,
                verbose_name="Net Profit Margin (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="net_profit_margin_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Net Profit Margin fiscal year + 4",
                null=True,
                verbose_name="Net Profit Margin (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="revenue_growth_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Revenue Growth current fiscal year",
                null=True,
                verbose_name="Revenue Growth Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="revenue_growth_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Revenue Growth FY2e", null=True, verbose_name="Revenue Growth FY2e"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="revenue_growth_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Revenue Growth FY3e", null=True, verbose_name="Revenue Growth FY3e"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="revenue_growth_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Revenue Growth FY4e", null=True, verbose_name="Revenue Growth FY4e"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="revenue_growth_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Revenue Growth FY5e", null=True, verbose_name="Revenue Growth FY5e"
            ),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="capex_to_sales",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Capex-to-Sales", null=True, verbose_name="Capex-to-Sales"
            ),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="eps",
            field=models.FloatField(blank=True, help_text="Earning per shares", null=True, verbose_name="EPS"),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="free_cash_flow_to_sales_ratio",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="FCF-to-Sales Ratio", null=True, verbose_name="FCF-to-Sales Ratio"
            ),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="net_debt_to_ebitda_ratio",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="a debt ratio that shows how many years it would take for a company to pay back its debt if net debt and EBITDA are held constant",
                null=True,
                verbose_name="net-debt-to-EBITDA ratio",
            ),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="sga_to_sales_ratio",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="SG&A to Sales Ratio", null=True, verbose_name="SG&A to Sales Ratio"
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_fiscal_quarterly_period",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_of_instrument",
                to="wbportfolio.fiscalquarterperiod",
                verbose_name="Last Fiscal Quarterly Period",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_instrument_price",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_of_instrument",
                to="wbportfolio.instrumentprice",
                verbose_name="Last Instrument Price",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="ebit_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected EBIT current fiscal year",
                null=True,
                verbose_name="EBIT Current FY (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="ebitda_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected EBITDA current fiscal year",
                null=True,
                verbose_name="EBITDA Current FY (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="entreprise_value_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected Entreprise Value current fiscal year",
                null=True,
                verbose_name="Expected Entreprise Value Current FY (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="eps_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected EPS current fiscal year",
                null=True,
                verbose_name="EPS Current FY (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="eps_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Expected EPS next fiscal year", null=True, verbose_name="EPS (FY2e)"
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="eps_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Expected EPS fiscal year + 2", null=True, verbose_name="EPS (FY3e)"
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="eps_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Expected EPS fiscal year + 3", null=True, verbose_name="EPS (FY4e)"
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="eps_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Expected EPS fiscal year + 4", null=True, verbose_name="EPS (FY5e)"
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="free_cash_flow_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected FCFs current fiscal year",
                null=True,
                verbose_name="FCFs Current FY (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="gross_profit_margin_y1",
            field=models.FloatField(
                blank=True,
                help_text="Gross profit Current (FY1e)",
                null=True,
                verbose_name="Gross profit Margin Current FY (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="gross_profit_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross Profit current fiscal year",
                null=True,
                verbose_name="Gross Profit Current FY (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="gross_profit_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross Profit next fiscal year",
                null=True,
                verbose_name="Gross Profit (FY2e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="gross_profit_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross Profit fiscal year + 2",
                null=True,
                verbose_name="Gross Profit (FY3e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="gross_profit_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross Profit fiscal year + 3",
                null=True,
                verbose_name="Gross Profit (FY4e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="gross_profit_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross Profit fiscal year + 4",
                null=True,
                verbose_name="Gross Profit (FY5e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="net_debt_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Debt current fiscal year",
                null=True,
                verbose_name="Net Debt Current FY (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="net_debt_y2",
            field=models.FloatField(
                blank=True, help_text="Expected Net Debt year 1", null=True, verbose_name="Net Debt (FY2e)"
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="net_debt_y3",
            field=models.FloatField(
                blank=True, help_text="Expected Net Debt year 2", null=True, verbose_name="Net Debt (FY3e)"
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="net_debt_y4",
            field=models.FloatField(
                blank=True, help_text="Expected Net Debt year 3", null=True, verbose_name="Net Debt (FY4e)"
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="net_debt_y5",
            field=models.FloatField(
                blank=True, help_text="Expected Net Debt year 4", null=True, verbose_name="Net Debt (FY5e)"
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="net_profit_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit current fiscal year",
                null=True,
                verbose_name="Net profit Current FY (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="revenue_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected Revenue current fiscal year",
                null=True,
                verbose_name="Revenue Current FY (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="fundamental",
            name="cash_from_operation",
            field=models.FloatField(
                blank=True, help_text="Cash From Operation", null=True, verbose_name="Cash From Operation"
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="imports_allowed",
            field=models.BooleanField(
                default=False,
                help_text="If true, past historical data will be imported on creation and daily data update will include this instrument",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="refinitiv_mnemonic_code",
            field=models.CharField(
                blank=True,
                help_text="Refinitiv Datastream Mnemonic Code",
                max_length=255,
                null=True,
                unique=True,
                verbose_name="Refinitiv Datastream Mnemonic Code",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="ticker",
            field=models.CharField(
                blank=True,
                help_text="The Bloomberg ticker without the exchange (e.g. AAPL)",
                max_length=255,
                null=True,
                verbose_name="Ticker Bloomberg",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentrequest",
            name="status",
            field=django_fsm.FSMField(
                choices=[("PENDING", "Pending"), ("APPROVED", "Approved"), ("DENIED", "Denied"), ("DRAFT", "Draft")],
                default="DRAFT",
                help_text="The Request Status (default to Pending)",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AddConstraint(
            model_name="addressablemarket",
            constraint=models.UniqueConstraint(fields=("year", "classification"), name="unique_year_classification"),
        ),
        migrations.AddConstraint(
            model_name="instrumentprice",
            constraint=models.CheckConstraint(
                check=models.Q(("date__week_day__in", [1, 7]), _negated=True),
                name="wbportfolio_instrumentprice_weekday_constraint",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="classification",
            unique_together={("group", "code_aggregated")},
        ),
        migrations.AlterUniqueTogether(
            name="dailyfundamental",
            unique_together={("date", "instrument")},
        ),
        migrations.AlterUniqueTogether(
            name="fiscalquarterperiod",
            unique_together={("instrument", "fiscal_year", "fiscal_quarter")},
        ),
        migrations.AlterUniqueTogether(
            name="forecast",
            unique_together={("instrument", "date")},
        ),
        migrations.AlterUniqueTogether(
            name="fundamental",
            unique_together={("instrument", "fiscal_year", "fiscal_quarter")},
        ),
        migrations.AlterUniqueTogether(
            name="geographicsegment",
            unique_together={("instrument", "fiscal_year", "fiscal_quarter", "level", "field")},
        ),
        migrations.AlterUniqueTogether(
            name="instrumentprice",
            unique_together={("calculated", "date", "instrument")},
        ),
        migrations.AlterUniqueTogether(
            name="portfolioinstrumentpreferedclassificationthroughmodel",
            unique_together={("portfolio", "instrument")},
        ),
        migrations.AlterUniqueTogether(
            name="relatedinstrumentthroughmodel",
            unique_together={("instrument", "related_instrument", "is_primary", "related_type")},
        ),
        migrations.AlterModelOptions(
            name="trade",
            options={"verbose_name": "Trade", "verbose_name_plural": "Trades"},
        ),
        migrations.AddField(
            model_name="trade",
            name="custodian",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="trades",
                to="wbportfolio.custodian",
            ),
        ),
        migrations.AddField(
            model_name="trade",
            name="delta_weight",
            field=models.DecimalField(
                blank=True,
                decimal_places=6,
                help_text="The weight to be multiplied against the target for rebalancing",
                max_digits=16,
                null=True,
                verbose_name="Delta Weight",
            ),
        ),
        migrations.AddField(
            model_name="trade",
            name="effective_weight",
            field=models.DecimalField(
                decimal_places=6,
                default=0,
                help_text="The Effective weight (delta_weight = target_weight/effective_weight)",
                max_digits=16,
                verbose_name="Start Weight",
            ),
        ),
        migrations.AddField(
            model_name="trade",
            name="exclude_from_history",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="trade",
            name="external_identifier2",
            field=models.CharField(
                blank=True,
                help_text="A second external identifier that was supplied.",
                max_length=255,
                null=True,
                verbose_name="External Identifier 2",
            ),
        ),
        migrations.AddField(
            model_name="trade",
            name="pending",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="trade",
            name="price_gross",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The gross price per share.",
                max_digits=16,
                null=True,
                verbose_name="Gross Price",
            ),
        ),
        migrations.AddField(
            model_name="trade",
            name="register",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="trades",
                to="wbportfolio.register",
            ),
        ),
        migrations.AddField(
            model_name="trade",
            name="status",
            field=django_fsm.FSMField(
                choices=[
                    ("DRAFT", "Draft"),
                    ("SUBMIT", "Submit"),
                    ("EXECUTED", "Executed"),
                    ("CONFIRMED", "Confirmed"),
                ],
                default="CONFIRMED",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AddField(
            model_name="trade",
            name="target_weight",
            field=models.DecimalField(
                blank=True,
                decimal_places=6,
                help_text="The Target weight (delta_weight = target_weight/effective_weight)",
                max_digits=16,
                null=True,
                verbose_name="Target Weight",
            ),
        ),
        migrations.AddField(
            model_name="trade",
            name="trade_proposal",
            field=models.ForeignKey(
                blank=True,
                help_text="The Trade Proposal this trade is coming from",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="trades",
                to="wbportfolio.tradeproposal",
            ),
        ),
        migrations.AddField(
            model_name="trade",
            name="transaction_subtype",
            field=models.CharField(
                choices=[
                    ("REBALANCE", "Rebalance"),
                    ("DECREASE", "Decrease"),
                    ("INCREASE", "Increase"),
                    ("SUBSCRIPTION", "Subscription"),
                    ("REDEMPTION", "Redemption"),
                    ("BUY", "Buy"),
                    ("SELL", "Sell"),
                ],
                default="BUY",
                max_length=32,
                verbose_name="Trade Type",
            ),
        ),
        migrations.AlterField(
            model_name="trade",
            name="shares",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The number of shares that were traded.",
                max_digits=15,
                null=True,
                verbose_name="Shares",
            ),
        ),
        migrations.AlterModelTable(
            name="trade",
            table="portfolio_trade",
        ),
    ]
