# Generated by Django 4.1.7 on 2023-04-19 06:07

from decimal import Decimal

import django.contrib.postgres.fields
import django.contrib.postgres.fields.ranges
import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import django_better_admin_arrayfield.models.fields
import django_fsm
import wbcore.models.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("tags", "0001_initial"),
        ("currency", "0001_initial"),
        ("wbportfolio", "0001_initial_squashed"),
        ("geography", "0001_initial"),
        ("io", "0001_initial_squashed"),
        ("directory", "0001_initial"),
        ("contenttypes", "0002_remove_content_type_name"),
        ("wbcore", "0001_initial_squashed_squashed_0010_preset_appliedpreset"),
    ]

    operations = [
        migrations.AlterField(
            model_name="product",
            name="termsheet",
            field=models.FileField(blank=True, max_length=256, null=True, upload_to="portfolio/product/termsheets"),
        ),
        migrations.AddField(
            model_name="portfolio",
            name="active",
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name="classification",
            name="analyst_view",
            field=models.IntegerField(
                blank=True, choices=[(-1, "Negative"), (0, "Neutral"), (1, "Positive")], null=True
            ),
        ),
        migrations.AddField(
            model_name="classification",
            name="macro_long_term",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (-2, "Very Negative"),
                    (-1, "Negative"),
                    (0, "Neutral"),
                    (1, "Positive"),
                    (2, "Very Positive"),
                ],
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="classification",
            name="macro_medium_term",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (-2, "Very Negative"),
                    (-1, "Negative"),
                    (0, "Neutral"),
                    (1, "Positive"),
                    (2, "Very Positive"),
                ],
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="classification",
            name="macro_short_term",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (-2, "Very Negative"),
                    (-1, "Negative"),
                    (0, "Neutral"),
                    (1, "Positive"),
                    (2, "Very Positive"),
                ],
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="instrumentclassificationthroughmodel",
            name="tag_detail_endpoint",
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.AddField(
            model_name="instrumentclassificationthroughmodel",
            name="tag_representation",
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.RenameModel(
            old_name="FiscalQuarterPeriod",
            new_name="FiscalPeriod",
        ),
        migrations.RemoveIndex(
            model_name="fundamental",
            name="fundamental_idx",
        ),
        migrations.RemoveIndex(
            model_name="geographicsegment",
            name="geographic_segment_idx",
        ),
        migrations.RemoveIndex(
            model_name="fiscalperiod",
            name="fiscal_period_idx",
        ),
        migrations.AddField(
            model_name="fundamental",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True),
        ),
        migrations.AddField(
            model_name="geographicsegment",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True),
        ),
        migrations.AlterUniqueTogether(
            name="fundamental",
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name="geographicsegment",
            unique_together=set(),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="period",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="%(class)s",
                to="wbportfolio.fiscalperiod",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="geographicsegment",
            name="period",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="%(class)s",
                to="wbportfolio.fiscalperiod",
            ),
            preserve_default=False,
        ),
        migrations.AddIndex(
            model_name="fundamental",
            index=models.Index(fields=["instrument", "period"], name="fundamental_idx"),
        ),
        migrations.AddIndex(
            model_name="geographicsegment",
            index=models.Index(fields=["instrument", "period"], name="geographic_segment_idx"),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="last_fiscal_quarterly_period",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_of_instrument",
                to="wbportfolio.fiscalperiod",
                verbose_name="Last Fiscal Quarterly Period",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="fundamental",
            unique_together={("instrument", "period")},
        ),
        migrations.AlterUniqueTogether(
            name="geographicsegment",
            unique_together={("instrument", "period", "level", "field")},
        ),
        migrations.RenameField(
            model_name="fiscalperiod",
            old_name="fiscal_quarter_end_date",
            new_name="period_end_date",
        ),
        migrations.RenameField(
            model_name="fiscalperiod",
            old_name="fiscal_quarter",
            new_name="quarter",
        ),
        migrations.RenameField(
            model_name="fiscalperiod",
            old_name="fiscal_year",
            new_name="year",
        ),
        migrations.RenameField(
            model_name="fiscalperiod",
            old_name="fiscal_year_end_date",
            new_name="year_end_date",
        ),
        migrations.AlterUniqueTogether(
            name="fiscalperiod",
            unique_together=set(),
        ),
        migrations.AddField(
            model_name="fiscalperiod",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True),
        ),
        migrations.AddField(
            model_name="fiscalperiod",
            name="date_range",
            field=django.contrib.postgres.fields.ranges.DateRangeField(blank=True, null=True),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="fiscalperiod",
            name="instrument",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="fiscal_periods", to="wbportfolio.instrument"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="fiscalperiod",
            unique_together={("instrument", "year", "quarter")},
        ),
        migrations.AddIndex(
            model_name="fiscalperiod",
            index=models.Index(fields=["instrument", "quarter", "year"], name="fiscal_period_idx"),
        ),
        migrations.RemoveIndex(
            model_name="fiscalperiod",
            name="fiscal_period_idx",
        ),
        migrations.RemoveField(
            model_name="fundamental",
            name="date_range",
        ),
        migrations.RemoveField(
            model_name="fundamental",
            name="fiscal_quarter",
        ),
        migrations.RemoveField(
            model_name="fundamental",
            name="fiscal_year",
        ),
        migrations.RemoveField(
            model_name="geographicsegment",
            name="date_range",
        ),
        migrations.RemoveField(
            model_name="geographicsegment",
            name="fiscal_quarter",
        ),
        migrations.RemoveField(
            model_name="geographicsegment",
            name="fiscal_year",
        ),
        migrations.AlterField(
            model_name="fundamental",
            name="period",
            field=models.ForeignKey(
                default=None,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="%(class)s",
                to="wbportfolio.fiscalperiod",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="geographicsegment",
            name="period",
            field=models.ForeignKey(
                default=None,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="%(class)s",
                to="wbportfolio.fiscalperiod",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="fiscalperiod",
            name="date_range",
            field=django.contrib.postgres.fields.ranges.DateRangeField(default=None),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="instrument",
            name="tag_representation",
            field=models.CharField(blank=True, max_length=512, null=True),
        ),
        migrations.AlterField(
            model_name="instrumentclassificationthroughmodel",
            name="tag_representation",
            field=models.CharField(blank=True, max_length=512, null=True),
        ),
        migrations.AddIndex(
            model_name="fiscalperiod",
            index=models.Index(fields=["instrument", "quarter", "year"], name="fiscal_period_idx"),
        ),
        migrations.RenameField(
            model_name="portfolio",
            old_name="active",
            new_name="is_active",
        ),
        migrations.AddField(
            model_name="portfolio",
            name="deletion_datetime",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="classification",
            name="investable",
            field=models.BooleanField(default=True, help_text="Is this classification investable for us?"),
        ),
        migrations.CreateModel(
            name="ThemeReviewTemplate",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "name",
                    models.CharField(
                        default="", help_text="The name of the template.", max_length=32, verbose_name="Name"
                    ),
                ),
                (
                    "template_path",
                    models.CharField(blank=True, max_length=512, null=True, verbose_name="Template Path"),
                ),
                ("context_path", models.CharField(blank=True, max_length=512, null=True, verbose_name="Context Path")),
                (
                    "internal_employee",
                    models.BooleanField(
                        default=True, help_text="A marker to know if the template is available for internal employees."
                    ),
                ),
            ],
            options={
                "verbose_name": "Theme Review Template",
                "verbose_name_plural": "Theme Review Templates",
            },
        ),
        migrations.CreateModel(
            name="ListElementResearch",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "title",
                    models.CharField(help_text="Title - Maximum 255 character)", max_length=255, verbose_name="Title"),
                ),
                ("description", models.TextField(blank=True, default="", verbose_name="Description")),
            ],
            options={
                "verbose_name": "List Element Research",
                "verbose_name_plural": "List Element Researches",
            },
        ),
        migrations.CreateModel(
            name="ReferenceResearch",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "title",
                    models.CharField(help_text="Title - Maximum 255 character)", max_length=255, verbose_name="Title"),
                ),
                (
                    "reference_type",
                    models.CharField(
                        choices=[
                            ("ARTICLE", "Article"),
                            ("BOOK", "Book"),
                            ("CONFERENCE", "Conference"),
                            ("JOURNAL", "Journal"),
                            ("REPORT", "Report"),
                            ("WEBSITE", "Website"),
                            ("OTHER", "Other"),
                        ],
                        default="ARTICLE",
                        max_length=16,
                        verbose_name="Type of source",
                    ),
                ),
                ("source", models.CharField(blank=True, default="", max_length=256, verbose_name="Source")),
                ("date", models.DateField(blank=True, null=True)),
                ("url", models.URLField(blank=True, default="", max_length=2048, null=True, verbose_name="URL")),
            ],
            options={
                "verbose_name": "Reference Research",
                "verbose_name_plural": "Reference Researches",
            },
        ),
        migrations.CreateModel(
            name="RelationshipResearch",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "relationship_type",
                    models.CharField(
                        choices=[("KOL", "KOL"), ("ACADEMIC", "Academic"), ("COMPANY", "Company"), ("OTHER", "Other")],
                        default="KOL",
                        max_length=32,
                        verbose_name="Relationship Type",
                    ),
                ),
            ],
            options={
                "verbose_name": "Relationship Research",
                "verbose_name_plural": "Relationship Researches",
            },
        ),
        migrations.CreateModel(
            name="Research",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True)),
                (
                    "research_type",
                    models.CharField(
                        choices=[
                            ("ONE_TEXT", "One Sentence"),
                            ("TWO_TEXT", "Two Sentence"),
                            ("SWOT", "SWOT"),
                            ("OUTLOOK", "Outlook"),
                            ("PORTER_FIVE", "Porter Five"),
                            ("LIST_RESEARCH", "List Research"),
                            ("RELATIONSHIP", "Relationship"),
                            ("REFERENCE", "Reference"),
                            ("TIMELINE", "Timeline"),
                        ],
                        default="ONE_TEXT",
                        max_length=32,
                        verbose_name="Type",
                    ),
                ),
                ("preview", models.TextField(blank=True, null=True)),
                ("iteration", models.PositiveIntegerField(default=0)),
                ("object_id", models.PositiveIntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="ResearchTopic",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "research_type",
                    models.CharField(
                        choices=[
                            ("ONE_TEXT", "One Sentence"),
                            ("TWO_TEXT", "Two Sentence"),
                            ("SWOT", "SWOT"),
                            ("OUTLOOK", "Outlook"),
                            ("PORTER_FIVE", "Porter Five"),
                            ("LIST_RESEARCH", "List Research"),
                            ("RELATIONSHIP", "Relationship"),
                            ("REFERENCE", "Reference"),
                            ("TIMELINE", "Timeline"),
                        ],
                        default="ONE_TEXT",
                        max_length=32,
                        verbose_name="Research Type",
                    ),
                ),
                (
                    "allowed_model",
                    models.CharField(
                        choices=[("classification", "Classification"), ("instrument", "Instrument")],
                        default="classification",
                        max_length=32,
                        verbose_name="Type",
                    ),
                ),
                ("name", models.CharField(max_length=255, unique=True, verbose_name="Name")),
                ("iteration", models.PositiveIntegerField(blank=True, null=True, verbose_name="Iteration")),
                ("guideline", models.TextField(blank=True, default="")),
            ],
            options={
                "verbose_name": "Research Topic",
                "verbose_name_plural": "Research Topics",
            },
        ),
        migrations.CreateModel(
            name="ResearchTopicRelationship",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("object_id", models.PositiveIntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="ResearchTemplate",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("template_path", models.CharField(max_length=256, verbose_name="Template Path")),
                ("name", models.CharField(max_length=256, verbose_name="Name")),
                ("parameters", models.JSONField(blank=True, default=dict, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="TimelineResearch",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date", models.DateField(blank=True, null=True, verbose_name="Date")),
                (
                    "text",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Give some context and why now it is the 'right' time from a historical perspective.",
                        verbose_name="Text",
                    ),
                ),
                ("year", models.IntegerField(blank=True, null=True, verbose_name="Year")),
            ],
            options={
                "verbose_name": "Timeline Research",
                "verbose_name_plural": "Timeline Researches",
            },
        ),
        migrations.AddField(
            model_name="classification",
            name="description",
            field=models.TextField(
                blank=True,
                default="",
                help_text="Give a basic definition and description",
                verbose_name="Definition/Description",
            ),
        ),
        migrations.AddField(
            model_name="instrumentclassificationthroughmodel",
            name="pure_player",
            field=models.BooleanField(default=False, help_text="Pure Players Companies", verbose_name="Pure Player"),
        ),
        migrations.AddField(
            model_name="instrumentclassificationthroughmodel",
            name="reason",
            field=models.TextField(blank=True, default="", verbose_name="Reason for the choice"),
        ),
        migrations.AddField(
            model_name="instrumentclassificationthroughmodel",
            name="top_player",
            field=models.BooleanField(default=False, help_text="Top Players Companies", verbose_name="Top Player"),
        ),
        migrations.AddConstraint(
            model_name="instrumentclassificationthroughmodel",
            constraint=models.UniqueConstraint(
                fields=("instrument", "classification"), name="unique_classifiedinstrument"
            ),
        ),
        migrations.CreateModel(
            name="ListResearch",
            fields=[
                (
                    "research_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.research",
                    ),
                ),
                (
                    "summary",
                    models.TextField(blank=True, default="", verbose_name="Bottom Line (Maximum 1000 characters)"),
                ),
            ],
            options={
                "verbose_name": "List Research",
                "verbose_name_plural": "List Researches",
            },
            bases=("wbportfolio.research",),
        ),
        migrations.CreateModel(
            name="OneTextBoxResearch",
            fields=[
                (
                    "research_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.research",
                    ),
                ),
                ("text", models.TextField(blank=True, default="", verbose_name="Text")),
            ],
            options={
                "verbose_name": "One TextBox Research",
                "verbose_name_plural": "One TextBox Researches",
            },
            bases=("wbportfolio.research",),
        ),
        migrations.CreateModel(
            name="OutlookResearch",
            fields=[
                (
                    "research_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.research",
                    ),
                ),
                (
                    "short_term",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="What to watch for the future. Think forward and give several possible outcomes of the overall theme/scenarios) state of the theme. What is the possible addressable market for each period? What (and why) are the possible (and prevailing) technologies/products that we would see in the future? What (and why) are the technologies/products likely to command the highest market share?",
                        verbose_name="Short Term (up to 2 years)",
                    ),
                ),
                (
                    "medium_term",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="What to watch for the future. Think forward and give several possible outcomes of the overall theme/scenarios) state of the theme. What is the possible addressable market for each period? What (and why) are the possible (and prevailing) technologies/products that we would see in the future? What (and why) are the technologies/products likely to command the highest market share?",
                        verbose_name="Medium Term (from 3 to 5 years)",
                    ),
                ),
                (
                    "long_term",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="What to watch for the future. Think forward and give several possible outcomes of the overall theme/scenarios) state of the theme. What is the possible addressable market for each period? What (and why) are the possible (and prevailing) technologies/products that we would see in the future? What (and why) are the technologies/products likely to command the highest market share?",
                        verbose_name="Long Term (from 5 to 10 years)",
                    ),
                ),
                (
                    "very_long_term",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="What to watch for the future. Think forward and give several possible outcomes of the overall theme/scenarios) state of the theme. What is the possible addressable market for each period? What (and why) are the possible (and prevailing) technologies/products that we would see in the future? What (and why) are the technologies/products likely to command the highest market share?",
                        verbose_name="Very long Term scenario thinking (15 to 30 years)",
                    ),
                ),
                (
                    "summary",
                    models.TextField(
                        blank=True, default="", verbose_name="Outlook Bottom Line (Maximum 1000 characters)"
                    ),
                ),
            ],
            options={
                "verbose_name": "Outlook Research",
                "verbose_name_plural": "Outlook Researches",
            },
            bases=("wbportfolio.research",),
        ),
        migrations.CreateModel(
            name="PorterFiveResearch",
            fields=[
                (
                    "research_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.research",
                    ),
                ),
                (
                    "rivalry_competitors",
                    models.TextField(blank=True, default="", verbose_name="Rivalry among existing competitors"),
                ),
                (
                    "power_suppliers",
                    models.TextField(blank=True, default="", verbose_name="Bargaining power of suppliers"),
                ),
                (
                    "threat_new_entrants",
                    models.TextField(blank=True, default="", verbose_name="Threat of new entrants"),
                ),
                ("power_buyers", models.TextField(blank=True, default="", verbose_name="Bargaining power of buyers")),
                (
                    "threat_substitutes",
                    models.TextField(
                        blank=True,
                        default="",
                        verbose_name="Threat of substitute products (can be expanded with a sixth force: role of complementors).",
                    ),
                ),
                (
                    "summary",
                    models.TextField(blank=True, default="", verbose_name="Bottom Line (Maximum 1000 characters)"),
                ),
            ],
            options={
                "verbose_name": "Porter Five Research",
                "verbose_name_plural": "Porter Five Researches",
            },
            bases=("wbportfolio.research",),
        ),
        migrations.CreateModel(
            name="SWOTResearch",
            fields=[
                (
                    "research_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.research",
                    ),
                ),
                (
                    "strengths",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Describe the strengths for the theme/subtheme.",
                        verbose_name="Strengths",
                    ),
                ),
                (
                    "weaknesses",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Describe the weaknesses for the theme/subtheme.",
                        verbose_name="Weaknesses",
                    ),
                ),
                (
                    "opportunities",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Describe the opportunities for the theme/subtheme.",
                        verbose_name="Opportunities",
                    ),
                ),
                (
                    "threats",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Describe the threats for the theme/subtheme.",
                        verbose_name="Threats",
                    ),
                ),
                (
                    "summary",
                    models.TextField(blank=True, default="", verbose_name="Bottom Line (Maximum 1000 characters)"),
                ),
            ],
            options={
                "verbose_name": "SWOT Research",
                "verbose_name_plural": "SWOT Researches",
            },
            bases=("wbportfolio.research",),
        ),
        migrations.CreateModel(
            name="TwoTextBoxResearch",
            fields=[
                (
                    "research_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.research",
                    ),
                ),
                ("text", models.TextField(blank=True, default="", verbose_name="Text")),
                ("summary", models.TextField(blank=True, default="", verbose_name="Summary")),
            ],
            options={
                "verbose_name": "Two TextBox Research",
                "verbose_name_plural": "Two TextBox Researches",
            },
            bases=("wbportfolio.research",),
        ),
        migrations.AddField(
            model_name="researchtemplate",
            name="content_type",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="researche_templates",
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AddField(
            model_name="researchtopicrelationship",
            name="topic",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="relationships",
                to="wbportfolio.researchtopic",
                verbose_name="Relationship",
            ),
        ),
        migrations.AddField(
            model_name="researchtopicrelationship",
            name="object_repr",
            field=models.CharField(blank=True, max_length=512, null=True),
        ),
        migrations.AddField(
            model_name="researchtopicrelationship",
            name="content_type",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to="contenttypes.contenttype"
            ),
        ),
        migrations.AddField(
            model_name="research",
            name="content_type",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to="contenttypes.contenttype"
            ),
        ),
        migrations.AddField(
            model_name="research",
            name="research_topic",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="researches",
                to="wbportfolio.researchtopic",
                verbose_name="Research Topic",
            ),
        ),
        migrations.AddField(
            model_name="timelineresearch",
            name="list_research",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="related_timelines",
                to="wbportfolio.listresearch",
                verbose_name="List Research",
            ),
        ),
        migrations.AddIndex(
            model_name="research",
            index=models.Index(
                fields=["research_type", "research_topic", "content_type", "object_id", "iteration"],
                name="research_idx",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="research",
            unique_together={("research_type", "research_topic", "content_type", "object_id", "iteration")},
        ),
        migrations.AddField(
            model_name="relationshipresearch",
            name="list_research",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="related_relationships",
                to="wbportfolio.listresearch",
                verbose_name="List Research",
            ),
        ),
        migrations.AddField(
            model_name="referenceresearch",
            name="list_research",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="related_references",
                to="wbportfolio.listresearch",
                verbose_name="List Research",
            ),
        ),
        migrations.AddField(
            model_name="listelementresearch",
            name="list_research",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="related_list_research",
                to="wbportfolio.listresearch",
                verbose_name="List Research",
            ),
        ),
        migrations.AlterField(
            model_name="research",
            name="research_type",
            field=models.CharField(
                choices=[
                    ("ONE_TEXT", "One Sentence"),
                    ("TWO_TEXT", "Two Sentences"),
                    ("SWOT", "SWOT"),
                    ("OUTLOOK", "Outlook"),
                    ("PORTER_FIVE", "Porter Five"),
                    ("LIST_RESEARCH", "List Research"),
                    ("RELATIONSHIP", "Relationship"),
                    ("REFERENCE", "Reference"),
                    ("TIMELINE", "Timeline"),
                ],
                default="ONE_TEXT",
                max_length=32,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="researchtopic",
            name="research_type",
            field=models.CharField(
                choices=[
                    ("ONE_TEXT", "One Sentence"),
                    ("TWO_TEXT", "Two Sentences"),
                    ("SWOT", "SWOT"),
                    ("OUTLOOK", "Outlook"),
                    ("PORTER_FIVE", "Porter Five"),
                    ("LIST_RESEARCH", "List Research"),
                    ("RELATIONSHIP", "Relationship"),
                    ("REFERENCE", "Reference"),
                    ("TIMELINE", "Timeline"),
                ],
                default="ONE_TEXT",
                max_length=32,
                verbose_name="Research Type",
            ),
        ),
        migrations.AddConstraint(
            model_name="researchtopicrelationship",
            constraint=models.UniqueConstraint(
                fields=("topic", "content_type", "object_id"), name="unique_research_topic_relationship"
            ),
        ),
        migrations.AlterModelOptions(
            name="researchtopicrelationship",
            options={
                "verbose_name": "Research Topic Relationship",
                "verbose_name_plural": "Research Topic Relationships",
            },
        ),
        migrations.AddField(
            model_name="researchtopic",
            name="order",
            field=models.PositiveIntegerField(blank=True, null=True, verbose_name="Order"),
        ),
        migrations.AlterField(
            model_name="researchtopic",
            name="iteration",
            field=models.PositiveIntegerField(default=0, verbose_name="Iteration"),
        ),
        migrations.AddField(
            model_name="instrumentclassificationthroughmodel",
            name="percent_of_revenue",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0.0),
                    django.core.validators.MaxValueValidator(1.0),
                ],
                verbose_name="% of revenue",
            ),
        ),
        migrations.DeleteModel(
            name="ThemeReviewTemplate",
        ),
        migrations.AddField(
            model_name="product",
            name="theme",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products",
                to="wbportfolio.theme",
            ),
        ),
        migrations.AddField(
            model_name="equity",
            name="status",
            field=django_fsm.FSMField(
                choices=[("PRIVATE", "Private"), ("PUBLIC", "Public"), ("MERGED", "M&A"), ("INACTIVE", "Inactive")],
                default="PUBLIC",
                max_length=50,
            ),
        ),
        migrations.CreateModel(
            name="Deal",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("DEAL", "Deal"),
                            ("FUNDING", "Funding"),
                            ("INVESTMENT", "Investment"),
                            ("PORTFOLIO_EXIT", "Portfolio Exit"),
                        ],
                        default="DEAL",
                        help_text="The deal type",
                        max_length=14,
                        verbose_name="Type",
                    ),
                ),
                ("date", models.DateField()),
                ("transaction_amount", models.FloatField(help_text="Deal Size (in millions")),
                ("funding_round", models.CharField(max_length=128, verbose_name="Funding Round")),
                ("funding_round_category", models.CharField(max_length=128, verbose_name="Funding Round Category")),
                (
                    "valuation",
                    models.FloatField(
                        help_text="Valuation of the funded organization after this transaction (in Millions USD).",
                        verbose_name="Valuaton",
                    ),
                ),
                (
                    "valuation_estimated",
                    models.BooleanField(
                        default=False,
                        help_text="True if the valuation is an estimate",
                        verbose_name="Is valuation estimated",
                    ),
                ),
                (
                    "valuation_source_type",
                    models.CharField(
                        choices=[
                            ("STATE_FILING", "State Filing"),
                            ("VENTURE_SOURCE_ACTUAL", "Venture Source Actual"),
                            ("VENTURE_SOURCE_ESTIMATE", "Venture Source Estimate"),
                            ("MEDIA_MENTION", "Media Mention"),
                            ("COMPARABLE", "Comparable"),
                        ],
                        default="VENTURE_SOURCE_ACTUAL",
                        help_text="The source type of the valuation",
                        max_length=24,
                    ),
                ),
                (
                    "valuation_media_mention_source_urls",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.URLField(),
                        help_text="List of URLs used to source the valuation for the Media Mentions source type.",
                        size=None,
                    ),
                ),
                (
                    "equity",
                    models.ForeignKey(
                        limit_choices_to={"status": "PRIVATE"},
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="deals",
                        to="wbportfolio.equity",
                    ),
                ),
                (
                    "investors",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Investors",
                        related_name="invested_deals",
                        to="wbportfolio.instrument",
                        verbose_name="Investors",
                    ),
                ),
            ],
        ),
        migrations.AlterField(
            model_name="trade",
            name="delta_weight",
            field=models.DecimalField(
                decimal_places=6,
                default=Decimal("0"),
                help_text="The weight to be multiplied against the target for rebalancing",
                max_digits=16,
                verbose_name="Delta Weight",
            ),
        ),
        migrations.AlterField(
            model_name="trade",
            name="target_weight",
            field=models.DecimalField(
                decimal_places=6,
                default=Decimal("0"),
                help_text="The Target weight (delta_weight = target_weight/effective_weight)",
                max_digits=16,
                verbose_name="Target Weight",
            ),
        ),
        migrations.AlterField(
            model_name="classification",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Name"),
        ),
        migrations.AlterField(
            model_name="fiscalperiod",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Name"),
        ),
        migrations.AlterField(
            model_name="fundamental",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Name"),
        ),
        migrations.AlterField(
            model_name="geographicsegment",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Name"),
        ),
        migrations.AlterField(
            model_name="research",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Name"),
        ),
        migrations.AddField(
            model_name="trade",
            name="order",
            field=models.PositiveSmallIntegerField(blank=True, null=True),
        ),
        migrations.AlterUniqueTogether(
            name="portfolioinstrumentpreferedclassificationthroughmodel",
            unique_together={("portfolio", "instrument", "classification_group")},
        ),
        migrations.CreateModel(
            name="InstrumentClassificationRelatedInstrument",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "related_instrument_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("PARTNER", "Partner"),
                            ("SUPPLIER", "Supplier"),
                            ("PEER", "Peer"),
                            ("COMPETITOR", "Competitor"),
                            ("BIGGEST_THREAT", "Biggest Threat"),
                            ("CUSTOMER", "Customer"),
                        ],
                        max_length=16,
                        null=True,
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="instrumentclassificationthroughmodel",
            name="related_instruments",
            field=models.ManyToManyField(
                blank=True,
                through="wbportfolio.InstrumentClassificationRelatedInstrument",
                to="wbportfolio.instrument",
            ),
        ),
        migrations.AddField(
            model_name="instrumentclassificationrelatedinstrument",
            name="classified_instrument",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="related_instruements",
                to="wbportfolio.instrumentclassificationthroughmodel",
            ),
        ),
        migrations.AddField(
            model_name="instrumentclassificationrelatedinstrument",
            name="related_instrument",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="instrument_classification_related",
                to="wbportfolio.instrument",
            ),
        ),
        migrations.AlterModelTable(
            name="assetposition",
            table=None,
        ),
        migrations.AlterModelTable(
            name="bond",
            table=None,
        ),
        migrations.AlterModelTable(
            name="cash",
            table=None,
        ),
        migrations.AlterModelTable(
            name="classification",
            table=None,
        ),
        migrations.AlterModelTable(
            name="classificationgroup",
            table=None,
        ),
        migrations.AlterModelTable(
            name="custodian",
            table=None,
        ),
        migrations.AlterModelTable(
            name="equity",
            table=None,
        ),
        migrations.AlterModelTable(
            name="exchange",
            table=None,
        ),
        migrations.AlterModelTable(
            name="exchangeinstrumentthroughmodel",
            table=None,
        ),
        migrations.AlterModelTable(
            name="expiry",
            table=None,
        ),
        migrations.AlterModelTable(
            name="feecalculation",
            table=None,
        ),
        migrations.AlterModelTable(
            name="fees",
            table=None,
        ),
        migrations.AlterModelTable(
            name="index",
            table=None,
        ),
        migrations.AlterModelTable(
            name="instrument",
            table=None,
        ),
        migrations.AlterModelTable(
            name="instrumentfavoritegroup",
            table=None,
        ),
        migrations.AlterModelTable(
            name="instrumentportfoliothroughmodel",
            table=None,
        ),
        migrations.AlterModelTable(
            name="instrumentprice",
            table=None,
        ),
        migrations.AlterModelTable(
            name="interestratederivative",
            table=None,
        ),
        migrations.AlterModelTable(
            name="portfolio",
            table=None,
        ),
        migrations.AlterModelTable(
            name="portfolioinstrumentpreferedclassificationthroughmodel",
            table=None,
        ),
        migrations.AlterModelTable(
            name="portfoliorole",
            table=None,
        ),
        migrations.AlterModelTable(
            name="product",
            table=None,
        ),
        migrations.AlterModelTable(
            name="productgroup",
            table=None,
        ),
        migrations.AlterModelTable(
            name="productgrouprepresentant",
            table=None,
        ),
        migrations.AlterModelTable(
            name="register",
            table=None,
        ),
        migrations.AlterModelTable(
            name="trade",
            table=None,
        ),
        migrations.AlterModelTable(
            name="transaction",
            table=None,
        ),
        migrations.RemoveIndex(
            model_name="fiscalperiod",
            name="fiscal_period_idx",
        ),
        migrations.RenameField(
            model_name="assetposition",
            old_name="latest_split",
            new_name="applied_split",
        ),
        migrations.RenameField(
            model_name="fundamental",
            old_name="cash_equivalents",
            new_name="cash_and_cash_equivalents",
        ),
        migrations.RenameField(
            model_name="fundamental",
            old_name="cash_st_investments",
            new_name="cash_and_short_term_investments",
        ),
        migrations.RenameField(
            model_name="fundamental",
            old_name="cash_st_investments_to_current_assets_ratio",
            new_name="cash_and_short_term_investments_to_current_assets_ratio",
        ),
        migrations.AlterUniqueTogether(
            name="fiscalperiod",
            unique_together=set(),
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="market_share",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="price_fx_portfolio",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="price_multiplier",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="total_value",
        ),
        migrations.RemoveField(
            model_name="assetposition",
            name="total_value_fx_portfolio",
        ),
        migrations.RemoveField(
            model_name="dailyfundamental",
            name="eps",
        ),
        migrations.RemoveField(
            model_name="forecast",
            name="expected_book_value_y1",
        ),
        migrations.RemoveField(
            model_name="forecast",
            name="expected_book_value_y2",
        ),
        migrations.RemoveField(
            model_name="forecast",
            name="expected_book_value_y3",
        ),
        migrations.RemoveField(
            model_name="forecast",
            name="expected_book_value_y4",
        ),
        migrations.RemoveField(
            model_name="forecast",
            name="expected_book_value_y5",
        ),
        migrations.RemoveField(
            model_name="fundamental",
            name="free_cash_flow_5y_cagr",
        ),
        migrations.RemoveField(
            model_name="fundamental",
            name="revenue_growth_5y_cagr",
        ),
        migrations.RenameField(
            model_name="assetposition",
            old_name="currency_fx_rate",
            new_name="initial_currency_fx_rate",
        ),
        migrations.RenameField(
            model_name="assetposition",
            old_name="price",
            new_name="initial_price",
        ),
        migrations.RenameField(
            model_name="assetposition",
            old_name="shares",
            new_name="initial_shares",
        ),
        migrations.AddField(
            model_name="dailyfundamental",
            name="eps_3y_cagr",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="3-year Cumulative Annual Growth Rate of EPS %",
                null=True,
                verbose_name="EPS 3 Year CAGR",
            ),
        ),
        migrations.AddField(
            model_name="dailyfundamental",
            name="eps_ftw",
            field=models.FloatField(
                blank=True, help_text="Earning per Shares (FTW)", null=True, verbose_name="EPS FTW"
            ),
        ),
        migrations.AddField(
            model_name="dailyfundamental",
            name="free_cash_flow_3y_cagr",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="3-year Cumulative Annual Growth Rate of FCFs %",
                null=True,
                verbose_name="Latest 3Y FCFs CAGR",
            ),
        ),
        migrations.AddField(
            model_name="dailyfundamental",
            name="revenue_growth_3y_cagr",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="3-year Cumulative Annual Growth Rate of revenue %",
                null=True,
                verbose_name="3Y Revenue Growth CAGR",
            ),
        ),
        migrations.AddField(
            model_name="fiscalperiod",
            name="period",
            field=models.PositiveIntegerField(
                default=1,
                validators=[
                    django.core.validators.MaxValueValidator(limit_value=4),
                    django.core.validators.MinValueValidator(limit_value=1),
                ],
            ),
        ),
        migrations.AddField(
            model_name="fiscalperiod",
            name="period_type",
            field=models.CharField(
                choices=[
                    ("Y", "Annual"),
                    ("6M", "Semester Interim"),
                    ("4M", "Trimester Interim"),
                    ("Q", "Quarterly Interim"),
                ],
                default="Q",
                max_length=52,
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="deprecation_and_amortization_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Deprecation and Amortization Current FY (FY1e)",
                null=True,
                verbose_name="Deprecation and Amortization (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="deprecation_and_amortization_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Deprecation and Amortization (next fiscal year)",
                null=True,
                verbose_name="Deprecation and Amortization (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="deprecation_and_amortization_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Deprecation and Amortization (fiscal year + 2)",
                null=True,
                verbose_name="Deprecation and Amortization (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="deprecation_and_amortization_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Deprecation and Amortization (fiscal year + 3)",
                null=True,
                verbose_name="Deprecation and Amortization (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="deprecation_and_amortization_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Deprecation and Amortization (fiscal year + 4)",
                null=True,
                verbose_name="Deprecation and Amortization (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="eps_growth_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="EPS Growth current fiscal year",
                null=True,
                verbose_name="EPS Growth Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="eps_growth_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="EPS Growth FY2e", null=True, verbose_name="EPS Growth FY2e"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="eps_growth_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="EPS Growth FY3e", null=True, verbose_name="EPS Growth FY3e"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="eps_growth_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="EPS Growth FY4e", null=True, verbose_name="EPS Growth FY4e"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="eps_growth_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="EPS Growth FY5e", null=True, verbose_name="EPS Growth FY5e"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="expected_book_value_per_share_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected Book value Per Share current fiscal year",
                null=True,
                verbose_name="Expected Book value Per Share Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="expected_book_value_per_share_y2",
            field=models.FloatField(
                blank=True,
                help_text="Expected Book value Per Share fiscal year +1",
                null=True,
                verbose_name="Expected Book value Per Share (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="expected_book_value_per_share_y3",
            field=models.FloatField(
                blank=True,
                help_text="Expected Book value Per Share fiscal year +2",
                null=True,
                verbose_name="Expected Book value Per Share (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="expected_book_value_per_share_y4",
            field=models.FloatField(
                blank=True,
                help_text="Expected Book value Per Share fiscal year +3",
                null=True,
                verbose_name="Expected Book value Per Share (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="expected_book_value_per_share_y5",
            field=models.FloatField(
                blank=True,
                help_text="Expected Book value Per Share fiscal year +4",
                null=True,
                verbose_name="Expected Book value Per Share (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_margin_without_depreciation_y1",
            field=models.FloatField(
                blank=True,
                help_text="Gross profit Margin (excl. D&A) Current FY (FY1e)",
                null=True,
                verbose_name="Gross profit Margin (excl. D&A) (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_margin_without_depreciation_y2",
            field=models.FloatField(
                blank=True,
                help_text="Expected Gross profit margin without D&A (next fiscal year)",
                null=True,
                verbose_name="Gross profit Margin (excl. D&A) (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_margin_without_depreciation_y3",
            field=models.FloatField(
                blank=True,
                help_text="Expected Gross profit margin without D&A (fiscal year + 2)",
                null=True,
                verbose_name="Gross profit Margin (excl. D&A) (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_margin_without_depreciation_y4",
            field=models.FloatField(
                blank=True,
                help_text="Expected Gross profit margin without D&A (fiscal year + 3)",
                null=True,
                verbose_name="Gross profit Margin (excl. D&A) (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="gross_profit_margin_without_depreciation_y5",
            field=models.FloatField(
                blank=True,
                help_text="Expected Gross profit margin without D&A (fiscal year + 4)",
                null=True,
                verbose_name="Gross profit Margin (excl. D&A) (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="cost_of_good_sold_without_depreciation",
            field=models.FloatField(blank=True, null=True, verbose_name="COGS (Excl Depreciation)"),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="deprecation_and_amortization",
            field=models.FloatField(blank=True, null=True, verbose_name="D&A"),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="deprecation_and_amortization_to_sales_ratio",
            field=wbcore.models.fields.DynamicFloatField(blank=True, null=True, verbose_name="D&A to Sales Ratio"),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="eps_growth",
            field=wbcore.models.fields.DynamicFloatField(blank=True, null=True, verbose_name="EPS Growth"),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="interest_expense_to_sales_ratio",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, null=True, verbose_name="Interest Expense to Sales Ratio"
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_fundamental_current",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_current_fundamental_of_instruments",
                to="wbportfolio.fundamental",
                verbose_name="Current Fundamental (Year 1)",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="performance_1d",
            field=wbcore.models.fields.DynamicDecimalField(
                blank=True,
                decimal_places=6,
                help_text="Performance 1D",
                max_digits=16,
                null=True,
                verbose_name="Performance 1D",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="performance_30d",
            field=wbcore.models.fields.DynamicDecimalField(
                blank=True,
                decimal_places=6,
                help_text="Performance 30 days rolling",
                max_digits=16,
                null=True,
                verbose_name="Performance (1M)",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="performance_365d",
            field=wbcore.models.fields.DynamicDecimalField(
                blank=True,
                decimal_places=6,
                help_text="Performance 365 days rolling",
                max_digits=16,
                null=True,
                verbose_name="Performance (1Y)",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="performance_7d",
            field=wbcore.models.fields.DynamicDecimalField(
                blank=True,
                decimal_places=6,
                help_text="Performance 7 days rolling",
                max_digits=16,
                null=True,
                verbose_name="Performance (1W)",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="performance_90d",
            field=wbcore.models.fields.DynamicDecimalField(
                blank=True,
                decimal_places=6,
                help_text="Performance 90 days rolling",
                max_digits=16,
                null=True,
                verbose_name="Performance (1Q)",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="performance_inception",
            field=wbcore.models.fields.DynamicDecimalField(
                blank=True,
                decimal_places=6,
                help_text="Performance since inception",
                max_digits=16,
                null=True,
                verbose_name="Performance (Inception)",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="performance_ytd",
            field=wbcore.models.fields.DynamicDecimalField(
                blank=True,
                decimal_places=6,
                help_text="Performance Year-to-date",
                max_digits=16,
                null=True,
                verbose_name="Performance (YTD)",
            ),
        ),
        migrations.AddField(
            model_name="splitdata",
            name="cumulative_factor",
            field=models.DecimalField(
                decimal_places=3, default=Decimal("1"), max_digits=9, verbose_name="Cumulative Factor"
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="weighting",
            field=models.DecimalField(
                decimal_places=6,
                default=Decimal("0"),
                help_text="The Weight of the Asset on the price date of the Asset.",
                max_digits=7,
                verbose_name="Weight",
            ),
        ),
        migrations.AlterField(
            model_name="dailyfundamental",
            name="eps_ttm",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Trailing Twelve Month EPS", null=True, verbose_name="EPS TTM"
            ),
        ),
        migrations.AlterField(
            model_name="fiscalperiod",
            name="period_end_date",
            field=models.DateField(help_text="The Fiscal Period end date"),
        ),
        migrations.AlterField(
            model_name="fiscalperiod",
            name="year",
            field=models.PositiveIntegerField(
                validators=[
                    django.core.validators.MaxLengthValidator(limit_value=4),
                    django.core.validators.MinLengthValidator(limit_value=1),
                ]
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="capital_expenditures_y1",
            field=models.FloatField(
                blank=True,
                help_text="Capital Expenditures current fiscal year",
                null=True,
                verbose_name="Capital Expenditures Current FY (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="capital_expenditures_y2",
            field=models.FloatField(
                blank=True,
                help_text="Capital Expenditures fiscal year +1",
                null=True,
                verbose_name="Capital Expenditures (FY2e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="capital_expenditures_y3",
            field=models.FloatField(
                blank=True,
                help_text="Capital Expenditures fiscal year +2",
                null=True,
                verbose_name="Capital Expenditures (FY3e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="capital_expenditures_y4",
            field=models.FloatField(
                blank=True,
                help_text="Capital Expenditures fiscal year +3",
                null=True,
                verbose_name="Capital Expenditures (FY4e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="capital_expenditures_y5",
            field=models.FloatField(
                blank=True,
                help_text="Capital Expenditures fiscal year +4",
                null=True,
                verbose_name="Capital Expenditures (FY5e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="gross_profit_margin_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Gross profit Margin Current FY (FY1e)",
                null=True,
                verbose_name="Gross profit Margin (FY1e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="gross_profit_margin_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross profit margin (next fiscal year)",
                null=True,
                verbose_name="Gross profit Margin (FY2e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="gross_profit_margin_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross profit margin (fiscal year + 2)",
                null=True,
                verbose_name="Gross profit Margin (FY3e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="gross_profit_margin_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross profit margin (fiscal year + 3)",
                null=True,
                verbose_name="Gross profit Margin (FY4e)",
            ),
        ),
        migrations.AlterField(
            model_name="forecast",
            name="gross_profit_margin_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Expected Gross profit margin (fiscal year + 4)",
                null=True,
                verbose_name="Gross profit Margin (FY5e)",
            ),
        ),
        migrations.AlterField(
            model_name="fundamental",
            name="cost_of_good_sold",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Cost of Goods Sold (excluding Depreciation and Amortization)",
                null=True,
                verbose_name="COGS (ex D&A)",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="last_fundamental_y0",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_fundamental_of_instruments",
                to="wbportfolio.fundamental",
                verbose_name="Last Fundamental (Year 0)",
            ),
        ),
        migrations.AlterField(
            model_name="splitdata",
            name="status",
            field=django_fsm.FSMField(
                choices=[("PENDING", "Pending"), ("APPLIED", "Applied"), ("DENIED", "Denied")],
                default="PENDING",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="fiscalperiod",
            unique_together={("instrument", "period_type", "year", "period")},
        ),
        migrations.AddIndex(
            model_name="fiscalperiod",
            index=models.Index(fields=["instrument", "period_type", "year", "period"], name="fiscal_period_idx"),
        ),
        migrations.AddConstraint(
            model_name="fiscalperiod",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(("period_type", "Y"), ("period", 1)),
                    models.Q(("period_type", "6M"), ("period__lte", 2)),
                    models.Q(("period_type", "4M"), ("period__lte", 3)),
                    models.Q(("period_type", "Q"), ("period__lte", 4)),
                    _connector="OR",
                ),
                name="annual_period_is_always_1",
            ),
        ),
        migrations.RemoveField(
            model_name="fiscalperiod",
            name="quarter",
        ),
        migrations.RemoveField(
            model_name="fiscalperiod",
            name="year_end_date",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="latest_split",
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="initial_currency_fx_rate",
            field=models.DecimalField(
                decimal_places=14,
                default=1.0,
                help_text="The Currency Exchange Rate that is applied to the Asset to convert it into the Portfolio's currency.",
                max_digits=28,
                verbose_name="Initial Currency FX Rate",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="initial_price",
            field=models.DecimalField(decimal_places=4, default=None, max_digits=16, verbose_name="Initial Price"),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="initial_shares",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The amount of Units of the Asset on the price date of the Asset.",
                max_digits=14,
                null=True,
                verbose_name="Initial Quantity",
            ),
        ),
        migrations.RemoveConstraint(
            model_name="fiscalperiod",
            name="annual_period_is_always_1",
        ),
        migrations.RemoveIndex(
            model_name="fiscalperiod",
            name="fiscal_period_idx",
        ),
        migrations.RenameField(
            model_name="fiscalperiod",
            old_name="period",
            new_name="period_index",
        ),
        migrations.AlterUniqueTogether(
            name="fiscalperiod",
            unique_together=set(),
        ),
        migrations.AddField(
            model_name="fiscalperiod",
            name="period_interim",
            field=models.BooleanField(default=True, verbose_name="Interim Period"),
        ),
        migrations.AddField(
            model_name="fiscalperiod",
            name="period_year",
            field=models.PositiveIntegerField(
                default=None,
                help_text="The calendar period year",
                validators=[
                    django.core.validators.MaxLengthValidator(limit_value=4),
                    django.core.validators.MinLengthValidator(limit_value=1),
                ],
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="fiscalperiod",
            name="period_type",
            field=models.CharField(
                choices=[("Y", "Annual"), ("6M", "Semester"), ("4M", "Trimester"), ("Q", "Quarter")],
                default="Q",
                max_length=52,
            ),
        ),
        migrations.AlterUniqueTogether(
            name="fiscalperiod",
            unique_together={("instrument", "period_interim", "period_year", "period_index")},
        ),
        migrations.AddIndex(
            model_name="fiscalperiod",
            index=models.Index(
                fields=["instrument", "period_interim", "period_year", "period_index"], name="fiscal_period_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="fiscalperiod",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(("period_type", "Y"), ("period_index", 1)),
                    models.Q(("period_type", "6M"), ("period_index__lte", 2)),
                    models.Q(("period_type", "4M"), ("period_index__lte", 3)),
                    models.Q(("period_type", "Q"), ("period_index__lte", 4)),
                    _connector="OR",
                ),
                name="annual_period_is_always_1",
            ),
        ),
        migrations.RemoveField(
            model_name="fiscalperiod",
            name="year",
        ),
        migrations.RemoveIndex(
            model_name="fiscalperiod",
            name="fiscal_period_idx",
        ),
        migrations.AlterUniqueTogether(
            name="fiscalperiod",
            unique_together={("instrument", "period_interim", "period_type", "period_year", "period_index")},
        ),
        migrations.AddIndex(
            model_name="fiscalperiod",
            index=models.Index(
                fields=["instrument", "period_interim", "period_type", "period_year", "period_index"],
                name="fiscal_period_idx",
            ),
        ),
        migrations.RenameField(
            model_name="instrument",
            old_name="last_fiscal_quarterly_period",
            new_name="last_quaterly_period",
        ),
        migrations.RemoveField(
            model_name="fiscalperiod",
            name="company_expected_report_date",
        ),
        migrations.AlterField(
            model_name="fiscalperiod",
            name="expected_report_date",
            field=models.DateField(blank=True, help_text="The expected report date", null=True),
        ),
        migrations.AddField(
            model_name="instrument",
            name="next_quarterly_period",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="next_of_instrument",
                to="wbportfolio.fiscalperiod",
                verbose_name="Next Fiscal Quarterly Period",
            ),
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="last_quaterly_period",
        ),
        migrations.AddField(
            model_name="instrument",
            name="last_quarterly_period",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_of_instrument",
                to="wbportfolio.fiscalperiod",
                verbose_name="Last Fiscal Quarterly Period",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentprice",
            name="free_float",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Free Float Number Of Shares", null=True, verbose_name="Free Float"
            ),
        ),
        migrations.AddField(
            model_name="dailyfundamental",
            name="free_cash",
            field=models.FloatField(
                blank=True, help_text="Daily Free Cash", null=True, verbose_name="Free Cash (Daily)"
            ),
        ),
        migrations.AlterField(
            model_name="dailyfundamental",
            name="free_cash_flow",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Current Free Cash Flow", null=True, verbose_name="Daily FCFs"
            ),
        ),
        migrations.RemoveField(
            model_name="dailyfundamental",
            name="free_cash_flow_growth",
        ),
        migrations.AddField(
            model_name="dailyfundamental",
            name="free_cash_flow_ttm_growth",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Current Free Cash Trailing Twelve Month Flow Growth",
                null=True,
                verbose_name="Daily FCFs TTM Growth",
            ),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="total_liabilities",
            field=models.FloatField(
                blank=True, help_text="Total Liabilities", null=True, verbose_name="Total Liabilities"
            ),
        ),
        migrations.AddField(
            model_name="dailyfundamental",
            name="lock_dynamic_fields",
            field=models.BooleanField(default=False, help_text="If True, will not allow dynamic fields to be updated"),
        ),
        migrations.AddField(
            model_name="forecast",
            name="lock_dynamic_fields",
            field=models.BooleanField(default=False, help_text="If True, will not allow dynamic fields to be updated"),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="lock_dynamic_fields",
            field=models.BooleanField(default=False, help_text="If True, will not allow dynamic fields to be updated"),
        ),
        migrations.AddField(
            model_name="geographicsegment",
            name="lock_dynamic_fields",
            field=models.BooleanField(default=False, help_text="If True, will not allow dynamic fields to be updated"),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="lock_dynamic_fields",
            field=models.BooleanField(default=False, help_text="If True, will not allow dynamic fields to be updated"),
        ),
        migrations.AddField(
            model_name="dailyfundamental",
            name="updated_at",
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name="forecast",
            name="updated_at",
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="updated_at",
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name="geographicsegment",
            name="updated_at",
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="updated_at",
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.RenameIndex(
            model_name="assetposition",
            new_name="wbportfolio_date_0a7c0a_idx",
            old_name="portfolio_a_date_397efc_idx",
        ),
        migrations.RenameIndex(
            model_name="assetposition",
            new_name="wbportfolio_date_da82d2_idx",
            old_name="portfolio_a_date_5e33e1_idx",
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="asset_valuation_date",
            field=models.DateField(
                default=None,
                help_text="An alternate Valuation Date, if the price date of the Asset is different from the overlying Portfolio.",
                verbose_name="Alternate Valuation Date",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="fiscalperiod",
            name="expected_year_end_date",
            field=models.DateField(blank=True, help_text="Expected Fiscal year end", null=True),
        ),
        migrations.RenameField(
            model_name="dailyfundamental",
            old_name="lock_dynamic_fields",
            new_name="lock_all_dynamic_fields",
        ),
        migrations.RenameField(
            model_name="forecast",
            old_name="lock_dynamic_fields",
            new_name="lock_all_dynamic_fields",
        ),
        migrations.RenameField(
            model_name="fundamental",
            old_name="lock_dynamic_fields",
            new_name="lock_all_dynamic_fields",
        ),
        migrations.RenameField(
            model_name="geographicsegment",
            old_name="lock_dynamic_fields",
            new_name="lock_all_dynamic_fields",
        ),
        migrations.RenameField(
            model_name="instrumentprice",
            old_name="lock_dynamic_fields",
            new_name="lock_all_dynamic_fields",
        ),
        migrations.AddField(
            model_name="dailyfundamental",
            name="locked_dynamic_fields",
            field=django_better_admin_arrayfield.models.fields.ArrayField(
                base_field=models.CharField(max_length=128), blank=True, default=list, size=None
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="locked_dynamic_fields",
            field=django_better_admin_arrayfield.models.fields.ArrayField(
                base_field=models.CharField(max_length=128), blank=True, default=list, size=None
            ),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="locked_dynamic_fields",
            field=django_better_admin_arrayfield.models.fields.ArrayField(
                base_field=models.CharField(max_length=128), blank=True, default=list, size=None
            ),
        ),
        migrations.AddField(
            model_name="geographicsegment",
            name="locked_dynamic_fields",
            field=django_better_admin_arrayfield.models.fields.ArrayField(
                base_field=models.CharField(max_length=128), blank=True, default=list, size=None
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="locked_dynamic_fields",
            field=django_better_admin_arrayfield.models.fields.ArrayField(
                base_field=models.CharField(max_length=128), blank=True, default=list, size=None
            ),
        ),
        migrations.RemoveField(
            model_name="forecast",
            name="net_profit_y1",
        ),
        migrations.RemoveField(
            model_name="forecast",
            name="net_profit_y2",
        ),
        migrations.RemoveField(
            model_name="forecast",
            name="net_profit_y3",
        ),
        migrations.RemoveField(
            model_name="forecast",
            name="net_profit_y4",
        ),
        migrations.RemoveField(
            model_name="forecast",
            name="net_profit_y5",
        ),
        migrations.AddField(
            model_name="forecast",
            name="adjusted_net_profit_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit Adjusted current fiscal year",
                null=True,
                verbose_name="Net Profit Adjusted Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="adjusted_net_profit_y2",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit Adjusted next fiscal year",
                null=True,
                verbose_name="Net Profit Adjusted (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="adjusted_net_profit_y3",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit Adjusted fiscal year + 2",
                null=True,
                verbose_name="Net Profit Adjusted (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="adjusted_net_profit_y4",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit Adjusted fiscal year + 3",
                null=True,
                verbose_name="Net Profit Adjusted (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="adjusted_net_profit_y5",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit Adjusted fiscal year + 4",
                null=True,
                verbose_name="Net Profit Adjusted (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="reported_net_profit_y1",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit Reported current fiscal year",
                null=True,
                verbose_name="Net Profit Reported Current FY (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="reported_net_profit_y2",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit Reported next fiscal year",
                null=True,
                verbose_name="Net Profit Reported (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="reported_net_profit_y3",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit Reported fiscal year + 2",
                null=True,
                verbose_name="Net Profit Reported (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="reported_net_profit_y4",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit Reported fiscal year + 3",
                null=True,
                verbose_name="Net Profit Reported (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="reported_net_profit_y5",
            field=models.FloatField(
                blank=True,
                help_text="Expected Net Profit Reported fiscal year + 4",
                null=True,
                verbose_name="Net Profit Reported (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="deal",
            name="external_id",
            field=models.CharField(blank=True, max_length=64, null=True),
        ),
        migrations.AddField(
            model_name="instrument",
            name="additional_urls",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.URLField(blank=True, null=True), blank=True, default=list, size=None
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="alternative_titles",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(blank=True, max_length=255, null=True), default=list, size=None
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="founded_year",
            field=models.IntegerField(blank=True, null=True, verbose_name="Founded Year"),
        ),
        migrations.AddField(
            model_name="instrument",
            name="headquarter_address",
            field=models.CharField(blank=True, help_text="The company Headquarter address", max_length=512, null=True),
        ),
        migrations.AddField(
            model_name="instrument",
            name="primary_url",
            field=models.URLField(blank=True, help_text="The Company website url", null=True),
        ),
        migrations.AlterField(
            model_name="deal",
            name="valuation",
            field=models.FloatField(
                blank=True,
                help_text="Valuation of the funded organization after this transaction (in Millions USD).",
                null=True,
                verbose_name="Valuaton",
            ),
        ),
        migrations.AlterField(
            model_name="deal",
            name="valuation_media_mention_source_urls",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.URLField(),
                blank=True,
                help_text="List of URLs used to source the valuation for the Media Mentions source type.",
                null=True,
                size=None,
            ),
        ),
        migrations.AlterField(
            model_name="deal",
            name="valuation_source_type",
            field=models.CharField(blank=True, help_text="The source type of the valuation", max_length=24, null=True),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="market_capitalization_consolidated",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="the consolidated market value of a company in local currency.",
                null=True,
                verbose_name="Market Capitalization (Consolidated)",
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="outstanding_shares_consolidated",
            field=wbcore.models.fields.DynamicDecimalField(
                blank=True,
                decimal_places=4,
                help_text="The amount of outstanding share for this instrument",
                max_digits=16,
                null=True,
                verbose_name="Outstanding Shares (Consolidated)",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="initial_high_water_mark",
            field=models.PositiveIntegerField(
                default=100, help_text="Initial High Water Mark", verbose_name="Initial High Water Mark"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_assets_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Return On Assets current fiscal year", null=True, verbose_name="ROA (%) (FY1e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_assets_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Return On Assets fiscal year +1", null=True, verbose_name="ROA (%) (FY2e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_assets_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Return On Assets fiscal year +2", null=True, verbose_name="ROA (%) (FY3e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_assets_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Return On Assets fiscal year +3", null=True, verbose_name="ROA (%) (FY4e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_assets_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Return On Assets fiscal year +4", null=True, verbose_name="ROA (%) (FY5e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_capital_employed_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Return on Capital Employed current fiscal year",
                null=True,
                verbose_name="ROCE (%) (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_capital_employed_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Return on Capital Employed fiscal year +1",
                null=True,
                verbose_name="ROCE (%) (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_capital_employed_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Return on Capital Employed fiscal year +2",
                null=True,
                verbose_name="ROCE (%) (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_capital_employed_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Return on Capital Employed fiscal year +3",
                null=True,
                verbose_name="ROCE (%) (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_capital_employed_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Return on Capital Employed fiscal year +4",
                null=True,
                verbose_name="ROCE (%) (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_equity_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Return on Equity current fiscal year", null=True, verbose_name="ROE (%) (FY1e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_equity_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Return on Equity fiscal year +1", null=True, verbose_name="ROE (%) (FY2e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_equity_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Return on Equity fiscal year +2", null=True, verbose_name="ROE (%) (FY3e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_equity_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Return on Equity fiscal year +3", null=True, verbose_name="ROE (%) (FY4e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_equity_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True, help_text="Return on Equity fiscal year +4", null=True, verbose_name="ROE (%) (FY5e)"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_invested_capital_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Return On Invested Capital current fiscal year",
                null=True,
                verbose_name="ROIC (%) (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_invested_capital_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Return On Invested Capital fiscal year +1",
                null=True,
                verbose_name="ROIC (%) (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_invested_capital_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Return On Invested Capital fiscal year +2",
                null=True,
                verbose_name="ROIC (%) (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_invested_capital_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Return On Invested Capital fiscal year +3",
                null=True,
                verbose_name="ROIC (%) (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="return_on_invested_capital_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Return On Invested Capital fiscal year +4",
                null=True,
                verbose_name="ROIC (%) (FY5e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="interest_coverage_ratio_y1",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Times Earnings Before Interest And Taxes pay interest current fiscal year",
                null=True,
                verbose_name="Interest Coverage Ratio (FY1e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="interest_coverage_ratio_y2",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Times Earnings Before Interest And Taxes pay interest fiscal year +1",
                null=True,
                verbose_name="Interest Coverage Ratio (FY2e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="interest_coverage_ratio_y3",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Times Earnings Before Interest And Taxes pay interest fiscal year +2",
                null=True,
                verbose_name="Interest Coverage Ratio (FY3e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="interest_coverage_ratio_y4",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Times Earnings Before Interest And Taxes pay interest fiscal year +3",
                null=True,
                verbose_name="Interest Coverage Ratio (FY4e)",
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="interest_coverage_ratio_y5",
            field=wbcore.models.fields.DynamicFloatField(
                blank=True,
                help_text="Times Earnings Before Interest And Taxes pay interest fiscal year +4",
                null=True,
                verbose_name="Interest Coverage Ratio (FY5e)",
            ),
        ),
        migrations.AddConstraint(
            model_name="assetposition",
            constraint=models.CheckConstraint(
                check=models.Q(("date__week_day__in", [1, 7]), _negated=True),
                name="wbportfolio_assetposition_weekday_constraint",
            ),
        ),
        migrations.RemoveField(
            model_name="classification",
            name="analyst_view",
        ),
        migrations.RemoveField(
            model_name="classification",
            name="macro_long_term",
        ),
        migrations.RemoveField(
            model_name="classification",
            name="macro_medium_term",
        ),
        migrations.RemoveField(
            model_name="classification",
            name="macro_short_term",
        ),
        migrations.RemoveField(
            model_name="product",
            name="theme",
        ),
        migrations.AlterField(
            model_name="research",
            name="iteration",
            field=models.PositiveIntegerField(default=0, verbose_name="Version"),
        ),
        migrations.AlterField(
            model_name="researchtopic",
            name="iteration",
            field=models.PositiveIntegerField(default=0, verbose_name="Version"),
        ),
        migrations.CreateModel(
            name="MutualFund",
            fields=[
                (
                    "instrument_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.instrument",
                    ),
                ),
            ],
            options={
                "verbose_name": "Mutual Fund",
                "verbose_name_plural": "Mutual Funds",
            },
            bases=("wbportfolio.instrument",),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="instrument_type",
            field=models.CharField(
                blank=True,
                choices=[
                    ("Product", "Product"),
                    ("Index", "Index"),
                    ("ProductGroup", "Product Group"),
                    ("MutualFund", "Mutual Fund"),
                    ("Equity", "Equity"),
                    ("ETF", "ETF"),
                    ("ETP", "ETP"),
                    ("Cash", "Cash"),
                    ("Option", "Option"),
                    ("Right", "Right"),
                    ("Bond", "Bond"),
                    ("InterestRateDerivative", "Interest Rate Derivate"),
                    ("Future", "Future"),
                    ("Forward", "Forward"),
                    ("Swap", "Swap"),
                    ("Coupon", "Coupon"),
                    ("Crypto", "Crypto"),
                    ("Commodity", "Commodity"),
                ],
                max_length=255,
                null=True,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentrequest",
            name="instrument_type",
            field=models.CharField(
                choices=[
                    ("Product", "Product"),
                    ("Index", "Index"),
                    ("ProductGroup", "Product Group"),
                    ("MutualFund", "Mutual Fund"),
                    ("Equity", "Equity"),
                    ("ETF", "ETF"),
                    ("ETP", "ETP"),
                    ("Cash", "Cash"),
                    ("Option", "Option"),
                    ("Right", "Right"),
                    ("Bond", "Bond"),
                    ("InterestRateDerivative", "Interest Rate Derivate"),
                    ("Future", "Future"),
                    ("Forward", "Forward"),
                    ("Swap", "Swap"),
                    ("Coupon", "Coupon"),
                    ("Crypto", "Crypto"),
                    ("Commodity", "Commodity"),
                ],
                max_length=255,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentrequest",
            name="created_instrument",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="creation_request",
                to="wbportfolio.instrument",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="instrumentportfoliothroughmodel",
            unique_together={("instrument", "portfolio")},
        ),
        migrations.AlterField(
            model_name="researchtopicrelationship",
            name="object_repr",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Relationship"),
        ),
        migrations.AddField(
            model_name="portfolio",
            name="is_invested",
            field=models.BooleanField(default=False),
        ),
        migrations.RemoveField(
            model_name="product",
            name="no_aggregation",
        ),
        migrations.AlterField(
            model_name="research",
            name="research_type",
            field=models.CharField(
                choices=[
                    ("ONE_TEXT", "One Sentence"),
                    ("TWO_TEXT", "Two Sentences"),
                    ("SWOT", "SWOT"),
                    ("OUTLOOK", "Outlook"),
                    ("PORTER_FIVE", "Porter Five"),
                    ("TEXT_LIST_RESEARCH", "Text List Research"),
                    ("OPTION_LIST_RESEARCH", "Option List Research"),
                    ("RELATIONSHIP", "Relationship"),
                    ("REFERENCE", "Reference"),
                    ("TIMELINE", "Timeline"),
                ],
                default="ONE_TEXT",
                max_length=32,
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="researchtopic",
            name="research_type",
            field=models.CharField(
                choices=[
                    ("ONE_TEXT", "One Sentence"),
                    ("TWO_TEXT", "Two Sentences"),
                    ("SWOT", "SWOT"),
                    ("OUTLOOK", "Outlook"),
                    ("PORTER_FIVE", "Porter Five"),
                    ("TEXT_LIST_RESEARCH", "Text List Research"),
                    ("OPTION_LIST_RESEARCH", "Option List Research"),
                    ("RELATIONSHIP", "Relationship"),
                    ("REFERENCE", "Reference"),
                    ("TIMELINE", "Timeline"),
                ],
                default="ONE_TEXT",
                max_length=32,
                verbose_name="Research Type",
            ),
        ),
        migrations.AddField(
            model_name="researchtopic",
            name="group",
            field=models.ManyToManyField(
                blank=True,
                help_text="If not specify, all employees will be able to update the search",
                related_name="research_topics_of_group",
                to="auth.group",
                verbose_name="Group allowed to update research",
            ),
        ),
        migrations.CreateModel(
            name="OptionListResearchTopic",
            fields=[
                (
                    "researchtopic_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbportfolio.researchtopic",
                    ),
                ),
                (
                    "options",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=32, verbose_name="Options"),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                ("multiple_choice", models.BooleanField(default=False, verbose_name="Multiple choice")),
            ],
            options={
                "verbose_name": "Option List Research Topic",
                "verbose_name_plural": "Option List Research Topics",
            },
            bases=("wbportfolio.researchtopic",),
        ),
        migrations.RemoveConstraint(
            model_name="researchtopicrelationship",
            name="unique_research_topic_relationship",
        ),
        migrations.AddConstraint(
            model_name="researchtopicrelationship",
            constraint=models.UniqueConstraint(
                fields=("topic", "content_type", "object_id", "object_repr"), name="unique_research_topic_relationship"
            ),
        ),
        migrations.AddField(
            model_name="research",
            name="changed",
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddConstraint(
            model_name="researchtopic",
            constraint=models.UniqueConstraint(fields=("name", "allowed_model"), name="unique_research_topic"),
        ),
        migrations.AlterField(
            model_name="researchtopic",
            name="name",
            field=models.CharField(max_length=255, verbose_name="Name"),
        ),
        migrations.AlterField(
            model_name="research",
            name="changed",
            field=models.DateField(auto_now=True),
        ),
        migrations.AlterModelOptions(
            name="tradeproposal",
            options={"verbose_name": "Trade Proposal", "verbose_name_plural": "Trade Proposals"},
        ),
        migrations.RenameField(
            model_name="trade",
            old_name="delta_weight",
            new_name="weighting",
        ),
        migrations.RemoveField(
            model_name="trade",
            name="effective_weight",
        ),
        migrations.RemoveField(
            model_name="trade",
            name="target_weight",
        ),
        migrations.AlterUniqueTogether(
            name="tradeproposal",
            unique_together={("portfolio", "trade_date")},
        ),
        migrations.AlterField(
            model_name="trade",
            name="weighting",
            field=models.DecimalField(
                decimal_places=6,
                default=Decimal("0"),
                help_text="The weight to be multiplied against the target",
                max_digits=16,
                verbose_name="Weight",
            ),
        ),
        migrations.RemoveField(
            model_name="fundamental",
            name="computed_str",
        ),
        migrations.RemoveField(
            model_name="geographicsegment",
            name="computed_str",
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="initial_shares",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="The amount of Units of the Asset on the price date of the Asset.",
                max_digits=18,
                null=True,
                verbose_name="Initial Quantity",
            ),
        ),
        migrations.AddField(
            model_name="assetposition",
            name="import_source",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
            ),
        ),
        migrations.AddField(
            model_name="dailyfundamental",
            name="import_source",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
            ),
        ),
        migrations.AddField(
            model_name="deal",
            name="import_source",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
            ),
        ),
        migrations.AddField(
            model_name="fiscalperiod",
            name="import_source",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
            ),
        ),
        migrations.AddField(
            model_name="forecast",
            name="import_source",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
            ),
        ),
        migrations.AddField(
            model_name="fundamental",
            name="import_source",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
            ),
        ),
        migrations.AddField(
            model_name="geographicsegment",
            name="import_source",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="import_source",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
            ),
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="import_source",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
            ),
        ),
        migrations.AddField(
            model_name="register",
            name="import_source",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
            ),
        ),
        migrations.AddField(
            model_name="splitdata",
            name="import_source",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
            ),
        ),
        migrations.AddField(
            model_name="transaction",
            name="import_source",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
            ),
        ),
        migrations.AddField(
            model_name="exchange",
            name="city",
            field=models.ForeignKey(
                blank=True,
                help_text="The city where this Exchange is located at.",
                limit_choices_to={"level": 3},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="portfolio_exchanges_city",
                to="geography.geography",
                verbose_name="City",
            ),
        ),
        migrations.AddField(
            model_name="exchange",
            name="country",
            field=models.ForeignKey(
                blank=True,
                help_text="The country where this exchange is located at.",
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="portfolio_exchanges_country",
                to="geography.geography",
                verbose_name="Country",
            ),
        ),
        migrations.AddField(
            model_name="geographicfocus",
            name="country",
            field=models.ForeignKey(
                default=None,
                on_delete=django.db.models.deletion.PROTECT,
                to="geography.geography",
                verbose_name="Location",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="instrument",
            name="country",
            field=models.ForeignKey(
                blank=True,
                help_text="Country in which this instrument is issued and bonded by law. The country of jurisdiction.",
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="instruments",
                to="geography.geography",
                verbose_name="Country",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="jurisdiction",
            field=models.ForeignKey(
                blank=True,
                help_text="The country of jurisdiction",
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products",
                to="geography.geography",
                verbose_name="Country on which this product is issued and bonded by law",
            ),
        ),
        migrations.AddField(
            model_name="productgrouprepresentant",
            name="country",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="geography.geography",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="register",
            name="citizenship",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="register_citizenship_registers",
                to="geography.geography",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="register",
            name="custodian_country",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="register_custodian_country_registers",
                to="geography.geography",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="register",
            name="outlet_country",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="register_outlet_country_registers",
                to="geography.geography",
            ),
        ),
        migrations.AddField(
            model_name="register",
            name="residence",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="register_residence_registers",
                to="geography.geography",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="register",
            name="custodian_city",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 3},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="register_custodian_city_registers",
                to="geography.geography",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="register",
            name="outlet_city",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 3},
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="register_outlet_city_registers",
                to="geography.geography",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="headquarter_city",
            field=models.ForeignKey(
                blank=True,
                help_text="The company's headquarter city",
                limit_choices_to={"level": 3},
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="headquarters_of",
                to="geography.geography",
                verbose_name="Headquarter City",
            ),
        ),
        migrations.AddConstraint(
            model_name="productgrouprepresentant",
            constraint=models.UniqueConstraint(
                fields=("product_group", "country"), name="unique_country_product_group"
            ),
        ),
        migrations.AlterField(
            model_name="exchange",
            name="city",
            field=models.ForeignKey(
                blank=True,
                help_text="The city where this Exchange is located at.",
                limit_choices_to={"level": 3},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="portfolio_exchanges_city",
                to="geography.geography",
                verbose_name="City",
            ),
        ),
        migrations.AlterField(
            model_name="exchange",
            name="country",
            field=models.ForeignKey(
                blank=True,
                help_text="The country where this exchange is located at.",
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="portfolio_exchanges_country",
                to="geography.geography",
                verbose_name="Country",
            ),
        ),
        migrations.AlterField(
            model_name="geographicfocus",
            name="country",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="geography.geography", verbose_name="Location"
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="country",
            field=models.ForeignKey(
                blank=True,
                help_text="Country in which this instrument is issued and bonded by law. The country of jurisdiction.",
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="instruments",
                to="geography.geography",
                verbose_name="Country",
            ),
        ),
        migrations.AlterField(
            model_name="instrument",
            name="headquarter_city",
            field=models.ForeignKey(
                blank=True,
                help_text="The company's headquarter city",
                limit_choices_to={"level": 3},
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="headquarters_of",
                to="geography.geography",
                verbose_name="Headquarter City",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="jurisdiction",
            field=models.ForeignKey(
                blank=True,
                help_text="The country of jurisdiction",
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products",
                to="geography.geography",
                verbose_name="Country on which this product is issued and bonded by law",
            ),
        ),
        migrations.AlterField(
            model_name="productgrouprepresentant",
            name="country",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="geography.geography",
            ),
        ),
        migrations.AlterField(
            model_name="register",
            name="citizenship",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="register_citizenship_registers",
                to="geography.geography",
            ),
        ),
        migrations.AlterField(
            model_name="register",
            name="custodian_city",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 3},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="register_custodian_city_registers",
                to="geography.geography",
            ),
        ),
        migrations.AlterField(
            model_name="register",
            name="custodian_country",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="register_custodian_country_registers",
                to="geography.geography",
            ),
        ),
        migrations.AlterField(
            model_name="register",
            name="outlet_city",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 3},
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="register_outlet_city_registers",
                to="geography.geography",
            ),
        ),
        migrations.AlterField(
            model_name="register",
            name="outlet_country",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="register_outlet_country_registers",
                to="geography.geography",
            ),
        ),
        migrations.AlterField(
            model_name="register",
            name="residence",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 1},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="register_residence_registers",
                to="geography.geography",
            ),
        ),
        migrations.AddField(
            model_name="assetposition",
            name="currency",
            field=models.ForeignKey(
                help_text="The Currency of the Asset.",
                on_delete=django.db.models.deletion.PROTECT,
                related_name="portfolio_currencies_asset",
                to="currency.currency",
                verbose_name="Currency",
            ),
        ),
        migrations.AddField(
            model_name="assetposition",
            name="currency_fx_rate_instrument_to_usd",
            field=models.ForeignKey(
                blank=True,
                help_text="Rate to between instrument currency and USD",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="instrument_assets",
                to="currency.currencyfxrates",
                verbose_name="Instrument Currency Rate",
            ),
        ),
        migrations.AddField(
            model_name="assetposition",
            name="currency_fx_rate_portfolio_to_usd",
            field=models.ForeignKey(
                blank=True,
                help_text="Rate to between portfolio currency and USD",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="portfolio_assets",
                to="currency.currencyfxrates",
                verbose_name="Portfolio Currency Rate",
            ),
        ),
        migrations.AddField(
            model_name="companyportfoliodata",
            name="assets_under_management_currency",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="currency.currency",
                verbose_name="AUM Currency",
            ),
        ),
        migrations.AddField(
            model_name="companyportfoliodata",
            name="potential_currency",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="wbportfolio_potential_currencies",
                to="currency.currency",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="currency",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="instruments",
                to="currency.currency",
                verbose_name="Currency",
            ),
        ),
        migrations.AddField(
            model_name="portfolio",
            name="currency",
            field=models.ForeignKey(
                help_text="The currency of the portfolio.",
                on_delete=django.db.models.deletion.PROTECT,
                related_name="portfolios",
                to="currency.currency",
                verbose_name="Currency",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="index_hedged_currency",
            field=models.ForeignKey(
                blank=True,
                help_text="The currency upon to which the product's strategies is hedged. Default to None",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="hedged_products",
                to="currency.currency",
                verbose_name="Index Hedged Currency",
            ),
        ),
        migrations.AddField(
            model_name="transaction",
            name="currency",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="transactions",
                to="currency.currency",
                verbose_name="Currency",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="tags",
            field=models.ManyToManyField(blank=True, related_name="%(app_label)s_%(class)s_items", to="tags.tag"),
        ),
        migrations.AddField(
            model_name="instrumentclassificationthroughmodel",
            name="tags",
            field=models.ManyToManyField(blank=True, related_name="%(app_label)s_%(class)s_items", to="tags.tag"),
        ),
        migrations.AddField(
            model_name="assetallocation",
            name="company",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="asset_allocations", to="directory.company"
            ),
        ),
        migrations.AddField(
            model_name="companyportfoliodata",
            name="company",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, related_name="portfolio_data", to="directory.company"
            ),
        ),
        migrations.AddField(
            model_name="custodian",
            name="company",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="custodians",
                to="directory.company",
            ),
        ),
        migrations.AddField(
            model_name="geographicfocus",
            name="company",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="geographic_focuses", to="directory.company"
            ),
        ),
        migrations.AddField(
            model_name="instrumentfavoritegroup",
            name="owner",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="favorite_instruments_groups",
                to="directory.person",
            ),
        ),
        migrations.AddField(
            model_name="instrumentrequest",
            name="handler",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="handled_instrument_requests",
                to="directory.person",
                verbose_name="Handler",
            ),
        ),
        migrations.AddField(
            model_name="instrumentrequest",
            name="requester",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="instrument_requests",
                to="directory.person",
                verbose_name="Requester",
            ),
        ),
        migrations.AddField(
            model_name="portfoliorole",
            name="person",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="portfolio_roles",
                to="directory.person",
                verbose_name="Person",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="bank",
            field=models.ForeignKey(
                help_text="The Bank that holds the product. A company from the CRM.",
                on_delete=django.db.models.deletion.PROTECT,
                related_name="issues_products",
                to="directory.company",
                verbose_name="Bank",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="white_label_customers",
            field=models.ManyToManyField(
                blank=True,
                help_text="Specifies whether a product is a white label product or not. If at least one customer is specified, this product becomes a white label product and can only be seen by the respected customers.",
                related_name="white_label_customer_products",
                to="directory.entry",
                verbose_name="White Label Customers",
            ),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="administrator",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="administrator_groups",
                to="directory.company",
            ),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="auditor",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="auditor_groups",
                to="directory.company",
            ),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="depositary",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="depositary_product_groups",
                to="directory.company",
            ),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="investment_manager",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="investment_manager_groups",
                to="directory.company",
            ),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="management_company",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="management_company_product_groups",
                to="directory.company",
            ),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="paying_agent",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="paying_agent_groups",
                to="directory.company",
            ),
        ),
        migrations.AddField(
            model_name="productgroup",
            name="transfer_agent",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="transfer_agent_product_groups",
                to="directory.company",
            ),
        ),
        migrations.AddField(
            model_name="productgrouprepresentant",
            name="representant",
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to="directory.company"),
        ),
        migrations.AddField(
            model_name="relationshipresearch",
            name="entry",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="entries_relationship_researches",
                to="directory.entry",
                verbose_name="Relationship From",
            ),
        ),
        migrations.AddField(
            model_name="splitdata",
            name="last_handler",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_handled_splits",
                to="directory.person",
            ),
        ),
        migrations.AddField(
            model_name="tradeproposal",
            name="creator",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="trade_proposals",
                to="directory.person",
                verbose_name="Owner",
            ),
        ),
        migrations.RemoveField(
            model_name="classificationperformanceanalysis",
            name="classification",
        ),
        migrations.RemoveField(
            model_name="instrumentperformanceanalysis",
            name="classification",
        ),
        migrations.RemoveField(
            model_name="instrumentperformanceanalysis",
            name="instrument",
        ),
        migrations.RemoveField(
            model_name="instrumentperformanceanalysis",
            name="performance_peers",
        ),
        migrations.RemoveField(
            model_name="theme",
            name="benchmarks",
        ),
        migrations.RemoveField(
            model_name="theme",
            name="classification",
        ),
        migrations.RemoveField(
            model_name="theme",
            name="composite",
        ),
        migrations.RemoveField(
            model_name="theme",
            name="model_portfolio",
        ),
        migrations.RemoveField(
            model_name="theme",
            name="peers",
        ),
        migrations.RemoveField(
            model_name="theme",
            name="products",
        ),
        migrations.DeleteModel(
            name="AddressableMarket",
        ),
        migrations.DeleteModel(
            name="ClassificationPerformanceAnalysis",
        ),
        migrations.DeleteModel(
            name="InstrumentPerformanceAnalysis",
        ),
        migrations.DeleteModel(
            name="Theme",
        ),
    ]
