# Generated by Django 4.1.9 on 2023-07-19 07:11

from decimal import Decimal

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("wbportfolio", "0042_instrumentlist_instrumentlistthroughmodel_and_more"),
        ("currency", "0001_initial"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="instrumentlistthroughmodel",
            options={"verbose_name": "Instrument in Instrument List"},
        ),
        migrations.RemoveField(
            model_name="instrumentlist",
            name="instruments",
        ),
        migrations.AddField(
            model_name="instrumentlistthroughmodel",
            name="instrument_str",
            field=models.CharField(default="", max_length=256),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="instrumentlistthroughmodel",
            name="instrument",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="wbportfolio.instrument"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="instrumentprice",
            unique_together={("instrument", "date", "calculated")},
        ),
        migrations.AddField(
            model_name="instrumentprice",
            name="currency_fx_rate_to_usd",
            field=models.ForeignKey(
                blank=True,
                help_text="Rate to between instrument currency and USD",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="instrument_prices",
                to="currency.currencyfxrates",
                verbose_name="Instrument Currency Rate",
            ),
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="ask",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="bid",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="bid_rate",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="close",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="currency_fx_usd",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="custom_beta_180d",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="custom_beta_1y",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="custom_beta_2y",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="custom_beta_3y",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="custom_beta_5y",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="dividend_yield",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="free_float",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="free_float_ratio",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="high",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="interest_rate",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="low",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="market_capitalization_usd",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="net_return",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="net_value_usd",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="offered_rate",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="open",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="performance_1d",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="performance_30d",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="performance_365d",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="performance_7d",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="performance_90d",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="performance_inception",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="performance_ytd",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="price_earning",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="price_index",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="short_interest",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="short_interest_ratio",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="total_return_index",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="volume_50d_usd",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="volume_usd",
        ),
        migrations.RemoveField(
            model_name="instrumentprice",
            name="yield_redemption",
        ),
        migrations.RenameModel(old_name="SplitData", new_name="Adjustment"),
        migrations.RenameField(model_name="assetposition", old_name="applied_split", new_name="applied_adjustment"),
        migrations.AlterModelOptions(
            name="adjustment",
            options={"verbose_name": "Datum Adjustment", "verbose_name_plural": "Data Adjustment"},
        ),
        migrations.AlterField(
            model_name="adjustment",
            name="cumulative_factor",
            field=models.DecimalField(
                decimal_places=17, default=Decimal("1"), max_digits=30, verbose_name="Cumulative Factor"
            ),
        ),
        migrations.AlterField(
            model_name="adjustment",
            name="factor",
            field=models.DecimalField(decimal_places=17, default=Decimal("1"), max_digits=30, verbose_name="Factor"),
        ),
        migrations.AlterField(
            model_name="adjustment",
            name="last_handler",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_handled_adjustments",
                to="directory.person",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="applied_adjustment",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="adjustmented_assets",
                to="wbportfolio.adjustment",
            ),
        ),
    ]
