# Generated by Django 4.1.9 on 2023-06-27 07:21

import django.db.models.deletion
import django_fsm
import wbcore.utils.strings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("wbcrm", "0005_account_accountrole_accountroletype_and_more"),
        ("wbportfolio", "0045_alter_instrument_financial_instrument"),
    ]

    operations = [
        migrations.AddField(
            model_name="product",
            name="default_account",
            field=models.ForeignKey(
                blank=True,
                help_text="If a default Account is set, then all newly created tradesare automatically matched to this sub account.",
                limit_choices_to=models.Q(("is_terminal_account", True)),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="default_product_accounts",
                to="wbcrm.account",
                verbose_name="Default Account",
            ),
        ),
        migrations.CreateModel(
            name="Claim",
            fields=[
                (
                    "id",
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID"),
                ),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("APPROVED", "Approved"),
                            ("WITHDRAWN", "Withdrawn"),
                            ("DRAFT", "Draft"),
                            ("AUTO_MATCHED", "Auto-Matched"),
                        ],
                        default="DRAFT",
                        max_length=50,
                        verbose_name="Status",
                    ),
                ),
                ("date", models.DateField(verbose_name="Date")),
                ("bank", models.CharField(blank=True, max_length=255, verbose_name="Bank")),
                (
                    "reference",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Reference"),
                ),
                (
                    "shares",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="The amount of shares purchased / sold.",
                        max_digits=15,
                        null=True,
                        verbose_name="Shares",
                    ),
                ),
                (
                    "nominal_amount",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="The nominal amount purchased / sold. Either shares or nominal_amount has to be provided.",
                        max_digits=15,
                        null=True,
                        verbose_name="Nominal Amount",
                    ),
                ),
                (
                    "external_id",
                    models.CharField(
                        blank=True,
                        help_text="An External ID to reference a claim.",
                        max_length=255,
                        null=True,
                        verbose_name="External Identifier",
                    ),
                ),
                (
                    "account",
                    models.ForeignKey(
                        blank=True,
                        limit_choices_to=models.Q(("is_terminal_account", True)),
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="claims",
                        to="wbcrm.account",
                        verbose_name="Account",
                    ),
                ),
                (
                    "claimant",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="claimed",
                        to="directory.entry",
                        verbose_name="Claimant",
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="claims_created",
                        to="directory.entry",
                        verbose_name="Creator",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="claims",
                        to="wbportfolio.product",
                        verbose_name="Product",
                    ),
                ),
                (
                    "trade",
                    models.ForeignKey(
                        blank=True,
                        help_text="Please select a Product first. The customer-trade the claim is consolidated against. The customer-trade and the claim don't necessarily have to have the same date, number of shares, etc.",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="claims",
                        to="wbportfolio.trade",
                        verbose_name="Trade",
                    ),
                ),
            ],
            options={
                "verbose_name": "Claim",
                "verbose_name_plural": "Claims",
            },
            bases=(wbcore.utils.strings.ReferenceIDMixin, models.Model),
        ),
        migrations.AlterField(
            model_name="portfoliorole",
            name="role_type",
            field=models.CharField(
                choices=[
                    ("MANAGER", "Manager"),
                    ("RISK_MANAGER", "Risk Manager"),
                    ("PORTFOLIO_MANAGER", "Portfolio Manager"),
                    ("ANALYST", "Analyst"),
                ],
                max_length=24,
                verbose_name="Type",
            ),
        ),
    ]
