# Generated by Django 4.2.8 on 2023-12-18 13:46

import django.db.models.deletion
from django.db import migrations, models


def migrate_productgroup_to_parent(apps, schema_editor):
    ProductGroup = apps.get_model("wbportfolio", "ProductGroup")
    Product = apps.get_model("wbportfolio", "Product")
    Instrument = apps.get_model("wbfdm", "Instrument")
    for product_group in ProductGroup.objects.all():
        for product in Product.objects.filter(group=product_group):
            instrument = Instrument.objects.get(id=product.instrument_ptr_id)
            instrument.parent_id = product_group.instrument_ptr_id
            instrument.save()


class Migration(migrations.Migration):
    dependencies = [
        ("wbfdm", "0012_instrumentprice_created_instrumentprice_modified"),
        ("wbportfolio", "0052_remove_cash_instrument_ptr_and_more"),
    ]

    operations = [
        migrations.RunPython(migrate_productgroup_to_parent),
        migrations.RemoveField(
            model_name="product",
            name="group",
        ),
        migrations.AlterField(
            model_name="adjustment",
            name="instrument",
            field=models.ForeignKey(
                limit_choices_to=models.Q(("children__isnull", True)),
                on_delete=django.db.models.deletion.CASCADE,
                related_name="pms_adjustments",
                to="wbfdm.instrument",
            ),
        ),
        migrations.AlterField(
            model_name="assetposition",
            name="underlying_instrument",
            field=models.ForeignKey(
                help_text="The instrument that is this asset.",
                limit_choices_to=models.Q(("children__isnull", True)),
                on_delete=django.db.models.deletion.PROTECT,
                related_name="assets",
                to="wbfdm.instrument",
                verbose_name="Underlying Instrument",
            ),
        ),
        migrations.AlterField(
            model_name="portfoliorole",
            name="instrument",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to=models.Q(("children__isnull", True)),
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="portfolio_roles",
                to="wbfdm.instrument",
                verbose_name="Instrument",
            ),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="underlying_instrument",
            field=models.ForeignKey(
                help_text="The instrument that is this transaction.",
                limit_choices_to=models.Q(("children__isnull", True)),
                on_delete=django.db.models.deletion.PROTECT,
                related_name="transactions",
                to="wbfdm.instrument",
                verbose_name="Underlying Instrument",
            ),
        ),
        migrations.AlterField(
            model_name="portfolio",
            name="prefered_instrument_classifications",
            field=models.ManyToManyField(
                blank=True,
                limit_choices_to=models.Q(("instrument_type__is_classifiable", True)),
                related_name="prefered_portfolio_classifications",
                through="wbportfolio.PortfolioInstrumentPreferedClassificationThroughModel",
                to="wbfdm.instrument",
                verbose_name="The Prefered classification per instrument",
            ),
        ),
        migrations.AlterField(
            model_name="portfolioinstrumentpreferedclassificationthroughmodel",
            name="instrument",
            field=models.ForeignKey(
                limit_choices_to=models.Q(("instrument_type__is_classifiable", True)),
                on_delete=django.db.models.deletion.CASCADE,
                related_name="prefered_classification_portfolio",
                to="wbfdm.instrument",
            ),
        ),
        migrations.AlterField(
            model_name="instrumentportfoliothroughmodel",
            name="instrument",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    ("instrument_type__key", "product"),
                    ("instrument_type__key", "index"),
                    ("instrument_type__key", "product_group"),
                    _connector="OR",
                ),
                on_delete=django.db.models.deletion.CASCADE,
                related_name="through_portfolios",
                to="wbfdm.instrument",
            ),
        ),
        migrations.AlterField(
            model_name="portfolio",
            name="instruments",
            field=models.ManyToManyField(
                blank=True,
                help_text="Instruments linked to this instrument",
                limit_choices_to=models.Q(
                    ("instrument_type__key", "product"),
                    ("instrument_type__key", "index"),
                    ("instrument_type__key", "product_group"),
                    _connector="OR",
                ),
                related_name="portfolios",
                through="wbportfolio.InstrumentPortfolioThroughModel",
                to="wbfdm.instrument",
                verbose_name="Instruments",
            ),
        ),
    ]
