# Generated by Django 5.0.6 on 2024-06-06 08:55

from decimal import Decimal

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("directory", "0008_bankingcontact_access"),
        ("io", "0007_alter_exportsource_query_params"),
        ("wbportfolio", "0060_alter_portfolioportfoliothroughmodel_type"),
    ]

    operations = [
        migrations.AddField(
            model_name="portfolio",
            name="bank_accounts",
            field=models.ManyToManyField(
                blank=True, related_name="wbportfolio_portfolios", to="directory.bankingcontact"
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="bank_account",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="wbportfolio_products",
                to="directory.bankingcontact",
            ),
        ),
        migrations.CreateModel(
            name="PortfolioCashTarget",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("valid_date", models.DateField()),
                ("min_target", models.DecimalField(blank=True, decimal_places=4, max_digits=5, null=True)),
                ("target", models.DecimalField(decimal_places=4, default=Decimal("0"), max_digits=5)),
                ("max_target", models.DecimalField(blank=True, decimal_places=4, max_digits=5, null=True)),
                ("comment", models.TextField(blank=True, default="")),
                (
                    "portfolio",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="cash_targets",
                        to="wbportfolio.portfolio",
                    ),
                ),
            ],
            options={
                "verbose_name": "Portfolio Cash Target",
                "verbose_name_plural": "Portfolio Cash Targets",
            },
        ),
        migrations.CreateModel(
            name="PortfolioSwingPricing",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("valid_date", models.DateField()),
                ("negative_threshold", models.DecimalField(decimal_places=4, max_digits=4)),
                ("negative_swing_factor", models.DecimalField(decimal_places=4, max_digits=4)),
                ("positive_threshold", models.DecimalField(decimal_places=4, max_digits=4)),
                ("positive_swing_factor", models.DecimalField(decimal_places=4, max_digits=4)),
                (
                    "portfolio",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="swing_pricings",
                        to="wbportfolio.portfolio",
                    ),
                ),
            ],
            options={
                "verbose_name": "Portfolio Swing Pricing",
                "verbose_name_plural": "Portfolio Swing Pricings",
            },
        ),
        migrations.CreateModel(
            name="DailyPortfolioCashFlow",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("pending", models.BooleanField(default=False)),
                ("value_date", models.DateField()),
                ("cash", models.DecimalField(blank=True, decimal_places=4, max_digits=19)),
                (
                    "cash_flow_forecast",
                    models.DecimalField(blank=True, decimal_places=4, default=Decimal("0"), max_digits=19),
                ),
                ("total_assets", models.DecimalField(blank=True, decimal_places=4, max_digits=19)),
                (
                    "min_target_cash_pct",
                    models.DecimalField(blank=True, decimal_places=4, default=Decimal("0"), max_digits=4),
                ),
                (
                    "target_cash_pct",
                    models.DecimalField(blank=True, decimal_places=4, default=Decimal("0"), max_digits=4),
                ),
                (
                    "max_target_cash_pct",
                    models.DecimalField(blank=True, decimal_places=4, default=Decimal("0"), max_digits=4),
                ),
                ("estimated_total_assets", models.DecimalField(blank=True, decimal_places=4, max_digits=19)),
                ("cash_flow_asset_ratio", models.DecimalField(blank=True, decimal_places=4, max_digits=5)),
                ("true_cash", models.DecimalField(blank=True, decimal_places=4, max_digits=19)),
                ("cash_pct", models.DecimalField(blank=True, decimal_places=4, max_digits=5)),
                ("true_cash_pct", models.DecimalField(blank=True, decimal_places=4, max_digits=5)),
                ("target_cash", models.DecimalField(blank=True, decimal_places=4, max_digits=19)),
                ("excess_cash", models.DecimalField(blank=True, decimal_places=4, max_digits=19)),
                (
                    "proposed_rebalancing",
                    models.DecimalField(blank=True, decimal_places=4, default=Decimal("0"), max_digits=19),
                ),
                (
                    "rebalancing",
                    models.DecimalField(blank=True, decimal_places=4, default=Decimal("0"), max_digits=19),
                ),
                ("comment", models.TextField(blank=True, default="")),
                (
                    "import_source",
                    models.ForeignKey(
                        blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
                    ),
                ),
                (
                    "portfolio",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="daily_cashflows",
                        to="wbportfolio.portfolio",
                    ),
                ),
                (
                    "swing_pricing",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="cash_flow",
                        to="wbportfolio.portfolioswingpricing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Daily Portfolio CashFlow",
                "verbose_name_plural": "Daily Portfolio CashFlow",
            },
        ),
        migrations.AddConstraint(
            model_name="portfoliocashtarget",
            constraint=models.UniqueConstraint(fields=("portfolio", "valid_date"), name="unique_portfolio_valid_date"),
        ),
        migrations.AddConstraint(
            model_name="portfolioswingpricing",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("negative_threshold__lt", 0),
                    ("negative_swing_factor__lt", 0),
                    ("positive_threshold__gt", 0),
                    ("positive_swing_factor__gt", 0),
                ),
                name="value_polarity",
            ),
        ),
        migrations.AddConstraint(
            model_name="portfolioswingpricing",
            constraint=models.UniqueConstraint(fields=("valid_date", "portfolio"), name="unique_valid_date_portfolio"),
        ),
        migrations.AddConstraint(
            model_name="dailyportfoliocashflow",
            constraint=models.UniqueConstraint(fields=("portfolio", "value_date"), name="unique_portfolio_value_date"),
        ),
    ]
