# Generated by Django 5.0.6 on 2024-07-19 14:20

from decimal import Decimal

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("wbcrm", "0009_alter_account_is_public"),
        ("wbportfolio", "0062_alter_dailyportfoliocashflow_options"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="AccountReconciliation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("reconciliation_date", models.DateField()),
                ("approved_dt", models.DateTimeField(blank=True, null=True, verbose_name="Approved Timestamp")),
                (
                    "account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="wbportfolio_reconciliations",
                        to="wbcrm.account",
                    ),
                ),
                (
                    "approved_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Approved By",
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, related_name="+", to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
            options={
                "verbose_name": "Account Holdings Reconciliation",
                "verbose_name_plural": "Account Holdings Reconciliations",
                "notification_types": [
                    (
                        "wbportfolio.account_reconciliation.notify",
                        "Account Reconciliation Events",
                        "A notification that informs the user about an account reconciliation event.",
                        True,
                        True,
                        True,
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="AccountReconciliationLine",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "price",
                    models.DecimalField(
                        decimal_places=4,
                        default=Decimal("0"),
                        help_text="The last share price of the product",
                        max_digits=18,
                    ),
                ),
                ("price_date", models.DateField()),
                (
                    "shares",
                    models.IntegerField(default=0, help_text="The number of shares computed through the Workbench"),
                ),
                (
                    "nominal_value",
                    models.IntegerField(default=0, help_text="The nominal value computed through the Workbench"),
                ),
                (
                    "shares_external",
                    models.IntegerField(
                        default=0,
                        help_text="The number of shares externally provided through the Account holder. Initially set to the number of shares computed through the Workbench",
                    ),
                ),
                (
                    "nominal_value_external",
                    models.IntegerField(
                        default=0,
                        help_text="The nominal value externally provided through the Account holder. Initially set to the number of shares computed through the Workbench",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="account_reconciliation_lines",
                        to="wbportfolio.product",
                    ),
                ),
                (
                    "reconciliation",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="lines",
                        to="wbportfolio.accountreconciliation",
                    ),
                ),
            ],
            options={
                "verbose_name": "Account Reconciliation (Product)",
                "verbose_name_plural": "Account Reconciliation (Products)",
            },
        ),
        migrations.AddConstraint(
            model_name="accountreconciliation",
            constraint=models.UniqueConstraint(fields=("reconciliation_date", "account"), name="unique_date_account"),
        ),
        migrations.AddConstraint(
            model_name="accountreconciliationline",
            constraint=models.UniqueConstraint(
                fields=("reconciliation", "product"), name="unique_reconcilation_product"
            ),
        ),
    ]
