# Generated by Django 5.0.9 on 2024-10-16 12:15

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("wbportfolio", "0067_assetposition_unique_asset_position"),
    ]

    operations = [
        migrations.AddField(
            model_name="trade",
            name="internal_trade",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="internal_subscription_redemption_trade",
                to="wbportfolio.trade",
            ),
        ),
        migrations.AddField(
            model_name="trade",
            name="marked_as_internal",
            field=models.BooleanField(
                default=False,
                help_text="If this is checked, then this subscription or redemption is considered internal and will not be considered in any AUM computation",
                verbose_name="Internal",
            ),
        ),
        migrations.AddConstraint(
            model_name="trade",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("marked_as_internal", False),
                    models.Q(
                        ("marked_as_internal", True), ("transaction_subtype__in", ["REDEMPTION", "SUBSCRIPTION"])
                    ),
                    _connector="OR",
                ),
                name="marked_as_internal_only_for_subred",
            ),
        ),
        migrations.AddConstraint(
            model_name="trade",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("internal_trade__isnull", True),
                    models.Q(
                        ("internal_trade__isnull", False), ("transaction_subtype__in", ["REDEMPTION", "SUBSCRIPTION"])
                    ),
                    _connector="OR",
                ),
                name="internal_trade_set_only_for_subred",
            ),
        ),
    ]
