# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppArgs', 'App']

@pulumi.input_type
class AppArgs:
    def __init__(__self__, *,
                 budget_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 no_compute: Optional[pulumi.Input[builtins.bool]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input['AppResourceArgs']]]] = None,
                 user_api_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a App resource.
        :param pulumi.Input[builtins.str] budget_policy_id: The Budget Policy ID set for this resource.
        :param pulumi.Input[builtins.str] description: The description of the app.
        :param pulumi.Input[builtins.str] name: The name of the app. The name must contain only lowercase alphanumeric characters and hyphens. It must be unique within the workspace.
        :param pulumi.Input[Sequence[pulumi.Input['AppResourceArgs']]] resources: A list of resources that the app have access to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_api_scopes: A list of api scopes granted to the user access token.
        """
        if budget_policy_id is not None:
            pulumi.set(__self__, "budget_policy_id", budget_policy_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_compute is not None:
            pulumi.set(__self__, "no_compute", no_compute)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if user_api_scopes is not None:
            pulumi.set(__self__, "user_api_scopes", user_api_scopes)

    @property
    @pulumi.getter(name="budgetPolicyId")
    def budget_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Budget Policy ID set for this resource.
        """
        return pulumi.get(self, "budget_policy_id")

    @budget_policy_id.setter
    def budget_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "budget_policy_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the app.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the app. The name must contain only lowercase alphanumeric characters and hyphens. It must be unique within the workspace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="noCompute")
    def no_compute(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "no_compute")

    @no_compute.setter
    def no_compute(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "no_compute", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppResourceArgs']]]]:
        """
        A list of resources that the app have access to.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppResourceArgs']]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="userApiScopes")
    def user_api_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of api scopes granted to the user access token.
        """
        return pulumi.get(self, "user_api_scopes")

    @user_api_scopes.setter
    def user_api_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_api_scopes", value)


@pulumi.input_type
class _AppState:
    def __init__(__self__, *,
                 active_deployment: Optional[pulumi.Input['AppActiveDeploymentArgs']] = None,
                 app_status: Optional[pulumi.Input['AppAppStatusArgs']] = None,
                 budget_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_status: Optional[pulumi.Input['AppComputeStatusArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 creator: Optional[pulumi.Input[builtins.str]] = None,
                 default_source_code_path: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_budget_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 effective_user_api_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 no_compute: Optional[pulumi.Input[builtins.bool]] = None,
                 oauth2_app_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 oauth2_app_integration_id: Optional[pulumi.Input[builtins.str]] = None,
                 pending_deployment: Optional[pulumi.Input['AppPendingDeploymentArgs']] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input['AppResourceArgs']]]] = None,
                 service_principal_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[builtins.int]] = None,
                 service_principal_name: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 updater: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 user_api_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering App resources.
        :param pulumi.Input['AppAppStatusArgs'] app_status: attribute
        :param pulumi.Input[builtins.str] budget_policy_id: The Budget Policy ID set for this resource.
        :param pulumi.Input['AppComputeStatusArgs'] compute_status: attribute
        :param pulumi.Input[builtins.str] create_time: The creation time of the app.
        :param pulumi.Input[builtins.str] creator: The email of the user that created the app.
        :param pulumi.Input[builtins.str] default_source_code_path: The default workspace file system path of the source code from which app deployment are created. This field tracks the workspace source code path of the last active deployment.
        :param pulumi.Input[builtins.str] description: The description of the app.
        :param pulumi.Input[builtins.str] effective_budget_policy_id: The effective budget policy ID.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] effective_user_api_scopes: A list of effective api scopes granted to the user access token.
        :param pulumi.Input[builtins.str] name: The name of the app. The name must contain only lowercase alphanumeric characters and hyphens. It must be unique within the workspace.
        :param pulumi.Input[Sequence[pulumi.Input['AppResourceArgs']]] resources: A list of resources that the app have access to.
        :param pulumi.Input[builtins.int] service_principal_id: id of the app service principal
        :param pulumi.Input[builtins.str] service_principal_name: name of the app service principal
        :param pulumi.Input[builtins.str] update_time: The update time of the app.
        :param pulumi.Input[builtins.str] updater: The email of the user that last updated the app.
        :param pulumi.Input[builtins.str] url: The URL of the app once it is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_api_scopes: A list of api scopes granted to the user access token.
        """
        if active_deployment is not None:
            pulumi.set(__self__, "active_deployment", active_deployment)
        if app_status is not None:
            pulumi.set(__self__, "app_status", app_status)
        if budget_policy_id is not None:
            pulumi.set(__self__, "budget_policy_id", budget_policy_id)
        if compute_status is not None:
            pulumi.set(__self__, "compute_status", compute_status)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if default_source_code_path is not None:
            pulumi.set(__self__, "default_source_code_path", default_source_code_path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_budget_policy_id is not None:
            pulumi.set(__self__, "effective_budget_policy_id", effective_budget_policy_id)
        if effective_user_api_scopes is not None:
            pulumi.set(__self__, "effective_user_api_scopes", effective_user_api_scopes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_compute is not None:
            pulumi.set(__self__, "no_compute", no_compute)
        if oauth2_app_client_id is not None:
            pulumi.set(__self__, "oauth2_app_client_id", oauth2_app_client_id)
        if oauth2_app_integration_id is not None:
            pulumi.set(__self__, "oauth2_app_integration_id", oauth2_app_integration_id)
        if pending_deployment is not None:
            pulumi.set(__self__, "pending_deployment", pending_deployment)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if service_principal_client_id is not None:
            pulumi.set(__self__, "service_principal_client_id", service_principal_client_id)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_name is not None:
            pulumi.set(__self__, "service_principal_name", service_principal_name)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if updater is not None:
            pulumi.set(__self__, "updater", updater)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_api_scopes is not None:
            pulumi.set(__self__, "user_api_scopes", user_api_scopes)

    @property
    @pulumi.getter(name="activeDeployment")
    def active_deployment(self) -> Optional[pulumi.Input['AppActiveDeploymentArgs']]:
        return pulumi.get(self, "active_deployment")

    @active_deployment.setter
    def active_deployment(self, value: Optional[pulumi.Input['AppActiveDeploymentArgs']]):
        pulumi.set(self, "active_deployment", value)

    @property
    @pulumi.getter(name="appStatus")
    def app_status(self) -> Optional[pulumi.Input['AppAppStatusArgs']]:
        """
        attribute
        """
        return pulumi.get(self, "app_status")

    @app_status.setter
    def app_status(self, value: Optional[pulumi.Input['AppAppStatusArgs']]):
        pulumi.set(self, "app_status", value)

    @property
    @pulumi.getter(name="budgetPolicyId")
    def budget_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Budget Policy ID set for this resource.
        """
        return pulumi.get(self, "budget_policy_id")

    @budget_policy_id.setter
    def budget_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "budget_policy_id", value)

    @property
    @pulumi.getter(name="computeStatus")
    def compute_status(self) -> Optional[pulumi.Input['AppComputeStatusArgs']]:
        """
        attribute
        """
        return pulumi.get(self, "compute_status")

    @compute_status.setter
    def compute_status(self, value: Optional[pulumi.Input['AppComputeStatusArgs']]):
        pulumi.set(self, "compute_status", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation time of the app.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email of the user that created the app.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creator", value)

    @property
    @pulumi.getter(name="defaultSourceCodePath")
    def default_source_code_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default workspace file system path of the source code from which app deployment are created. This field tracks the workspace source code path of the last active deployment.
        """
        return pulumi.get(self, "default_source_code_path")

    @default_source_code_path.setter
    def default_source_code_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_source_code_path", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the app.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveBudgetPolicyId")
    def effective_budget_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The effective budget policy ID.
        """
        return pulumi.get(self, "effective_budget_policy_id")

    @effective_budget_policy_id.setter
    def effective_budget_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "effective_budget_policy_id", value)

    @property
    @pulumi.getter(name="effectiveUserApiScopes")
    def effective_user_api_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of effective api scopes granted to the user access token.
        """
        return pulumi.get(self, "effective_user_api_scopes")

    @effective_user_api_scopes.setter
    def effective_user_api_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_user_api_scopes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the app. The name must contain only lowercase alphanumeric characters and hyphens. It must be unique within the workspace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="noCompute")
    def no_compute(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "no_compute")

    @no_compute.setter
    def no_compute(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "no_compute", value)

    @property
    @pulumi.getter(name="oauth2AppClientId")
    def oauth2_app_client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "oauth2_app_client_id")

    @oauth2_app_client_id.setter
    def oauth2_app_client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oauth2_app_client_id", value)

    @property
    @pulumi.getter(name="oauth2AppIntegrationId")
    def oauth2_app_integration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "oauth2_app_integration_id")

    @oauth2_app_integration_id.setter
    def oauth2_app_integration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oauth2_app_integration_id", value)

    @property
    @pulumi.getter(name="pendingDeployment")
    def pending_deployment(self) -> Optional[pulumi.Input['AppPendingDeploymentArgs']]:
        return pulumi.get(self, "pending_deployment")

    @pending_deployment.setter
    def pending_deployment(self, value: Optional[pulumi.Input['AppPendingDeploymentArgs']]):
        pulumi.set(self, "pending_deployment", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppResourceArgs']]]]:
        """
        A list of resources that the app have access to.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppResourceArgs']]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="servicePrincipalClientId")
    def service_principal_client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "service_principal_client_id")

    @service_principal_client_id.setter
    def service_principal_client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_principal_client_id", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        id of the app service principal
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "service_principal_id", value)

    @property
    @pulumi.getter(name="servicePrincipalName")
    def service_principal_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        name of the app service principal
        """
        return pulumi.get(self, "service_principal_name")

    @service_principal_name.setter
    def service_principal_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_principal_name", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The update time of the app.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def updater(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email of the user that last updated the app.
        """
        return pulumi.get(self, "updater")

    @updater.setter
    def updater(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updater", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the app once it is deployed.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="userApiScopes")
    def user_api_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of api scopes granted to the user access token.
        """
        return pulumi.get(self, "user_api_scopes")

    @user_api_scopes.setter
    def user_api_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_api_scopes", value)


@pulumi.type_token("databricks:index/app:App")
class App(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 budget_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 no_compute: Optional[pulumi.Input[builtins.bool]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppResourceArgs', 'AppResourceArgsDict']]]]] = None,
                 user_api_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        [Databricks Apps](https://docs.databricks.com/en/dev-tools/databricks-apps/index.html) run directly on a customer's Databricks instance, integrate with their data, use and extend Databricks services, and enable users to interact through single sign-on. This resource creates the application but does not handle app deployment, which should be handled separately as part of your CI/CD pipeline.

        > This feature is in [Public Preview](https://docs.databricks.com/release-notes/release-types.html).

        > This resource can only be used with a workspace-level provider!

        ## Import

        This resource can be imported by name:

        hcl

        import {

          to = databricks_app.this

          id = "<app_name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/app:App this <app_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] budget_policy_id: The Budget Policy ID set for this resource.
        :param pulumi.Input[builtins.str] description: The description of the app.
        :param pulumi.Input[builtins.str] name: The name of the app. The name must contain only lowercase alphanumeric characters and hyphens. It must be unique within the workspace.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppResourceArgs', 'AppResourceArgsDict']]]] resources: A list of resources that the app have access to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_api_scopes: A list of api scopes granted to the user access token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AppArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        [Databricks Apps](https://docs.databricks.com/en/dev-tools/databricks-apps/index.html) run directly on a customer's Databricks instance, integrate with their data, use and extend Databricks services, and enable users to interact through single sign-on. This resource creates the application but does not handle app deployment, which should be handled separately as part of your CI/CD pipeline.

        > This feature is in [Public Preview](https://docs.databricks.com/release-notes/release-types.html).

        > This resource can only be used with a workspace-level provider!

        ## Import

        This resource can be imported by name:

        hcl

        import {

          to = databricks_app.this

          id = "<app_name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/app:App this <app_name>
        ```

        :param str resource_name: The name of the resource.
        :param AppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 budget_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 no_compute: Optional[pulumi.Input[builtins.bool]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppResourceArgs', 'AppResourceArgsDict']]]]] = None,
                 user_api_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppArgs.__new__(AppArgs)

            __props__.__dict__["budget_policy_id"] = budget_policy_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["no_compute"] = no_compute
            __props__.__dict__["resources"] = resources
            __props__.__dict__["user_api_scopes"] = user_api_scopes
            __props__.__dict__["active_deployment"] = None
            __props__.__dict__["app_status"] = None
            __props__.__dict__["compute_status"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["default_source_code_path"] = None
            __props__.__dict__["effective_budget_policy_id"] = None
            __props__.__dict__["effective_user_api_scopes"] = None
            __props__.__dict__["oauth2_app_client_id"] = None
            __props__.__dict__["oauth2_app_integration_id"] = None
            __props__.__dict__["pending_deployment"] = None
            __props__.__dict__["service_principal_client_id"] = None
            __props__.__dict__["service_principal_id"] = None
            __props__.__dict__["service_principal_name"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["updater"] = None
            __props__.__dict__["url"] = None
        super(App, __self__).__init__(
            'databricks:index/app:App',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_deployment: Optional[pulumi.Input[Union['AppActiveDeploymentArgs', 'AppActiveDeploymentArgsDict']]] = None,
            app_status: Optional[pulumi.Input[Union['AppAppStatusArgs', 'AppAppStatusArgsDict']]] = None,
            budget_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            compute_status: Optional[pulumi.Input[Union['AppComputeStatusArgs', 'AppComputeStatusArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            creator: Optional[pulumi.Input[builtins.str]] = None,
            default_source_code_path: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_budget_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            effective_user_api_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            no_compute: Optional[pulumi.Input[builtins.bool]] = None,
            oauth2_app_client_id: Optional[pulumi.Input[builtins.str]] = None,
            oauth2_app_integration_id: Optional[pulumi.Input[builtins.str]] = None,
            pending_deployment: Optional[pulumi.Input[Union['AppPendingDeploymentArgs', 'AppPendingDeploymentArgsDict']]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppResourceArgs', 'AppResourceArgsDict']]]]] = None,
            service_principal_client_id: Optional[pulumi.Input[builtins.str]] = None,
            service_principal_id: Optional[pulumi.Input[builtins.int]] = None,
            service_principal_name: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            updater: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None,
            user_api_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'App':
        """
        Get an existing App resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AppAppStatusArgs', 'AppAppStatusArgsDict']] app_status: attribute
        :param pulumi.Input[builtins.str] budget_policy_id: The Budget Policy ID set for this resource.
        :param pulumi.Input[Union['AppComputeStatusArgs', 'AppComputeStatusArgsDict']] compute_status: attribute
        :param pulumi.Input[builtins.str] create_time: The creation time of the app.
        :param pulumi.Input[builtins.str] creator: The email of the user that created the app.
        :param pulumi.Input[builtins.str] default_source_code_path: The default workspace file system path of the source code from which app deployment are created. This field tracks the workspace source code path of the last active deployment.
        :param pulumi.Input[builtins.str] description: The description of the app.
        :param pulumi.Input[builtins.str] effective_budget_policy_id: The effective budget policy ID.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] effective_user_api_scopes: A list of effective api scopes granted to the user access token.
        :param pulumi.Input[builtins.str] name: The name of the app. The name must contain only lowercase alphanumeric characters and hyphens. It must be unique within the workspace.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppResourceArgs', 'AppResourceArgsDict']]]] resources: A list of resources that the app have access to.
        :param pulumi.Input[builtins.int] service_principal_id: id of the app service principal
        :param pulumi.Input[builtins.str] service_principal_name: name of the app service principal
        :param pulumi.Input[builtins.str] update_time: The update time of the app.
        :param pulumi.Input[builtins.str] updater: The email of the user that last updated the app.
        :param pulumi.Input[builtins.str] url: The URL of the app once it is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_api_scopes: A list of api scopes granted to the user access token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppState.__new__(_AppState)

        __props__.__dict__["active_deployment"] = active_deployment
        __props__.__dict__["app_status"] = app_status
        __props__.__dict__["budget_policy_id"] = budget_policy_id
        __props__.__dict__["compute_status"] = compute_status
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["creator"] = creator
        __props__.__dict__["default_source_code_path"] = default_source_code_path
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_budget_policy_id"] = effective_budget_policy_id
        __props__.__dict__["effective_user_api_scopes"] = effective_user_api_scopes
        __props__.__dict__["name"] = name
        __props__.__dict__["no_compute"] = no_compute
        __props__.__dict__["oauth2_app_client_id"] = oauth2_app_client_id
        __props__.__dict__["oauth2_app_integration_id"] = oauth2_app_integration_id
        __props__.__dict__["pending_deployment"] = pending_deployment
        __props__.__dict__["resources"] = resources
        __props__.__dict__["service_principal_client_id"] = service_principal_client_id
        __props__.__dict__["service_principal_id"] = service_principal_id
        __props__.__dict__["service_principal_name"] = service_principal_name
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["updater"] = updater
        __props__.__dict__["url"] = url
        __props__.__dict__["user_api_scopes"] = user_api_scopes
        return App(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeDeployment")
    def active_deployment(self) -> pulumi.Output['outputs.AppActiveDeployment']:
        return pulumi.get(self, "active_deployment")

    @property
    @pulumi.getter(name="appStatus")
    def app_status(self) -> pulumi.Output['outputs.AppAppStatus']:
        """
        attribute
        """
        return pulumi.get(self, "app_status")

    @property
    @pulumi.getter(name="budgetPolicyId")
    def budget_policy_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Budget Policy ID set for this resource.
        """
        return pulumi.get(self, "budget_policy_id")

    @property
    @pulumi.getter(name="computeStatus")
    def compute_status(self) -> pulumi.Output['outputs.AppComputeStatus']:
        """
        attribute
        """
        return pulumi.get(self, "compute_status")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The creation time of the app.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> pulumi.Output[builtins.str]:
        """
        The email of the user that created the app.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="defaultSourceCodePath")
    def default_source_code_path(self) -> pulumi.Output[builtins.str]:
        """
        The default workspace file system path of the source code from which app deployment are created. This field tracks the workspace source code path of the last active deployment.
        """
        return pulumi.get(self, "default_source_code_path")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the app.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveBudgetPolicyId")
    def effective_budget_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The effective budget policy ID.
        """
        return pulumi.get(self, "effective_budget_policy_id")

    @property
    @pulumi.getter(name="effectiveUserApiScopes")
    def effective_user_api_scopes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of effective api scopes granted to the user access token.
        """
        return pulumi.get(self, "effective_user_api_scopes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the app. The name must contain only lowercase alphanumeric characters and hyphens. It must be unique within the workspace.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="noCompute")
    def no_compute(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "no_compute")

    @property
    @pulumi.getter(name="oauth2AppClientId")
    def oauth2_app_client_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "oauth2_app_client_id")

    @property
    @pulumi.getter(name="oauth2AppIntegrationId")
    def oauth2_app_integration_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "oauth2_app_integration_id")

    @property
    @pulumi.getter(name="pendingDeployment")
    def pending_deployment(self) -> pulumi.Output['outputs.AppPendingDeployment']:
        return pulumi.get(self, "pending_deployment")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Optional[Sequence['outputs.AppResource']]]:
        """
        A list of resources that the app have access to.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="servicePrincipalClientId")
    def service_principal_client_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "service_principal_client_id")

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Output[builtins.int]:
        """
        id of the app service principal
        """
        return pulumi.get(self, "service_principal_id")

    @property
    @pulumi.getter(name="servicePrincipalName")
    def service_principal_name(self) -> pulumi.Output[builtins.str]:
        """
        name of the app service principal
        """
        return pulumi.get(self, "service_principal_name")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The update time of the app.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def updater(self) -> pulumi.Output[builtins.str]:
        """
        The email of the user that last updated the app.
        """
        return pulumi.get(self, "updater")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the app once it is deployed.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userApiScopes")
    def user_api_scopes(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of api scopes granted to the user access token.
        """
        return pulumi.get(self, "user_api_scopes")

