# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomAppIntegrationArgs', 'CustomAppIntegration']

@pulumi.input_type
class CustomAppIntegrationArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 confidential: Optional[pulumi.Input[builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 created_by: Optional[pulumi.Input[builtins.int]] = None,
                 creator_username: Optional[pulumi.Input[builtins.str]] = None,
                 integration_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 token_access_policy: Optional[pulumi.Input['CustomAppIntegrationTokenAccessPolicyArgs']] = None,
                 user_authorized_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a CustomAppIntegration resource.
        :param pulumi.Input[builtins.str] client_id: OAuth client-id generated by Databricks
        :param pulumi.Input[builtins.str] client_secret: OAuth client-secret generated by the Databricks if this is a confidential OAuth app.
        :param pulumi.Input[builtins.bool] confidential: Indicates whether an OAuth client secret is required to authenticate this client. Default to `false`. Change requires a new resource.
        :param pulumi.Input[builtins.str] integration_id: Unique integration id for the custom OAuth app.
        :param pulumi.Input[builtins.str] name: Name of the custom OAuth app. Change requires a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] redirect_urls: List of OAuth redirect urls.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: OAuth scopes granted to the application. Supported scopes: `all-apis`, `sql`, `offline_access`, `openid`, `profile`, `email`.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if confidential is not None:
            pulumi.set(__self__, "confidential", confidential)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if creator_username is not None:
            pulumi.set(__self__, "creator_username", creator_username)
        if integration_id is not None:
            pulumi.set(__self__, "integration_id", integration_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_urls is not None:
            pulumi.set(__self__, "redirect_urls", redirect_urls)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_access_policy is not None:
            pulumi.set(__self__, "token_access_policy", token_access_policy)
        if user_authorized_scopes is not None:
            pulumi.set(__self__, "user_authorized_scopes", user_authorized_scopes)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OAuth client-id generated by Databricks
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OAuth client-secret generated by the Databricks if this is a confidential OAuth app.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def confidential(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether an OAuth client secret is required to authenticate this client. Default to `false`. Change requires a new resource.
        """
        return pulumi.get(self, "confidential")

    @confidential.setter
    def confidential(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "confidential", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="creatorUsername")
    def creator_username(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "creator_username")

    @creator_username.setter
    def creator_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creator_username", value)

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique integration id for the custom OAuth app.
        """
        return pulumi.get(self, "integration_id")

    @integration_id.setter
    def integration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the custom OAuth app. Change requires a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redirectUrls")
    def redirect_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of OAuth redirect urls.
        """
        return pulumi.get(self, "redirect_urls")

    @redirect_urls.setter
    def redirect_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "redirect_urls", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        OAuth scopes granted to the application. Supported scopes: `all-apis`, `sql`, `offline_access`, `openid`, `profile`, `email`.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="tokenAccessPolicy")
    def token_access_policy(self) -> Optional[pulumi.Input['CustomAppIntegrationTokenAccessPolicyArgs']]:
        return pulumi.get(self, "token_access_policy")

    @token_access_policy.setter
    def token_access_policy(self, value: Optional[pulumi.Input['CustomAppIntegrationTokenAccessPolicyArgs']]):
        pulumi.set(self, "token_access_policy", value)

    @property
    @pulumi.getter(name="userAuthorizedScopes")
    def user_authorized_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "user_authorized_scopes")

    @user_authorized_scopes.setter
    def user_authorized_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_authorized_scopes", value)


@pulumi.input_type
class _CustomAppIntegrationState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 confidential: Optional[pulumi.Input[builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 created_by: Optional[pulumi.Input[builtins.int]] = None,
                 creator_username: Optional[pulumi.Input[builtins.str]] = None,
                 integration_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 token_access_policy: Optional[pulumi.Input['CustomAppIntegrationTokenAccessPolicyArgs']] = None,
                 user_authorized_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CustomAppIntegration resources.
        :param pulumi.Input[builtins.str] client_id: OAuth client-id generated by Databricks
        :param pulumi.Input[builtins.str] client_secret: OAuth client-secret generated by the Databricks if this is a confidential OAuth app.
        :param pulumi.Input[builtins.bool] confidential: Indicates whether an OAuth client secret is required to authenticate this client. Default to `false`. Change requires a new resource.
        :param pulumi.Input[builtins.str] integration_id: Unique integration id for the custom OAuth app.
        :param pulumi.Input[builtins.str] name: Name of the custom OAuth app. Change requires a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] redirect_urls: List of OAuth redirect urls.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: OAuth scopes granted to the application. Supported scopes: `all-apis`, `sql`, `offline_access`, `openid`, `profile`, `email`.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if confidential is not None:
            pulumi.set(__self__, "confidential", confidential)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if creator_username is not None:
            pulumi.set(__self__, "creator_username", creator_username)
        if integration_id is not None:
            pulumi.set(__self__, "integration_id", integration_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_urls is not None:
            pulumi.set(__self__, "redirect_urls", redirect_urls)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_access_policy is not None:
            pulumi.set(__self__, "token_access_policy", token_access_policy)
        if user_authorized_scopes is not None:
            pulumi.set(__self__, "user_authorized_scopes", user_authorized_scopes)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OAuth client-id generated by Databricks
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OAuth client-secret generated by the Databricks if this is a confidential OAuth app.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def confidential(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether an OAuth client secret is required to authenticate this client. Default to `false`. Change requires a new resource.
        """
        return pulumi.get(self, "confidential")

    @confidential.setter
    def confidential(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "confidential", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="creatorUsername")
    def creator_username(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "creator_username")

    @creator_username.setter
    def creator_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creator_username", value)

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique integration id for the custom OAuth app.
        """
        return pulumi.get(self, "integration_id")

    @integration_id.setter
    def integration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the custom OAuth app. Change requires a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redirectUrls")
    def redirect_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of OAuth redirect urls.
        """
        return pulumi.get(self, "redirect_urls")

    @redirect_urls.setter
    def redirect_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "redirect_urls", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        OAuth scopes granted to the application. Supported scopes: `all-apis`, `sql`, `offline_access`, `openid`, `profile`, `email`.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="tokenAccessPolicy")
    def token_access_policy(self) -> Optional[pulumi.Input['CustomAppIntegrationTokenAccessPolicyArgs']]:
        return pulumi.get(self, "token_access_policy")

    @token_access_policy.setter
    def token_access_policy(self, value: Optional[pulumi.Input['CustomAppIntegrationTokenAccessPolicyArgs']]):
        pulumi.set(self, "token_access_policy", value)

    @property
    @pulumi.getter(name="userAuthorizedScopes")
    def user_authorized_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "user_authorized_scopes")

    @user_authorized_scopes.setter
    def user_authorized_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_authorized_scopes", value)


@pulumi.type_token("databricks:index/customAppIntegration:CustomAppIntegration")
class CustomAppIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 confidential: Optional[pulumi.Input[builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 created_by: Optional[pulumi.Input[builtins.int]] = None,
                 creator_username: Optional[pulumi.Input[builtins.str]] = None,
                 integration_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 token_access_policy: Optional[pulumi.Input[Union['CustomAppIntegrationTokenAccessPolicyArgs', 'CustomAppIntegrationTokenAccessPolicyArgsDict']]] = None,
                 user_authorized_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource allows you to enable [custom OAuth applications](https://docs.databricks.com/en/integrations/enable-disable-oauth.html#enable-custom-oauth-applications-using-the-databricks-ui).

        > This resource can only be used with an account-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.CustomAppIntegration("this",
            name="custom_integration_name",
            redirect_urls=["https://example.com"],
            scopes=["all-apis"],
            token_access_policy={
                "access_token_ttl_in_minutes": 15,
                "refresh_token_ttl_in_minutes": 30,
            })
        ```

        ## Related Resources

        The following resources are used in the context:

        * MwsWorkspaces to set up Databricks workspaces.

        ## Import

        This resource can be imported by its integration ID:

        hcl

        import {

          to = databricks_custom_app_integration.this

          id = "<integration_id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/customAppIntegration:CustomAppIntegration this "<integration_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] client_id: OAuth client-id generated by Databricks
        :param pulumi.Input[builtins.str] client_secret: OAuth client-secret generated by the Databricks if this is a confidential OAuth app.
        :param pulumi.Input[builtins.bool] confidential: Indicates whether an OAuth client secret is required to authenticate this client. Default to `false`. Change requires a new resource.
        :param pulumi.Input[builtins.str] integration_id: Unique integration id for the custom OAuth app.
        :param pulumi.Input[builtins.str] name: Name of the custom OAuth app. Change requires a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] redirect_urls: List of OAuth redirect urls.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: OAuth scopes granted to the application. Supported scopes: `all-apis`, `sql`, `offline_access`, `openid`, `profile`, `email`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CustomAppIntegrationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to enable [custom OAuth applications](https://docs.databricks.com/en/integrations/enable-disable-oauth.html#enable-custom-oauth-applications-using-the-databricks-ui).

        > This resource can only be used with an account-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.CustomAppIntegration("this",
            name="custom_integration_name",
            redirect_urls=["https://example.com"],
            scopes=["all-apis"],
            token_access_policy={
                "access_token_ttl_in_minutes": 15,
                "refresh_token_ttl_in_minutes": 30,
            })
        ```

        ## Related Resources

        The following resources are used in the context:

        * MwsWorkspaces to set up Databricks workspaces.

        ## Import

        This resource can be imported by its integration ID:

        hcl

        import {

          to = databricks_custom_app_integration.this

          id = "<integration_id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/customAppIntegration:CustomAppIntegration this "<integration_id>"
        ```

        :param str resource_name: The name of the resource.
        :param CustomAppIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomAppIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 confidential: Optional[pulumi.Input[builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 created_by: Optional[pulumi.Input[builtins.int]] = None,
                 creator_username: Optional[pulumi.Input[builtins.str]] = None,
                 integration_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 token_access_policy: Optional[pulumi.Input[Union['CustomAppIntegrationTokenAccessPolicyArgs', 'CustomAppIntegrationTokenAccessPolicyArgsDict']]] = None,
                 user_authorized_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomAppIntegrationArgs.__new__(CustomAppIntegrationArgs)

            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["confidential"] = confidential
            __props__.__dict__["create_time"] = create_time
            __props__.__dict__["created_by"] = created_by
            __props__.__dict__["creator_username"] = creator_username
            __props__.__dict__["integration_id"] = integration_id
            __props__.__dict__["name"] = name
            __props__.__dict__["redirect_urls"] = redirect_urls
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["token_access_policy"] = token_access_policy
            __props__.__dict__["user_authorized_scopes"] = user_authorized_scopes
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CustomAppIntegration, __self__).__init__(
            'databricks:index/customAppIntegration:CustomAppIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            client_secret: Optional[pulumi.Input[builtins.str]] = None,
            confidential: Optional[pulumi.Input[builtins.bool]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            created_by: Optional[pulumi.Input[builtins.int]] = None,
            creator_username: Optional[pulumi.Input[builtins.str]] = None,
            integration_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            token_access_policy: Optional[pulumi.Input[Union['CustomAppIntegrationTokenAccessPolicyArgs', 'CustomAppIntegrationTokenAccessPolicyArgsDict']]] = None,
            user_authorized_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'CustomAppIntegration':
        """
        Get an existing CustomAppIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] client_id: OAuth client-id generated by Databricks
        :param pulumi.Input[builtins.str] client_secret: OAuth client-secret generated by the Databricks if this is a confidential OAuth app.
        :param pulumi.Input[builtins.bool] confidential: Indicates whether an OAuth client secret is required to authenticate this client. Default to `false`. Change requires a new resource.
        :param pulumi.Input[builtins.str] integration_id: Unique integration id for the custom OAuth app.
        :param pulumi.Input[builtins.str] name: Name of the custom OAuth app. Change requires a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] redirect_urls: List of OAuth redirect urls.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: OAuth scopes granted to the application. Supported scopes: `all-apis`, `sql`, `offline_access`, `openid`, `profile`, `email`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomAppIntegrationState.__new__(_CustomAppIntegrationState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["confidential"] = confidential
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["creator_username"] = creator_username
        __props__.__dict__["integration_id"] = integration_id
        __props__.__dict__["name"] = name
        __props__.__dict__["redirect_urls"] = redirect_urls
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["token_access_policy"] = token_access_policy
        __props__.__dict__["user_authorized_scopes"] = user_authorized_scopes
        return CustomAppIntegration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[builtins.str]:
        """
        OAuth client-id generated by Databricks
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[builtins.str]:
        """
        OAuth client-secret generated by the Databricks if this is a confidential OAuth app.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def confidential(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether an OAuth client secret is required to authenticate this client. Default to `false`. Change requires a new resource.
        """
        return pulumi.get(self, "confidential")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="creatorUsername")
    def creator_username(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "creator_username")

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique integration id for the custom OAuth app.
        """
        return pulumi.get(self, "integration_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the custom OAuth app. Change requires a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="redirectUrls")
    def redirect_urls(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of OAuth redirect urls.
        """
        return pulumi.get(self, "redirect_urls")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        OAuth scopes granted to the application. Supported scopes: `all-apis`, `sql`, `offline_access`, `openid`, `profile`, `email`.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="tokenAccessPolicy")
    def token_access_policy(self) -> pulumi.Output[Optional['outputs.CustomAppIntegrationTokenAccessPolicy']]:
        return pulumi.get(self, "token_access_policy")

    @property
    @pulumi.getter(name="userAuthorizedScopes")
    def user_authorized_scopes(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        return pulumi.get(self, "user_authorized_scopes")

