# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatabaseInstanceArgs', 'DatabaseInstance']

@pulumi.input_type
class DatabaseInstanceArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 stopped: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a DatabaseInstance resource.
        :param pulumi.Input[builtins.str] capacity: The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        :param pulumi.Input[builtins.str] name: The name of the instance. This is the unique identifier for the instance
        :param pulumi.Input[builtins.bool] stopped: Whether the instance is stopped
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stopped is not None:
            pulumi.set(__self__, "stopped", stopped)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the instance. This is the unique identifier for the instance
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def stopped(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the instance is stopped
        """
        return pulumi.get(self, "stopped")

    @stopped.setter
    def stopped(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "stopped", value)


@pulumi.input_type
class _DatabaseInstanceState:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[builtins.str]] = None,
                 creator: Optional[pulumi.Input[builtins.str]] = None,
                 effective_stopped: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pg_version: Optional[pulumi.Input[builtins.str]] = None,
                 read_write_dns: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 stopped: Optional[pulumi.Input[builtins.bool]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseInstance resources.
        :param pulumi.Input[builtins.str] capacity: The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        :param pulumi.Input[builtins.str] creation_time: (string) - The timestamp when the instance was created
        :param pulumi.Input[builtins.str] creator: (string) - The email of the creator of the instance
        :param pulumi.Input[builtins.bool] effective_stopped: (boolean) - xref AIP-129. `stopped` is owned by the client, while `effective_stopped` is owned by the server.
               `stopped` will only be set in Create/Update response messages if and only if the user provides the field via the request.
               `effective_stopped` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        :param pulumi.Input[builtins.str] name: The name of the instance. This is the unique identifier for the instance
        :param pulumi.Input[builtins.str] pg_version: (string) - The version of Postgres running on the instance
        :param pulumi.Input[builtins.str] read_write_dns: (string) - The DNS endpoint to connect to the instance for read+write access
        :param pulumi.Input[builtins.str] state: (string) - The current state of the instance. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        :param pulumi.Input[builtins.bool] stopped: Whether the instance is stopped
        :param pulumi.Input[builtins.str] uid: (string) - An immutable UUID identifier for the instance
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if effective_stopped is not None:
            pulumi.set(__self__, "effective_stopped", effective_stopped)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pg_version is not None:
            pulumi.set(__self__, "pg_version", pg_version)
        if read_write_dns is not None:
            pulumi.set(__self__, "read_write_dns", read_write_dns)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stopped is not None:
            pulumi.set(__self__, "stopped", stopped)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (string) - The timestamp when the instance was created
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (string) - The email of the creator of the instance
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creator", value)

    @property
    @pulumi.getter(name="effectiveStopped")
    def effective_stopped(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (boolean) - xref AIP-129. `stopped` is owned by the client, while `effective_stopped` is owned by the server.
        `stopped` will only be set in Create/Update response messages if and only if the user provides the field via the request.
        `effective_stopped` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        """
        return pulumi.get(self, "effective_stopped")

    @effective_stopped.setter
    def effective_stopped(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "effective_stopped", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the instance. This is the unique identifier for the instance
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pgVersion")
    def pg_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (string) - The version of Postgres running on the instance
        """
        return pulumi.get(self, "pg_version")

    @pg_version.setter
    def pg_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pg_version", value)

    @property
    @pulumi.getter(name="readWriteDns")
    def read_write_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (string) - The DNS endpoint to connect to the instance for read+write access
        """
        return pulumi.get(self, "read_write_dns")

    @read_write_dns.setter
    def read_write_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "read_write_dns", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (string) - The current state of the instance. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def stopped(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the instance is stopped
        """
        return pulumi.get(self, "stopped")

    @stopped.setter
    def stopped(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "stopped", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (string) - An immutable UUID identifier for the instance
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("databricks:index/databaseInstance:DatabaseInstance")
class DatabaseInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 stopped: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Database Instances are managed Postgres instances, composed of a primary Postgres compute instance and 0 or more read replica instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.DatabaseInstance("this",
            name="my-database-instance",
            capacity="CU_2")
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = name

          to = databricks_database_instance.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/databaseInstance:DatabaseInstance databricks_database_instance name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] capacity: The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        :param pulumi.Input[builtins.str] name: The name of the instance. This is the unique identifier for the instance
        :param pulumi.Input[builtins.bool] stopped: Whether the instance is stopped
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DatabaseInstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Database Instances are managed Postgres instances, composed of a primary Postgres compute instance and 0 or more read replica instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.DatabaseInstance("this",
            name="my-database-instance",
            capacity="CU_2")
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = name

          to = databricks_database_instance.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/databaseInstance:DatabaseInstance databricks_database_instance name
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 stopped: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseInstanceArgs.__new__(DatabaseInstanceArgs)

            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["name"] = name
            __props__.__dict__["stopped"] = stopped
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["effective_stopped"] = None
            __props__.__dict__["pg_version"] = None
            __props__.__dict__["read_write_dns"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
        super(DatabaseInstance, __self__).__init__(
            'databricks:index/databaseInstance:DatabaseInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity: Optional[pulumi.Input[builtins.str]] = None,
            creation_time: Optional[pulumi.Input[builtins.str]] = None,
            creator: Optional[pulumi.Input[builtins.str]] = None,
            effective_stopped: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            pg_version: Optional[pulumi.Input[builtins.str]] = None,
            read_write_dns: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            stopped: Optional[pulumi.Input[builtins.bool]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None) -> 'DatabaseInstance':
        """
        Get an existing DatabaseInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] capacity: The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        :param pulumi.Input[builtins.str] creation_time: (string) - The timestamp when the instance was created
        :param pulumi.Input[builtins.str] creator: (string) - The email of the creator of the instance
        :param pulumi.Input[builtins.bool] effective_stopped: (boolean) - xref AIP-129. `stopped` is owned by the client, while `effective_stopped` is owned by the server.
               `stopped` will only be set in Create/Update response messages if and only if the user provides the field via the request.
               `effective_stopped` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        :param pulumi.Input[builtins.str] name: The name of the instance. This is the unique identifier for the instance
        :param pulumi.Input[builtins.str] pg_version: (string) - The version of Postgres running on the instance
        :param pulumi.Input[builtins.str] read_write_dns: (string) - The DNS endpoint to connect to the instance for read+write access
        :param pulumi.Input[builtins.str] state: (string) - The current state of the instance. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        :param pulumi.Input[builtins.bool] stopped: Whether the instance is stopped
        :param pulumi.Input[builtins.str] uid: (string) - An immutable UUID identifier for the instance
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseInstanceState.__new__(_DatabaseInstanceState)

        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["creator"] = creator
        __props__.__dict__["effective_stopped"] = effective_stopped
        __props__.__dict__["name"] = name
        __props__.__dict__["pg_version"] = pg_version
        __props__.__dict__["read_write_dns"] = read_write_dns
        __props__.__dict__["state"] = state
        __props__.__dict__["stopped"] = stopped
        __props__.__dict__["uid"] = uid
        return DatabaseInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        (string) - The timestamp when the instance was created
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def creator(self) -> pulumi.Output[builtins.str]:
        """
        (string) - The email of the creator of the instance
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="effectiveStopped")
    def effective_stopped(self) -> pulumi.Output[builtins.bool]:
        """
        (boolean) - xref AIP-129. `stopped` is owned by the client, while `effective_stopped` is owned by the server.
        `stopped` will only be set in Create/Update response messages if and only if the user provides the field via the request.
        `effective_stopped` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        """
        return pulumi.get(self, "effective_stopped")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the instance. This is the unique identifier for the instance
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pgVersion")
    def pg_version(self) -> pulumi.Output[builtins.str]:
        """
        (string) - The version of Postgres running on the instance
        """
        return pulumi.get(self, "pg_version")

    @property
    @pulumi.getter(name="readWriteDns")
    def read_write_dns(self) -> pulumi.Output[builtins.str]:
        """
        (string) - The DNS endpoint to connect to the instance for read+write access
        """
        return pulumi.get(self, "read_write_dns")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        (string) - The current state of the instance. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def stopped(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the instance is stopped
        """
        return pulumi.get(self, "stopped")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        (string) - An immutable UUID identifier for the instance
        """
        return pulumi.get(self, "uid")

