# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAccountNetworkPolicyResult',
    'AwaitableGetAccountNetworkPolicyResult',
    'get_account_network_policy',
    'get_account_network_policy_output',
]

@pulumi.output_type
class GetAccountNetworkPolicyResult:
    """
    A collection of values returned by getAccountNetworkPolicy.
    """
    def __init__(__self__, account_id=None, egress=None, id=None, network_policy_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if egress and not isinstance(egress, dict):
            raise TypeError("Expected argument 'egress' to be a dict")
        pulumi.set(__self__, "egress", egress)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_policy_id and not isinstance(network_policy_id, str):
            raise TypeError("Expected argument 'network_policy_id' to be a str")
        pulumi.set(__self__, "network_policy_id", network_policy_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        (string) - The associated account ID for this Network Policy object
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def egress(self) -> Optional['outputs.GetAccountNetworkPolicyEgressResult']:
        """
        (NetworkPolicyEgress) - The network policies applying for egress traffic
        """
        return pulumi.get(self, "egress")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkPolicyId")
    def network_policy_id(self) -> Optional[builtins.str]:
        """
        (string) - The unique identifier for the network policy
        """
        return pulumi.get(self, "network_policy_id")


class AwaitableGetAccountNetworkPolicyResult(GetAccountNetworkPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountNetworkPolicyResult(
            account_id=self.account_id,
            egress=self.egress,
            id=self.id,
            network_policy_id=self.network_policy_id)


def get_account_network_policy(account_id: Optional[builtins.str] = None,
                               egress: Optional[Union['GetAccountNetworkPolicyEgressArgs', 'GetAccountNetworkPolicyEgressArgsDict']] = None,
                               network_policy_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountNetworkPolicyResult:
    """
    Use this data source to access information about an existing resource.

    :param builtins.str account_id: (string) - The associated account ID for this Network Policy object
    :param Union['GetAccountNetworkPolicyEgressArgs', 'GetAccountNetworkPolicyEgressArgsDict'] egress: (NetworkPolicyEgress) - The network policies applying for egress traffic
    :param builtins.str network_policy_id: The unique identifier for the network policy
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['egress'] = egress
    __args__['networkPolicyId'] = network_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getAccountNetworkPolicy:getAccountNetworkPolicy', __args__, opts=opts, typ=GetAccountNetworkPolicyResult).value

    return AwaitableGetAccountNetworkPolicyResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        egress=pulumi.get(__ret__, 'egress'),
        id=pulumi.get(__ret__, 'id'),
        network_policy_id=pulumi.get(__ret__, 'network_policy_id'))
def get_account_network_policy_output(account_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      egress: Optional[pulumi.Input[Optional[Union['GetAccountNetworkPolicyEgressArgs', 'GetAccountNetworkPolicyEgressArgsDict']]]] = None,
                                      network_policy_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountNetworkPolicyResult]:
    """
    Use this data source to access information about an existing resource.

    :param builtins.str account_id: (string) - The associated account ID for this Network Policy object
    :param Union['GetAccountNetworkPolicyEgressArgs', 'GetAccountNetworkPolicyEgressArgsDict'] egress: (NetworkPolicyEgress) - The network policies applying for egress traffic
    :param builtins.str network_policy_id: The unique identifier for the network policy
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['egress'] = egress
    __args__['networkPolicyId'] = network_policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getAccountNetworkPolicy:getAccountNetworkPolicy', __args__, opts=opts, typ=GetAccountNetworkPolicyResult)
    return __ret__.apply(lambda __response__: GetAccountNetworkPolicyResult(
        account_id=pulumi.get(__response__, 'account_id'),
        egress=pulumi.get(__response__, 'egress'),
        id=pulumi.get(__response__, 'id'),
        network_policy_id=pulumi.get(__response__, 'network_policy_id')))
