# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAwsUnityCatalogPolicyResult',
    'AwaitableGetAwsUnityCatalogPolicyResult',
    'get_aws_unity_catalog_policy',
    'get_aws_unity_catalog_policy_output',
]

@pulumi.output_type
class GetAwsUnityCatalogPolicyResult:
    """
    A collection of values returned by getAwsUnityCatalogPolicy.
    """
    def __init__(__self__, aws_account_id=None, aws_partition=None, bucket_name=None, id=None, json=None, kms_name=None, role_name=None):
        if aws_account_id and not isinstance(aws_account_id, str):
            raise TypeError("Expected argument 'aws_account_id' to be a str")
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        if aws_partition and not isinstance(aws_partition, str):
            raise TypeError("Expected argument 'aws_partition' to be a str")
        pulumi.set(__self__, "aws_partition", aws_partition)
        if bucket_name and not isinstance(bucket_name, str):
            raise TypeError("Expected argument 'bucket_name' to be a str")
        pulumi.set(__self__, "bucket_name", bucket_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if json and not isinstance(json, str):
            raise TypeError("Expected argument 'json' to be a str")
        pulumi.set(__self__, "json", json)
        if kms_name and not isinstance(kms_name, str):
            raise TypeError("Expected argument 'kms_name' to be a str")
        pulumi.set(__self__, "kms_name", kms_name)
        if role_name and not isinstance(role_name, str):
            raise TypeError("Expected argument 'role_name' to be a str")
        pulumi.set(__self__, "role_name", role_name)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> builtins.str:
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="awsPartition")
    def aws_partition(self) -> Optional[builtins.str]:
        return pulumi.get(self, "aws_partition")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def json(self) -> builtins.str:
        """
        AWS IAM Policy JSON document
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter(name="kmsName")
    def kms_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "kms_name")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> builtins.str:
        return pulumi.get(self, "role_name")


class AwaitableGetAwsUnityCatalogPolicyResult(GetAwsUnityCatalogPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsUnityCatalogPolicyResult(
            aws_account_id=self.aws_account_id,
            aws_partition=self.aws_partition,
            bucket_name=self.bucket_name,
            id=self.id,
            json=self.json,
            kms_name=self.kms_name,
            role_name=self.role_name)


def get_aws_unity_catalog_policy(aws_account_id: Optional[builtins.str] = None,
                                 aws_partition: Optional[builtins.str] = None,
                                 bucket_name: Optional[builtins.str] = None,
                                 kms_name: Optional[builtins.str] = None,
                                 role_name: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsUnityCatalogPolicyResult:
    """
    This data source constructs the necessary AWS Unity Catalog policy for you.

    > This data source can be used with an account or workspace-level provider.

    > This data source has an evolving API, which may change in future versions of the provider. Please always consult [latest documentation](https://docs.databricks.com/data-governance/unity-catalog/get-started.html#configure-a-storage-bucket-and-iam-role-in-aws) in case of any questions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_databricks as databricks

    this = databricks.get_aws_unity_catalog_policy(aws_account_id=aws_account_id,
        bucket_name="databricks-bucket",
        role_name=f"{prefix}-uc-access",
        kms_name="arn:aws:kms:us-west-2:111122223333:key/databricks-kms")
    this_get_aws_unity_catalog_assume_role_policy = databricks.get_aws_unity_catalog_assume_role_policy(aws_account_id=aws_account_id,
        role_name=f"{prefix}-uc-access",
        external_id="12345")
    unity_metastore = aws.iam.Policy("unity_metastore",
        name=f"{prefix}-unity-catalog-metastore-access-iam-policy",
        policy=this.json)
    metastore_data_access = aws.iam.Role("metastore_data_access",
        name=f"{prefix}-uc-access",
        assume_role_policy=this_get_aws_unity_catalog_assume_role_policy.json)
    metastore_data_access_role_policy_attachment = aws.iam.RolePolicyAttachment("metastore_data_access",
        role=metastore_data_access.name,
        policy_arn=unity_metastore.arn)
    ```


    :param builtins.str aws_account_id: The Account ID of the current AWS account (not your Databricks account).
    :param builtins.str aws_partition: AWS partition. The options are `aws`, `aws-us-gov`, or `aws-us-gov-dod`. Defaults to `aws`
    :param builtins.str bucket_name: The name of the S3 bucket used as root storage location for [managed tables](https://docs.databricks.com/data-governance/unity-catalog/index.html#managed-table) in Unity Catalog.  The name must follow the [S3 bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
    :param builtins.str kms_name: If encryption is enabled, provide the ARN of the KMS key that encrypts the S3 bucket contents. If encryption is disabled, do not provide this argument.
    :param builtins.str role_name: The name of the AWS IAM role that you created in the previous step in the [official documentation](https://docs.databricks.com/data-governance/unity-catalog/get-started.html#configure-a-storage-bucket-and-iam-role-in-aws).
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['awsPartition'] = aws_partition
    __args__['bucketName'] = bucket_name
    __args__['kmsName'] = kms_name
    __args__['roleName'] = role_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getAwsUnityCatalogPolicy:getAwsUnityCatalogPolicy', __args__, opts=opts, typ=GetAwsUnityCatalogPolicyResult).value

    return AwaitableGetAwsUnityCatalogPolicyResult(
        aws_account_id=pulumi.get(__ret__, 'aws_account_id'),
        aws_partition=pulumi.get(__ret__, 'aws_partition'),
        bucket_name=pulumi.get(__ret__, 'bucket_name'),
        id=pulumi.get(__ret__, 'id'),
        json=pulumi.get(__ret__, 'json'),
        kms_name=pulumi.get(__ret__, 'kms_name'),
        role_name=pulumi.get(__ret__, 'role_name'))
def get_aws_unity_catalog_policy_output(aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                                        aws_partition: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                                        kms_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        role_name: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAwsUnityCatalogPolicyResult]:
    """
    This data source constructs the necessary AWS Unity Catalog policy for you.

    > This data source can be used with an account or workspace-level provider.

    > This data source has an evolving API, which may change in future versions of the provider. Please always consult [latest documentation](https://docs.databricks.com/data-governance/unity-catalog/get-started.html#configure-a-storage-bucket-and-iam-role-in-aws) in case of any questions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_databricks as databricks

    this = databricks.get_aws_unity_catalog_policy(aws_account_id=aws_account_id,
        bucket_name="databricks-bucket",
        role_name=f"{prefix}-uc-access",
        kms_name="arn:aws:kms:us-west-2:111122223333:key/databricks-kms")
    this_get_aws_unity_catalog_assume_role_policy = databricks.get_aws_unity_catalog_assume_role_policy(aws_account_id=aws_account_id,
        role_name=f"{prefix}-uc-access",
        external_id="12345")
    unity_metastore = aws.iam.Policy("unity_metastore",
        name=f"{prefix}-unity-catalog-metastore-access-iam-policy",
        policy=this.json)
    metastore_data_access = aws.iam.Role("metastore_data_access",
        name=f"{prefix}-uc-access",
        assume_role_policy=this_get_aws_unity_catalog_assume_role_policy.json)
    metastore_data_access_role_policy_attachment = aws.iam.RolePolicyAttachment("metastore_data_access",
        role=metastore_data_access.name,
        policy_arn=unity_metastore.arn)
    ```


    :param builtins.str aws_account_id: The Account ID of the current AWS account (not your Databricks account).
    :param builtins.str aws_partition: AWS partition. The options are `aws`, `aws-us-gov`, or `aws-us-gov-dod`. Defaults to `aws`
    :param builtins.str bucket_name: The name of the S3 bucket used as root storage location for [managed tables](https://docs.databricks.com/data-governance/unity-catalog/index.html#managed-table) in Unity Catalog.  The name must follow the [S3 bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
    :param builtins.str kms_name: If encryption is enabled, provide the ARN of the KMS key that encrypts the S3 bucket contents. If encryption is disabled, do not provide this argument.
    :param builtins.str role_name: The name of the AWS IAM role that you created in the previous step in the [official documentation](https://docs.databricks.com/data-governance/unity-catalog/get-started.html#configure-a-storage-bucket-and-iam-role-in-aws).
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['awsPartition'] = aws_partition
    __args__['bucketName'] = bucket_name
    __args__['kmsName'] = kms_name
    __args__['roleName'] = role_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getAwsUnityCatalogPolicy:getAwsUnityCatalogPolicy', __args__, opts=opts, typ=GetAwsUnityCatalogPolicyResult)
    return __ret__.apply(lambda __response__: GetAwsUnityCatalogPolicyResult(
        aws_account_id=pulumi.get(__response__, 'aws_account_id'),
        aws_partition=pulumi.get(__response__, 'aws_partition'),
        bucket_name=pulumi.get(__response__, 'bucket_name'),
        id=pulumi.get(__response__, 'id'),
        json=pulumi.get(__response__, 'json'),
        kms_name=pulumi.get(__response__, 'kms_name'),
        role_name=pulumi.get(__response__, 'role_name')))
