# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCurrentMetastoreResult',
    'AwaitableGetCurrentMetastoreResult',
    'get_current_metastore',
    'get_current_metastore_output',
]

@pulumi.output_type
class GetCurrentMetastoreResult:
    """
    A collection of values returned by getCurrentMetastore.
    """
    def __init__(__self__, id=None, metastore_info=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metastore_info and not isinstance(metastore_info, dict):
            raise TypeError("Expected argument 'metastore_info' to be a dict")
        pulumi.set(__self__, "metastore_info", metastore_info)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        metastore ID. Will be `no_metastore` if there is no metastore assigned for the current workspace
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="metastoreInfo")
    def metastore_info(self) -> 'outputs.GetCurrentMetastoreMetastoreInfoResult':
        """
        summary about a metastore attached to the current workspace returned by [Get a metastore summary API](https://docs.databricks.com/api/workspace/metastores/summary). This contains the following attributes (check the API page for up-to-date details):
        """
        return pulumi.get(self, "metastore_info")


class AwaitableGetCurrentMetastoreResult(GetCurrentMetastoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCurrentMetastoreResult(
            id=self.id,
            metastore_info=self.metastore_info)


def get_current_metastore(id: Optional[builtins.str] = None,
                          metastore_info: Optional[Union['GetCurrentMetastoreMetastoreInfoArgs', 'GetCurrentMetastoreMetastoreInfoArgsDict']] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCurrentMetastoreResult:
    """
    Retrieves information about metastore attached to a given workspace.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    MetastoreSummary response for a metastore attached to the current workspace.

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_current_metastore()
    pulumi.export("someMetastore", this.metastore_info)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Metastore to get information for a metastore with a given ID.
    * get_metastores to get a mapping of name to id of all metastores.
    * Metastore to manage Metastores within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param builtins.str id: metastore ID. Will be `no_metastore` if there is no metastore assigned for the current workspace
    :param Union['GetCurrentMetastoreMetastoreInfoArgs', 'GetCurrentMetastoreMetastoreInfoArgsDict'] metastore_info: summary about a metastore attached to the current workspace returned by [Get a metastore summary API](https://docs.databricks.com/api/workspace/metastores/summary). This contains the following attributes (check the API page for up-to-date details):
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['metastoreInfo'] = metastore_info
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getCurrentMetastore:getCurrentMetastore', __args__, opts=opts, typ=GetCurrentMetastoreResult).value

    return AwaitableGetCurrentMetastoreResult(
        id=pulumi.get(__ret__, 'id'),
        metastore_info=pulumi.get(__ret__, 'metastore_info'))
def get_current_metastore_output(id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 metastore_info: Optional[pulumi.Input[Optional[Union['GetCurrentMetastoreMetastoreInfoArgs', 'GetCurrentMetastoreMetastoreInfoArgsDict']]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCurrentMetastoreResult]:
    """
    Retrieves information about metastore attached to a given workspace.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    MetastoreSummary response for a metastore attached to the current workspace.

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_current_metastore()
    pulumi.export("someMetastore", this.metastore_info)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Metastore to get information for a metastore with a given ID.
    * get_metastores to get a mapping of name to id of all metastores.
    * Metastore to manage Metastores within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param builtins.str id: metastore ID. Will be `no_metastore` if there is no metastore assigned for the current workspace
    :param Union['GetCurrentMetastoreMetastoreInfoArgs', 'GetCurrentMetastoreMetastoreInfoArgsDict'] metastore_info: summary about a metastore attached to the current workspace returned by [Get a metastore summary API](https://docs.databricks.com/api/workspace/metastores/summary). This contains the following attributes (check the API page for up-to-date details):
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['metastoreInfo'] = metastore_info
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getCurrentMetastore:getCurrentMetastore', __args__, opts=opts, typ=GetCurrentMetastoreResult)
    return __ret__.apply(lambda __response__: GetCurrentMetastoreResult(
        id=pulumi.get(__response__, 'id'),
        metastore_info=pulumi.get(__response__, 'metastore_info')))
