# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFunctionsResult',
    'AwaitableGetFunctionsResult',
    'get_functions',
    'get_functions_output',
]

@pulumi.output_type
class GetFunctionsResult:
    """
    A collection of values returned by getFunctions.
    """
    def __init__(__self__, catalog_name=None, functions=None, id=None, include_browse=None, schema_name=None):
        if catalog_name and not isinstance(catalog_name, str):
            raise TypeError("Expected argument 'catalog_name' to be a str")
        pulumi.set(__self__, "catalog_name", catalog_name)
        if functions and not isinstance(functions, list):
            raise TypeError("Expected argument 'functions' to be a list")
        pulumi.set(__self__, "functions", functions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_browse and not isinstance(include_browse, bool):
            raise TypeError("Expected argument 'include_browse' to be a bool")
        pulumi.set(__self__, "include_browse", include_browse)
        if schema_name and not isinstance(schema_name, str):
            raise TypeError("Expected argument 'schema_name' to be a str")
        pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> builtins.str:
        """
        Name of parent catalog.
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def functions(self) -> Sequence['outputs.GetFunctionsFunctionResult']:
        """
        list of objects describing individual UDF. Each object consists of the following attributes (refer to [REST API documentation](https://docs.databricks.com/api/workspace/functions/list#functions) for up-to-date list of attributes. Default type is String):
        """
        return pulumi.get(self, "functions")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeBrowse")
    def include_browse(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "include_browse")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> builtins.str:
        """
        Name of parent schema relative to its parent catalog.
        """
        return pulumi.get(self, "schema_name")


class AwaitableGetFunctionsResult(GetFunctionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFunctionsResult(
            catalog_name=self.catalog_name,
            functions=self.functions,
            id=self.id,
            include_browse=self.include_browse,
            schema_name=self.schema_name)


def get_functions(catalog_name: Optional[builtins.str] = None,
                  functions: Optional[Sequence[Union['GetFunctionsFunctionArgs', 'GetFunctionsFunctionArgsDict']]] = None,
                  include_browse: Optional[builtins.bool] = None,
                  schema_name: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFunctionsResult:
    """
    Retrieves a list of [User-Defined Functions (UDFs) registered in the Unity Catalog](https://docs.databricks.com/en/udf/unity-catalog.html).

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    List all functions defined in a specific schema (`main.default` in this example):

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_functions(catalog_name="main",
        schema_name="default")
    pulumi.export("allExternalLocations", all.functions)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Schema to get information about a single schema


    :param builtins.str catalog_name: Name of databricks_catalog.
    :param Sequence[Union['GetFunctionsFunctionArgs', 'GetFunctionsFunctionArgsDict']] functions: list of objects describing individual UDF. Each object consists of the following attributes (refer to [REST API documentation](https://docs.databricks.com/api/workspace/functions/list#functions) for up-to-date list of attributes. Default type is String):
    :param builtins.bool include_browse: flag to specify if include UDFs in the response for which the principal can only access selective metadata for.
    :param builtins.str schema_name: Name of databricks_schema.
    """
    __args__ = dict()
    __args__['catalogName'] = catalog_name
    __args__['functions'] = functions
    __args__['includeBrowse'] = include_browse
    __args__['schemaName'] = schema_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getFunctions:getFunctions', __args__, opts=opts, typ=GetFunctionsResult).value

    return AwaitableGetFunctionsResult(
        catalog_name=pulumi.get(__ret__, 'catalog_name'),
        functions=pulumi.get(__ret__, 'functions'),
        id=pulumi.get(__ret__, 'id'),
        include_browse=pulumi.get(__ret__, 'include_browse'),
        schema_name=pulumi.get(__ret__, 'schema_name'))
def get_functions_output(catalog_name: Optional[pulumi.Input[builtins.str]] = None,
                         functions: Optional[pulumi.Input[Optional[Sequence[Union['GetFunctionsFunctionArgs', 'GetFunctionsFunctionArgsDict']]]]] = None,
                         include_browse: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                         schema_name: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFunctionsResult]:
    """
    Retrieves a list of [User-Defined Functions (UDFs) registered in the Unity Catalog](https://docs.databricks.com/en/udf/unity-catalog.html).

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    List all functions defined in a specific schema (`main.default` in this example):

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_functions(catalog_name="main",
        schema_name="default")
    pulumi.export("allExternalLocations", all.functions)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Schema to get information about a single schema


    :param builtins.str catalog_name: Name of databricks_catalog.
    :param Sequence[Union['GetFunctionsFunctionArgs', 'GetFunctionsFunctionArgsDict']] functions: list of objects describing individual UDF. Each object consists of the following attributes (refer to [REST API documentation](https://docs.databricks.com/api/workspace/functions/list#functions) for up-to-date list of attributes. Default type is String):
    :param builtins.bool include_browse: flag to specify if include UDFs in the response for which the principal can only access selective metadata for.
    :param builtins.str schema_name: Name of databricks_schema.
    """
    __args__ = dict()
    __args__['catalogName'] = catalog_name
    __args__['functions'] = functions
    __args__['includeBrowse'] = include_browse
    __args__['schemaName'] = schema_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getFunctions:getFunctions', __args__, opts=opts, typ=GetFunctionsResult)
    return __ret__.apply(lambda __response__: GetFunctionsResult(
        catalog_name=pulumi.get(__response__, 'catalog_name'),
        functions=pulumi.get(__response__, 'functions'),
        id=pulumi.get(__response__, 'id'),
        include_browse=pulumi.get(__response__, 'include_browse'),
        schema_name=pulumi.get(__response__, 'schema_name')))
