# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMlflowExperimentResult',
    'AwaitableGetMlflowExperimentResult',
    'get_mlflow_experiment',
    'get_mlflow_experiment_output',
]

@pulumi.output_type
class GetMlflowExperimentResult:
    """
    A collection of values returned by getMlflowExperiment.
    """
    def __init__(__self__, artifact_location=None, creation_time=None, experiment_id=None, id=None, last_update_time=None, lifecycle_stage=None, name=None, tags=None):
        if artifact_location and not isinstance(artifact_location, str):
            raise TypeError("Expected argument 'artifact_location' to be a str")
        pulumi.set(__self__, "artifact_location", artifact_location)
        if creation_time and not isinstance(creation_time, int):
            raise TypeError("Expected argument 'creation_time' to be a int")
        pulumi.set(__self__, "creation_time", creation_time)
        if experiment_id and not isinstance(experiment_id, str):
            raise TypeError("Expected argument 'experiment_id' to be a str")
        pulumi.set(__self__, "experiment_id", experiment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_update_time and not isinstance(last_update_time, int):
            raise TypeError("Expected argument 'last_update_time' to be a int")
        pulumi.set(__self__, "last_update_time", last_update_time)
        if lifecycle_stage and not isinstance(lifecycle_stage, str):
            raise TypeError("Expected argument 'lifecycle_stage' to be a str")
        pulumi.set(__self__, "lifecycle_stage", lifecycle_stage)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="artifactLocation")
    def artifact_location(self) -> builtins.str:
        """
        Location where artifacts for the experiment are stored.
        """
        return pulumi.get(self, "artifact_location")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> builtins.int:
        """
        Creation time in unix time stamp.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="experimentId")
    def experiment_id(self) -> builtins.str:
        """
        Unique identifier for the experiment. (same as `id`)
        """
        return pulumi.get(self, "experiment_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier for the experiment. (same as `experiment_id`)
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> builtins.int:
        """
        Last update time in unix time stamp.
        """
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter(name="lifecycleStage")
    def lifecycle_stage(self) -> builtins.str:
        """
        Current life cycle stage of the experiment: `active` or `deleted`.
        """
        return pulumi.get(self, "lifecycle_stage")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Path to experiment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetMlflowExperimentTagResult']:
        """
        Additional metadata key-value pairs.
        """
        return pulumi.get(self, "tags")


class AwaitableGetMlflowExperimentResult(GetMlflowExperimentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMlflowExperimentResult(
            artifact_location=self.artifact_location,
            creation_time=self.creation_time,
            experiment_id=self.experiment_id,
            id=self.id,
            last_update_time=self.last_update_time,
            lifecycle_stage=self.lifecycle_stage,
            name=self.name,
            tags=self.tags)


def get_mlflow_experiment(artifact_location: Optional[builtins.str] = None,
                          creation_time: Optional[builtins.int] = None,
                          experiment_id: Optional[builtins.str] = None,
                          id: Optional[builtins.str] = None,
                          last_update_time: Optional[builtins.int] = None,
                          lifecycle_stage: Optional[builtins.str] = None,
                          name: Optional[builtins.str] = None,
                          tags: Optional[Sequence[Union['GetMlflowExperimentTagArgs', 'GetMlflowExperimentTagArgsDict']]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMlflowExperimentResult:
    """
    Retrieves the settings of MlflowExperiment by id or name.

    > This data source can only be used with a workspace-level provider!


    :param builtins.str artifact_location: Location where artifacts for the experiment are stored.
    :param builtins.int creation_time: Creation time in unix time stamp.
    :param builtins.str experiment_id: Unique identifier for the experiment.
    :param builtins.str id: Unique identifier for the experiment. (same as `experiment_id`)
    :param builtins.int last_update_time: Last update time in unix time stamp.
    :param builtins.str lifecycle_stage: Current life cycle stage of the experiment: `active` or `deleted`.
    :param builtins.str name: Path to experiment.
    :param Sequence[Union['GetMlflowExperimentTagArgs', 'GetMlflowExperimentTagArgsDict']] tags: Additional metadata key-value pairs.
    """
    __args__ = dict()
    __args__['artifactLocation'] = artifact_location
    __args__['creationTime'] = creation_time
    __args__['experimentId'] = experiment_id
    __args__['id'] = id
    __args__['lastUpdateTime'] = last_update_time
    __args__['lifecycleStage'] = lifecycle_stage
    __args__['name'] = name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getMlflowExperiment:getMlflowExperiment', __args__, opts=opts, typ=GetMlflowExperimentResult).value

    return AwaitableGetMlflowExperimentResult(
        artifact_location=pulumi.get(__ret__, 'artifact_location'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        experiment_id=pulumi.get(__ret__, 'experiment_id'),
        id=pulumi.get(__ret__, 'id'),
        last_update_time=pulumi.get(__ret__, 'last_update_time'),
        lifecycle_stage=pulumi.get(__ret__, 'lifecycle_stage'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_mlflow_experiment_output(artifact_location: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 creation_time: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                 experiment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 last_update_time: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                 lifecycle_stage: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 tags: Optional[pulumi.Input[Optional[Sequence[Union['GetMlflowExperimentTagArgs', 'GetMlflowExperimentTagArgsDict']]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMlflowExperimentResult]:
    """
    Retrieves the settings of MlflowExperiment by id or name.

    > This data source can only be used with a workspace-level provider!


    :param builtins.str artifact_location: Location where artifacts for the experiment are stored.
    :param builtins.int creation_time: Creation time in unix time stamp.
    :param builtins.str experiment_id: Unique identifier for the experiment.
    :param builtins.str id: Unique identifier for the experiment. (same as `experiment_id`)
    :param builtins.int last_update_time: Last update time in unix time stamp.
    :param builtins.str lifecycle_stage: Current life cycle stage of the experiment: `active` or `deleted`.
    :param builtins.str name: Path to experiment.
    :param Sequence[Union['GetMlflowExperimentTagArgs', 'GetMlflowExperimentTagArgsDict']] tags: Additional metadata key-value pairs.
    """
    __args__ = dict()
    __args__['artifactLocation'] = artifact_location
    __args__['creationTime'] = creation_time
    __args__['experimentId'] = experiment_id
    __args__['id'] = id
    __args__['lastUpdateTime'] = last_update_time
    __args__['lifecycleStage'] = lifecycle_stage
    __args__['name'] = name
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getMlflowExperiment:getMlflowExperiment', __args__, opts=opts, typ=GetMlflowExperimentResult)
    return __ret__.apply(lambda __response__: GetMlflowExperimentResult(
        artifact_location=pulumi.get(__response__, 'artifact_location'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        experiment_id=pulumi.get(__response__, 'experiment_id'),
        id=pulumi.get(__response__, 'id'),
        last_update_time=pulumi.get(__response__, 'last_update_time'),
        lifecycle_stage=pulumi.get(__response__, 'lifecycle_stage'),
        name=pulumi.get(__response__, 'name'),
        tags=pulumi.get(__response__, 'tags')))
