# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetMwsNetworkConnectivityConfigsResult',
    'AwaitableGetMwsNetworkConnectivityConfigsResult',
    'get_mws_network_connectivity_configs',
    'get_mws_network_connectivity_configs_output',
]

@pulumi.output_type
class GetMwsNetworkConnectivityConfigsResult:
    """
    A collection of values returned by getMwsNetworkConnectivityConfigs.
    """
    def __init__(__self__, id=None, names=None, region=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Sequence[builtins.str]:
        """
        List of names of databricks_mws_network_connectivity_config
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")


class AwaitableGetMwsNetworkConnectivityConfigsResult(GetMwsNetworkConnectivityConfigsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMwsNetworkConnectivityConfigsResult(
            id=self.id,
            names=self.names,
            region=self.region)


def get_mws_network_connectivity_configs(names: Optional[Sequence[builtins.str]] = None,
                                         region: Optional[builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMwsNetworkConnectivityConfigsResult:
    """
    Lists all MwsNetworkConnectivityConfig in Databricks Account.

    > This data source can only be used with an account-level provider!

    ## Example Usage

    List all network connectivity configurations in Databricks Account

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_mws_network_connectivity_configs()
    pulumi.export("all", this)
    ```

    List network connectivity configurations from a specific region in Databricks Account

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_mws_network_connectivity_configs(region="us-east-1")
    pulumi.export("filtered", this)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * MwsNetworkConnectivityConfig to get information about a single network connectivity configuration.
    * MwsNetworkConnectivityConfig to manage network connectivity configuration.


    :param Sequence[builtins.str] names: List of names of databricks_mws_network_connectivity_config
    :param builtins.str region: Filter network connectivity configurations by region.
    """
    __args__ = dict()
    __args__['names'] = names
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getMwsNetworkConnectivityConfigs:getMwsNetworkConnectivityConfigs', __args__, opts=opts, typ=GetMwsNetworkConnectivityConfigsResult).value

    return AwaitableGetMwsNetworkConnectivityConfigsResult(
        id=pulumi.get(__ret__, 'id'),
        names=pulumi.get(__ret__, 'names'),
        region=pulumi.get(__ret__, 'region'))
def get_mws_network_connectivity_configs_output(names: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                                region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMwsNetworkConnectivityConfigsResult]:
    """
    Lists all MwsNetworkConnectivityConfig in Databricks Account.

    > This data source can only be used with an account-level provider!

    ## Example Usage

    List all network connectivity configurations in Databricks Account

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_mws_network_connectivity_configs()
    pulumi.export("all", this)
    ```

    List network connectivity configurations from a specific region in Databricks Account

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_mws_network_connectivity_configs(region="us-east-1")
    pulumi.export("filtered", this)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * MwsNetworkConnectivityConfig to get information about a single network connectivity configuration.
    * MwsNetworkConnectivityConfig to manage network connectivity configuration.


    :param Sequence[builtins.str] names: List of names of databricks_mws_network_connectivity_config
    :param builtins.str region: Filter network connectivity configurations by region.
    """
    __args__ = dict()
    __args__['names'] = names
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getMwsNetworkConnectivityConfigs:getMwsNetworkConnectivityConfigs', __args__, opts=opts, typ=GetMwsNetworkConnectivityConfigsResult)
    return __ret__.apply(lambda __response__: GetMwsNetworkConnectivityConfigsResult(
        id=pulumi.get(__response__, 'id'),
        names=pulumi.get(__response__, 'names'),
        region=pulumi.get(__response__, 'region')))
