# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRegisteredModelVersionsResult',
    'AwaitableGetRegisteredModelVersionsResult',
    'get_registered_model_versions',
    'get_registered_model_versions_output',
]

@pulumi.output_type
class GetRegisteredModelVersionsResult:
    """
    A collection of values returned by getRegisteredModelVersions.
    """
    def __init__(__self__, full_name=None, id=None, model_versions=None):
        if full_name and not isinstance(full_name, str):
            raise TypeError("Expected argument 'full_name' to be a str")
        pulumi.set(__self__, "full_name", full_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if model_versions and not isinstance(model_versions, list):
            raise TypeError("Expected argument 'model_versions' to be a list")
        pulumi.set(__self__, "model_versions", model_versions)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> builtins.str:
        """
        The fully-qualified name of the registered model (`catalog_name.schema_name.name`).
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modelVersions")
    def model_versions(self) -> Sequence['outputs.GetRegisteredModelVersionsModelVersionResult']:
        """
        list of objects describing the model versions. Each object consists of following attributes:
        """
        return pulumi.get(self, "model_versions")


class AwaitableGetRegisteredModelVersionsResult(GetRegisteredModelVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegisteredModelVersionsResult(
            full_name=self.full_name,
            id=self.id,
            model_versions=self.model_versions)


def get_registered_model_versions(full_name: Optional[builtins.str] = None,
                                  model_versions: Optional[Sequence[Union['GetRegisteredModelVersionsModelVersionArgs', 'GetRegisteredModelVersionsModelVersionArgsDict']]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegisteredModelVersionsResult:
    """
    This resource allows you to get information about versions of [Model in Unity Catalog](https://docs.databricks.com/en/mlflow/models-in-uc.html).

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_registered_model_versions(full_name="main.default.my_model")
    ```

    ## Related Resources

    The following resources are often used in the same context:

    * RegisteredModel data source to retrieve information about a model within Unity Catalog.
    * RegisteredModel resource to manage models within Unity Catalog.
    * ModelServing to serve this model on a Databricks serving endpoint.
    * MlflowExperiment to manage [MLflow experiments](https://docs.databricks.com/data/data-sources/mlflow-experiment.html) in Databricks.


    :param builtins.str full_name: The fully-qualified name of the registered model (`catalog_name.schema_name.name`).
    :param Sequence[Union['GetRegisteredModelVersionsModelVersionArgs', 'GetRegisteredModelVersionsModelVersionArgsDict']] model_versions: list of objects describing the model versions. Each object consists of following attributes:
    """
    __args__ = dict()
    __args__['fullName'] = full_name
    __args__['modelVersions'] = model_versions
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getRegisteredModelVersions:getRegisteredModelVersions', __args__, opts=opts, typ=GetRegisteredModelVersionsResult).value

    return AwaitableGetRegisteredModelVersionsResult(
        full_name=pulumi.get(__ret__, 'full_name'),
        id=pulumi.get(__ret__, 'id'),
        model_versions=pulumi.get(__ret__, 'model_versions'))
def get_registered_model_versions_output(full_name: Optional[pulumi.Input[builtins.str]] = None,
                                         model_versions: Optional[pulumi.Input[Optional[Sequence[Union['GetRegisteredModelVersionsModelVersionArgs', 'GetRegisteredModelVersionsModelVersionArgsDict']]]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegisteredModelVersionsResult]:
    """
    This resource allows you to get information about versions of [Model in Unity Catalog](https://docs.databricks.com/en/mlflow/models-in-uc.html).

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_registered_model_versions(full_name="main.default.my_model")
    ```

    ## Related Resources

    The following resources are often used in the same context:

    * RegisteredModel data source to retrieve information about a model within Unity Catalog.
    * RegisteredModel resource to manage models within Unity Catalog.
    * ModelServing to serve this model on a Databricks serving endpoint.
    * MlflowExperiment to manage [MLflow experiments](https://docs.databricks.com/data/data-sources/mlflow-experiment.html) in Databricks.


    :param builtins.str full_name: The fully-qualified name of the registered model (`catalog_name.schema_name.name`).
    :param Sequence[Union['GetRegisteredModelVersionsModelVersionArgs', 'GetRegisteredModelVersionsModelVersionArgsDict']] model_versions: list of objects describing the model versions. Each object consists of following attributes:
    """
    __args__ = dict()
    __args__['fullName'] = full_name
    __args__['modelVersions'] = model_versions
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getRegisteredModelVersions:getRegisteredModelVersions', __args__, opts=opts, typ=GetRegisteredModelVersionsResult)
    return __ret__.apply(lambda __response__: GetRegisteredModelVersionsResult(
        full_name=pulumi.get(__response__, 'full_name'),
        id=pulumi.get(__response__, 'id'),
        model_versions=pulumi.get(__response__, 'model_versions')))
