# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetSchemasResult',
    'AwaitableGetSchemasResult',
    'get_schemas',
    'get_schemas_output',
]

@pulumi.output_type
class GetSchemasResult:
    """
    A collection of values returned by getSchemas.
    """
    def __init__(__self__, catalog_name=None, id=None, ids=None):
        if catalog_name and not isinstance(catalog_name, str):
            raise TypeError("Expected argument 'catalog_name' to be a str")
        pulumi.set(__self__, "catalog_name", catalog_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> builtins.str:
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[builtins.str]:
        """
        set of Schema full names: *`catalog`.`schema`*
        """
        return pulumi.get(self, "ids")


class AwaitableGetSchemasResult(GetSchemasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchemasResult(
            catalog_name=self.catalog_name,
            id=self.id,
            ids=self.ids)


def get_schemas(catalog_name: Optional[builtins.str] = None,
                ids: Optional[Sequence[builtins.str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchemasResult:
    """
    Retrieves a list of Schema ids, that were created by Pulumi or manually, so that special handling could be applied.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Listing all schemas in a _sandbox_ databricks_catalog:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    sandbox = databricks.get_schemas(catalog_name="sandbox")
    pulumi.export("allSandboxSchemas", sandbox)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Schema to manage schemas within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param builtins.str catalog_name: Name of databricks_catalog
    :param Sequence[builtins.str] ids: set of Schema full names: *`catalog`.`schema`*
    """
    __args__ = dict()
    __args__['catalogName'] = catalog_name
    __args__['ids'] = ids
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getSchemas:getSchemas', __args__, opts=opts, typ=GetSchemasResult).value

    return AwaitableGetSchemasResult(
        catalog_name=pulumi.get(__ret__, 'catalog_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'))
def get_schemas_output(catalog_name: Optional[pulumi.Input[builtins.str]] = None,
                       ids: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchemasResult]:
    """
    Retrieves a list of Schema ids, that were created by Pulumi or manually, so that special handling could be applied.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Listing all schemas in a _sandbox_ databricks_catalog:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    sandbox = databricks.get_schemas(catalog_name="sandbox")
    pulumi.export("allSandboxSchemas", sandbox)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Schema to manage schemas within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param builtins.str catalog_name: Name of databricks_catalog
    :param Sequence[builtins.str] ids: set of Schema full names: *`catalog`.`schema`*
    """
    __args__ = dict()
    __args__['catalogName'] = catalog_name
    __args__['ids'] = ids
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getSchemas:getSchemas', __args__, opts=opts, typ=GetSchemasResult)
    return __ret__.apply(lambda __response__: GetSchemasResult(
        catalog_name=pulumi.get(__response__, 'catalog_name'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids')))
