# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetSharesResult',
    'AwaitableGetSharesResult',
    'get_shares',
    'get_shares_output',
]

@pulumi.output_type
class GetSharesResult:
    """
    A collection of values returned by getShares.
    """
    def __init__(__self__, id=None, shares=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if shares and not isinstance(shares, list):
            raise TypeError("Expected argument 'shares' to be a list")
        pulumi.set(__self__, "shares", shares)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def shares(self) -> Sequence[builtins.str]:
        """
        list of Share names.
        """
        return pulumi.get(self, "shares")


class AwaitableGetSharesResult(GetSharesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSharesResult(
            id=self.id,
            shares=self.shares)


def get_shares(shares: Optional[Sequence[builtins.str]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSharesResult:
    """
    Retrieves a list of Share name, that were created by Pulumi or manually.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Getting all existing shares in the metastore

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_shares()
    pulumi.export("shareName", this.shares)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Share to create Delta Sharing shares.
    * Recipient to create Delta Sharing recipients.
    * Grants to manage Delta Sharing permissions.


    :param Sequence[builtins.str] shares: list of Share names.
    """
    __args__ = dict()
    __args__['shares'] = shares
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getShares:getShares', __args__, opts=opts, typ=GetSharesResult).value

    return AwaitableGetSharesResult(
        id=pulumi.get(__ret__, 'id'),
        shares=pulumi.get(__ret__, 'shares'))
def get_shares_output(shares: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSharesResult]:
    """
    Retrieves a list of Share name, that were created by Pulumi or manually.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Getting all existing shares in the metastore

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_shares()
    pulumi.export("shareName", this.shares)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Share to create Delta Sharing shares.
    * Recipient to create Delta Sharing recipients.
    * Grants to manage Delta Sharing permissions.


    :param Sequence[builtins.str] shares: list of Share names.
    """
    __args__ = dict()
    __args__['shares'] = shares
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getShares:getShares', __args__, opts=opts, typ=GetSharesResult)
    return __ret__.apply(lambda __response__: GetSharesResult(
        id=pulumi.get(__response__, 'id'),
        shares=pulumi.get(__response__, 'shares')))
