# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetStorageCredentialsResult',
    'AwaitableGetStorageCredentialsResult',
    'get_storage_credentials',
    'get_storage_credentials_output',
]

@pulumi.output_type
class GetStorageCredentialsResult:
    """
    A collection of values returned by getStorageCredentials.
    """
    def __init__(__self__, id=None, names=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Sequence[builtins.str]:
        """
        List of names of StorageCredential in the metastore
        """
        return pulumi.get(self, "names")


class AwaitableGetStorageCredentialsResult(GetStorageCredentialsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStorageCredentialsResult(
            id=self.id,
            names=self.names)


def get_storage_credentials(names: Optional[Sequence[builtins.str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStorageCredentialsResult:
    """
    Retrieves a list of StorageCredential objects, that were created by Pulumi or manually, so that special handling could be applied.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    List all storage credentials in the metastore

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_storage_credentials()
    pulumi.export("allStorageCredentials", all.names)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * StorageCredential to get information about a single credential
    * StorageCredential to manage Storage Credentials within Unity Catalog.


    :param Sequence[builtins.str] names: List of names of StorageCredential in the metastore
    """
    __args__ = dict()
    __args__['names'] = names
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getStorageCredentials:getStorageCredentials', __args__, opts=opts, typ=GetStorageCredentialsResult).value

    return AwaitableGetStorageCredentialsResult(
        id=pulumi.get(__ret__, 'id'),
        names=pulumi.get(__ret__, 'names'))
def get_storage_credentials_output(names: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStorageCredentialsResult]:
    """
    Retrieves a list of StorageCredential objects, that were created by Pulumi or manually, so that special handling could be applied.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    List all storage credentials in the metastore

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_storage_credentials()
    pulumi.export("allStorageCredentials", all.names)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * StorageCredential to get information about a single credential
    * StorageCredential to manage Storage Credentials within Unity Catalog.


    :param Sequence[builtins.str] names: List of names of StorageCredential in the metastore
    """
    __args__ = dict()
    __args__['names'] = names
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getStorageCredentials:getStorageCredentials', __args__, opts=opts, typ=GetStorageCredentialsResult)
    return __ret__.apply(lambda __response__: GetStorageCredentialsResult(
        id=pulumi.get(__response__, 'id'),
        names=pulumi.get(__response__, 'names')))
