# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetVolumesResult',
    'AwaitableGetVolumesResult',
    'get_volumes',
    'get_volumes_output',
]

@pulumi.output_type
class GetVolumesResult:
    """
    A collection of values returned by getVolumes.
    """
    def __init__(__self__, catalog_name=None, id=None, ids=None, schema_name=None):
        if catalog_name and not isinstance(catalog_name, str):
            raise TypeError("Expected argument 'catalog_name' to be a str")
        pulumi.set(__self__, "catalog_name", catalog_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if schema_name and not isinstance(schema_name, str):
            raise TypeError("Expected argument 'schema_name' to be a str")
        pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> builtins.str:
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[builtins.str]:
        """
        a list of Volume full names: *`catalog`.`schema`.`volume`*
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> builtins.str:
        return pulumi.get(self, "schema_name")


class AwaitableGetVolumesResult(GetVolumesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumesResult(
            catalog_name=self.catalog_name,
            id=self.id,
            ids=self.ids,
            schema_name=self.schema_name)


def get_volumes(catalog_name: Optional[builtins.str] = None,
                ids: Optional[Sequence[builtins.str]] = None,
                schema_name: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumesResult:
    """
    Retrieves a list of Volume ids (full names), that were created by Pulumi or manually.

    > This data source can only be used with a workspace-level provider!

    ## Plugin Framework Migration

    The volumes data source has been migrated from sdkv2 to plugin framework in version 1.57。 If you encounter any problem with this data source and suspect it is due to the migration, you can fallback to sdkv2 by setting the environment variable in the following way `export USE_SDK_V2_DATA_SOURCES="get_volumes"`.

    ## Example Usage

    Listing all volumes in a _things_ Schema of a  _sandbox_ databricks_catalog:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_volumes(catalog_name="sandbox",
        schema_name="things")
    pulumi.export("allVolumes", this)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Volume to manage volumes within Unity Catalog.
    * Schema to manage schemas within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param builtins.str catalog_name: Name of databricks_catalog
    :param Sequence[builtins.str] ids: a list of Volume full names: *`catalog`.`schema`.`volume`*
    :param builtins.str schema_name: Name of databricks_schema
    """
    __args__ = dict()
    __args__['catalogName'] = catalog_name
    __args__['ids'] = ids
    __args__['schemaName'] = schema_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getVolumes:getVolumes', __args__, opts=opts, typ=GetVolumesResult).value

    return AwaitableGetVolumesResult(
        catalog_name=pulumi.get(__ret__, 'catalog_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        schema_name=pulumi.get(__ret__, 'schema_name'))
def get_volumes_output(catalog_name: Optional[pulumi.Input[builtins.str]] = None,
                       ids: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                       schema_name: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumesResult]:
    """
    Retrieves a list of Volume ids (full names), that were created by Pulumi or manually.

    > This data source can only be used with a workspace-level provider!

    ## Plugin Framework Migration

    The volumes data source has been migrated from sdkv2 to plugin framework in version 1.57。 If you encounter any problem with this data source and suspect it is due to the migration, you can fallback to sdkv2 by setting the environment variable in the following way `export USE_SDK_V2_DATA_SOURCES="get_volumes"`.

    ## Example Usage

    Listing all volumes in a _things_ Schema of a  _sandbox_ databricks_catalog:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_volumes(catalog_name="sandbox",
        schema_name="things")
    pulumi.export("allVolumes", this)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Volume to manage volumes within Unity Catalog.
    * Schema to manage schemas within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param builtins.str catalog_name: Name of databricks_catalog
    :param Sequence[builtins.str] ids: a list of Volume full names: *`catalog`.`schema`.`volume`*
    :param builtins.str schema_name: Name of databricks_schema
    """
    __args__ = dict()
    __args__['catalogName'] = catalog_name
    __args__['ids'] = ids
    __args__['schemaName'] = schema_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getVolumes:getVolumes', __args__, opts=opts, typ=GetVolumesResult)
    return __ret__.apply(lambda __response__: GetVolumesResult(
        catalog_name=pulumi.get(__response__, 'catalog_name'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        schema_name=pulumi.get(__response__, 'schema_name')))
