# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GitCredentialArgs', 'GitCredential']

@pulumi.input_type
class GitCredentialArgs:
    def __init__(__self__, *,
                 git_provider: pulumi.Input[builtins.str],
                 force: Optional[pulumi.Input[builtins.bool]] = None,
                 git_username: Optional[pulumi.Input[builtins.str]] = None,
                 personal_access_token: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a GitCredential resource.
        :param pulumi.Input[builtins.str] git_provider: case insensitive name of the Git provider.  Following values are supported right now (could be a subject for a change, consult [Git Credentials API documentation](https://docs.databricks.com/dev-tools/api/latest/gitcredentials.html)): `gitHub`, `gitHubEnterprise`, `bitbucketCloud`, `bitbucketServer`, `azureDevOpsServices`, `gitLab`, `gitLabEnterpriseEdition`, `awsCodeCommit`, `azureDevOpsServicesAad`.
        :param pulumi.Input[builtins.bool] force: specify if settings need to be enforced - right now, Databricks allows only single Git credential, so if it's already configured, the apply operation will fail.
        :param pulumi.Input[builtins.str] git_username: user name at Git provider.
        :param pulumi.Input[builtins.str] personal_access_token: The personal access token used to authenticate to the corresponding Git provider. If value is not provided, it's sourced from the first environment variable of `GITHUB_TOKEN`, `GITLAB_TOKEN`, or `AZDO_PERSONAL_ACCESS_TOKEN`, that has a non-empty value.
        """
        pulumi.set(__self__, "git_provider", git_provider)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if git_username is not None:
            pulumi.set(__self__, "git_username", git_username)
        if personal_access_token is not None:
            pulumi.set(__self__, "personal_access_token", personal_access_token)

    @property
    @pulumi.getter(name="gitProvider")
    def git_provider(self) -> pulumi.Input[builtins.str]:
        """
        case insensitive name of the Git provider.  Following values are supported right now (could be a subject for a change, consult [Git Credentials API documentation](https://docs.databricks.com/dev-tools/api/latest/gitcredentials.html)): `gitHub`, `gitHubEnterprise`, `bitbucketCloud`, `bitbucketServer`, `azureDevOpsServices`, `gitLab`, `gitLabEnterpriseEdition`, `awsCodeCommit`, `azureDevOpsServicesAad`.
        """
        return pulumi.get(self, "git_provider")

    @git_provider.setter
    def git_provider(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "git_provider", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        specify if settings need to be enforced - right now, Databricks allows only single Git credential, so if it's already configured, the apply operation will fail.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter(name="gitUsername")
    def git_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        user name at Git provider.
        """
        return pulumi.get(self, "git_username")

    @git_username.setter
    def git_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "git_username", value)

    @property
    @pulumi.getter(name="personalAccessToken")
    def personal_access_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The personal access token used to authenticate to the corresponding Git provider. If value is not provided, it's sourced from the first environment variable of `GITHUB_TOKEN`, `GITLAB_TOKEN`, or `AZDO_PERSONAL_ACCESS_TOKEN`, that has a non-empty value.
        """
        return pulumi.get(self, "personal_access_token")

    @personal_access_token.setter
    def personal_access_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "personal_access_token", value)


@pulumi.input_type
class _GitCredentialState:
    def __init__(__self__, *,
                 force: Optional[pulumi.Input[builtins.bool]] = None,
                 git_provider: Optional[pulumi.Input[builtins.str]] = None,
                 git_username: Optional[pulumi.Input[builtins.str]] = None,
                 personal_access_token: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GitCredential resources.
        :param pulumi.Input[builtins.bool] force: specify if settings need to be enforced - right now, Databricks allows only single Git credential, so if it's already configured, the apply operation will fail.
        :param pulumi.Input[builtins.str] git_provider: case insensitive name of the Git provider.  Following values are supported right now (could be a subject for a change, consult [Git Credentials API documentation](https://docs.databricks.com/dev-tools/api/latest/gitcredentials.html)): `gitHub`, `gitHubEnterprise`, `bitbucketCloud`, `bitbucketServer`, `azureDevOpsServices`, `gitLab`, `gitLabEnterpriseEdition`, `awsCodeCommit`, `azureDevOpsServicesAad`.
        :param pulumi.Input[builtins.str] git_username: user name at Git provider.
        :param pulumi.Input[builtins.str] personal_access_token: The personal access token used to authenticate to the corresponding Git provider. If value is not provided, it's sourced from the first environment variable of `GITHUB_TOKEN`, `GITLAB_TOKEN`, or `AZDO_PERSONAL_ACCESS_TOKEN`, that has a non-empty value.
        """
        if force is not None:
            pulumi.set(__self__, "force", force)
        if git_provider is not None:
            pulumi.set(__self__, "git_provider", git_provider)
        if git_username is not None:
            pulumi.set(__self__, "git_username", git_username)
        if personal_access_token is not None:
            pulumi.set(__self__, "personal_access_token", personal_access_token)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        specify if settings need to be enforced - right now, Databricks allows only single Git credential, so if it's already configured, the apply operation will fail.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter(name="gitProvider")
    def git_provider(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        case insensitive name of the Git provider.  Following values are supported right now (could be a subject for a change, consult [Git Credentials API documentation](https://docs.databricks.com/dev-tools/api/latest/gitcredentials.html)): `gitHub`, `gitHubEnterprise`, `bitbucketCloud`, `bitbucketServer`, `azureDevOpsServices`, `gitLab`, `gitLabEnterpriseEdition`, `awsCodeCommit`, `azureDevOpsServicesAad`.
        """
        return pulumi.get(self, "git_provider")

    @git_provider.setter
    def git_provider(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "git_provider", value)

    @property
    @pulumi.getter(name="gitUsername")
    def git_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        user name at Git provider.
        """
        return pulumi.get(self, "git_username")

    @git_username.setter
    def git_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "git_username", value)

    @property
    @pulumi.getter(name="personalAccessToken")
    def personal_access_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The personal access token used to authenticate to the corresponding Git provider. If value is not provided, it's sourced from the first environment variable of `GITHUB_TOKEN`, `GITLAB_TOKEN`, or `AZDO_PERSONAL_ACCESS_TOKEN`, that has a non-empty value.
        """
        return pulumi.get(self, "personal_access_token")

    @personal_access_token.setter
    def personal_access_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "personal_access_token", value)


@pulumi.type_token("databricks:index/gitCredential:GitCredential")
class GitCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force: Optional[pulumi.Input[builtins.bool]] = None,
                 git_provider: Optional[pulumi.Input[builtins.str]] = None,
                 git_username: Optional[pulumi.Input[builtins.str]] = None,
                 personal_access_token: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to manage credentials for [Databricks Repos](https://docs.databricks.com/repos.html) using [Git Credentials API](https://docs.databricks.com/dev-tools/api/latest/gitcredentials.html).

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        You can declare Pulumi-managed Git credential using following code:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        ado = databricks.GitCredential("ado",
            git_username="myuser",
            git_provider="azureDevOpsServices",
            personal_access_token="sometoken")
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * Repo to manage Databricks Repos.

        ## Import

        The resource cluster can be imported using ID of Git credential that could be obtained via REST API:

        hcl

        import {

          to = databricks_git_credential.this

          id = "<git-credential-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/gitCredential:GitCredential this <git-credential-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] force: specify if settings need to be enforced - right now, Databricks allows only single Git credential, so if it's already configured, the apply operation will fail.
        :param pulumi.Input[builtins.str] git_provider: case insensitive name of the Git provider.  Following values are supported right now (could be a subject for a change, consult [Git Credentials API documentation](https://docs.databricks.com/dev-tools/api/latest/gitcredentials.html)): `gitHub`, `gitHubEnterprise`, `bitbucketCloud`, `bitbucketServer`, `azureDevOpsServices`, `gitLab`, `gitLabEnterpriseEdition`, `awsCodeCommit`, `azureDevOpsServicesAad`.
        :param pulumi.Input[builtins.str] git_username: user name at Git provider.
        :param pulumi.Input[builtins.str] personal_access_token: The personal access token used to authenticate to the corresponding Git provider. If value is not provided, it's sourced from the first environment variable of `GITHUB_TOKEN`, `GITLAB_TOKEN`, or `AZDO_PERSONAL_ACCESS_TOKEN`, that has a non-empty value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage credentials for [Databricks Repos](https://docs.databricks.com/repos.html) using [Git Credentials API](https://docs.databricks.com/dev-tools/api/latest/gitcredentials.html).

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        You can declare Pulumi-managed Git credential using following code:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        ado = databricks.GitCredential("ado",
            git_username="myuser",
            git_provider="azureDevOpsServices",
            personal_access_token="sometoken")
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * Repo to manage Databricks Repos.

        ## Import

        The resource cluster can be imported using ID of Git credential that could be obtained via REST API:

        hcl

        import {

          to = databricks_git_credential.this

          id = "<git-credential-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/gitCredential:GitCredential this <git-credential-id>
        ```

        :param str resource_name: The name of the resource.
        :param GitCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force: Optional[pulumi.Input[builtins.bool]] = None,
                 git_provider: Optional[pulumi.Input[builtins.str]] = None,
                 git_username: Optional[pulumi.Input[builtins.str]] = None,
                 personal_access_token: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitCredentialArgs.__new__(GitCredentialArgs)

            __props__.__dict__["force"] = force
            if git_provider is None and not opts.urn:
                raise TypeError("Missing required property 'git_provider'")
            __props__.__dict__["git_provider"] = git_provider
            __props__.__dict__["git_username"] = git_username
            __props__.__dict__["personal_access_token"] = personal_access_token
        super(GitCredential, __self__).__init__(
            'databricks:index/gitCredential:GitCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            force: Optional[pulumi.Input[builtins.bool]] = None,
            git_provider: Optional[pulumi.Input[builtins.str]] = None,
            git_username: Optional[pulumi.Input[builtins.str]] = None,
            personal_access_token: Optional[pulumi.Input[builtins.str]] = None) -> 'GitCredential':
        """
        Get an existing GitCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] force: specify if settings need to be enforced - right now, Databricks allows only single Git credential, so if it's already configured, the apply operation will fail.
        :param pulumi.Input[builtins.str] git_provider: case insensitive name of the Git provider.  Following values are supported right now (could be a subject for a change, consult [Git Credentials API documentation](https://docs.databricks.com/dev-tools/api/latest/gitcredentials.html)): `gitHub`, `gitHubEnterprise`, `bitbucketCloud`, `bitbucketServer`, `azureDevOpsServices`, `gitLab`, `gitLabEnterpriseEdition`, `awsCodeCommit`, `azureDevOpsServicesAad`.
        :param pulumi.Input[builtins.str] git_username: user name at Git provider.
        :param pulumi.Input[builtins.str] personal_access_token: The personal access token used to authenticate to the corresponding Git provider. If value is not provided, it's sourced from the first environment variable of `GITHUB_TOKEN`, `GITLAB_TOKEN`, or `AZDO_PERSONAL_ACCESS_TOKEN`, that has a non-empty value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitCredentialState.__new__(_GitCredentialState)

        __props__.__dict__["force"] = force
        __props__.__dict__["git_provider"] = git_provider
        __props__.__dict__["git_username"] = git_username
        __props__.__dict__["personal_access_token"] = personal_access_token
        return GitCredential(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        specify if settings need to be enforced - right now, Databricks allows only single Git credential, so if it's already configured, the apply operation will fail.
        """
        return pulumi.get(self, "force")

    @property
    @pulumi.getter(name="gitProvider")
    def git_provider(self) -> pulumi.Output[builtins.str]:
        """
        case insensitive name of the Git provider.  Following values are supported right now (could be a subject for a change, consult [Git Credentials API documentation](https://docs.databricks.com/dev-tools/api/latest/gitcredentials.html)): `gitHub`, `gitHubEnterprise`, `bitbucketCloud`, `bitbucketServer`, `azureDevOpsServices`, `gitLab`, `gitLabEnterpriseEdition`, `awsCodeCommit`, `azureDevOpsServicesAad`.
        """
        return pulumi.get(self, "git_provider")

    @property
    @pulumi.getter(name="gitUsername")
    def git_username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        user name at Git provider.
        """
        return pulumi.get(self, "git_username")

    @property
    @pulumi.getter(name="personalAccessToken")
    def personal_access_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The personal access token used to authenticate to the corresponding Git provider. If value is not provided, it's sourced from the first environment variable of `GITHUB_TOKEN`, `GITLAB_TOKEN`, or `AZDO_PERSONAL_ACCESS_TOKEN`, that has a non-empty value.
        """
        return pulumi.get(self, "personal_access_token")

