# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GrantArgs', 'Grant']

@pulumi.input_type
class GrantArgs:
    def __init__(__self__, *,
                 principal: pulumi.Input[builtins.str],
                 privileges: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 credential: Optional[pulumi.Input[builtins.str]] = None,
                 external_location: Optional[pulumi.Input[builtins.str]] = None,
                 foreign_connection: Optional[pulumi.Input[builtins.str]] = None,
                 function: Optional[pulumi.Input[builtins.str]] = None,
                 metastore: Optional[pulumi.Input[builtins.str]] = None,
                 model: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline: Optional[pulumi.Input[builtins.str]] = None,
                 recipient: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 share: Optional[pulumi.Input[builtins.str]] = None,
                 storage_credential: Optional[pulumi.Input[builtins.str]] = None,
                 table: Optional[pulumi.Input[builtins.str]] = None,
                 volume: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Grant resource.
        """
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "privileges", privileges)
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)
        if external_location is not None:
            pulumi.set(__self__, "external_location", external_location)
        if foreign_connection is not None:
            pulumi.set(__self__, "foreign_connection", foreign_connection)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if metastore is not None:
            pulumi.set(__self__, "metastore", metastore)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if recipient is not None:
            pulumi.set(__self__, "recipient", recipient)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if share is not None:
            pulumi.set(__self__, "share", share)
        if storage_credential is not None:
            pulumi.set(__self__, "storage_credential", storage_credential)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal", value)

    @property
    @pulumi.getter
    def privileges(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        return pulumi.get(self, "privileges")

    @privileges.setter
    def privileges(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "privileges", value)

    @property
    @pulumi.getter
    def catalog(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog", value)

    @property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter(name="externalLocation")
    def external_location(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "external_location")

    @external_location.setter
    def external_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_location", value)

    @property
    @pulumi.getter(name="foreignConnection")
    def foreign_connection(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "foreign_connection")

    @foreign_connection.setter
    def foreign_connection(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "foreign_connection", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter
    def metastore(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "metastore")

    @metastore.setter
    def metastore(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metastore", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter
    def recipient(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "recipient")

    @recipient.setter
    def recipient(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recipient", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def share(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "share")

    @share.setter
    def share(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "share", value)

    @property
    @pulumi.getter(name="storageCredential")
    def storage_credential(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "storage_credential")

    @storage_credential.setter
    def storage_credential(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_credential", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter
    def volume(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume", value)


@pulumi.input_type
class _GrantState:
    def __init__(__self__, *,
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 credential: Optional[pulumi.Input[builtins.str]] = None,
                 external_location: Optional[pulumi.Input[builtins.str]] = None,
                 foreign_connection: Optional[pulumi.Input[builtins.str]] = None,
                 function: Optional[pulumi.Input[builtins.str]] = None,
                 metastore: Optional[pulumi.Input[builtins.str]] = None,
                 model: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline: Optional[pulumi.Input[builtins.str]] = None,
                 principal: Optional[pulumi.Input[builtins.str]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 recipient: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 share: Optional[pulumi.Input[builtins.str]] = None,
                 storage_credential: Optional[pulumi.Input[builtins.str]] = None,
                 table: Optional[pulumi.Input[builtins.str]] = None,
                 volume: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Grant resources.
        """
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)
        if external_location is not None:
            pulumi.set(__self__, "external_location", external_location)
        if foreign_connection is not None:
            pulumi.set(__self__, "foreign_connection", foreign_connection)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if metastore is not None:
            pulumi.set(__self__, "metastore", metastore)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if privileges is not None:
            pulumi.set(__self__, "privileges", privileges)
        if recipient is not None:
            pulumi.set(__self__, "recipient", recipient)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if share is not None:
            pulumi.set(__self__, "share", share)
        if storage_credential is not None:
            pulumi.set(__self__, "storage_credential", storage_credential)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def catalog(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog", value)

    @property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter(name="externalLocation")
    def external_location(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "external_location")

    @external_location.setter
    def external_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_location", value)

    @property
    @pulumi.getter(name="foreignConnection")
    def foreign_connection(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "foreign_connection")

    @foreign_connection.setter
    def foreign_connection(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "foreign_connection", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter
    def metastore(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "metastore")

    @metastore.setter
    def metastore(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metastore", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal", value)

    @property
    @pulumi.getter
    def privileges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "privileges")

    @privileges.setter
    def privileges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "privileges", value)

    @property
    @pulumi.getter
    def recipient(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "recipient")

    @recipient.setter
    def recipient(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recipient", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def share(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "share")

    @share.setter
    def share(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "share", value)

    @property
    @pulumi.getter(name="storageCredential")
    def storage_credential(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "storage_credential")

    @storage_credential.setter
    def storage_credential(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_credential", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter
    def volume(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume", value)


@pulumi.type_token("databricks:index/grant:Grant")
class Grant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 credential: Optional[pulumi.Input[builtins.str]] = None,
                 external_location: Optional[pulumi.Input[builtins.str]] = None,
                 foreign_connection: Optional[pulumi.Input[builtins.str]] = None,
                 function: Optional[pulumi.Input[builtins.str]] = None,
                 metastore: Optional[pulumi.Input[builtins.str]] = None,
                 model: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline: Optional[pulumi.Input[builtins.str]] = None,
                 principal: Optional[pulumi.Input[builtins.str]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 recipient: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 share: Optional[pulumi.Input[builtins.str]] = None,
                 storage_credential: Optional[pulumi.Input[builtins.str]] = None,
                 table: Optional[pulumi.Input[builtins.str]] = None,
                 volume: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > This article refers to the privileges and inheritance model in Privilege Model version 1.0. If you created your metastore during the public preview (before August 25, 2022), you can upgrade to Privilege Model version 1.0 following [Upgrade to privilege inheritance](https://docs.databricks.com/data-governance/unity-catalog/hive-metastore.html)

        > Most of Unity Catalog APIs are only accessible via **workspace-level APIs**. This design may change in the future. Account-level principal grants can be assigned with any valid workspace as the Unity Catalog is decoupled from specific workspaces. More information in [the official documentation](https://docs.databricks.com/data-governance/unity-catalog/index.html).

        In Unity Catalog all users initially have no access to data. Only Metastore Admins can create objects and can grant/revoke access on individual objects to users and groups. Every securable object in Unity Catalog has an owner. The owner can be any account-level user or group, called principals in general. The principal that creates an object becomes its owner. Owners receive `ALL_PRIVILEGES` on the securable object (e.g., `SELECT` and `MODIFY` on a table), as well as the permission to grant privileges to other principals.

        Securable objects are hierarchical and privileges are inherited downward. The highest level object that privileges are inherited from is the catalog. This means that granting a privilege on a catalog or schema automatically grants the privilege to all current and future objects within the catalog or schema. Privileges that are granted on a metastore are not inherited.

        Every `Grant` resource must have exactly one securable identifier and the following arguments:

        - `principal` - User name, group name or service principal application ID.
        - `privileges` - One or more privileges that are specific to a securable type.

        For the latest list of privilege types that apply to each securable object in Unity Catalog, please refer to the [official documentation](https://docs.databricks.com/en/data-governance/unity-catalog/manage-privileges/privileges.html#privilege-types-by-securable-object-in-unity-catalog)

        Pulumi will handle any configuration drift for the specified principal on every `pulumi up` run, even when grants are changed outside of Pulumi state.

        See Grants for the list of privilege types that apply to each securable object.

        ## Metastore grants

        See Grants Metastore grants for the list of privileges that apply to Metastores.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sandbox_data_engineers = databricks.Grant("sandbox_data_engineers",
            metastore="metastore_id",
            principal="Data Engineers",
            privileges=[
                "CREATE_CATALOG",
                "CREATE_EXTERNAL_LOCATION",
            ])
        sandbox_data_sharer = databricks.Grant("sandbox_data_sharer",
            metastore="metastore_id",
            principal="Data Sharer",
            privileges=[
                "CREATE_RECIPIENT",
                "CREATE_SHARE",
            ])
        ```

        ## Catalog grants

        See Grants Catalog grants for the list of privileges that apply to Catalogs.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sandbox = databricks.Catalog("sandbox",
            name="sandbox",
            comment="this catalog is managed by terraform",
            properties={
                "purpose": "testing",
            })
        sandbox_data_scientists = databricks.Grant("sandbox_data_scientists",
            catalog=sandbox.name,
            principal="Data Scientists",
            privileges=[
                "USE_CATALOG",
                "USE_SCHEMA",
                "CREATE_TABLE",
                "SELECT",
            ])
        sandbox_data_engineers = databricks.Grant("sandbox_data_engineers",
            catalog=sandbox.name,
            principal="Data Engineers",
            privileges=[
                "USE_CATALOG",
                "USE_SCHEMA",
                "CREATE_SCHEMA",
                "CREATE_TABLE",
                "MODIFY",
            ])
        sandbox_data_analyst = databricks.Grant("sandbox_data_analyst",
            catalog=sandbox.name,
            principal="Data Analyst",
            privileges=[
                "USE_CATALOG",
                "USE_SCHEMA",
                "SELECT",
            ])
        ```

        ## Schema grants

        See Grants Schema grants for the list of privileges that apply to Schemas.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        things = databricks.Schema("things",
            catalog_name=sandbox["id"],
            name="things",
            comment="this schema is managed by terraform",
            properties={
                "kind": "various",
            })
        things_grant = databricks.Grant("things",
            schema=things.id,
            principal="Data Engineers",
            privileges=[
                "USE_SCHEMA",
                "MODIFY",
            ])
        ```

        ## Table grants

        See Grants Table grants for the list of privileges that apply to Tables.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        customers_data_engineers = databricks.Grant("customers_data_engineers",
            table="main.reporting.customers",
            principal="Data Engineers",
            privileges=[
                "MODIFY",
                "SELECT",
            ])
        customers_data_analysts = databricks.Grant("customers_data_analysts",
            table="main.reporting.customers",
            principal="Data Analysts",
            privileges=["SELECT"])
        ```

        You can also apply grants dynamically with get_tables data resource:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        things = databricks.get_tables(catalog_name="sandbox",
            schema_name="things")
        things_grant = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate(things.ids)]:
            things_grant.append(databricks.Grant(f"things-{range['key']}",
                table=range["value"],
                principal="sensitive",
                privileges=[
                    "SELECT",
                    "MODIFY",
                ]))
        ```

        ## View grants

        See Grants View grants for the list of privileges that apply to Views.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        customer360 = databricks.Grant("customer360",
            table="main.reporting.customer360",
            principal="Data Analysts",
            privileges=["SELECT"])
        ```

        You can also apply grants dynamically with get_views data resource:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        customers = databricks.get_views(catalog_name="main",
            schema_name="customers")
        customers_grant = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate(customers.ids)]:
            customers_grant.append(databricks.Grant(f"customers-{range['key']}",
                table=range["value"],
                principal="sensitive",
                privileges=[
                    "SELECT",
                    "MODIFY",
                ]))
        ```

        ## Volume grants

        See Grants Volume grants for the list of privileges that apply to Volumes.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.Volume("this",
            name="quickstart_volume",
            catalog_name=sandbox["name"],
            schema_name=things["name"],
            volume_type="EXTERNAL",
            storage_location=some["url"],
            comment="this volume is managed by terraform")
        volume = databricks.Grant("volume",
            volume=this.id,
            principal="Data Engineers",
            privileges=["WRITE_VOLUME"])
        ```

        ## Registered model grants

        See Grants Registered model grants for the list of privileges that apply to Registered models.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        customers_data_engineers = databricks.Grant("customers_data_engineers",
            model="main.reporting.customer_model",
            principal="Data Engineers",
            privileges=[
                "APPLY_TAG",
                "EXECUTE",
            ])
        customers_data_analysts = databricks.Grant("customers_data_analysts",
            model="main.reporting.customer_model",
            principal="Data Analysts",
            privileges=["EXECUTE"])
        ```

        ## Function grants

        See Grants Function grants for the list of privileges that apply to Registered models.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        udf_data_engineers = databricks.Grant("udf_data_engineers",
            function="main.reporting.udf",
            principal="Data Engineers",
            privileges=["EXECUTE"])
        udf_data_analysts = databricks.Grant("udf_data_analysts",
            function="main.reporting.udf",
            principal="Data Analysts",
            privileges=["EXECUTE"])
        ```

        ## Service credential grants

        See Grants Service credential grants for the list of privileges that apply to Service credentials.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        external = databricks.Credential("external",
            name=external_data_access["name"],
            aws_iam_role={
                "role_arn": external_data_access["arn"],
            },
            purpose="SERVICE",
            comment="Managed by TF")
        external_creds = databricks.Grant("external_creds",
            credential=external.id,
            principal="Data Engineers",
            privileges=["ACCESS"])
        ```

        ## Storage credential grants

        See Grants Storage credential grants for the list of privileges that apply to Storage credentials.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        external = databricks.StorageCredential("external",
            name=external_data_access["name"],
            aws_iam_role={
                "role_arn": external_data_access["arn"],
            },
            comment="Managed by TF")
        external_creds = databricks.Grant("external_creds",
            storage_credential=external.id,
            principal="Data Engineers",
            privileges=["CREATE_EXTERNAL_TABLE"])
        ```

        ## External location grants

        See Grants External location grants for the list of privileges that apply to External locations.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        some = databricks.ExternalLocation("some",
            name="external",
            url=f"s3://{external_aws_s3_bucket['id']}/some",
            credential_name=external["id"],
            comment="Managed by TF")
        some_data_engineers = databricks.Grant("some_data_engineers",
            external_location=some.id,
            principal="Data Engineers",
            privileges=[
                "CREATE_EXTERNAL_TABLE",
                "READ_FILES",
            ])
        some_service_principal = databricks.Grant("some_service_principal",
            external_location=some.id,
            principal=my_sp["applicationId"],
            privileges=[
                "USE_SCHEMA",
                "MODIFY",
            ])
        some_group = databricks.Grant("some_group",
            external_location=some.id,
            principal=my_group["displayName"],
            privileges=[
                "USE_SCHEMA",
                "MODIFY",
            ])
        some_user = databricks.Grant("some_user",
            external_location=some.id,
            principal=my_user["userName"],
            privileges=[
                "USE_SCHEMA",
                "MODIFY",
            ])
        ```

        ## Connection grants

        See Grants Connection grants for the list of privileges that apply to Connections.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        mysql = databricks.Connection("mysql",
            name="mysql_connection",
            connection_type="MYSQL",
            comment="this is a connection to mysql db",
            options={
                "host": "test.mysql.database.azure.com",
                "port": "3306",
                "user": "user",
                "password": "password",
            },
            properties={
                "purpose": "testing",
            })
        some = databricks.Grant("some",
            foreign_connection=mysql.name,
            principal="Data Engineers",
            privileges=[
                "CREATE_FOREIGN_CATALOG",
                "USE_CONNECTION",
            ])
        ```

        ## Delta Sharing share grants

        See Grants Delta Sharing share grants for the list of privileges that apply to Delta Sharing shares.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        some = databricks.Share("some", name="my_share")
        some_recipient = databricks.Recipient("some", name="my_recipient")
        some_grant = databricks.Grant("some",
            share=some.name,
            principal=some_recipient.name,
            privileges=["SELECT"])
        ```

        ## Other access control

        You can control Databricks General Permissions through Permissions resource.

        ## Import

        The resource can be imported using combination of securable type (`table`, `catalog`, `foreign_connection`, ...), it's name and `principal`:

        hcl

        import {

          to = databricks_grant.this

          id = "<securable_type>/<securable_name>/<principal>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/grant:Grant this <securable_type>/<securable_name>/<principal>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrantArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > This article refers to the privileges and inheritance model in Privilege Model version 1.0. If you created your metastore during the public preview (before August 25, 2022), you can upgrade to Privilege Model version 1.0 following [Upgrade to privilege inheritance](https://docs.databricks.com/data-governance/unity-catalog/hive-metastore.html)

        > Most of Unity Catalog APIs are only accessible via **workspace-level APIs**. This design may change in the future. Account-level principal grants can be assigned with any valid workspace as the Unity Catalog is decoupled from specific workspaces. More information in [the official documentation](https://docs.databricks.com/data-governance/unity-catalog/index.html).

        In Unity Catalog all users initially have no access to data. Only Metastore Admins can create objects and can grant/revoke access on individual objects to users and groups. Every securable object in Unity Catalog has an owner. The owner can be any account-level user or group, called principals in general. The principal that creates an object becomes its owner. Owners receive `ALL_PRIVILEGES` on the securable object (e.g., `SELECT` and `MODIFY` on a table), as well as the permission to grant privileges to other principals.

        Securable objects are hierarchical and privileges are inherited downward. The highest level object that privileges are inherited from is the catalog. This means that granting a privilege on a catalog or schema automatically grants the privilege to all current and future objects within the catalog or schema. Privileges that are granted on a metastore are not inherited.

        Every `Grant` resource must have exactly one securable identifier and the following arguments:

        - `principal` - User name, group name or service principal application ID.
        - `privileges` - One or more privileges that are specific to a securable type.

        For the latest list of privilege types that apply to each securable object in Unity Catalog, please refer to the [official documentation](https://docs.databricks.com/en/data-governance/unity-catalog/manage-privileges/privileges.html#privilege-types-by-securable-object-in-unity-catalog)

        Pulumi will handle any configuration drift for the specified principal on every `pulumi up` run, even when grants are changed outside of Pulumi state.

        See Grants for the list of privilege types that apply to each securable object.

        ## Metastore grants

        See Grants Metastore grants for the list of privileges that apply to Metastores.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sandbox_data_engineers = databricks.Grant("sandbox_data_engineers",
            metastore="metastore_id",
            principal="Data Engineers",
            privileges=[
                "CREATE_CATALOG",
                "CREATE_EXTERNAL_LOCATION",
            ])
        sandbox_data_sharer = databricks.Grant("sandbox_data_sharer",
            metastore="metastore_id",
            principal="Data Sharer",
            privileges=[
                "CREATE_RECIPIENT",
                "CREATE_SHARE",
            ])
        ```

        ## Catalog grants

        See Grants Catalog grants for the list of privileges that apply to Catalogs.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sandbox = databricks.Catalog("sandbox",
            name="sandbox",
            comment="this catalog is managed by terraform",
            properties={
                "purpose": "testing",
            })
        sandbox_data_scientists = databricks.Grant("sandbox_data_scientists",
            catalog=sandbox.name,
            principal="Data Scientists",
            privileges=[
                "USE_CATALOG",
                "USE_SCHEMA",
                "CREATE_TABLE",
                "SELECT",
            ])
        sandbox_data_engineers = databricks.Grant("sandbox_data_engineers",
            catalog=sandbox.name,
            principal="Data Engineers",
            privileges=[
                "USE_CATALOG",
                "USE_SCHEMA",
                "CREATE_SCHEMA",
                "CREATE_TABLE",
                "MODIFY",
            ])
        sandbox_data_analyst = databricks.Grant("sandbox_data_analyst",
            catalog=sandbox.name,
            principal="Data Analyst",
            privileges=[
                "USE_CATALOG",
                "USE_SCHEMA",
                "SELECT",
            ])
        ```

        ## Schema grants

        See Grants Schema grants for the list of privileges that apply to Schemas.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        things = databricks.Schema("things",
            catalog_name=sandbox["id"],
            name="things",
            comment="this schema is managed by terraform",
            properties={
                "kind": "various",
            })
        things_grant = databricks.Grant("things",
            schema=things.id,
            principal="Data Engineers",
            privileges=[
                "USE_SCHEMA",
                "MODIFY",
            ])
        ```

        ## Table grants

        See Grants Table grants for the list of privileges that apply to Tables.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        customers_data_engineers = databricks.Grant("customers_data_engineers",
            table="main.reporting.customers",
            principal="Data Engineers",
            privileges=[
                "MODIFY",
                "SELECT",
            ])
        customers_data_analysts = databricks.Grant("customers_data_analysts",
            table="main.reporting.customers",
            principal="Data Analysts",
            privileges=["SELECT"])
        ```

        You can also apply grants dynamically with get_tables data resource:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        things = databricks.get_tables(catalog_name="sandbox",
            schema_name="things")
        things_grant = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate(things.ids)]:
            things_grant.append(databricks.Grant(f"things-{range['key']}",
                table=range["value"],
                principal="sensitive",
                privileges=[
                    "SELECT",
                    "MODIFY",
                ]))
        ```

        ## View grants

        See Grants View grants for the list of privileges that apply to Views.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        customer360 = databricks.Grant("customer360",
            table="main.reporting.customer360",
            principal="Data Analysts",
            privileges=["SELECT"])
        ```

        You can also apply grants dynamically with get_views data resource:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        customers = databricks.get_views(catalog_name="main",
            schema_name="customers")
        customers_grant = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate(customers.ids)]:
            customers_grant.append(databricks.Grant(f"customers-{range['key']}",
                table=range["value"],
                principal="sensitive",
                privileges=[
                    "SELECT",
                    "MODIFY",
                ]))
        ```

        ## Volume grants

        See Grants Volume grants for the list of privileges that apply to Volumes.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.Volume("this",
            name="quickstart_volume",
            catalog_name=sandbox["name"],
            schema_name=things["name"],
            volume_type="EXTERNAL",
            storage_location=some["url"],
            comment="this volume is managed by terraform")
        volume = databricks.Grant("volume",
            volume=this.id,
            principal="Data Engineers",
            privileges=["WRITE_VOLUME"])
        ```

        ## Registered model grants

        See Grants Registered model grants for the list of privileges that apply to Registered models.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        customers_data_engineers = databricks.Grant("customers_data_engineers",
            model="main.reporting.customer_model",
            principal="Data Engineers",
            privileges=[
                "APPLY_TAG",
                "EXECUTE",
            ])
        customers_data_analysts = databricks.Grant("customers_data_analysts",
            model="main.reporting.customer_model",
            principal="Data Analysts",
            privileges=["EXECUTE"])
        ```

        ## Function grants

        See Grants Function grants for the list of privileges that apply to Registered models.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        udf_data_engineers = databricks.Grant("udf_data_engineers",
            function="main.reporting.udf",
            principal="Data Engineers",
            privileges=["EXECUTE"])
        udf_data_analysts = databricks.Grant("udf_data_analysts",
            function="main.reporting.udf",
            principal="Data Analysts",
            privileges=["EXECUTE"])
        ```

        ## Service credential grants

        See Grants Service credential grants for the list of privileges that apply to Service credentials.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        external = databricks.Credential("external",
            name=external_data_access["name"],
            aws_iam_role={
                "role_arn": external_data_access["arn"],
            },
            purpose="SERVICE",
            comment="Managed by TF")
        external_creds = databricks.Grant("external_creds",
            credential=external.id,
            principal="Data Engineers",
            privileges=["ACCESS"])
        ```

        ## Storage credential grants

        See Grants Storage credential grants for the list of privileges that apply to Storage credentials.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        external = databricks.StorageCredential("external",
            name=external_data_access["name"],
            aws_iam_role={
                "role_arn": external_data_access["arn"],
            },
            comment="Managed by TF")
        external_creds = databricks.Grant("external_creds",
            storage_credential=external.id,
            principal="Data Engineers",
            privileges=["CREATE_EXTERNAL_TABLE"])
        ```

        ## External location grants

        See Grants External location grants for the list of privileges that apply to External locations.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        some = databricks.ExternalLocation("some",
            name="external",
            url=f"s3://{external_aws_s3_bucket['id']}/some",
            credential_name=external["id"],
            comment="Managed by TF")
        some_data_engineers = databricks.Grant("some_data_engineers",
            external_location=some.id,
            principal="Data Engineers",
            privileges=[
                "CREATE_EXTERNAL_TABLE",
                "READ_FILES",
            ])
        some_service_principal = databricks.Grant("some_service_principal",
            external_location=some.id,
            principal=my_sp["applicationId"],
            privileges=[
                "USE_SCHEMA",
                "MODIFY",
            ])
        some_group = databricks.Grant("some_group",
            external_location=some.id,
            principal=my_group["displayName"],
            privileges=[
                "USE_SCHEMA",
                "MODIFY",
            ])
        some_user = databricks.Grant("some_user",
            external_location=some.id,
            principal=my_user["userName"],
            privileges=[
                "USE_SCHEMA",
                "MODIFY",
            ])
        ```

        ## Connection grants

        See Grants Connection grants for the list of privileges that apply to Connections.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        mysql = databricks.Connection("mysql",
            name="mysql_connection",
            connection_type="MYSQL",
            comment="this is a connection to mysql db",
            options={
                "host": "test.mysql.database.azure.com",
                "port": "3306",
                "user": "user",
                "password": "password",
            },
            properties={
                "purpose": "testing",
            })
        some = databricks.Grant("some",
            foreign_connection=mysql.name,
            principal="Data Engineers",
            privileges=[
                "CREATE_FOREIGN_CATALOG",
                "USE_CONNECTION",
            ])
        ```

        ## Delta Sharing share grants

        See Grants Delta Sharing share grants for the list of privileges that apply to Delta Sharing shares.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        some = databricks.Share("some", name="my_share")
        some_recipient = databricks.Recipient("some", name="my_recipient")
        some_grant = databricks.Grant("some",
            share=some.name,
            principal=some_recipient.name,
            privileges=["SELECT"])
        ```

        ## Other access control

        You can control Databricks General Permissions through Permissions resource.

        ## Import

        The resource can be imported using combination of securable type (`table`, `catalog`, `foreign_connection`, ...), it's name and `principal`:

        hcl

        import {

          to = databricks_grant.this

          id = "<securable_type>/<securable_name>/<principal>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/grant:Grant this <securable_type>/<securable_name>/<principal>
        ```

        :param str resource_name: The name of the resource.
        :param GrantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 credential: Optional[pulumi.Input[builtins.str]] = None,
                 external_location: Optional[pulumi.Input[builtins.str]] = None,
                 foreign_connection: Optional[pulumi.Input[builtins.str]] = None,
                 function: Optional[pulumi.Input[builtins.str]] = None,
                 metastore: Optional[pulumi.Input[builtins.str]] = None,
                 model: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline: Optional[pulumi.Input[builtins.str]] = None,
                 principal: Optional[pulumi.Input[builtins.str]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 recipient: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 share: Optional[pulumi.Input[builtins.str]] = None,
                 storage_credential: Optional[pulumi.Input[builtins.str]] = None,
                 table: Optional[pulumi.Input[builtins.str]] = None,
                 volume: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrantArgs.__new__(GrantArgs)

            __props__.__dict__["catalog"] = catalog
            __props__.__dict__["credential"] = credential
            __props__.__dict__["external_location"] = external_location
            __props__.__dict__["foreign_connection"] = foreign_connection
            __props__.__dict__["function"] = function
            __props__.__dict__["metastore"] = metastore
            __props__.__dict__["model"] = model
            __props__.__dict__["pipeline"] = pipeline
            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
            if privileges is None and not opts.urn:
                raise TypeError("Missing required property 'privileges'")
            __props__.__dict__["privileges"] = privileges
            __props__.__dict__["recipient"] = recipient
            __props__.__dict__["schema"] = schema
            __props__.__dict__["share"] = share
            __props__.__dict__["storage_credential"] = storage_credential
            __props__.__dict__["table"] = table
            __props__.__dict__["volume"] = volume
        super(Grant, __self__).__init__(
            'databricks:index/grant:Grant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog: Optional[pulumi.Input[builtins.str]] = None,
            credential: Optional[pulumi.Input[builtins.str]] = None,
            external_location: Optional[pulumi.Input[builtins.str]] = None,
            foreign_connection: Optional[pulumi.Input[builtins.str]] = None,
            function: Optional[pulumi.Input[builtins.str]] = None,
            metastore: Optional[pulumi.Input[builtins.str]] = None,
            model: Optional[pulumi.Input[builtins.str]] = None,
            pipeline: Optional[pulumi.Input[builtins.str]] = None,
            principal: Optional[pulumi.Input[builtins.str]] = None,
            privileges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            recipient: Optional[pulumi.Input[builtins.str]] = None,
            schema: Optional[pulumi.Input[builtins.str]] = None,
            share: Optional[pulumi.Input[builtins.str]] = None,
            storage_credential: Optional[pulumi.Input[builtins.str]] = None,
            table: Optional[pulumi.Input[builtins.str]] = None,
            volume: Optional[pulumi.Input[builtins.str]] = None) -> 'Grant':
        """
        Get an existing Grant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrantState.__new__(_GrantState)

        __props__.__dict__["catalog"] = catalog
        __props__.__dict__["credential"] = credential
        __props__.__dict__["external_location"] = external_location
        __props__.__dict__["foreign_connection"] = foreign_connection
        __props__.__dict__["function"] = function
        __props__.__dict__["metastore"] = metastore
        __props__.__dict__["model"] = model
        __props__.__dict__["pipeline"] = pipeline
        __props__.__dict__["principal"] = principal
        __props__.__dict__["privileges"] = privileges
        __props__.__dict__["recipient"] = recipient
        __props__.__dict__["schema"] = schema
        __props__.__dict__["share"] = share
        __props__.__dict__["storage_credential"] = storage_credential
        __props__.__dict__["table"] = table
        __props__.__dict__["volume"] = volume
        return Grant(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def catalog(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter(name="externalLocation")
    def external_location(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "external_location")

    @property
    @pulumi.getter(name="foreignConnection")
    def foreign_connection(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "foreign_connection")

    @property
    @pulumi.getter
    def function(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def metastore(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "metastore")

    @property
    @pulumi.getter
    def model(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def pipeline(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "principal")

    @property
    @pulumi.getter
    def privileges(self) -> pulumi.Output[Sequence[builtins.str]]:
        return pulumi.get(self, "privileges")

    @property
    @pulumi.getter
    def recipient(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "recipient")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def share(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "share")

    @property
    @pulumi.getter(name="storageCredential")
    def storage_credential(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "storage_credential")

    @property
    @pulumi.getter
    def table(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "volume")

