# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MetastoreArgs', 'Metastore']

@pulumi.input_type
class MetastoreArgs:
    def __init__(__self__, *,
                 cloud: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.int]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 default_data_access_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 delta_sharing_organization_name: Optional[pulumi.Input[builtins.str]] = None,
                 delta_sharing_recipient_token_lifetime_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 delta_sharing_scope: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 global_metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root_credential_id: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Metastore resource.
        :param pulumi.Input[builtins.str] delta_sharing_organization_name: The organization name of a Delta Sharing entity. This field is used for Databricks to Databricks sharing. Once this is set it cannot be removed and can only be modified to another valid value. To delete this value please taint and recreate the resource.
        :param pulumi.Input[builtins.int] delta_sharing_recipient_token_lifetime_in_seconds: Required along with `delta_sharing_scope`. Used to set expiration duration in seconds on recipient data access tokens. Set to 0 for unlimited duration.
        :param pulumi.Input[builtins.str] delta_sharing_scope: Required along with `delta_sharing_recipient_token_lifetime_in_seconds`. Used to enable delta sharing on the metastore. Valid values: INTERNAL, INTERNAL_AND_EXTERNAL.  INTERNAL only allows sharing within the same account, and INTERNAL_AND_EXTERNAL allows cross account sharing and token based sharing.
        :param pulumi.Input[builtins.bool] force_destroy: Destroy metastore regardless of its contents.
        :param pulumi.Input[builtins.str] name: Name of metastore.
        :param pulumi.Input[builtins.str] owner: Username/groupname/sp application_id of the metastore owner.
        :param pulumi.Input[builtins.str] region: The region of the metastore
        :param pulumi.Input[builtins.str] storage_root: Path on cloud storage account, where managed `Table` are stored. Change forces creation of a new resource. If no `storage_root` is defined for the metastore, each catalog must have a `storage_root` defined.
        """
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if default_data_access_config_id is not None:
            pulumi.set(__self__, "default_data_access_config_id", default_data_access_config_id)
        if delta_sharing_organization_name is not None:
            pulumi.set(__self__, "delta_sharing_organization_name", delta_sharing_organization_name)
        if delta_sharing_recipient_token_lifetime_in_seconds is not None:
            pulumi.set(__self__, "delta_sharing_recipient_token_lifetime_in_seconds", delta_sharing_recipient_token_lifetime_in_seconds)
        if delta_sharing_scope is not None:
            pulumi.set(__self__, "delta_sharing_scope", delta_sharing_scope)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if global_metastore_id is not None:
            pulumi.set(__self__, "global_metastore_id", global_metastore_id)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if storage_root is not None:
            pulumi.set(__self__, "storage_root", storage_root)
        if storage_root_credential_id is not None:
            pulumi.set(__self__, "storage_root_credential_id", storage_root_credential_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="defaultDataAccessConfigId")
    def default_data_access_config_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "default_data_access_config_id")

    @default_data_access_config_id.setter
    def default_data_access_config_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_data_access_config_id", value)

    @property
    @pulumi.getter(name="deltaSharingOrganizationName")
    def delta_sharing_organization_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The organization name of a Delta Sharing entity. This field is used for Databricks to Databricks sharing. Once this is set it cannot be removed and can only be modified to another valid value. To delete this value please taint and recreate the resource.
        """
        return pulumi.get(self, "delta_sharing_organization_name")

    @delta_sharing_organization_name.setter
    def delta_sharing_organization_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delta_sharing_organization_name", value)

    @property
    @pulumi.getter(name="deltaSharingRecipientTokenLifetimeInSeconds")
    def delta_sharing_recipient_token_lifetime_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Required along with `delta_sharing_scope`. Used to set expiration duration in seconds on recipient data access tokens. Set to 0 for unlimited duration.
        """
        return pulumi.get(self, "delta_sharing_recipient_token_lifetime_in_seconds")

    @delta_sharing_recipient_token_lifetime_in_seconds.setter
    def delta_sharing_recipient_token_lifetime_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "delta_sharing_recipient_token_lifetime_in_seconds", value)

    @property
    @pulumi.getter(name="deltaSharingScope")
    def delta_sharing_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required along with `delta_sharing_recipient_token_lifetime_in_seconds`. Used to enable delta sharing on the metastore. Valid values: INTERNAL, INTERNAL_AND_EXTERNAL.  INTERNAL only allows sharing within the same account, and INTERNAL_AND_EXTERNAL allows cross account sharing and token based sharing.
        """
        return pulumi.get(self, "delta_sharing_scope")

    @delta_sharing_scope.setter
    def delta_sharing_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delta_sharing_scope", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Destroy metastore regardless of its contents.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="globalMetastoreId")
    def global_metastore_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "global_metastore_id")

    @global_metastore_id.setter
    def global_metastore_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "global_metastore_id", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of metastore.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username/groupname/sp application_id of the metastore owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of the metastore
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="storageRoot")
    def storage_root(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path on cloud storage account, where managed `Table` are stored. Change forces creation of a new resource. If no `storage_root` is defined for the metastore, each catalog must have a `storage_root` defined.
        """
        return pulumi.get(self, "storage_root")

    @storage_root.setter
    def storage_root(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_root", value)

    @property
    @pulumi.getter(name="storageRootCredentialId")
    def storage_root_credential_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "storage_root_credential_id")

    @storage_root_credential_id.setter
    def storage_root_credential_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_root_credential_id", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_by", value)


@pulumi.input_type
class _MetastoreState:
    def __init__(__self__, *,
                 cloud: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.int]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 default_data_access_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 delta_sharing_organization_name: Optional[pulumi.Input[builtins.str]] = None,
                 delta_sharing_recipient_token_lifetime_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 delta_sharing_scope: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 global_metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root_credential_id: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Metastore resources.
        :param pulumi.Input[builtins.str] delta_sharing_organization_name: The organization name of a Delta Sharing entity. This field is used for Databricks to Databricks sharing. Once this is set it cannot be removed and can only be modified to another valid value. To delete this value please taint and recreate the resource.
        :param pulumi.Input[builtins.int] delta_sharing_recipient_token_lifetime_in_seconds: Required along with `delta_sharing_scope`. Used to set expiration duration in seconds on recipient data access tokens. Set to 0 for unlimited duration.
        :param pulumi.Input[builtins.str] delta_sharing_scope: Required along with `delta_sharing_recipient_token_lifetime_in_seconds`. Used to enable delta sharing on the metastore. Valid values: INTERNAL, INTERNAL_AND_EXTERNAL.  INTERNAL only allows sharing within the same account, and INTERNAL_AND_EXTERNAL allows cross account sharing and token based sharing.
        :param pulumi.Input[builtins.bool] force_destroy: Destroy metastore regardless of its contents.
        :param pulumi.Input[builtins.str] name: Name of metastore.
        :param pulumi.Input[builtins.str] owner: Username/groupname/sp application_id of the metastore owner.
        :param pulumi.Input[builtins.str] region: The region of the metastore
        :param pulumi.Input[builtins.str] storage_root: Path on cloud storage account, where managed `Table` are stored. Change forces creation of a new resource. If no `storage_root` is defined for the metastore, each catalog must have a `storage_root` defined.
        """
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if default_data_access_config_id is not None:
            pulumi.set(__self__, "default_data_access_config_id", default_data_access_config_id)
        if delta_sharing_organization_name is not None:
            pulumi.set(__self__, "delta_sharing_organization_name", delta_sharing_organization_name)
        if delta_sharing_recipient_token_lifetime_in_seconds is not None:
            pulumi.set(__self__, "delta_sharing_recipient_token_lifetime_in_seconds", delta_sharing_recipient_token_lifetime_in_seconds)
        if delta_sharing_scope is not None:
            pulumi.set(__self__, "delta_sharing_scope", delta_sharing_scope)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if global_metastore_id is not None:
            pulumi.set(__self__, "global_metastore_id", global_metastore_id)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if storage_root is not None:
            pulumi.set(__self__, "storage_root", storage_root)
        if storage_root_credential_id is not None:
            pulumi.set(__self__, "storage_root_credential_id", storage_root_credential_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="defaultDataAccessConfigId")
    def default_data_access_config_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "default_data_access_config_id")

    @default_data_access_config_id.setter
    def default_data_access_config_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_data_access_config_id", value)

    @property
    @pulumi.getter(name="deltaSharingOrganizationName")
    def delta_sharing_organization_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The organization name of a Delta Sharing entity. This field is used for Databricks to Databricks sharing. Once this is set it cannot be removed and can only be modified to another valid value. To delete this value please taint and recreate the resource.
        """
        return pulumi.get(self, "delta_sharing_organization_name")

    @delta_sharing_organization_name.setter
    def delta_sharing_organization_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delta_sharing_organization_name", value)

    @property
    @pulumi.getter(name="deltaSharingRecipientTokenLifetimeInSeconds")
    def delta_sharing_recipient_token_lifetime_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Required along with `delta_sharing_scope`. Used to set expiration duration in seconds on recipient data access tokens. Set to 0 for unlimited duration.
        """
        return pulumi.get(self, "delta_sharing_recipient_token_lifetime_in_seconds")

    @delta_sharing_recipient_token_lifetime_in_seconds.setter
    def delta_sharing_recipient_token_lifetime_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "delta_sharing_recipient_token_lifetime_in_seconds", value)

    @property
    @pulumi.getter(name="deltaSharingScope")
    def delta_sharing_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required along with `delta_sharing_recipient_token_lifetime_in_seconds`. Used to enable delta sharing on the metastore. Valid values: INTERNAL, INTERNAL_AND_EXTERNAL.  INTERNAL only allows sharing within the same account, and INTERNAL_AND_EXTERNAL allows cross account sharing and token based sharing.
        """
        return pulumi.get(self, "delta_sharing_scope")

    @delta_sharing_scope.setter
    def delta_sharing_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delta_sharing_scope", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Destroy metastore regardless of its contents.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="globalMetastoreId")
    def global_metastore_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "global_metastore_id")

    @global_metastore_id.setter
    def global_metastore_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "global_metastore_id", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of metastore.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username/groupname/sp application_id of the metastore owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of the metastore
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="storageRoot")
    def storage_root(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path on cloud storage account, where managed `Table` are stored. Change forces creation of a new resource. If no `storage_root` is defined for the metastore, each catalog must have a `storage_root` defined.
        """
        return pulumi.get(self, "storage_root")

    @storage_root.setter
    def storage_root(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_root", value)

    @property
    @pulumi.getter(name="storageRootCredentialId")
    def storage_root_credential_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "storage_root_credential_id")

    @storage_root_credential_id.setter
    def storage_root_credential_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_root_credential_id", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_by", value)


@pulumi.type_token("databricks:index/metastore:Metastore")
class Metastore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.int]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 default_data_access_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 delta_sharing_organization_name: Optional[pulumi.Input[builtins.str]] = None,
                 delta_sharing_recipient_token_lifetime_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 delta_sharing_scope: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 global_metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root_credential_id: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > This resource can be used with an account or workspace-level provider.

        A metastore is the top-level container of objects in Unity Catalog. It stores data assets (tables and views) and the permissions that govern access to them. Databricks account admins can create metastores and assign them to Databricks workspaces in order to control which workloads use each metastore.

        Unity Catalog offers a new metastore with built in security and auditing. This is distinct to the metastore used in previous versions of Databricks (based on the Hive Metastore).

        A Unity Catalog metastore can be created without a root location & credential to maintain strict separation of storage across catalogs or environments.

        ## Example Usage

        For AWS

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.Metastore("this",
            name="primary",
            storage_root=f"s3://{metastore['id']}/metastore",
            owner="uc admins",
            region="us-east-1",
            force_destroy=True)
        this_metastore_assignment = databricks.MetastoreAssignment("this",
            metastore_id=this.id,
            workspace_id=workspace_id)
        ```

        For Azure

        ## Import

        This resource can be imported by ID:

        hcl

        import {

          to = databricks_metastore.this

          id = "<id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/metastore:Metastore this <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] delta_sharing_organization_name: The organization name of a Delta Sharing entity. This field is used for Databricks to Databricks sharing. Once this is set it cannot be removed and can only be modified to another valid value. To delete this value please taint and recreate the resource.
        :param pulumi.Input[builtins.int] delta_sharing_recipient_token_lifetime_in_seconds: Required along with `delta_sharing_scope`. Used to set expiration duration in seconds on recipient data access tokens. Set to 0 for unlimited duration.
        :param pulumi.Input[builtins.str] delta_sharing_scope: Required along with `delta_sharing_recipient_token_lifetime_in_seconds`. Used to enable delta sharing on the metastore. Valid values: INTERNAL, INTERNAL_AND_EXTERNAL.  INTERNAL only allows sharing within the same account, and INTERNAL_AND_EXTERNAL allows cross account sharing and token based sharing.
        :param pulumi.Input[builtins.bool] force_destroy: Destroy metastore regardless of its contents.
        :param pulumi.Input[builtins.str] name: Name of metastore.
        :param pulumi.Input[builtins.str] owner: Username/groupname/sp application_id of the metastore owner.
        :param pulumi.Input[builtins.str] region: The region of the metastore
        :param pulumi.Input[builtins.str] storage_root: Path on cloud storage account, where managed `Table` are stored. Change forces creation of a new resource. If no `storage_root` is defined for the metastore, each catalog must have a `storage_root` defined.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MetastoreArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > This resource can be used with an account or workspace-level provider.

        A metastore is the top-level container of objects in Unity Catalog. It stores data assets (tables and views) and the permissions that govern access to them. Databricks account admins can create metastores and assign them to Databricks workspaces in order to control which workloads use each metastore.

        Unity Catalog offers a new metastore with built in security and auditing. This is distinct to the metastore used in previous versions of Databricks (based on the Hive Metastore).

        A Unity Catalog metastore can be created without a root location & credential to maintain strict separation of storage across catalogs or environments.

        ## Example Usage

        For AWS

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.Metastore("this",
            name="primary",
            storage_root=f"s3://{metastore['id']}/metastore",
            owner="uc admins",
            region="us-east-1",
            force_destroy=True)
        this_metastore_assignment = databricks.MetastoreAssignment("this",
            metastore_id=this.id,
            workspace_id=workspace_id)
        ```

        For Azure

        ## Import

        This resource can be imported by ID:

        hcl

        import {

          to = databricks_metastore.this

          id = "<id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/metastore:Metastore this <id>
        ```

        :param str resource_name: The name of the resource.
        :param MetastoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetastoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.int]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 default_data_access_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 delta_sharing_organization_name: Optional[pulumi.Input[builtins.str]] = None,
                 delta_sharing_recipient_token_lifetime_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 delta_sharing_scope: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 global_metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root_credential_id: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetastoreArgs.__new__(MetastoreArgs)

            __props__.__dict__["cloud"] = cloud
            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["created_by"] = created_by
            __props__.__dict__["default_data_access_config_id"] = default_data_access_config_id
            __props__.__dict__["delta_sharing_organization_name"] = delta_sharing_organization_name
            __props__.__dict__["delta_sharing_recipient_token_lifetime_in_seconds"] = delta_sharing_recipient_token_lifetime_in_seconds
            __props__.__dict__["delta_sharing_scope"] = delta_sharing_scope
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["global_metastore_id"] = global_metastore_id
            __props__.__dict__["metastore_id"] = metastore_id
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            __props__.__dict__["region"] = region
            __props__.__dict__["storage_root"] = storage_root
            __props__.__dict__["storage_root_credential_id"] = storage_root_credential_id
            __props__.__dict__["updated_at"] = updated_at
            __props__.__dict__["updated_by"] = updated_by
        super(Metastore, __self__).__init__(
            'databricks:index/metastore:Metastore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.int]] = None,
            created_by: Optional[pulumi.Input[builtins.str]] = None,
            default_data_access_config_id: Optional[pulumi.Input[builtins.str]] = None,
            delta_sharing_organization_name: Optional[pulumi.Input[builtins.str]] = None,
            delta_sharing_recipient_token_lifetime_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            delta_sharing_scope: Optional[pulumi.Input[builtins.str]] = None,
            force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            global_metastore_id: Optional[pulumi.Input[builtins.str]] = None,
            metastore_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            owner: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            storage_root: Optional[pulumi.Input[builtins.str]] = None,
            storage_root_credential_id: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.int]] = None,
            updated_by: Optional[pulumi.Input[builtins.str]] = None) -> 'Metastore':
        """
        Get an existing Metastore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] delta_sharing_organization_name: The organization name of a Delta Sharing entity. This field is used for Databricks to Databricks sharing. Once this is set it cannot be removed and can only be modified to another valid value. To delete this value please taint and recreate the resource.
        :param pulumi.Input[builtins.int] delta_sharing_recipient_token_lifetime_in_seconds: Required along with `delta_sharing_scope`. Used to set expiration duration in seconds on recipient data access tokens. Set to 0 for unlimited duration.
        :param pulumi.Input[builtins.str] delta_sharing_scope: Required along with `delta_sharing_recipient_token_lifetime_in_seconds`. Used to enable delta sharing on the metastore. Valid values: INTERNAL, INTERNAL_AND_EXTERNAL.  INTERNAL only allows sharing within the same account, and INTERNAL_AND_EXTERNAL allows cross account sharing and token based sharing.
        :param pulumi.Input[builtins.bool] force_destroy: Destroy metastore regardless of its contents.
        :param pulumi.Input[builtins.str] name: Name of metastore.
        :param pulumi.Input[builtins.str] owner: Username/groupname/sp application_id of the metastore owner.
        :param pulumi.Input[builtins.str] region: The region of the metastore
        :param pulumi.Input[builtins.str] storage_root: Path on cloud storage account, where managed `Table` are stored. Change forces creation of a new resource. If no `storage_root` is defined for the metastore, each catalog must have a `storage_root` defined.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetastoreState.__new__(_MetastoreState)

        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["default_data_access_config_id"] = default_data_access_config_id
        __props__.__dict__["delta_sharing_organization_name"] = delta_sharing_organization_name
        __props__.__dict__["delta_sharing_recipient_token_lifetime_in_seconds"] = delta_sharing_recipient_token_lifetime_in_seconds
        __props__.__dict__["delta_sharing_scope"] = delta_sharing_scope
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["global_metastore_id"] = global_metastore_id
        __props__.__dict__["metastore_id"] = metastore_id
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["region"] = region
        __props__.__dict__["storage_root"] = storage_root
        __props__.__dict__["storage_root_credential_id"] = storage_root_credential_id
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["updated_by"] = updated_by
        return Metastore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="defaultDataAccessConfigId")
    def default_data_access_config_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "default_data_access_config_id")

    @property
    @pulumi.getter(name="deltaSharingOrganizationName")
    def delta_sharing_organization_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The organization name of a Delta Sharing entity. This field is used for Databricks to Databricks sharing. Once this is set it cannot be removed and can only be modified to another valid value. To delete this value please taint and recreate the resource.
        """
        return pulumi.get(self, "delta_sharing_organization_name")

    @property
    @pulumi.getter(name="deltaSharingRecipientTokenLifetimeInSeconds")
    def delta_sharing_recipient_token_lifetime_in_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Required along with `delta_sharing_scope`. Used to set expiration duration in seconds on recipient data access tokens. Set to 0 for unlimited duration.
        """
        return pulumi.get(self, "delta_sharing_recipient_token_lifetime_in_seconds")

    @property
    @pulumi.getter(name="deltaSharingScope")
    def delta_sharing_scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Required along with `delta_sharing_recipient_token_lifetime_in_seconds`. Used to enable delta sharing on the metastore. Valid values: INTERNAL, INTERNAL_AND_EXTERNAL.  INTERNAL only allows sharing within the same account, and INTERNAL_AND_EXTERNAL allows cross account sharing and token based sharing.
        """
        return pulumi.get(self, "delta_sharing_scope")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Destroy metastore regardless of its contents.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="globalMetastoreId")
    def global_metastore_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "global_metastore_id")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of metastore.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[builtins.str]:
        """
        Username/groupname/sp application_id of the metastore owner.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region of the metastore
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="storageRoot")
    def storage_root(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Path on cloud storage account, where managed `Table` are stored. Change forces creation of a new resource. If no `storage_root` is defined for the metastore, each catalog must have a `storage_root` defined.
        """
        return pulumi.get(self, "storage_root")

    @property
    @pulumi.getter(name="storageRootCredentialId")
    def storage_root_credential_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "storage_root_credential_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "updated_by")

