# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MlflowExperimentArgs', 'MlflowExperiment']

@pulumi.input_type
class MlflowExperimentArgs:
    def __init__(__self__, *,
                 artifact_location: Optional[pulumi.Input[builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 experiment_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_update_time: Optional[pulumi.Input[builtins.int]] = None,
                 lifecycle_stage: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['MlflowExperimentTagArgs']]]] = None):
        """
        The set of arguments for constructing a MlflowExperiment resource.
        :param pulumi.Input[builtins.str] artifact_location: Path to dbfs:/ or s3:// artifact location of the MLflow experiment.
        :param pulumi.Input[builtins.str] name: Name of MLflow experiment. It must be an absolute path within the Databricks workspace, e.g. `/Users/<some-username>/my-experiment`. For more information about changes to experiment naming conventions, see [mlflow docs](https://docs.databricks.com/applications/mlflow/experiments.html#experiment-migration).
        :param pulumi.Input[Sequence[pulumi.Input['MlflowExperimentTagArgs']]] tags: Tags for the MLflow experiment.
        """
        if artifact_location is not None:
            pulumi.set(__self__, "artifact_location", artifact_location)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            warnings.warn("""Remove the description attribute as it no longer is used and will be removed in a future version.""", DeprecationWarning)
            pulumi.log.warn("""description is deprecated: Remove the description attribute as it no longer is used and will be removed in a future version.""")
        if description is not None:
            pulumi.set(__self__, "description", description)
        if experiment_id is not None:
            pulumi.set(__self__, "experiment_id", experiment_id)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if lifecycle_stage is not None:
            pulumi.set(__self__, "lifecycle_stage", lifecycle_stage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="artifactLocation")
    def artifact_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to dbfs:/ or s3:// artifact location of the MLflow experiment.
        """
        return pulumi.get(self, "artifact_location")

    @artifact_location.setter
    def artifact_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "artifact_location", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Remove the description attribute as it no longer is used and will be removed in a future version.""")
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="experimentId")
    def experiment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "experiment_id")

    @experiment_id.setter
    def experiment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "experiment_id", value)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "last_update_time")

    @last_update_time.setter
    def last_update_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "last_update_time", value)

    @property
    @pulumi.getter(name="lifecycleStage")
    def lifecycle_stage(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "lifecycle_stage")

    @lifecycle_stage.setter
    def lifecycle_stage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_stage", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of MLflow experiment. It must be an absolute path within the Databricks workspace, e.g. `/Users/<some-username>/my-experiment`. For more information about changes to experiment naming conventions, see [mlflow docs](https://docs.databricks.com/applications/mlflow/experiments.html#experiment-migration).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MlflowExperimentTagArgs']]]]:
        """
        Tags for the MLflow experiment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MlflowExperimentTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _MlflowExperimentState:
    def __init__(__self__, *,
                 artifact_location: Optional[pulumi.Input[builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 experiment_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_update_time: Optional[pulumi.Input[builtins.int]] = None,
                 lifecycle_stage: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['MlflowExperimentTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering MlflowExperiment resources.
        :param pulumi.Input[builtins.str] artifact_location: Path to dbfs:/ or s3:// artifact location of the MLflow experiment.
        :param pulumi.Input[builtins.str] name: Name of MLflow experiment. It must be an absolute path within the Databricks workspace, e.g. `/Users/<some-username>/my-experiment`. For more information about changes to experiment naming conventions, see [mlflow docs](https://docs.databricks.com/applications/mlflow/experiments.html#experiment-migration).
        :param pulumi.Input[Sequence[pulumi.Input['MlflowExperimentTagArgs']]] tags: Tags for the MLflow experiment.
        """
        if artifact_location is not None:
            pulumi.set(__self__, "artifact_location", artifact_location)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            warnings.warn("""Remove the description attribute as it no longer is used and will be removed in a future version.""", DeprecationWarning)
            pulumi.log.warn("""description is deprecated: Remove the description attribute as it no longer is used and will be removed in a future version.""")
        if description is not None:
            pulumi.set(__self__, "description", description)
        if experiment_id is not None:
            pulumi.set(__self__, "experiment_id", experiment_id)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if lifecycle_stage is not None:
            pulumi.set(__self__, "lifecycle_stage", lifecycle_stage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="artifactLocation")
    def artifact_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to dbfs:/ or s3:// artifact location of the MLflow experiment.
        """
        return pulumi.get(self, "artifact_location")

    @artifact_location.setter
    def artifact_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "artifact_location", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Remove the description attribute as it no longer is used and will be removed in a future version.""")
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="experimentId")
    def experiment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "experiment_id")

    @experiment_id.setter
    def experiment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "experiment_id", value)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "last_update_time")

    @last_update_time.setter
    def last_update_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "last_update_time", value)

    @property
    @pulumi.getter(name="lifecycleStage")
    def lifecycle_stage(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "lifecycle_stage")

    @lifecycle_stage.setter
    def lifecycle_stage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_stage", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of MLflow experiment. It must be an absolute path within the Databricks workspace, e.g. `/Users/<some-username>/my-experiment`. For more information about changes to experiment naming conventions, see [mlflow docs](https://docs.databricks.com/applications/mlflow/experiments.html#experiment-migration).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MlflowExperimentTagArgs']]]]:
        """
        Tags for the MLflow experiment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MlflowExperimentTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("databricks:index/mlflowExperiment:MlflowExperiment")
class MlflowExperiment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_location: Optional[pulumi.Input[builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 experiment_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_update_time: Optional[pulumi.Input[builtins.int]] = None,
                 lifecycle_stage: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MlflowExperimentTagArgs', 'MlflowExperimentTagArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource allows you to manage [MLflow experiments](https://docs.databricks.com/data/data-sources/mlflow-experiment.html) in Databricks.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.get_current_user()
        this = databricks.MlflowExperiment("this",
            name=f"{me.home}/Sample",
            artifact_location="dbfs:/tmp/my-experiment",
            tags=[
                {
                    "key": "key1",
                    "value": "value1",
                },
                {
                    "key": "key2",
                    "value": "value2",
                },
            ])
        ```

        ## Access Control

        * Permissions can control which groups or individual users can *Read*, *Edit*, or *Manage* individual experiments.

        ## Related Resources

        The following resources are often used in the same context:

        * RegisteredModel to create [Models in Unity Catalog](https://docs.databricks.com/en/mlflow/models-in-uc.html) in Databricks.
        * End to end workspace management guide.
        * Directory to manage directories in [Databricks Workpace](https://docs.databricks.com/workspace/workspace-objects.html).
        * MlflowModel to create models in the [workspace model registry](https://docs.databricks.com/en/mlflow/model-registry.html) in Databricks.
        * Notebook to manage [Databricks Notebooks](https://docs.databricks.com/notebooks/index.html).
        * Notebook data to export a notebook from Databricks Workspace.
        * Repo to manage [Databricks Repos](https://docs.databricks.com/repos.html).

        ## Import

        The experiment resource can be imported using the id of the experiment:

        hcl

        import {

          to = databricks_mlflow_experiment.this

          id = "<experiment-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/mlflowExperiment:MlflowExperiment this "<experiment-id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] artifact_location: Path to dbfs:/ or s3:// artifact location of the MLflow experiment.
        :param pulumi.Input[builtins.str] name: Name of MLflow experiment. It must be an absolute path within the Databricks workspace, e.g. `/Users/<some-username>/my-experiment`. For more information about changes to experiment naming conventions, see [mlflow docs](https://docs.databricks.com/applications/mlflow/experiments.html#experiment-migration).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MlflowExperimentTagArgs', 'MlflowExperimentTagArgsDict']]]] tags: Tags for the MLflow experiment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MlflowExperimentArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage [MLflow experiments](https://docs.databricks.com/data/data-sources/mlflow-experiment.html) in Databricks.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.get_current_user()
        this = databricks.MlflowExperiment("this",
            name=f"{me.home}/Sample",
            artifact_location="dbfs:/tmp/my-experiment",
            tags=[
                {
                    "key": "key1",
                    "value": "value1",
                },
                {
                    "key": "key2",
                    "value": "value2",
                },
            ])
        ```

        ## Access Control

        * Permissions can control which groups or individual users can *Read*, *Edit*, or *Manage* individual experiments.

        ## Related Resources

        The following resources are often used in the same context:

        * RegisteredModel to create [Models in Unity Catalog](https://docs.databricks.com/en/mlflow/models-in-uc.html) in Databricks.
        * End to end workspace management guide.
        * Directory to manage directories in [Databricks Workpace](https://docs.databricks.com/workspace/workspace-objects.html).
        * MlflowModel to create models in the [workspace model registry](https://docs.databricks.com/en/mlflow/model-registry.html) in Databricks.
        * Notebook to manage [Databricks Notebooks](https://docs.databricks.com/notebooks/index.html).
        * Notebook data to export a notebook from Databricks Workspace.
        * Repo to manage [Databricks Repos](https://docs.databricks.com/repos.html).

        ## Import

        The experiment resource can be imported using the id of the experiment:

        hcl

        import {

          to = databricks_mlflow_experiment.this

          id = "<experiment-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/mlflowExperiment:MlflowExperiment this "<experiment-id>"
        ```

        :param str resource_name: The name of the resource.
        :param MlflowExperimentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MlflowExperimentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_location: Optional[pulumi.Input[builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 experiment_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_update_time: Optional[pulumi.Input[builtins.int]] = None,
                 lifecycle_stage: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MlflowExperimentTagArgs', 'MlflowExperimentTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MlflowExperimentArgs.__new__(MlflowExperimentArgs)

            __props__.__dict__["artifact_location"] = artifact_location
            __props__.__dict__["creation_time"] = creation_time
            __props__.__dict__["description"] = description
            __props__.__dict__["experiment_id"] = experiment_id
            __props__.__dict__["last_update_time"] = last_update_time
            __props__.__dict__["lifecycle_stage"] = lifecycle_stage
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
        super(MlflowExperiment, __self__).__init__(
            'databricks:index/mlflowExperiment:MlflowExperiment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artifact_location: Optional[pulumi.Input[builtins.str]] = None,
            creation_time: Optional[pulumi.Input[builtins.int]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            experiment_id: Optional[pulumi.Input[builtins.str]] = None,
            last_update_time: Optional[pulumi.Input[builtins.int]] = None,
            lifecycle_stage: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MlflowExperimentTagArgs', 'MlflowExperimentTagArgsDict']]]]] = None) -> 'MlflowExperiment':
        """
        Get an existing MlflowExperiment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] artifact_location: Path to dbfs:/ or s3:// artifact location of the MLflow experiment.
        :param pulumi.Input[builtins.str] name: Name of MLflow experiment. It must be an absolute path within the Databricks workspace, e.g. `/Users/<some-username>/my-experiment`. For more information about changes to experiment naming conventions, see [mlflow docs](https://docs.databricks.com/applications/mlflow/experiments.html#experiment-migration).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MlflowExperimentTagArgs', 'MlflowExperimentTagArgsDict']]]] tags: Tags for the MLflow experiment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MlflowExperimentState.__new__(_MlflowExperimentState)

        __props__.__dict__["artifact_location"] = artifact_location
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["experiment_id"] = experiment_id
        __props__.__dict__["last_update_time"] = last_update_time
        __props__.__dict__["lifecycle_stage"] = lifecycle_stage
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        return MlflowExperiment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artifactLocation")
    def artifact_location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Path to dbfs:/ or s3:// artifact location of the MLflow experiment.
        """
        return pulumi.get(self, "artifact_location")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Remove the description attribute as it no longer is used and will be removed in a future version.""")
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="experimentId")
    def experiment_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "experiment_id")

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter(name="lifecycleStage")
    def lifecycle_stage(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "lifecycle_stage")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of MLflow experiment. It must be an absolute path within the Databricks workspace, e.g. `/Users/<some-username>/my-experiment`. For more information about changes to experiment naming conventions, see [mlflow docs](https://docs.databricks.com/applications/mlflow/experiments.html#experiment-migration).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.MlflowExperimentTag']]:
        """
        Tags for the MLflow experiment.
        """
        return pulumi.get(self, "tags")

