# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ModelServingProvisionedThroughputArgs', 'ModelServingProvisionedThroughput']

@pulumi.input_type
class ModelServingProvisionedThroughputArgs:
    def __init__(__self__, *,
                 config: pulumi.Input['ModelServingProvisionedThroughputConfigArgs'],
                 ai_gateway: Optional[pulumi.Input['ModelServingProvisionedThroughputAiGatewayArgs']] = None,
                 budget_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingProvisionedThroughputTagArgs']]]] = None):
        """
        The set of arguments for constructing a ModelServingProvisionedThroughput resource.
        :param pulumi.Input['ModelServingProvisionedThroughputConfigArgs'] config: The model serving endpoint configuration.
        :param pulumi.Input['ModelServingProvisionedThroughputAiGatewayArgs'] ai_gateway: A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        :param pulumi.Input[builtins.str] budget_policy_id: The Budget Policy ID set for this serving endpoint.
        :param pulumi.Input[builtins.str] name: The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        :param pulumi.Input[Sequence[pulumi.Input['ModelServingProvisionedThroughputTagArgs']]] tags: Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        pulumi.set(__self__, "config", config)
        if ai_gateway is not None:
            pulumi.set(__self__, "ai_gateway", ai_gateway)
        if budget_policy_id is not None:
            pulumi.set(__self__, "budget_policy_id", budget_policy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input['ModelServingProvisionedThroughputConfigArgs']:
        """
        The model serving endpoint configuration.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['ModelServingProvisionedThroughputConfigArgs']):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="aiGateway")
    def ai_gateway(self) -> Optional[pulumi.Input['ModelServingProvisionedThroughputAiGatewayArgs']]:
        """
        A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        """
        return pulumi.get(self, "ai_gateway")

    @ai_gateway.setter
    def ai_gateway(self, value: Optional[pulumi.Input['ModelServingProvisionedThroughputAiGatewayArgs']]):
        pulumi.set(self, "ai_gateway", value)

    @property
    @pulumi.getter(name="budgetPolicyId")
    def budget_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Budget Policy ID set for this serving endpoint.
        """
        return pulumi.get(self, "budget_policy_id")

    @budget_policy_id.setter
    def budget_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "budget_policy_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingProvisionedThroughputTagArgs']]]]:
        """
        Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingProvisionedThroughputTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ModelServingProvisionedThroughputState:
    def __init__(__self__, *,
                 ai_gateway: Optional[pulumi.Input['ModelServingProvisionedThroughputAiGatewayArgs']] = None,
                 budget_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 config: Optional[pulumi.Input['ModelServingProvisionedThroughputConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 serving_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingProvisionedThroughputTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering ModelServingProvisionedThroughput resources.
        :param pulumi.Input['ModelServingProvisionedThroughputAiGatewayArgs'] ai_gateway: A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        :param pulumi.Input[builtins.str] budget_policy_id: The Budget Policy ID set for this serving endpoint.
        :param pulumi.Input['ModelServingProvisionedThroughputConfigArgs'] config: The model serving endpoint configuration.
        :param pulumi.Input[builtins.str] name: The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        :param pulumi.Input[builtins.str] serving_endpoint_id: Unique identifier of the serving endpoint primarily used to set permissions and refer to this instance for other operations.
        :param pulumi.Input[Sequence[pulumi.Input['ModelServingProvisionedThroughputTagArgs']]] tags: Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        if ai_gateway is not None:
            pulumi.set(__self__, "ai_gateway", ai_gateway)
        if budget_policy_id is not None:
            pulumi.set(__self__, "budget_policy_id", budget_policy_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if serving_endpoint_id is not None:
            pulumi.set(__self__, "serving_endpoint_id", serving_endpoint_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="aiGateway")
    def ai_gateway(self) -> Optional[pulumi.Input['ModelServingProvisionedThroughputAiGatewayArgs']]:
        """
        A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        """
        return pulumi.get(self, "ai_gateway")

    @ai_gateway.setter
    def ai_gateway(self, value: Optional[pulumi.Input['ModelServingProvisionedThroughputAiGatewayArgs']]):
        pulumi.set(self, "ai_gateway", value)

    @property
    @pulumi.getter(name="budgetPolicyId")
    def budget_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Budget Policy ID set for this serving endpoint.
        """
        return pulumi.get(self, "budget_policy_id")

    @budget_policy_id.setter
    def budget_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "budget_policy_id", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ModelServingProvisionedThroughputConfigArgs']]:
        """
        The model serving endpoint configuration.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ModelServingProvisionedThroughputConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="servingEndpointId")
    def serving_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the serving endpoint primarily used to set permissions and refer to this instance for other operations.
        """
        return pulumi.get(self, "serving_endpoint_id")

    @serving_endpoint_id.setter
    def serving_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "serving_endpoint_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingProvisionedThroughputTagArgs']]]]:
        """
        Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingProvisionedThroughputTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("databricks:index/modelServingProvisionedThroughput:ModelServingProvisionedThroughput")
class ModelServingProvisionedThroughput(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ai_gateway: Optional[pulumi.Input[Union['ModelServingProvisionedThroughputAiGatewayArgs', 'ModelServingProvisionedThroughputAiGatewayArgsDict']]] = None,
                 budget_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['ModelServingProvisionedThroughputConfigArgs', 'ModelServingProvisionedThroughputConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelServingProvisionedThroughputTagArgs', 'ModelServingProvisionedThroughputTagArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource allows you to manage [Foundation Model provisioned throughput](https://docs.databricks.com/aws/en/machine-learning/foundation-model-apis/deploy-prov-throughput-foundation-model-apis) endpoints in Databricks.

        > This resource is currently in private preview, and only available for enrolled customers.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        Creating a Foundation Model provisioned throughput endpoint

        ```python
        import pulumi
        import pulumi_databricks as databricks

        llama = databricks.ModelServingProvisionedThroughput("llama",
            ai_gateway={
                "usage_tracking_config": {
                    "enabled": True,
                },
            },
            config={
                "served_entities": [{
                    "entity_name": "system.ai.llama-4-maverick",
                    "entity_version": "1",
                    "provisioned_model_units": 100,
                }],
            })
        ```

        ## Access Control

        * Permissions can control which groups or individual users can *Manage*, *Query* or *View* individual serving endpoints.

        ## Related Resources

        The following resources are often used in the same context:

        * ModelServing to create custom and external serving endpoints in Databricks.
        * RegisteredModel to create [Models in Unity Catalog](https://docs.databricks.com/en/mlflow/models-in-uc.html) in Databricks.
        * End to end workspace management guide.
        * Directory to manage directories in [Databricks Workspace](https://docs.databricks.com/workspace/workspace-objects.html).
        * MlflowModel to create models in the [workspace model registry](https://docs.databricks.com/en/mlflow/model-registry.html) in Databricks.
        * Notebook to manage [Databricks Notebooks](https://docs.databricks.com/notebooks/index.html).
        * Notebook data to export a notebook from Databricks Workspace.
        * Repo to manage [Databricks Repos](https://docs.databricks.com/repos.html).

        ## Import

        The model serving provisioned throughput resource can be imported using the name of the endpoint:

        hcl

        import {

          to = databricks_model_serving_provisioned_throughput.this

          id = "<model-serving-endpoint-name>"

        }

        ```sh
        $ pulumi import databricks:index/modelServingProvisionedThroughput:ModelServingProvisionedThroughput Alternatively, when using Pulumi version 1.4 or earlier, import using the command:
        ```

        bash

        ```sh
        $ pulumi import databricks:index/modelServingProvisionedThroughput:ModelServingProvisionedThroughput this <model-serving-endpoint-name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ModelServingProvisionedThroughputAiGatewayArgs', 'ModelServingProvisionedThroughputAiGatewayArgsDict']] ai_gateway: A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        :param pulumi.Input[builtins.str] budget_policy_id: The Budget Policy ID set for this serving endpoint.
        :param pulumi.Input[Union['ModelServingProvisionedThroughputConfigArgs', 'ModelServingProvisionedThroughputConfigArgsDict']] config: The model serving endpoint configuration.
        :param pulumi.Input[builtins.str] name: The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelServingProvisionedThroughputTagArgs', 'ModelServingProvisionedThroughputTagArgsDict']]]] tags: Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelServingProvisionedThroughputArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage [Foundation Model provisioned throughput](https://docs.databricks.com/aws/en/machine-learning/foundation-model-apis/deploy-prov-throughput-foundation-model-apis) endpoints in Databricks.

        > This resource is currently in private preview, and only available for enrolled customers.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        Creating a Foundation Model provisioned throughput endpoint

        ```python
        import pulumi
        import pulumi_databricks as databricks

        llama = databricks.ModelServingProvisionedThroughput("llama",
            ai_gateway={
                "usage_tracking_config": {
                    "enabled": True,
                },
            },
            config={
                "served_entities": [{
                    "entity_name": "system.ai.llama-4-maverick",
                    "entity_version": "1",
                    "provisioned_model_units": 100,
                }],
            })
        ```

        ## Access Control

        * Permissions can control which groups or individual users can *Manage*, *Query* or *View* individual serving endpoints.

        ## Related Resources

        The following resources are often used in the same context:

        * ModelServing to create custom and external serving endpoints in Databricks.
        * RegisteredModel to create [Models in Unity Catalog](https://docs.databricks.com/en/mlflow/models-in-uc.html) in Databricks.
        * End to end workspace management guide.
        * Directory to manage directories in [Databricks Workspace](https://docs.databricks.com/workspace/workspace-objects.html).
        * MlflowModel to create models in the [workspace model registry](https://docs.databricks.com/en/mlflow/model-registry.html) in Databricks.
        * Notebook to manage [Databricks Notebooks](https://docs.databricks.com/notebooks/index.html).
        * Notebook data to export a notebook from Databricks Workspace.
        * Repo to manage [Databricks Repos](https://docs.databricks.com/repos.html).

        ## Import

        The model serving provisioned throughput resource can be imported using the name of the endpoint:

        hcl

        import {

          to = databricks_model_serving_provisioned_throughput.this

          id = "<model-serving-endpoint-name>"

        }

        ```sh
        $ pulumi import databricks:index/modelServingProvisionedThroughput:ModelServingProvisionedThroughput Alternatively, when using Pulumi version 1.4 or earlier, import using the command:
        ```

        bash

        ```sh
        $ pulumi import databricks:index/modelServingProvisionedThroughput:ModelServingProvisionedThroughput this <model-serving-endpoint-name>
        ```

        :param str resource_name: The name of the resource.
        :param ModelServingProvisionedThroughputArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelServingProvisionedThroughputArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ai_gateway: Optional[pulumi.Input[Union['ModelServingProvisionedThroughputAiGatewayArgs', 'ModelServingProvisionedThroughputAiGatewayArgsDict']]] = None,
                 budget_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['ModelServingProvisionedThroughputConfigArgs', 'ModelServingProvisionedThroughputConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelServingProvisionedThroughputTagArgs', 'ModelServingProvisionedThroughputTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelServingProvisionedThroughputArgs.__new__(ModelServingProvisionedThroughputArgs)

            __props__.__dict__["ai_gateway"] = ai_gateway
            __props__.__dict__["budget_policy_id"] = budget_policy_id
            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["serving_endpoint_id"] = None
        super(ModelServingProvisionedThroughput, __self__).__init__(
            'databricks:index/modelServingProvisionedThroughput:ModelServingProvisionedThroughput',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ai_gateway: Optional[pulumi.Input[Union['ModelServingProvisionedThroughputAiGatewayArgs', 'ModelServingProvisionedThroughputAiGatewayArgsDict']]] = None,
            budget_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            config: Optional[pulumi.Input[Union['ModelServingProvisionedThroughputConfigArgs', 'ModelServingProvisionedThroughputConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            serving_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelServingProvisionedThroughputTagArgs', 'ModelServingProvisionedThroughputTagArgsDict']]]]] = None) -> 'ModelServingProvisionedThroughput':
        """
        Get an existing ModelServingProvisionedThroughput resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ModelServingProvisionedThroughputAiGatewayArgs', 'ModelServingProvisionedThroughputAiGatewayArgsDict']] ai_gateway: A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        :param pulumi.Input[builtins.str] budget_policy_id: The Budget Policy ID set for this serving endpoint.
        :param pulumi.Input[Union['ModelServingProvisionedThroughputConfigArgs', 'ModelServingProvisionedThroughputConfigArgsDict']] config: The model serving endpoint configuration.
        :param pulumi.Input[builtins.str] name: The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        :param pulumi.Input[builtins.str] serving_endpoint_id: Unique identifier of the serving endpoint primarily used to set permissions and refer to this instance for other operations.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelServingProvisionedThroughputTagArgs', 'ModelServingProvisionedThroughputTagArgsDict']]]] tags: Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelServingProvisionedThroughputState.__new__(_ModelServingProvisionedThroughputState)

        __props__.__dict__["ai_gateway"] = ai_gateway
        __props__.__dict__["budget_policy_id"] = budget_policy_id
        __props__.__dict__["config"] = config
        __props__.__dict__["name"] = name
        __props__.__dict__["serving_endpoint_id"] = serving_endpoint_id
        __props__.__dict__["tags"] = tags
        return ModelServingProvisionedThroughput(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aiGateway")
    def ai_gateway(self) -> pulumi.Output[Optional['outputs.ModelServingProvisionedThroughputAiGateway']]:
        """
        A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        """
        return pulumi.get(self, "ai_gateway")

    @property
    @pulumi.getter(name="budgetPolicyId")
    def budget_policy_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Budget Policy ID set for this serving endpoint.
        """
        return pulumi.get(self, "budget_policy_id")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.ModelServingProvisionedThroughputConfig']:
        """
        The model serving endpoint configuration.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="servingEndpointId")
    def serving_endpoint_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the serving endpoint primarily used to set permissions and refer to this instance for other operations.
        """
        return pulumi.get(self, "serving_endpoint_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ModelServingProvisionedThroughputTag']]]:
        """
        Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        return pulumi.get(self, "tags")

