# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MwsCredentialsArgs', 'MwsCredentials']

@pulumi.input_type
class MwsCredentialsArgs:
    def __init__(__self__, *,
                 credentials_name: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[builtins.int]] = None,
                 credentials_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MwsCredentials resource.
        :param pulumi.Input[builtins.str] credentials_name: name of credentials to register
        :param pulumi.Input[builtins.str] role_arn: ARN of cross-account role
        :param pulumi.Input[builtins.str] account_id: **(Deprecated)** Maintained for backwards compatibility and will be removed in a later version. It should now be specified under a provider instance where `host = "https://accounts.cloud.databricks.com"`
        :param pulumi.Input[builtins.int] creation_time: (Integer) time of credentials registration
        :param pulumi.Input[builtins.str] credentials_id: (String) identifier of credentials
        """
        pulumi.set(__self__, "credentials_name", credentials_name)
        pulumi.set(__self__, "role_arn", role_arn)
        if account_id is not None:
            warnings.warn("""`account_id` should be set as part of the Databricks Config, not in the resource.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: `account_id` should be set as part of the Databricks Config, not in the resource.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if credentials_id is not None:
            pulumi.set(__self__, "credentials_id", credentials_id)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)

    @property
    @pulumi.getter(name="credentialsName")
    def credentials_name(self) -> pulumi.Input[builtins.str]:
        """
        name of credentials to register
        """
        return pulumi.get(self, "credentials_name")

    @credentials_name.setter
    def credentials_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "credentials_name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of cross-account role
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""`account_id` should be set as part of the Databricks Config, not in the resource.""")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        **(Deprecated)** Maintained for backwards compatibility and will be removed in a later version. It should now be specified under a provider instance where `host = "https://accounts.cloud.databricks.com"`
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Integer) time of credentials registration
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (String) identifier of credentials
        """
        return pulumi.get(self, "credentials_id")

    @credentials_id.setter
    def credentials_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credentials_id", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)


@pulumi.input_type
class _MwsCredentialsState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[builtins.int]] = None,
                 credentials_id: Optional[pulumi.Input[builtins.str]] = None,
                 credentials_name: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MwsCredentials resources.
        :param pulumi.Input[builtins.str] account_id: **(Deprecated)** Maintained for backwards compatibility and will be removed in a later version. It should now be specified under a provider instance where `host = "https://accounts.cloud.databricks.com"`
        :param pulumi.Input[builtins.int] creation_time: (Integer) time of credentials registration
        :param pulumi.Input[builtins.str] credentials_id: (String) identifier of credentials
        :param pulumi.Input[builtins.str] credentials_name: name of credentials to register
        :param pulumi.Input[builtins.str] role_arn: ARN of cross-account role
        """
        if account_id is not None:
            warnings.warn("""`account_id` should be set as part of the Databricks Config, not in the resource.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: `account_id` should be set as part of the Databricks Config, not in the resource.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if credentials_id is not None:
            pulumi.set(__self__, "credentials_id", credentials_id)
        if credentials_name is not None:
            pulumi.set(__self__, "credentials_name", credentials_name)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""`account_id` should be set as part of the Databricks Config, not in the resource.""")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        **(Deprecated)** Maintained for backwards compatibility and will be removed in a later version. It should now be specified under a provider instance where `host = "https://accounts.cloud.databricks.com"`
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Integer) time of credentials registration
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (String) identifier of credentials
        """
        return pulumi.get(self, "credentials_id")

    @credentials_id.setter
    def credentials_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credentials_id", value)

    @property
    @pulumi.getter(name="credentialsName")
    def credentials_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        name of credentials to register
        """
        return pulumi.get(self, "credentials_name")

    @credentials_name.setter
    def credentials_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credentials_name", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of cross-account role
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.type_token("databricks:index/mwsCredentials:MwsCredentials")
class MwsCredentials(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[builtins.int]] = None,
                 credentials_id: Optional[pulumi.Input[builtins.str]] = None,
                 credentials_name: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_databricks as databricks

        config = pulumi.Config()
        # Account Id that could be found in the top right corner of https://accounts.cloud.databricks.com/
        databricks_account_id = config.require_object("databricksAccountId")
        # Names of created resources will be prefixed with this value
        prefix = config.require_object("prefix")
        this = databricks.get_aws_assume_role_policy(external_id=databricks_account_id)
        cross_account_role = aws.iam.Role("cross_account_role",
            name=f"{prefix}-crossaccount",
            assume_role_policy=this.json,
            tags=tags)
        this_get_aws_cross_account_policy = databricks.get_aws_cross_account_policy()
        this_role_policy = aws.iam.RolePolicy("this",
            name=f"{prefix}-policy",
            role=cross_account_role.id,
            policy=this_get_aws_cross_account_policy.json)
        this_mws_credentials = databricks.MwsCredentials("this",
            credentials_name=f"{prefix}-creds",
            role_arn=cross_account_role.arn)
        ```

        ## Related Resources

        The following resources are used in the same context:

        * Provisioning Databricks on AWS guide.
        * MwsCustomerManagedKeys to configure KMS keys for new workspaces within AWS.
        * MwsLogDelivery to configure delivery of [billable usage logs](https://docs.databricks.com/administration-guide/account-settings/billable-usage-delivery.html) and [audit logs](https://docs.databricks.com/administration-guide/account-settings/audit-logs.html).
        * MwsNetworks to [configure VPC](https://docs.databricks.com/administration-guide/cloud-configurations/aws/customer-managed-vpc.html) & subnets for new workspaces within AWS.
        * MwsStorageConfigurations to configure root bucket new workspaces within AWS.
        * MwsWorkspaces to set up [AWS and GCP workspaces](https://docs.databricks.com/getting-started/overview.html#e2-architecture-1).

        ## Import

        This resource can be imported by the combination of its identifier and the account id:

        hcl

        import {

          to = databricks_mws_credentials.this

          id = "<account_id>/<credentials_id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/mwsCredentials:MwsCredentials this <account_id>/<credentials_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: **(Deprecated)** Maintained for backwards compatibility and will be removed in a later version. It should now be specified under a provider instance where `host = "https://accounts.cloud.databricks.com"`
        :param pulumi.Input[builtins.int] creation_time: (Integer) time of credentials registration
        :param pulumi.Input[builtins.str] credentials_id: (String) identifier of credentials
        :param pulumi.Input[builtins.str] credentials_name: name of credentials to register
        :param pulumi.Input[builtins.str] role_arn: ARN of cross-account role
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MwsCredentialsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_databricks as databricks

        config = pulumi.Config()
        # Account Id that could be found in the top right corner of https://accounts.cloud.databricks.com/
        databricks_account_id = config.require_object("databricksAccountId")
        # Names of created resources will be prefixed with this value
        prefix = config.require_object("prefix")
        this = databricks.get_aws_assume_role_policy(external_id=databricks_account_id)
        cross_account_role = aws.iam.Role("cross_account_role",
            name=f"{prefix}-crossaccount",
            assume_role_policy=this.json,
            tags=tags)
        this_get_aws_cross_account_policy = databricks.get_aws_cross_account_policy()
        this_role_policy = aws.iam.RolePolicy("this",
            name=f"{prefix}-policy",
            role=cross_account_role.id,
            policy=this_get_aws_cross_account_policy.json)
        this_mws_credentials = databricks.MwsCredentials("this",
            credentials_name=f"{prefix}-creds",
            role_arn=cross_account_role.arn)
        ```

        ## Related Resources

        The following resources are used in the same context:

        * Provisioning Databricks on AWS guide.
        * MwsCustomerManagedKeys to configure KMS keys for new workspaces within AWS.
        * MwsLogDelivery to configure delivery of [billable usage logs](https://docs.databricks.com/administration-guide/account-settings/billable-usage-delivery.html) and [audit logs](https://docs.databricks.com/administration-guide/account-settings/audit-logs.html).
        * MwsNetworks to [configure VPC](https://docs.databricks.com/administration-guide/cloud-configurations/aws/customer-managed-vpc.html) & subnets for new workspaces within AWS.
        * MwsStorageConfigurations to configure root bucket new workspaces within AWS.
        * MwsWorkspaces to set up [AWS and GCP workspaces](https://docs.databricks.com/getting-started/overview.html#e2-architecture-1).

        ## Import

        This resource can be imported by the combination of its identifier and the account id:

        hcl

        import {

          to = databricks_mws_credentials.this

          id = "<account_id>/<credentials_id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/mwsCredentials:MwsCredentials this <account_id>/<credentials_id>
        ```

        :param str resource_name: The name of the resource.
        :param MwsCredentialsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MwsCredentialsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[builtins.int]] = None,
                 credentials_id: Optional[pulumi.Input[builtins.str]] = None,
                 credentials_name: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MwsCredentialsArgs.__new__(MwsCredentialsArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["creation_time"] = creation_time
            __props__.__dict__["credentials_id"] = credentials_id
            if credentials_name is None and not opts.urn:
                raise TypeError("Missing required property 'credentials_name'")
            __props__.__dict__["credentials_name"] = credentials_name
            __props__.__dict__["external_id"] = external_id
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
        super(MwsCredentials, __self__).__init__(
            'databricks:index/mwsCredentials:MwsCredentials',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            creation_time: Optional[pulumi.Input[builtins.int]] = None,
            credentials_id: Optional[pulumi.Input[builtins.str]] = None,
            credentials_name: Optional[pulumi.Input[builtins.str]] = None,
            external_id: Optional[pulumi.Input[builtins.str]] = None,
            role_arn: Optional[pulumi.Input[builtins.str]] = None) -> 'MwsCredentials':
        """
        Get an existing MwsCredentials resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: **(Deprecated)** Maintained for backwards compatibility and will be removed in a later version. It should now be specified under a provider instance where `host = "https://accounts.cloud.databricks.com"`
        :param pulumi.Input[builtins.int] creation_time: (Integer) time of credentials registration
        :param pulumi.Input[builtins.str] credentials_id: (String) identifier of credentials
        :param pulumi.Input[builtins.str] credentials_name: name of credentials to register
        :param pulumi.Input[builtins.str] role_arn: ARN of cross-account role
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MwsCredentialsState.__new__(_MwsCredentialsState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["credentials_id"] = credentials_id
        __props__.__dict__["credentials_name"] = credentials_name
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["role_arn"] = role_arn
        return MwsCredentials(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""`account_id` should be set as part of the Databricks Config, not in the resource.""")
    def account_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        **(Deprecated)** Maintained for backwards compatibility and will be removed in a later version. It should now be specified under a provider instance where `host = "https://accounts.cloud.databricks.com"`
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.int]:
        """
        (Integer) time of credentials registration
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> pulumi.Output[builtins.str]:
        """
        (String) identifier of credentials
        """
        return pulumi.get(self, "credentials_id")

    @property
    @pulumi.getter(name="credentialsName")
    def credentials_name(self) -> pulumi.Output[builtins.str]:
        """
        name of credentials to register
        """
        return pulumi.get(self, "credentials_name")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of cross-account role
        """
        return pulumi.get(self, "role_arn")

