# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MwsNccBindingArgs', 'MwsNccBinding']

@pulumi.input_type
class MwsNccBindingArgs:
    def __init__(__self__, *,
                 network_connectivity_config_id: pulumi.Input[builtins.str],
                 workspace_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a MwsNccBinding resource.
        :param pulumi.Input[builtins.str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account.
        :param pulumi.Input[builtins.str] workspace_id: Identifier of the workspace to attach the NCC to. Change forces creation of a new resource.
        """
        pulumi.set(__self__, "network_connectivity_config_id", network_connectivity_config_id)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="networkConnectivityConfigId")
    def network_connectivity_config_id(self) -> pulumi.Input[builtins.str]:
        """
        Canonical unique identifier of Network Connectivity Config in Databricks Account.
        """
        return pulumi.get(self, "network_connectivity_config_id")

    @network_connectivity_config_id.setter
    def network_connectivity_config_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_connectivity_config_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the workspace to attach the NCC to. Change forces creation of a new resource.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _MwsNccBindingState:
    def __init__(__self__, *,
                 network_connectivity_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MwsNccBinding resources.
        :param pulumi.Input[builtins.str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account.
        :param pulumi.Input[builtins.str] workspace_id: Identifier of the workspace to attach the NCC to. Change forces creation of a new resource.
        """
        if network_connectivity_config_id is not None:
            pulumi.set(__self__, "network_connectivity_config_id", network_connectivity_config_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="networkConnectivityConfigId")
    def network_connectivity_config_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Canonical unique identifier of Network Connectivity Config in Databricks Account.
        """
        return pulumi.get(self, "network_connectivity_config_id")

    @network_connectivity_config_id.setter
    def network_connectivity_config_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_connectivity_config_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the workspace to attach the NCC to. Change forces creation of a new resource.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("databricks:index/mwsNccBinding:MwsNccBinding")
class MwsNccBinding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_connectivity_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Allows you to attach a Network Connectivity Config object to a MwsWorkspaces resource to create a [Databricks Workspace that leverages serverless network connectivity configs](https://learn.microsoft.com/en-us/azure/databricks/sql/admin/serverless-firewall).

        > This resource can only be used with an account-level provider!

        > This feature is available for AWS & Azure only, and is in [Public Preview](https://docs.databricks.com/release-notes/release-types.html) in AWS.

        The NCC and workspace must be in the same region.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        region = config.require_object("region")
        prefix = config.require_object("prefix")
        ncc = databricks.MwsNetworkConnectivityConfig("ncc",
            name=f"ncc-for-{prefix}",
            region=region)
        ncc_binding = databricks.MwsNccBinding("ncc_binding",
            network_connectivity_config_id=ncc.network_connectivity_config_id,
            workspace_id=databricks_workspace_id)
        ```

        ## Related Resources

        The following resources are used in the context:

        * MwsWorkspaces to set up Databricks workspaces.
        * MwsNetworkConnectivityConfig to create Network Connectivity Config objects.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account.
        :param pulumi.Input[builtins.str] workspace_id: Identifier of the workspace to attach the NCC to. Change forces creation of a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MwsNccBindingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows you to attach a Network Connectivity Config object to a MwsWorkspaces resource to create a [Databricks Workspace that leverages serverless network connectivity configs](https://learn.microsoft.com/en-us/azure/databricks/sql/admin/serverless-firewall).

        > This resource can only be used with an account-level provider!

        > This feature is available for AWS & Azure only, and is in [Public Preview](https://docs.databricks.com/release-notes/release-types.html) in AWS.

        The NCC and workspace must be in the same region.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        region = config.require_object("region")
        prefix = config.require_object("prefix")
        ncc = databricks.MwsNetworkConnectivityConfig("ncc",
            name=f"ncc-for-{prefix}",
            region=region)
        ncc_binding = databricks.MwsNccBinding("ncc_binding",
            network_connectivity_config_id=ncc.network_connectivity_config_id,
            workspace_id=databricks_workspace_id)
        ```

        ## Related Resources

        The following resources are used in the context:

        * MwsWorkspaces to set up Databricks workspaces.
        * MwsNetworkConnectivityConfig to create Network Connectivity Config objects.

        :param str resource_name: The name of the resource.
        :param MwsNccBindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MwsNccBindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_connectivity_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MwsNccBindingArgs.__new__(MwsNccBindingArgs)

            if network_connectivity_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_connectivity_config_id'")
            __props__.__dict__["network_connectivity_config_id"] = network_connectivity_config_id
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(MwsNccBinding, __self__).__init__(
            'databricks:index/mwsNccBinding:MwsNccBinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            network_connectivity_config_id: Optional[pulumi.Input[builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'MwsNccBinding':
        """
        Get an existing MwsNccBinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account.
        :param pulumi.Input[builtins.str] workspace_id: Identifier of the workspace to attach the NCC to. Change forces creation of a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MwsNccBindingState.__new__(_MwsNccBindingState)

        __props__.__dict__["network_connectivity_config_id"] = network_connectivity_config_id
        __props__.__dict__["workspace_id"] = workspace_id
        return MwsNccBinding(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="networkConnectivityConfigId")
    def network_connectivity_config_id(self) -> pulumi.Output[builtins.str]:
        """
        Canonical unique identifier of Network Connectivity Config in Databricks Account.
        """
        return pulumi.get(self, "network_connectivity_config_id")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of the workspace to attach the NCC to. Change forces creation of a new resource.
        """
        return pulumi.get(self, "workspace_id")

