# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MwsPermissionAssignmentArgs', 'MwsPermissionAssignment']

@pulumi.input_type
class MwsPermissionAssignmentArgs:
    def __init__(__self__, *,
                 permissions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 principal_id: pulumi.Input[builtins.str],
                 workspace_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a MwsPermissionAssignment resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions: The list of workspace permissions to assign to the principal:
               * `"USER"` - Can access the workspace with basic privileges.
               * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        :param pulumi.Input[builtins.str] principal_id: Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the SCIM API, or using databricks_user, ServicePrincipal or Group data sources.
        :param pulumi.Input[builtins.str] workspace_id: Databricks workspace ID.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of workspace permissions to assign to the principal:
        * `"USER"` - Can access the workspace with basic privileges.
        * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[builtins.str]:
        """
        Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the SCIM API, or using databricks_user, ServicePrincipal or Group data sources.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        Databricks workspace ID.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _MwsPermissionAssignmentState:
    def __init__(__self__, *,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MwsPermissionAssignment resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions: The list of workspace permissions to assign to the principal:
               * `"USER"` - Can access the workspace with basic privileges.
               * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        :param pulumi.Input[builtins.str] principal_id: Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the SCIM API, or using databricks_user, ServicePrincipal or Group data sources.
        :param pulumi.Input[builtins.str] workspace_id: Databricks workspace ID.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of workspace permissions to assign to the principal:
        * `"USER"` - Can access the workspace with basic privileges.
        * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the SCIM API, or using databricks_user, ServicePrincipal or Group data sources.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Databricks workspace ID.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("databricks:index/mwsPermissionAssignment:MwsPermissionAssignment")
class MwsPermissionAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource is used to assign account-level users, service principals and groups to a Databricks workspace.

        > This resource can only be used with an account-level provider!

        ## Example Usage

        In account context, adding account-level group to a workspace:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        data_eng = databricks.Group("data_eng", display_name="Data Engineering")
        add_admin_group = databricks.MwsPermissionAssignment("add_admin_group",
            workspace_id=this["workspaceId"],
            principal_id=data_eng.id,
            permissions=["ADMIN"])
        ```

        In account context, adding account-level user to a workspace:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.User("me", user_name="me@example.com")
        add_user = databricks.MwsPermissionAssignment("add_user",
            workspace_id=this["workspaceId"],
            principal_id=me.id,
            permissions=["USER"])
        ```

        In account context, adding account-level service principal to a workspace:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sp = databricks.ServicePrincipal("sp", display_name="Automation-only SP")
        add_admin_spn = databricks.MwsPermissionAssignment("add_admin_spn",
            workspace_id=this["workspaceId"],
            principal_id=sp.id,
            permissions=["ADMIN"])
        ```

        ## Related Resources

        The following resources are used in the same context:

        * Group to manage [groups in Databricks Workspace](https://docs.databricks.com/administration-guide/users-groups/groups.html) or [Account Console](https://accounts.cloud.databricks.com/) (for AWS deployments).
        * Group data to retrieve information about Group members, entitlements and instance profiles.
        * GroupMember to attach users and groups as group members.
        * PermissionAssignment to manage permission assignment from a workspace context

        ## Import

        The resource `databricks_mws_permission_assignment` can be imported using the workspace id and principal id

        hcl

        import {

          to = databricks_mws_permission_assignment.this

          id = "workspace_id|principal_id"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/mwsPermissionAssignment:MwsPermissionAssignment this "workspace_id|principal_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions: The list of workspace permissions to assign to the principal:
               * `"USER"` - Can access the workspace with basic privileges.
               * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        :param pulumi.Input[builtins.str] principal_id: Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the SCIM API, or using databricks_user, ServicePrincipal or Group data sources.
        :param pulumi.Input[builtins.str] workspace_id: Databricks workspace ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MwsPermissionAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource is used to assign account-level users, service principals and groups to a Databricks workspace.

        > This resource can only be used with an account-level provider!

        ## Example Usage

        In account context, adding account-level group to a workspace:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        data_eng = databricks.Group("data_eng", display_name="Data Engineering")
        add_admin_group = databricks.MwsPermissionAssignment("add_admin_group",
            workspace_id=this["workspaceId"],
            principal_id=data_eng.id,
            permissions=["ADMIN"])
        ```

        In account context, adding account-level user to a workspace:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.User("me", user_name="me@example.com")
        add_user = databricks.MwsPermissionAssignment("add_user",
            workspace_id=this["workspaceId"],
            principal_id=me.id,
            permissions=["USER"])
        ```

        In account context, adding account-level service principal to a workspace:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sp = databricks.ServicePrincipal("sp", display_name="Automation-only SP")
        add_admin_spn = databricks.MwsPermissionAssignment("add_admin_spn",
            workspace_id=this["workspaceId"],
            principal_id=sp.id,
            permissions=["ADMIN"])
        ```

        ## Related Resources

        The following resources are used in the same context:

        * Group to manage [groups in Databricks Workspace](https://docs.databricks.com/administration-guide/users-groups/groups.html) or [Account Console](https://accounts.cloud.databricks.com/) (for AWS deployments).
        * Group data to retrieve information about Group members, entitlements and instance profiles.
        * GroupMember to attach users and groups as group members.
        * PermissionAssignment to manage permission assignment from a workspace context

        ## Import

        The resource `databricks_mws_permission_assignment` can be imported using the workspace id and principal id

        hcl

        import {

          to = databricks_mws_permission_assignment.this

          id = "workspace_id|principal_id"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/mwsPermissionAssignment:MwsPermissionAssignment this "workspace_id|principal_id"
        ```

        :param str resource_name: The name of the resource.
        :param MwsPermissionAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MwsPermissionAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MwsPermissionAssignmentArgs.__new__(MwsPermissionAssignmentArgs)

            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(MwsPermissionAssignment, __self__).__init__(
            'databricks:index/mwsPermissionAssignment:MwsPermissionAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            principal_id: Optional[pulumi.Input[builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'MwsPermissionAssignment':
        """
        Get an existing MwsPermissionAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions: The list of workspace permissions to assign to the principal:
               * `"USER"` - Can access the workspace with basic privileges.
               * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        :param pulumi.Input[builtins.str] principal_id: Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the SCIM API, or using databricks_user, ServicePrincipal or Group data sources.
        :param pulumi.Input[builtins.str] workspace_id: Databricks workspace ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MwsPermissionAssignmentState.__new__(_MwsPermissionAssignmentState)

        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["workspace_id"] = workspace_id
        return MwsPermissionAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of workspace permissions to assign to the principal:
        * `"USER"` - Can access the workspace with basic privileges.
        * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[builtins.str]:
        """
        Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the SCIM API, or using databricks_user, ServicePrincipal or Group data sources.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        Databricks workspace ID.
        """
        return pulumi.get(self, "workspace_id")

