# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QualityMonitorV2Args', 'QualityMonitorV2']

@pulumi.input_type
class QualityMonitorV2Args:
    def __init__(__self__, *,
                 object_id: pulumi.Input[builtins.str],
                 object_type: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a QualityMonitorV2 resource.
        :param pulumi.Input[builtins.str] object_id: The uuid of the request object. For example, schema id
        :param pulumi.Input[builtins.str] object_type: The type of the monitored object. Can be one of the following: schema
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "object_type", object_type)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[builtins.str]:
        """
        The uuid of the request object. For example, schema id
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the monitored object. Can be one of the following: schema
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "object_type", value)


@pulumi.input_type
class _QualityMonitorV2State:
    def __init__(__self__, *,
                 anomaly_detection_config: Optional[pulumi.Input['QualityMonitorV2AnomalyDetectionConfigArgs']] = None,
                 object_id: Optional[pulumi.Input[builtins.str]] = None,
                 object_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering QualityMonitorV2 resources.
        :param pulumi.Input['QualityMonitorV2AnomalyDetectionConfigArgs'] anomaly_detection_config: (AnomalyDetectionConfig) -
        :param pulumi.Input[builtins.str] object_id: The uuid of the request object. For example, schema id
        :param pulumi.Input[builtins.str] object_type: The type of the monitored object. Can be one of the following: schema
        """
        if anomaly_detection_config is not None:
            pulumi.set(__self__, "anomaly_detection_config", anomaly_detection_config)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)

    @property
    @pulumi.getter(name="anomalyDetectionConfig")
    def anomaly_detection_config(self) -> Optional[pulumi.Input['QualityMonitorV2AnomalyDetectionConfigArgs']]:
        """
        (AnomalyDetectionConfig) -
        """
        return pulumi.get(self, "anomaly_detection_config")

    @anomaly_detection_config.setter
    def anomaly_detection_config(self, value: Optional[pulumi.Input['QualityMonitorV2AnomalyDetectionConfigArgs']]):
        pulumi.set(self, "anomaly_detection_config", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The uuid of the request object. For example, schema id
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the monitored object. Can be one of the following: schema
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_type", value)


@pulumi.type_token("databricks:index/qualityMonitorV2:QualityMonitorV2")
class QualityMonitorV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 object_id: Optional[pulumi.Input[builtins.str]] = None,
                 object_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Users with MANAGE Schema can use quality monitor v2 to set up data quality monitoring checks for UC objects, currently support schema.

        > **Note** This resource can only be used with an workspace-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.Schema("this",
            catalog_name="my_catalog",
            name="my_schema")
        this_quality_monitor_v2 = databricks.QualityMonitorV2("this",
            object_type="schema",
            object_id=this.schema_id)
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = object_type,object_id

          to = databricks_quality_monitor_v2.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/qualityMonitorV2:QualityMonitorV2 databricks_quality_monitor_v2 object_type,object_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] object_id: The uuid of the request object. For example, schema id
        :param pulumi.Input[builtins.str] object_type: The type of the monitored object. Can be one of the following: schema
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QualityMonitorV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Users with MANAGE Schema can use quality monitor v2 to set up data quality monitoring checks for UC objects, currently support schema.

        > **Note** This resource can only be used with an workspace-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.Schema("this",
            catalog_name="my_catalog",
            name="my_schema")
        this_quality_monitor_v2 = databricks.QualityMonitorV2("this",
            object_type="schema",
            object_id=this.schema_id)
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = object_type,object_id

          to = databricks_quality_monitor_v2.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/qualityMonitorV2:QualityMonitorV2 databricks_quality_monitor_v2 object_type,object_id
        ```

        :param str resource_name: The name of the resource.
        :param QualityMonitorV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QualityMonitorV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 object_id: Optional[pulumi.Input[builtins.str]] = None,
                 object_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QualityMonitorV2Args.__new__(QualityMonitorV2Args)

            if object_id is None and not opts.urn:
                raise TypeError("Missing required property 'object_id'")
            __props__.__dict__["object_id"] = object_id
            if object_type is None and not opts.urn:
                raise TypeError("Missing required property 'object_type'")
            __props__.__dict__["object_type"] = object_type
            __props__.__dict__["anomaly_detection_config"] = None
        super(QualityMonitorV2, __self__).__init__(
            'databricks:index/qualityMonitorV2:QualityMonitorV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            anomaly_detection_config: Optional[pulumi.Input[Union['QualityMonitorV2AnomalyDetectionConfigArgs', 'QualityMonitorV2AnomalyDetectionConfigArgsDict']]] = None,
            object_id: Optional[pulumi.Input[builtins.str]] = None,
            object_type: Optional[pulumi.Input[builtins.str]] = None) -> 'QualityMonitorV2':
        """
        Get an existing QualityMonitorV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['QualityMonitorV2AnomalyDetectionConfigArgs', 'QualityMonitorV2AnomalyDetectionConfigArgsDict']] anomaly_detection_config: (AnomalyDetectionConfig) -
        :param pulumi.Input[builtins.str] object_id: The uuid of the request object. For example, schema id
        :param pulumi.Input[builtins.str] object_type: The type of the monitored object. Can be one of the following: schema
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QualityMonitorV2State.__new__(_QualityMonitorV2State)

        __props__.__dict__["anomaly_detection_config"] = anomaly_detection_config
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["object_type"] = object_type
        return QualityMonitorV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="anomalyDetectionConfig")
    def anomaly_detection_config(self) -> pulumi.Output['outputs.QualityMonitorV2AnomalyDetectionConfig']:
        """
        (AnomalyDetectionConfig) -
        """
        return pulumi.get(self, "anomaly_detection_config")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[builtins.str]:
        """
        The uuid of the request object. For example, schema id
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the monitored object. Can be one of the following: schema
        """
        return pulumi.get(self, "object_type")

