# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QueryArgs', 'Query']

@pulumi.input_type
class QueryArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 query_text: pulumi.Input[builtins.str],
                 warehouse_id: pulumi.Input[builtins.str],
                 apply_auto_limit: Optional[pulumi.Input[builtins.bool]] = None,
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 owner_user_name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterArgs']]]] = None,
                 parent_path: Optional[pulumi.Input[builtins.str]] = None,
                 run_as_mode: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Query resource.
        :param pulumi.Input[builtins.str] display_name: Name of the query.
        :param pulumi.Input[builtins.str] query_text: Text of SQL query.
        :param pulumi.Input[builtins.str] warehouse_id: ID of a SQL warehouse which will be used to execute this query.
        :param pulumi.Input[builtins.bool] apply_auto_limit: Whether to apply a 1000 row limit to the query result.
        :param pulumi.Input[builtins.str] catalog: Name of the catalog where this query will be executed.
        :param pulumi.Input[builtins.str] description: General description that conveys additional information about this query such as usage notes.
        :param pulumi.Input[builtins.str] owner_user_name: Query owner's username.
        :param pulumi.Input[Sequence[pulumi.Input['QueryParameterArgs']]] parameters: Query parameter definition.  Consists of following attributes (one of `*_value` is required):
        :param pulumi.Input[builtins.str] parent_path: The path to a workspace folder containing the query. The default is the user's home folder.  If changed, the query will be recreated.
        :param pulumi.Input[builtins.str] run_as_mode: Sets the "Run as" role for the object.  Should be one of `OWNER`, `VIEWER`.
        :param pulumi.Input[builtins.str] schema: Name of the schema where this query will be executed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags that will be added to the query.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "query_text", query_text)
        pulumi.set(__self__, "warehouse_id", warehouse_id)
        if apply_auto_limit is not None:
            pulumi.set(__self__, "apply_auto_limit", apply_auto_limit)
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if owner_user_name is not None:
            pulumi.set(__self__, "owner_user_name", owner_user_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if parent_path is not None:
            pulumi.set(__self__, "parent_path", parent_path)
        if run_as_mode is not None:
            pulumi.set(__self__, "run_as_mode", run_as_mode)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the query.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="queryText")
    def query_text(self) -> pulumi.Input[builtins.str]:
        """
        Text of SQL query.
        """
        return pulumi.get(self, "query_text")

    @query_text.setter
    def query_text(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "query_text", value)

    @property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of a SQL warehouse which will be used to execute this query.
        """
        return pulumi.get(self, "warehouse_id")

    @warehouse_id.setter
    def warehouse_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "warehouse_id", value)

    @property
    @pulumi.getter(name="applyAutoLimit")
    def apply_auto_limit(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to apply a 1000 row limit to the query result.
        """
        return pulumi.get(self, "apply_auto_limit")

    @apply_auto_limit.setter
    def apply_auto_limit(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "apply_auto_limit", value)

    @property
    @pulumi.getter
    def catalog(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the catalog where this query will be executed.
        """
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        General description that conveys additional information about this query such as usage notes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Query owner's username.
        """
        return pulumi.get(self, "owner_user_name")

    @owner_user_name.setter
    def owner_user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_user_name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterArgs']]]]:
        """
        Query parameter definition.  Consists of following attributes (one of `*_value` is required):
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="parentPath")
    def parent_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to a workspace folder containing the query. The default is the user's home folder.  If changed, the query will be recreated.
        """
        return pulumi.get(self, "parent_path")

    @parent_path.setter
    def parent_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_path", value)

    @property
    @pulumi.getter(name="runAsMode")
    def run_as_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the "Run as" role for the object.  Should be one of `OWNER`, `VIEWER`.
        """
        return pulumi.get(self, "run_as_mode")

    @run_as_mode.setter
    def run_as_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "run_as_mode", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the schema where this query will be executed.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags that will be added to the query.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _QueryState:
    def __init__(__self__, *,
                 apply_auto_limit: Optional[pulumi.Input[builtins.bool]] = None,
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_modifier_user_name: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_state: Optional[pulumi.Input[builtins.str]] = None,
                 owner_user_name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterArgs']]]] = None,
                 parent_path: Optional[pulumi.Input[builtins.str]] = None,
                 query_text: Optional[pulumi.Input[builtins.str]] = None,
                 run_as_mode: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 warehouse_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Query resources.
        :param pulumi.Input[builtins.bool] apply_auto_limit: Whether to apply a 1000 row limit to the query result.
        :param pulumi.Input[builtins.str] catalog: Name of the catalog where this query will be executed.
        :param pulumi.Input[builtins.str] create_time: The timestamp string indicating when the query was created.
        :param pulumi.Input[builtins.str] description: General description that conveys additional information about this query such as usage notes.
        :param pulumi.Input[builtins.str] display_name: Name of the query.
        :param pulumi.Input[builtins.str] last_modifier_user_name: Username of the user who last saved changes to this query.
        :param pulumi.Input[builtins.str] lifecycle_state: The workspace state of the query. Used for tracking trashed status. (Possible values are `ACTIVE` or `TRASHED`).
        :param pulumi.Input[builtins.str] owner_user_name: Query owner's username.
        :param pulumi.Input[Sequence[pulumi.Input['QueryParameterArgs']]] parameters: Query parameter definition.  Consists of following attributes (one of `*_value` is required):
        :param pulumi.Input[builtins.str] parent_path: The path to a workspace folder containing the query. The default is the user's home folder.  If changed, the query will be recreated.
        :param pulumi.Input[builtins.str] query_text: Text of SQL query.
        :param pulumi.Input[builtins.str] run_as_mode: Sets the "Run as" role for the object.  Should be one of `OWNER`, `VIEWER`.
        :param pulumi.Input[builtins.str] schema: Name of the schema where this query will be executed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags that will be added to the query.
        :param pulumi.Input[builtins.str] update_time: The timestamp string indicating when the query was updated.
        :param pulumi.Input[builtins.str] warehouse_id: ID of a SQL warehouse which will be used to execute this query.
        """
        if apply_auto_limit is not None:
            pulumi.set(__self__, "apply_auto_limit", apply_auto_limit)
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if last_modifier_user_name is not None:
            pulumi.set(__self__, "last_modifier_user_name", last_modifier_user_name)
        if lifecycle_state is not None:
            pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        if owner_user_name is not None:
            pulumi.set(__self__, "owner_user_name", owner_user_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if parent_path is not None:
            pulumi.set(__self__, "parent_path", parent_path)
        if query_text is not None:
            pulumi.set(__self__, "query_text", query_text)
        if run_as_mode is not None:
            pulumi.set(__self__, "run_as_mode", run_as_mode)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if warehouse_id is not None:
            pulumi.set(__self__, "warehouse_id", warehouse_id)

    @property
    @pulumi.getter(name="applyAutoLimit")
    def apply_auto_limit(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to apply a 1000 row limit to the query result.
        """
        return pulumi.get(self, "apply_auto_limit")

    @apply_auto_limit.setter
    def apply_auto_limit(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "apply_auto_limit", value)

    @property
    @pulumi.getter
    def catalog(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the catalog where this query will be executed.
        """
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp string indicating when the query was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        General description that conveys additional information about this query such as usage notes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the query.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="lastModifierUserName")
    def last_modifier_user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username of the user who last saved changes to this query.
        """
        return pulumi.get(self, "last_modifier_user_name")

    @last_modifier_user_name.setter
    def last_modifier_user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modifier_user_name", value)

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The workspace state of the query. Used for tracking trashed status. (Possible values are `ACTIVE` or `TRASHED`).
        """
        return pulumi.get(self, "lifecycle_state")

    @lifecycle_state.setter
    def lifecycle_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_state", value)

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Query owner's username.
        """
        return pulumi.get(self, "owner_user_name")

    @owner_user_name.setter
    def owner_user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_user_name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterArgs']]]]:
        """
        Query parameter definition.  Consists of following attributes (one of `*_value` is required):
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="parentPath")
    def parent_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to a workspace folder containing the query. The default is the user's home folder.  If changed, the query will be recreated.
        """
        return pulumi.get(self, "parent_path")

    @parent_path.setter
    def parent_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_path", value)

    @property
    @pulumi.getter(name="queryText")
    def query_text(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Text of SQL query.
        """
        return pulumi.get(self, "query_text")

    @query_text.setter
    def query_text(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query_text", value)

    @property
    @pulumi.getter(name="runAsMode")
    def run_as_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the "Run as" role for the object.  Should be one of `OWNER`, `VIEWER`.
        """
        return pulumi.get(self, "run_as_mode")

    @run_as_mode.setter
    def run_as_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "run_as_mode", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the schema where this query will be executed.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags that will be added to the query.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp string indicating when the query was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of a SQL warehouse which will be used to execute this query.
        """
        return pulumi.get(self, "warehouse_id")

    @warehouse_id.setter
    def warehouse_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "warehouse_id", value)


@pulumi.type_token("databricks:index/query:Query")
class Query(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_auto_limit: Optional[pulumi.Input[builtins.bool]] = None,
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 owner_user_name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueryParameterArgs', 'QueryParameterArgsDict']]]]] = None,
                 parent_path: Optional[pulumi.Input[builtins.str]] = None,
                 query_text: Optional[pulumi.Input[builtins.str]] = None,
                 run_as_mode: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 warehouse_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        This resource can be imported using query ID:

        hcl

        import {

          to = databricks_query.this

          id = "<query-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/query:Query this <query-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] apply_auto_limit: Whether to apply a 1000 row limit to the query result.
        :param pulumi.Input[builtins.str] catalog: Name of the catalog where this query will be executed.
        :param pulumi.Input[builtins.str] description: General description that conveys additional information about this query such as usage notes.
        :param pulumi.Input[builtins.str] display_name: Name of the query.
        :param pulumi.Input[builtins.str] owner_user_name: Query owner's username.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QueryParameterArgs', 'QueryParameterArgsDict']]]] parameters: Query parameter definition.  Consists of following attributes (one of `*_value` is required):
        :param pulumi.Input[builtins.str] parent_path: The path to a workspace folder containing the query. The default is the user's home folder.  If changed, the query will be recreated.
        :param pulumi.Input[builtins.str] query_text: Text of SQL query.
        :param pulumi.Input[builtins.str] run_as_mode: Sets the "Run as" role for the object.  Should be one of `OWNER`, `VIEWER`.
        :param pulumi.Input[builtins.str] schema: Name of the schema where this query will be executed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags that will be added to the query.
        :param pulumi.Input[builtins.str] warehouse_id: ID of a SQL warehouse which will be used to execute this query.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        This resource can be imported using query ID:

        hcl

        import {

          to = databricks_query.this

          id = "<query-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/query:Query this <query-id>
        ```

        :param str resource_name: The name of the resource.
        :param QueryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_auto_limit: Optional[pulumi.Input[builtins.bool]] = None,
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 owner_user_name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueryParameterArgs', 'QueryParameterArgsDict']]]]] = None,
                 parent_path: Optional[pulumi.Input[builtins.str]] = None,
                 query_text: Optional[pulumi.Input[builtins.str]] = None,
                 run_as_mode: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 warehouse_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueryArgs.__new__(QueryArgs)

            __props__.__dict__["apply_auto_limit"] = apply_auto_limit
            __props__.__dict__["catalog"] = catalog
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["owner_user_name"] = owner_user_name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["parent_path"] = parent_path
            if query_text is None and not opts.urn:
                raise TypeError("Missing required property 'query_text'")
            __props__.__dict__["query_text"] = query_text
            __props__.__dict__["run_as_mode"] = run_as_mode
            __props__.__dict__["schema"] = schema
            __props__.__dict__["tags"] = tags
            if warehouse_id is None and not opts.urn:
                raise TypeError("Missing required property 'warehouse_id'")
            __props__.__dict__["warehouse_id"] = warehouse_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["last_modifier_user_name"] = None
            __props__.__dict__["lifecycle_state"] = None
            __props__.__dict__["update_time"] = None
        super(Query, __self__).__init__(
            'databricks:index/query:Query',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_auto_limit: Optional[pulumi.Input[builtins.bool]] = None,
            catalog: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            last_modifier_user_name: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_state: Optional[pulumi.Input[builtins.str]] = None,
            owner_user_name: Optional[pulumi.Input[builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueryParameterArgs', 'QueryParameterArgsDict']]]]] = None,
            parent_path: Optional[pulumi.Input[builtins.str]] = None,
            query_text: Optional[pulumi.Input[builtins.str]] = None,
            run_as_mode: Optional[pulumi.Input[builtins.str]] = None,
            schema: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            warehouse_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Query':
        """
        Get an existing Query resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] apply_auto_limit: Whether to apply a 1000 row limit to the query result.
        :param pulumi.Input[builtins.str] catalog: Name of the catalog where this query will be executed.
        :param pulumi.Input[builtins.str] create_time: The timestamp string indicating when the query was created.
        :param pulumi.Input[builtins.str] description: General description that conveys additional information about this query such as usage notes.
        :param pulumi.Input[builtins.str] display_name: Name of the query.
        :param pulumi.Input[builtins.str] last_modifier_user_name: Username of the user who last saved changes to this query.
        :param pulumi.Input[builtins.str] lifecycle_state: The workspace state of the query. Used for tracking trashed status. (Possible values are `ACTIVE` or `TRASHED`).
        :param pulumi.Input[builtins.str] owner_user_name: Query owner's username.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QueryParameterArgs', 'QueryParameterArgsDict']]]] parameters: Query parameter definition.  Consists of following attributes (one of `*_value` is required):
        :param pulumi.Input[builtins.str] parent_path: The path to a workspace folder containing the query. The default is the user's home folder.  If changed, the query will be recreated.
        :param pulumi.Input[builtins.str] query_text: Text of SQL query.
        :param pulumi.Input[builtins.str] run_as_mode: Sets the "Run as" role for the object.  Should be one of `OWNER`, `VIEWER`.
        :param pulumi.Input[builtins.str] schema: Name of the schema where this query will be executed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags that will be added to the query.
        :param pulumi.Input[builtins.str] update_time: The timestamp string indicating when the query was updated.
        :param pulumi.Input[builtins.str] warehouse_id: ID of a SQL warehouse which will be used to execute this query.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QueryState.__new__(_QueryState)

        __props__.__dict__["apply_auto_limit"] = apply_auto_limit
        __props__.__dict__["catalog"] = catalog
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["last_modifier_user_name"] = last_modifier_user_name
        __props__.__dict__["lifecycle_state"] = lifecycle_state
        __props__.__dict__["owner_user_name"] = owner_user_name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["parent_path"] = parent_path
        __props__.__dict__["query_text"] = query_text
        __props__.__dict__["run_as_mode"] = run_as_mode
        __props__.__dict__["schema"] = schema
        __props__.__dict__["tags"] = tags
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["warehouse_id"] = warehouse_id
        return Query(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applyAutoLimit")
    def apply_auto_limit(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to apply a 1000 row limit to the query result.
        """
        return pulumi.get(self, "apply_auto_limit")

    @property
    @pulumi.getter
    def catalog(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the catalog where this query will be executed.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp string indicating when the query was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        General description that conveys additional information about this query such as usage notes.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the query.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="lastModifierUserName")
    def last_modifier_user_name(self) -> pulumi.Output[builtins.str]:
        """
        Username of the user who last saved changes to this query.
        """
        return pulumi.get(self, "last_modifier_user_name")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> pulumi.Output[builtins.str]:
        """
        The workspace state of the query. Used for tracking trashed status. (Possible values are `ACTIVE` or `TRASHED`).
        """
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Query owner's username.
        """
        return pulumi.get(self, "owner_user_name")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.QueryParameter']]]:
        """
        Query parameter definition.  Consists of following attributes (one of `*_value` is required):
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="parentPath")
    def parent_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The path to a workspace folder containing the query. The default is the user's home folder.  If changed, the query will be recreated.
        """
        return pulumi.get(self, "parent_path")

    @property
    @pulumi.getter(name="queryText")
    def query_text(self) -> pulumi.Output[builtins.str]:
        """
        Text of SQL query.
        """
        return pulumi.get(self, "query_text")

    @property
    @pulumi.getter(name="runAsMode")
    def run_as_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Sets the "Run as" role for the object.  Should be one of `OWNER`, `VIEWER`.
        """
        return pulumi.get(self, "run_as_mode")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the schema where this query will be executed.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Tags that will be added to the query.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp string indicating when the query was updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of a SQL warehouse which will be used to execute this query.
        """
        return pulumi.get(self, "warehouse_id")

